-- MySQL dump 10.13  Distrib 5.7.33, for Linux (x86_64)
--
-- Host: localhost    Database: magento237sd
-- ------------------------------------------------------
-- Server version	5.7.33

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `[[dbprefix]]admin_analytics_usage_version_log`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_analytics_usage_version_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]admin_analytics_usage_version_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Log ID',
  `last_viewed_in_version` varchar(50) NOT NULL COMMENT 'Viewer last viewed on product version',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[DBPREFIX]]ADMIN_ANALYTICS_USAGE_VERSION_LOG_LAST_VIEWED_IN_VERSION` (`last_viewed_in_version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin Notification Viewer Log Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_analytics_usage_version_log`
--

LOCK TABLES `[[dbprefix]]admin_analytics_usage_version_log` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_analytics_usage_version_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]admin_analytics_usage_version_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_passwords`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_passwords`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]admin_passwords` (
  `password_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Password ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `password_hash` varchar(255) DEFAULT NULL COMMENT 'Password Hash',
  `expires` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Deprecated',
  `last_updated` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Last Updated',
  PRIMARY KEY (`password_id`),
  KEY `[[DBPREFIX]]ADMIN_PASSWORDS_USER_ID` (`user_id`),
  CONSTRAINT `[[DBPREFIX]]ADMIN_PASSWORDS_USER_ID_[[DBPREFIX]]ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Admin Passwords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_passwords`
--

LOCK TABLES `[[dbprefix]]admin_passwords` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_passwords` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]admin_passwords` VALUES (1,1,'[[admin_pass]]',0,[[timestamp]]);
/*!40000 ALTER TABLE `[[dbprefix]]admin_passwords` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_system_messages`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_system_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]admin_system_messages` (
  `identity` varchar(100) NOT NULL COMMENT 'Message ID',
  `severity` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  PRIMARY KEY (`identity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin System Messages';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_system_messages`
--

LOCK TABLES `[[dbprefix]]admin_system_messages` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_system_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]admin_system_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_user`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]admin_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'User ID',
  `firstname` varchar(32) DEFAULT NULL COMMENT 'User First Name',
  `lastname` varchar(32) DEFAULT NULL COMMENT 'User Last Name',
  `email` varchar(128) DEFAULT NULL COMMENT 'User Email',
  `username` varchar(40) DEFAULT NULL COMMENT 'User Login',
  `password` varchar(255) NOT NULL COMMENT 'User Password',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'User Created Time',
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'User Modified Time',
  `logdate` timestamp NULL DEFAULT NULL COMMENT 'User Last Login Time',
  `lognum` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'User Login Number',
  `reload_acl_flag` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Reload ACL',
  `is_active` smallint(6) NOT NULL DEFAULT '1' COMMENT 'User Is Active',
  `extra` text COMMENT 'User Extra Data',
  `rp_token` text COMMENT 'Reset Password Link Token',
  `rp_token_created_at` timestamp NULL DEFAULT NULL COMMENT 'Reset Password Link Token Creation Date',
  `interface_locale` varchar(16) NOT NULL DEFAULT 'en_US' COMMENT 'Backend interface locale',
  `failures_num` smallint(6) DEFAULT '0' COMMENT 'Failure Number',
  `first_failure` timestamp NULL DEFAULT NULL COMMENT 'First Failure',
  `lock_expires` timestamp NULL DEFAULT NULL COMMENT 'Expiration Lock Dates',
  `refresh_token` text COMMENT 'Email connector refresh token',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `[[DBPREFIX]]ADMIN_USER_USERNAME` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Admin User Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_user`
--

LOCK TABLES `[[dbprefix]]admin_user` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_user` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]admin_user` VALUES (1,'[[admin_fname]]','[[admin_lname]]','[[admin_email]]','[[admin_username]]','[[admin_pass]]','[[regtime]]','[[regtime]]',NULL,0,0,1,NULL,NULL,NULL,'en_US',0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `[[dbprefix]]admin_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]admin_user_session`
--

DROP TABLE IF EXISTS `[[dbprefix]]admin_user_session`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]admin_user_session` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `session_id` varchar(128) NOT NULL COMMENT 'Session ID value',
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Admin User ID',
  `status` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Current Session status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `ip` varchar(15) NOT NULL COMMENT 'Remote user IP',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADMIN_USER_SESSION_SESSION_ID` (`session_id`),
  KEY `[[DBPREFIX]]ADMIN_USER_SESSION_USER_ID` (`user_id`),
  CONSTRAINT `[[DBPREFIX]]ADMIN_USER_SESSION_USER_ID_[[DBPREFIX]]ADMIN_USER_USER_ID` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin User sessions table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]admin_user_session`
--

LOCK TABLES `[[dbprefix]]admin_user_session` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]admin_user_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]admin_user_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adminnotification_inbox`
--

DROP TABLE IF EXISTS `[[dbprefix]]adminnotification_inbox`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]adminnotification_inbox` (
  `notification_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Notification ID',
  `severity` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  `title` varchar(255) NOT NULL COMMENT 'Title',
  `description` text COMMENT 'Description',
  `url` varchar(255) DEFAULT NULL COMMENT 'Url',
  `is_read` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification read',
  `is_remove` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification might be removed',
  PRIMARY KEY (`notification_id`),
  KEY `[[DBPREFIX]]ADMINNOTIFICATION_INBOX_SEVERITY` (`severity`),
  KEY `[[DBPREFIX]]ADMINNOTIFICATION_INBOX_IS_READ` (`is_read`),
  KEY `[[DBPREFIX]]ADMINNOTIFICATION_INBOX_IS_REMOVE` (`is_remove`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='Adminnotification Inbox';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adminnotification_inbox`
--

LOCK TABLES `[[dbprefix]]adminnotification_inbox` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adminnotification_inbox` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]adminnotification_inbox` VALUES (1,4,'[[regtime]]','Deprecation Notice','Catalog Search is currently configured to use the MySQL engine, which has been deprecated. Consider migrating to one of\nthe Elasticsearch engines now to ensure there are no service interruptions during your next upgrade.','',0,0),(2,4,'[[regtime]]','Disable Notice','To improve performance, collecting statistics for the Magento Report module is disabled by default. \nYou can enable it in System Config.','',0,0);
/*!40000 ALTER TABLE `[[dbprefix]]adminnotification_inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adobe_stock_asset`
--

DROP TABLE IF EXISTS `[[dbprefix]]adobe_stock_asset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]adobe_stock_asset` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `media_gallery_id` int(10) unsigned DEFAULT NULL COMMENT 'Media gallery ID',
  `category_id` int(10) unsigned DEFAULT NULL COMMENT 'Category ID',
  `creator_id` int(10) unsigned DEFAULT NULL COMMENT 'Creator ID',
  `is_licensed` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Licensed',
  `creation_date` varchar(255) DEFAULT NULL COMMENT 'Creation Date',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_ASSET_MDA_GLR_ID_[[DBPREFIX]]MDA_GLR_ASSET_ID` (`media_gallery_id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_ASSET_ID` (`id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_ASSET_CATEGORY_ID` (`category_id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_ASSET_CREATOR_ID` (`creator_id`),
  CONSTRAINT `[[DBPREFIX]]ADOBE_STOCK_ASSET_CATEGORY_ID_[[DBPREFIX]]ADOBE_STOCK_CATEGORY_ID` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]adobe_stock_category` (`id`) ON DELETE SET NULL,
  CONSTRAINT `[[DBPREFIX]]ADOBE_STOCK_ASSET_CREATOR_ID_[[DBPREFIX]]ADOBE_STOCK_CREATOR_ID` FOREIGN KEY (`creator_id`) REFERENCES `[[dbprefix]]adobe_stock_creator` (`id`) ON DELETE SET NULL,
  CONSTRAINT `[[DBPREFIX]]ADOBE_STOCK_ASSET_MDA_GLR_ID_[[DBPREFIX]]MDA_GLR_ASSET_ID` FOREIGN KEY (`media_gallery_id`) REFERENCES `[[dbprefix]]media_gallery_asset` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Asset';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adobe_stock_asset`
--

LOCK TABLES `[[dbprefix]]adobe_stock_asset` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_asset` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_asset` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adobe_stock_category`
--

DROP TABLE IF EXISTS `[[dbprefix]]adobe_stock_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]adobe_stock_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Name',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_CATEGORY_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Category';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adobe_stock_category`
--

LOCK TABLES `[[dbprefix]]adobe_stock_category` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adobe_stock_creator`
--

DROP TABLE IF EXISTS `[[dbprefix]]adobe_stock_creator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]adobe_stock_creator` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) DEFAULT NULL COMMENT 'Asset creator''s name',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADOBE_STOCK_CREATOR_ID` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe Stock Creator';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adobe_stock_creator`
--

LOCK TABLES `[[dbprefix]]adobe_stock_creator` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_creator` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_stock_creator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]adobe_user_profile`
--

DROP TABLE IF EXISTS `[[dbprefix]]adobe_user_profile`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]adobe_user_profile` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `admin_user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Admin User Id',
  `name` varchar(255) NOT NULL COMMENT 'Display Name',
  `email` varchar(255) NOT NULL COMMENT 'user profile email',
  `image` varchar(255) NOT NULL COMMENT 'user profile avatar',
  `account_type` varchar(255) DEFAULT NULL COMMENT 'Account Type',
  `access_token` text COMMENT 'Access Token',
  `refresh_token` text COMMENT 'Refresh Token',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created At',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Updated At',
  `access_token_expires_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Access Token Expires At',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]ADOBE_USER_PROFILE_ADMIN_USER_ID_[[DBPREFIX]]ADMIN_USER_USER_ID` (`admin_user_id`),
  KEY `[[DBPREFIX]]ADOBE_USER_PROFILE_ID` (`id`),
  CONSTRAINT `[[DBPREFIX]]ADOBE_USER_PROFILE_ADMIN_USER_ID_[[DBPREFIX]]ADMIN_USER_USER_ID` FOREIGN KEY (`admin_user_id`) REFERENCES `[[dbprefix]]admin_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Adobe IMS User Profile';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]adobe_user_profile`
--

LOCK TABLES `[[dbprefix]]adobe_user_profile` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_user_profile` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]adobe_user_profile` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]amazon_customer`
--

DROP TABLE IF EXISTS `[[dbprefix]]amazon_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]amazon_customer` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `customer_id` int(10) unsigned NOT NULL COMMENT 'Customer_id',
  `amazon_id` varchar(255) NOT NULL COMMENT 'Amazon_id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `[[DBPREFIX]]AMAZON_CUSTOMER_CUSTOMER_ID_AMAZON_ID` (`customer_id`,`amazon_id`),
  UNIQUE KEY `[[DBPREFIX]]AMAZON_CUSTOMER_CUSTOMER_ID` (`customer_id`),
  CONSTRAINT `[[DBPREFIX]]AMAZON_CUSTOMER_CUSTOMER_ID_[[DBPREFIX]]CUSTOMER_ENTITY_ENTITY_ID` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]customer_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='[[dbprefix]]amazon_customer';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]amazon_customer`
--

LOCK TABLES `[[dbprefix]]amazon_customer` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]amazon_customer` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]amazon_customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]amazon_pending_authorization`
--

DROP TABLE IF EXISTS `[[dbprefix]]amazon_pending_authorization`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]amazon_pending_authorization` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `order_id` int(10) unsigned NOT NULL COMMENT 'Order_id',
  `payment_id` int(10) unsigned NOT NULL COMMENT 'Payment_id',
  `authorization_id` varchar(255) DEFAULT NULL COMMENT 'Authorization_id',
  `created_at` datetime NOT NULL COMMENT 'Created_at',
  `updated_at` datetime DEFAULT NULL COMMENT 'Updated_at',
  `processed` smallint(5) unsigned DEFAULT '0' COMMENT 'Initial authorization processed',
  `capture` smallint(5) unsigned DEFAULT '0' COMMENT 'Initial authorization has capture',
  `capture_id` varchar(255) DEFAULT NULL COMMENT 'Initial authorization capture id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `UNQ_7865C57877864BE1B3D60FB8224FEF3E` (`order_id`,`payment_id`,`authorization_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='[[dbprefix]]amazon_pending_authorization';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]amazon_pending_authorization`
--

LOCK TABLES `[[dbprefix]]amazon_pending_authorization` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]amazon_pending_authorization` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]amazon_pending_authorization` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]amazon_pending_capture`
--

DROP TABLE IF EXISTS `[[dbprefix]]amazon_pending_capture`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]amazon_pending_capture` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `capture_id` varchar(255) NOT NULL COMMENT 'Capture_id',
  `created_at` datetime NOT NULL COMMENT 'Created_at',
  `order_id` int(10) unsigned NOT NULL COMMENT 'order id',
  `payment_id` int(10) unsigned NOT NULL COMMENT 'payment id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `[[DBPREFIX]]AMAZON_PENDING_CAPTURE_ORDER_ID_PAYMENT_ID_CAPTURE_ID` (`order_id`,`payment_id`,`capture_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='[[dbprefix]]amazon_pending_capture';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]amazon_pending_capture`
--

LOCK TABLES `[[dbprefix]]amazon_pending_capture` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]amazon_pending_capture` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]amazon_pending_capture` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]amazon_pending_refund`
--

DROP TABLE IF EXISTS `[[dbprefix]]amazon_pending_refund`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]amazon_pending_refund` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity_id',
  `refund_id` varchar(255) NOT NULL COMMENT 'Refund_id',
  `created_at` datetime NOT NULL COMMENT 'Created_at',
  `order_id` int(10) unsigned NOT NULL COMMENT 'Order_id',
  `payment_id` int(10) unsigned NOT NULL COMMENT 'Payment_id',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `[[DBPREFIX]]AMAZON_PENDING_REFUND_ORDER_ID_PAYMENT_ID_REFUND_ID` (`order_id`,`payment_id`,`refund_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='[[dbprefix]]amazon_pending_refund';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]amazon_pending_refund`
--

LOCK TABLES `[[dbprefix]]amazon_pending_refund` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]amazon_pending_refund` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]amazon_pending_refund` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]amazon_quote`
--

DROP TABLE IF EXISTS `[[dbprefix]]amazon_quote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]amazon_quote` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `quote_id` int(10) unsigned NOT NULL COMMENT 'Quote ID',
  `amazon_order_reference_id` varchar(255) NOT NULL COMMENT 'Amazon Order Reference ID',
  `sandbox_simulation_reference` varchar(255) DEFAULT NULL COMMENT 'Sandbox simulation reference',
  `confirmed` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Quote confirmed with Amazon',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `[[DBPREFIX]]AMAZON_QUOTE_QUOTE_ID` (`quote_id`),
  CONSTRAINT `[[DBPREFIX]]AMAZON_QUOTE_QUOTE_ID_[[DBPREFIX]]QUOTE_ENTITY_ID` FOREIGN KEY (`quote_id`) REFERENCES `[[dbprefix]]quote` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_quote';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]amazon_quote`
--

LOCK TABLES `[[dbprefix]]amazon_quote` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]amazon_quote` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]amazon_quote` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]amazon_sales_order`
--

DROP TABLE IF EXISTS `[[dbprefix]]amazon_sales_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]amazon_sales_order` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `order_id` int(10) unsigned NOT NULL COMMENT 'Order ID',
  `amazon_order_reference_id` varchar(255) NOT NULL COMMENT 'Amazon Order Reference ID',
  PRIMARY KEY (`entity_id`),
  UNIQUE KEY `[[DBPREFIX]]AMAZON_SALES_ORDER_ORDER_ID` (`order_id`),
  CONSTRAINT `[[DBPREFIX]]AMAZON_SALES_ORDER_ORDER_ID_[[DBPREFIX]]SALES_ORDER_ENTITY_ID` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]sales_order` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='amazon_sales_order';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]amazon_sales_order`
--

LOCK TABLES `[[dbprefix]]amazon_sales_order` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]amazon_sales_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]amazon_sales_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]authorization_role`
--

DROP TABLE IF EXISTS `[[dbprefix]]authorization_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]authorization_role` (
  `role_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Role ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Role ID',
  `tree_level` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Role Tree Level',
  `sort_order` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Role Sort Order',
  `role_type` varchar(1) NOT NULL DEFAULT '0' COMMENT 'Role Type',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `user_type` varchar(16) DEFAULT NULL COMMENT 'User Type',
  `role_name` varchar(50) DEFAULT NULL COMMENT 'Role Name',
  PRIMARY KEY (`role_id`),
  KEY `[[DBPREFIX]]AUTHORIZATION_ROLE_PARENT_ID_SORT_ORDER` (`parent_id`,`sort_order`),
  KEY `[[DBPREFIX]]AUTHORIZATION_ROLE_TREE_LEVEL` (`tree_level`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='Admin Role Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]authorization_role`
--

LOCK TABLES `[[dbprefix]]authorization_role` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]authorization_role` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]authorization_role` VALUES (1,0,1,1,'G',0,'2','Administrators'),(2,1,2,0,'U',1,'2','[[admin_username]]');
/*!40000 ALTER TABLE `[[dbprefix]]authorization_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]authorization_rule`
--

DROP TABLE IF EXISTS `[[dbprefix]]authorization_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]authorization_rule` (
  `rule_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule ID',
  `role_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Role ID',
  `resource_id` varchar(255) DEFAULT NULL COMMENT 'Resource ID',
  `privileges` varchar(20) DEFAULT NULL COMMENT 'Privileges',
  `permission` varchar(10) DEFAULT NULL COMMENT 'Permission',
  PRIMARY KEY (`rule_id`),
  KEY `[[DBPREFIX]]AUTHORIZATION_RULE_RESOURCE_ID_ROLE_ID` (`resource_id`,`role_id`),
  KEY `[[DBPREFIX]]AUTHORIZATION_RULE_ROLE_ID_RESOURCE_ID` (`role_id`,`resource_id`),
  CONSTRAINT `[[DBPREFIX]]AUTHORIZATION_RULE_ROLE_ID_[[DBPREFIX]]AUTHORIZATION_ROLE_ROLE_ID` FOREIGN KEY (`role_id`) REFERENCES `[[dbprefix]]authorization_role` (`role_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Admin Rule Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]authorization_rule`
--

LOCK TABLES `[[dbprefix]]authorization_rule` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]authorization_rule` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]authorization_rule` VALUES (1,1,'Magento_Backend::all',NULL,'allow');
/*!40000 ALTER TABLE `[[dbprefix]]authorization_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]cache`
--

DROP TABLE IF EXISTS `[[dbprefix]]cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]cache` (
  `id` varchar(200) NOT NULL COMMENT 'Cache Id',
  `data` mediumblob COMMENT 'Cache Data',
  `create_time` int(11) DEFAULT NULL COMMENT 'Cache Creation Time',
  `update_time` int(11) DEFAULT NULL COMMENT 'Time of Cache Updating',
  `expire_time` int(11) DEFAULT NULL COMMENT 'Cache Expiration Time',
  PRIMARY KEY (`id`),
  KEY `[[DBPREFIX]]CACHE_EXPIRE_TIME` (`expire_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]cache`
--

LOCK TABLES `[[dbprefix]]cache` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]cache_tag`
--

DROP TABLE IF EXISTS `[[dbprefix]]cache_tag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]cache_tag` (
  `tag` varchar(100) NOT NULL COMMENT 'Tag',
  `cache_id` varchar(200) NOT NULL COMMENT 'Cache Id',
  PRIMARY KEY (`tag`,`cache_id`),
  KEY `[[DBPREFIX]]CACHE_TAG_CACHE_ID` (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tag Caches';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]cache_tag`
--

LOCK TABLES `[[dbprefix]]cache_tag` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]cache_tag` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]cache_tag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]captcha_log`
--

DROP TABLE IF EXISTS `[[dbprefix]]captcha_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]captcha_log` (
  `type` varchar(32) NOT NULL COMMENT 'Type',
  `value` varchar(255) NOT NULL COMMENT 'Value',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Count',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  PRIMARY KEY (`type`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Count Login Attempts';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]captcha_log`
--

LOCK TABLES `[[dbprefix]]captcha_log` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]captcha_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]captcha_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Category ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `path` varchar(255) NOT NULL COMMENT 'Tree Path',
  `position` int(11) NOT NULL COMMENT 'Position',
  `level` int(11) NOT NULL DEFAULT '0' COMMENT 'Tree Level',
  `children_count` int(11) NOT NULL COMMENT 'Child Count',
  PRIMARY KEY (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_LEVEL` (`level`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_PATH` (`path`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_entity` VALUES (1,3,0,'[[regtime]]','[[regtime]]','1',0,0,39),(2,3,1,'[[regtime]]','[[regtime]]','1/2',1,1,38),(3,3,2,'[[regtime]]','[[regtime]]','1/2/3',4,2,3),(4,3,3,'[[regtime]]','[[regtime]]','1/2/3/4',1,3,0),(5,3,3,'[[regtime]]','[[regtime]]','1/2/3/5',2,3,0),(6,3,3,'[[regtime]]','[[regtime]]','1/2/3/6',3,3,0),(7,3,2,'[[regtime]]','[[regtime]]','1/2/7',5,2,6),(8,3,7,'[[regtime]]','[[regtime]]','1/2/7/8',1,3,0),(9,3,2,'[[regtime]]','[[regtime]]','1/2/9',5,2,1),(10,3,9,'[[regtime]]','[[regtime]]','1/2/9/10',1,3,0),(11,3,2,'[[regtime]]','[[regtime]]','1/2/11',3,2,8),(12,3,11,'[[regtime]]','[[regtime]]','1/2/11/12',1,3,4),(13,3,11,'[[regtime]]','[[regtime]]','1/2/11/13',2,3,2),(14,3,12,'[[regtime]]','[[regtime]]','1/2/11/12/14',1,4,0),(15,3,12,'[[regtime]]','[[regtime]]','1/2/11/12/15',2,4,0),(16,3,12,'[[regtime]]','[[regtime]]','1/2/11/12/16',3,4,0),(17,3,12,'[[regtime]]','[[regtime]]','1/2/11/12/17',4,4,0),(18,3,13,'[[regtime]]','[[regtime]]','1/2/11/13/18',1,4,0),(19,3,13,'[[regtime]]','[[regtime]]','1/2/11/13/19',2,4,0),(20,3,2,'[[regtime]]','[[regtime]]','1/2/20',2,2,8),(21,3,20,'[[regtime]]','[[regtime]]','1/2/20/21',1,3,4),(22,3,20,'[[regtime]]','[[regtime]]','1/2/20/22',2,3,2),(23,3,21,'[[regtime]]','[[regtime]]','1/2/20/21/23',1,4,0),(24,3,21,'[[regtime]]','[[regtime]]','1/2/20/21/24',2,4,0),(25,3,21,'[[regtime]]','[[regtime]]','1/2/20/21/25',3,4,0),(26,3,21,'[[regtime]]','[[regtime]]','1/2/20/21/26',4,4,0),(27,3,22,'[[regtime]]','[[regtime]]','1/2/20/22/27',1,4,0),(28,3,22,'[[regtime]]','[[regtime]]','1/2/20/22/28',2,4,0),(29,3,2,'[[regtime]]','[[regtime]]','1/2/29',6,2,4),(30,3,29,'[[regtime]]','[[regtime]]','1/2/29/30',1,3,0),(31,3,29,'[[regtime]]','[[regtime]]','1/2/29/31',2,3,0),(32,3,29,'[[regtime]]','[[regtime]]','1/2/29/32',3,3,0),(33,3,29,'[[regtime]]','[[regtime]]','1/2/29/33',4,3,0),(34,3,7,'[[regtime]]','[[regtime]]','1/2/7/34',2,3,0),(35,3,7,'[[regtime]]','[[regtime]]','1/2/7/35',3,3,0),(36,3,7,'[[regtime]]','[[regtime]]','1/2/7/36',4,3,0),(37,3,2,'[[regtime]]','[[regtime]]','1/2/37',6,2,0),(38,3,2,'[[regtime]]','[[regtime]]','1/2/38',1,2,0),(39,3,7,'[[regtime]]','[[regtime]]','1/2/7/39',5,3,0),(40,3,7,'[[regtime]]','[[regtime]]','1/2/7/40',6,3,0);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_datetime`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_datetime` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_CTGR_ENTT_DTIME_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DTIME_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DTIME_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DTIME_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_datetime`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_datetime` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_datetime` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_decimal`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_decimal` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_CTGR_ENTT_DEC_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DEC_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DEC_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_DEC_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_decimal`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_decimal` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_decimal` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_int`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_int` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int(11) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_INT_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_INT_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_INT_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=118 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_int`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_int` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_int` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_entity_int` VALUES (1,69,0,1,1),(2,46,0,2,1),(3,69,0,2,1),(4,46,0,3,1),(5,54,0,3,0),(6,69,0,3,1),(7,46,0,4,1),(8,54,0,4,1),(9,69,0,4,1),(10,46,0,5,1),(11,54,0,5,1),(12,69,0,5,1),(13,46,0,6,1),(14,54,0,6,1),(15,69,0,6,1),(16,46,0,7,0),(17,54,0,7,0),(18,69,0,7,0),(19,46,0,8,1),(20,54,0,8,1),(21,69,0,8,0),(22,46,0,9,1),(23,54,0,9,0),(24,69,0,9,1),(25,46,0,10,1),(26,54,0,10,1),(27,69,0,10,1),(28,46,0,11,1),(29,54,0,11,0),(30,69,0,11,1),(31,46,0,12,1),(32,54,0,12,1),(33,69,0,12,1),(34,46,0,13,1),(35,54,0,13,1),(36,69,0,13,1),(37,46,0,14,1),(38,54,0,14,1),(39,69,0,14,1),(40,46,0,15,1),(41,54,0,15,1),(42,69,0,15,1),(43,46,0,16,1),(44,54,0,16,1),(45,69,0,16,1),(46,46,0,17,1),(47,54,0,17,1),(48,69,0,17,1),(49,46,0,18,1),(50,54,0,18,1),(51,69,0,18,1),(52,46,0,19,1),(53,54,0,19,1),(54,69,0,19,1),(55,46,0,20,1),(56,54,0,20,0),(57,69,0,20,1),(58,46,0,21,1),(59,54,0,21,1),(60,69,0,21,1),(61,46,0,22,1),(62,54,0,22,1),(63,69,0,22,1),(64,46,0,23,1),(65,54,0,23,1),(66,69,0,23,1),(67,46,0,24,1),(68,54,0,24,1),(69,69,0,24,1),(70,46,0,25,1),(71,54,0,25,1),(72,69,0,25,1),(73,46,0,26,1),(74,54,0,26,1),(75,69,0,26,1),(76,46,0,27,1),(77,54,0,27,1),(78,69,0,27,1),(79,46,0,28,1),(80,54,0,28,1),(81,69,0,28,1),(82,46,0,29,0),(83,54,0,29,0),(84,69,0,29,0),(85,46,0,30,1),(86,54,0,30,1),(87,69,0,30,0),(88,46,0,31,1),(89,54,0,31,1),(90,69,0,31,0),(91,46,0,32,1),(92,54,0,32,1),(93,69,0,32,0),(94,46,0,33,1),(95,54,0,33,1),(96,69,0,33,0),(97,46,0,34,1),(98,54,0,34,1),(99,69,0,34,0),(100,46,0,35,1),(101,54,0,35,1),(102,69,0,35,0),(103,46,0,36,1),(104,54,0,36,1),(105,69,0,36,0),(106,46,0,37,1),(107,54,0,37,0),(108,69,0,37,1),(109,46,0,38,1),(110,54,0,38,0),(111,69,0,38,1),(112,46,0,39,1),(113,54,0,39,0),(114,69,0,39,0),(115,46,0,40,1),(116,54,0,40,0),(117,69,0,40,0);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_text`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_text` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` text COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_CTGR_ENTT_TEXT_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_TEXT_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_TEXT_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_text`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_text` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_text` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_entity_varchar`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_entity_varchar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_category_entity_varchar` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_CTGR_ENTT_VCHR_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_VCHR_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_VCHR_ENTT_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_ENTT_VCHR_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=130 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Varchar Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_entity_varchar`
--

LOCK TABLES `[[dbprefix]]catalog_category_entity_varchar` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_varchar` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_entity_varchar` VALUES (1,45,0,1,'Root Catalog'),(2,45,0,2,'Default Category'),(3,52,0,2,'PRODUCTS'),(4,45,0,3,'Gear'),(5,52,0,3,'PAGE'),(6,126,0,3,'gear'),(7,127,0,3,'gear'),(8,45,0,4,'Bags'),(9,126,0,4,'bags'),(10,127,0,4,'gear/bags'),(11,45,0,5,'Fitness Equipment'),(12,126,0,5,'fitness-equipment'),(13,127,0,5,'gear/fitness-equipment'),(14,45,0,6,'Watches'),(15,126,0,6,'watches'),(16,127,0,6,'gear/watches'),(17,45,0,7,'Collections'),(18,52,0,7,'PAGE'),(19,126,0,7,'collections'),(20,127,0,7,'collections'),(21,45,0,8,'New Luma Yoga Collection'),(22,126,0,8,'yoga-new'),(23,127,0,8,'collections/yoga-new'),(24,45,0,9,'Training'),(25,52,0,9,'PAGE'),(26,126,0,9,'training'),(27,127,0,9,'training'),(28,45,0,10,'Video Download'),(29,126,0,10,'training-video'),(30,127,0,10,'training/training-video'),(31,45,0,11,'Men'),(32,52,0,11,'PAGE'),(33,126,0,11,'men'),(34,127,0,11,'men'),(35,45,0,12,'Tops'),(36,126,0,12,'tops-men'),(37,127,0,12,'men/tops-men'),(38,45,0,13,'Bottoms'),(39,126,0,13,'bottoms-men'),(40,127,0,13,'men/bottoms-men'),(41,45,0,14,'Jackets'),(42,126,0,14,'jackets-men'),(43,127,0,14,'men/tops-men/jackets-men'),(44,45,0,15,'Hoodies & Sweatshirts'),(45,126,0,15,'hoodies-and-sweatshirts-men'),(46,127,0,15,'men/tops-men/hoodies-and-sweatshirts-men'),(47,45,0,16,'Tees'),(48,126,0,16,'tees-men'),(49,127,0,16,'men/tops-men/tees-men'),(50,45,0,17,'Tanks'),(51,126,0,17,'tanks-men'),(52,127,0,17,'men/tops-men/tanks-men'),(53,45,0,18,'Pants'),(54,126,0,18,'pants-men'),(55,127,0,18,'men/bottoms-men/pants-men'),(56,45,0,19,'Shorts'),(57,126,0,19,'shorts-men'),(58,127,0,19,'men/bottoms-men/shorts-men'),(59,45,0,20,'Women'),(60,52,0,20,'PAGE'),(61,126,0,20,'women'),(62,127,0,20,'women'),(63,45,0,21,'Tops'),(64,126,0,21,'tops-women'),(65,127,0,21,'women/tops-women'),(66,45,0,22,'Bottoms'),(67,126,0,22,'bottoms-women'),(68,127,0,22,'women/bottoms-women'),(69,45,0,23,'Jackets'),(70,126,0,23,'jackets-women'),(71,127,0,23,'women/tops-women/jackets-women'),(72,45,0,24,'Hoodies & Sweatshirts'),(73,126,0,24,'hoodies-and-sweatshirts-women'),(74,127,0,24,'women/tops-women/hoodies-and-sweatshirts-women'),(75,45,0,25,'Tees'),(76,126,0,25,'tees-women'),(77,127,0,25,'women/tops-women/tees-women'),(78,45,0,26,'Bras & Tanks'),(79,126,0,26,'tanks-women'),(80,127,0,26,'women/tops-women/tanks-women'),(81,45,0,27,'Pants'),(82,126,0,27,'pants-women'),(83,127,0,27,'women/bottoms-women/pants-women'),(84,45,0,28,'Shorts'),(85,126,0,28,'shorts-women'),(86,127,0,28,'women/bottoms-women/shorts-women'),(87,45,0,29,'Promotions'),(88,52,0,29,'PAGE'),(89,126,0,29,'promotions'),(90,127,0,29,'promotions'),(91,45,0,30,'Women Sale'),(92,126,0,30,'women-sale'),(93,127,0,30,'promotions/women-sale'),(94,45,0,31,'Men Sale'),(95,126,0,31,'men-sale'),(96,127,0,31,'promotions/men-sale'),(97,45,0,32,'Pants'),(98,126,0,32,'pants-all'),(99,127,0,32,'promotions/pants-all'),(100,45,0,33,'Tees'),(101,126,0,33,'tees-all'),(102,127,0,33,'promotions/tees-all'),(103,45,0,34,'Erin Recommends'),(104,126,0,34,'erin-recommends'),(105,127,0,34,'collections/erin-recommends'),(106,45,0,35,'Performance Fabrics'),(107,126,0,35,'performance-fabrics'),(108,127,0,35,'collections/performance-fabrics'),(109,45,0,36,'Eco Friendly'),(110,126,0,36,'eco-friendly'),(111,127,0,36,'collections/eco-friendly'),(112,45,0,37,'Sale'),(113,52,0,37,'PAGE'),(114,126,0,37,'sale'),(115,127,0,37,'sale'),(116,45,0,38,'What\'s New'),(117,52,0,38,'PAGE'),(118,126,0,38,'what-is-new'),(119,127,0,38,'what-is-new'),(120,45,0,39,'Performance Sportswear New'),(121,52,0,39,'PAGE'),(122,63,0,39,'1column'),(123,126,0,39,'performance-new'),(124,127,0,39,'collections/performance-new'),(125,45,0,40,'Eco Collection New'),(126,52,0,40,'PAGE'),(127,63,0,40,'1column'),(128,126,0,40,'eco-new'),(129,127,0,40,'collections/eco-new');
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_category_product` (
  `entity_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`entity_id`,`category_id`,`product_id`),
  UNIQUE KEY `[[DBPREFIX]]CATALOG_CATEGORY_PRODUCT_CATEGORY_ID_PRODUCT_ID` (`category_id`,`product_id`),
  KEY `[[DBPREFIX]]CATALOG_CATEGORY_PRODUCT_PRODUCT_ID` (`product_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_PRD_CTGR_ID_[[DBPREFIX]]CAT_CTGR_ENTT_ENTT_ID` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]catalog_category_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CTGR_PRD_PRD_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5178 DEFAULT CHARSET=utf8 COMMENT='Catalog Product To Category Linkage Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product`
--

LOCK TABLES `[[dbprefix]]catalog_category_product` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_product` VALUES (1,3,1,0),(2,4,1,0),(3,3,2,0),(4,7,2,0),(5,4,2,0),(6,3,3,0),(7,4,3,0),(8,3,4,0),(9,7,4,0),(10,4,4,0),(11,8,4,0),(12,3,5,0),(13,7,5,0),(14,4,5,0),(15,8,5,0),(16,3,6,0),(17,4,6,0),(18,3,7,0),(19,4,7,0),(20,3,8,0),(21,4,8,0),(22,3,9,0),(23,4,9,0),(24,3,10,0),(25,7,10,0),(26,4,10,0),(27,3,11,0),(28,7,11,0),(29,4,11,0),(30,3,12,0),(31,4,12,0),(32,3,13,0),(33,7,13,0),(34,4,13,0),(35,8,13,0),(36,3,14,0),(37,7,14,0),(38,4,14,0),(39,3,15,0),(40,5,15,0),(41,3,16,0),(42,7,16,0),(43,5,16,0),(44,3,17,0),(45,5,17,0),(46,3,18,0),(47,5,18,0),(48,3,19,0),(49,7,19,0),(50,5,19,0),(51,8,19,0),(52,3,20,0),(53,5,20,0),(54,3,21,0),(55,5,21,0),(56,3,22,0),(57,5,22,0),(58,3,23,0),(59,5,23,0),(60,3,24,0),(61,5,24,0),(62,3,25,0),(63,5,25,0),(64,3,26,0),(65,5,26,0),(66,3,27,0),(67,5,27,0),(68,3,28,0),(69,5,28,0),(70,3,29,0),(71,5,29,0),(72,3,30,0),(73,5,30,0),(74,3,31,0),(75,5,31,0),(76,3,32,0),(77,5,32,0),(78,3,33,0),(79,5,33,0),(80,3,34,0),(81,5,34,0),(82,3,35,0),(83,5,35,0),(84,3,36,0),(85,6,36,0),(86,3,37,0),(87,6,37,0),(88,3,38,0),(89,7,38,0),(90,6,38,0),(91,8,38,0),(92,3,39,0),(93,7,39,0),(94,6,39,0),(95,8,39,0),(96,3,40,0),(97,7,40,0),(98,6,40,0),(99,8,40,0),(100,3,41,0),(101,6,41,0),(102,3,42,0),(103,6,42,0),(104,3,43,0),(105,6,43,0),(106,3,44,0),(107,7,44,0),(108,6,44,0),(109,8,44,0),(110,3,45,0),(111,5,45,0),(112,3,46,0),(113,5,46,0),(114,9,47,0),(115,10,47,0),(116,9,48,0),(117,10,48,0),(118,9,49,0),(119,10,49,0),(120,9,50,0),(121,10,50,0),(122,9,51,0),(123,10,51,0),(124,9,52,0),(125,10,52,0),(126,15,53,0),(127,36,53,0),(128,2,53,0),(129,15,54,0),(130,36,54,0),(131,2,54,0),(132,15,55,0),(133,36,55,0),(134,2,55,0),(135,15,56,0),(136,36,56,0),(137,2,56,0),(138,15,57,0),(139,36,57,0),(140,2,57,0),(141,15,58,0),(142,36,58,0),(143,2,58,0),(144,15,59,0),(145,36,59,0),(146,2,59,0),(147,15,60,0),(148,36,60,0),(149,2,60,0),(150,15,61,0),(151,36,61,0),(152,2,61,0),(153,15,62,0),(154,36,62,0),(155,2,62,0),(156,15,63,0),(157,36,63,0),(158,2,63,0),(159,15,64,0),(160,36,64,0),(161,2,64,0),(162,15,65,0),(163,36,65,0),(164,2,65,0),(165,15,66,0),(166,36,66,0),(167,2,66,0),(168,15,67,0),(169,36,67,0),(170,2,67,0),(171,15,68,0),(172,36,68,0),(173,2,68,0),(174,15,69,0),(175,15,70,0),(176,15,71,0),(177,15,72,0),(178,15,73,0),(179,15,74,0),(180,15,75,0),(181,15,76,0),(182,15,77,0),(183,15,78,0),(184,15,79,0),(185,15,80,0),(186,15,81,0),(187,15,82,0),(188,15,83,0),(189,15,84,0),(190,15,85,0),(191,36,85,0),(192,2,85,0),(193,15,86,0),(194,36,86,0),(195,2,86,0),(196,15,87,0),(197,36,87,0),(198,2,87,0),(199,15,88,0),(200,36,88,0),(201,2,88,0),(202,15,89,0),(203,36,89,0),(204,2,89,0),(205,15,90,0),(206,36,90,0),(207,2,90,0),(208,15,91,0),(209,36,91,0),(210,2,91,0),(211,15,92,0),(212,36,92,0),(213,2,92,0),(214,15,93,0),(215,36,93,0),(216,2,93,0),(217,15,94,0),(218,36,94,0),(219,2,94,0),(220,15,95,0),(221,36,95,0),(222,2,95,0),(223,15,96,0),(224,36,96,0),(225,2,96,0),(226,15,97,0),(227,36,97,0),(228,2,97,0),(229,15,98,0),(230,36,98,0),(231,2,98,0),(232,15,99,0),(233,36,99,0),(234,2,99,0),(235,15,100,0),(236,36,100,0),(237,2,100,0),(238,15,101,0),(239,36,101,0),(240,2,101,0),(241,15,102,0),(242,36,102,0),(243,2,102,0),(244,15,103,0),(245,36,103,0),(246,2,103,0),(247,15,104,0),(248,36,104,0),(249,2,104,0),(250,15,105,0),(251,36,105,0),(252,2,105,0),(253,15,106,0),(254,36,106,0),(255,2,106,0),(256,15,107,0),(257,36,107,0),(258,2,107,0),(259,15,108,0),(260,36,108,0),(261,2,108,0),(262,15,109,0),(263,36,109,0),(264,2,109,0),(265,15,110,0),(266,36,110,0),(267,2,110,0),(268,15,111,0),(269,36,111,0),(270,2,111,0),(271,15,112,0),(272,36,112,0),(273,2,112,0),(274,15,113,0),(275,36,113,0),(276,2,113,0),(277,15,114,0),(278,36,114,0),(279,2,114,0),(280,15,115,0),(281,36,115,0),(282,2,115,0),(283,15,116,0),(284,36,116,0),(285,2,116,0),(286,15,117,0),(287,15,118,0),(288,15,119,0),(289,15,120,0),(290,15,121,0),(291,15,122,0),(292,15,123,0),(293,15,124,0),(294,15,125,0),(295,15,126,0),(296,15,127,0),(297,15,128,0),(298,15,129,0),(299,15,130,0),(300,15,131,0),(301,15,132,0),(302,15,133,0),(303,15,134,0),(304,15,135,0),(305,15,136,0),(306,15,137,0),(307,15,138,0),(308,15,139,0),(309,15,140,0),(310,15,141,0),(311,15,142,0),(312,15,143,0),(313,15,144,0),(314,15,145,0),(315,15,146,0),(316,15,147,0),(317,15,148,0),(318,15,149,0),(319,15,150,0),(320,15,151,0),(321,15,152,0),(322,15,153,0),(323,15,154,0),(324,15,155,0),(325,15,156,0),(326,15,157,0),(327,15,158,0),(328,15,159,0),(329,15,160,0),(330,15,161,0),(331,15,162,0),(332,15,163,0),(333,15,164,0),(334,15,165,0),(335,15,166,0),(336,15,167,0),(337,15,168,0),(338,15,169,0),(339,15,170,0),(340,15,171,0),(341,15,172,0),(342,15,173,0),(343,15,174,0),(344,15,175,0),(345,15,176,0),(346,15,177,0),(347,15,178,0),(348,15,179,0),(349,15,180,0),(350,15,181,0),(351,15,182,0),(352,15,183,0),(353,15,184,0),(354,15,185,0),(355,15,186,0),(356,15,187,0),(357,15,188,0),(358,15,189,0),(359,15,190,0),(360,15,191,0),(361,15,192,0),(362,15,193,0),(363,15,194,0),(364,15,195,0),(365,15,196,0),(366,15,197,0),(367,15,198,0),(368,15,199,0),(369,15,200,0),(370,15,201,0),(371,15,202,0),(372,15,203,0),(373,15,204,0),(374,15,205,0),(375,15,206,0),(376,15,207,0),(377,15,208,0),(378,15,209,0),(379,15,210,0),(380,15,211,0),(381,15,212,0),(382,15,213,0),(383,15,214,0),(384,15,215,0),(385,15,216,0),(386,15,217,0),(387,15,218,0),(388,15,219,0),(389,15,220,0),(390,15,221,0),(391,15,222,0),(392,15,223,0),(393,15,224,0),(394,15,225,0),(395,15,226,0),(396,15,227,0),(397,15,228,0),(398,15,229,0),(399,15,230,0),(400,15,231,0),(401,15,232,0),(402,15,233,0),(403,15,234,0),(404,15,235,0),(405,15,236,0),(406,15,237,0),(407,15,238,0),(408,15,239,0),(409,15,240,0),(410,15,241,0),(411,15,242,0),(412,15,243,0),(413,15,244,0),(414,15,245,0),(415,15,246,0),(416,15,247,0),(417,15,248,0),(418,15,249,0),(419,15,250,0),(420,15,251,0),(421,15,252,0),(422,15,253,0),(423,15,254,0),(424,15,255,0),(425,15,256,0),(426,15,257,0),(427,15,258,0),(428,15,259,0),(429,15,260,0),(430,14,261,0),(431,14,262,0),(432,14,263,0),(433,14,264,0),(434,14,265,0),(435,14,266,0),(436,14,267,0),(437,14,268,0),(438,14,269,0),(439,14,270,0),(440,14,271,0),(441,14,272,0),(442,14,273,0),(443,14,274,0),(444,14,275,0),(445,14,276,0),(446,14,277,0),(447,14,278,0),(448,14,279,0),(449,14,280,0),(450,14,281,0),(451,14,282,0),(452,14,283,0),(453,14,284,0),(454,14,285,0),(455,14,286,0),(456,14,287,0),(457,14,288,0),(458,14,289,0),(459,14,290,0),(460,14,291,0),(461,14,292,0),(462,14,293,0),(463,36,293,0),(464,2,293,0),(465,14,294,0),(466,36,294,0),(467,2,294,0),(468,14,295,0),(469,36,295,0),(470,2,295,0),(471,14,296,0),(472,36,296,0),(473,2,296,0),(474,14,297,0),(475,36,297,0),(476,2,297,0),(477,14,298,0),(478,36,298,0),(479,2,298,0),(480,14,299,0),(481,36,299,0),(482,2,299,0),(483,14,300,0),(484,36,300,0),(485,2,300,0),(486,14,301,0),(487,36,301,0),(488,2,301,0),(489,14,302,0),(490,36,302,0),(491,2,302,0),(492,14,303,0),(493,36,303,0),(494,2,303,0),(495,14,304,0),(496,36,304,0),(497,2,304,0),(498,14,305,0),(499,36,305,0),(500,2,305,0),(501,14,306,0),(502,36,306,0),(503,2,306,0),(504,14,307,0),(505,36,307,0),(506,2,307,0),(507,14,308,0),(508,36,308,0),(509,2,308,0),(510,14,309,0),(511,14,310,0),(512,14,311,0),(513,14,312,0),(514,14,313,0),(515,14,314,0),(516,14,315,0),(517,14,316,0),(518,14,317,0),(519,14,318,0),(520,14,319,0),(521,14,320,0),(522,14,321,0),(523,14,322,0),(524,14,323,0),(525,14,324,0),(526,14,325,0),(527,14,326,0),(528,14,327,0),(529,14,328,0),(530,14,329,0),(531,14,330,0),(532,14,331,0),(533,14,332,0),(534,14,333,0),(535,14,334,0),(536,14,335,0),(537,14,336,0),(538,14,337,0),(539,14,338,0),(540,14,339,0),(541,14,340,0),(542,14,341,0),(543,14,342,0),(544,14,343,0),(545,14,344,0),(546,14,345,0),(547,14,346,0),(548,14,347,0),(549,14,348,0),(550,14,349,0),(551,14,350,0),(552,14,351,0),(553,14,352,0),(554,14,353,0),(555,14,354,0),(556,14,355,0),(557,14,356,0),(558,14,357,0),(559,14,358,0),(560,14,359,0),(561,14,360,0),(562,14,361,0),(563,14,362,0),(564,14,363,0),(565,14,364,0),(566,14,365,0),(567,14,366,0),(568,14,367,0),(569,14,368,0),(570,14,369,0),(571,14,370,0),(572,14,371,0),(573,14,372,0),(574,14,373,0),(575,14,374,0),(576,14,375,0),(577,14,376,0),(578,14,377,0),(579,14,378,0),(580,14,379,0),(581,14,380,0),(582,14,381,0),(583,14,382,0),(584,14,383,0),(585,14,384,0),(586,14,385,0),(587,14,386,0),(588,14,387,0),(589,14,388,0),(590,14,389,0),(591,36,389,0),(592,2,389,0),(593,14,390,0),(594,36,390,0),(595,2,390,0),(596,14,391,0),(597,36,391,0),(598,2,391,0),(599,14,392,0),(600,36,392,0),(601,2,392,0),(602,14,393,0),(603,36,393,0),(604,2,393,0),(605,14,394,0),(606,36,394,0),(607,2,394,0),(608,14,395,0),(609,36,395,0),(610,2,395,0),(611,14,396,0),(612,36,396,0),(613,2,396,0),(614,14,397,0),(615,36,397,0),(616,2,397,0),(617,14,398,0),(618,36,398,0),(619,2,398,0),(620,14,399,0),(621,36,399,0),(622,2,399,0),(623,14,400,0),(624,36,400,0),(625,2,400,0),(626,14,401,0),(627,36,401,0),(628,2,401,0),(629,14,402,0),(630,36,402,0),(631,2,402,0),(632,14,403,0),(633,36,403,0),(634,2,403,0),(635,14,404,0),(636,36,404,0),(637,2,404,0),(638,14,405,0),(639,14,406,0),(640,14,407,0),(641,14,408,0),(642,14,409,0),(643,14,410,0),(644,14,411,0),(645,14,412,0),(646,14,413,0),(647,14,414,0),(648,14,415,0),(649,14,416,0),(650,14,417,0),(651,14,418,0),(652,14,419,0),(653,14,420,0),(654,14,421,0),(655,14,422,0),(656,14,423,0),(657,14,424,0),(658,14,425,0),(659,14,426,0),(660,14,427,0),(661,14,428,0),(662,14,429,0),(663,14,430,0),(664,14,431,0),(665,14,432,0),(666,14,433,0),(667,14,434,0),(668,14,435,0),(669,14,436,0),(670,16,437,0),(671,16,438,0),(672,16,439,0),(673,16,440,0),(674,16,441,0),(675,16,442,0),(676,16,443,0),(677,16,444,0),(678,16,445,0),(679,16,446,0),(680,16,447,0),(681,16,448,0),(682,16,449,0),(683,16,450,0),(684,16,451,0),(685,16,452,0),(686,16,453,0),(687,36,453,0),(688,2,453,0),(689,16,454,0),(690,36,454,0),(691,2,454,0),(692,16,455,0),(693,36,455,0),(694,2,455,0),(695,16,456,0),(696,36,456,0),(697,2,456,0),(698,16,457,0),(699,36,457,0),(700,2,457,0),(701,16,458,0),(702,36,458,0),(703,2,458,0),(704,16,459,0),(705,36,459,0),(706,2,459,0),(707,16,460,0),(708,36,460,0),(709,2,460,0),(710,16,461,0),(711,36,461,0),(712,2,461,0),(713,16,462,0),(714,36,462,0),(715,2,462,0),(716,16,463,0),(717,36,463,0),(718,2,463,0),(719,16,464,0),(720,36,464,0),(721,2,464,0),(722,16,465,0),(723,36,465,0),(724,2,465,0),(725,16,466,0),(726,36,466,0),(727,2,466,0),(728,16,467,0),(729,36,467,0),(730,2,467,0),(731,16,468,0),(732,36,468,0),(733,2,468,0),(734,16,469,0),(735,16,470,0),(736,16,471,0),(737,16,472,0),(738,16,473,0),(739,16,474,0),(740,16,475,0),(741,16,476,0),(742,16,477,0),(743,16,478,0),(744,16,479,0),(745,16,480,0),(746,16,481,0),(747,16,482,0),(748,16,483,0),(749,16,484,0),(750,16,485,0),(751,16,486,0),(752,16,487,0),(753,16,488,0),(754,16,489,0),(755,16,490,0),(756,16,491,0),(757,16,492,0),(758,16,493,0),(759,16,494,0),(760,16,495,0),(761,16,496,0),(762,16,497,0),(763,16,498,0),(764,16,499,0),(765,16,500,0),(766,16,501,0),(767,16,502,0),(768,16,503,0),(769,16,504,0),(770,16,505,0),(771,16,506,0),(772,16,507,0),(773,16,508,0),(774,16,509,0),(775,16,510,0),(776,16,511,0),(777,16,512,0),(778,16,513,0),(779,16,514,0),(780,16,515,0),(781,16,516,0),(782,16,517,0),(783,16,518,0),(784,16,519,0),(785,16,520,0),(786,16,521,0),(787,16,522,0),(788,16,523,0),(789,16,524,0),(790,16,525,0),(791,16,526,0),(792,16,527,0),(793,16,528,0),(794,16,529,0),(795,16,530,0),(796,16,531,0),(797,16,532,0),(798,16,533,0),(799,16,534,0),(800,16,535,0),(801,16,536,0),(802,16,537,0),(803,16,538,0),(804,16,539,0),(805,16,540,0),(806,16,541,0),(807,16,542,0),(808,16,543,0),(809,16,544,0),(810,16,545,0),(811,16,546,0),(812,16,547,0),(813,16,548,0),(814,16,549,0),(815,16,550,0),(816,16,551,0),(817,16,552,0),(818,16,553,0),(819,16,554,0),(820,16,555,0),(821,16,556,0),(822,16,557,0),(823,16,558,0),(824,16,559,0),(825,16,560,0),(826,16,561,0),(827,16,562,0),(828,16,563,0),(829,16,564,0),(830,16,565,0),(831,16,566,0),(832,16,567,0),(833,16,568,0),(834,16,569,0),(835,16,570,0),(836,16,571,0),(837,16,572,0),(838,16,573,0),(839,16,574,0),(840,16,575,0),(841,16,576,0),(842,16,577,0),(843,16,578,0),(844,16,579,0),(845,16,580,0),(846,16,581,0),(847,16,582,0),(848,16,583,0),(849,16,584,0),(850,16,585,0),(851,16,586,0),(852,16,587,0),(853,16,588,0),(854,16,589,0),(855,16,590,0),(856,16,591,0),(857,16,592,0),(858,16,593,0),(859,16,594,0),(860,16,595,0),(861,16,596,0),(862,16,597,0),(863,16,598,0),(864,16,599,0),(865,16,600,0),(866,16,601,0),(867,16,602,0),(868,16,603,0),(869,16,604,0),(870,16,605,0),(871,16,606,0),(872,16,607,0),(873,16,608,0),(874,16,609,0),(875,16,610,0),(876,16,611,0),(877,16,612,0),(878,16,613,0),(879,16,614,0),(880,16,615,0),(881,16,616,0),(882,16,617,0),(883,16,618,0),(884,16,619,0),(885,16,620,0),(886,16,621,0),(887,16,622,0),(888,16,623,0),(889,16,624,0),(890,16,625,0),(891,16,626,0),(892,16,627,0),(893,16,628,0),(894,17,629,0),(895,17,630,0),(896,17,631,0),(897,17,632,0),(898,17,633,0),(899,17,634,0),(900,17,635,0),(901,17,636,0),(902,17,637,0),(903,17,638,0),(904,17,639,0),(905,17,640,0),(906,17,641,0),(907,17,642,0),(908,17,643,0),(909,17,644,0),(910,17,645,0),(911,17,646,0),(912,17,647,0),(913,17,648,0),(914,17,649,0),(915,17,650,0),(916,17,651,0),(917,17,652,0),(918,17,653,0),(919,17,654,0),(920,17,655,0),(921,17,656,0),(922,17,657,0),(923,17,658,0),(924,17,659,0),(925,17,660,0),(926,17,661,0),(927,17,662,0),(928,17,663,0),(929,17,664,0),(930,17,665,0),(931,17,666,0),(932,17,667,0),(933,17,668,0),(934,17,669,0),(935,17,670,0),(936,17,671,0),(937,17,672,0),(938,17,673,0),(939,17,674,0),(940,17,675,0),(941,17,676,0),(942,17,677,0),(943,17,678,0),(944,17,679,0),(945,17,680,0),(946,17,681,0),(947,17,682,0),(948,17,683,0),(949,17,684,0),(950,17,685,0),(951,17,686,0),(952,17,687,0),(953,17,688,0),(954,17,689,0),(955,17,690,0),(956,17,691,0),(957,17,692,0),(958,17,693,0),(959,17,694,0),(960,17,695,0),(961,36,695,0),(962,2,695,0),(963,17,696,0),(964,36,696,0),(965,2,696,0),(966,17,697,0),(967,36,697,0),(968,2,697,0),(969,17,698,0),(970,36,698,0),(971,2,698,0),(972,17,699,0),(973,36,699,0),(974,2,699,0),(975,17,700,0),(976,36,700,0),(977,2,700,0),(978,17,701,0),(979,17,702,0),(980,17,703,0),(981,17,704,0),(982,17,705,0),(983,17,706,0),(984,17,707,0),(985,17,708,0),(986,17,709,0),(987,17,710,0),(988,17,711,0),(989,17,712,0),(990,17,713,0),(991,17,714,0),(992,17,715,0),(993,17,716,0),(994,17,717,0),(995,17,718,0),(996,17,719,0),(997,36,719,0),(998,2,719,0),(999,17,720,0),(1000,36,720,0),(1001,2,720,0),(1002,17,721,0),(1003,36,721,0),(1004,2,721,0),(1005,17,722,0),(1006,36,722,0),(1007,2,722,0),(1008,17,723,0),(1009,36,723,0),(1010,2,723,0),(1011,17,724,0),(1012,36,724,0),(1013,2,724,0),(1014,17,725,0),(1015,17,726,0),(1016,17,727,0),(1017,17,728,0),(1018,17,729,0),(1019,17,730,0),(1020,18,731,0),(1021,32,731,0),(1022,2,731,0),(1023,18,732,0),(1024,32,732,0),(1025,2,732,0),(1026,18,733,0),(1027,32,733,0),(1028,2,733,0),(1029,18,734,0),(1030,32,734,0),(1031,2,734,0),(1032,18,735,0),(1033,32,735,0),(1034,2,735,0),(1035,18,736,0),(1036,32,736,0),(1037,2,736,0),(1038,18,737,0),(1039,32,737,0),(1040,2,737,0),(1041,18,738,0),(1042,32,738,0),(1043,2,738,0),(1044,18,739,0),(1045,32,739,0),(1046,2,739,0),(1047,18,740,0),(1048,32,740,0),(1049,2,740,0),(1050,18,741,0),(1051,32,741,0),(1052,2,741,0),(1053,18,742,0),(1054,32,742,0),(1055,2,742,0),(1056,18,743,0),(1057,32,743,0),(1058,2,743,0),(1059,18,744,0),(1060,32,744,0),(1061,35,744,0),(1062,2,744,0),(1063,18,745,0),(1064,32,745,0),(1065,35,745,0),(1066,2,745,0),(1067,18,746,0),(1068,32,746,0),(1069,35,746,0),(1070,2,746,0),(1071,18,747,0),(1072,32,747,0),(1073,35,747,0),(1074,2,747,0),(1075,18,748,0),(1076,32,748,0),(1077,35,748,0),(1078,2,748,0),(1079,18,749,0),(1080,32,749,0),(1081,35,749,0),(1082,2,749,0),(1083,18,750,0),(1084,32,750,0),(1085,35,750,0),(1086,2,750,0),(1087,18,751,0),(1088,32,751,0),(1089,35,751,0),(1090,2,751,0),(1091,18,752,0),(1092,32,752,0),(1093,35,752,0),(1094,2,752,0),(1095,18,753,0),(1096,32,753,0),(1097,35,753,0),(1098,2,753,0),(1099,18,754,0),(1100,32,754,0),(1101,35,754,0),(1102,2,754,0),(1103,18,755,0),(1104,32,755,0),(1105,35,755,0),(1106,2,755,0),(1107,18,756,0),(1108,32,756,0),(1109,35,756,0),(1110,2,756,0),(1111,18,757,0),(1112,32,757,0),(1113,8,757,0),(1114,2,757,0),(1115,18,758,0),(1116,32,758,0),(1117,8,758,0),(1118,2,758,0),(1119,18,759,0),(1120,32,759,0),(1121,8,759,0),(1122,2,759,0),(1123,18,760,0),(1124,32,760,0),(1125,8,760,0),(1126,2,760,0),(1127,18,761,0),(1128,32,761,0),(1129,8,761,0),(1130,2,761,0),(1131,18,762,0),(1132,32,762,0),(1133,8,762,0),(1134,2,762,0),(1135,18,763,0),(1136,32,763,0),(1137,8,763,0),(1138,2,763,0),(1139,18,764,0),(1140,32,764,0),(1141,8,764,0),(1142,2,764,0),(1143,18,765,0),(1144,32,765,0),(1145,8,765,0),(1146,2,765,0),(1147,18,766,0),(1148,32,766,0),(1149,8,766,0),(1150,2,766,0),(1151,18,767,0),(1152,32,767,0),(1153,8,767,0),(1154,2,767,0),(1155,18,768,0),(1156,32,768,0),(1157,8,768,0),(1158,2,768,0),(1159,18,769,0),(1160,32,769,0),(1161,8,769,0),(1162,2,769,0),(1163,18,770,0),(1164,32,770,0),(1165,2,770,0),(1166,18,771,0),(1167,32,771,0),(1168,2,771,0),(1169,18,772,0),(1170,32,772,0),(1171,2,772,0),(1172,18,773,0),(1173,32,773,0),(1174,2,773,0),(1175,18,774,0),(1176,32,774,0),(1177,2,774,0),(1178,18,775,0),(1179,32,775,0),(1180,2,775,0),(1181,18,776,0),(1182,32,776,0),(1183,2,776,0),(1184,18,777,0),(1185,32,777,0),(1186,2,777,0),(1187,18,778,0),(1188,32,778,0),(1189,2,778,0),(1190,18,779,0),(1191,32,779,0),(1192,2,779,0),(1193,18,780,0),(1194,32,780,0),(1195,2,780,0),(1196,18,781,0),(1197,32,781,0),(1198,2,781,0),(1199,18,782,0),(1200,32,782,0),(1201,2,782,0),(1202,18,783,0),(1203,32,783,0),(1204,8,783,0),(1205,2,783,0),(1206,18,784,0),(1207,32,784,0),(1208,8,784,0),(1209,2,784,0),(1210,18,785,0),(1211,32,785,0),(1212,8,785,0),(1213,2,785,0),(1214,18,786,0),(1215,32,786,0),(1216,8,786,0),(1217,2,786,0),(1218,18,787,0),(1219,32,787,0),(1220,8,787,0),(1221,2,787,0),(1222,18,788,0),(1223,32,788,0),(1224,8,788,0),(1225,2,788,0),(1226,18,789,0),(1227,32,789,0),(1228,8,789,0),(1229,2,789,0),(1230,18,790,0),(1231,32,790,0),(1232,8,790,0),(1233,2,790,0),(1234,18,791,0),(1235,32,791,0),(1236,8,791,0),(1237,2,791,0),(1238,18,792,0),(1239,32,792,0),(1240,8,792,0),(1241,2,792,0),(1242,18,793,0),(1243,32,793,0),(1244,8,793,0),(1245,2,793,0),(1246,18,794,0),(1247,32,794,0),(1248,8,794,0),(1249,2,794,0),(1250,18,795,0),(1251,32,795,0),(1252,8,795,0),(1253,2,795,0),(1254,18,796,0),(1255,32,796,0),(1256,36,796,0),(1257,2,796,0),(1258,18,797,0),(1259,32,797,0),(1260,36,797,0),(1261,2,797,0),(1262,18,798,0),(1263,32,798,0),(1264,36,798,0),(1265,2,798,0),(1266,18,799,0),(1267,32,799,0),(1268,36,799,0),(1269,2,799,0),(1270,18,800,0),(1271,32,800,0),(1272,36,800,0),(1273,2,800,0),(1274,18,801,0),(1275,32,801,0),(1276,36,801,0),(1277,2,801,0),(1278,18,802,0),(1279,32,802,0),(1280,36,802,0),(1281,2,802,0),(1282,18,803,0),(1283,32,803,0),(1284,36,803,0),(1285,2,803,0),(1286,18,804,0),(1287,32,804,0),(1288,36,804,0),(1289,2,804,0),(1290,18,805,0),(1291,32,805,0),(1292,36,805,0),(1293,2,805,0),(1294,18,806,0),(1295,32,806,0),(1296,36,806,0),(1297,2,806,0),(1298,18,807,0),(1299,32,807,0),(1300,36,807,0),(1301,2,807,0),(1302,18,808,0),(1303,32,808,0),(1304,36,808,0),(1305,2,808,0),(1306,18,809,0),(1307,32,809,0),(1308,8,809,0),(1309,2,809,0),(1310,18,810,0),(1311,32,810,0),(1312,8,810,0),(1313,2,810,0),(1314,18,811,0),(1315,32,811,0),(1316,8,811,0),(1317,2,811,0),(1318,18,812,0),(1319,32,812,0),(1320,8,812,0),(1321,2,812,0),(1322,18,813,0),(1323,32,813,0),(1324,8,813,0),(1325,2,813,0),(1326,18,814,0),(1327,32,814,0),(1328,8,814,0),(1329,2,814,0),(1330,18,815,0),(1331,32,815,0),(1332,8,815,0),(1333,2,815,0),(1334,18,816,0),(1335,32,816,0),(1336,8,816,0),(1337,2,816,0),(1338,18,817,0),(1339,32,817,0),(1340,8,817,0),(1341,2,817,0),(1342,18,818,0),(1343,32,818,0),(1344,8,818,0),(1345,2,818,0),(1346,18,819,0),(1347,32,819,0),(1348,8,819,0),(1349,2,819,0),(1350,18,820,0),(1351,32,820,0),(1352,8,820,0),(1353,2,820,0),(1354,18,821,0),(1355,32,821,0),(1356,8,821,0),(1357,2,821,0),(1358,18,822,0),(1359,32,822,0),(1360,8,822,0),(1361,2,822,0),(1362,18,823,0),(1363,32,823,0),(1364,8,823,0),(1365,2,823,0),(1366,18,824,0),(1367,32,824,0),(1368,8,824,0),(1369,2,824,0),(1370,18,825,0),(1371,32,825,0),(1372,8,825,0),(1373,2,825,0),(1374,18,826,0),(1375,32,826,0),(1376,8,826,0),(1377,2,826,0),(1378,18,827,0),(1379,32,827,0),(1380,8,827,0),(1381,2,827,0),(1382,18,828,0),(1383,32,828,0),(1384,8,828,0),(1385,2,828,0),(1386,18,829,0),(1387,32,829,0),(1388,8,829,0),(1389,2,829,0),(1390,18,830,0),(1391,32,830,0),(1392,8,830,0),(1393,2,830,0),(1394,18,831,0),(1395,32,831,0),(1396,8,831,0),(1397,2,831,0),(1398,18,832,0),(1399,32,832,0),(1400,8,832,0),(1401,2,832,0),(1402,18,833,0),(1403,32,833,0),(1404,8,833,0),(1405,2,833,0),(1406,18,834,0),(1407,32,834,0),(1408,8,834,0),(1409,2,834,0),(1410,18,835,0),(1411,32,835,0),(1412,8,835,0),(1413,34,835,0),(1414,2,835,0),(1415,18,836,0),(1416,32,836,0),(1417,8,836,0),(1418,34,836,0),(1419,2,836,0),(1420,18,837,0),(1421,32,837,0),(1422,8,837,0),(1423,34,837,0),(1424,2,837,0),(1425,18,838,0),(1426,32,838,0),(1427,8,838,0),(1428,34,838,0),(1429,2,838,0),(1430,18,839,0),(1431,32,839,0),(1432,8,839,0),(1433,34,839,0),(1434,2,839,0),(1435,18,840,0),(1436,32,840,0),(1437,8,840,0),(1438,34,840,0),(1439,2,840,0),(1440,18,841,0),(1441,32,841,0),(1442,8,841,0),(1443,34,841,0),(1444,2,841,0),(1445,18,842,0),(1446,32,842,0),(1447,8,842,0),(1448,34,842,0),(1449,2,842,0),(1450,18,843,0),(1451,32,843,0),(1452,8,843,0),(1453,34,843,0),(1454,2,843,0),(1455,18,844,0),(1456,32,844,0),(1457,8,844,0),(1458,34,844,0),(1459,2,844,0),(1460,18,845,0),(1461,32,845,0),(1462,8,845,0),(1463,34,845,0),(1464,2,845,0),(1465,18,846,0),(1466,32,846,0),(1467,8,846,0),(1468,34,846,0),(1469,2,846,0),(1470,18,847,0),(1471,32,847,0),(1472,8,847,0),(1473,34,847,0),(1474,2,847,0),(1475,18,848,0),(1476,32,848,0),(1477,34,848,0),(1478,2,848,0),(1479,18,849,0),(1480,32,849,0),(1481,34,849,0),(1482,2,849,0),(1483,18,850,0),(1484,32,850,0),(1485,34,850,0),(1486,2,850,0),(1487,18,851,0),(1488,32,851,0),(1489,34,851,0),(1490,2,851,0),(1491,18,852,0),(1492,32,852,0),(1493,34,852,0),(1494,2,852,0),(1495,18,853,0),(1496,32,853,0),(1497,34,853,0),(1498,2,853,0),(1499,18,854,0),(1500,32,854,0),(1501,34,854,0),(1502,2,854,0),(1503,18,855,0),(1504,32,855,0),(1505,34,855,0),(1506,2,855,0),(1507,18,856,0),(1508,32,856,0),(1509,34,856,0),(1510,2,856,0),(1511,18,857,0),(1512,32,857,0),(1513,34,857,0),(1514,2,857,0),(1515,18,858,0),(1516,32,858,0),(1517,34,858,0),(1518,2,858,0),(1519,18,859,0),(1520,32,859,0),(1521,34,859,0),(1522,2,859,0),(1523,18,860,0),(1524,32,860,0),(1525,34,860,0),(1526,2,860,0),(1527,18,861,0),(1528,32,861,0),(1529,34,861,0),(1530,2,861,0),(1531,18,862,0),(1532,32,862,0),(1533,34,862,0),(1534,2,862,0),(1535,18,863,0),(1536,32,863,0),(1537,34,863,0),(1538,2,863,0),(1539,18,864,0),(1540,32,864,0),(1541,34,864,0),(1542,2,864,0),(1543,18,865,0),(1544,32,865,0),(1545,34,865,0),(1546,2,865,0),(1547,18,866,0),(1548,32,866,0),(1549,34,866,0),(1550,2,866,0),(1551,18,867,0),(1552,32,867,0),(1553,34,867,0),(1554,2,867,0),(1555,18,868,0),(1556,32,868,0),(1557,34,868,0),(1558,2,868,0),(1559,18,869,0),(1560,32,869,0),(1561,34,869,0),(1562,2,869,0),(1563,18,870,0),(1564,32,870,0),(1565,34,870,0),(1566,2,870,0),(1567,18,871,0),(1568,32,871,0),(1569,34,871,0),(1570,2,871,0),(1571,18,872,0),(1572,32,872,0),(1573,34,872,0),(1574,2,872,0),(1575,18,873,0),(1576,32,873,0),(1577,34,873,0),(1578,2,873,0),(1579,18,874,0),(1580,32,874,0),(1581,2,874,0),(1582,18,875,0),(1583,32,875,0),(1584,2,875,0),(1585,18,876,0),(1586,32,876,0),(1587,2,876,0),(1588,18,877,0),(1589,32,877,0),(1590,2,877,0),(1591,18,878,0),(1592,32,878,0),(1593,2,878,0),(1594,18,879,0),(1595,32,879,0),(1596,2,879,0),(1597,18,880,0),(1598,32,880,0),(1599,2,880,0),(1600,18,881,0),(1601,32,881,0),(1602,2,881,0),(1603,18,882,0),(1604,32,882,0),(1605,2,882,0),(1606,18,883,0),(1607,32,883,0),(1608,2,883,0),(1609,18,884,0),(1610,32,884,0),(1611,2,884,0),(1612,18,885,0),(1613,32,885,0),(1614,2,885,0),(1615,18,886,0),(1616,32,886,0),(1617,2,886,0),(1618,19,887,0),(1619,34,887,0),(1620,2,887,0),(1621,19,888,0),(1622,34,888,0),(1623,2,888,0),(1624,19,889,0),(1625,34,889,0),(1626,2,889,0),(1627,19,890,0),(1628,34,890,0),(1629,2,890,0),(1630,19,891,0),(1631,34,891,0),(1632,2,891,0),(1633,19,892,0),(1634,34,892,0),(1635,2,892,0),(1636,19,893,0),(1637,34,893,0),(1638,2,893,0),(1639,19,894,0),(1640,34,894,0),(1641,2,894,0),(1642,19,895,0),(1643,34,895,0),(1644,2,895,0),(1645,19,896,0),(1646,34,896,0),(1647,2,896,0),(1648,19,897,0),(1649,34,897,0),(1650,2,897,0),(1651,19,898,0),(1652,34,898,0),(1653,2,898,0),(1654,19,899,0),(1655,34,899,0),(1656,2,899,0),(1657,19,900,0),(1658,19,901,0),(1659,19,902,0),(1660,19,903,0),(1661,19,904,0),(1662,19,905,0),(1663,35,905,0),(1664,2,905,0),(1665,19,906,0),(1666,35,906,0),(1667,2,906,0),(1668,19,907,0),(1669,35,907,0),(1670,2,907,0),(1671,19,908,0),(1672,35,908,0),(1673,2,908,0),(1674,19,909,0),(1675,35,909,0),(1676,2,909,0),(1677,19,910,0),(1678,35,910,0),(1679,2,910,0),(1680,19,911,0),(1681,35,911,0),(1682,2,911,0),(1683,19,912,0),(1684,35,912,0),(1685,2,912,0),(1686,19,913,0),(1687,35,913,0),(1688,2,913,0),(1689,19,914,0),(1690,35,914,0),(1691,2,914,0),(1692,19,915,0),(1693,35,915,0),(1694,2,915,0),(1695,19,916,0),(1696,35,916,0),(1697,2,916,0),(1698,19,917,0),(1699,35,917,0),(1700,2,917,0),(1701,19,918,0),(1702,19,919,0),(1703,19,920,0),(1704,19,921,0),(1705,19,922,0),(1706,19,923,0),(1707,19,924,0),(1708,19,925,0),(1709,19,926,0),(1710,19,927,0),(1711,19,928,0),(1712,19,929,0),(1713,19,930,0),(1714,19,931,0),(1715,35,931,0),(1716,2,931,0),(1717,19,932,0),(1718,35,932,0),(1719,2,932,0),(1720,19,933,0),(1721,35,933,0),(1722,2,933,0),(1723,19,934,0),(1724,35,934,0),(1725,2,934,0),(1726,19,935,0),(1727,35,935,0),(1728,2,935,0),(1729,19,936,0),(1730,35,936,0),(1731,2,936,0),(1732,19,937,0),(1733,35,937,0),(1734,2,937,0),(1735,19,938,0),(1736,35,938,0),(1737,2,938,0),(1738,19,939,0),(1739,35,939,0),(1740,2,939,0),(1741,19,940,0),(1742,35,940,0),(1743,2,940,0),(1744,19,941,0),(1745,35,941,0),(1746,2,941,0),(1747,19,942,0),(1748,35,942,0),(1749,2,942,0),(1750,19,943,0),(1751,35,943,0),(1752,2,943,0),(1753,19,944,0),(1754,8,944,0),(1755,2,944,0),(1756,19,945,0),(1757,8,945,0),(1758,2,945,0),(1759,19,946,0),(1760,8,946,0),(1761,2,946,0),(1762,19,947,0),(1763,8,947,0),(1764,2,947,0),(1765,19,948,0),(1766,8,948,0),(1767,2,948,0),(1768,19,949,0),(1769,8,949,0),(1770,2,949,0),(1771,19,950,0),(1772,8,950,0),(1773,2,950,0),(1774,19,951,0),(1775,8,951,0),(1776,2,951,0),(1777,19,952,0),(1778,8,952,0),(1779,2,952,0),(1780,19,953,0),(1781,8,953,0),(1782,2,953,0),(1783,19,954,0),(1784,8,954,0),(1785,2,954,0),(1786,19,955,0),(1787,8,955,0),(1788,2,955,0),(1789,19,956,0),(1790,8,956,0),(1791,2,956,0),(1792,19,957,0),(1793,31,957,0),(1794,34,957,0),(1795,2,957,0),(1796,19,958,0),(1797,31,958,0),(1798,34,958,0),(1799,2,958,0),(1800,19,959,0),(1801,31,959,0),(1802,34,959,0),(1803,2,959,0),(1804,19,960,0),(1805,31,960,0),(1806,34,960,0),(1807,2,960,0),(1808,19,961,0),(1809,31,961,0),(1810,34,961,0),(1811,2,961,0),(1812,19,962,0),(1813,31,962,0),(1814,34,962,0),(1815,2,962,0),(1816,19,963,0),(1817,31,963,0),(1818,34,963,0),(1819,2,963,0),(1820,19,964,0),(1821,31,964,0),(1822,34,964,0),(1823,2,964,0),(1824,19,965,0),(1825,31,965,0),(1826,34,965,0),(1827,2,965,0),(1828,19,966,0),(1829,31,966,0),(1830,34,966,0),(1831,2,966,0),(1832,19,967,0),(1833,31,967,0),(1834,34,967,0),(1835,2,967,0),(1836,19,968,0),(1837,31,968,0),(1838,34,968,0),(1839,2,968,0),(1840,19,969,0),(1841,31,969,0),(1842,34,969,0),(1843,2,969,0),(1844,19,970,0),(1845,31,970,0),(1846,2,970,0),(1847,19,971,0),(1848,31,971,0),(1849,2,971,0),(1850,19,972,0),(1851,31,972,0),(1852,2,972,0),(1853,19,973,0),(1854,31,973,0),(1855,2,973,0),(1856,19,974,0),(1857,31,974,0),(1858,2,974,0),(1859,19,975,0),(1860,31,975,0),(1861,2,975,0),(1862,19,976,0),(1863,31,976,0),(1864,2,976,0),(1865,19,977,0),(1866,31,977,0),(1867,2,977,0),(1868,19,978,0),(1869,31,978,0),(1870,2,978,0),(1871,19,979,0),(1872,31,979,0),(1873,2,979,0),(1874,19,980,0),(1875,31,980,0),(1876,2,980,0),(1877,19,981,0),(1878,31,981,0),(1879,2,981,0),(1880,19,982,0),(1881,31,982,0),(1882,2,982,0),(1883,19,983,0),(1884,35,983,0),(1885,2,983,0),(1886,19,984,0),(1887,35,984,0),(1888,2,984,0),(1889,19,985,0),(1890,35,985,0),(1891,2,985,0),(1892,19,986,0),(1893,35,986,0),(1894,2,986,0),(1895,19,987,0),(1896,35,987,0),(1897,2,987,0),(1898,19,988,0),(1899,35,988,0),(1900,2,988,0),(1901,19,989,0),(1902,35,989,0),(1903,2,989,0),(1904,19,990,0),(1905,35,990,0),(1906,2,990,0),(1907,19,991,0),(1908,35,991,0),(1909,2,991,0),(1910,19,992,0),(1911,35,992,0),(1912,2,992,0),(1913,19,993,0),(1914,35,993,0),(1915,2,993,0),(1916,19,994,0),(1917,35,994,0),(1918,2,994,0),(1919,19,995,0),(1920,35,995,0),(1921,2,995,0),(1922,19,996,0),(1923,8,996,0),(1924,2,996,0),(1925,19,997,0),(1926,8,997,0),(1927,2,997,0),(1928,19,998,0),(1929,8,998,0),(1930,2,998,0),(1931,19,999,0),(1932,8,999,0),(1933,2,999,0),(1934,19,1000,0),(1935,8,1000,0),(1936,2,1000,0),(1937,19,1001,0),(1938,8,1001,0),(1939,2,1001,0),(1940,19,1002,0),(1941,8,1002,0),(1942,2,1002,0),(1943,19,1003,0),(1944,8,1003,0),(1945,2,1003,0),(1946,19,1004,0),(1947,8,1004,0),(1948,2,1004,0),(1949,19,1005,0),(1950,8,1005,0),(1951,2,1005,0),(1952,19,1006,0),(1953,8,1006,0),(1954,2,1006,0),(1955,19,1007,0),(1956,8,1007,0),(1957,2,1007,0),(1958,19,1008,0),(1959,8,1008,0),(1960,2,1008,0),(1961,19,1009,0),(1962,19,1010,0),(1963,19,1011,0),(1964,19,1012,0),(1965,19,1013,0),(1966,19,1014,0),(1967,19,1015,0),(1968,19,1016,0),(1969,19,1017,0),(1970,19,1018,0),(1971,19,1019,0),(1972,19,1020,0),(1973,19,1021,0),(1974,19,1022,0),(1975,31,1022,0),(1976,2,1022,0),(1977,19,1023,0),(1978,31,1023,0),(1979,2,1023,0),(1980,19,1024,0),(1981,31,1024,0),(1982,2,1024,0),(1983,19,1025,0),(1984,31,1025,0),(1985,2,1025,0),(1986,19,1026,0),(1987,31,1026,0),(1988,2,1026,0),(1989,19,1027,0),(1990,31,1027,0),(1991,2,1027,0),(1992,19,1028,0),(1993,31,1028,0),(1994,2,1028,0),(1995,19,1029,0),(1996,31,1029,0),(1997,2,1029,0),(1998,19,1030,0),(1999,31,1030,0),(2000,2,1030,0),(2001,19,1031,0),(2002,31,1031,0),(2003,2,1031,0),(2004,19,1032,0),(2005,31,1032,0),(2006,2,1032,0),(2007,19,1033,0),(2008,31,1033,0),(2009,2,1033,0),(2010,19,1034,0),(2011,31,1034,0),(2012,2,1034,0),(2013,24,1035,0),(2014,8,1035,0),(2015,34,1035,0),(2016,2,1035,0),(2017,24,1036,0),(2018,8,1036,0),(2019,34,1036,0),(2020,2,1036,0),(2021,24,1037,0),(2022,8,1037,0),(2023,34,1037,0),(2024,2,1037,0),(2025,24,1038,0),(2026,8,1038,0),(2027,34,1038,0),(2028,2,1038,0),(2029,24,1039,0),(2030,8,1039,0),(2031,34,1039,0),(2032,2,1039,0),(2033,24,1040,0),(2034,8,1040,0),(2035,34,1040,0),(2036,2,1040,0),(2037,24,1041,0),(2038,8,1041,0),(2039,34,1041,0),(2040,2,1041,0),(2041,24,1042,0),(2042,8,1042,0),(2043,34,1042,0),(2044,2,1042,0),(2045,24,1043,0),(2046,8,1043,0),(2047,34,1043,0),(2048,2,1043,0),(2049,24,1044,0),(2050,8,1044,0),(2051,34,1044,0),(2052,2,1044,0),(2053,24,1045,0),(2054,8,1045,0),(2055,34,1045,0),(2056,2,1045,0),(2057,24,1046,0),(2058,8,1046,0),(2059,34,1046,0),(2060,2,1046,0),(2061,24,1047,0),(2062,8,1047,0),(2063,34,1047,0),(2064,2,1047,0),(2065,24,1048,0),(2066,8,1048,0),(2067,34,1048,0),(2068,2,1048,0),(2069,24,1049,0),(2070,8,1049,0),(2071,34,1049,0),(2072,2,1049,0),(2073,24,1050,0),(2074,8,1050,0),(2075,34,1050,0),(2076,2,1050,0),(2077,24,1051,0),(2078,30,1051,0),(2079,2,1051,0),(2080,24,1052,0),(2081,30,1052,0),(2082,2,1052,0),(2083,24,1053,0),(2084,30,1053,0),(2085,2,1053,0),(2086,24,1054,0),(2087,30,1054,0),(2088,2,1054,0),(2089,24,1055,0),(2090,30,1055,0),(2091,2,1055,0),(2092,24,1056,0),(2093,30,1056,0),(2094,2,1056,0),(2095,24,1057,0),(2096,30,1057,0),(2097,2,1057,0),(2098,24,1058,0),(2099,30,1058,0),(2100,2,1058,0),(2101,24,1059,0),(2102,30,1059,0),(2103,2,1059,0),(2104,24,1060,0),(2105,30,1060,0),(2106,2,1060,0),(2107,24,1061,0),(2108,30,1061,0),(2109,2,1061,0),(2110,24,1062,0),(2111,30,1062,0),(2112,2,1062,0),(2113,24,1063,0),(2114,30,1063,0),(2115,2,1063,0),(2116,24,1064,0),(2117,30,1064,0),(2118,2,1064,0),(2119,24,1065,0),(2120,30,1065,0),(2121,2,1065,0),(2122,24,1066,0),(2123,30,1066,0),(2124,2,1066,0),(2125,24,1067,0),(2126,24,1068,0),(2127,24,1069,0),(2128,24,1070,0),(2129,24,1071,0),(2130,24,1072,0),(2131,24,1073,0),(2132,24,1074,0),(2133,24,1075,0),(2134,24,1076,0),(2135,24,1077,0),(2136,24,1078,0),(2137,24,1079,0),(2138,24,1080,0),(2139,24,1081,0),(2140,24,1082,0),(2141,24,1083,0),(2142,24,1084,0),(2143,24,1085,0),(2144,24,1086,0),(2145,24,1087,0),(2146,24,1088,0),(2147,24,1089,0),(2148,24,1090,0),(2149,24,1091,0),(2150,24,1092,0),(2151,24,1093,0),(2152,24,1094,0),(2153,24,1095,0),(2154,24,1096,0),(2155,24,1097,0),(2156,24,1098,0),(2157,24,1099,0),(2158,24,1100,0),(2159,24,1101,0),(2160,24,1102,0),(2161,24,1103,0),(2162,24,1104,0),(2163,24,1105,0),(2164,24,1106,0),(2165,24,1107,0),(2166,24,1108,0),(2167,24,1109,0),(2168,24,1110,0),(2169,24,1111,0),(2170,24,1112,0),(2171,24,1113,0),(2172,24,1114,0),(2173,24,1115,0),(2174,24,1116,0),(2175,24,1117,0),(2176,24,1118,0),(2177,24,1119,0),(2178,24,1120,0),(2179,24,1121,0),(2180,8,1121,0),(2181,34,1121,0),(2182,2,1121,0),(2183,24,1122,0),(2184,8,1122,0),(2185,34,1122,0),(2186,2,1122,0),(2187,24,1123,0),(2188,8,1123,0),(2189,34,1123,0),(2190,2,1123,0),(2191,24,1124,0),(2192,8,1124,0),(2193,34,1124,0),(2194,2,1124,0),(2195,24,1125,0),(2196,8,1125,0),(2197,34,1125,0),(2198,2,1125,0),(2199,24,1126,0),(2200,8,1126,0),(2201,34,1126,0),(2202,2,1126,0),(2203,24,1127,0),(2204,8,1127,0),(2205,34,1127,0),(2206,2,1127,0),(2207,24,1128,0),(2208,8,1128,0),(2209,34,1128,0),(2210,2,1128,0),(2211,24,1129,0),(2212,8,1129,0),(2213,34,1129,0),(2214,2,1129,0),(2215,24,1130,0),(2216,8,1130,0),(2217,34,1130,0),(2218,2,1130,0),(2219,24,1131,0),(2220,8,1131,0),(2221,34,1131,0),(2222,2,1131,0),(2223,24,1132,0),(2224,8,1132,0),(2225,34,1132,0),(2226,2,1132,0),(2227,24,1133,0),(2228,8,1133,0),(2229,34,1133,0),(2230,2,1133,0),(2231,24,1134,0),(2232,8,1134,0),(2233,34,1134,0),(2234,2,1134,0),(2235,24,1135,0),(2236,8,1135,0),(2237,34,1135,0),(2238,2,1135,0),(2239,24,1136,0),(2240,8,1136,0),(2241,34,1136,0),(2242,2,1136,0),(2243,24,1137,0),(2244,30,1137,0),(2245,35,1137,0),(2246,2,1137,0),(2247,24,1138,0),(2248,30,1138,0),(2249,35,1138,0),(2250,2,1138,0),(2251,24,1139,0),(2252,30,1139,0),(2253,35,1139,0),(2254,2,1139,0),(2255,24,1140,0),(2256,30,1140,0),(2257,35,1140,0),(2258,2,1140,0),(2259,24,1141,0),(2260,30,1141,0),(2261,35,1141,0),(2262,2,1141,0),(2263,24,1142,0),(2264,30,1142,0),(2265,35,1142,0),(2266,2,1142,0),(2267,24,1143,0),(2268,30,1143,0),(2269,35,1143,0),(2270,2,1143,0),(2271,24,1144,0),(2272,30,1144,0),(2273,35,1144,0),(2274,2,1144,0),(2275,24,1145,0),(2276,30,1145,0),(2277,35,1145,0),(2278,2,1145,0),(2279,24,1146,0),(2280,30,1146,0),(2281,35,1146,0),(2282,2,1146,0),(2283,24,1147,0),(2284,30,1147,0),(2285,35,1147,0),(2286,2,1147,0),(2287,24,1148,0),(2288,30,1148,0),(2289,35,1148,0),(2290,2,1148,0),(2291,24,1149,0),(2292,30,1149,0),(2293,35,1149,0),(2294,2,1149,0),(2295,24,1150,0),(2296,30,1150,0),(2297,35,1150,0),(2298,2,1150,0),(2299,24,1151,0),(2300,30,1151,0),(2301,35,1151,0),(2302,2,1151,0),(2303,24,1152,0),(2304,30,1152,0),(2305,35,1152,0),(2306,2,1152,0),(2307,24,1153,0),(2308,36,1153,0),(2309,2,1153,0),(2310,24,1154,0),(2311,36,1154,0),(2312,2,1154,0),(2313,24,1155,0),(2314,36,1155,0),(2315,2,1155,0),(2316,24,1156,0),(2317,36,1156,0),(2318,2,1156,0),(2319,24,1157,0),(2320,36,1157,0),(2321,2,1157,0),(2322,24,1158,0),(2323,36,1158,0),(2324,2,1158,0),(2325,24,1159,0),(2326,36,1159,0),(2327,2,1159,0),(2328,24,1160,0),(2329,36,1160,0),(2330,2,1160,0),(2331,24,1161,0),(2332,36,1161,0),(2333,2,1161,0),(2334,24,1162,0),(2335,36,1162,0),(2336,2,1162,0),(2337,24,1163,0),(2338,36,1163,0),(2339,2,1163,0),(2340,24,1164,0),(2341,36,1164,0),(2342,2,1164,0),(2343,24,1165,0),(2344,36,1165,0),(2345,2,1165,0),(2346,24,1166,0),(2347,36,1166,0),(2348,2,1166,0),(2349,24,1167,0),(2350,36,1167,0),(2351,2,1167,0),(2352,24,1168,0),(2353,36,1168,0),(2354,2,1168,0),(2355,24,1169,0),(2356,8,1169,0),(2357,2,1169,0),(2358,24,1170,0),(2359,8,1170,0),(2360,2,1170,0),(2361,24,1171,0),(2362,8,1171,0),(2363,2,1171,0),(2364,24,1172,0),(2365,8,1172,0),(2366,2,1172,0),(2367,24,1173,0),(2368,8,1173,0),(2369,2,1173,0),(2370,24,1174,0),(2371,8,1174,0),(2372,2,1174,0),(2373,24,1175,0),(2374,8,1175,0),(2375,2,1175,0),(2376,24,1176,0),(2377,8,1176,0),(2378,2,1176,0),(2379,24,1177,0),(2380,8,1177,0),(2381,2,1177,0),(2382,24,1178,0),(2383,8,1178,0),(2384,2,1178,0),(2385,24,1179,0),(2386,8,1179,0),(2387,2,1179,0),(2388,24,1180,0),(2389,8,1180,0),(2390,2,1180,0),(2391,24,1181,0),(2392,8,1181,0),(2393,2,1181,0),(2394,24,1182,0),(2395,8,1182,0),(2396,2,1182,0),(2397,24,1183,0),(2398,8,1183,0),(2399,2,1183,0),(2400,24,1184,0),(2401,8,1184,0),(2402,2,1184,0),(2403,24,1185,0),(2404,34,1185,0),(2405,2,1185,0),(2406,24,1186,0),(2407,34,1186,0),(2408,2,1186,0),(2409,24,1187,0),(2410,34,1187,0),(2411,2,1187,0),(2412,24,1188,0),(2413,34,1188,0),(2414,2,1188,0),(2415,24,1189,0),(2416,34,1189,0),(2417,2,1189,0),(2418,24,1190,0),(2419,34,1190,0),(2420,2,1190,0),(2421,24,1191,0),(2422,34,1191,0),(2423,2,1191,0),(2424,24,1192,0),(2425,34,1192,0),(2426,2,1192,0),(2427,24,1193,0),(2428,34,1193,0),(2429,2,1193,0),(2430,24,1194,0),(2431,34,1194,0),(2432,2,1194,0),(2433,24,1195,0),(2434,34,1195,0),(2435,2,1195,0),(2436,24,1196,0),(2437,34,1196,0),(2438,2,1196,0),(2439,24,1197,0),(2440,34,1197,0),(2441,2,1197,0),(2442,24,1198,0),(2443,34,1198,0),(2444,2,1198,0),(2445,24,1199,0),(2446,34,1199,0),(2447,2,1199,0),(2448,24,1200,0),(2449,34,1200,0),(2450,2,1200,0),(2451,24,1201,0),(2452,35,1201,0),(2453,2,1201,0),(2454,24,1202,0),(2455,35,1202,0),(2456,2,1202,0),(2457,24,1203,0),(2458,35,1203,0),(2459,2,1203,0),(2460,24,1204,0),(2461,35,1204,0),(2462,2,1204,0),(2463,24,1205,0),(2464,35,1205,0),(2465,2,1205,0),(2466,24,1206,0),(2467,35,1206,0),(2468,2,1206,0),(2469,24,1207,0),(2470,35,1207,0),(2471,2,1207,0),(2472,24,1208,0),(2473,35,1208,0),(2474,2,1208,0),(2475,24,1209,0),(2476,35,1209,0),(2477,2,1209,0),(2478,24,1210,0),(2479,35,1210,0),(2480,2,1210,0),(2481,24,1211,0),(2482,35,1211,0),(2483,2,1211,0),(2484,24,1212,0),(2485,35,1212,0),(2486,2,1212,0),(2487,24,1213,0),(2488,35,1213,0),(2489,2,1213,0),(2490,24,1214,0),(2491,35,1214,0),(2492,2,1214,0),(2493,24,1215,0),(2494,35,1215,0),(2495,2,1215,0),(2496,24,1216,0),(2497,35,1216,0),(2498,2,1216,0),(2499,23,1217,0),(2500,8,1217,0),(2501,34,1217,0),(2502,2,1217,0),(2503,23,1218,0),(2504,8,1218,0),(2505,34,1218,0),(2506,2,1218,0),(2507,23,1219,0),(2508,8,1219,0),(2509,34,1219,0),(2510,2,1219,0),(2511,23,1220,0),(2512,8,1220,0),(2513,34,1220,0),(2514,2,1220,0),(2515,23,1221,0),(2516,8,1221,0),(2517,34,1221,0),(2518,2,1221,0),(2519,23,1222,0),(2520,8,1222,0),(2521,34,1222,0),(2522,2,1222,0),(2523,23,1223,0),(2524,8,1223,0),(2525,34,1223,0),(2526,2,1223,0),(2527,23,1224,0),(2528,8,1224,0),(2529,34,1224,0),(2530,2,1224,0),(2531,23,1225,0),(2532,8,1225,0),(2533,34,1225,0),(2534,2,1225,0),(2535,23,1226,0),(2536,8,1226,0),(2537,34,1226,0),(2538,2,1226,0),(2539,23,1227,0),(2540,30,1227,0),(2541,2,1227,0),(2542,23,1228,0),(2543,30,1228,0),(2544,2,1228,0),(2545,23,1229,0),(2546,30,1229,0),(2547,2,1229,0),(2548,23,1230,0),(2549,30,1230,0),(2550,2,1230,0),(2551,23,1231,0),(2552,30,1231,0),(2553,2,1231,0),(2554,23,1232,0),(2555,30,1232,0),(2556,2,1232,0),(2557,23,1233,0),(2558,30,1233,0),(2559,2,1233,0),(2560,23,1234,0),(2561,30,1234,0),(2562,2,1234,0),(2563,23,1235,0),(2564,30,1235,0),(2565,2,1235,0),(2566,23,1236,0),(2567,30,1236,0),(2568,2,1236,0),(2569,23,1237,0),(2570,30,1237,0),(2571,2,1237,0),(2572,23,1238,0),(2573,30,1238,0),(2574,2,1238,0),(2575,23,1239,0),(2576,30,1239,0),(2577,2,1239,0),(2578,23,1240,0),(2579,30,1240,0),(2580,2,1240,0),(2581,23,1241,0),(2582,30,1241,0),(2583,2,1241,0),(2584,23,1242,0),(2585,30,1242,0),(2586,2,1242,0),(2587,23,1243,0),(2588,23,1244,0),(2589,23,1245,0),(2590,23,1246,0),(2591,23,1247,0),(2592,23,1248,0),(2593,23,1249,0),(2594,23,1250,0),(2595,23,1251,0),(2596,23,1252,0),(2597,23,1253,0),(2598,23,1254,0),(2599,23,1255,0),(2600,23,1256,0),(2601,23,1257,0),(2602,23,1258,0),(2603,23,1259,0),(2604,8,1259,0),(2605,35,1259,0),(2606,2,1259,0),(2607,23,1260,0),(2608,8,1260,0),(2609,35,1260,0),(2610,2,1260,0),(2611,23,1261,0),(2612,8,1261,0),(2613,35,1261,0),(2614,2,1261,0),(2615,23,1262,0),(2616,8,1262,0),(2617,35,1262,0),(2618,2,1262,0),(2619,23,1263,0),(2620,8,1263,0),(2621,35,1263,0),(2622,2,1263,0),(2623,23,1264,0),(2624,8,1264,0),(2625,35,1264,0),(2626,2,1264,0),(2627,23,1265,0),(2628,8,1265,0),(2629,35,1265,0),(2630,2,1265,0),(2631,23,1266,0),(2632,8,1266,0),(2633,35,1266,0),(2634,2,1266,0),(2635,23,1267,0),(2636,8,1267,0),(2637,35,1267,0),(2638,2,1267,0),(2639,23,1268,0),(2640,8,1268,0),(2641,35,1268,0),(2642,2,1268,0),(2643,23,1269,0),(2644,8,1269,0),(2645,35,1269,0),(2646,2,1269,0),(2647,23,1270,0),(2648,8,1270,0),(2649,35,1270,0),(2650,2,1270,0),(2651,23,1271,0),(2652,8,1271,0),(2653,35,1271,0),(2654,2,1271,0),(2655,23,1272,0),(2656,8,1272,0),(2657,35,1272,0),(2658,2,1272,0),(2659,23,1273,0),(2660,8,1273,0),(2661,35,1273,0),(2662,2,1273,0),(2663,23,1274,0),(2664,8,1274,0),(2665,35,1274,0),(2666,2,1274,0),(2667,23,1275,0),(2668,23,1276,0),(2669,23,1277,0),(2670,23,1278,0),(2671,23,1279,0),(2672,23,1280,0),(2673,23,1281,0),(2674,23,1282,0),(2675,23,1283,0),(2676,23,1284,0),(2677,23,1285,0),(2678,23,1286,0),(2679,23,1287,0),(2680,23,1288,0),(2681,23,1289,0),(2682,23,1290,0),(2683,23,1291,0),(2684,23,1292,0),(2685,23,1293,0),(2686,23,1294,0),(2687,23,1295,0),(2688,23,1296,0),(2689,23,1297,0),(2690,23,1298,0),(2691,23,1299,0),(2692,23,1300,0),(2693,23,1301,0),(2694,23,1302,0),(2695,23,1303,0),(2696,23,1304,0),(2697,23,1305,0),(2698,23,1306,0),(2699,23,1307,0),(2700,30,1307,0),(2701,34,1307,0),(2702,2,1307,0),(2703,23,1308,0),(2704,30,1308,0),(2705,34,1308,0),(2706,2,1308,0),(2707,23,1309,0),(2708,30,1309,0),(2709,34,1309,0),(2710,2,1309,0),(2711,23,1310,0),(2712,30,1310,0),(2713,34,1310,0),(2714,2,1310,0),(2715,23,1311,0),(2716,30,1311,0),(2717,34,1311,0),(2718,2,1311,0),(2719,23,1312,0),(2720,30,1312,0),(2721,34,1312,0),(2722,2,1312,0),(2723,23,1313,0),(2724,30,1313,0),(2725,34,1313,0),(2726,2,1313,0),(2727,23,1314,0),(2728,30,1314,0),(2729,34,1314,0),(2730,2,1314,0),(2731,23,1315,0),(2732,30,1315,0),(2733,34,1315,0),(2734,2,1315,0),(2735,23,1316,0),(2736,30,1316,0),(2737,34,1316,0),(2738,2,1316,0),(2739,23,1317,0),(2740,30,1317,0),(2741,34,1317,0),(2742,2,1317,0),(2743,23,1318,0),(2744,30,1318,0),(2745,34,1318,0),(2746,2,1318,0),(2747,23,1319,0),(2748,30,1319,0),(2749,34,1319,0),(2750,2,1319,0),(2751,23,1320,0),(2752,30,1320,0),(2753,34,1320,0),(2754,2,1320,0),(2755,23,1321,0),(2756,30,1321,0),(2757,34,1321,0),(2758,2,1321,0),(2759,23,1322,0),(2760,30,1322,0),(2761,34,1322,0),(2762,2,1322,0),(2763,23,1323,0),(2764,34,1323,0),(2765,2,1323,0),(2766,23,1324,0),(2767,34,1324,0),(2768,2,1324,0),(2769,23,1325,0),(2770,34,1325,0),(2771,2,1325,0),(2772,23,1326,0),(2773,34,1326,0),(2774,2,1326,0),(2775,23,1327,0),(2776,34,1327,0),(2777,2,1327,0),(2778,23,1328,0),(2779,34,1328,0),(2780,2,1328,0),(2781,23,1329,0),(2782,34,1329,0),(2783,2,1329,0),(2784,23,1330,0),(2785,34,1330,0),(2786,2,1330,0),(2787,23,1331,0),(2788,34,1331,0),(2789,2,1331,0),(2790,23,1332,0),(2791,34,1332,0),(2792,2,1332,0),(2793,23,1333,0),(2794,34,1333,0),(2795,2,1333,0),(2796,23,1334,0),(2797,34,1334,0),(2798,2,1334,0),(2799,23,1335,0),(2800,34,1335,0),(2801,2,1335,0),(2802,23,1336,0),(2803,34,1336,0),(2804,2,1336,0),(2805,23,1337,0),(2806,34,1337,0),(2807,2,1337,0),(2808,23,1338,0),(2809,34,1338,0),(2810,2,1338,0),(2811,23,1339,0),(2812,8,1339,0),(2813,35,1339,0),(2814,2,1339,0),(2815,23,1340,0),(2816,8,1340,0),(2817,35,1340,0),(2818,2,1340,0),(2819,23,1341,0),(2820,8,1341,0),(2821,35,1341,0),(2822,2,1341,0),(2823,23,1342,0),(2824,8,1342,0),(2825,35,1342,0),(2826,2,1342,0),(2827,23,1343,0),(2828,8,1343,0),(2829,35,1343,0),(2830,2,1343,0),(2831,23,1344,0),(2832,8,1344,0),(2833,35,1344,0),(2834,2,1344,0),(2835,23,1345,0),(2836,8,1345,0),(2837,35,1345,0),(2838,2,1345,0),(2839,23,1346,0),(2840,8,1346,0),(2841,35,1346,0),(2842,2,1346,0),(2843,23,1347,0),(2844,8,1347,0),(2845,35,1347,0),(2846,2,1347,0),(2847,23,1348,0),(2848,8,1348,0),(2849,35,1348,0),(2850,2,1348,0),(2851,23,1349,0),(2852,8,1349,0),(2853,35,1349,0),(2854,2,1349,0),(2855,23,1350,0),(2856,8,1350,0),(2857,35,1350,0),(2858,2,1350,0),(2859,23,1351,0),(2860,8,1351,0),(2861,35,1351,0),(2862,2,1351,0),(2863,23,1352,0),(2864,8,1352,0),(2865,35,1352,0),(2866,2,1352,0),(2867,23,1353,0),(2868,8,1353,0),(2869,35,1353,0),(2870,2,1353,0),(2871,23,1354,0),(2872,8,1354,0),(2873,35,1354,0),(2874,2,1354,0),(2875,23,1355,0),(2876,8,1355,0),(2877,2,1355,0),(2878,23,1356,0),(2879,8,1356,0),(2880,2,1356,0),(2881,23,1357,0),(2882,8,1357,0),(2883,2,1357,0),(2884,23,1358,0),(2885,8,1358,0),(2886,2,1358,0),(2887,23,1359,0),(2888,8,1359,0),(2889,2,1359,0),(2890,23,1360,0),(2891,8,1360,0),(2892,2,1360,0),(2893,23,1361,0),(2894,8,1361,0),(2895,2,1361,0),(2896,23,1362,0),(2897,8,1362,0),(2898,2,1362,0),(2899,23,1363,0),(2900,8,1363,0),(2901,2,1363,0),(2902,23,1364,0),(2903,8,1364,0),(2904,2,1364,0),(2905,23,1365,0),(2906,8,1365,0),(2907,2,1365,0),(2908,23,1366,0),(2909,8,1366,0),(2910,2,1366,0),(2911,23,1367,0),(2912,8,1367,0),(2913,2,1367,0),(2914,23,1368,0),(2915,8,1368,0),(2916,2,1368,0),(2917,23,1369,0),(2918,8,1369,0),(2919,2,1369,0),(2920,23,1370,0),(2921,8,1370,0),(2922,2,1370,0),(2923,23,1371,0),(2924,30,1371,0),(2925,35,1371,0),(2926,2,1371,0),(2927,23,1372,0),(2928,30,1372,0),(2929,35,1372,0),(2930,2,1372,0),(2931,23,1373,0),(2932,30,1373,0),(2933,35,1373,0),(2934,2,1373,0),(2935,23,1374,0),(2936,30,1374,0),(2937,35,1374,0),(2938,2,1374,0),(2939,23,1375,0),(2940,30,1375,0),(2941,35,1375,0),(2942,2,1375,0),(2943,23,1376,0),(2944,30,1376,0),(2945,35,1376,0),(2946,2,1376,0),(2947,23,1377,0),(2948,30,1377,0),(2949,35,1377,0),(2950,2,1377,0),(2951,23,1378,0),(2952,30,1378,0),(2953,35,1378,0),(2954,2,1378,0),(2955,23,1379,0),(2956,30,1379,0),(2957,35,1379,0),(2958,2,1379,0),(2959,23,1380,0),(2960,30,1380,0),(2961,35,1380,0),(2962,2,1380,0),(2963,23,1381,0),(2964,30,1381,0),(2965,35,1381,0),(2966,2,1381,0),(2967,23,1382,0),(2968,30,1382,0),(2969,35,1382,0),(2970,2,1382,0),(2971,23,1383,0),(2972,30,1383,0),(2973,35,1383,0),(2974,2,1383,0),(2975,23,1384,0),(2976,30,1384,0),(2977,35,1384,0),(2978,2,1384,0),(2979,23,1385,0),(2980,30,1385,0),(2981,35,1385,0),(2982,2,1385,0),(2983,23,1386,0),(2984,30,1386,0),(2985,35,1386,0),(2986,2,1386,0),(2987,23,1387,0),(2988,30,1387,0),(2989,35,1387,0),(2990,2,1387,0),(2991,23,1388,0),(2992,30,1388,0),(2993,35,1388,0),(2994,2,1388,0),(2995,23,1389,0),(2996,30,1389,0),(2997,35,1389,0),(2998,2,1389,0),(2999,23,1390,0),(3000,30,1390,0),(3001,35,1390,0),(3002,2,1390,0),(3003,23,1391,0),(3004,30,1391,0),(3005,35,1391,0),(3006,2,1391,0),(3007,23,1392,0),(3008,30,1392,0),(3009,35,1392,0),(3010,2,1392,0),(3011,23,1393,0),(3012,30,1393,0),(3013,35,1393,0),(3014,2,1393,0),(3015,23,1394,0),(3016,30,1394,0),(3017,35,1394,0),(3018,2,1394,0),(3019,23,1395,0),(3020,30,1395,0),(3021,35,1395,0),(3022,2,1395,0),(3023,23,1396,0),(3024,30,1396,0),(3025,35,1396,0),(3026,2,1396,0),(3027,23,1397,0),(3028,30,1397,0),(3029,35,1397,0),(3030,2,1397,0),(3031,23,1398,0),(3032,30,1398,0),(3033,35,1398,0),(3034,2,1398,0),(3035,23,1399,0),(3036,30,1399,0),(3037,35,1399,0),(3038,2,1399,0),(3039,23,1400,0),(3040,30,1400,0),(3041,35,1400,0),(3042,2,1400,0),(3043,23,1401,0),(3044,30,1401,0),(3045,35,1401,0),(3046,2,1401,0),(3047,23,1402,0),(3048,30,1402,0),(3049,35,1402,0),(3050,2,1402,0),(3051,25,1403,0),(3052,33,1403,0),(3053,8,1403,0),(3054,2,1403,0),(3055,25,1404,0),(3056,33,1404,0),(3057,8,1404,0),(3058,2,1404,0),(3059,25,1405,0),(3060,33,1405,0),(3061,8,1405,0),(3062,2,1405,0),(3063,25,1406,0),(3064,33,1406,0),(3065,8,1406,0),(3066,2,1406,0),(3067,25,1407,0),(3068,33,1407,0),(3069,8,1407,0),(3070,2,1407,0),(3071,25,1408,0),(3072,33,1408,0),(3073,8,1408,0),(3074,2,1408,0),(3075,25,1409,0),(3076,33,1409,0),(3077,8,1409,0),(3078,2,1409,0),(3079,25,1410,0),(3080,33,1410,0),(3081,8,1410,0),(3082,2,1410,0),(3083,25,1411,0),(3084,33,1411,0),(3085,8,1411,0),(3086,2,1411,0),(3087,25,1412,0),(3088,33,1412,0),(3089,8,1412,0),(3090,2,1412,0),(3091,25,1413,0),(3092,33,1413,0),(3093,8,1413,0),(3094,2,1413,0),(3095,25,1414,0),(3096,33,1414,0),(3097,8,1414,0),(3098,2,1414,0),(3099,25,1415,0),(3100,33,1415,0),(3101,8,1415,0),(3102,2,1415,0),(3103,25,1416,0),(3104,33,1416,0),(3105,8,1416,0),(3106,2,1416,0),(3107,25,1417,0),(3108,33,1417,0),(3109,8,1417,0),(3110,2,1417,0),(3111,25,1418,0),(3112,33,1418,0),(3113,8,1418,0),(3114,2,1418,0),(3115,25,1419,0),(3116,33,1419,0),(3117,35,1419,0),(3118,2,1419,0),(3119,25,1420,0),(3120,33,1420,0),(3121,35,1420,0),(3122,2,1420,0),(3123,25,1421,0),(3124,33,1421,0),(3125,35,1421,0),(3126,2,1421,0),(3127,25,1422,0),(3128,33,1422,0),(3129,35,1422,0),(3130,2,1422,0),(3131,25,1423,0),(3132,33,1423,0),(3133,35,1423,0),(3134,2,1423,0),(3135,25,1424,0),(3136,33,1424,0),(3137,35,1424,0),(3138,2,1424,0),(3139,25,1425,0),(3140,33,1425,0),(3141,35,1425,0),(3142,2,1425,0),(3143,25,1426,0),(3144,33,1426,0),(3145,35,1426,0),(3146,2,1426,0),(3147,25,1427,0),(3148,33,1427,0),(3149,35,1427,0),(3150,2,1427,0),(3151,25,1428,0),(3152,33,1428,0),(3153,35,1428,0),(3154,2,1428,0),(3155,25,1429,0),(3156,33,1429,0),(3157,35,1429,0),(3158,2,1429,0),(3159,25,1430,0),(3160,33,1430,0),(3161,35,1430,0),(3162,2,1430,0),(3163,25,1431,0),(3164,33,1431,0),(3165,35,1431,0),(3166,2,1431,0),(3167,25,1432,0),(3168,33,1432,0),(3169,35,1432,0),(3170,2,1432,0),(3171,25,1433,0),(3172,33,1433,0),(3173,35,1433,0),(3174,2,1433,0),(3175,25,1434,0),(3176,33,1434,0),(3177,35,1434,0),(3178,2,1434,0),(3179,25,1435,0),(3180,33,1435,0),(3181,8,1435,0),(3182,36,1435,0),(3183,2,1435,0),(3184,25,1436,0),(3185,33,1436,0),(3186,8,1436,0),(3187,36,1436,0),(3188,2,1436,0),(3189,25,1437,0),(3190,33,1437,0),(3191,8,1437,0),(3192,36,1437,0),(3193,2,1437,0),(3194,25,1438,0),(3195,33,1438,0),(3196,8,1438,0),(3197,36,1438,0),(3198,2,1438,0),(3199,25,1439,0),(3200,33,1439,0),(3201,8,1439,0),(3202,36,1439,0),(3203,2,1439,0),(3204,25,1440,0),(3205,33,1440,0),(3206,8,1440,0),(3207,36,1440,0),(3208,2,1440,0),(3209,25,1441,0),(3210,33,1441,0),(3211,8,1441,0),(3212,36,1441,0),(3213,2,1441,0),(3214,25,1442,0),(3215,33,1442,0),(3216,8,1442,0),(3217,36,1442,0),(3218,2,1442,0),(3219,25,1443,0),(3220,33,1443,0),(3221,8,1443,0),(3222,36,1443,0),(3223,2,1443,0),(3224,25,1444,0),(3225,33,1444,0),(3226,8,1444,0),(3227,36,1444,0),(3228,2,1444,0),(3229,25,1445,0),(3230,33,1445,0),(3231,8,1445,0),(3232,36,1445,0),(3233,2,1445,0),(3234,25,1446,0),(3235,33,1446,0),(3236,8,1446,0),(3237,36,1446,0),(3238,2,1446,0),(3239,25,1447,0),(3240,33,1447,0),(3241,8,1447,0),(3242,36,1447,0),(3243,2,1447,0),(3244,25,1448,0),(3245,33,1448,0),(3246,8,1448,0),(3247,36,1448,0),(3248,2,1448,0),(3249,25,1449,0),(3250,33,1449,0),(3251,8,1449,0),(3252,36,1449,0),(3253,2,1449,0),(3254,25,1450,0),(3255,33,1450,0),(3256,8,1450,0),(3257,36,1450,0),(3258,2,1450,0),(3259,25,1451,0),(3260,33,1451,0),(3261,8,1451,0),(3262,36,1451,0),(3263,2,1451,0),(3264,25,1452,0),(3265,33,1452,0),(3266,8,1452,0),(3267,36,1452,0),(3268,2,1452,0),(3269,25,1453,0),(3270,33,1453,0),(3271,8,1453,0),(3272,36,1453,0),(3273,2,1453,0),(3274,25,1454,0),(3275,33,1454,0),(3276,8,1454,0),(3277,36,1454,0),(3278,2,1454,0),(3279,25,1455,0),(3280,33,1455,0),(3281,8,1455,0),(3282,36,1455,0),(3283,2,1455,0),(3284,25,1456,0),(3285,33,1456,0),(3286,8,1456,0),(3287,36,1456,0),(3288,2,1456,0),(3289,25,1457,0),(3290,33,1457,0),(3291,8,1457,0),(3292,36,1457,0),(3293,2,1457,0),(3294,25,1458,0),(3295,33,1458,0),(3296,8,1458,0),(3297,36,1458,0),(3298,2,1458,0),(3299,25,1459,0),(3300,33,1459,0),(3301,8,1459,0),(3302,36,1459,0),(3303,2,1459,0),(3304,25,1460,0),(3305,33,1460,0),(3306,8,1460,0),(3307,36,1460,0),(3308,2,1460,0),(3309,25,1461,0),(3310,33,1461,0),(3311,8,1461,0),(3312,36,1461,0),(3313,2,1461,0),(3314,25,1462,0),(3315,33,1462,0),(3316,8,1462,0),(3317,36,1462,0),(3318,2,1462,0),(3319,25,1463,0),(3320,33,1463,0),(3321,8,1463,0),(3322,36,1463,0),(3323,2,1463,0),(3324,25,1464,0),(3325,33,1464,0),(3326,8,1464,0),(3327,36,1464,0),(3328,2,1464,0),(3329,25,1465,0),(3330,33,1465,0),(3331,8,1465,0),(3332,36,1465,0),(3333,2,1465,0),(3334,25,1466,0),(3335,33,1466,0),(3336,8,1466,0),(3337,36,1466,0),(3338,2,1466,0),(3339,25,1467,0),(3340,33,1467,0),(3341,8,1467,0),(3342,34,1467,0),(3343,2,1467,0),(3344,25,1468,0),(3345,33,1468,0),(3346,8,1468,0),(3347,34,1468,0),(3348,2,1468,0),(3349,25,1469,0),(3350,33,1469,0),(3351,8,1469,0),(3352,34,1469,0),(3353,2,1469,0),(3354,25,1470,0),(3355,33,1470,0),(3356,8,1470,0),(3357,34,1470,0),(3358,2,1470,0),(3359,25,1471,0),(3360,33,1471,0),(3361,8,1471,0),(3362,34,1471,0),(3363,2,1471,0),(3364,25,1472,0),(3365,33,1472,0),(3366,8,1472,0),(3367,34,1472,0),(3368,2,1472,0),(3369,25,1473,0),(3370,33,1473,0),(3371,8,1473,0),(3372,34,1473,0),(3373,2,1473,0),(3374,25,1474,0),(3375,33,1474,0),(3376,8,1474,0),(3377,34,1474,0),(3378,2,1474,0),(3379,25,1475,0),(3380,33,1475,0),(3381,8,1475,0),(3382,34,1475,0),(3383,2,1475,0),(3384,25,1476,0),(3385,33,1476,0),(3386,8,1476,0),(3387,34,1476,0),(3388,2,1476,0),(3389,25,1477,0),(3390,33,1477,0),(3391,8,1477,0),(3392,34,1477,0),(3393,2,1477,0),(3394,25,1478,0),(3395,33,1478,0),(3396,8,1478,0),(3397,34,1478,0),(3398,2,1478,0),(3399,25,1479,0),(3400,33,1479,0),(3401,8,1479,0),(3402,34,1479,0),(3403,2,1479,0),(3404,25,1480,0),(3405,33,1480,0),(3406,8,1480,0),(3407,34,1480,0),(3408,2,1480,0),(3409,25,1481,0),(3410,33,1481,0),(3411,8,1481,0),(3412,34,1481,0),(3413,2,1481,0),(3414,25,1482,0),(3415,33,1482,0),(3416,8,1482,0),(3417,34,1482,0),(3418,2,1482,0),(3419,25,1483,0),(3420,33,1483,0),(3421,30,1483,0),(3422,2,1483,0),(3423,25,1484,0),(3424,33,1484,0),(3425,30,1484,0),(3426,2,1484,0),(3427,25,1485,0),(3428,33,1485,0),(3429,30,1485,0),(3430,2,1485,0),(3431,25,1486,0),(3432,33,1486,0),(3433,30,1486,0),(3434,2,1486,0),(3435,25,1487,0),(3436,33,1487,0),(3437,30,1487,0),(3438,2,1487,0),(3439,25,1488,0),(3440,33,1488,0),(3441,30,1488,0),(3442,2,1488,0),(3443,25,1489,0),(3444,33,1489,0),(3445,30,1489,0),(3446,2,1489,0),(3447,25,1490,0),(3448,33,1490,0),(3449,30,1490,0),(3450,2,1490,0),(3451,25,1491,0),(3452,33,1491,0),(3453,30,1491,0),(3454,2,1491,0),(3455,25,1492,0),(3456,33,1492,0),(3457,30,1492,0),(3458,2,1492,0),(3459,25,1493,0),(3460,33,1493,0),(3461,30,1493,0),(3462,2,1493,0),(3463,25,1494,0),(3464,33,1494,0),(3465,30,1494,0),(3466,2,1494,0),(3467,25,1495,0),(3468,33,1495,0),(3469,30,1495,0),(3470,2,1495,0),(3471,25,1496,0),(3472,33,1496,0),(3473,30,1496,0),(3474,2,1496,0),(3475,25,1497,0),(3476,33,1497,0),(3477,30,1497,0),(3478,2,1497,0),(3479,25,1498,0),(3480,33,1498,0),(3481,30,1498,0),(3482,2,1498,0),(3483,25,1499,0),(3484,33,1499,0),(3485,30,1499,0),(3486,36,1499,0),(3487,2,1499,0),(3488,25,1500,0),(3489,33,1500,0),(3490,30,1500,0),(3491,36,1500,0),(3492,2,1500,0),(3493,25,1501,0),(3494,33,1501,0),(3495,30,1501,0),(3496,36,1501,0),(3497,2,1501,0),(3498,25,1502,0),(3499,33,1502,0),(3500,30,1502,0),(3501,36,1502,0),(3502,2,1502,0),(3503,25,1503,0),(3504,33,1503,0),(3505,30,1503,0),(3506,36,1503,0),(3507,2,1503,0),(3508,25,1504,0),(3509,33,1504,0),(3510,30,1504,0),(3511,36,1504,0),(3512,2,1504,0),(3513,25,1505,0),(3514,33,1505,0),(3515,30,1505,0),(3516,36,1505,0),(3517,2,1505,0),(3518,25,1506,0),(3519,33,1506,0),(3520,30,1506,0),(3521,36,1506,0),(3522,2,1506,0),(3523,25,1507,0),(3524,33,1507,0),(3525,30,1507,0),(3526,36,1507,0),(3527,2,1507,0),(3528,25,1508,0),(3529,33,1508,0),(3530,30,1508,0),(3531,36,1508,0),(3532,2,1508,0),(3533,25,1509,0),(3534,33,1509,0),(3535,30,1509,0),(3536,36,1509,0),(3537,2,1509,0),(3538,25,1510,0),(3539,33,1510,0),(3540,30,1510,0),(3541,36,1510,0),(3542,2,1510,0),(3543,25,1511,0),(3544,33,1511,0),(3545,30,1511,0),(3546,36,1511,0),(3547,2,1511,0),(3548,25,1512,0),(3549,33,1512,0),(3550,30,1512,0),(3551,36,1512,0),(3552,2,1512,0),(3553,25,1513,0),(3554,33,1513,0),(3555,30,1513,0),(3556,36,1513,0),(3557,2,1513,0),(3558,25,1514,0),(3559,33,1514,0),(3560,30,1514,0),(3561,36,1514,0),(3562,2,1514,0),(3563,25,1515,0),(3564,33,1515,0),(3565,35,1515,0),(3566,2,1515,0),(3567,25,1516,0),(3568,33,1516,0),(3569,35,1516,0),(3570,2,1516,0),(3571,25,1517,0),(3572,33,1517,0),(3573,35,1517,0),(3574,2,1517,0),(3575,25,1518,0),(3576,33,1518,0),(3577,35,1518,0),(3578,2,1518,0),(3579,25,1519,0),(3580,33,1519,0),(3581,35,1519,0),(3582,2,1519,0),(3583,25,1520,0),(3584,33,1520,0),(3585,35,1520,0),(3586,2,1520,0),(3587,25,1521,0),(3588,33,1521,0),(3589,35,1521,0),(3590,2,1521,0),(3591,25,1522,0),(3592,33,1522,0),(3593,35,1522,0),(3594,2,1522,0),(3595,25,1523,0),(3596,33,1523,0),(3597,35,1523,0),(3598,2,1523,0),(3599,25,1524,0),(3600,33,1524,0),(3601,35,1524,0),(3602,2,1524,0),(3603,25,1525,0),(3604,33,1525,0),(3605,35,1525,0),(3606,2,1525,0),(3607,25,1526,0),(3608,33,1526,0),(3609,35,1526,0),(3610,2,1526,0),(3611,25,1527,0),(3612,33,1527,0),(3613,35,1527,0),(3614,2,1527,0),(3615,25,1528,0),(3616,33,1528,0),(3617,35,1528,0),(3618,2,1528,0),(3619,25,1529,0),(3620,33,1529,0),(3621,35,1529,0),(3622,2,1529,0),(3623,25,1530,0),(3624,33,1530,0),(3625,35,1530,0),(3626,2,1530,0),(3627,25,1531,0),(3628,33,1531,0),(3629,30,1531,0),(3630,34,1531,0),(3631,2,1531,0),(3632,25,1532,0),(3633,33,1532,0),(3634,30,1532,0),(3635,34,1532,0),(3636,2,1532,0),(3637,25,1533,0),(3638,33,1533,0),(3639,30,1533,0),(3640,34,1533,0),(3641,2,1533,0),(3642,25,1534,0),(3643,33,1534,0),(3644,30,1534,0),(3645,34,1534,0),(3646,2,1534,0),(3647,25,1535,0),(3648,33,1535,0),(3649,30,1535,0),(3650,34,1535,0),(3651,2,1535,0),(3652,25,1536,0),(3653,33,1536,0),(3654,30,1536,0),(3655,34,1536,0),(3656,2,1536,0),(3657,25,1537,0),(3658,33,1537,0),(3659,30,1537,0),(3660,34,1537,0),(3661,2,1537,0),(3662,25,1538,0),(3663,33,1538,0),(3664,30,1538,0),(3665,34,1538,0),(3666,2,1538,0),(3667,25,1539,0),(3668,33,1539,0),(3669,30,1539,0),(3670,34,1539,0),(3671,2,1539,0),(3672,25,1540,0),(3673,33,1540,0),(3674,30,1540,0),(3675,34,1540,0),(3676,2,1540,0),(3677,25,1541,0),(3678,33,1541,0),(3679,30,1541,0),(3680,34,1541,0),(3681,2,1541,0),(3682,25,1542,0),(3683,33,1542,0),(3684,30,1542,0),(3685,34,1542,0),(3686,2,1542,0),(3687,25,1543,0),(3688,33,1543,0),(3689,30,1543,0),(3690,34,1543,0),(3691,2,1543,0),(3692,25,1544,0),(3693,33,1544,0),(3694,30,1544,0),(3695,34,1544,0),(3696,2,1544,0),(3697,25,1545,0),(3698,33,1545,0),(3699,30,1545,0),(3700,34,1545,0),(3701,2,1545,0),(3702,25,1546,0),(3703,33,1546,0),(3704,30,1546,0),(3705,34,1546,0),(3706,2,1546,0),(3707,25,1547,0),(3708,33,1547,0),(3709,35,1547,0),(3710,2,1547,0),(3711,25,1548,0),(3712,33,1548,0),(3713,35,1548,0),(3714,2,1548,0),(3715,25,1549,0),(3716,33,1549,0),(3717,35,1549,0),(3718,2,1549,0),(3719,25,1550,0),(3720,33,1550,0),(3721,35,1550,0),(3722,2,1550,0),(3723,25,1551,0),(3724,33,1551,0),(3725,35,1551,0),(3726,2,1551,0),(3727,25,1552,0),(3728,33,1552,0),(3729,35,1552,0),(3730,2,1552,0),(3731,25,1553,0),(3732,33,1553,0),(3733,35,1553,0),(3734,2,1553,0),(3735,25,1554,0),(3736,33,1554,0),(3737,35,1554,0),(3738,2,1554,0),(3739,25,1555,0),(3740,33,1555,0),(3741,35,1555,0),(3742,2,1555,0),(3743,25,1556,0),(3744,33,1556,0),(3745,35,1556,0),(3746,2,1556,0),(3747,25,1557,0),(3748,33,1557,0),(3749,35,1557,0),(3750,2,1557,0),(3751,25,1558,0),(3752,33,1558,0),(3753,35,1558,0),(3754,2,1558,0),(3755,25,1559,0),(3756,33,1559,0),(3757,35,1559,0),(3758,2,1559,0),(3759,25,1560,0),(3760,33,1560,0),(3761,35,1560,0),(3762,2,1560,0),(3763,25,1561,0),(3764,33,1561,0),(3765,35,1561,0),(3766,2,1561,0),(3767,25,1562,0),(3768,33,1562,0),(3769,35,1562,0),(3770,2,1562,0),(3771,25,1563,0),(3772,33,1563,0),(3773,2,1563,0),(3774,25,1564,0),(3775,33,1564,0),(3776,2,1564,0),(3777,25,1565,0),(3778,33,1565,0),(3779,2,1565,0),(3780,25,1566,0),(3781,33,1566,0),(3782,2,1566,0),(3783,25,1567,0),(3784,33,1567,0),(3785,2,1567,0),(3786,25,1568,0),(3787,33,1568,0),(3788,2,1568,0),(3789,25,1569,0),(3790,33,1569,0),(3791,2,1569,0),(3792,25,1570,0),(3793,33,1570,0),(3794,2,1570,0),(3795,25,1571,0),(3796,33,1571,0),(3797,2,1571,0),(3798,25,1572,0),(3799,33,1572,0),(3800,2,1572,0),(3801,25,1573,0),(3802,33,1573,0),(3803,2,1573,0),(3804,25,1574,0),(3805,33,1574,0),(3806,2,1574,0),(3807,25,1575,0),(3808,33,1575,0),(3809,2,1575,0),(3810,25,1576,0),(3811,33,1576,0),(3812,2,1576,0),(3813,25,1577,0),(3814,33,1577,0),(3815,2,1577,0),(3816,25,1578,0),(3817,33,1578,0),(3818,2,1578,0),(3819,25,1579,0),(3820,33,1579,0),(3821,2,1579,0),(3822,25,1580,0),(3823,33,1580,0),(3824,2,1580,0),(3825,25,1581,0),(3826,33,1581,0),(3827,2,1581,0),(3828,25,1582,0),(3829,33,1582,0),(3830,2,1582,0),(3831,25,1583,0),(3832,33,1583,0),(3833,2,1583,0),(3834,25,1584,0),(3835,33,1584,0),(3836,2,1584,0),(3837,25,1585,0),(3838,33,1585,0),(3839,2,1585,0),(3840,25,1586,0),(3841,33,1586,0),(3842,2,1586,0),(3843,25,1587,0),(3844,33,1587,0),(3845,2,1587,0),(3846,25,1588,0),(3847,33,1588,0),(3848,2,1588,0),(3849,25,1589,0),(3850,33,1589,0),(3851,2,1589,0),(3852,25,1590,0),(3853,33,1590,0),(3854,2,1590,0),(3855,25,1591,0),(3856,33,1591,0),(3857,2,1591,0),(3858,25,1592,0),(3859,33,1592,0),(3860,2,1592,0),(3861,25,1593,0),(3862,33,1593,0),(3863,2,1593,0),(3864,25,1594,0),(3865,33,1594,0),(3866,2,1594,0),(3867,26,1595,0),(3868,30,1595,0),(3869,36,1595,0),(3870,2,1595,0),(3871,26,1596,0),(3872,30,1596,0),(3873,36,1596,0),(3874,2,1596,0),(3875,26,1597,0),(3876,30,1597,0),(3877,36,1597,0),(3878,2,1597,0),(3879,26,1598,0),(3880,30,1598,0),(3881,36,1598,0),(3882,2,1598,0),(3883,26,1599,0),(3884,30,1599,0),(3885,36,1599,0),(3886,2,1599,0),(3887,26,1600,0),(3888,30,1600,0),(3889,36,1600,0),(3890,2,1600,0),(3891,26,1601,0),(3892,30,1601,0),(3893,36,1601,0),(3894,2,1601,0),(3895,26,1602,0),(3896,30,1602,0),(3897,36,1602,0),(3898,2,1602,0),(3899,26,1603,0),(3900,30,1603,0),(3901,36,1603,0),(3902,2,1603,0),(3903,26,1604,0),(3904,30,1604,0),(3905,36,1604,0),(3906,2,1604,0),(3907,26,1605,0),(3908,30,1605,0),(3909,36,1605,0),(3910,2,1605,0),(3911,26,1606,0),(3912,30,1606,0),(3913,36,1606,0),(3914,2,1606,0),(3915,26,1607,0),(3916,30,1607,0),(3917,36,1607,0),(3918,2,1607,0),(3919,26,1608,0),(3920,30,1608,0),(3921,36,1608,0),(3922,2,1608,0),(3923,26,1609,0),(3924,30,1609,0),(3925,36,1609,0),(3926,2,1609,0),(3927,26,1610,0),(3928,30,1610,0),(3929,36,1610,0),(3930,2,1610,0),(3931,26,1611,0),(3932,26,1612,0),(3933,26,1613,0),(3934,26,1614,0),(3935,26,1615,0),(3936,26,1616,0),(3937,26,1617,0),(3938,26,1618,0),(3939,26,1619,0),(3940,26,1620,0),(3941,26,1621,0),(3942,26,1622,0),(3943,26,1623,0),(3944,26,1624,0),(3945,26,1625,0),(3946,26,1626,0),(3947,26,1627,0),(3948,8,1627,0),(3949,35,1627,0),(3950,2,1627,0),(3951,26,1628,0),(3952,8,1628,0),(3953,35,1628,0),(3954,2,1628,0),(3955,26,1629,0),(3956,8,1629,0),(3957,35,1629,0),(3958,2,1629,0),(3959,26,1630,0),(3960,8,1630,0),(3961,35,1630,0),(3962,2,1630,0),(3963,26,1631,0),(3964,8,1631,0),(3965,35,1631,0),(3966,2,1631,0),(3967,26,1632,0),(3968,8,1632,0),(3969,35,1632,0),(3970,2,1632,0),(3971,26,1633,0),(3972,8,1633,0),(3973,35,1633,0),(3974,2,1633,0),(3975,26,1634,0),(3976,8,1634,0),(3977,35,1634,0),(3978,2,1634,0),(3979,26,1635,0),(3980,8,1635,0),(3981,35,1635,0),(3982,2,1635,0),(3983,26,1636,0),(3984,8,1636,0),(3985,35,1636,0),(3986,2,1636,0),(3987,26,1637,0),(3988,8,1637,0),(3989,35,1637,0),(3990,2,1637,0),(3991,26,1638,0),(3992,8,1638,0),(3993,35,1638,0),(3994,2,1638,0),(3995,26,1639,0),(3996,8,1639,0),(3997,35,1639,0),(3998,2,1639,0),(3999,26,1640,0),(4000,8,1640,0),(4001,35,1640,0),(4002,2,1640,0),(4003,26,1641,0),(4004,8,1641,0),(4005,35,1641,0),(4006,2,1641,0),(4007,26,1642,0),(4008,8,1642,0),(4009,35,1642,0),(4010,2,1642,0),(4011,26,1643,0),(4012,26,1644,0),(4013,26,1645,0),(4014,26,1646,0),(4015,26,1647,0),(4016,26,1648,0),(4017,26,1649,0),(4018,26,1650,0),(4019,26,1651,0),(4020,26,1652,0),(4021,26,1653,0),(4022,26,1654,0),(4023,26,1655,0),(4024,26,1656,0),(4025,26,1657,0),(4026,26,1658,0),(4027,26,1659,0),(4028,26,1660,0),(4029,26,1661,0),(4030,26,1662,0),(4031,26,1663,0),(4032,26,1664,0),(4033,26,1665,0),(4034,26,1666,0),(4035,26,1667,0),(4036,26,1668,0),(4037,26,1669,0),(4038,26,1670,0),(4039,26,1671,0),(4040,26,1672,0),(4041,26,1673,0),(4042,26,1674,0),(4043,26,1675,0),(4044,36,1675,0),(4045,2,1675,0),(4046,26,1676,0),(4047,36,1676,0),(4048,2,1676,0),(4049,26,1677,0),(4050,36,1677,0),(4051,2,1677,0),(4052,26,1678,0),(4053,36,1678,0),(4054,2,1678,0),(4055,26,1679,0),(4056,36,1679,0),(4057,2,1679,0),(4058,26,1680,0),(4059,36,1680,0),(4060,2,1680,0),(4061,26,1681,0),(4062,36,1681,0),(4063,2,1681,0),(4064,26,1682,0),(4065,36,1682,0),(4066,2,1682,0),(4067,26,1683,0),(4068,36,1683,0),(4069,2,1683,0),(4070,26,1684,0),(4071,36,1684,0),(4072,2,1684,0),(4073,26,1685,0),(4074,36,1685,0),(4075,2,1685,0),(4076,26,1686,0),(4077,36,1686,0),(4078,2,1686,0),(4079,26,1687,0),(4080,36,1687,0),(4081,2,1687,0),(4082,26,1688,0),(4083,36,1688,0),(4084,2,1688,0),(4085,26,1689,0),(4086,36,1689,0),(4087,2,1689,0),(4088,26,1690,0),(4089,36,1690,0),(4090,2,1690,0),(4091,26,1691,0),(4092,26,1692,0),(4093,26,1693,0),(4094,26,1694,0),(4095,26,1695,0),(4096,26,1696,0),(4097,26,1697,0),(4098,26,1698,0),(4099,26,1699,0),(4100,26,1700,0),(4101,26,1701,0),(4102,26,1702,0),(4103,26,1703,0),(4104,26,1704,0),(4105,26,1705,0),(4106,26,1706,0),(4107,26,1707,0),(4108,8,1707,0),(4109,34,1707,0),(4110,2,1707,0),(4111,26,1708,0),(4112,8,1708,0),(4113,34,1708,0),(4114,2,1708,0),(4115,26,1709,0),(4116,8,1709,0),(4117,34,1709,0),(4118,2,1709,0),(4119,26,1710,0),(4120,8,1710,0),(4121,34,1710,0),(4122,2,1710,0),(4123,26,1711,0),(4124,8,1711,0),(4125,34,1711,0),(4126,2,1711,0),(4127,26,1712,0),(4128,8,1712,0),(4129,34,1712,0),(4130,2,1712,0),(4131,26,1713,0),(4132,8,1713,0),(4133,34,1713,0),(4134,2,1713,0),(4135,26,1714,0),(4136,8,1714,0),(4137,34,1714,0),(4138,2,1714,0),(4139,26,1715,0),(4140,8,1715,0),(4141,34,1715,0),(4142,2,1715,0),(4143,26,1716,0),(4144,8,1716,0),(4145,34,1716,0),(4146,2,1716,0),(4147,26,1717,0),(4148,8,1717,0),(4149,34,1717,0),(4150,2,1717,0),(4151,26,1718,0),(4152,8,1718,0),(4153,34,1718,0),(4154,2,1718,0),(4155,26,1719,0),(4156,8,1719,0),(4157,34,1719,0),(4158,2,1719,0),(4159,26,1720,0),(4160,8,1720,0),(4161,34,1720,0),(4162,2,1720,0),(4163,26,1721,0),(4164,8,1721,0),(4165,34,1721,0),(4166,2,1721,0),(4167,26,1722,0),(4168,8,1722,0),(4169,34,1722,0),(4170,2,1722,0),(4171,26,1723,0),(4172,35,1723,0),(4173,2,1723,0),(4174,26,1724,0),(4175,35,1724,0),(4176,2,1724,0),(4177,26,1725,0),(4178,35,1725,0),(4179,2,1725,0),(4180,26,1726,0),(4181,35,1726,0),(4182,2,1726,0),(4183,26,1727,0),(4184,35,1727,0),(4185,2,1727,0),(4186,26,1728,0),(4187,35,1728,0),(4188,2,1728,0),(4189,26,1729,0),(4190,35,1729,0),(4191,2,1729,0),(4192,26,1730,0),(4193,35,1730,0),(4194,2,1730,0),(4195,26,1731,0),(4196,35,1731,0),(4197,2,1731,0),(4198,26,1732,0),(4199,35,1732,0),(4200,2,1732,0),(4201,26,1733,0),(4202,35,1733,0),(4203,2,1733,0),(4204,26,1734,0),(4205,35,1734,0),(4206,2,1734,0),(4207,26,1735,0),(4208,35,1735,0),(4209,2,1735,0),(4210,26,1736,0),(4211,35,1736,0),(4212,2,1736,0),(4213,26,1737,0),(4214,35,1737,0),(4215,2,1737,0),(4216,26,1738,0),(4217,35,1738,0),(4218,2,1738,0),(4219,26,1739,0),(4220,34,1739,0),(4221,2,1739,0),(4222,26,1740,0),(4223,34,1740,0),(4224,2,1740,0),(4225,26,1741,0),(4226,34,1741,0),(4227,2,1741,0),(4228,26,1742,0),(4229,34,1742,0),(4230,2,1742,0),(4231,26,1743,0),(4232,34,1743,0),(4233,2,1743,0),(4234,26,1744,0),(4235,34,1744,0),(4236,2,1744,0),(4237,26,1745,0),(4238,34,1745,0),(4239,2,1745,0),(4240,26,1746,0),(4241,34,1746,0),(4242,2,1746,0),(4243,26,1747,0),(4244,34,1747,0),(4245,2,1747,0),(4246,26,1748,0),(4247,34,1748,0),(4248,2,1748,0),(4249,26,1749,0),(4250,34,1749,0),(4251,2,1749,0),(4252,26,1750,0),(4253,34,1750,0),(4254,2,1750,0),(4255,26,1751,0),(4256,34,1751,0),(4257,2,1751,0),(4258,26,1752,0),(4259,34,1752,0),(4260,2,1752,0),(4261,26,1753,0),(4262,34,1753,0),(4263,2,1753,0),(4264,26,1754,0),(4265,34,1754,0),(4266,2,1754,0),(4267,26,1755,0),(4268,26,1756,0),(4269,26,1757,0),(4270,26,1758,0),(4271,26,1759,0),(4272,26,1760,0),(4273,26,1761,0),(4274,26,1762,0),(4275,26,1763,0),(4276,26,1764,0),(4277,26,1765,0),(4278,26,1766,0),(4279,26,1767,0),(4280,26,1768,0),(4281,26,1769,0),(4282,26,1770,0),(4283,26,1771,0),(4284,35,1771,0),(4285,2,1771,0),(4286,26,1772,0),(4287,35,1772,0),(4288,2,1772,0),(4289,26,1773,0),(4290,35,1773,0),(4291,2,1773,0),(4292,26,1774,0),(4293,35,1774,0),(4294,2,1774,0),(4295,26,1775,0),(4296,35,1775,0),(4297,2,1775,0),(4298,26,1776,0),(4299,35,1776,0),(4300,2,1776,0),(4301,26,1777,0),(4302,35,1777,0),(4303,2,1777,0),(4304,26,1778,0),(4305,35,1778,0),(4306,2,1778,0),(4307,26,1779,0),(4308,35,1779,0),(4309,2,1779,0),(4310,26,1780,0),(4311,35,1780,0),(4312,2,1780,0),(4313,26,1781,0),(4314,35,1781,0),(4315,2,1781,0),(4316,26,1782,0),(4317,35,1782,0),(4318,2,1782,0),(4319,26,1783,0),(4320,35,1783,0),(4321,2,1783,0),(4322,26,1784,0),(4323,35,1784,0),(4324,2,1784,0),(4325,26,1785,0),(4326,35,1785,0),(4327,2,1785,0),(4328,26,1786,0),(4329,35,1786,0),(4330,2,1786,0),(4331,26,1787,0),(4332,30,1787,0),(4333,35,1787,0),(4334,2,1787,0),(4335,26,1788,0),(4336,30,1788,0),(4337,35,1788,0),(4338,2,1788,0),(4339,26,1789,0),(4340,30,1789,0),(4341,35,1789,0),(4342,2,1789,0),(4343,26,1790,0),(4344,30,1790,0),(4345,35,1790,0),(4346,2,1790,0),(4347,26,1791,0),(4348,30,1791,0),(4349,35,1791,0),(4350,2,1791,0),(4351,26,1792,0),(4352,30,1792,0),(4353,35,1792,0),(4354,2,1792,0),(4355,26,1793,0),(4356,30,1793,0),(4357,35,1793,0),(4358,2,1793,0),(4359,26,1794,0),(4360,30,1794,0),(4361,35,1794,0),(4362,2,1794,0),(4363,26,1795,0),(4364,30,1795,0),(4365,35,1795,0),(4366,2,1795,0),(4367,26,1796,0),(4368,30,1796,0),(4369,35,1796,0),(4370,2,1796,0),(4371,26,1797,0),(4372,30,1797,0),(4373,35,1797,0),(4374,2,1797,0),(4375,26,1798,0),(4376,30,1798,0),(4377,35,1798,0),(4378,2,1798,0),(4379,26,1799,0),(4380,30,1799,0),(4381,35,1799,0),(4382,2,1799,0),(4383,26,1800,0),(4384,30,1800,0),(4385,35,1800,0),(4386,2,1800,0),(4387,26,1801,0),(4388,30,1801,0),(4389,35,1801,0),(4390,2,1801,0),(4391,26,1802,0),(4392,30,1802,0),(4393,35,1802,0),(4394,2,1802,0),(4395,26,1803,0),(4396,30,1803,0),(4397,34,1803,0),(4398,2,1803,0),(4399,26,1804,0),(4400,30,1804,0),(4401,34,1804,0),(4402,2,1804,0),(4403,26,1805,0),(4404,30,1805,0),(4405,34,1805,0),(4406,2,1805,0),(4407,26,1806,0),(4408,30,1806,0),(4409,34,1806,0),(4410,2,1806,0),(4411,26,1807,0),(4412,30,1807,0),(4413,34,1807,0),(4414,2,1807,0),(4415,26,1808,0),(4416,30,1808,0),(4417,34,1808,0),(4418,2,1808,0),(4419,26,1809,0),(4420,30,1809,0),(4421,34,1809,0),(4422,2,1809,0),(4423,26,1810,0),(4424,30,1810,0),(4425,34,1810,0),(4426,2,1810,0),(4427,26,1811,0),(4428,30,1811,0),(4429,34,1811,0),(4430,2,1811,0),(4431,26,1812,0),(4432,30,1812,0),(4433,34,1812,0),(4434,2,1812,0),(4435,26,1813,0),(4436,30,1813,0),(4437,34,1813,0),(4438,2,1813,0),(4439,26,1814,0),(4440,30,1814,0),(4441,34,1814,0),(4442,2,1814,0),(4443,26,1815,0),(4444,30,1815,0),(4445,34,1815,0),(4446,2,1815,0),(4447,26,1816,0),(4448,30,1816,0),(4449,34,1816,0),(4450,2,1816,0),(4451,26,1817,0),(4452,30,1817,0),(4453,34,1817,0),(4454,2,1817,0),(4455,26,1818,0),(4456,30,1818,0),(4457,34,1818,0),(4458,2,1818,0),(4459,27,1819,0),(4460,32,1819,0),(4461,35,1819,0),(4462,2,1819,0),(4463,27,1820,0),(4464,32,1820,0),(4465,35,1820,0),(4466,2,1820,0),(4467,27,1821,0),(4468,32,1821,0),(4469,35,1821,0),(4470,2,1821,0),(4471,27,1822,0),(4472,32,1822,0),(4473,35,1822,0),(4474,2,1822,0),(4475,27,1823,0),(4476,32,1823,0),(4477,35,1823,0),(4478,2,1823,0),(4479,27,1824,0),(4480,32,1824,0),(4481,35,1824,0),(4482,2,1824,0),(4483,27,1825,0),(4484,32,1825,0),(4485,35,1825,0),(4486,2,1825,0),(4487,27,1826,0),(4488,32,1826,0),(4489,35,1826,0),(4490,2,1826,0),(4491,27,1827,0),(4492,32,1827,0),(4493,35,1827,0),(4494,2,1827,0),(4495,27,1828,0),(4496,32,1828,0),(4497,35,1828,0),(4498,2,1828,0),(4499,27,1829,0),(4500,32,1829,0),(4501,35,1829,0),(4502,2,1829,0),(4503,27,1830,0),(4504,32,1830,0),(4505,35,1830,0),(4506,2,1830,0),(4507,27,1831,0),(4508,32,1831,0),(4509,35,1831,0),(4510,2,1831,0),(4511,27,1832,0),(4512,32,1832,0),(4513,35,1832,0),(4514,2,1832,0),(4515,27,1833,0),(4516,32,1833,0),(4517,8,1833,0),(4518,2,1833,0),(4519,27,1834,0),(4520,32,1834,0),(4521,8,1834,0),(4522,2,1834,0),(4523,27,1835,0),(4524,32,1835,0),(4525,8,1835,0),(4526,2,1835,0),(4527,27,1836,0),(4528,32,1836,0),(4529,8,1836,0),(4530,2,1836,0),(4531,27,1837,0),(4532,32,1837,0),(4533,8,1837,0),(4534,2,1837,0),(4535,27,1838,0),(4536,32,1838,0),(4537,8,1838,0),(4538,2,1838,0),(4539,27,1839,0),(4540,32,1839,0),(4541,8,1839,0),(4542,2,1839,0),(4543,27,1840,0),(4544,32,1840,0),(4545,2,1840,0),(4546,27,1841,0),(4547,32,1841,0),(4548,2,1841,0),(4549,27,1842,0),(4550,32,1842,0),(4551,2,1842,0),(4552,27,1843,0),(4553,32,1843,0),(4554,2,1843,0),(4555,27,1844,0),(4556,32,1844,0),(4557,2,1844,0),(4558,27,1845,0),(4559,32,1845,0),(4560,2,1845,0),(4561,27,1846,0),(4562,32,1846,0),(4563,2,1846,0),(4564,27,1847,0),(4565,32,1847,0),(4566,34,1847,0),(4567,2,1847,0),(4568,27,1848,0),(4569,32,1848,0),(4570,34,1848,0),(4571,2,1848,0),(4572,27,1849,0),(4573,32,1849,0),(4574,34,1849,0),(4575,2,1849,0),(4576,27,1850,0),(4577,32,1850,0),(4578,34,1850,0),(4579,2,1850,0),(4580,27,1851,0),(4581,32,1851,0),(4582,34,1851,0),(4583,2,1851,0),(4584,27,1852,0),(4585,32,1852,0),(4586,34,1852,0),(4587,2,1852,0),(4588,27,1853,0),(4589,32,1853,0),(4590,34,1853,0),(4591,2,1853,0),(4592,27,1854,0),(4593,32,1854,0),(4594,34,1854,0),(4595,2,1854,0),(4596,27,1855,0),(4597,32,1855,0),(4598,34,1855,0),(4599,2,1855,0),(4600,27,1856,0),(4601,32,1856,0),(4602,34,1856,0),(4603,2,1856,0),(4604,27,1857,0),(4605,32,1857,0),(4606,34,1857,0),(4607,2,1857,0),(4608,27,1858,0),(4609,32,1858,0),(4610,34,1858,0),(4611,2,1858,0),(4612,27,1859,0),(4613,32,1859,0),(4614,34,1859,0),(4615,2,1859,0),(4616,27,1860,0),(4617,32,1860,0),(4618,34,1860,0),(4619,2,1860,0),(4620,27,1861,0),(4621,32,1861,0),(4622,35,1861,0),(4623,2,1861,0),(4624,27,1862,0),(4625,32,1862,0),(4626,35,1862,0),(4627,2,1862,0),(4628,27,1863,0),(4629,32,1863,0),(4630,35,1863,0),(4631,2,1863,0),(4632,27,1864,0),(4633,32,1864,0),(4634,35,1864,0),(4635,2,1864,0),(4636,27,1865,0),(4637,32,1865,0),(4638,35,1865,0),(4639,2,1865,0),(4640,27,1866,0),(4641,32,1866,0),(4642,35,1866,0),(4643,2,1866,0),(4644,27,1867,0),(4645,32,1867,0),(4646,35,1867,0),(4647,2,1867,0),(4648,27,1868,0),(4649,32,1868,0),(4650,2,1868,0),(4651,27,1869,0),(4652,32,1869,0),(4653,2,1869,0),(4654,27,1870,0),(4655,32,1870,0),(4656,2,1870,0),(4657,27,1871,0),(4658,32,1871,0),(4659,2,1871,0),(4660,27,1872,0),(4661,32,1872,0),(4662,2,1872,0),(4663,27,1873,0),(4664,32,1873,0),(4665,2,1873,0),(4666,27,1874,0),(4667,32,1874,0),(4668,2,1874,0),(4669,27,1875,0),(4670,32,1875,0),(4671,2,1875,0),(4672,27,1876,0),(4673,32,1876,0),(4674,2,1876,0),(4675,27,1877,0),(4676,32,1877,0),(4677,2,1877,0),(4678,27,1878,0),(4679,32,1878,0),(4680,2,1878,0),(4681,27,1879,0),(4682,32,1879,0),(4683,2,1879,0),(4684,27,1880,0),(4685,32,1880,0),(4686,2,1880,0),(4687,27,1881,0),(4688,32,1881,0),(4689,2,1881,0),(4690,27,1882,0),(4691,32,1882,0),(4692,36,1882,0),(4693,2,1882,0),(4694,27,1883,0),(4695,32,1883,0),(4696,36,1883,0),(4697,2,1883,0),(4698,27,1884,0),(4699,32,1884,0),(4700,36,1884,0),(4701,2,1884,0),(4702,27,1885,0),(4703,32,1885,0),(4704,36,1885,0),(4705,2,1885,0),(4706,27,1886,0),(4707,32,1886,0),(4708,36,1886,0),(4709,2,1886,0),(4710,27,1887,0),(4711,32,1887,0),(4712,36,1887,0),(4713,2,1887,0),(4714,27,1888,0),(4715,32,1888,0),(4716,36,1888,0),(4717,2,1888,0),(4718,27,1889,0),(4719,32,1889,0),(4720,2,1889,0),(4721,27,1890,0),(4722,32,1890,0),(4723,2,1890,0),(4724,27,1891,0),(4725,32,1891,0),(4726,2,1891,0),(4727,27,1892,0),(4728,32,1892,0),(4729,2,1892,0),(4730,27,1893,0),(4731,32,1893,0),(4732,2,1893,0),(4733,27,1894,0),(4734,32,1894,0),(4735,2,1894,0),(4736,27,1895,0),(4737,32,1895,0),(4738,2,1895,0),(4739,27,1896,0),(4740,32,1896,0),(4741,35,1896,0),(4742,2,1896,0),(4743,27,1897,0),(4744,32,1897,0),(4745,35,1897,0),(4746,2,1897,0),(4747,27,1898,0),(4748,32,1898,0),(4749,35,1898,0),(4750,2,1898,0),(4751,27,1899,0),(4752,32,1899,0),(4753,35,1899,0),(4754,2,1899,0),(4755,27,1900,0),(4756,32,1900,0),(4757,35,1900,0),(4758,2,1900,0),(4759,27,1901,0),(4760,32,1901,0),(4761,35,1901,0),(4762,2,1901,0),(4763,27,1902,0),(4764,32,1902,0),(4765,35,1902,0),(4766,2,1902,0),(4767,27,1903,0),(4768,32,1903,0),(4769,34,1903,0),(4770,2,1903,0),(4771,27,1904,0),(4772,32,1904,0),(4773,34,1904,0),(4774,2,1904,0),(4775,27,1905,0),(4776,32,1905,0),(4777,34,1905,0),(4778,2,1905,0),(4779,27,1906,0),(4780,32,1906,0),(4781,34,1906,0),(4782,2,1906,0),(4783,27,1907,0),(4784,32,1907,0),(4785,34,1907,0),(4786,2,1907,0),(4787,27,1908,0),(4788,32,1908,0),(4789,34,1908,0),(4790,2,1908,0),(4791,27,1909,0),(4792,32,1909,0),(4793,34,1909,0),(4794,2,1909,0),(4795,28,1910,0),(4796,8,1910,0),(4797,36,1910,0),(4798,2,1910,0),(4799,28,1911,0),(4800,8,1911,0),(4801,36,1911,0),(4802,2,1911,0),(4803,28,1912,0),(4804,8,1912,0),(4805,36,1912,0),(4806,2,1912,0),(4807,28,1913,0),(4808,8,1913,0),(4809,36,1913,0),(4810,2,1913,0),(4811,28,1914,0),(4812,8,1914,0),(4813,36,1914,0),(4814,2,1914,0),(4815,28,1915,0),(4816,8,1915,0),(4817,36,1915,0),(4818,2,1915,0),(4819,28,1916,0),(4820,8,1916,0),(4821,36,1916,0),(4822,2,1916,0),(4823,28,1917,0),(4824,8,1917,0),(4825,36,1917,0),(4826,2,1917,0),(4827,28,1918,0),(4828,8,1918,0),(4829,36,1918,0),(4830,2,1918,0),(4831,28,1919,0),(4832,8,1919,0),(4833,36,1919,0),(4834,2,1919,0),(4835,28,1920,0),(4836,8,1920,0),(4837,36,1920,0),(4838,2,1920,0),(4839,28,1921,0),(4840,8,1921,0),(4841,36,1921,0),(4842,2,1921,0),(4843,28,1922,0),(4844,8,1922,0),(4845,36,1922,0),(4846,2,1922,0),(4847,28,1923,0),(4848,8,1923,0),(4849,36,1923,0),(4850,2,1923,0),(4851,28,1924,0),(4852,8,1924,0),(4853,36,1924,0),(4854,2,1924,0),(4855,28,1925,0),(4856,8,1925,0),(4857,36,1925,0),(4858,2,1925,0),(4859,28,1926,0),(4860,30,1926,0),(4861,2,1926,0),(4862,28,1927,0),(4863,30,1927,0),(4864,2,1927,0),(4865,28,1928,0),(4866,30,1928,0),(4867,2,1928,0),(4868,28,1929,0),(4869,30,1929,0),(4870,2,1929,0),(4871,28,1930,0),(4872,30,1930,0),(4873,2,1930,0),(4874,28,1931,0),(4875,30,1931,0),(4876,2,1931,0),(4877,28,1932,0),(4878,30,1932,0),(4879,2,1932,0),(4880,28,1933,0),(4881,30,1933,0),(4882,2,1933,0),(4883,28,1934,0),(4884,30,1934,0),(4885,2,1934,0),(4886,28,1935,0),(4887,30,1935,0),(4888,2,1935,0),(4889,28,1936,0),(4890,30,1936,0),(4891,2,1936,0),(4892,28,1937,0),(4893,30,1937,0),(4894,2,1937,0),(4895,28,1938,0),(4896,30,1938,0),(4897,2,1938,0),(4898,28,1939,0),(4899,30,1939,0),(4900,2,1939,0),(4901,28,1940,0),(4902,30,1940,0),(4903,2,1940,0),(4904,28,1941,0),(4905,30,1941,0),(4906,2,1941,0),(4907,28,1942,0),(4908,8,1942,0),(4909,35,1942,0),(4910,2,1942,0),(4911,28,1943,0),(4912,8,1943,0),(4913,35,1943,0),(4914,2,1943,0),(4915,28,1944,0),(4916,8,1944,0),(4917,35,1944,0),(4918,2,1944,0),(4919,28,1945,0),(4920,8,1945,0),(4921,35,1945,0),(4922,2,1945,0),(4923,28,1946,0),(4924,8,1946,0),(4925,35,1946,0),(4926,2,1946,0),(4927,28,1947,0),(4928,8,1947,0),(4929,35,1947,0),(4930,2,1947,0),(4931,28,1948,0),(4932,8,1948,0),(4933,35,1948,0),(4934,2,1948,0),(4935,28,1949,0),(4936,8,1949,0),(4937,35,1949,0),(4938,2,1949,0),(4939,28,1950,0),(4940,8,1950,0),(4941,35,1950,0),(4942,2,1950,0),(4943,28,1951,0),(4944,8,1951,0),(4945,35,1951,0),(4946,2,1951,0),(4947,28,1952,0),(4948,8,1952,0),(4949,35,1952,0),(4950,2,1952,0),(4951,28,1953,0),(4952,8,1953,0),(4953,35,1953,0),(4954,2,1953,0),(4955,28,1954,0),(4956,8,1954,0),(4957,35,1954,0),(4958,2,1954,0),(4959,28,1955,0),(4960,8,1955,0),(4961,35,1955,0),(4962,2,1955,0),(4963,28,1956,0),(4964,8,1956,0),(4965,35,1956,0),(4966,2,1956,0),(4967,28,1957,0),(4968,8,1957,0),(4969,35,1957,0),(4970,2,1957,0),(4971,28,1958,0),(4972,28,1959,0),(4973,28,1960,0),(4974,28,1961,0),(4975,28,1962,0),(4976,28,1963,0),(4977,28,1964,0),(4978,28,1965,0),(4979,28,1966,0),(4980,28,1967,0),(4981,28,1968,0),(4982,28,1969,0),(4983,28,1970,0),(4984,28,1971,0),(4985,28,1972,0),(4986,28,1973,0),(4987,28,1974,0),(4988,30,1974,0),(4989,2,1974,0),(4990,28,1975,0),(4991,30,1975,0),(4992,2,1975,0),(4993,28,1976,0),(4994,30,1976,0),(4995,2,1976,0),(4996,28,1977,0),(4997,30,1977,0),(4998,2,1977,0),(4999,28,1978,0),(5000,30,1978,0),(5001,2,1978,0),(5002,28,1979,0),(5003,30,1979,0),(5004,2,1979,0),(5005,28,1980,0),(5006,30,1980,0),(5007,2,1980,0),(5008,28,1981,0),(5009,30,1981,0),(5010,2,1981,0),(5011,28,1982,0),(5012,30,1982,0),(5013,2,1982,0),(5014,28,1983,0),(5015,30,1983,0),(5016,2,1983,0),(5017,28,1984,0),(5018,30,1984,0),(5019,2,1984,0),(5020,28,1985,0),(5021,30,1985,0),(5022,2,1985,0),(5023,28,1986,0),(5024,30,1986,0),(5025,2,1986,0),(5026,28,1987,0),(5027,30,1987,0),(5028,2,1987,0),(5029,28,1988,0),(5030,30,1988,0),(5031,2,1988,0),(5032,28,1989,0),(5033,30,1989,0),(5034,2,1989,0),(5035,28,1990,0),(5036,28,1991,0),(5037,28,1992,0),(5038,28,1993,0),(5039,28,1994,0),(5040,28,1995,0),(5041,28,1996,0),(5042,28,1997,0),(5043,8,1997,0),(5044,2,1997,0),(5045,28,1998,0),(5046,8,1998,0),(5047,2,1998,0),(5048,28,1999,0),(5049,8,1999,0),(5050,2,1999,0),(5051,28,2000,0),(5052,8,2000,0),(5053,2,2000,0),(5054,28,2001,0),(5055,8,2001,0),(5056,2,2001,0),(5057,28,2002,0),(5058,8,2002,0),(5059,2,2002,0),(5060,28,2003,0),(5061,8,2003,0),(5062,2,2003,0),(5063,28,2004,0),(5064,35,2004,0),(5065,2,2004,0),(5066,28,2005,0),(5067,35,2005,0),(5068,2,2005,0),(5069,28,2006,0),(5070,35,2006,0),(5071,2,2006,0),(5072,28,2007,0),(5073,35,2007,0),(5074,2,2007,0),(5075,28,2008,0),(5076,35,2008,0),(5077,2,2008,0),(5078,28,2009,0),(5079,35,2009,0),(5080,2,2009,0),(5081,28,2010,0),(5082,28,2011,0),(5083,28,2012,0),(5084,28,2013,0),(5085,28,2014,0),(5086,28,2015,0),(5087,28,2016,0),(5088,28,2017,0),(5089,36,2017,0),(5090,2,2017,0),(5091,28,2018,0),(5092,36,2018,0),(5093,2,2018,0),(5094,28,2019,0),(5095,36,2019,0),(5096,2,2019,0),(5097,28,2020,0),(5098,36,2020,0),(5099,2,2020,0),(5100,28,2021,0),(5101,36,2021,0),(5102,2,2021,0),(5103,28,2022,0),(5104,36,2022,0),(5105,2,2022,0),(5106,28,2023,0),(5107,36,2023,0),(5108,2,2023,0),(5109,28,2024,0),(5110,34,2024,0),(5111,2,2024,0),(5112,28,2025,0),(5113,34,2025,0),(5114,2,2025,0),(5115,28,2026,0),(5116,34,2026,0),(5117,2,2026,0),(5118,28,2027,0),(5119,34,2027,0),(5120,2,2027,0),(5121,28,2028,0),(5122,34,2028,0),(5123,2,2028,0),(5124,28,2029,0),(5125,34,2029,0),(5126,2,2029,0),(5127,28,2030,0),(5128,34,2030,0),(5129,2,2030,0),(5130,28,2031,0),(5131,34,2031,0),(5132,2,2031,0),(5133,28,2032,0),(5134,34,2032,0),(5135,2,2032,0),(5136,28,2033,0),(5137,34,2033,0),(5138,2,2033,0),(5139,28,2034,0),(5140,34,2034,0),(5141,2,2034,0),(5142,28,2035,0),(5143,34,2035,0),(5144,2,2035,0),(5145,28,2036,0),(5146,34,2036,0),(5147,2,2036,0),(5148,28,2037,0),(5149,34,2037,0),(5150,2,2037,0),(5151,28,2038,0),(5152,34,2038,0),(5153,2,2038,0),(5154,28,2039,0),(5155,34,2039,0),(5156,2,2039,0),(5157,28,2040,0),(5158,34,2040,0),(5159,2,2040,0),(5160,28,2041,0),(5161,34,2041,0),(5162,2,2041,0),(5163,28,2042,0),(5164,34,2042,0),(5165,2,2042,0),(5166,28,2043,0),(5167,34,2043,0),(5168,2,2043,0),(5169,28,2044,0),(5170,34,2044,0),(5171,2,2044,0),(5172,28,2045,0),(5173,34,2045,0),(5174,2,2045,0),(5175,28,2046,0),(5176,34,2046,0),(5177,2,2046,0);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_BB4A590114301ED9D94C8239D3EF6DA8` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index_replica`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index_replica` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_BB4A590114301ED9D94C8239D3EF6DA8` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index_replica`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index_replica` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_replica` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index_store1`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index_store1`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index_store1` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_CTGR_PRD_IDX_STORE1_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_EAA97D781ECAB4B7D46CE05989FB5FCE` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Prmg Catalog Category Product Index Store1';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index_store1`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index_store1` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_store1` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_product_index_store1` VALUES (2,1,0,1,1,4),(2,2,0,1,1,4),(2,3,0,1,1,4),(2,4,0,1,1,4),(2,5,0,1,1,4),(2,6,0,1,1,4),(2,7,0,1,1,4),(2,8,0,1,1,4),(2,9,0,1,1,4),(2,10,0,1,1,4),(2,11,0,1,1,4),(2,12,0,1,1,4),(2,13,0,1,1,4),(2,14,0,1,1,4),(2,15,0,1,1,4),(2,16,0,1,1,4),(2,17,0,1,1,4),(2,18,0,1,1,4),(2,19,0,1,1,4),(2,20,0,1,1,4),(2,21,0,1,1,4),(2,22,0,1,1,4),(2,23,0,1,1,4),(2,36,0,1,1,4),(2,37,0,1,1,4),(2,38,0,1,1,4),(2,39,0,1,1,4),(2,40,0,1,1,4),(2,41,0,1,1,4),(2,42,0,1,1,4),(2,43,0,1,1,4),(2,44,0,1,1,4),(2,45,0,1,1,4),(2,46,0,1,1,4),(2,47,0,1,1,4),(2,48,0,1,1,4),(2,49,0,1,1,4),(2,50,0,1,1,4),(2,51,0,1,1,4),(2,52,0,1,1,4),(2,68,0,1,1,4),(2,84,0,1,1,4),(2,100,0,1,1,4),(2,116,0,1,1,4),(2,132,0,1,1,4),(2,148,0,1,1,4),(2,164,0,1,1,4),(2,180,0,1,1,4),(2,196,0,1,1,4),(2,212,0,1,1,4),(2,228,0,1,1,4),(2,244,0,1,1,4),(2,260,0,1,1,4),(2,276,0,1,1,4),(2,292,0,1,1,4),(2,308,0,1,1,4),(2,324,0,1,1,4),(2,340,0,1,1,4),(2,356,0,1,1,4),(2,372,0,1,1,4),(2,388,0,1,1,4),(2,404,0,1,1,4),(2,420,0,1,1,4),(2,436,0,1,1,4),(2,452,0,1,1,4),(2,468,0,1,1,4),(2,484,0,1,1,4),(2,500,0,1,1,4),(2,516,0,1,1,4),(2,532,0,1,1,4),(2,548,0,1,1,4),(2,564,0,1,1,4),(2,580,0,1,1,4),(2,596,0,1,1,4),(2,612,0,1,1,4),(2,628,0,1,1,4),(2,644,0,1,1,4),(2,660,0,1,1,4),(2,676,0,1,1,4),(2,682,0,1,1,4),(2,688,0,1,1,4),(2,694,0,1,1,4),(2,700,0,1,1,4),(2,706,0,1,1,4),(2,712,0,1,1,4),(2,718,0,1,1,4),(2,724,0,1,1,4),(2,730,0,1,1,4),(2,743,0,1,1,4),(2,756,0,1,1,4),(2,769,0,1,1,4),(2,782,0,1,1,4),(2,795,0,1,1,4),(2,808,0,1,1,4),(2,821,0,1,1,4),(2,834,0,1,1,4),(2,847,0,1,1,4),(2,860,0,1,1,4),(2,873,0,1,1,4),(2,886,0,1,1,4),(2,899,0,1,1,4),(2,904,0,1,1,4),(2,917,0,1,1,4),(2,930,0,1,1,4),(2,943,0,1,1,4),(2,956,0,1,1,4),(2,969,0,1,1,4),(2,982,0,1,1,4),(2,995,0,1,1,4),(2,1008,0,1,1,4),(2,1021,0,1,1,4),(2,1034,0,1,1,4),(2,1050,0,1,1,4),(2,1066,0,1,1,4),(2,1082,0,1,1,4),(2,1098,0,1,1,4),(2,1114,0,1,1,4),(2,1120,0,1,1,4),(2,1136,0,1,1,4),(2,1152,0,1,1,4),(2,1168,0,1,1,4),(2,1184,0,1,1,4),(2,1200,0,1,1,4),(2,1216,0,1,1,4),(2,1226,0,1,1,4),(2,1242,0,1,1,4),(2,1258,0,1,1,4),(2,1274,0,1,1,4),(2,1290,0,1,1,4),(2,1306,0,1,1,4),(2,1322,0,1,1,4),(2,1338,0,1,1,4),(2,1354,0,1,1,4),(2,1370,0,1,1,4),(2,1386,0,1,1,4),(2,1402,0,1,1,4),(2,1418,0,1,1,4),(2,1434,0,1,1,4),(2,1450,0,1,1,4),(2,1466,0,1,1,4),(2,1482,0,1,1,4),(2,1498,0,1,1,4),(2,1514,0,1,1,4),(2,1530,0,1,1,4),(2,1546,0,1,1,4),(2,1562,0,1,1,4),(2,1578,0,1,1,4),(2,1594,0,1,1,4),(2,1610,0,1,1,4),(2,1626,0,1,1,4),(2,1642,0,1,1,4),(2,1658,0,1,1,4),(2,1674,0,1,1,4),(2,1690,0,1,1,4),(2,1706,0,1,1,4),(2,1722,0,1,1,4),(2,1738,0,1,1,4),(2,1754,0,1,1,4),(2,1770,0,1,1,4),(2,1786,0,1,1,4),(2,1802,0,1,1,4),(2,1818,0,1,1,4),(2,1825,0,1,1,4),(2,1832,0,1,1,4),(2,1839,0,1,1,4),(2,1846,0,1,1,4),(2,1853,0,1,1,4),(2,1860,0,1,1,4),(2,1867,0,1,1,4),(2,1874,0,1,1,4),(2,1881,0,1,1,4),(2,1888,0,1,1,4),(2,1895,0,1,1,4),(2,1902,0,1,1,4),(2,1909,0,1,1,4),(2,1925,0,1,1,4),(2,1941,0,1,1,4),(2,1957,0,1,1,4),(2,1973,0,1,1,4),(2,1989,0,1,1,4),(2,1996,0,1,1,4),(2,2003,0,1,1,4),(2,2009,0,1,1,4),(2,2016,0,1,1,4),(2,2023,0,1,1,4),(2,2030,0,1,1,4),(2,2046,0,1,1,4),(3,1,0,1,1,4),(3,2,0,1,1,4),(3,3,0,1,1,4),(3,4,0,1,1,4),(3,5,0,1,1,4),(3,6,0,1,1,4),(3,7,0,1,1,4),(3,8,0,1,1,4),(3,9,0,1,1,4),(3,10,0,1,1,4),(3,11,0,1,1,4),(3,12,0,1,1,4),(3,13,0,1,1,4),(3,14,0,1,1,4),(3,15,0,1,1,4),(3,16,0,1,1,4),(3,17,0,1,1,4),(3,18,0,1,1,4),(3,19,0,1,1,4),(3,20,0,1,1,4),(3,21,0,1,1,4),(3,22,0,1,1,4),(3,23,0,1,1,4),(3,36,0,1,1,4),(3,37,0,1,1,4),(3,38,0,1,1,4),(3,39,0,1,1,4),(3,40,0,1,1,4),(3,41,0,1,1,4),(3,42,0,1,1,4),(3,43,0,1,1,4),(3,44,0,1,1,4),(3,45,0,1,1,4),(3,46,0,1,1,4),(4,1,0,1,1,4),(4,2,0,1,1,4),(4,3,0,1,1,4),(4,4,0,1,1,4),(4,5,0,1,1,4),(4,6,0,1,1,4),(4,7,0,1,1,4),(4,8,0,1,1,4),(4,9,0,1,1,4),(4,10,0,1,1,4),(4,11,0,1,1,4),(4,12,0,1,1,4),(4,13,0,1,1,4),(4,14,0,1,1,4),(5,15,0,1,1,4),(5,16,0,1,1,4),(5,17,0,1,1,4),(5,18,0,1,1,4),(5,19,0,1,1,4),(5,20,0,1,1,4),(5,21,0,1,1,4),(5,22,0,1,1,4),(5,23,0,1,1,4),(5,45,0,1,1,4),(5,46,0,1,1,4),(6,36,0,1,1,4),(6,37,0,1,1,4),(6,38,0,1,1,4),(6,39,0,1,1,4),(6,40,0,1,1,4),(6,41,0,1,1,4),(6,42,0,1,1,4),(6,43,0,1,1,4),(6,44,0,1,1,4),(7,2,0,1,1,4),(7,4,0,1,1,4),(7,5,0,1,1,4),(7,10,0,1,1,4),(7,11,0,1,1,4),(7,13,0,1,1,4),(7,14,0,1,1,4),(7,16,0,1,1,4),(7,19,0,1,1,4),(7,38,0,1,1,4),(7,39,0,1,1,4),(7,40,0,1,1,4),(7,44,0,1,1,4),(8,4,0,1,1,4),(8,5,0,1,1,4),(8,13,0,1,1,4),(8,19,0,1,1,4),(8,38,0,1,1,4),(8,39,0,1,1,4),(8,40,0,1,1,4),(8,44,0,1,1,4),(8,769,0,1,1,4),(8,795,0,1,1,4),(8,821,0,1,1,4),(8,834,0,1,1,4),(8,847,0,1,1,4),(8,956,0,1,1,4),(8,1008,0,1,1,4),(8,1050,0,1,1,4),(8,1136,0,1,1,4),(8,1184,0,1,1,4),(8,1226,0,1,1,4),(8,1274,0,1,1,4),(8,1354,0,1,1,4),(8,1370,0,1,1,4),(8,1418,0,1,1,4),(8,1450,0,1,1,4),(8,1466,0,1,1,4),(8,1482,0,1,1,4),(8,1642,0,1,1,4),(8,1722,0,1,1,4),(8,1839,0,1,1,4),(8,1925,0,1,1,4),(8,1957,0,1,1,4),(8,2003,0,1,1,4),(9,47,0,1,1,4),(9,48,0,1,1,4),(9,49,0,1,1,4),(9,50,0,1,1,4),(9,51,0,1,1,4),(9,52,0,1,1,4),(10,47,0,1,1,4),(10,48,0,1,1,4),(10,49,0,1,1,4),(10,50,0,1,1,4),(10,51,0,1,1,4),(10,52,0,1,1,4),(12,68,10000,0,1,4),(12,84,10000,0,1,4),(12,100,10000,0,1,4),(12,116,10000,0,1,4),(12,132,10000,0,1,4),(12,148,10000,0,1,4),(12,164,10000,0,1,4),(12,180,10000,0,1,4),(12,196,10000,0,1,4),(12,212,10000,0,1,4),(12,228,10000,0,1,4),(12,244,10000,0,1,4),(12,260,10000,0,1,4),(12,276,10000,0,1,4),(12,292,10000,0,1,4),(12,308,10000,0,1,4),(12,324,10000,0,1,4),(12,340,10000,0,1,4),(12,356,10000,0,1,4),(12,372,10000,0,1,4),(12,388,10000,0,1,4),(12,404,10000,0,1,4),(12,420,10000,0,1,4),(12,436,10000,0,1,4),(12,452,10000,0,1,4),(12,468,10000,0,1,4),(12,484,10000,0,1,4),(12,500,10000,0,1,4),(12,516,10000,0,1,4),(12,532,10000,0,1,4),(12,548,10000,0,1,4),(12,564,10000,0,1,4),(12,580,10000,0,1,4),(12,596,10000,0,1,4),(12,612,10000,0,1,4),(12,628,10000,0,1,4),(12,644,10000,0,1,4),(12,660,10000,0,1,4),(12,676,10000,0,1,4),(12,682,10000,0,1,4),(12,688,10000,0,1,4),(12,694,10000,0,1,4),(12,700,10000,0,1,4),(12,706,10000,0,1,4),(12,712,10000,0,1,4),(12,718,10000,0,1,4),(12,724,10000,0,1,4),(12,730,10000,0,1,4),(13,743,10000,0,1,4),(13,756,10000,0,1,4),(13,769,10000,0,1,4),(13,782,10000,0,1,4),(13,795,10000,0,1,4),(13,808,10000,0,1,4),(13,821,10000,0,1,4),(13,834,10000,0,1,4),(13,847,10000,0,1,4),(13,860,10000,0,1,4),(13,873,10000,0,1,4),(13,886,10000,0,1,4),(13,899,10000,0,1,4),(13,904,10000,0,1,4),(13,917,10000,0,1,4),(13,930,10000,0,1,4),(13,943,10000,0,1,4),(13,956,10000,0,1,4),(13,969,10000,0,1,4),(13,982,10000,0,1,4),(13,995,10000,0,1,4),(13,1008,10000,0,1,4),(13,1021,10000,0,1,4),(13,1034,10000,0,1,4),(14,276,0,1,1,4),(14,292,0,1,1,4),(14,308,0,1,1,4),(14,324,0,1,1,4),(14,340,0,1,1,4),(14,356,0,1,1,4),(14,372,0,1,1,4),(14,388,0,1,1,4),(14,404,0,1,1,4),(14,420,0,1,1,4),(14,436,0,1,1,4),(15,68,0,1,1,4),(15,84,0,1,1,4),(15,100,0,1,1,4),(15,116,0,1,1,4),(15,132,0,1,1,4),(15,148,0,1,1,4),(15,164,0,1,1,4),(15,180,0,1,1,4),(15,196,0,1,1,4),(15,212,0,1,1,4),(15,228,0,1,1,4),(15,244,0,1,1,4),(15,260,0,1,1,4),(16,452,0,1,1,4),(16,468,0,1,1,4),(16,484,0,1,1,4),(16,500,0,1,1,4),(16,516,0,1,1,4),(16,532,0,1,1,4),(16,548,0,1,1,4),(16,564,0,1,1,4),(16,580,0,1,1,4),(16,596,0,1,1,4),(16,612,0,1,1,4),(16,628,0,1,1,4),(17,644,0,1,1,4),(17,660,0,1,1,4),(17,676,0,1,1,4),(17,682,0,1,1,4),(17,688,0,1,1,4),(17,694,0,1,1,4),(17,700,0,1,1,4),(17,706,0,1,1,4),(17,712,0,1,1,4),(17,718,0,1,1,4),(17,724,0,1,1,4),(17,730,0,1,1,4),(18,743,0,1,1,4),(18,756,0,1,1,4),(18,769,0,1,1,4),(18,782,0,1,1,4),(18,795,0,1,1,4),(18,808,0,1,1,4),(18,821,0,1,1,4),(18,834,0,1,1,4),(18,847,0,1,1,4),(18,860,0,1,1,4),(18,873,0,1,1,4),(18,886,0,1,1,4),(19,899,0,1,1,4),(19,904,0,1,1,4),(19,917,0,1,1,4),(19,930,0,1,1,4),(19,943,0,1,1,4),(19,956,0,1,1,4),(19,969,0,1,1,4),(19,982,0,1,1,4),(19,995,0,1,1,4),(19,1008,0,1,1,4),(19,1021,0,1,1,4),(19,1034,0,1,1,4),(21,1050,10000,0,1,4),(21,1066,10000,0,1,4),(21,1082,10000,0,1,4),(21,1098,10000,0,1,4),(21,1114,10000,0,1,4),(21,1120,10000,0,1,4),(21,1136,10000,0,1,4),(21,1152,10000,0,1,4),(21,1168,10000,0,1,4),(21,1184,10000,0,1,4),(21,1200,10000,0,1,4),(21,1216,10000,0,1,4),(21,1226,10000,0,1,4),(21,1242,10000,0,1,4),(21,1258,10000,0,1,4),(21,1274,10000,0,1,4),(21,1290,10000,0,1,4),(21,1306,10000,0,1,4),(21,1322,10000,0,1,4),(21,1338,10000,0,1,4),(21,1354,10000,0,1,4),(21,1370,10000,0,1,4),(21,1386,10000,0,1,4),(21,1402,10000,0,1,4),(21,1418,10000,0,1,4),(21,1434,10000,0,1,4),(21,1450,10000,0,1,4),(21,1466,10000,0,1,4),(21,1482,10000,0,1,4),(21,1498,10000,0,1,4),(21,1514,10000,0,1,4),(21,1530,10000,0,1,4),(21,1546,10000,0,1,4),(21,1562,10000,0,1,4),(21,1578,10000,0,1,4),(21,1594,10000,0,1,4),(21,1610,10000,0,1,4),(21,1626,10000,0,1,4),(21,1642,10000,0,1,4),(21,1658,10000,0,1,4),(21,1674,10000,0,1,4),(21,1690,10000,0,1,4),(21,1706,10000,0,1,4),(21,1722,10000,0,1,4),(21,1738,10000,0,1,4),(21,1754,10000,0,1,4),(21,1770,10000,0,1,4),(21,1786,10000,0,1,4),(21,1802,10000,0,1,4),(21,1818,10000,0,1,4),(22,1825,10000,0,1,4),(22,1832,10000,0,1,4),(22,1839,10000,0,1,4),(22,1846,10000,0,1,4),(22,1853,10000,0,1,4),(22,1860,10000,0,1,4),(22,1867,10000,0,1,4),(22,1874,10000,0,1,4),(22,1881,10000,0,1,4),(22,1888,10000,0,1,4),(22,1895,10000,0,1,4),(22,1902,10000,0,1,4),(22,1909,10000,0,1,4),(22,1925,10000,0,1,4),(22,1941,10000,0,1,4),(22,1957,10000,0,1,4),(22,1973,10000,0,1,4),(22,1989,10000,0,1,4),(22,1996,10000,0,1,4),(22,2003,10000,0,1,4),(22,2009,10000,0,1,4),(22,2016,10000,0,1,4),(22,2023,10000,0,1,4),(22,2030,10000,0,1,4),(22,2046,10000,0,1,4),(23,1226,0,1,1,4),(23,1242,0,1,1,4),(23,1258,0,1,1,4),(23,1274,0,1,1,4),(23,1290,0,1,1,4),(23,1306,0,1,1,4),(23,1322,0,1,1,4),(23,1338,0,1,1,4),(23,1354,0,1,1,4),(23,1370,0,1,1,4),(23,1386,0,1,1,4),(23,1402,0,1,1,4),(24,1050,0,1,1,4),(24,1066,0,1,1,4),(24,1082,0,1,1,4),(24,1098,0,1,1,4),(24,1114,0,1,1,4),(24,1120,0,1,1,4),(24,1136,0,1,1,4),(24,1152,0,1,1,4),(24,1168,0,1,1,4),(24,1184,0,1,1,4),(24,1200,0,1,1,4),(24,1216,0,1,1,4),(25,1418,0,1,1,4),(25,1434,0,1,1,4),(25,1450,0,1,1,4),(25,1466,0,1,1,4),(25,1482,0,1,1,4),(25,1498,0,1,1,4),(25,1514,0,1,1,4),(25,1530,0,1,1,4),(25,1546,0,1,1,4),(25,1562,0,1,1,4),(25,1578,0,1,1,4),(25,1594,0,1,1,4),(26,1610,0,1,1,4),(26,1626,0,1,1,4),(26,1642,0,1,1,4),(26,1658,0,1,1,4),(26,1674,0,1,1,4),(26,1690,0,1,1,4),(26,1706,0,1,1,4),(26,1722,0,1,1,4),(26,1738,0,1,1,4),(26,1754,0,1,1,4),(26,1770,0,1,1,4),(26,1786,0,1,1,4),(26,1802,0,1,1,4),(26,1818,0,1,1,4),(27,1825,0,1,1,4),(27,1832,0,1,1,4),(27,1839,0,1,1,4),(27,1846,0,1,1,4),(27,1853,0,1,1,4),(27,1860,0,1,1,4),(27,1867,0,1,1,4),(27,1874,0,1,1,4),(27,1881,0,1,1,4),(27,1888,0,1,1,4),(27,1895,0,1,1,4),(27,1902,0,1,1,4),(27,1909,0,1,1,4),(28,1925,0,1,1,4),(28,1941,0,1,1,4),(28,1957,0,1,1,4),(28,1973,0,1,1,4),(28,1989,0,1,1,4),(28,1996,0,1,1,4),(28,2003,0,1,1,4),(28,2009,0,1,1,4),(28,2016,0,1,1,4),(28,2023,0,1,1,4),(28,2030,0,1,1,4),(28,2046,0,1,1,4),(30,1066,0,1,1,4),(30,1152,0,1,1,4),(30,1242,0,1,1,4),(30,1322,0,1,1,4),(30,1386,0,1,1,4),(30,1402,0,1,1,4),(30,1498,0,1,1,4),(30,1514,0,1,1,4),(30,1546,0,1,1,4),(30,1610,0,1,1,4),(30,1802,0,1,1,4),(30,1818,0,1,1,4),(30,1941,0,1,1,4),(30,1989,0,1,1,4),(31,969,0,1,1,4),(31,982,0,1,1,4),(31,1034,0,1,1,4),(32,743,0,1,1,4),(32,756,0,1,1,4),(32,769,0,1,1,4),(32,782,0,1,1,4),(32,795,0,1,1,4),(32,808,0,1,1,4),(32,821,0,1,1,4),(32,834,0,1,1,4),(32,847,0,1,1,4),(32,860,0,1,1,4),(32,873,0,1,1,4),(32,886,0,1,1,4),(32,1825,0,1,1,4),(32,1832,0,1,1,4),(32,1839,0,1,1,4),(32,1846,0,1,1,4),(32,1853,0,1,1,4),(32,1860,0,1,1,4),(32,1867,0,1,1,4),(32,1874,0,1,1,4),(32,1881,0,1,1,4),(32,1888,0,1,1,4),(32,1895,0,1,1,4),(32,1902,0,1,1,4),(32,1909,0,1,1,4),(33,1418,0,1,1,4),(33,1434,0,1,1,4),(33,1450,0,1,1,4),(33,1466,0,1,1,4),(33,1482,0,1,1,4),(33,1498,0,1,1,4),(33,1514,0,1,1,4),(33,1530,0,1,1,4),(33,1546,0,1,1,4),(33,1562,0,1,1,4),(33,1578,0,1,1,4),(33,1594,0,1,1,4),(34,847,0,1,1,4),(34,860,0,1,1,4),(34,873,0,1,1,4),(34,899,0,1,1,4),(34,969,0,1,1,4),(34,1050,0,1,1,4),(34,1136,0,1,1,4),(34,1200,0,1,1,4),(34,1226,0,1,1,4),(34,1322,0,1,1,4),(34,1338,0,1,1,4),(34,1482,0,1,1,4),(34,1546,0,1,1,4),(34,1722,0,1,1,4),(34,1754,0,1,1,4),(34,1818,0,1,1,4),(34,1853,0,1,1,4),(34,1860,0,1,1,4),(34,1909,0,1,1,4),(34,2030,0,1,1,4),(34,2046,0,1,1,4),(35,756,0,1,1,4),(35,917,0,1,1,4),(35,943,0,1,1,4),(35,995,0,1,1,4),(35,1152,0,1,1,4),(35,1216,0,1,1,4),(35,1274,0,1,1,4),(35,1354,0,1,1,4),(35,1386,0,1,1,4),(35,1402,0,1,1,4),(35,1434,0,1,1,4),(35,1530,0,1,1,4),(35,1562,0,1,1,4),(35,1642,0,1,1,4),(35,1738,0,1,1,4),(35,1786,0,1,1,4),(35,1802,0,1,1,4),(35,1825,0,1,1,4),(35,1832,0,1,1,4),(35,1867,0,1,1,4),(35,1902,0,1,1,4),(35,1957,0,1,1,4),(35,2009,0,1,1,4),(36,68,0,1,1,4),(36,100,0,1,1,4),(36,116,0,1,1,4),(36,308,0,1,1,4),(36,404,0,1,1,4),(36,468,0,1,1,4),(36,700,0,1,1,4),(36,724,0,1,1,4),(36,808,0,1,1,4),(36,1168,0,1,1,4),(36,1450,0,1,1,4),(36,1466,0,1,1,4),(36,1514,0,1,1,4),(36,1610,0,1,1,4),(36,1690,0,1,1,4),(36,1888,0,1,1,4),(36,1925,0,1,1,4),(36,2023,0,1,1,4);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_store1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index_store1_replica`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index_store1_replica`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index_store1_replica` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category Id',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product Id',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store Id',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `IDX_6FBAC0A8825789D69AB86505B4914089` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `IDX_8F15547F72AF00C7861A223EC6C69052` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Prmg Catalog Category Product Index Store1 Replica';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index_store1_replica`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index_store1_replica` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_store1_replica` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_category_product_index_store1_replica` VALUES (2,1,0,1,1,4),(2,2,0,1,1,4),(2,3,0,1,1,4),(2,4,0,1,1,4),(2,5,0,1,1,4),(2,6,0,1,1,4),(2,7,0,1,1,4),(2,8,0,1,1,4),(2,9,0,1,1,4),(2,10,0,1,1,4),(2,11,0,1,1,4),(2,12,0,1,1,4),(2,13,0,1,1,4),(2,14,0,1,1,4),(2,15,0,1,1,4),(2,16,0,1,1,4),(2,17,0,1,1,4),(2,18,0,1,1,4),(2,19,0,1,1,4),(2,20,0,1,1,4),(2,21,0,1,1,4),(2,22,0,1,1,4),(2,23,0,1,1,4),(2,36,0,1,1,4),(2,37,0,1,1,4),(2,38,0,1,1,4),(2,39,0,1,1,4),(2,40,0,1,1,4),(2,41,0,1,1,4),(2,42,0,1,1,4),(2,43,0,1,1,4),(2,44,0,1,1,4),(2,45,0,1,1,4),(2,46,0,1,1,4),(2,47,0,1,1,4),(2,48,0,1,1,4),(2,49,0,1,1,4),(2,50,0,1,1,4),(2,51,0,1,1,4),(2,52,0,1,1,4),(2,68,0,1,1,4),(2,84,0,1,1,4),(2,100,0,1,1,4),(2,116,0,1,1,4),(2,132,0,1,1,4),(2,148,0,1,1,4),(2,164,0,1,1,4),(2,180,0,1,1,4),(2,196,0,1,1,4),(2,212,0,1,1,4),(2,228,0,1,1,4),(2,244,0,1,1,4),(2,260,0,1,1,4),(2,276,0,1,1,4),(2,292,0,1,1,4),(2,308,0,1,1,4),(2,324,0,1,1,4),(2,340,0,1,1,4),(2,356,0,1,1,4),(2,372,0,1,1,4),(2,388,0,1,1,4),(2,404,0,1,1,4),(2,420,0,1,1,4),(2,436,0,1,1,4),(2,452,0,1,1,4),(2,468,0,1,1,4),(2,484,0,1,1,4),(2,500,0,1,1,4),(2,516,0,1,1,4),(2,532,0,1,1,4),(2,548,0,1,1,4),(2,564,0,1,1,4),(2,580,0,1,1,4),(2,596,0,1,1,4),(2,612,0,1,1,4),(2,628,0,1,1,4),(2,644,0,1,1,4),(2,660,0,1,1,4),(2,676,0,1,1,4),(2,682,0,1,1,4),(2,688,0,1,1,4),(2,694,0,1,1,4),(2,700,0,1,1,4),(2,706,0,1,1,4),(2,712,0,1,1,4),(2,718,0,1,1,4),(2,724,0,1,1,4),(2,730,0,1,1,4),(2,743,0,1,1,4),(2,756,0,1,1,4),(2,769,0,1,1,4),(2,782,0,1,1,4),(2,795,0,1,1,4),(2,808,0,1,1,4),(2,821,0,1,1,4),(2,834,0,1,1,4),(2,847,0,1,1,4),(2,860,0,1,1,4),(2,873,0,1,1,4),(2,886,0,1,1,4),(2,899,0,1,1,4),(2,904,0,1,1,4),(2,917,0,1,1,4),(2,930,0,1,1,4),(2,943,0,1,1,4),(2,956,0,1,1,4),(2,969,0,1,1,4),(2,982,0,1,1,4),(2,995,0,1,1,4),(2,1008,0,1,1,4),(2,1021,0,1,1,4),(2,1034,0,1,1,4),(2,1050,0,1,1,4),(2,1066,0,1,1,4),(2,1082,0,1,1,4),(2,1098,0,1,1,4),(2,1114,0,1,1,4),(2,1120,0,1,1,4),(2,1136,0,1,1,4),(2,1152,0,1,1,4),(2,1168,0,1,1,4),(2,1184,0,1,1,4),(2,1200,0,1,1,4),(2,1216,0,1,1,4),(2,1226,0,1,1,4),(2,1242,0,1,1,4),(2,1258,0,1,1,4),(2,1274,0,1,1,4),(2,1290,0,1,1,4),(2,1306,0,1,1,4),(2,1322,0,1,1,4),(2,1338,0,1,1,4),(2,1354,0,1,1,4),(2,1370,0,1,1,4),(2,1386,0,1,1,4),(2,1402,0,1,1,4),(2,1418,0,1,1,4),(2,1434,0,1,1,4),(2,1450,0,1,1,4),(2,1466,0,1,1,4),(2,1482,0,1,1,4),(2,1498,0,1,1,4),(2,1514,0,1,1,4),(2,1530,0,1,1,4),(2,1546,0,1,1,4),(2,1562,0,1,1,4),(2,1578,0,1,1,4),(2,1594,0,1,1,4),(2,1610,0,1,1,4),(2,1626,0,1,1,4),(2,1642,0,1,1,4),(2,1658,0,1,1,4),(2,1674,0,1,1,4),(2,1690,0,1,1,4),(2,1706,0,1,1,4),(2,1722,0,1,1,4),(2,1738,0,1,1,4),(2,1754,0,1,1,4),(2,1770,0,1,1,4),(2,1786,0,1,1,4),(2,1802,0,1,1,4),(2,1818,0,1,1,4),(2,1825,0,1,1,4),(2,1832,0,1,1,4),(2,1839,0,1,1,4),(2,1846,0,1,1,4),(2,1853,0,1,1,4),(2,1860,0,1,1,4),(2,1867,0,1,1,4),(2,1874,0,1,1,4),(2,1881,0,1,1,4),(2,1888,0,1,1,4),(2,1895,0,1,1,4),(2,1902,0,1,1,4),(2,1909,0,1,1,4),(2,1925,0,1,1,4),(2,1941,0,1,1,4),(2,1957,0,1,1,4),(2,1973,0,1,1,4),(2,1989,0,1,1,4),(2,1996,0,1,1,4),(2,2003,0,1,1,4),(2,2009,0,1,1,4),(2,2016,0,1,1,4),(2,2023,0,1,1,4),(2,2030,0,1,1,4),(2,2046,0,1,1,4),(3,1,0,1,1,4),(3,2,0,1,1,4),(3,3,0,1,1,4),(3,4,0,1,1,4),(3,5,0,1,1,4),(3,6,0,1,1,4),(3,7,0,1,1,4),(3,8,0,1,1,4),(3,9,0,1,1,4),(3,10,0,1,1,4),(3,11,0,1,1,4),(3,12,0,1,1,4),(3,13,0,1,1,4),(3,14,0,1,1,4),(3,15,0,1,1,4),(3,16,0,1,1,4),(3,17,0,1,1,4),(3,18,0,1,1,4),(3,19,0,1,1,4),(3,20,0,1,1,4),(3,21,0,1,1,4),(3,22,0,1,1,4),(3,23,0,1,1,4),(3,36,0,1,1,4),(3,37,0,1,1,4),(3,38,0,1,1,4),(3,39,0,1,1,4),(3,40,0,1,1,4),(3,41,0,1,1,4),(3,42,0,1,1,4),(3,43,0,1,1,4),(3,44,0,1,1,4),(3,45,0,1,1,4),(3,46,0,1,1,4),(4,1,0,1,1,4),(4,2,0,1,1,4),(4,3,0,1,1,4),(4,4,0,1,1,4),(4,5,0,1,1,4),(4,6,0,1,1,4),(4,7,0,1,1,4),(4,8,0,1,1,4),(4,9,0,1,1,4),(4,10,0,1,1,4),(4,11,0,1,1,4),(4,12,0,1,1,4),(4,13,0,1,1,4),(4,14,0,1,1,4),(5,15,0,1,1,4),(5,16,0,1,1,4),(5,17,0,1,1,4),(5,18,0,1,1,4),(5,19,0,1,1,4),(5,20,0,1,1,4),(5,21,0,1,1,4),(5,22,0,1,1,4),(5,23,0,1,1,4),(5,45,0,1,1,4),(5,46,0,1,1,4),(6,36,0,1,1,4),(6,37,0,1,1,4),(6,38,0,1,1,4),(6,39,0,1,1,4),(6,40,0,1,1,4),(6,41,0,1,1,4),(6,42,0,1,1,4),(6,43,0,1,1,4),(6,44,0,1,1,4),(7,2,0,1,1,4),(7,4,0,1,1,4),(7,5,0,1,1,4),(7,10,0,1,1,4),(7,11,0,1,1,4),(7,13,0,1,1,4),(7,14,0,1,1,4),(7,16,0,1,1,4),(7,19,0,1,1,4),(7,38,0,1,1,4),(7,39,0,1,1,4),(7,40,0,1,1,4),(7,44,0,1,1,4),(8,4,0,1,1,4),(8,5,0,1,1,4),(8,13,0,1,1,4),(8,19,0,1,1,4),(8,38,0,1,1,4),(8,39,0,1,1,4),(8,40,0,1,1,4),(8,44,0,1,1,4),(8,769,0,1,1,4),(8,795,0,1,1,4),(8,821,0,1,1,4),(8,834,0,1,1,4),(8,847,0,1,1,4),(8,956,0,1,1,4),(8,1008,0,1,1,4),(8,1050,0,1,1,4),(8,1136,0,1,1,4),(8,1184,0,1,1,4),(8,1226,0,1,1,4),(8,1274,0,1,1,4),(8,1354,0,1,1,4),(8,1370,0,1,1,4),(8,1418,0,1,1,4),(8,1450,0,1,1,4),(8,1466,0,1,1,4),(8,1482,0,1,1,4),(8,1642,0,1,1,4),(8,1722,0,1,1,4),(8,1839,0,1,1,4),(8,1925,0,1,1,4),(8,1957,0,1,1,4),(8,2003,0,1,1,4),(9,47,0,1,1,4),(9,48,0,1,1,4),(9,49,0,1,1,4),(9,50,0,1,1,4),(9,51,0,1,1,4),(9,52,0,1,1,4),(10,47,0,1,1,4),(10,48,0,1,1,4),(10,49,0,1,1,4),(10,50,0,1,1,4),(10,51,0,1,1,4),(10,52,0,1,1,4),(12,68,10000,0,1,4),(12,84,10000,0,1,4),(12,100,10000,0,1,4),(12,116,10000,0,1,4),(12,132,10000,0,1,4),(12,148,10000,0,1,4),(12,164,10000,0,1,4),(12,180,10000,0,1,4),(12,196,10000,0,1,4),(12,212,10000,0,1,4),(12,228,10000,0,1,4),(12,244,10000,0,1,4),(12,260,10000,0,1,4),(12,276,10000,0,1,4),(12,292,10000,0,1,4),(12,308,10000,0,1,4),(12,324,10000,0,1,4),(12,340,10000,0,1,4),(12,356,10000,0,1,4),(12,372,10000,0,1,4),(12,388,10000,0,1,4),(12,404,10000,0,1,4),(12,420,10000,0,1,4),(12,436,10000,0,1,4),(12,452,10000,0,1,4),(12,468,10000,0,1,4),(12,484,10000,0,1,4),(12,500,10000,0,1,4),(12,516,10000,0,1,4),(12,532,10000,0,1,4),(12,548,10000,0,1,4),(12,564,10000,0,1,4),(12,580,10000,0,1,4),(12,596,10000,0,1,4),(12,612,10000,0,1,4),(12,628,10000,0,1,4),(12,644,10000,0,1,4),(12,660,10000,0,1,4),(12,676,10000,0,1,4),(12,682,10000,0,1,4),(12,688,10000,0,1,4),(12,694,10000,0,1,4),(12,700,10000,0,1,4),(12,706,10000,0,1,4),(12,712,10000,0,1,4),(12,718,10000,0,1,4),(12,724,10000,0,1,4),(12,730,10000,0,1,4),(13,743,10000,0,1,4),(13,756,10000,0,1,4),(13,769,10000,0,1,4),(13,782,10000,0,1,4),(13,795,10000,0,1,4),(13,808,10000,0,1,4),(13,821,10000,0,1,4),(13,834,10000,0,1,4),(13,847,10000,0,1,4),(13,860,10000,0,1,4),(13,873,10000,0,1,4),(13,886,10000,0,1,4),(13,899,10000,0,1,4),(13,904,10000,0,1,4),(13,917,10000,0,1,4),(13,930,10000,0,1,4),(13,943,10000,0,1,4),(13,956,10000,0,1,4),(13,969,10000,0,1,4),(13,982,10000,0,1,4),(13,995,10000,0,1,4),(13,1008,10000,0,1,4),(13,1021,10000,0,1,4),(13,1034,10000,0,1,4),(14,276,0,1,1,4),(14,292,0,1,1,4),(14,308,0,1,1,4),(14,324,0,1,1,4),(14,340,0,1,1,4),(14,356,0,1,1,4),(14,372,0,1,1,4),(14,388,0,1,1,4),(14,404,0,1,1,4),(14,420,0,1,1,4),(14,436,0,1,1,4),(15,68,0,1,1,4),(15,84,0,1,1,4),(15,100,0,1,1,4),(15,116,0,1,1,4),(15,132,0,1,1,4),(15,148,0,1,1,4),(15,164,0,1,1,4),(15,180,0,1,1,4),(15,196,0,1,1,4),(15,212,0,1,1,4),(15,228,0,1,1,4),(15,244,0,1,1,4),(15,260,0,1,1,4),(16,452,0,1,1,4),(16,468,0,1,1,4),(16,484,0,1,1,4),(16,500,0,1,1,4),(16,516,0,1,1,4),(16,532,0,1,1,4),(16,548,0,1,1,4),(16,564,0,1,1,4),(16,580,0,1,1,4),(16,596,0,1,1,4),(16,612,0,1,1,4),(16,628,0,1,1,4),(17,644,0,1,1,4),(17,660,0,1,1,4),(17,676,0,1,1,4),(17,682,0,1,1,4),(17,688,0,1,1,4),(17,694,0,1,1,4),(17,700,0,1,1,4),(17,706,0,1,1,4),(17,712,0,1,1,4),(17,718,0,1,1,4),(17,724,0,1,1,4),(17,730,0,1,1,4),(18,743,0,1,1,4),(18,756,0,1,1,4),(18,769,0,1,1,4),(18,782,0,1,1,4),(18,795,0,1,1,4),(18,808,0,1,1,4),(18,821,0,1,1,4),(18,834,0,1,1,4),(18,847,0,1,1,4),(18,860,0,1,1,4),(18,873,0,1,1,4),(18,886,0,1,1,4),(19,899,0,1,1,4),(19,904,0,1,1,4),(19,917,0,1,1,4),(19,930,0,1,1,4),(19,943,0,1,1,4),(19,956,0,1,1,4),(19,969,0,1,1,4),(19,982,0,1,1,4),(19,995,0,1,1,4),(19,1008,0,1,1,4),(19,1021,0,1,1,4),(19,1034,0,1,1,4),(21,1050,10000,0,1,4),(21,1066,10000,0,1,4),(21,1082,10000,0,1,4),(21,1098,10000,0,1,4),(21,1114,10000,0,1,4),(21,1120,10000,0,1,4),(21,1136,10000,0,1,4),(21,1152,10000,0,1,4),(21,1168,10000,0,1,4),(21,1184,10000,0,1,4),(21,1200,10000,0,1,4),(21,1216,10000,0,1,4),(21,1226,10000,0,1,4),(21,1242,10000,0,1,4),(21,1258,10000,0,1,4),(21,1274,10000,0,1,4),(21,1290,10000,0,1,4),(21,1306,10000,0,1,4),(21,1322,10000,0,1,4),(21,1338,10000,0,1,4),(21,1354,10000,0,1,4),(21,1370,10000,0,1,4),(21,1386,10000,0,1,4),(21,1402,10000,0,1,4),(21,1418,10000,0,1,4),(21,1434,10000,0,1,4),(21,1450,10000,0,1,4),(21,1466,10000,0,1,4),(21,1482,10000,0,1,4),(21,1498,10000,0,1,4),(21,1514,10000,0,1,4),(21,1530,10000,0,1,4),(21,1546,10000,0,1,4),(21,1562,10000,0,1,4),(21,1578,10000,0,1,4),(21,1594,10000,0,1,4),(21,1610,10000,0,1,4),(21,1626,10000,0,1,4),(21,1642,10000,0,1,4),(21,1658,10000,0,1,4),(21,1674,10000,0,1,4),(21,1690,10000,0,1,4),(21,1706,10000,0,1,4),(21,1722,10000,0,1,4),(21,1738,10000,0,1,4),(21,1754,10000,0,1,4),(21,1770,10000,0,1,4),(21,1786,10000,0,1,4),(21,1802,10000,0,1,4),(21,1818,10000,0,1,4),(22,1825,10000,0,1,4),(22,1832,10000,0,1,4),(22,1839,10000,0,1,4),(22,1846,10000,0,1,4),(22,1853,10000,0,1,4),(22,1860,10000,0,1,4),(22,1867,10000,0,1,4),(22,1874,10000,0,1,4),(22,1881,10000,0,1,4),(22,1888,10000,0,1,4),(22,1895,10000,0,1,4),(22,1902,10000,0,1,4),(22,1909,10000,0,1,4),(22,1925,10000,0,1,4),(22,1941,10000,0,1,4),(22,1957,10000,0,1,4),(22,1973,10000,0,1,4),(22,1989,10000,0,1,4),(22,1996,10000,0,1,4),(22,2003,10000,0,1,4),(22,2009,10000,0,1,4),(22,2016,10000,0,1,4),(22,2023,10000,0,1,4),(22,2030,10000,0,1,4),(22,2046,10000,0,1,4),(23,1226,0,1,1,4),(23,1242,0,1,1,4),(23,1258,0,1,1,4),(23,1274,0,1,1,4),(23,1290,0,1,1,4),(23,1306,0,1,1,4),(23,1322,0,1,1,4),(23,1338,0,1,1,4),(23,1354,0,1,1,4),(23,1370,0,1,1,4),(23,1386,0,1,1,4),(23,1402,0,1,1,4),(24,1050,0,1,1,4),(24,1066,0,1,1,4),(24,1082,0,1,1,4),(24,1098,0,1,1,4),(24,1114,0,1,1,4),(24,1120,0,1,1,4),(24,1136,0,1,1,4),(24,1152,0,1,1,4),(24,1168,0,1,1,4),(24,1184,0,1,1,4),(24,1200,0,1,1,4),(24,1216,0,1,1,4),(25,1418,0,1,1,4),(25,1434,0,1,1,4),(25,1450,0,1,1,4),(25,1466,0,1,1,4),(25,1482,0,1,1,4),(25,1498,0,1,1,4),(25,1514,0,1,1,4),(25,1530,0,1,1,4),(25,1546,0,1,1,4),(25,1562,0,1,1,4),(25,1578,0,1,1,4),(25,1594,0,1,1,4),(26,1610,0,1,1,4),(26,1626,0,1,1,4),(26,1642,0,1,1,4),(26,1658,0,1,1,4),(26,1674,0,1,1,4),(26,1690,0,1,1,4),(26,1706,0,1,1,4),(26,1722,0,1,1,4),(26,1738,0,1,1,4),(26,1754,0,1,1,4),(26,1770,0,1,1,4),(26,1786,0,1,1,4),(26,1802,0,1,1,4),(26,1818,0,1,1,4),(27,1825,0,1,1,4),(27,1832,0,1,1,4),(27,1839,0,1,1,4),(27,1846,0,1,1,4),(27,1853,0,1,1,4),(27,1860,0,1,1,4),(27,1867,0,1,1,4),(27,1874,0,1,1,4),(27,1881,0,1,1,4),(27,1888,0,1,1,4),(27,1895,0,1,1,4),(27,1902,0,1,1,4),(27,1909,0,1,1,4),(28,1925,0,1,1,4),(28,1941,0,1,1,4),(28,1957,0,1,1,4),(28,1973,0,1,1,4),(28,1989,0,1,1,4),(28,1996,0,1,1,4),(28,2003,0,1,1,4),(28,2009,0,1,1,4),(28,2016,0,1,1,4),(28,2023,0,1,1,4),(28,2030,0,1,1,4),(28,2046,0,1,1,4),(30,1066,0,1,1,4),(30,1152,0,1,1,4),(30,1242,0,1,1,4),(30,1322,0,1,1,4),(30,1386,0,1,1,4),(30,1402,0,1,1,4),(30,1498,0,1,1,4),(30,1514,0,1,1,4),(30,1546,0,1,1,4),(30,1610,0,1,1,4),(30,1802,0,1,1,4),(30,1818,0,1,1,4),(30,1941,0,1,1,4),(30,1989,0,1,1,4),(31,969,0,1,1,4),(31,982,0,1,1,4),(31,1034,0,1,1,4),(32,743,0,1,1,4),(32,756,0,1,1,4),(32,769,0,1,1,4),(32,782,0,1,1,4),(32,795,0,1,1,4),(32,808,0,1,1,4),(32,821,0,1,1,4),(32,834,0,1,1,4),(32,847,0,1,1,4),(32,860,0,1,1,4),(32,873,0,1,1,4),(32,886,0,1,1,4),(32,1825,0,1,1,4),(32,1832,0,1,1,4),(32,1839,0,1,1,4),(32,1846,0,1,1,4),(32,1853,0,1,1,4),(32,1860,0,1,1,4),(32,1867,0,1,1,4),(32,1874,0,1,1,4),(32,1881,0,1,1,4),(32,1888,0,1,1,4),(32,1895,0,1,1,4),(32,1902,0,1,1,4),(32,1909,0,1,1,4),(33,1418,0,1,1,4),(33,1434,0,1,1,4),(33,1450,0,1,1,4),(33,1466,0,1,1,4),(33,1482,0,1,1,4),(33,1498,0,1,1,4),(33,1514,0,1,1,4),(33,1530,0,1,1,4),(33,1546,0,1,1,4),(33,1562,0,1,1,4),(33,1578,0,1,1,4),(33,1594,0,1,1,4),(34,847,0,1,1,4),(34,860,0,1,1,4),(34,873,0,1,1,4),(34,899,0,1,1,4),(34,969,0,1,1,4),(34,1050,0,1,1,4),(34,1136,0,1,1,4),(34,1200,0,1,1,4),(34,1226,0,1,1,4),(34,1322,0,1,1,4),(34,1338,0,1,1,4),(34,1482,0,1,1,4),(34,1546,0,1,1,4),(34,1722,0,1,1,4),(34,1754,0,1,1,4),(34,1818,0,1,1,4),(34,1853,0,1,1,4),(34,1860,0,1,1,4),(34,1909,0,1,1,4),(34,2030,0,1,1,4),(34,2046,0,1,1,4),(35,756,0,1,1,4),(35,917,0,1,1,4),(35,943,0,1,1,4),(35,995,0,1,1,4),(35,1152,0,1,1,4),(35,1216,0,1,1,4),(35,1274,0,1,1,4),(35,1354,0,1,1,4),(35,1386,0,1,1,4),(35,1402,0,1,1,4),(35,1434,0,1,1,4),(35,1530,0,1,1,4),(35,1562,0,1,1,4),(35,1642,0,1,1,4),(35,1738,0,1,1,4),(35,1786,0,1,1,4),(35,1802,0,1,1,4),(35,1825,0,1,1,4),(35,1832,0,1,1,4),(35,1867,0,1,1,4),(35,1902,0,1,1,4),(35,1957,0,1,1,4),(35,2009,0,1,1,4),(36,68,0,1,1,4),(36,100,0,1,1,4),(36,116,0,1,1,4),(36,308,0,1,1,4),(36,404,0,1,1,4),(36,468,0,1,1,4),(36,700,0,1,1,4),(36,724,0,1,1,4),(36,808,0,1,1,4),(36,1168,0,1,1,4),(36,1450,0,1,1,4),(36,1466,0,1,1,4),(36,1514,0,1,1,4),(36,1610,0,1,1,4),(36,1690,0,1,1,4),(36,1888,0,1,1,4),(36,1925,0,1,1,4),(36,2023,0,1,1,4);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_store1_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_category_product_index_tmp`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_category_product_index_tmp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_category_product_index_tmp` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_CTGR_PRD_IDX_TMP_PRD_ID_CTGR_ID_STORE_ID` (`product_id`,`category_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Indexer temporary table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_category_product_index_tmp`
--

LOCK TABLES `[[dbprefix]]catalog_category_product_index_tmp` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_tmp` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_category_product_index_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_compare_item`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_compare_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_compare_item` (
  `catalog_compare_item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare Item ID',
  `visitor_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Visitor ID',
  `customer_id` int(10) unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `store_id` smallint(5) unsigned DEFAULT NULL COMMENT 'Store ID',
  PRIMARY KEY (`catalog_compare_item_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_ITEM_PRODUCT_ID` (`product_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_ITEM_VISITOR_ID_PRODUCT_ID` (`visitor_id`,`product_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_ITEM_CUSTOMER_ID_PRODUCT_ID` (`customer_id`,`product_id`),
  KEY `[[DBPREFIX]]CATALOG_COMPARE_ITEM_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CATALOG_COMPARE_ITEM_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE SET NULL,
  CONSTRAINT `[[DBPREFIX]]CAT_CMP_ITEM_CSTR_ID_[[DBPREFIX]]CSTR_ENTT_ENTT_ID` FOREIGN KEY (`customer_id`) REFERENCES `[[dbprefix]]customer_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_CMP_ITEM_PRD_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Compare Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_compare_item`
--

LOCK TABLES `[[dbprefix]]catalog_compare_item` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_compare_item` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_compare_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_eav_attribute`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_eav_attribute`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_eav_attribute` (
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `frontend_input_renderer` varchar(255) DEFAULT NULL COMMENT 'Frontend Input Renderer',
  `is_global` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Global',
  `is_visible` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Visible',
  `is_searchable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Searchable',
  `is_filterable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable',
  `is_comparable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Comparable',
  `is_visible_on_front` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `is_html_allowed_on_front` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is HTML Allowed On Front',
  `is_used_for_price_rules` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Price Rules',
  `is_filterable_in_search` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable In Search',
  `used_in_product_listing` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used In Product Listing',
  `used_for_sort_by` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Sorting',
  `apply_to` varchar(255) DEFAULT NULL COMMENT 'Apply To',
  `is_visible_in_advanced_search` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible In Advanced Search',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_wysiwyg_enabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is WYSIWYG Enabled',
  `is_used_for_promo_rules` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Promo Rules',
  `is_required_in_admin_store` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Required In Admin Store',
  `is_used_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used in Grid',
  `is_visible_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible in Grid',
  `is_filterable_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable in Grid',
  `search_weight` float NOT NULL DEFAULT '1' COMMENT 'Search Weight',
  `additional_data` text COMMENT 'Additional swatch attributes data',
  PRIMARY KEY (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_EAV_ATTRIBUTE_USED_FOR_SORT_BY` (`used_for_sort_by`),
  KEY `[[DBPREFIX]]CATALOG_EAV_ATTRIBUTE_USED_IN_PRODUCT_LISTING` (`used_in_product_listing`),
  CONSTRAINT `[[DBPREFIX]]CAT_EAV_ATTR_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog EAV Attribute Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_eav_attribute`
--

LOCK TABLES `[[dbprefix]]catalog_eav_attribute` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_eav_attribute` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_eav_attribute` VALUES (45,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(46,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(47,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,0,1,0,0,0,0,0,1,NULL),(48,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(49,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(50,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(51,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(52,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(53,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(54,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(55,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(56,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(57,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(58,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(59,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(60,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(61,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(62,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(63,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(64,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(65,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(66,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(67,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\Available',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(68,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\DefaultSortby',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(69,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(70,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(71,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(72,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Pricestep',0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(73,NULL,0,1,1,0,0,0,0,0,0,1,1,NULL,1,0,0,0,0,0,0,0,5,NULL),(74,NULL,1,1,1,0,1,0,0,0,0,0,0,NULL,1,0,0,1,0,0,0,0,6,NULL),(75,NULL,0,1,1,0,1,0,1,0,0,0,0,NULL,1,0,1,0,0,0,0,0,1,NULL),(76,NULL,0,1,1,0,1,0,1,0,0,1,0,NULL,1,0,1,0,0,1,0,0,1,NULL),(77,NULL,1,1,1,1,0,0,0,0,0,1,1,'simple,virtual,bundle,downloadable,configurable',1,0,0,0,0,0,0,0,1,NULL),(78,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,1,1,NULL),(79,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,0,1,NULL),(80,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,0,1,NULL),(81,NULL,1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable',0,0,0,0,0,1,0,1,1,NULL),(82,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Weight',1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,1,1,NULL),(83,NULL,1,1,1,1,1,0,0,0,0,0,0,'simple,configurable',1,0,0,0,0,1,0,1,1,NULL),(84,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,NULL),(85,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,NULL),(86,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,NULL),(87,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(88,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(89,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(90,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(91,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(92,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable',0,0,0,0,0,0,0,0,1,NULL),(93,NULL,1,1,0,1,0,0,1,0,0,1,0,'simple,virtual,configurable',0,0,0,1,0,1,0,1,1,'{\"swatch_input_type\":\"visual\",\"update_product_preview_image\":1,\"use_product_image_for_swatch\":0}'),(94,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(95,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(96,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(97,'Magento\\Framework\\Data\\Form\\Element\\Hidden',2,1,1,0,0,0,0,0,0,1,0,NULL,0,0,0,0,1,0,0,0,1,NULL),(98,NULL,0,0,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,0,0,0,1,NULL),(99,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,1,0,0,0,1,NULL),(100,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,1,1,NULL),(101,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(102,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(103,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(104,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(105,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Category',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(106,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(107,NULL,1,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(108,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(109,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(110,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(111,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(112,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(113,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(114,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,bundle,configurable,grouped',0,0,0,0,0,1,0,1,1,NULL),(115,'Magento\\CatalogInventory\\Block\\Adminhtml\\Form\\Field\\Stock',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(116,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(117,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(118,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(119,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type',1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,1,0,1,1,NULL),(120,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type\\Price',2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,0,0,0,0,0,0,0,1,NULL),(121,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,NULL),(122,NULL,1,1,0,0,0,0,0,0,0,0,0,'bundle',0,0,0,0,0,0,0,0,1,NULL),(123,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,NULL),(124,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,NULL),(125,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,0,0,0,0,0,0,0,1,NULL),(126,NULL,0,1,1,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(127,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(128,NULL,0,1,1,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,1,0,1,1,NULL),(129,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,0,0,0,1,NULL),(130,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,0,0,0,0,0,0,0,1,NULL),(131,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0,0,0,0,0,1,NULL),(132,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,0,0,0,0,0,0,0,1,NULL),(133,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,0,0,0,0,0,0,0,1,NULL),(134,NULL,2,1,1,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,0,0,0,0,1,0,1,1,NULL),(135,'Magento\\GiftMessage\\Block\\Adminhtml\\Product\\Helper\\Form\\Config',1,1,0,0,0,0,0,0,0,0,0,NULL,0,0,0,0,0,1,0,0,1,NULL),(136,NULL,1,1,0,1,1,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(137,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(138,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(139,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(140,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(141,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(142,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(143,NULL,1,1,0,1,0,0,1,0,0,1,0,NULL,0,0,0,1,0,0,0,0,1,'{\"swatch_input_type\":\"text\",\"update_product_preview_image\":1,\"use_product_image_for_swatch\":0}'),(144,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(145,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(146,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(147,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(148,NULL,1,1,0,1,0,0,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(149,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(150,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(151,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(152,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(153,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(154,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(155,NULL,1,1,0,1,0,1,1,0,0,0,0,NULL,0,0,0,1,0,0,0,0,1,NULL),(156,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,0,0,0,0,0,0,0,1,NULL);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_eav_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_option`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_option`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_option` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option ID',
  `parent_id` int(10) unsigned NOT NULL COMMENT 'Parent ID',
  `required` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required',
  `position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `type` varchar(255) DEFAULT NULL COMMENT 'Type',
  PRIMARY KEY (`option_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_OPTION_PARENT_ID` (`parent_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_OPT_PARENT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`parent_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Option';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_option`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_option` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_option` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_bundle_option` VALUES (1,46,1,1,'radio'),(2,46,1,2,'radio'),(3,46,1,3,'radio'),(4,46,1,4,'radio');
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_option` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_option_value`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_option_value` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `option_id` int(10) unsigned NOT NULL COMMENT 'Option ID',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store ID',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_PRD_BNDL_OPT_VAL_OPT_ID_PARENT_PRD_ID_STORE_ID` (`option_id`,`parent_product_id`,`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_OPT_VAL_OPT_ID_[[DBPREFIX]]CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `[[dbprefix]]catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Option Value';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_option_value`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_option_value` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_option_value` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_bundle_option_value` VALUES (1,1,0,'Sprite Stasis Ball',46),(2,2,0,'Sprite Foam Yoga Brick',46),(3,3,0,'Sprite Yoga Strap',46),(4,4,0,'Sprite Foam Roller',46);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_price_index`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_price_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_price_index` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `customer_group_id` int(10) unsigned NOT NULL COMMENT 'Customer Group ID',
  `min_price` decimal(20,6) NOT NULL COMMENT 'Min Price',
  `max_price` decimal(20,6) NOT NULL COMMENT 'Max Price',
  PRIMARY KEY (`entity_id`,`website_id`,`customer_group_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_WEBSITE_ID` (`website_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_CUSTOMER_GROUP_ID` (`customer_group_id`),
  CONSTRAINT `FK_8DB5B8954D6EEC1C9A89C61D561C2D39` FOREIGN KEY (`customer_group_id`) REFERENCES `[[dbprefix]]customer_group` (`customer_group_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_PRICE_IDX_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_PRICE_IDX_WS_ID_[[DBPREFIX]]STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `[[dbprefix]]store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Price Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_price_index`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_price_index` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_price_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_price_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_selection`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_selection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_selection` (
  `selection_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Selection ID',
  `option_id` int(10) unsigned NOT NULL COMMENT 'Option ID',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product ID',
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product ID',
  `position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_default` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Default',
  `selection_price_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Selection Price Value',
  `selection_qty` decimal(12,4) DEFAULT NULL COMMENT 'Selection Qty',
  `selection_can_change_qty` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Selection Can Change Qty',
  PRIMARY KEY (`selection_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_SELECTION_OPTION_ID` (`option_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_SELECTION_PRODUCT_ID` (`product_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_SELECTION_OPT_ID_[[DBPREFIX]]CAT_PRD_BNDL_OPT_OPT_ID` FOREIGN KEY (`option_id`) REFERENCES `[[dbprefix]]catalog_product_bundle_option` (`option_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_SELECTION_PRD_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`product_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Selection';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_selection`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_selection` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_selection` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_bundle_selection` VALUES (1,1,46,26,1,1,0,0.0000,1.0000,1),(2,1,46,29,2,0,0,0.0000,1.0000,1),(3,1,46,32,3,0,0,0.0000,1.0000,1),(4,2,46,21,1,1,0,0.0000,1.0000,1),(5,3,46,33,1,1,0,0.0000,1.0000,1),(6,3,46,34,2,0,0,0.0000,1.0000,1),(7,3,46,35,3,0,0,0.0000,1.0000,1),(8,4,46,22,1,1,0,0.0000,1.0000,1);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_selection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_selection_price`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_selection_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_selection_price` (
  `selection_id` int(10) unsigned NOT NULL COMMENT 'Selection ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `selection_price_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(20,6) NOT NULL DEFAULT '0.000000' COMMENT 'Selection Price Value',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product ID',
  PRIMARY KEY (`selection_id`,`parent_product_id`,`website_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_BUNDLE_SELECTION_PRICE_WEBSITE_ID` (`website_id`),
  CONSTRAINT `FK_48A0D40A08C88AC5E40947636D598C57` FOREIGN KEY (`selection_id`) REFERENCES `[[dbprefix]]catalog_product_bundle_selection` (`selection_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_BNDL_SELECTION_PRICE_WS_ID_[[DBPREFIX]]STORE_WS_WS_ID` FOREIGN KEY (`website_id`) REFERENCES `[[dbprefix]]store_website` (`website_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Selection Price';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_selection_price`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_selection_price` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_selection_price` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_selection_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_bundle_stock_index`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_bundle_stock_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_bundle_stock_index` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity ID',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website ID',
  `stock_id` smallint(5) unsigned NOT NULL COMMENT 'Stock ID',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option ID',
  `stock_status` smallint(6) DEFAULT '0' COMMENT 'Stock Status',
  PRIMARY KEY (`entity_id`,`website_id`,`stock_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Stock Index';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_bundle_stock_index`
--

LOCK TABLES `[[dbprefix]]catalog_product_bundle_stock_index` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_stock_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_bundle_stock_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple' COMMENT 'Type ID',
  `sku` varchar(64) DEFAULT NULL COMMENT 'SKU',
  `has_options` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Has Options',
  `required_options` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required Options',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_SKU` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=2047 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity` VALUES (1,15,'simple','24-MB01',0,0,'[[regtime]]','[[regtime]]'),(2,15,'simple','24-MB04',0,0,'[[regtime]]','[[regtime]]'),(3,15,'simple','24-MB03',0,0,'[[regtime]]','[[regtime]]'),(4,15,'simple','24-MB05',0,0,'[[regtime]]','[[regtime]]'),(5,15,'simple','24-MB06',0,0,'[[regtime]]','[[regtime]]'),(6,15,'simple','24-MB02',0,0,'[[regtime]]','[[regtime]]'),(7,15,'simple','24-UB02',0,0,'[[regtime]]','[[regtime]]'),(8,15,'simple','24-WB01',0,0,'[[regtime]]','[[regtime]]'),(9,15,'simple','24-WB02',0,0,'[[regtime]]','[[regtime]]'),(10,15,'simple','24-WB05',0,0,'[[regtime]]','[[regtime]]'),(11,15,'simple','24-WB06',0,0,'[[regtime]]','[[regtime]]'),(12,15,'simple','24-WB03',0,0,'[[regtime]]','[[regtime]]'),(13,15,'simple','24-WB07',0,0,'[[regtime]]','[[regtime]]'),(14,15,'simple','24-WB04',0,0,'[[regtime]]','[[regtime]]'),(15,11,'simple','24-UG06',0,0,'[[regtime]]','[[regtime]]'),(16,11,'simple','24-UG07',0,0,'[[regtime]]','[[regtime]]'),(17,11,'simple','24-UG04',0,0,'[[regtime]]','[[regtime]]'),(18,11,'simple','24-UG02',0,0,'[[regtime]]','[[regtime]]'),(19,11,'simple','24-UG05',0,0,'[[regtime]]','[[regtime]]'),(20,11,'simple','24-UG01',0,0,'[[regtime]]','[[regtime]]'),(21,11,'simple','24-WG084',0,0,'[[regtime]]','[[regtime]]'),(22,11,'simple','24-WG088',0,0,'[[regtime]]','[[regtime]]'),(23,11,'simple','24-UG03',0,0,'[[regtime]]','[[regtime]]'),(24,12,'simple','24-WG081-gray',0,0,'[[regtime]]','[[regtime]]'),(25,12,'simple','24-WG081-pink',0,0,'[[regtime]]','[[regtime]]'),(26,12,'simple','24-WG081-blue',0,0,'[[regtime]]','[[regtime]]'),(27,12,'simple','24-WG082-gray',0,0,'[[regtime]]','[[regtime]]'),(28,12,'simple','24-WG082-pink',0,0,'[[regtime]]','[[regtime]]'),(29,12,'simple','24-WG082-blue',0,0,'[[regtime]]','[[regtime]]'),(30,12,'simple','24-WG083-gray',0,0,'[[regtime]]','[[regtime]]'),(31,12,'simple','24-WG083-pink',0,0,'[[regtime]]','[[regtime]]'),(32,12,'simple','24-WG083-blue',0,0,'[[regtime]]','[[regtime]]'),(33,13,'simple','24-WG085',0,0,'[[regtime]]','[[regtime]]'),(34,13,'simple','24-WG086',0,0,'[[regtime]]','[[regtime]]'),(35,13,'simple','24-WG087',0,0,'[[regtime]]','[[regtime]]'),(36,11,'simple','24-MG04',0,0,'[[regtime]]','[[regtime]]'),(37,11,'simple','24-MG01',0,0,'[[regtime]]','[[regtime]]'),(38,11,'simple','24-MG03',0,0,'[[regtime]]','[[regtime]]'),(39,11,'simple','24-MG05',0,0,'[[regtime]]','[[regtime]]'),(40,11,'simple','24-MG02',0,0,'[[regtime]]','[[regtime]]'),(41,11,'simple','24-WG09',0,0,'[[regtime]]','[[regtime]]'),(42,11,'simple','24-WG01',0,0,'[[regtime]]','[[regtime]]'),(43,11,'simple','24-WG03',0,0,'[[regtime]]','[[regtime]]'),(44,11,'simple','24-WG02',0,0,'[[regtime]]','[[regtime]]'),(45,11,'grouped','24-WG085_Group',0,0,'[[regtime]]','[[regtime]]'),(46,11,'bundle','24-WG080',1,1,'[[regtime]]','[[regtime]]'),(47,14,'downloadable','240-LV04',0,0,'[[regtime]]','[[regtime]]'),(48,14,'downloadable','240-LV05',0,0,'[[regtime]]','[[regtime]]'),(49,14,'downloadable','240-LV06',0,0,'[[regtime]]','[[regtime]]'),(50,14,'downloadable','240-LV07',0,0,'[[regtime]]','[[regtime]]'),(51,14,'downloadable','240-LV08',0,0,'[[regtime]]','[[regtime]]'),(52,14,'downloadable','240-LV09',0,0,'[[regtime]]','[[regtime]]'),(53,9,'simple','MH01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(54,9,'simple','MH01-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(55,9,'simple','MH01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(56,9,'simple','MH01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(57,9,'simple','MH01-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(58,9,'simple','MH01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(59,9,'simple','MH01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(60,9,'simple','MH01-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(61,9,'simple','MH01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(62,9,'simple','MH01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(63,9,'simple','MH01-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(64,9,'simple','MH01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(65,9,'simple','MH01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(66,9,'simple','MH01-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(67,9,'simple','MH01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(68,9,'configurable','MH01',1,0,'[[regtime]]','[[regtime]]'),(69,9,'simple','MH02-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(70,9,'simple','MH02-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(71,9,'simple','MH02-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(72,9,'simple','MH02-S-Black',0,0,'[[regtime]]','[[regtime]]'),(73,9,'simple','MH02-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(74,9,'simple','MH02-S-Red',0,0,'[[regtime]]','[[regtime]]'),(75,9,'simple','MH02-M-Black',0,0,'[[regtime]]','[[regtime]]'),(76,9,'simple','MH02-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(77,9,'simple','MH02-M-Red',0,0,'[[regtime]]','[[regtime]]'),(78,9,'simple','MH02-L-Black',0,0,'[[regtime]]','[[regtime]]'),(79,9,'simple','MH02-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(80,9,'simple','MH02-L-Red',0,0,'[[regtime]]','[[regtime]]'),(81,9,'simple','MH02-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(82,9,'simple','MH02-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(83,9,'simple','MH02-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(84,9,'configurable','MH02',1,0,'[[regtime]]','[[regtime]]'),(85,9,'simple','MH03-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(86,9,'simple','MH03-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(87,9,'simple','MH03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(88,9,'simple','MH03-S-Black',0,0,'[[regtime]]','[[regtime]]'),(89,9,'simple','MH03-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(90,9,'simple','MH03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(91,9,'simple','MH03-M-Black',0,0,'[[regtime]]','[[regtime]]'),(92,9,'simple','MH03-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(93,9,'simple','MH03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(94,9,'simple','MH03-L-Black',0,0,'[[regtime]]','[[regtime]]'),(95,9,'simple','MH03-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(96,9,'simple','MH03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(97,9,'simple','MH03-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(98,9,'simple','MH03-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(99,9,'simple','MH03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(100,9,'configurable','MH03',1,0,'[[regtime]]','[[regtime]]'),(101,9,'simple','MH04-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(102,9,'simple','MH04-XS-White',0,0,'[[regtime]]','[[regtime]]'),(103,9,'simple','MH04-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(104,9,'simple','MH04-S-Green',0,0,'[[regtime]]','[[regtime]]'),(105,9,'simple','MH04-S-White',0,0,'[[regtime]]','[[regtime]]'),(106,9,'simple','MH04-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(107,9,'simple','MH04-M-Green',0,0,'[[regtime]]','[[regtime]]'),(108,9,'simple','MH04-M-White',0,0,'[[regtime]]','[[regtime]]'),(109,9,'simple','MH04-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(110,9,'simple','MH04-L-Green',0,0,'[[regtime]]','[[regtime]]'),(111,9,'simple','MH04-L-White',0,0,'[[regtime]]','[[regtime]]'),(112,9,'simple','MH04-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(113,9,'simple','MH04-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(114,9,'simple','MH04-XL-White',0,0,'[[regtime]]','[[regtime]]'),(115,9,'simple','MH04-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(116,9,'configurable','MH04',1,0,'[[regtime]]','[[regtime]]'),(117,9,'simple','MH05-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(118,9,'simple','MH05-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(119,9,'simple','MH05-XS-White',0,0,'[[regtime]]','[[regtime]]'),(120,9,'simple','MH05-S-Green',0,0,'[[regtime]]','[[regtime]]'),(121,9,'simple','MH05-S-Red',0,0,'[[regtime]]','[[regtime]]'),(122,9,'simple','MH05-S-White',0,0,'[[regtime]]','[[regtime]]'),(123,9,'simple','MH05-M-Green',0,0,'[[regtime]]','[[regtime]]'),(124,9,'simple','MH05-M-Red',0,0,'[[regtime]]','[[regtime]]'),(125,9,'simple','MH05-M-White',0,0,'[[regtime]]','[[regtime]]'),(126,9,'simple','MH05-L-Green',0,0,'[[regtime]]','[[regtime]]'),(127,9,'simple','MH05-L-Red',0,0,'[[regtime]]','[[regtime]]'),(128,9,'simple','MH05-L-White',0,0,'[[regtime]]','[[regtime]]'),(129,9,'simple','MH05-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(130,9,'simple','MH05-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(131,9,'simple','MH05-XL-White',0,0,'[[regtime]]','[[regtime]]'),(132,9,'configurable','MH05',1,0,'[[regtime]]','[[regtime]]'),(133,9,'simple','MH06-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(134,9,'simple','MH06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(135,9,'simple','MH06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(136,9,'simple','MH06-S-Black',0,0,'[[regtime]]','[[regtime]]'),(137,9,'simple','MH06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(138,9,'simple','MH06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(139,9,'simple','MH06-M-Black',0,0,'[[regtime]]','[[regtime]]'),(140,9,'simple','MH06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(141,9,'simple','MH06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(142,9,'simple','MH06-L-Black',0,0,'[[regtime]]','[[regtime]]'),(143,9,'simple','MH06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(144,9,'simple','MH06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(145,9,'simple','MH06-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(146,9,'simple','MH06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(147,9,'simple','MH06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(148,9,'configurable','MH06',1,0,'[[regtime]]','[[regtime]]'),(149,9,'simple','MH07-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(150,9,'simple','MH07-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(151,9,'simple','MH07-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(152,9,'simple','MH07-S-Black',0,0,'[[regtime]]','[[regtime]]'),(153,9,'simple','MH07-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(154,9,'simple','MH07-S-Green',0,0,'[[regtime]]','[[regtime]]'),(155,9,'simple','MH07-M-Black',0,0,'[[regtime]]','[[regtime]]'),(156,9,'simple','MH07-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(157,9,'simple','MH07-M-Green',0,0,'[[regtime]]','[[regtime]]'),(158,9,'simple','MH07-L-Black',0,0,'[[regtime]]','[[regtime]]'),(159,9,'simple','MH07-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(160,9,'simple','MH07-L-Green',0,0,'[[regtime]]','[[regtime]]'),(161,9,'simple','MH07-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(162,9,'simple','MH07-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(163,9,'simple','MH07-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(164,9,'configurable','MH07',1,0,'[[regtime]]','[[regtime]]'),(165,9,'simple','MH08-XS-Brown',0,0,'[[regtime]]','[[regtime]]'),(166,9,'simple','MH08-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(167,9,'simple','MH08-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(168,9,'simple','MH08-S-Brown',0,0,'[[regtime]]','[[regtime]]'),(169,9,'simple','MH08-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(170,9,'simple','MH08-S-Red',0,0,'[[regtime]]','[[regtime]]'),(171,9,'simple','MH08-M-Brown',0,0,'[[regtime]]','[[regtime]]'),(172,9,'simple','MH08-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(173,9,'simple','MH08-M-Red',0,0,'[[regtime]]','[[regtime]]'),(174,9,'simple','MH08-L-Brown',0,0,'[[regtime]]','[[regtime]]'),(175,9,'simple','MH08-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(176,9,'simple','MH08-L-Red',0,0,'[[regtime]]','[[regtime]]'),(177,9,'simple','MH08-XL-Brown',0,0,'[[regtime]]','[[regtime]]'),(178,9,'simple','MH08-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(179,9,'simple','MH08-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(180,9,'configurable','MH08',1,0,'[[regtime]]','[[regtime]]'),(181,9,'simple','MH09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(182,9,'simple','MH09-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(183,9,'simple','MH09-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(184,9,'simple','MH09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(185,9,'simple','MH09-S-Green',0,0,'[[regtime]]','[[regtime]]'),(186,9,'simple','MH09-S-Red',0,0,'[[regtime]]','[[regtime]]'),(187,9,'simple','MH09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(188,9,'simple','MH09-M-Green',0,0,'[[regtime]]','[[regtime]]'),(189,9,'simple','MH09-M-Red',0,0,'[[regtime]]','[[regtime]]'),(190,9,'simple','MH09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(191,9,'simple','MH09-L-Green',0,0,'[[regtime]]','[[regtime]]'),(192,9,'simple','MH09-L-Red',0,0,'[[regtime]]','[[regtime]]'),(193,9,'simple','MH09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(194,9,'simple','MH09-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(195,9,'simple','MH09-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(196,9,'configurable','MH09',1,0,'[[regtime]]','[[regtime]]'),(197,9,'simple','MH10-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(198,9,'simple','MH10-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(199,9,'simple','MH10-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(200,9,'simple','MH10-S-Black',0,0,'[[regtime]]','[[regtime]]'),(201,9,'simple','MH10-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(202,9,'simple','MH10-S-Red',0,0,'[[regtime]]','[[regtime]]'),(203,9,'simple','MH10-M-Black',0,0,'[[regtime]]','[[regtime]]'),(204,9,'simple','MH10-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(205,9,'simple','MH10-M-Red',0,0,'[[regtime]]','[[regtime]]'),(206,9,'simple','MH10-L-Black',0,0,'[[regtime]]','[[regtime]]'),(207,9,'simple','MH10-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(208,9,'simple','MH10-L-Red',0,0,'[[regtime]]','[[regtime]]'),(209,9,'simple','MH10-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(210,9,'simple','MH10-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(211,9,'simple','MH10-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(212,9,'configurable','MH10',1,0,'[[regtime]]','[[regtime]]'),(213,9,'simple','MH11-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(214,9,'simple','MH11-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(215,9,'simple','MH11-XS-White',0,0,'[[regtime]]','[[regtime]]'),(216,9,'simple','MH11-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(217,9,'simple','MH11-S-Red',0,0,'[[regtime]]','[[regtime]]'),(218,9,'simple','MH11-S-White',0,0,'[[regtime]]','[[regtime]]'),(219,9,'simple','MH11-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(220,9,'simple','MH11-M-Red',0,0,'[[regtime]]','[[regtime]]'),(221,9,'simple','MH11-M-White',0,0,'[[regtime]]','[[regtime]]'),(222,9,'simple','MH11-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(223,9,'simple','MH11-L-Red',0,0,'[[regtime]]','[[regtime]]'),(224,9,'simple','MH11-L-White',0,0,'[[regtime]]','[[regtime]]'),(225,9,'simple','MH11-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(226,9,'simple','MH11-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(227,9,'simple','MH11-XL-White',0,0,'[[regtime]]','[[regtime]]'),(228,9,'configurable','MH11',1,0,'[[regtime]]','[[regtime]]'),(229,9,'simple','MH12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(230,9,'simple','MH12-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(231,9,'simple','MH12-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(232,9,'simple','MH12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(233,9,'simple','MH12-S-Green',0,0,'[[regtime]]','[[regtime]]'),(234,9,'simple','MH12-S-Red',0,0,'[[regtime]]','[[regtime]]'),(235,9,'simple','MH12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(236,9,'simple','MH12-M-Green',0,0,'[[regtime]]','[[regtime]]'),(237,9,'simple','MH12-M-Red',0,0,'[[regtime]]','[[regtime]]'),(238,9,'simple','MH12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(239,9,'simple','MH12-L-Green',0,0,'[[regtime]]','[[regtime]]'),(240,9,'simple','MH12-L-Red',0,0,'[[regtime]]','[[regtime]]'),(241,9,'simple','MH12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(242,9,'simple','MH12-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(243,9,'simple','MH12-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(244,9,'configurable','MH12',1,0,'[[regtime]]','[[regtime]]'),(245,9,'simple','MH13-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(246,9,'simple','MH13-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(247,9,'simple','MH13-XS-Lavender',0,0,'[[regtime]]','[[regtime]]'),(248,9,'simple','MH13-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(249,9,'simple','MH13-S-Green',0,0,'[[regtime]]','[[regtime]]'),(250,9,'simple','MH13-S-Lavender',0,0,'[[regtime]]','[[regtime]]'),(251,9,'simple','MH13-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(252,9,'simple','MH13-M-Green',0,0,'[[regtime]]','[[regtime]]'),(253,9,'simple','MH13-M-Lavender',0,0,'[[regtime]]','[[regtime]]'),(254,9,'simple','MH13-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(255,9,'simple','MH13-L-Green',0,0,'[[regtime]]','[[regtime]]'),(256,9,'simple','MH13-L-Lavender',0,0,'[[regtime]]','[[regtime]]'),(257,9,'simple','MH13-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(258,9,'simple','MH13-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(259,9,'simple','MH13-XL-Lavender',0,0,'[[regtime]]','[[regtime]]'),(260,9,'configurable','MH13',1,0,'[[regtime]]','[[regtime]]'),(261,9,'simple','MJ01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(262,9,'simple','MJ01-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(263,9,'simple','MJ01-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(264,9,'simple','MJ01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(265,9,'simple','MJ01-S-Red',0,0,'[[regtime]]','[[regtime]]'),(266,9,'simple','MJ01-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(267,9,'simple','MJ01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(268,9,'simple','MJ01-M-Red',0,0,'[[regtime]]','[[regtime]]'),(269,9,'simple','MJ01-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(270,9,'simple','MJ01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(271,9,'simple','MJ01-L-Red',0,0,'[[regtime]]','[[regtime]]'),(272,9,'simple','MJ01-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(273,9,'simple','MJ01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(274,9,'simple','MJ01-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(275,9,'simple','MJ01-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(276,9,'configurable','MJ01',1,0,'[[regtime]]','[[regtime]]'),(277,9,'simple','MJ02-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(278,9,'simple','MJ02-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(279,9,'simple','MJ02-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(280,9,'simple','MJ02-S-Green',0,0,'[[regtime]]','[[regtime]]'),(281,9,'simple','MJ02-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(282,9,'simple','MJ02-S-Red',0,0,'[[regtime]]','[[regtime]]'),(283,9,'simple','MJ02-M-Green',0,0,'[[regtime]]','[[regtime]]'),(284,9,'simple','MJ02-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(285,9,'simple','MJ02-M-Red',0,0,'[[regtime]]','[[regtime]]'),(286,9,'simple','MJ02-L-Green',0,0,'[[regtime]]','[[regtime]]'),(287,9,'simple','MJ02-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(288,9,'simple','MJ02-L-Red',0,0,'[[regtime]]','[[regtime]]'),(289,9,'simple','MJ02-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(290,9,'simple','MJ02-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(291,9,'simple','MJ02-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(292,9,'configurable','MJ02',1,0,'[[regtime]]','[[regtime]]'),(293,9,'simple','MJ04-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(294,9,'simple','MJ04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(295,9,'simple','MJ04-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(296,9,'simple','MJ04-S-Black',0,0,'[[regtime]]','[[regtime]]'),(297,9,'simple','MJ04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(298,9,'simple','MJ04-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(299,9,'simple','MJ04-M-Black',0,0,'[[regtime]]','[[regtime]]'),(300,9,'simple','MJ04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(301,9,'simple','MJ04-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(302,9,'simple','MJ04-L-Black',0,0,'[[regtime]]','[[regtime]]'),(303,9,'simple','MJ04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(304,9,'simple','MJ04-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(305,9,'simple','MJ04-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(306,9,'simple','MJ04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(307,9,'simple','MJ04-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(308,9,'configurable','MJ04',1,0,'[[regtime]]','[[regtime]]'),(309,9,'simple','MJ07-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(310,9,'simple','MJ07-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(311,9,'simple','MJ07-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(312,9,'simple','MJ07-S-Black',0,0,'[[regtime]]','[[regtime]]'),(313,9,'simple','MJ07-S-Red',0,0,'[[regtime]]','[[regtime]]'),(314,9,'simple','MJ07-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(315,9,'simple','MJ07-M-Black',0,0,'[[regtime]]','[[regtime]]'),(316,9,'simple','MJ07-M-Red',0,0,'[[regtime]]','[[regtime]]'),(317,9,'simple','MJ07-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(318,9,'simple','MJ07-L-Black',0,0,'[[regtime]]','[[regtime]]'),(319,9,'simple','MJ07-L-Red',0,0,'[[regtime]]','[[regtime]]'),(320,9,'simple','MJ07-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(321,9,'simple','MJ07-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(322,9,'simple','MJ07-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(323,9,'simple','MJ07-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(324,9,'configurable','MJ07',1,0,'[[regtime]]','[[regtime]]'),(325,9,'simple','MJ08-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(326,9,'simple','MJ08-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(327,9,'simple','MJ08-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(328,9,'simple','MJ08-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(329,9,'simple','MJ08-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(330,9,'simple','MJ08-S-Green',0,0,'[[regtime]]','[[regtime]]'),(331,9,'simple','MJ08-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(332,9,'simple','MJ08-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(333,9,'simple','MJ08-M-Green',0,0,'[[regtime]]','[[regtime]]'),(334,9,'simple','MJ08-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(335,9,'simple','MJ08-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(336,9,'simple','MJ08-L-Green',0,0,'[[regtime]]','[[regtime]]'),(337,9,'simple','MJ08-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(338,9,'simple','MJ08-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(339,9,'simple','MJ08-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(340,9,'configurable','MJ08',1,0,'[[regtime]]','[[regtime]]'),(341,9,'simple','MJ09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(342,9,'simple','MJ09-XS-White',0,0,'[[regtime]]','[[regtime]]'),(343,9,'simple','MJ09-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(344,9,'simple','MJ09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(345,9,'simple','MJ09-S-White',0,0,'[[regtime]]','[[regtime]]'),(346,9,'simple','MJ09-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(347,9,'simple','MJ09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(348,9,'simple','MJ09-M-White',0,0,'[[regtime]]','[[regtime]]'),(349,9,'simple','MJ09-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(350,9,'simple','MJ09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(351,9,'simple','MJ09-L-White',0,0,'[[regtime]]','[[regtime]]'),(352,9,'simple','MJ09-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(353,9,'simple','MJ09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(354,9,'simple','MJ09-XL-White',0,0,'[[regtime]]','[[regtime]]'),(355,9,'simple','MJ09-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(356,9,'configurable','MJ09',1,0,'[[regtime]]','[[regtime]]'),(357,9,'simple','MJ10-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(358,9,'simple','MJ10-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(359,9,'simple','MJ10-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(360,9,'simple','MJ10-S-Black',0,0,'[[regtime]]','[[regtime]]'),(361,9,'simple','MJ10-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(362,9,'simple','MJ10-S-Red',0,0,'[[regtime]]','[[regtime]]'),(363,9,'simple','MJ10-M-Black',0,0,'[[regtime]]','[[regtime]]'),(364,9,'simple','MJ10-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(365,9,'simple','MJ10-M-Red',0,0,'[[regtime]]','[[regtime]]'),(366,9,'simple','MJ10-L-Black',0,0,'[[regtime]]','[[regtime]]'),(367,9,'simple','MJ10-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(368,9,'simple','MJ10-L-Red',0,0,'[[regtime]]','[[regtime]]'),(369,9,'simple','MJ10-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(370,9,'simple','MJ10-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(371,9,'simple','MJ10-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(372,9,'configurable','MJ10',1,0,'[[regtime]]','[[regtime]]'),(373,9,'simple','MJ11-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(374,9,'simple','MJ11-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(375,9,'simple','MJ11-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(376,9,'simple','MJ11-S-Black',0,0,'[[regtime]]','[[regtime]]'),(377,9,'simple','MJ11-S-Green',0,0,'[[regtime]]','[[regtime]]'),(378,9,'simple','MJ11-S-Red',0,0,'[[regtime]]','[[regtime]]'),(379,9,'simple','MJ11-M-Black',0,0,'[[regtime]]','[[regtime]]'),(380,9,'simple','MJ11-M-Green',0,0,'[[regtime]]','[[regtime]]'),(381,9,'simple','MJ11-M-Red',0,0,'[[regtime]]','[[regtime]]'),(382,9,'simple','MJ11-L-Black',0,0,'[[regtime]]','[[regtime]]'),(383,9,'simple','MJ11-L-Green',0,0,'[[regtime]]','[[regtime]]'),(384,9,'simple','MJ11-L-Red',0,0,'[[regtime]]','[[regtime]]'),(385,9,'simple','MJ11-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(386,9,'simple','MJ11-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(387,9,'simple','MJ11-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(388,9,'configurable','MJ11',1,0,'[[regtime]]','[[regtime]]'),(389,9,'simple','MJ06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(390,9,'simple','MJ06-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(391,9,'simple','MJ06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(392,9,'simple','MJ06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(393,9,'simple','MJ06-S-Green',0,0,'[[regtime]]','[[regtime]]'),(394,9,'simple','MJ06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(395,9,'simple','MJ06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(396,9,'simple','MJ06-M-Green',0,0,'[[regtime]]','[[regtime]]'),(397,9,'simple','MJ06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(398,9,'simple','MJ06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(399,9,'simple','MJ06-L-Green',0,0,'[[regtime]]','[[regtime]]'),(400,9,'simple','MJ06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(401,9,'simple','MJ06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(402,9,'simple','MJ06-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(403,9,'simple','MJ06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(404,9,'configurable','MJ06',1,0,'[[regtime]]','[[regtime]]'),(405,9,'simple','MJ03-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(406,9,'simple','MJ03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(407,9,'simple','MJ03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(408,9,'simple','MJ03-S-Black',0,0,'[[regtime]]','[[regtime]]'),(409,9,'simple','MJ03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(410,9,'simple','MJ03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(411,9,'simple','MJ03-M-Black',0,0,'[[regtime]]','[[regtime]]'),(412,9,'simple','MJ03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(413,9,'simple','MJ03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(414,9,'simple','MJ03-L-Black',0,0,'[[regtime]]','[[regtime]]'),(415,9,'simple','MJ03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(416,9,'simple','MJ03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(417,9,'simple','MJ03-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(418,9,'simple','MJ03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(419,9,'simple','MJ03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(420,9,'configurable','MJ03',1,0,'[[regtime]]','[[regtime]]'),(421,9,'simple','MJ12-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(422,9,'simple','MJ12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(423,9,'simple','MJ12-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(424,9,'simple','MJ12-S-Black',0,0,'[[regtime]]','[[regtime]]'),(425,9,'simple','MJ12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(426,9,'simple','MJ12-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(427,9,'simple','MJ12-M-Black',0,0,'[[regtime]]','[[regtime]]'),(428,9,'simple','MJ12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(429,9,'simple','MJ12-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(430,9,'simple','MJ12-L-Black',0,0,'[[regtime]]','[[regtime]]'),(431,9,'simple','MJ12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(432,9,'simple','MJ12-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(433,9,'simple','MJ12-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(434,9,'simple','MJ12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(435,9,'simple','MJ12-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(436,9,'configurable','MJ12',1,0,'[[regtime]]','[[regtime]]'),(437,9,'simple','MS04-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(438,9,'simple','MS04-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(439,9,'simple','MS04-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(440,9,'simple','MS04-S-Black',0,0,'[[regtime]]','[[regtime]]'),(441,9,'simple','MS04-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(442,9,'simple','MS04-S-Red',0,0,'[[regtime]]','[[regtime]]'),(443,9,'simple','MS04-M-Black',0,0,'[[regtime]]','[[regtime]]'),(444,9,'simple','MS04-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(445,9,'simple','MS04-M-Red',0,0,'[[regtime]]','[[regtime]]'),(446,9,'simple','MS04-L-Black',0,0,'[[regtime]]','[[regtime]]'),(447,9,'simple','MS04-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(448,9,'simple','MS04-L-Red',0,0,'[[regtime]]','[[regtime]]'),(449,9,'simple','MS04-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(450,9,'simple','MS04-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(451,9,'simple','MS04-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(452,9,'configurable','MS04',1,0,'[[regtime]]','[[regtime]]'),(453,9,'simple','MS05-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(454,9,'simple','MS05-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(455,9,'simple','MS05-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(456,9,'simple','MS05-S-Black',0,0,'[[regtime]]','[[regtime]]'),(457,9,'simple','MS05-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(458,9,'simple','MS05-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(459,9,'simple','MS05-M-Black',0,0,'[[regtime]]','[[regtime]]'),(460,9,'simple','MS05-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(461,9,'simple','MS05-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(462,9,'simple','MS05-L-Black',0,0,'[[regtime]]','[[regtime]]'),(463,9,'simple','MS05-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(464,9,'simple','MS05-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(465,9,'simple','MS05-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(466,9,'simple','MS05-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(467,9,'simple','MS05-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(468,9,'configurable','MS05',1,0,'[[regtime]]','[[regtime]]'),(469,9,'simple','MS09-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(470,9,'simple','MS09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(471,9,'simple','MS09-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(472,9,'simple','MS09-S-Black',0,0,'[[regtime]]','[[regtime]]'),(473,9,'simple','MS09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(474,9,'simple','MS09-S-Red',0,0,'[[regtime]]','[[regtime]]'),(475,9,'simple','MS09-M-Black',0,0,'[[regtime]]','[[regtime]]'),(476,9,'simple','MS09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(477,9,'simple','MS09-M-Red',0,0,'[[regtime]]','[[regtime]]'),(478,9,'simple','MS09-L-Black',0,0,'[[regtime]]','[[regtime]]'),(479,9,'simple','MS09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(480,9,'simple','MS09-L-Red',0,0,'[[regtime]]','[[regtime]]'),(481,9,'simple','MS09-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(482,9,'simple','MS09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(483,9,'simple','MS09-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(484,9,'configurable','MS09',1,0,'[[regtime]]','[[regtime]]'),(485,9,'simple','MS11-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(486,9,'simple','MS11-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(487,9,'simple','MS11-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(488,9,'simple','MS11-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(489,9,'simple','MS11-S-Green',0,0,'[[regtime]]','[[regtime]]'),(490,9,'simple','MS11-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(491,9,'simple','MS11-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(492,9,'simple','MS11-M-Green',0,0,'[[regtime]]','[[regtime]]'),(493,9,'simple','MS11-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(494,9,'simple','MS11-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(495,9,'simple','MS11-L-Green',0,0,'[[regtime]]','[[regtime]]'),(496,9,'simple','MS11-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(497,9,'simple','MS11-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(498,9,'simple','MS11-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(499,9,'simple','MS11-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(500,9,'configurable','MS11',1,0,'[[regtime]]','[[regtime]]'),(501,9,'simple','MS12-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(502,9,'simple','MS12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(503,9,'simple','MS12-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(504,9,'simple','MS12-S-Black',0,0,'[[regtime]]','[[regtime]]'),(505,9,'simple','MS12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(506,9,'simple','MS12-S-Red',0,0,'[[regtime]]','[[regtime]]'),(507,9,'simple','MS12-M-Black',0,0,'[[regtime]]','[[regtime]]'),(508,9,'simple','MS12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(509,9,'simple','MS12-M-Red',0,0,'[[regtime]]','[[regtime]]'),(510,9,'simple','MS12-L-Black',0,0,'[[regtime]]','[[regtime]]'),(511,9,'simple','MS12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(512,9,'simple','MS12-L-Red',0,0,'[[regtime]]','[[regtime]]'),(513,9,'simple','MS12-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(514,9,'simple','MS12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(515,9,'simple','MS12-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(516,9,'configurable','MS12',1,0,'[[regtime]]','[[regtime]]'),(517,9,'simple','MS03-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(518,9,'simple','MS03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(519,9,'simple','MS03-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(520,9,'simple','MS03-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(521,9,'simple','MS03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(522,9,'simple','MS03-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(523,9,'simple','MS03-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(524,9,'simple','MS03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(525,9,'simple','MS03-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(526,9,'simple','MS03-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(527,9,'simple','MS03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(528,9,'simple','MS03-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(529,9,'simple','MS03-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(530,9,'simple','MS03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(531,9,'simple','MS03-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(532,9,'configurable','MS03',1,0,'[[regtime]]','[[regtime]]'),(533,9,'simple','MS06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(534,9,'simple','MS06-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(535,9,'simple','MS06-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(536,9,'simple','MS06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(537,9,'simple','MS06-S-Green',0,0,'[[regtime]]','[[regtime]]'),(538,9,'simple','MS06-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(539,9,'simple','MS06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(540,9,'simple','MS06-M-Green',0,0,'[[regtime]]','[[regtime]]'),(541,9,'simple','MS06-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(542,9,'simple','MS06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(543,9,'simple','MS06-L-Green',0,0,'[[regtime]]','[[regtime]]'),(544,9,'simple','MS06-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(545,9,'simple','MS06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(546,9,'simple','MS06-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(547,9,'simple','MS06-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(548,9,'configurable','MS06',1,0,'[[regtime]]','[[regtime]]'),(549,9,'simple','MS01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(550,9,'simple','MS01-XS-Brown',0,0,'[[regtime]]','[[regtime]]'),(551,9,'simple','MS01-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(552,9,'simple','MS01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(553,9,'simple','MS01-S-Brown',0,0,'[[regtime]]','[[regtime]]'),(554,9,'simple','MS01-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(555,9,'simple','MS01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(556,9,'simple','MS01-M-Brown',0,0,'[[regtime]]','[[regtime]]'),(557,9,'simple','MS01-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(558,9,'simple','MS01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(559,9,'simple','MS01-L-Brown',0,0,'[[regtime]]','[[regtime]]'),(560,9,'simple','MS01-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(561,9,'simple','MS01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(562,9,'simple','MS01-XL-Brown',0,0,'[[regtime]]','[[regtime]]'),(563,9,'simple','MS01-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(564,9,'configurable','MS01',1,0,'[[regtime]]','[[regtime]]'),(565,9,'simple','MS02-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(566,9,'simple','MS02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(567,9,'simple','MS02-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(568,9,'simple','MS02-S-Black',0,0,'[[regtime]]','[[regtime]]'),(569,9,'simple','MS02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(570,9,'simple','MS02-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(571,9,'simple','MS02-M-Black',0,0,'[[regtime]]','[[regtime]]'),(572,9,'simple','MS02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(573,9,'simple','MS02-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(574,9,'simple','MS02-L-Black',0,0,'[[regtime]]','[[regtime]]'),(575,9,'simple','MS02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(576,9,'simple','MS02-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(577,9,'simple','MS02-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(578,9,'simple','MS02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(579,9,'simple','MS02-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(580,9,'configurable','MS02',1,0,'[[regtime]]','[[regtime]]'),(581,9,'simple','MS10-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(582,9,'simple','MS10-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(583,9,'simple','MS10-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(584,9,'simple','MS10-S-Black',0,0,'[[regtime]]','[[regtime]]'),(585,9,'simple','MS10-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(586,9,'simple','MS10-S-Red',0,0,'[[regtime]]','[[regtime]]'),(587,9,'simple','MS10-M-Black',0,0,'[[regtime]]','[[regtime]]'),(588,9,'simple','MS10-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(589,9,'simple','MS10-M-Red',0,0,'[[regtime]]','[[regtime]]'),(590,9,'simple','MS10-L-Black',0,0,'[[regtime]]','[[regtime]]'),(591,9,'simple','MS10-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(592,9,'simple','MS10-L-Red',0,0,'[[regtime]]','[[regtime]]'),(593,9,'simple','MS10-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(594,9,'simple','MS10-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(595,9,'simple','MS10-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(596,9,'configurable','MS10',1,0,'[[regtime]]','[[regtime]]'),(597,9,'simple','MS07-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(598,9,'simple','MS07-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(599,9,'simple','MS07-XS-White',0,0,'[[regtime]]','[[regtime]]'),(600,9,'simple','MS07-S-Black',0,0,'[[regtime]]','[[regtime]]'),(601,9,'simple','MS07-S-Green',0,0,'[[regtime]]','[[regtime]]'),(602,9,'simple','MS07-S-White',0,0,'[[regtime]]','[[regtime]]'),(603,9,'simple','MS07-M-Black',0,0,'[[regtime]]','[[regtime]]'),(604,9,'simple','MS07-M-Green',0,0,'[[regtime]]','[[regtime]]'),(605,9,'simple','MS07-M-White',0,0,'[[regtime]]','[[regtime]]'),(606,9,'simple','MS07-L-Black',0,0,'[[regtime]]','[[regtime]]'),(607,9,'simple','MS07-L-Green',0,0,'[[regtime]]','[[regtime]]'),(608,9,'simple','MS07-L-White',0,0,'[[regtime]]','[[regtime]]'),(609,9,'simple','MS07-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(610,9,'simple','MS07-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(611,9,'simple','MS07-XL-White',0,0,'[[regtime]]','[[regtime]]'),(612,9,'configurable','MS07',1,0,'[[regtime]]','[[regtime]]'),(613,9,'simple','MS08-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(614,9,'simple','MS08-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(615,9,'simple','MS08-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(616,9,'simple','MS08-S-Black',0,0,'[[regtime]]','[[regtime]]'),(617,9,'simple','MS08-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(618,9,'simple','MS08-S-Red',0,0,'[[regtime]]','[[regtime]]'),(619,9,'simple','MS08-M-Black',0,0,'[[regtime]]','[[regtime]]'),(620,9,'simple','MS08-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(621,9,'simple','MS08-M-Red',0,0,'[[regtime]]','[[regtime]]'),(622,9,'simple','MS08-L-Black',0,0,'[[regtime]]','[[regtime]]'),(623,9,'simple','MS08-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(624,9,'simple','MS08-L-Red',0,0,'[[regtime]]','[[regtime]]'),(625,9,'simple','MS08-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(626,9,'simple','MS08-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(627,9,'simple','MS08-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(628,9,'configurable','MS08',1,0,'[[regtime]]','[[regtime]]'),(629,9,'simple','MT01-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(630,9,'simple','MT01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(631,9,'simple','MT01-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(632,9,'simple','MT01-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(633,9,'simple','MT01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(634,9,'simple','MT01-S-Red',0,0,'[[regtime]]','[[regtime]]'),(635,9,'simple','MT01-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(636,9,'simple','MT01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(637,9,'simple','MT01-M-Red',0,0,'[[regtime]]','[[regtime]]'),(638,9,'simple','MT01-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(639,9,'simple','MT01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(640,9,'simple','MT01-L-Red',0,0,'[[regtime]]','[[regtime]]'),(641,9,'simple','MT01-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(642,9,'simple','MT01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(643,9,'simple','MT01-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(644,9,'configurable','MT01',1,0,'[[regtime]]','[[regtime]]'),(645,9,'simple','MT02-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(646,9,'simple','MT02-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(647,9,'simple','MT02-XS-White',0,0,'[[regtime]]','[[regtime]]'),(648,9,'simple','MT02-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(649,9,'simple','MT02-S-Red',0,0,'[[regtime]]','[[regtime]]'),(650,9,'simple','MT02-S-White',0,0,'[[regtime]]','[[regtime]]'),(651,9,'simple','MT02-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(652,9,'simple','MT02-M-Red',0,0,'[[regtime]]','[[regtime]]'),(653,9,'simple','MT02-M-White',0,0,'[[regtime]]','[[regtime]]'),(654,9,'simple','MT02-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(655,9,'simple','MT02-L-Red',0,0,'[[regtime]]','[[regtime]]'),(656,9,'simple','MT02-L-White',0,0,'[[regtime]]','[[regtime]]'),(657,9,'simple','MT02-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(658,9,'simple','MT02-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(659,9,'simple','MT02-XL-White',0,0,'[[regtime]]','[[regtime]]'),(660,9,'configurable','MT02',1,0,'[[regtime]]','[[regtime]]'),(661,9,'simple','MT03-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(662,9,'simple','MT03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(663,9,'simple','MT03-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(664,9,'simple','MT03-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(665,9,'simple','MT03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(666,9,'simple','MT03-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(667,9,'simple','MT03-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(668,9,'simple','MT03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(669,9,'simple','MT03-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(670,9,'simple','MT03-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(671,9,'simple','MT03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(672,9,'simple','MT03-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(673,9,'simple','MT03-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(674,9,'simple','MT03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(675,9,'simple','MT03-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(676,9,'configurable','MT03',1,0,'[[regtime]]','[[regtime]]'),(677,9,'simple','MT04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(678,9,'simple','MT04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(679,9,'simple','MT04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(680,9,'simple','MT04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(681,9,'simple','MT04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(682,9,'configurable','MT04',1,0,'[[regtime]]','[[regtime]]'),(683,9,'simple','MT05-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(684,9,'simple','MT05-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(685,9,'simple','MT05-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(686,9,'simple','MT05-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(687,9,'simple','MT05-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(688,9,'configurable','MT05',1,0,'[[regtime]]','[[regtime]]'),(689,9,'simple','MT06-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(690,9,'simple','MT06-S-Black',0,0,'[[regtime]]','[[regtime]]'),(691,9,'simple','MT06-M-Black',0,0,'[[regtime]]','[[regtime]]'),(692,9,'simple','MT06-L-Black',0,0,'[[regtime]]','[[regtime]]'),(693,9,'simple','MT06-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(694,9,'configurable','MT06',1,0,'[[regtime]]','[[regtime]]'),(695,9,'simple','MT07-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(696,9,'simple','MT07-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(697,9,'simple','MT07-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(698,9,'simple','MT07-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(699,9,'simple','MT07-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(700,9,'configurable','MT07',1,0,'[[regtime]]','[[regtime]]'),(701,9,'simple','MT08-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(702,9,'simple','MT08-S-Green',0,0,'[[regtime]]','[[regtime]]'),(703,9,'simple','MT08-M-Green',0,0,'[[regtime]]','[[regtime]]'),(704,9,'simple','MT08-L-Green',0,0,'[[regtime]]','[[regtime]]'),(705,9,'simple','MT08-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(706,9,'configurable','MT08',1,0,'[[regtime]]','[[regtime]]'),(707,9,'simple','MT09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(708,9,'simple','MT09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(709,9,'simple','MT09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(710,9,'simple','MT09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(711,9,'simple','MT09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(712,9,'configurable','MT09',1,0,'[[regtime]]','[[regtime]]'),(713,9,'simple','MT10-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(714,9,'simple','MT10-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(715,9,'simple','MT10-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(716,9,'simple','MT10-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(717,9,'simple','MT10-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(718,9,'configurable','MT10',1,0,'[[regtime]]','[[regtime]]'),(719,9,'simple','MT11-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(720,9,'simple','MT11-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(721,9,'simple','MT11-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(722,9,'simple','MT11-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(723,9,'simple','MT11-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(724,9,'configurable','MT11',1,0,'[[regtime]]','[[regtime]]'),(725,9,'simple','MT12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(726,9,'simple','MT12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(727,9,'simple','MT12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(728,9,'simple','MT12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(729,9,'simple','MT12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(730,9,'configurable','MT12',1,0,'[[regtime]]','[[regtime]]'),(731,10,'simple','MP01-32-Black',0,0,'[[regtime]]','[[regtime]]'),(732,10,'simple','MP01-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(733,10,'simple','MP01-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(734,10,'simple','MP01-33-Black',0,0,'[[regtime]]','[[regtime]]'),(735,10,'simple','MP01-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(736,10,'simple','MP01-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(737,10,'simple','MP01-34-Black',0,0,'[[regtime]]','[[regtime]]'),(738,10,'simple','MP01-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(739,10,'simple','MP01-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(740,10,'simple','MP01-36-Black',0,0,'[[regtime]]','[[regtime]]'),(741,10,'simple','MP01-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(742,10,'simple','MP01-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(743,10,'configurable','MP01',1,0,'[[regtime]]','[[regtime]]'),(744,10,'simple','MP02-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(745,10,'simple','MP02-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(746,10,'simple','MP02-32-Red',0,0,'[[regtime]]','[[regtime]]'),(747,10,'simple','MP02-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(748,10,'simple','MP02-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(749,10,'simple','MP02-33-Red',0,0,'[[regtime]]','[[regtime]]'),(750,10,'simple','MP02-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(751,10,'simple','MP02-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(752,10,'simple','MP02-34-Red',0,0,'[[regtime]]','[[regtime]]'),(753,10,'simple','MP02-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(754,10,'simple','MP02-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(755,10,'simple','MP02-36-Red',0,0,'[[regtime]]','[[regtime]]'),(756,10,'configurable','MP02',1,0,'[[regtime]]','[[regtime]]'),(757,10,'simple','MP03-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(758,10,'simple','MP03-32-Green',0,0,'[[regtime]]','[[regtime]]'),(759,10,'simple','MP03-32-Red',0,0,'[[regtime]]','[[regtime]]'),(760,10,'simple','MP03-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(761,10,'simple','MP03-33-Green',0,0,'[[regtime]]','[[regtime]]'),(762,10,'simple','MP03-33-Red',0,0,'[[regtime]]','[[regtime]]'),(763,10,'simple','MP03-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(764,10,'simple','MP03-34-Green',0,0,'[[regtime]]','[[regtime]]'),(765,10,'simple','MP03-34-Red',0,0,'[[regtime]]','[[regtime]]'),(766,10,'simple','MP03-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(767,10,'simple','MP03-36-Green',0,0,'[[regtime]]','[[regtime]]'),(768,10,'simple','MP03-36-Red',0,0,'[[regtime]]','[[regtime]]'),(769,10,'configurable','MP03',1,0,'[[regtime]]','[[regtime]]'),(770,10,'simple','MP04-32-Black',0,0,'[[regtime]]','[[regtime]]'),(771,10,'simple','MP04-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(772,10,'simple','MP04-32-Green',0,0,'[[regtime]]','[[regtime]]'),(773,10,'simple','MP04-33-Black',0,0,'[[regtime]]','[[regtime]]'),(774,10,'simple','MP04-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(775,10,'simple','MP04-33-Green',0,0,'[[regtime]]','[[regtime]]'),(776,10,'simple','MP04-34-Black',0,0,'[[regtime]]','[[regtime]]'),(777,10,'simple','MP04-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(778,10,'simple','MP04-34-Green',0,0,'[[regtime]]','[[regtime]]'),(779,10,'simple','MP04-36-Black',0,0,'[[regtime]]','[[regtime]]'),(780,10,'simple','MP04-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(781,10,'simple','MP04-36-Green',0,0,'[[regtime]]','[[regtime]]'),(782,10,'configurable','MP04',1,0,'[[regtime]]','[[regtime]]'),(783,10,'simple','MP05-32-Black',0,0,'[[regtime]]','[[regtime]]'),(784,10,'simple','MP05-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(785,10,'simple','MP05-32-Green',0,0,'[[regtime]]','[[regtime]]'),(786,10,'simple','MP05-33-Black',0,0,'[[regtime]]','[[regtime]]'),(787,10,'simple','MP05-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(788,10,'simple','MP05-33-Green',0,0,'[[regtime]]','[[regtime]]'),(789,10,'simple','MP05-34-Black',0,0,'[[regtime]]','[[regtime]]'),(790,10,'simple','MP05-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(791,10,'simple','MP05-34-Green',0,0,'[[regtime]]','[[regtime]]'),(792,10,'simple','MP05-36-Black',0,0,'[[regtime]]','[[regtime]]'),(793,10,'simple','MP05-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(794,10,'simple','MP05-36-Green',0,0,'[[regtime]]','[[regtime]]'),(795,10,'configurable','MP05',1,0,'[[regtime]]','[[regtime]]'),(796,10,'simple','MP06-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(797,10,'simple','MP06-32-Green',0,0,'[[regtime]]','[[regtime]]'),(798,10,'simple','MP06-32-Orange',0,0,'[[regtime]]','[[regtime]]'),(799,10,'simple','MP06-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(800,10,'simple','MP06-33-Green',0,0,'[[regtime]]','[[regtime]]'),(801,10,'simple','MP06-33-Orange',0,0,'[[regtime]]','[[regtime]]'),(802,10,'simple','MP06-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(803,10,'simple','MP06-34-Green',0,0,'[[regtime]]','[[regtime]]'),(804,10,'simple','MP06-34-Orange',0,0,'[[regtime]]','[[regtime]]'),(805,10,'simple','MP06-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(806,10,'simple','MP06-36-Green',0,0,'[[regtime]]','[[regtime]]'),(807,10,'simple','MP06-36-Orange',0,0,'[[regtime]]','[[regtime]]'),(808,10,'configurable','MP06',1,0,'[[regtime]]','[[regtime]]'),(809,10,'simple','MP07-32-Black',0,0,'[[regtime]]','[[regtime]]'),(810,10,'simple','MP07-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(811,10,'simple','MP07-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(812,10,'simple','MP07-33-Black',0,0,'[[regtime]]','[[regtime]]'),(813,10,'simple','MP07-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(814,10,'simple','MP07-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(815,10,'simple','MP07-34-Black',0,0,'[[regtime]]','[[regtime]]'),(816,10,'simple','MP07-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(817,10,'simple','MP07-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(818,10,'simple','MP07-36-Black',0,0,'[[regtime]]','[[regtime]]'),(819,10,'simple','MP07-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(820,10,'simple','MP07-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(821,10,'configurable','MP07',1,0,'[[regtime]]','[[regtime]]'),(822,10,'simple','MP08-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(823,10,'simple','MP08-32-Green',0,0,'[[regtime]]','[[regtime]]'),(824,10,'simple','MP08-32-Red',0,0,'[[regtime]]','[[regtime]]'),(825,10,'simple','MP08-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(826,10,'simple','MP08-33-Green',0,0,'[[regtime]]','[[regtime]]'),(827,10,'simple','MP08-33-Red',0,0,'[[regtime]]','[[regtime]]'),(828,10,'simple','MP08-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(829,10,'simple','MP08-34-Green',0,0,'[[regtime]]','[[regtime]]'),(830,10,'simple','MP08-34-Red',0,0,'[[regtime]]','[[regtime]]'),(831,10,'simple','MP08-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(832,10,'simple','MP08-36-Green',0,0,'[[regtime]]','[[regtime]]'),(833,10,'simple','MP08-36-Red',0,0,'[[regtime]]','[[regtime]]'),(834,10,'configurable','MP08',1,0,'[[regtime]]','[[regtime]]'),(835,10,'simple','MP09-32-Black',0,0,'[[regtime]]','[[regtime]]'),(836,10,'simple','MP09-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(837,10,'simple','MP09-32-Red',0,0,'[[regtime]]','[[regtime]]'),(838,10,'simple','MP09-33-Black',0,0,'[[regtime]]','[[regtime]]'),(839,10,'simple','MP09-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(840,10,'simple','MP09-33-Red',0,0,'[[regtime]]','[[regtime]]'),(841,10,'simple','MP09-34-Black',0,0,'[[regtime]]','[[regtime]]'),(842,10,'simple','MP09-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(843,10,'simple','MP09-34-Red',0,0,'[[regtime]]','[[regtime]]'),(844,10,'simple','MP09-36-Black',0,0,'[[regtime]]','[[regtime]]'),(845,10,'simple','MP09-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(846,10,'simple','MP09-36-Red',0,0,'[[regtime]]','[[regtime]]'),(847,10,'configurable','MP09',1,0,'[[regtime]]','[[regtime]]'),(848,10,'simple','MP10-32-Black',0,0,'[[regtime]]','[[regtime]]'),(849,10,'simple','MP10-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(850,10,'simple','MP10-32-Green',0,0,'[[regtime]]','[[regtime]]'),(851,10,'simple','MP10-33-Black',0,0,'[[regtime]]','[[regtime]]'),(852,10,'simple','MP10-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(853,10,'simple','MP10-33-Green',0,0,'[[regtime]]','[[regtime]]'),(854,10,'simple','MP10-34-Black',0,0,'[[regtime]]','[[regtime]]'),(855,10,'simple','MP10-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(856,10,'simple','MP10-34-Green',0,0,'[[regtime]]','[[regtime]]'),(857,10,'simple','MP10-36-Black',0,0,'[[regtime]]','[[regtime]]'),(858,10,'simple','MP10-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(859,10,'simple','MP10-36-Green',0,0,'[[regtime]]','[[regtime]]'),(860,10,'configurable','MP10',1,0,'[[regtime]]','[[regtime]]'),(861,10,'simple','MP11-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(862,10,'simple','MP11-32-Brown',0,0,'[[regtime]]','[[regtime]]'),(863,10,'simple','MP11-32-Green',0,0,'[[regtime]]','[[regtime]]'),(864,10,'simple','MP11-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(865,10,'simple','MP11-33-Brown',0,0,'[[regtime]]','[[regtime]]'),(866,10,'simple','MP11-33-Green',0,0,'[[regtime]]','[[regtime]]'),(867,10,'simple','MP11-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(868,10,'simple','MP11-34-Brown',0,0,'[[regtime]]','[[regtime]]'),(869,10,'simple','MP11-34-Green',0,0,'[[regtime]]','[[regtime]]'),(870,10,'simple','MP11-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(871,10,'simple','MP11-36-Brown',0,0,'[[regtime]]','[[regtime]]'),(872,10,'simple','MP11-36-Green',0,0,'[[regtime]]','[[regtime]]'),(873,10,'configurable','MP11',1,0,'[[regtime]]','[[regtime]]'),(874,10,'simple','MP12-32-Black',0,0,'[[regtime]]','[[regtime]]'),(875,10,'simple','MP12-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(876,10,'simple','MP12-32-Red',0,0,'[[regtime]]','[[regtime]]'),(877,10,'simple','MP12-33-Black',0,0,'[[regtime]]','[[regtime]]'),(878,10,'simple','MP12-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(879,10,'simple','MP12-33-Red',0,0,'[[regtime]]','[[regtime]]'),(880,10,'simple','MP12-34-Black',0,0,'[[regtime]]','[[regtime]]'),(881,10,'simple','MP12-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(882,10,'simple','MP12-34-Red',0,0,'[[regtime]]','[[regtime]]'),(883,10,'simple','MP12-36-Black',0,0,'[[regtime]]','[[regtime]]'),(884,10,'simple','MP12-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(885,10,'simple','MP12-36-Red',0,0,'[[regtime]]','[[regtime]]'),(886,10,'configurable','MP12',1,0,'[[regtime]]','[[regtime]]'),(887,10,'simple','MSH01-32-Black',0,0,'[[regtime]]','[[regtime]]'),(888,10,'simple','MSH01-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(889,10,'simple','MSH01-32-Red',0,0,'[[regtime]]','[[regtime]]'),(890,10,'simple','MSH01-33-Black',0,0,'[[regtime]]','[[regtime]]'),(891,10,'simple','MSH01-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(892,10,'simple','MSH01-33-Red',0,0,'[[regtime]]','[[regtime]]'),(893,10,'simple','MSH01-34-Black',0,0,'[[regtime]]','[[regtime]]'),(894,10,'simple','MSH01-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(895,10,'simple','MSH01-34-Red',0,0,'[[regtime]]','[[regtime]]'),(896,10,'simple','MSH01-36-Black',0,0,'[[regtime]]','[[regtime]]'),(897,10,'simple','MSH01-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(898,10,'simple','MSH01-36-Red',0,0,'[[regtime]]','[[regtime]]'),(899,10,'configurable','MSH01',1,0,'[[regtime]]','[[regtime]]'),(900,10,'simple','MSH02-32-Black',0,0,'[[regtime]]','[[regtime]]'),(901,10,'simple','MSH02-33-Black',0,0,'[[regtime]]','[[regtime]]'),(902,10,'simple','MSH02-34-Black',0,0,'[[regtime]]','[[regtime]]'),(903,10,'simple','MSH02-36-Black',0,0,'[[regtime]]','[[regtime]]'),(904,10,'configurable','MSH02',1,0,'[[regtime]]','[[regtime]]'),(905,10,'simple','MSH03-32-Black',0,0,'[[regtime]]','[[regtime]]'),(906,10,'simple','MSH03-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(907,10,'simple','MSH03-32-Green',0,0,'[[regtime]]','[[regtime]]'),(908,10,'simple','MSH03-33-Black',0,0,'[[regtime]]','[[regtime]]'),(909,10,'simple','MSH03-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(910,10,'simple','MSH03-33-Green',0,0,'[[regtime]]','[[regtime]]'),(911,10,'simple','MSH03-34-Black',0,0,'[[regtime]]','[[regtime]]'),(912,10,'simple','MSH03-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(913,10,'simple','MSH03-34-Green',0,0,'[[regtime]]','[[regtime]]'),(914,10,'simple','MSH03-36-Black',0,0,'[[regtime]]','[[regtime]]'),(915,10,'simple','MSH03-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(916,10,'simple','MSH03-36-Green',0,0,'[[regtime]]','[[regtime]]'),(917,10,'configurable','MSH03',1,0,'[[regtime]]','[[regtime]]'),(918,10,'simple','MSH04-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(919,10,'simple','MSH04-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(920,10,'simple','MSH04-32-Yellow',0,0,'[[regtime]]','[[regtime]]'),(921,10,'simple','MSH04-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(922,10,'simple','MSH04-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(923,10,'simple','MSH04-33-Yellow',0,0,'[[regtime]]','[[regtime]]'),(924,10,'simple','MSH04-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(925,10,'simple','MSH04-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(926,10,'simple','MSH04-34-Yellow',0,0,'[[regtime]]','[[regtime]]'),(927,10,'simple','MSH04-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(928,10,'simple','MSH04-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(929,10,'simple','MSH04-36-Yellow',0,0,'[[regtime]]','[[regtime]]'),(930,10,'configurable','MSH04',1,0,'[[regtime]]','[[regtime]]'),(931,10,'simple','MSH05-32-Black',0,0,'[[regtime]]','[[regtime]]'),(932,10,'simple','MSH05-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(933,10,'simple','MSH05-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(934,10,'simple','MSH05-33-Black',0,0,'[[regtime]]','[[regtime]]'),(935,10,'simple','MSH05-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(936,10,'simple','MSH05-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(937,10,'simple','MSH05-34-Black',0,0,'[[regtime]]','[[regtime]]'),(938,10,'simple','MSH05-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(939,10,'simple','MSH05-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(940,10,'simple','MSH05-36-Black',0,0,'[[regtime]]','[[regtime]]'),(941,10,'simple','MSH05-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(942,10,'simple','MSH05-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(943,10,'configurable','MSH05',1,0,'[[regtime]]','[[regtime]]'),(944,10,'simple','MSH06-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(945,10,'simple','MSH06-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(946,10,'simple','MSH06-32-Red',0,0,'[[regtime]]','[[regtime]]'),(947,10,'simple','MSH06-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(948,10,'simple','MSH06-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(949,10,'simple','MSH06-33-Red',0,0,'[[regtime]]','[[regtime]]'),(950,10,'simple','MSH06-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(951,10,'simple','MSH06-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(952,10,'simple','MSH06-34-Red',0,0,'[[regtime]]','[[regtime]]'),(953,10,'simple','MSH06-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(954,10,'simple','MSH06-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(955,10,'simple','MSH06-36-Red',0,0,'[[regtime]]','[[regtime]]'),(956,10,'configurable','MSH06',1,0,'[[regtime]]','[[regtime]]'),(957,10,'simple','MSH07-32-Black',0,0,'[[regtime]]','[[regtime]]'),(958,10,'simple','MSH07-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(959,10,'simple','MSH07-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(960,10,'simple','MSH07-33-Black',0,0,'[[regtime]]','[[regtime]]'),(961,10,'simple','MSH07-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(962,10,'simple','MSH07-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(963,10,'simple','MSH07-34-Black',0,0,'[[regtime]]','[[regtime]]'),(964,10,'simple','MSH07-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(965,10,'simple','MSH07-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(966,10,'simple','MSH07-36-Black',0,0,'[[regtime]]','[[regtime]]'),(967,10,'simple','MSH07-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(968,10,'simple','MSH07-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(969,10,'configurable','MSH07',1,0,'[[regtime]]','[[regtime]]'),(970,10,'simple','MSH08-32-Black',0,0,'[[regtime]]','[[regtime]]'),(971,10,'simple','MSH08-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(972,10,'simple','MSH08-32-Green',0,0,'[[regtime]]','[[regtime]]'),(973,10,'simple','MSH08-33-Black',0,0,'[[regtime]]','[[regtime]]'),(974,10,'simple','MSH08-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(975,10,'simple','MSH08-33-Green',0,0,'[[regtime]]','[[regtime]]'),(976,10,'simple','MSH08-34-Black',0,0,'[[regtime]]','[[regtime]]'),(977,10,'simple','MSH08-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(978,10,'simple','MSH08-34-Green',0,0,'[[regtime]]','[[regtime]]'),(979,10,'simple','MSH08-36-Black',0,0,'[[regtime]]','[[regtime]]'),(980,10,'simple','MSH08-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(981,10,'simple','MSH08-36-Green',0,0,'[[regtime]]','[[regtime]]'),(982,10,'configurable','MSH08',1,0,'[[regtime]]','[[regtime]]'),(983,10,'simple','MSH09-32-Black',0,0,'[[regtime]]','[[regtime]]'),(984,10,'simple','MSH09-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(985,10,'simple','MSH09-32-Green',0,0,'[[regtime]]','[[regtime]]'),(986,10,'simple','MSH09-33-Black',0,0,'[[regtime]]','[[regtime]]'),(987,10,'simple','MSH09-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(988,10,'simple','MSH09-33-Green',0,0,'[[regtime]]','[[regtime]]'),(989,10,'simple','MSH09-34-Black',0,0,'[[regtime]]','[[regtime]]'),(990,10,'simple','MSH09-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(991,10,'simple','MSH09-34-Green',0,0,'[[regtime]]','[[regtime]]'),(992,10,'simple','MSH09-36-Black',0,0,'[[regtime]]','[[regtime]]'),(993,10,'simple','MSH09-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(994,10,'simple','MSH09-36-Green',0,0,'[[regtime]]','[[regtime]]'),(995,10,'configurable','MSH09',1,0,'[[regtime]]','[[regtime]]'),(996,10,'simple','MSH10-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(997,10,'simple','MSH10-32-Green',0,0,'[[regtime]]','[[regtime]]'),(998,10,'simple','MSH10-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(999,10,'simple','MSH10-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(1000,10,'simple','MSH10-33-Green',0,0,'[[regtime]]','[[regtime]]'),(1001,10,'simple','MSH10-33-Purple',0,0,'[[regtime]]','[[regtime]]'),(1002,10,'simple','MSH10-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(1003,10,'simple','MSH10-34-Green',0,0,'[[regtime]]','[[regtime]]'),(1004,10,'simple','MSH10-34-Purple',0,0,'[[regtime]]','[[regtime]]'),(1005,10,'simple','MSH10-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(1006,10,'simple','MSH10-36-Green',0,0,'[[regtime]]','[[regtime]]'),(1007,10,'simple','MSH10-36-Purple',0,0,'[[regtime]]','[[regtime]]'),(1008,10,'configurable','MSH10',1,0,'[[regtime]]','[[regtime]]'),(1009,10,'simple','MSH11-32-Black',0,0,'[[regtime]]','[[regtime]]'),(1010,10,'simple','MSH11-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(1011,10,'simple','MSH11-32-Red',0,0,'[[regtime]]','[[regtime]]'),(1012,10,'simple','MSH11-33-Black',0,0,'[[regtime]]','[[regtime]]'),(1013,10,'simple','MSH11-33-Blue',0,0,'[[regtime]]','[[regtime]]'),(1014,10,'simple','MSH11-33-Red',0,0,'[[regtime]]','[[regtime]]'),(1015,10,'simple','MSH11-34-Black',0,0,'[[regtime]]','[[regtime]]'),(1016,10,'simple','MSH11-34-Blue',0,0,'[[regtime]]','[[regtime]]'),(1017,10,'simple','MSH11-34-Red',0,0,'[[regtime]]','[[regtime]]'),(1018,10,'simple','MSH11-36-Black',0,0,'[[regtime]]','[[regtime]]'),(1019,10,'simple','MSH11-36-Blue',0,0,'[[regtime]]','[[regtime]]'),(1020,10,'simple','MSH11-36-Red',0,0,'[[regtime]]','[[regtime]]'),(1021,10,'configurable','MSH11',1,0,'[[regtime]]','[[regtime]]'),(1022,10,'simple','MSH12-32-Black',0,0,'[[regtime]]','[[regtime]]'),(1023,10,'simple','MSH12-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(1024,10,'simple','MSH12-32-Red',0,0,'[[regtime]]','[[regtime]]'),(1025,10,'simple','MSH12-33-Black',0,0,'[[regtime]]','[[regtime]]'),(1026,10,'simple','MSH12-33-Gray',0,0,'[[regtime]]','[[regtime]]'),(1027,10,'simple','MSH12-33-Red',0,0,'[[regtime]]','[[regtime]]'),(1028,10,'simple','MSH12-34-Black',0,0,'[[regtime]]','[[regtime]]'),(1029,10,'simple','MSH12-34-Gray',0,0,'[[regtime]]','[[regtime]]'),(1030,10,'simple','MSH12-34-Red',0,0,'[[regtime]]','[[regtime]]'),(1031,10,'simple','MSH12-36-Black',0,0,'[[regtime]]','[[regtime]]'),(1032,10,'simple','MSH12-36-Gray',0,0,'[[regtime]]','[[regtime]]'),(1033,10,'simple','MSH12-36-Red',0,0,'[[regtime]]','[[regtime]]'),(1034,10,'configurable','MSH12',1,0,'[[regtime]]','[[regtime]]'),(1035,9,'simple','WH01-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1036,9,'simple','WH01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1037,9,'simple','WH01-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1038,9,'simple','WH01-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1039,9,'simple','WH01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1040,9,'simple','WH01-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1041,9,'simple','WH01-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1042,9,'simple','WH01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1043,9,'simple','WH01-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1044,9,'simple','WH01-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1045,9,'simple','WH01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1046,9,'simple','WH01-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1047,9,'simple','WH01-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1048,9,'simple','WH01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1049,9,'simple','WH01-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1050,9,'configurable','WH01',1,0,'[[regtime]]','[[regtime]]'),(1051,9,'simple','WH02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1052,9,'simple','WH02-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1053,9,'simple','WH02-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1054,9,'simple','WH02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1055,9,'simple','WH02-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1056,9,'simple','WH02-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1057,9,'simple','WH02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1058,9,'simple','WH02-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1059,9,'simple','WH02-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1060,9,'simple','WH02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1061,9,'simple','WH02-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1062,9,'simple','WH02-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1063,9,'simple','WH02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1064,9,'simple','WH02-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1065,9,'simple','WH02-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1066,9,'configurable','WH02',1,0,'[[regtime]]','[[regtime]]'),(1067,9,'simple','WH03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1068,9,'simple','WH03-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1069,9,'simple','WH03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1070,9,'simple','WH03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1071,9,'simple','WH03-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1072,9,'simple','WH03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1073,9,'simple','WH03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1074,9,'simple','WH03-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1075,9,'simple','WH03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1076,9,'simple','WH03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1077,9,'simple','WH03-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1078,9,'simple','WH03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1079,9,'simple','WH03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1080,9,'simple','WH03-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1081,9,'simple','WH03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1082,9,'configurable','WH03',1,0,'[[regtime]]','[[regtime]]'),(1083,9,'simple','WH04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1084,9,'simple','WH04-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1085,9,'simple','WH04-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1086,9,'simple','WH04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1087,9,'simple','WH04-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1088,9,'simple','WH04-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1089,9,'simple','WH04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1090,9,'simple','WH04-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1091,9,'simple','WH04-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1092,9,'simple','WH04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1093,9,'simple','WH04-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1094,9,'simple','WH04-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1095,9,'simple','WH04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1096,9,'simple','WH04-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1097,9,'simple','WH04-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1098,9,'configurable','WH04',1,0,'[[regtime]]','[[regtime]]'),(1099,9,'simple','WH05-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1100,9,'simple','WH05-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1101,9,'simple','WH05-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1102,9,'simple','WH05-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1103,9,'simple','WH05-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1104,9,'simple','WH05-S-White',0,0,'[[regtime]]','[[regtime]]'),(1105,9,'simple','WH05-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1106,9,'simple','WH05-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1107,9,'simple','WH05-M-White',0,0,'[[regtime]]','[[regtime]]'),(1108,9,'simple','WH05-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1109,9,'simple','WH05-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1110,9,'simple','WH05-L-White',0,0,'[[regtime]]','[[regtime]]'),(1111,9,'simple','WH05-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1112,9,'simple','WH05-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1113,9,'simple','WH05-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1114,9,'configurable','WH05',1,0,'[[regtime]]','[[regtime]]'),(1115,9,'simple','WH06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1116,9,'simple','WH06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1117,9,'simple','WH06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1118,9,'simple','WH06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1119,9,'simple','WH06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1120,9,'configurable','WH06',1,0,'[[regtime]]','[[regtime]]'),(1121,9,'simple','WH07-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1122,9,'simple','WH07-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1123,9,'simple','WH07-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1124,9,'simple','WH07-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1125,9,'simple','WH07-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1126,9,'simple','WH07-S-White',0,0,'[[regtime]]','[[regtime]]'),(1127,9,'simple','WH07-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1128,9,'simple','WH07-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1129,9,'simple','WH07-M-White',0,0,'[[regtime]]','[[regtime]]'),(1130,9,'simple','WH07-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1131,9,'simple','WH07-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1132,9,'simple','WH07-L-White',0,0,'[[regtime]]','[[regtime]]'),(1133,9,'simple','WH07-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1134,9,'simple','WH07-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1135,9,'simple','WH07-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1136,9,'configurable','WH07',1,0,'[[regtime]]','[[regtime]]'),(1137,9,'simple','WH08-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1138,9,'simple','WH08-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1139,9,'simple','WH08-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1140,9,'simple','WH08-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1141,9,'simple','WH08-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1142,9,'simple','WH08-S-White',0,0,'[[regtime]]','[[regtime]]'),(1143,9,'simple','WH08-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1144,9,'simple','WH08-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1145,9,'simple','WH08-M-White',0,0,'[[regtime]]','[[regtime]]'),(1146,9,'simple','WH08-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1147,9,'simple','WH08-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1148,9,'simple','WH08-L-White',0,0,'[[regtime]]','[[regtime]]'),(1149,9,'simple','WH08-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1150,9,'simple','WH08-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1151,9,'simple','WH08-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1152,9,'configurable','WH08',1,0,'[[regtime]]','[[regtime]]'),(1153,9,'simple','WH09-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1154,9,'simple','WH09-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1155,9,'simple','WH09-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1156,9,'simple','WH09-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1157,9,'simple','WH09-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1158,9,'simple','WH09-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1159,9,'simple','WH09-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1160,9,'simple','WH09-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1161,9,'simple','WH09-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1162,9,'simple','WH09-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1163,9,'simple','WH09-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1164,9,'simple','WH09-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1165,9,'simple','WH09-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1166,9,'simple','WH09-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1167,9,'simple','WH09-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1168,9,'configurable','WH09',1,0,'[[regtime]]','[[regtime]]'),(1169,9,'simple','WH10-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1170,9,'simple','WH10-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1171,9,'simple','WH10-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1172,9,'simple','WH10-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1173,9,'simple','WH10-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1174,9,'simple','WH10-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1175,9,'simple','WH10-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1176,9,'simple','WH10-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1177,9,'simple','WH10-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1178,9,'simple','WH10-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1179,9,'simple','WH10-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1180,9,'simple','WH10-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1181,9,'simple','WH10-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1182,9,'simple','WH10-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1183,9,'simple','WH10-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1184,9,'configurable','WH10',1,0,'[[regtime]]','[[regtime]]'),(1185,9,'simple','WH11-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1186,9,'simple','WH11-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1187,9,'simple','WH11-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1188,9,'simple','WH11-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1189,9,'simple','WH11-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1190,9,'simple','WH11-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1191,9,'simple','WH11-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1192,9,'simple','WH11-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1193,9,'simple','WH11-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1194,9,'simple','WH11-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1195,9,'simple','WH11-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1196,9,'simple','WH11-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1197,9,'simple','WH11-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1198,9,'simple','WH11-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1199,9,'simple','WH11-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1200,9,'configurable','WH11',1,0,'[[regtime]]','[[regtime]]'),(1201,9,'simple','WH12-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1202,9,'simple','WH12-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1203,9,'simple','WH12-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1204,9,'simple','WH12-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1205,9,'simple','WH12-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1206,9,'simple','WH12-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1207,9,'simple','WH12-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1208,9,'simple','WH12-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1209,9,'simple','WH12-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1210,9,'simple','WH12-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1211,9,'simple','WH12-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1212,9,'simple','WH12-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1213,9,'simple','WH12-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1214,9,'simple','WH12-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1215,9,'simple','WH12-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1216,9,'configurable','WH12',1,0,'[[regtime]]','[[regtime]]'),(1217,9,'simple','WJ01-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1218,9,'simple','WJ01-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1219,9,'simple','WJ01-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1220,9,'simple','WJ01-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1221,9,'simple','WJ01-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1222,9,'simple','WJ01-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1223,9,'simple','WJ01-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1224,9,'simple','WJ01-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1225,9,'simple','WJ01-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1226,9,'configurable','WJ01',0,0,'[[regtime]]','[[regtime]]'),(1227,9,'simple','WJ02-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1228,9,'simple','WJ02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1229,9,'simple','WJ02-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1230,9,'simple','WJ02-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1231,9,'simple','WJ02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1232,9,'simple','WJ02-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1233,9,'simple','WJ02-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1234,9,'simple','WJ02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1235,9,'simple','WJ02-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1236,9,'simple','WJ02-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1237,9,'simple','WJ02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1238,9,'simple','WJ02-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1239,9,'simple','WJ02-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1240,9,'simple','WJ02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1241,9,'simple','WJ02-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1242,9,'configurable','WJ02',0,0,'[[regtime]]','[[regtime]]'),(1243,9,'simple','WJ03-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1244,9,'simple','WJ03-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1245,9,'simple','WJ03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1246,9,'simple','WJ03-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1247,9,'simple','WJ03-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1248,9,'simple','WJ03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1249,9,'simple','WJ03-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1250,9,'simple','WJ03-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1251,9,'simple','WJ03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1252,9,'simple','WJ03-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1253,9,'simple','WJ03-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1254,9,'simple','WJ03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1255,9,'simple','WJ03-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1256,9,'simple','WJ03-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1257,9,'simple','WJ03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1258,9,'configurable','WJ03',0,0,'[[regtime]]','[[regtime]]'),(1259,9,'simple','WJ04-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1260,9,'simple','WJ04-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1261,9,'simple','WJ04-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1262,9,'simple','WJ04-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1263,9,'simple','WJ04-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1264,9,'simple','WJ04-S-White',0,0,'[[regtime]]','[[regtime]]'),(1265,9,'simple','WJ04-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1266,9,'simple','WJ04-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1267,9,'simple','WJ04-M-White',0,0,'[[regtime]]','[[regtime]]'),(1268,9,'simple','WJ04-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1269,9,'simple','WJ04-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1270,9,'simple','WJ04-L-White',0,0,'[[regtime]]','[[regtime]]'),(1271,9,'simple','WJ04-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1272,9,'simple','WJ04-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1273,9,'simple','WJ04-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1274,9,'configurable','WJ04',0,0,'[[regtime]]','[[regtime]]'),(1275,9,'simple','WJ05-XS-Brown',0,0,'[[regtime]]','[[regtime]]'),(1276,9,'simple','WJ05-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1277,9,'simple','WJ05-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1278,9,'simple','WJ05-S-Brown',0,0,'[[regtime]]','[[regtime]]'),(1279,9,'simple','WJ05-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1280,9,'simple','WJ05-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1281,9,'simple','WJ05-M-Brown',0,0,'[[regtime]]','[[regtime]]'),(1282,9,'simple','WJ05-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1283,9,'simple','WJ05-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1284,9,'simple','WJ05-L-Brown',0,0,'[[regtime]]','[[regtime]]'),(1285,9,'simple','WJ05-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1286,9,'simple','WJ05-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1287,9,'simple','WJ05-XL-Brown',0,0,'[[regtime]]','[[regtime]]'),(1288,9,'simple','WJ05-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1289,9,'simple','WJ05-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1290,9,'configurable','WJ05',0,0,'[[regtime]]','[[regtime]]'),(1291,9,'simple','WJ07-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1292,9,'simple','WJ07-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1293,9,'simple','WJ07-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1294,9,'simple','WJ07-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1295,9,'simple','WJ07-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1296,9,'simple','WJ07-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1297,9,'simple','WJ07-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1298,9,'simple','WJ07-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1299,9,'simple','WJ07-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1300,9,'simple','WJ07-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1301,9,'simple','WJ07-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1302,9,'simple','WJ07-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1303,9,'simple','WJ07-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1304,9,'simple','WJ07-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1305,9,'simple','WJ07-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1306,9,'configurable','WJ07',0,0,'[[regtime]]','[[regtime]]'),(1307,9,'simple','WJ08-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1308,9,'simple','WJ08-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1309,9,'simple','WJ08-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1310,9,'simple','WJ08-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1311,9,'simple','WJ08-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1312,9,'simple','WJ08-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1313,9,'simple','WJ08-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1314,9,'simple','WJ08-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1315,9,'simple','WJ08-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1316,9,'simple','WJ08-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1317,9,'simple','WJ08-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1318,9,'simple','WJ08-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1319,9,'simple','WJ08-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1320,9,'simple','WJ08-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1321,9,'simple','WJ08-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1322,9,'configurable','WJ08',0,0,'[[regtime]]','[[regtime]]'),(1323,9,'simple','WJ09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1324,9,'simple','WJ09-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1325,9,'simple','WJ09-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1326,9,'simple','WJ09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1327,9,'simple','WJ09-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1328,9,'simple','WJ09-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1329,9,'simple','WJ09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1330,9,'simple','WJ09-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1331,9,'simple','WJ09-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1332,9,'simple','WJ09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1333,9,'simple','WJ09-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1334,9,'simple','WJ09-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1335,9,'simple','WJ09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1336,9,'simple','WJ09-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1337,9,'simple','WJ09-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1338,9,'configurable','WJ09',0,0,'[[regtime]]','[[regtime]]'),(1339,9,'simple','WJ10-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1340,9,'simple','WJ10-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1341,9,'simple','WJ10-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1342,9,'simple','WJ10-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1343,9,'simple','WJ10-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1344,9,'simple','WJ10-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1345,9,'simple','WJ10-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1346,9,'simple','WJ10-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1347,9,'simple','WJ10-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1348,9,'simple','WJ10-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1349,9,'simple','WJ10-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1350,9,'simple','WJ10-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1351,9,'simple','WJ10-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1352,9,'simple','WJ10-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1353,9,'simple','WJ10-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1354,9,'configurable','WJ10',0,0,'[[regtime]]','[[regtime]]'),(1355,9,'simple','WJ11-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1356,9,'simple','WJ11-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1357,9,'simple','WJ11-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1358,9,'simple','WJ11-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1359,9,'simple','WJ11-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1360,9,'simple','WJ11-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1361,9,'simple','WJ11-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1362,9,'simple','WJ11-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1363,9,'simple','WJ11-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1364,9,'simple','WJ11-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1365,9,'simple','WJ11-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1366,9,'simple','WJ11-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1367,9,'simple','WJ11-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1368,9,'simple','WJ11-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1369,9,'simple','WJ11-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1370,9,'configurable','WJ11',0,0,'[[regtime]]','[[regtime]]'),(1371,9,'simple','WJ06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1372,9,'simple','WJ06-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1373,9,'simple','WJ06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1374,9,'simple','WJ06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1375,9,'simple','WJ06-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1376,9,'simple','WJ06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1377,9,'simple','WJ06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1378,9,'simple','WJ06-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1379,9,'simple','WJ06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1380,9,'simple','WJ06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1381,9,'simple','WJ06-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1382,9,'simple','WJ06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1383,9,'simple','WJ06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1384,9,'simple','WJ06-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1385,9,'simple','WJ06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1386,9,'configurable','WJ06',0,0,'[[regtime]]','[[regtime]]'),(1387,9,'simple','WJ12-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1388,9,'simple','WJ12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1389,9,'simple','WJ12-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1390,9,'simple','WJ12-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1391,9,'simple','WJ12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1392,9,'simple','WJ12-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1393,9,'simple','WJ12-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1394,9,'simple','WJ12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1395,9,'simple','WJ12-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1396,9,'simple','WJ12-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1397,9,'simple','WJ12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1398,9,'simple','WJ12-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1399,9,'simple','WJ12-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1400,9,'simple','WJ12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1401,9,'simple','WJ12-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1402,9,'configurable','WJ12',0,0,'[[regtime]]','[[regtime]]'),(1403,9,'simple','WS02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1404,9,'simple','WS02-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1405,9,'simple','WS02-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1406,9,'simple','WS02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1407,9,'simple','WS02-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1408,9,'simple','WS02-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1409,9,'simple','WS02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1410,9,'simple','WS02-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1411,9,'simple','WS02-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1412,9,'simple','WS02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1413,9,'simple','WS02-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1414,9,'simple','WS02-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1415,9,'simple','WS02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1416,9,'simple','WS02-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1417,9,'simple','WS02-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1418,9,'configurable','WS02',1,0,'[[regtime]]','[[regtime]]'),(1419,9,'simple','WS03-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1420,9,'simple','WS03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1421,9,'simple','WS03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1422,9,'simple','WS03-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1423,9,'simple','WS03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1424,9,'simple','WS03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1425,9,'simple','WS03-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1426,9,'simple','WS03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1427,9,'simple','WS03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1428,9,'simple','WS03-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1429,9,'simple','WS03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1430,9,'simple','WS03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1431,9,'simple','WS03-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1432,9,'simple','WS03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1433,9,'simple','WS03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1434,9,'configurable','WS03',1,0,'[[regtime]]','[[regtime]]'),(1435,9,'simple','WS04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1436,9,'simple','WS04-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1437,9,'simple','WS04-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1438,9,'simple','WS04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1439,9,'simple','WS04-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1440,9,'simple','WS04-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1441,9,'simple','WS04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1442,9,'simple','WS04-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1443,9,'simple','WS04-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1444,9,'simple','WS04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1445,9,'simple','WS04-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1446,9,'simple','WS04-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1447,9,'simple','WS04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1448,9,'simple','WS04-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1449,9,'simple','WS04-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1450,9,'configurable','WS04',1,0,'[[regtime]]','[[regtime]]'),(1451,9,'simple','WS06-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1452,9,'simple','WS06-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1453,9,'simple','WS06-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1454,9,'simple','WS06-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1455,9,'simple','WS06-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1456,9,'simple','WS06-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1457,9,'simple','WS06-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1458,9,'simple','WS06-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1459,9,'simple','WS06-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1460,9,'simple','WS06-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1461,9,'simple','WS06-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1462,9,'simple','WS06-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1463,9,'simple','WS06-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1464,9,'simple','WS06-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1465,9,'simple','WS06-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1466,9,'configurable','WS06',1,0,'[[regtime]]','[[regtime]]'),(1467,9,'simple','WS07-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1468,9,'simple','WS07-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1469,9,'simple','WS07-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1470,9,'simple','WS07-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1471,9,'simple','WS07-S-White',0,0,'[[regtime]]','[[regtime]]'),(1472,9,'simple','WS07-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1473,9,'simple','WS07-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1474,9,'simple','WS07-M-White',0,0,'[[regtime]]','[[regtime]]'),(1475,9,'simple','WS07-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1476,9,'simple','WS07-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1477,9,'simple','WS07-L-White',0,0,'[[regtime]]','[[regtime]]'),(1478,9,'simple','WS07-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1479,9,'simple','WS07-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1480,9,'simple','WS07-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1481,9,'simple','WS07-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1482,9,'configurable','WS07',1,0,'[[regtime]]','[[regtime]]'),(1483,9,'simple','WS08-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1484,9,'simple','WS08-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1485,9,'simple','WS08-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1486,9,'simple','WS08-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1487,9,'simple','WS08-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1488,9,'simple','WS08-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1489,9,'simple','WS08-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1490,9,'simple','WS08-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1491,9,'simple','WS08-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1492,9,'simple','WS08-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1493,9,'simple','WS08-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1494,9,'simple','WS08-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1495,9,'simple','WS08-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1496,9,'simple','WS08-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1497,9,'simple','WS08-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1498,9,'configurable','WS08',1,0,'[[regtime]]','[[regtime]]'),(1499,9,'simple','WS09-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1500,9,'simple','WS09-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1501,9,'simple','WS09-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1502,9,'simple','WS09-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1503,9,'simple','WS09-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1504,9,'simple','WS09-S-White',0,0,'[[regtime]]','[[regtime]]'),(1505,9,'simple','WS09-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1506,9,'simple','WS09-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1507,9,'simple','WS09-M-White',0,0,'[[regtime]]','[[regtime]]'),(1508,9,'simple','WS09-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1509,9,'simple','WS09-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1510,9,'simple','WS09-L-White',0,0,'[[regtime]]','[[regtime]]'),(1511,9,'simple','WS09-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1512,9,'simple','WS09-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1513,9,'simple','WS09-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1514,9,'configurable','WS09',1,0,'[[regtime]]','[[regtime]]'),(1515,9,'simple','WS10-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1516,9,'simple','WS10-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1517,9,'simple','WS10-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1518,9,'simple','WS10-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1519,9,'simple','WS10-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1520,9,'simple','WS10-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1521,9,'simple','WS10-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1522,9,'simple','WS10-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1523,9,'simple','WS10-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1524,9,'simple','WS10-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1525,9,'simple','WS10-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1526,9,'simple','WS10-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1527,9,'simple','WS10-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1528,9,'simple','WS10-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1529,9,'simple','WS10-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1530,9,'configurable','WS10',1,0,'[[regtime]]','[[regtime]]'),(1531,9,'simple','WS11-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1532,9,'simple','WS11-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1533,9,'simple','WS11-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1534,9,'simple','WS11-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1535,9,'simple','WS11-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1536,9,'simple','WS11-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1537,9,'simple','WS11-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1538,9,'simple','WS11-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1539,9,'simple','WS11-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1540,9,'simple','WS11-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1541,9,'simple','WS11-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1542,9,'simple','WS11-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1543,9,'simple','WS11-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1544,9,'simple','WS11-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1545,9,'simple','WS11-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1546,9,'configurable','WS11',1,0,'[[regtime]]','[[regtime]]'),(1547,9,'simple','WS12-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1548,9,'simple','WS12-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1549,9,'simple','WS12-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1550,9,'simple','WS12-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1551,9,'simple','WS12-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1552,9,'simple','WS12-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1553,9,'simple','WS12-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1554,9,'simple','WS12-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1555,9,'simple','WS12-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1556,9,'simple','WS12-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1557,9,'simple','WS12-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1558,9,'simple','WS12-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1559,9,'simple','WS12-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1560,9,'simple','WS12-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1561,9,'simple','WS12-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1562,9,'configurable','WS12',1,0,'[[regtime]]','[[regtime]]'),(1563,9,'simple','WS01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1564,9,'simple','WS01-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1565,9,'simple','WS01-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1566,9,'simple','WS01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1567,9,'simple','WS01-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1568,9,'simple','WS01-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1569,9,'simple','WS01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1570,9,'simple','WS01-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1571,9,'simple','WS01-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1572,9,'simple','WS01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1573,9,'simple','WS01-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1574,9,'simple','WS01-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1575,9,'simple','WS01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1576,9,'simple','WS01-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1577,9,'simple','WS01-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1578,9,'configurable','WS01',1,0,'[[regtime]]','[[regtime]]'),(1579,9,'simple','WS05-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1580,9,'simple','WS05-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1581,9,'simple','WS05-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1582,9,'simple','WS05-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1583,9,'simple','WS05-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1584,9,'simple','WS05-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1585,9,'simple','WS05-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1586,9,'simple','WS05-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1587,9,'simple','WS05-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1588,9,'simple','WS05-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1589,9,'simple','WS05-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1590,9,'simple','WS05-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1591,9,'simple','WS05-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1592,9,'simple','WS05-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1593,9,'simple','WS05-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1594,9,'configurable','WS05',1,0,'[[regtime]]','[[regtime]]'),(1595,9,'simple','WB01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1596,9,'simple','WB01-XS-Gray',0,0,'[[regtime]]','[[regtime]]'),(1597,9,'simple','WB01-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1598,9,'simple','WB01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1599,9,'simple','WB01-S-Gray',0,0,'[[regtime]]','[[regtime]]'),(1600,9,'simple','WB01-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1601,9,'simple','WB01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1602,9,'simple','WB01-M-Gray',0,0,'[[regtime]]','[[regtime]]'),(1603,9,'simple','WB01-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1604,9,'simple','WB01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1605,9,'simple','WB01-L-Gray',0,0,'[[regtime]]','[[regtime]]'),(1606,9,'simple','WB01-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1607,9,'simple','WB01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1608,9,'simple','WB01-XL-Gray',0,0,'[[regtime]]','[[regtime]]'),(1609,9,'simple','WB01-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1610,9,'configurable','WB01',1,0,'[[regtime]]','[[regtime]]'),(1611,9,'simple','WB02-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1612,9,'simple','WB02-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1613,9,'simple','WB02-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1614,9,'simple','WB02-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1615,9,'simple','WB02-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1616,9,'simple','WB02-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1617,9,'simple','WB02-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1618,9,'simple','WB02-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1619,9,'simple','WB02-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1620,9,'simple','WB02-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1621,9,'simple','WB02-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1622,9,'simple','WB02-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1623,9,'simple','WB02-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1624,9,'simple','WB02-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1625,9,'simple','WB02-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1626,9,'configurable','WB02',1,0,'[[regtime]]','[[regtime]]'),(1627,9,'simple','WB03-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1628,9,'simple','WB03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1629,9,'simple','WB03-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1630,9,'simple','WB03-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1631,9,'simple','WB03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1632,9,'simple','WB03-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1633,9,'simple','WB03-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1634,9,'simple','WB03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1635,9,'simple','WB03-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1636,9,'simple','WB03-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1637,9,'simple','WB03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1638,9,'simple','WB03-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1639,9,'simple','WB03-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1640,9,'simple','WB03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1641,9,'simple','WB03-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1642,9,'configurable','WB03',1,0,'[[regtime]]','[[regtime]]'),(1643,9,'simple','WB04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1644,9,'simple','WB04-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1645,9,'simple','WB04-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1646,9,'simple','WB04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1647,9,'simple','WB04-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1648,9,'simple','WB04-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1649,9,'simple','WB04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1650,9,'simple','WB04-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1651,9,'simple','WB04-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1652,9,'simple','WB04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1653,9,'simple','WB04-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1654,9,'simple','WB04-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1655,9,'simple','WB04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1656,9,'simple','WB04-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1657,9,'simple','WB04-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1658,9,'configurable','WB04',1,0,'[[regtime]]','[[regtime]]'),(1659,9,'simple','WB05-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1660,9,'simple','WB05-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1661,9,'simple','WB05-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1662,9,'simple','WB05-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1663,9,'simple','WB05-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1664,9,'simple','WB05-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1665,9,'simple','WB05-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1666,9,'simple','WB05-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1667,9,'simple','WB05-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1668,9,'simple','WB05-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1669,9,'simple','WB05-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1670,9,'simple','WB05-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1671,9,'simple','WB05-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1672,9,'simple','WB05-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1673,9,'simple','WB05-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1674,9,'configurable','WB05',1,0,'[[regtime]]','[[regtime]]'),(1675,9,'simple','WT01-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1676,9,'simple','WT01-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1677,9,'simple','WT01-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1678,9,'simple','WT01-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1679,9,'simple','WT01-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1680,9,'simple','WT01-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1681,9,'simple','WT01-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1682,9,'simple','WT01-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1683,9,'simple','WT01-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1684,9,'simple','WT01-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1685,9,'simple','WT01-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1686,9,'simple','WT01-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1687,9,'simple','WT01-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1688,9,'simple','WT01-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1689,9,'simple','WT01-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1690,9,'configurable','WT01',1,0,'[[regtime]]','[[regtime]]'),(1691,9,'simple','WT02-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1692,9,'simple','WT02-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1693,9,'simple','WT02-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1694,9,'simple','WT02-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1695,9,'simple','WT02-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1696,9,'simple','WT02-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1697,9,'simple','WT02-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1698,9,'simple','WT02-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1699,9,'simple','WT02-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1700,9,'simple','WT02-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1701,9,'simple','WT02-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1702,9,'simple','WT02-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1703,9,'simple','WT02-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1704,9,'simple','WT02-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1705,9,'simple','WT02-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1706,9,'configurable','WT02',1,0,'[[regtime]]','[[regtime]]'),(1707,9,'simple','WT03-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1708,9,'simple','WT03-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1709,9,'simple','WT03-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1710,9,'simple','WT03-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1711,9,'simple','WT03-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1712,9,'simple','WT03-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1713,9,'simple','WT03-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1714,9,'simple','WT03-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1715,9,'simple','WT03-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1716,9,'simple','WT03-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1717,9,'simple','WT03-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1718,9,'simple','WT03-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1719,9,'simple','WT03-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1720,9,'simple','WT03-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1721,9,'simple','WT03-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1722,9,'configurable','WT03',1,0,'[[regtime]]','[[regtime]]'),(1723,9,'simple','WT04-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1724,9,'simple','WT04-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1725,9,'simple','WT04-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1726,9,'simple','WT04-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1727,9,'simple','WT04-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1728,9,'simple','WT04-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1729,9,'simple','WT04-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1730,9,'simple','WT04-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1731,9,'simple','WT04-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1732,9,'simple','WT04-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1733,9,'simple','WT04-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1734,9,'simple','WT04-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1735,9,'simple','WT04-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1736,9,'simple','WT04-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1737,9,'simple','WT04-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1738,9,'configurable','WT04',1,0,'[[regtime]]','[[regtime]]'),(1739,9,'simple','WT05-XS-Orange',0,0,'[[regtime]]','[[regtime]]'),(1740,9,'simple','WT05-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1741,9,'simple','WT05-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1742,9,'simple','WT05-S-Orange',0,0,'[[regtime]]','[[regtime]]'),(1743,9,'simple','WT05-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1744,9,'simple','WT05-S-White',0,0,'[[regtime]]','[[regtime]]'),(1745,9,'simple','WT05-M-Orange',0,0,'[[regtime]]','[[regtime]]'),(1746,9,'simple','WT05-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1747,9,'simple','WT05-M-White',0,0,'[[regtime]]','[[regtime]]'),(1748,9,'simple','WT05-L-Orange',0,0,'[[regtime]]','[[regtime]]'),(1749,9,'simple','WT05-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1750,9,'simple','WT05-L-White',0,0,'[[regtime]]','[[regtime]]'),(1751,9,'simple','WT05-XL-Orange',0,0,'[[regtime]]','[[regtime]]'),(1752,9,'simple','WT05-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1753,9,'simple','WT05-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1754,9,'configurable','WT05',1,0,'[[regtime]]','[[regtime]]'),(1755,9,'simple','WT06-XS-Blue',0,0,'[[regtime]]','[[regtime]]'),(1756,9,'simple','WT06-XS-Red',0,0,'[[regtime]]','[[regtime]]'),(1757,9,'simple','WT06-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1758,9,'simple','WT06-S-Blue',0,0,'[[regtime]]','[[regtime]]'),(1759,9,'simple','WT06-S-Red',0,0,'[[regtime]]','[[regtime]]'),(1760,9,'simple','WT06-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1761,9,'simple','WT06-M-Blue',0,0,'[[regtime]]','[[regtime]]'),(1762,9,'simple','WT06-M-Red',0,0,'[[regtime]]','[[regtime]]'),(1763,9,'simple','WT06-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1764,9,'simple','WT06-L-Blue',0,0,'[[regtime]]','[[regtime]]'),(1765,9,'simple','WT06-L-Red',0,0,'[[regtime]]','[[regtime]]'),(1766,9,'simple','WT06-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1767,9,'simple','WT06-XL-Blue',0,0,'[[regtime]]','[[regtime]]'),(1768,9,'simple','WT06-XL-Red',0,0,'[[regtime]]','[[regtime]]'),(1769,9,'simple','WT06-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1770,9,'configurable','WT06',1,0,'[[regtime]]','[[regtime]]'),(1771,9,'simple','WT07-XS-Green',0,0,'[[regtime]]','[[regtime]]'),(1772,9,'simple','WT07-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1773,9,'simple','WT07-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1774,9,'simple','WT07-S-Green',0,0,'[[regtime]]','[[regtime]]'),(1775,9,'simple','WT07-S-White',0,0,'[[regtime]]','[[regtime]]'),(1776,9,'simple','WT07-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1777,9,'simple','WT07-M-Green',0,0,'[[regtime]]','[[regtime]]'),(1778,9,'simple','WT07-M-White',0,0,'[[regtime]]','[[regtime]]'),(1779,9,'simple','WT07-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1780,9,'simple','WT07-L-Green',0,0,'[[regtime]]','[[regtime]]'),(1781,9,'simple','WT07-L-White',0,0,'[[regtime]]','[[regtime]]'),(1782,9,'simple','WT07-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1783,9,'simple','WT07-XL-Green',0,0,'[[regtime]]','[[regtime]]'),(1784,9,'simple','WT07-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1785,9,'simple','WT07-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1786,9,'configurable','WT07',1,0,'[[regtime]]','[[regtime]]'),(1787,9,'simple','WT08-XS-Black',0,0,'[[regtime]]','[[regtime]]'),(1788,9,'simple','WT08-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1789,9,'simple','WT08-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1790,9,'simple','WT08-S-Black',0,0,'[[regtime]]','[[regtime]]'),(1791,9,'simple','WT08-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1792,9,'simple','WT08-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1793,9,'simple','WT08-M-Black',0,0,'[[regtime]]','[[regtime]]'),(1794,9,'simple','WT08-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1795,9,'simple','WT08-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1796,9,'simple','WT08-L-Black',0,0,'[[regtime]]','[[regtime]]'),(1797,9,'simple','WT08-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1798,9,'simple','WT08-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1799,9,'simple','WT08-XL-Black',0,0,'[[regtime]]','[[regtime]]'),(1800,9,'simple','WT08-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1801,9,'simple','WT08-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1802,9,'configurable','WT08',1,0,'[[regtime]]','[[regtime]]'),(1803,9,'simple','WT09-XS-Purple',0,0,'[[regtime]]','[[regtime]]'),(1804,9,'simple','WT09-XS-White',0,0,'[[regtime]]','[[regtime]]'),(1805,9,'simple','WT09-XS-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1806,9,'simple','WT09-S-Purple',0,0,'[[regtime]]','[[regtime]]'),(1807,9,'simple','WT09-S-White',0,0,'[[regtime]]','[[regtime]]'),(1808,9,'simple','WT09-S-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1809,9,'simple','WT09-M-Purple',0,0,'[[regtime]]','[[regtime]]'),(1810,9,'simple','WT09-M-White',0,0,'[[regtime]]','[[regtime]]'),(1811,9,'simple','WT09-M-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1812,9,'simple','WT09-L-Purple',0,0,'[[regtime]]','[[regtime]]'),(1813,9,'simple','WT09-L-White',0,0,'[[regtime]]','[[regtime]]'),(1814,9,'simple','WT09-L-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1815,9,'simple','WT09-XL-Purple',0,0,'[[regtime]]','[[regtime]]'),(1816,9,'simple','WT09-XL-White',0,0,'[[regtime]]','[[regtime]]'),(1817,9,'simple','WT09-XL-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1818,9,'configurable','WT09',1,0,'[[regtime]]','[[regtime]]'),(1819,10,'simple','WP01-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1820,10,'simple','WP01-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1821,10,'simple','WP01-28-White',0,0,'[[regtime]]','[[regtime]]'),(1822,10,'simple','WP01-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1823,10,'simple','WP01-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1824,10,'simple','WP01-29-White',0,0,'[[regtime]]','[[regtime]]'),(1825,10,'configurable','WP01',1,0,'[[regtime]]','[[regtime]]'),(1826,10,'simple','WP02-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1827,10,'simple','WP02-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1828,10,'simple','WP02-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1829,10,'simple','WP02-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1830,10,'simple','WP02-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1831,10,'simple','WP02-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1832,10,'configurable','WP02',1,0,'[[regtime]]','[[regtime]]'),(1833,10,'simple','WP03-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1834,10,'simple','WP03-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1835,10,'simple','WP03-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1836,10,'simple','WP03-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1837,10,'simple','WP03-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1838,10,'simple','WP03-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1839,10,'configurable','WP03',1,0,'[[regtime]]','[[regtime]]'),(1840,10,'simple','WP04-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1841,10,'simple','WP04-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1842,10,'simple','WP04-28-White',0,0,'[[regtime]]','[[regtime]]'),(1843,10,'simple','WP04-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1844,10,'simple','WP04-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1845,10,'simple','WP04-29-White',0,0,'[[regtime]]','[[regtime]]'),(1846,10,'configurable','WP04',1,0,'[[regtime]]','[[regtime]]'),(1847,10,'simple','WP05-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1848,10,'simple','WP05-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1849,10,'simple','WP05-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1850,10,'simple','WP05-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1851,10,'simple','WP05-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1852,10,'simple','WP05-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1853,10,'configurable','WP05',1,0,'[[regtime]]','[[regtime]]'),(1854,10,'simple','WP06-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1855,10,'simple','WP06-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1856,10,'simple','WP06-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1857,10,'simple','WP06-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1858,10,'simple','WP06-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1859,10,'simple','WP06-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1860,10,'configurable','WP06',1,0,'[[regtime]]','[[regtime]]'),(1861,10,'simple','WP07-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1862,10,'simple','WP07-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1863,10,'simple','WP07-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1864,10,'simple','WP07-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1865,10,'simple','WP07-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1866,10,'simple','WP07-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1867,10,'configurable','WP07',1,0,'[[regtime]]','[[regtime]]'),(1868,10,'simple','WP08-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1869,10,'simple','WP08-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1870,10,'simple','WP08-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1871,10,'simple','WP08-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1872,10,'simple','WP08-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1873,10,'simple','WP08-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1874,10,'configurable','WP08',1,0,'[[regtime]]','[[regtime]]'),(1875,10,'simple','WP09-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1876,10,'simple','WP09-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1877,10,'simple','WP09-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1878,10,'simple','WP09-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1879,10,'simple','WP09-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1880,10,'simple','WP09-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1881,10,'configurable','WP09',1,0,'[[regtime]]','[[regtime]]'),(1882,10,'simple','WP10-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1883,10,'simple','WP10-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1884,10,'simple','WP10-28-White',0,0,'[[regtime]]','[[regtime]]'),(1885,10,'simple','WP10-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1886,10,'simple','WP10-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1887,10,'simple','WP10-29-White',0,0,'[[regtime]]','[[regtime]]'),(1888,10,'configurable','WP10',1,0,'[[regtime]]','[[regtime]]'),(1889,10,'simple','WP11-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1890,10,'simple','WP11-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1891,10,'simple','WP11-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1892,10,'simple','WP11-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1893,10,'simple','WP11-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1894,10,'simple','WP11-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1895,10,'configurable','WP11',1,0,'[[regtime]]','[[regtime]]'),(1896,10,'simple','WP12-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1897,10,'simple','WP12-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1898,10,'simple','WP12-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1899,10,'simple','WP12-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1900,10,'simple','WP12-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1901,10,'simple','WP12-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1902,10,'configurable','WP12',1,0,'[[regtime]]','[[regtime]]'),(1903,10,'simple','WP13-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1904,10,'simple','WP13-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1905,10,'simple','WP13-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1906,10,'simple','WP13-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1907,10,'simple','WP13-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1908,10,'simple','WP13-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1909,10,'configurable','WP13',1,0,'[[regtime]]','[[regtime]]'),(1910,10,'simple','WSH01-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1911,10,'simple','WSH01-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1912,10,'simple','WSH01-28-Red',0,0,'[[regtime]]','[[regtime]]'),(1913,10,'simple','WSH01-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1914,10,'simple','WSH01-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1915,10,'simple','WSH01-29-Red',0,0,'[[regtime]]','[[regtime]]'),(1916,10,'simple','WSH01-30-Black',0,0,'[[regtime]]','[[regtime]]'),(1917,10,'simple','WSH01-30-Green',0,0,'[[regtime]]','[[regtime]]'),(1918,10,'simple','WSH01-30-Red',0,0,'[[regtime]]','[[regtime]]'),(1919,10,'simple','WSH01-31-Black',0,0,'[[regtime]]','[[regtime]]'),(1920,10,'simple','WSH01-31-Green',0,0,'[[regtime]]','[[regtime]]'),(1921,10,'simple','WSH01-31-Red',0,0,'[[regtime]]','[[regtime]]'),(1922,10,'simple','WSH01-32-Black',0,0,'[[regtime]]','[[regtime]]'),(1923,10,'simple','WSH01-32-Green',0,0,'[[regtime]]','[[regtime]]'),(1924,10,'simple','WSH01-32-Red',0,0,'[[regtime]]','[[regtime]]'),(1925,10,'configurable','WSH01',1,0,'[[regtime]]','[[regtime]]'),(1926,10,'simple','WSH02-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1927,10,'simple','WSH02-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1928,10,'simple','WSH02-28-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1929,10,'simple','WSH02-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1930,10,'simple','WSH02-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1931,10,'simple','WSH02-29-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1932,10,'simple','WSH02-30-Gray',0,0,'[[regtime]]','[[regtime]]'),(1933,10,'simple','WSH02-30-Orange',0,0,'[[regtime]]','[[regtime]]'),(1934,10,'simple','WSH02-30-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1935,10,'simple','WSH02-31-Gray',0,0,'[[regtime]]','[[regtime]]'),(1936,10,'simple','WSH02-31-Orange',0,0,'[[regtime]]','[[regtime]]'),(1937,10,'simple','WSH02-31-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1938,10,'simple','WSH02-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(1939,10,'simple','WSH02-32-Orange',0,0,'[[regtime]]','[[regtime]]'),(1940,10,'simple','WSH02-32-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1941,10,'configurable','WSH02',1,0,'[[regtime]]','[[regtime]]'),(1942,10,'simple','WSH03-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1943,10,'simple','WSH03-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1944,10,'simple','WSH03-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1945,10,'simple','WSH03-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1946,10,'simple','WSH03-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1947,10,'simple','WSH03-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1948,10,'simple','WSH03-30-Blue',0,0,'[[regtime]]','[[regtime]]'),(1949,10,'simple','WSH03-30-Gray',0,0,'[[regtime]]','[[regtime]]'),(1950,10,'simple','WSH03-30-Orange',0,0,'[[regtime]]','[[regtime]]'),(1951,10,'simple','WSH03-31-Blue',0,0,'[[regtime]]','[[regtime]]'),(1952,10,'simple','WSH03-31-Gray',0,0,'[[regtime]]','[[regtime]]'),(1953,10,'simple','WSH03-31-Orange',0,0,'[[regtime]]','[[regtime]]'),(1954,10,'simple','WSH03-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(1955,10,'simple','WSH03-32-Gray',0,0,'[[regtime]]','[[regtime]]'),(1956,10,'simple','WSH03-32-Orange',0,0,'[[regtime]]','[[regtime]]'),(1957,10,'configurable','WSH03',1,0,'[[regtime]]','[[regtime]]'),(1958,10,'simple','WSH04-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1959,10,'simple','WSH04-28-Green',0,0,'[[regtime]]','[[regtime]]'),(1960,10,'simple','WSH04-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1961,10,'simple','WSH04-29-Black',0,0,'[[regtime]]','[[regtime]]'),(1962,10,'simple','WSH04-29-Green',0,0,'[[regtime]]','[[regtime]]'),(1963,10,'simple','WSH04-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1964,10,'simple','WSH04-30-Black',0,0,'[[regtime]]','[[regtime]]'),(1965,10,'simple','WSH04-30-Green',0,0,'[[regtime]]','[[regtime]]'),(1966,10,'simple','WSH04-30-Orange',0,0,'[[regtime]]','[[regtime]]'),(1967,10,'simple','WSH04-31-Black',0,0,'[[regtime]]','[[regtime]]'),(1968,10,'simple','WSH04-31-Green',0,0,'[[regtime]]','[[regtime]]'),(1969,10,'simple','WSH04-31-Orange',0,0,'[[regtime]]','[[regtime]]'),(1970,10,'simple','WSH04-32-Black',0,0,'[[regtime]]','[[regtime]]'),(1971,10,'simple','WSH04-32-Green',0,0,'[[regtime]]','[[regtime]]'),(1972,10,'simple','WSH04-32-Orange',0,0,'[[regtime]]','[[regtime]]'),(1973,10,'configurable','WSH04',1,0,'[[regtime]]','[[regtime]]'),(1974,10,'simple','WSH05-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1975,10,'simple','WSH05-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1976,10,'simple','WSH05-28-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1977,10,'simple','WSH05-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(1978,10,'simple','WSH05-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1979,10,'simple','WSH05-29-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1980,10,'simple','WSH05-30-Blue',0,0,'[[regtime]]','[[regtime]]'),(1981,10,'simple','WSH05-30-Purple',0,0,'[[regtime]]','[[regtime]]'),(1982,10,'simple','WSH05-30-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1983,10,'simple','WSH05-31-Blue',0,0,'[[regtime]]','[[regtime]]'),(1984,10,'simple','WSH05-31-Purple',0,0,'[[regtime]]','[[regtime]]'),(1985,10,'simple','WSH05-31-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1986,10,'simple','WSH05-32-Blue',0,0,'[[regtime]]','[[regtime]]'),(1987,10,'simple','WSH05-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(1988,10,'simple','WSH05-32-Yellow',0,0,'[[regtime]]','[[regtime]]'),(1989,10,'configurable','WSH05',1,0,'[[regtime]]','[[regtime]]'),(1990,10,'simple','WSH06-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(1991,10,'simple','WSH06-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(1992,10,'simple','WSH06-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(1993,10,'simple','WSH06-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(1994,10,'simple','WSH06-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(1995,10,'simple','WSH06-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(1996,10,'configurable','WSH06',1,0,'[[regtime]]','[[regtime]]'),(1997,10,'simple','WSH07-28-Black',0,0,'[[regtime]]','[[regtime]]'),(1998,10,'simple','WSH07-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(1999,10,'simple','WSH07-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(2000,10,'simple','WSH07-29-Black',0,0,'[[regtime]]','[[regtime]]'),(2001,10,'simple','WSH07-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(2002,10,'simple','WSH07-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(2003,10,'configurable','WSH07',1,0,'[[regtime]]','[[regtime]]'),(2004,10,'simple','WSH08-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(2005,10,'simple','WSH08-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(2006,10,'simple','WSH08-30-Purple',0,0,'[[regtime]]','[[regtime]]'),(2007,10,'simple','WSH08-31-Purple',0,0,'[[regtime]]','[[regtime]]'),(2008,10,'simple','WSH08-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(2009,10,'configurable','WSH08',1,0,'[[regtime]]','[[regtime]]'),(2010,10,'simple','WSH09-28-Gray',0,0,'[[regtime]]','[[regtime]]'),(2011,10,'simple','WSH09-28-Green',0,0,'[[regtime]]','[[regtime]]'),(2012,10,'simple','WSH09-28-White',0,0,'[[regtime]]','[[regtime]]'),(2013,10,'simple','WSH09-29-Gray',0,0,'[[regtime]]','[[regtime]]'),(2014,10,'simple','WSH09-29-Green',0,0,'[[regtime]]','[[regtime]]'),(2015,10,'simple','WSH09-29-White',0,0,'[[regtime]]','[[regtime]]'),(2016,10,'configurable','WSH09',1,0,'[[regtime]]','[[regtime]]'),(2017,10,'simple','WSH10-28-Black',0,0,'[[regtime]]','[[regtime]]'),(2018,10,'simple','WSH10-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(2019,10,'simple','WSH10-28-White',0,0,'[[regtime]]','[[regtime]]'),(2020,10,'simple','WSH10-29-Black',0,0,'[[regtime]]','[[regtime]]'),(2021,10,'simple','WSH10-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(2022,10,'simple','WSH10-29-White',0,0,'[[regtime]]','[[regtime]]'),(2023,10,'configurable','WSH10',1,0,'[[regtime]]','[[regtime]]'),(2024,10,'simple','WSH11-28-Blue',0,0,'[[regtime]]','[[regtime]]'),(2025,10,'simple','WSH11-28-Orange',0,0,'[[regtime]]','[[regtime]]'),(2026,10,'simple','WSH11-28-Red',0,0,'[[regtime]]','[[regtime]]'),(2027,10,'simple','WSH11-29-Blue',0,0,'[[regtime]]','[[regtime]]'),(2028,10,'simple','WSH11-29-Orange',0,0,'[[regtime]]','[[regtime]]'),(2029,10,'simple','WSH11-29-Red',0,0,'[[regtime]]','[[regtime]]'),(2030,10,'configurable','WSH11',1,0,'[[regtime]]','[[regtime]]'),(2031,10,'simple','WSH12-28-Green',0,0,'[[regtime]]','[[regtime]]'),(2032,10,'simple','WSH12-28-Purple',0,0,'[[regtime]]','[[regtime]]'),(2033,10,'simple','WSH12-28-Red',0,0,'[[regtime]]','[[regtime]]'),(2034,10,'simple','WSH12-29-Green',0,0,'[[regtime]]','[[regtime]]'),(2035,10,'simple','WSH12-29-Purple',0,0,'[[regtime]]','[[regtime]]'),(2036,10,'simple','WSH12-29-Red',0,0,'[[regtime]]','[[regtime]]'),(2037,10,'simple','WSH12-30-Green',0,0,'[[regtime]]','[[regtime]]'),(2038,10,'simple','WSH12-30-Purple',0,0,'[[regtime]]','[[regtime]]'),(2039,10,'simple','WSH12-30-Red',0,0,'[[regtime]]','[[regtime]]'),(2040,10,'simple','WSH12-31-Green',0,0,'[[regtime]]','[[regtime]]'),(2041,10,'simple','WSH12-31-Purple',0,0,'[[regtime]]','[[regtime]]'),(2042,10,'simple','WSH12-31-Red',0,0,'[[regtime]]','[[regtime]]'),(2043,10,'simple','WSH12-32-Green',0,0,'[[regtime]]','[[regtime]]'),(2044,10,'simple','WSH12-32-Purple',0,0,'[[regtime]]','[[regtime]]'),(2045,10,'simple','WSH12-32-Red',0,0,'[[regtime]]','[[regtime]]'),(2046,10,'configurable','WSH12',1,0,'[[regtime]]','[[regtime]]');
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_datetime`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_datetime`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_datetime` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_PRD_ENTT_DTIME_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DTIME_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DTIME_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DTIME_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Datetime Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_datetime`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_datetime` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_datetime` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_datetime` VALUES (1,79,0,2,'[[regtime]]'),(2,79,0,10,'[[regtime]]'),(3,79,0,11,'[[regtime]]'),(4,79,0,16,'[[regtime]]'),(5,79,0,41,'[[regtime]]'),(6,79,0,42,'[[regtime]]');
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_decimal`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_decimal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_decimal` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(20,6) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_PRD_ENTT_DEC_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DEC_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_DEC_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3910 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Decimal Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_decimal`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_decimal` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_decimal` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_decimal` VALUES (1,77,0,1,34.000000),(2,77,0,2,32.000000),(3,78,0,2,32.000000),(4,77,0,3,38.000000),(5,77,0,4,45.000000),(6,77,0,5,45.000000),(7,77,0,6,59.000000),(8,77,0,7,74.000000),(9,77,0,8,32.000000),(10,77,0,9,32.000000),(11,77,0,10,32.000000),(12,78,0,10,24.000000),(13,77,0,11,33.000000),(14,78,0,11,33.000000),(15,77,0,12,36.000000),(16,77,0,13,45.000000),(17,77,0,14,45.000000),(18,77,0,15,7.000000),(19,77,0,16,12.000000),(20,78,0,16,12.000000),(21,77,0,17,12.000000),(22,77,0,18,16.000000),(23,77,0,19,19.000000),(24,77,0,20,19.000000),(25,77,0,21,5.000000),(26,77,0,22,19.000000),(27,77,0,23,22.000000),(28,77,0,24,23.000000),(29,77,0,25,23.000000),(30,77,0,26,23.000000),(31,77,0,27,27.000000),(32,77,0,28,27.000000),(33,77,0,29,27.000000),(34,77,0,30,32.000000),(35,77,0,31,32.000000),(36,77,0,32,32.000000),(37,77,0,33,14.000000),(38,77,0,34,17.000000),(39,77,0,35,21.000000),(40,77,0,36,45.000000),(41,77,0,37,49.000000),(42,77,0,38,54.000000),(43,77,0,39,55.000000),(44,77,0,40,92.000000),(45,77,0,41,43.000000),(46,78,0,41,43.000000),(47,77,0,42,49.000000),(48,78,0,42,49.000000),(49,77,0,43,54.000000),(50,77,0,44,92.000000),(51,77,0,47,6.000000),(52,77,0,48,14.000000),(53,77,0,49,22.000000),(54,77,0,50,14.000000),(55,77,0,51,18.000000),(56,77,0,52,0.000000),(57,77,0,53,52.000000),(58,82,0,53,1.000000),(59,77,0,54,52.000000),(60,82,0,54,1.000000),(61,77,0,55,52.000000),(62,82,0,55,1.000000),(63,77,0,56,52.000000),(64,82,0,56,1.000000),(65,77,0,57,52.000000),(66,82,0,57,1.000000),(67,77,0,58,52.000000),(68,82,0,58,1.000000),(69,77,0,59,52.000000),(70,82,0,59,1.000000),(71,77,0,60,52.000000),(72,82,0,60,1.000000),(73,77,0,61,52.000000),(74,82,0,61,1.000000),(75,77,0,62,52.000000),(76,82,0,62,1.000000),(77,77,0,63,52.000000),(78,82,0,63,1.000000),(79,77,0,64,52.000000),(80,82,0,64,1.000000),(81,77,0,65,52.000000),(82,82,0,65,1.000000),(83,77,0,66,52.000000),(84,82,0,66,1.000000),(85,77,0,67,52.000000),(86,82,0,67,1.000000),(87,77,0,68,52.000000),(88,77,0,69,70.000000),(89,82,0,69,1.000000),(90,77,0,70,70.000000),(91,82,0,70,1.000000),(92,77,0,71,70.000000),(93,82,0,71,1.000000),(94,77,0,72,70.000000),(95,82,0,72,1.000000),(96,77,0,73,70.000000),(97,82,0,73,1.000000),(98,77,0,74,70.000000),(99,82,0,74,1.000000),(100,77,0,75,70.000000),(101,82,0,75,1.000000),(102,77,0,76,70.000000),(103,82,0,76,1.000000),(104,77,0,77,70.000000),(105,82,0,77,1.000000),(106,77,0,78,70.000000),(107,82,0,78,1.000000),(108,77,0,79,70.000000),(109,82,0,79,1.000000),(110,77,0,80,70.000000),(111,82,0,80,1.000000),(112,77,0,81,70.000000),(113,82,0,81,1.000000),(114,77,0,82,70.000000),(115,82,0,82,1.000000),(116,77,0,83,70.000000),(117,82,0,83,1.000000),(118,77,0,84,70.000000),(119,77,0,85,63.000000),(120,82,0,85,1.000000),(121,77,0,86,63.000000),(122,82,0,86,1.000000),(123,77,0,87,63.000000),(124,82,0,87,1.000000),(125,77,0,88,63.000000),(126,82,0,88,1.000000),(127,77,0,89,63.000000),(128,82,0,89,1.000000),(129,77,0,90,63.000000),(130,82,0,90,1.000000),(131,77,0,91,63.000000),(132,82,0,91,1.000000),(133,77,0,92,63.000000),(134,82,0,92,1.000000),(135,77,0,93,63.000000),(136,82,0,93,1.000000),(137,77,0,94,63.000000),(138,82,0,94,1.000000),(139,77,0,95,63.000000),(140,82,0,95,1.000000),(141,77,0,96,63.000000),(142,82,0,96,1.000000),(143,77,0,97,63.000000),(144,82,0,97,1.000000),(145,77,0,98,63.000000),(146,82,0,98,1.000000),(147,77,0,99,63.000000),(148,82,0,99,1.000000),(149,77,0,100,63.000000),(150,77,0,101,60.000000),(151,82,0,101,1.000000),(152,77,0,102,60.000000),(153,82,0,102,1.000000),(154,77,0,103,60.000000),(155,82,0,103,1.000000),(156,77,0,104,60.000000),(157,82,0,104,1.000000),(158,77,0,105,60.000000),(159,82,0,105,1.000000),(160,77,0,106,60.000000),(161,82,0,106,1.000000),(162,77,0,107,60.000000),(163,82,0,107,1.000000),(164,77,0,108,60.000000),(165,82,0,108,1.000000),(166,77,0,109,60.000000),(167,82,0,109,1.000000),(168,77,0,110,60.000000),(169,82,0,110,1.000000),(170,77,0,111,60.000000),(171,82,0,111,1.000000),(172,77,0,112,60.000000),(173,82,0,112,1.000000),(174,77,0,113,60.000000),(175,82,0,113,1.000000),(176,77,0,114,60.000000),(177,82,0,114,1.000000),(178,77,0,115,60.000000),(179,82,0,115,1.000000),(180,77,0,116,60.000000),(181,77,0,117,52.000000),(182,82,0,117,1.000000),(183,77,0,118,52.000000),(184,82,0,118,1.000000),(185,77,0,119,52.000000),(186,82,0,119,1.000000),(187,77,0,120,52.000000),(188,82,0,120,1.000000),(189,77,0,121,52.000000),(190,82,0,121,1.000000),(191,77,0,122,52.000000),(192,82,0,122,1.000000),(193,77,0,123,52.000000),(194,82,0,123,1.000000),(195,77,0,124,52.000000),(196,82,0,124,1.000000),(197,77,0,125,52.000000),(198,82,0,125,1.000000),(199,77,0,126,52.000000),(200,82,0,126,1.000000),(201,77,0,127,52.000000),(202,82,0,127,1.000000),(203,77,0,128,52.000000),(204,82,0,128,1.000000),(205,77,0,129,52.000000),(206,82,0,129,1.000000),(207,77,0,130,52.000000),(208,82,0,130,1.000000),(209,77,0,131,52.000000),(210,82,0,131,1.000000),(211,77,0,132,52.000000),(212,77,0,133,42.000000),(213,82,0,133,1.000000),(214,77,0,134,42.000000),(215,82,0,134,1.000000),(216,77,0,135,42.000000),(217,82,0,135,1.000000),(218,77,0,136,42.000000),(219,82,0,136,1.000000),(220,77,0,137,42.000000),(221,82,0,137,1.000000),(222,77,0,138,42.000000),(223,82,0,138,1.000000),(224,77,0,139,42.000000),(225,82,0,139,1.000000),(226,77,0,140,42.000000),(227,82,0,140,1.000000),(228,77,0,141,42.000000),(229,82,0,141,1.000000),(230,77,0,142,42.000000),(231,82,0,142,1.000000),(232,77,0,143,42.000000),(233,82,0,143,1.000000),(234,77,0,144,42.000000),(235,82,0,144,1.000000),(236,77,0,145,42.000000),(237,82,0,145,1.000000),(238,77,0,146,42.000000),(239,82,0,146,1.000000),(240,77,0,147,42.000000),(241,82,0,147,1.000000),(242,77,0,148,42.000000),(243,77,0,149,54.000000),(244,82,0,149,1.000000),(245,77,0,150,54.000000),(246,82,0,150,1.000000),(247,77,0,151,54.000000),(248,82,0,151,1.000000),(249,77,0,152,54.000000),(250,82,0,152,1.000000),(251,77,0,153,54.000000),(252,82,0,153,1.000000),(253,77,0,154,54.000000),(254,82,0,154,1.000000),(255,77,0,155,54.000000),(256,82,0,155,1.000000),(257,77,0,156,54.000000),(258,82,0,156,1.000000),(259,77,0,157,54.000000),(260,82,0,157,1.000000),(261,77,0,158,54.000000),(262,82,0,158,1.000000),(263,77,0,159,54.000000),(264,82,0,159,1.000000),(265,77,0,160,54.000000),(266,82,0,160,1.000000),(267,77,0,161,54.000000),(268,82,0,161,1.000000),(269,77,0,162,54.000000),(270,82,0,162,1.000000),(271,77,0,163,54.000000),(272,82,0,163,1.000000),(273,77,0,164,54.000000),(274,77,0,165,42.000000),(275,82,0,165,1.000000),(276,77,0,166,42.000000),(277,82,0,166,1.000000),(278,77,0,167,42.000000),(279,82,0,167,1.000000),(280,77,0,168,42.000000),(281,82,0,168,1.000000),(282,77,0,169,42.000000),(283,82,0,169,1.000000),(284,77,0,170,42.000000),(285,82,0,170,1.000000),(286,77,0,171,42.000000),(287,82,0,171,1.000000),(288,77,0,172,42.000000),(289,82,0,172,1.000000),(290,77,0,173,42.000000),(291,82,0,173,1.000000),(292,77,0,174,42.000000),(293,82,0,174,1.000000),(294,77,0,175,42.000000),(295,82,0,175,1.000000),(296,77,0,176,42.000000),(297,82,0,176,1.000000),(298,77,0,177,42.000000),(299,82,0,177,1.000000),(300,77,0,178,42.000000),(301,82,0,178,1.000000),(302,77,0,179,42.000000),(303,82,0,179,1.000000),(304,77,0,180,42.000000),(305,77,0,181,69.000000),(306,82,0,181,1.000000),(307,77,0,182,69.000000),(308,82,0,182,1.000000),(309,77,0,183,69.000000),(310,82,0,183,1.000000),(311,77,0,184,69.000000),(312,82,0,184,1.000000),(313,77,0,185,69.000000),(314,82,0,185,1.000000),(315,77,0,186,69.000000),(316,82,0,186,1.000000),(317,77,0,187,69.000000),(318,82,0,187,1.000000),(319,77,0,188,69.000000),(320,82,0,188,1.000000),(321,77,0,189,69.000000),(322,82,0,189,1.000000),(323,77,0,190,69.000000),(324,82,0,190,1.000000),(325,77,0,191,69.000000),(326,82,0,191,1.000000),(327,77,0,192,69.000000),(328,82,0,192,1.000000),(329,77,0,193,69.000000),(330,82,0,193,1.000000),(331,77,0,194,69.000000),(332,82,0,194,1.000000),(333,77,0,195,69.000000),(334,82,0,195,1.000000),(335,77,0,196,69.000000),(336,77,0,197,62.000000),(337,82,0,197,1.000000),(338,77,0,198,62.000000),(339,82,0,198,1.000000),(340,77,0,199,62.000000),(341,82,0,199,1.000000),(342,77,0,200,62.000000),(343,82,0,200,1.000000),(344,77,0,201,62.000000),(345,82,0,201,1.000000),(346,77,0,202,62.000000),(347,82,0,202,1.000000),(348,77,0,203,62.000000),(349,82,0,203,1.000000),(350,77,0,204,62.000000),(351,82,0,204,1.000000),(352,77,0,205,62.000000),(353,82,0,205,1.000000),(354,77,0,206,62.000000),(355,82,0,206,1.000000),(356,77,0,207,62.000000),(357,82,0,207,1.000000),(358,77,0,208,62.000000),(359,82,0,208,1.000000),(360,77,0,209,62.000000),(361,82,0,209,1.000000),(362,77,0,210,62.000000),(363,82,0,210,1.000000),(364,77,0,211,62.000000),(365,82,0,211,1.000000),(366,77,0,212,62.000000),(367,77,0,213,64.000000),(368,82,0,213,1.000000),(369,77,0,214,64.000000),(370,82,0,214,1.000000),(371,77,0,215,64.000000),(372,82,0,215,1.000000),(373,77,0,216,64.000000),(374,82,0,216,1.000000),(375,77,0,217,64.000000),(376,82,0,217,1.000000),(377,77,0,218,64.000000),(378,82,0,218,1.000000),(379,77,0,219,64.000000),(380,82,0,219,1.000000),(381,77,0,220,64.000000),(382,82,0,220,1.000000),(383,77,0,221,64.000000),(384,82,0,221,1.000000),(385,77,0,222,64.000000),(386,82,0,222,1.000000),(387,77,0,223,64.000000),(388,82,0,223,1.000000),(389,77,0,224,64.000000),(390,82,0,224,1.000000),(391,77,0,225,64.000000),(392,82,0,225,1.000000),(393,77,0,226,64.000000),(394,82,0,226,1.000000),(395,77,0,227,64.000000),(396,82,0,227,1.000000),(397,77,0,228,64.000000),(398,77,0,229,69.000000),(399,82,0,229,1.000000),(400,77,0,230,69.000000),(401,82,0,230,1.000000),(402,77,0,231,69.000000),(403,82,0,231,1.000000),(404,77,0,232,69.000000),(405,82,0,232,1.000000),(406,77,0,233,69.000000),(407,82,0,233,1.000000),(408,77,0,234,69.000000),(409,82,0,234,1.000000),(410,77,0,235,69.000000),(411,82,0,235,1.000000),(412,77,0,236,69.000000),(413,82,0,236,1.000000),(414,77,0,237,69.000000),(415,82,0,237,1.000000),(416,77,0,238,69.000000),(417,82,0,238,1.000000),(418,77,0,239,69.000000),(419,82,0,239,1.000000),(420,77,0,240,69.000000),(421,82,0,240,1.000000),(422,77,0,241,69.000000),(423,82,0,241,1.000000),(424,77,0,242,69.000000),(425,82,0,242,1.000000),(426,77,0,243,69.000000),(427,82,0,243,1.000000),(428,77,0,244,69.000000),(429,77,0,245,74.000000),(430,82,0,245,1.000000),(431,77,0,246,74.000000),(432,82,0,246,1.000000),(433,77,0,247,74.000000),(434,82,0,247,1.000000),(435,77,0,248,74.000000),(436,82,0,248,1.000000),(437,77,0,249,74.000000),(438,82,0,249,1.000000),(439,77,0,250,74.000000),(440,82,0,250,1.000000),(441,77,0,251,74.000000),(442,82,0,251,1.000000),(443,77,0,252,74.000000),(444,82,0,252,1.000000),(445,77,0,253,74.000000),(446,82,0,253,1.000000),(447,77,0,254,74.000000),(448,82,0,254,1.000000),(449,77,0,255,74.000000),(450,82,0,255,1.000000),(451,77,0,256,74.000000),(452,82,0,256,1.000000),(453,77,0,257,74.000000),(454,82,0,257,1.000000),(455,77,0,258,74.000000),(456,82,0,258,1.000000),(457,77,0,259,74.000000),(458,82,0,259,1.000000),(459,77,0,260,74.000000),(460,77,0,261,42.000000),(461,82,0,261,1.000000),(462,77,0,262,42.000000),(463,82,0,262,1.000000),(464,77,0,263,42.000000),(465,82,0,263,1.000000),(466,77,0,264,42.000000),(467,82,0,264,1.000000),(468,77,0,265,42.000000),(469,82,0,265,1.000000),(470,77,0,266,42.000000),(471,82,0,266,1.000000),(472,77,0,267,42.000000),(473,82,0,267,1.000000),(474,77,0,268,42.000000),(475,82,0,268,1.000000),(476,77,0,269,42.000000),(477,82,0,269,1.000000),(478,77,0,270,42.000000),(479,82,0,270,1.000000),(480,77,0,271,42.000000),(481,82,0,271,1.000000),(482,77,0,272,42.000000),(483,82,0,272,1.000000),(484,77,0,273,42.000000),(485,82,0,273,1.000000),(486,77,0,274,42.000000),(487,82,0,274,1.000000),(488,77,0,275,42.000000),(489,82,0,275,1.000000),(490,77,0,276,42.000000),(491,77,0,277,51.000000),(492,82,0,277,1.000000),(493,77,0,278,51.000000),(494,82,0,278,1.000000),(495,77,0,279,51.000000),(496,82,0,279,1.000000),(497,77,0,280,51.000000),(498,82,0,280,1.000000),(499,77,0,281,51.000000),(500,82,0,281,1.000000),(501,77,0,282,51.000000),(502,82,0,282,1.000000),(503,77,0,283,51.000000),(504,82,0,283,1.000000),(505,77,0,284,51.000000),(506,82,0,284,1.000000),(507,77,0,285,51.000000),(508,82,0,285,1.000000),(509,77,0,286,51.000000),(510,82,0,286,1.000000),(511,77,0,287,51.000000),(512,82,0,287,1.000000),(513,77,0,288,51.000000),(514,82,0,288,1.000000),(515,77,0,289,51.000000),(516,82,0,289,1.000000),(517,77,0,290,51.000000),(518,82,0,290,1.000000),(519,77,0,291,51.000000),(520,82,0,291,1.000000),(521,77,0,292,51.000000),(522,77,0,293,47.000000),(523,82,0,293,1.000000),(524,77,0,294,47.000000),(525,82,0,294,1.000000),(526,77,0,295,47.000000),(527,82,0,295,1.000000),(528,77,0,296,47.000000),(529,82,0,296,1.000000),(530,77,0,297,47.000000),(531,82,0,297,1.000000),(532,77,0,298,47.000000),(533,82,0,298,1.000000),(534,77,0,299,47.000000),(535,82,0,299,1.000000),(536,77,0,300,47.000000),(537,82,0,300,1.000000),(538,77,0,301,47.000000),(539,82,0,301,1.000000),(540,77,0,302,47.000000),(541,82,0,302,1.000000),(542,77,0,303,47.000000),(543,82,0,303,1.000000),(544,77,0,304,47.000000),(545,82,0,304,1.000000),(546,77,0,305,47.000000),(547,82,0,305,1.000000),(548,77,0,306,47.000000),(549,82,0,306,1.000000),(550,77,0,307,47.000000),(551,82,0,307,1.000000),(552,77,0,308,47.000000),(553,77,0,309,72.000000),(554,82,0,309,1.000000),(555,77,0,310,72.000000),(556,82,0,310,1.000000),(557,77,0,311,72.000000),(558,82,0,311,1.000000),(559,77,0,312,72.000000),(560,82,0,312,1.000000),(561,77,0,313,72.000000),(562,82,0,313,1.000000),(563,77,0,314,72.000000),(564,82,0,314,1.000000),(565,77,0,315,72.000000),(566,82,0,315,1.000000),(567,77,0,316,72.000000),(568,82,0,316,1.000000),(569,77,0,317,72.000000),(570,82,0,317,1.000000),(571,77,0,318,72.000000),(572,82,0,318,1.000000),(573,77,0,319,72.000000),(574,82,0,319,1.000000),(575,77,0,320,72.000000),(576,82,0,320,1.000000),(577,77,0,321,72.000000),(578,82,0,321,1.000000),(579,77,0,322,72.000000),(580,82,0,322,1.000000),(581,77,0,323,72.000000),(582,82,0,323,1.000000),(583,77,0,324,72.000000),(584,77,0,325,99.000000),(585,82,0,325,1.000000),(586,77,0,326,99.000000),(587,82,0,326,1.000000),(588,77,0,327,99.000000),(589,82,0,327,1.000000),(590,77,0,328,99.000000),(591,82,0,328,1.000000),(592,77,0,329,99.000000),(593,82,0,329,1.000000),(594,77,0,330,99.000000),(595,82,0,330,1.000000),(596,77,0,331,99.000000),(597,82,0,331,1.000000),(598,77,0,332,99.000000),(599,82,0,332,1.000000),(600,77,0,333,99.000000),(601,82,0,333,1.000000),(602,77,0,334,99.000000),(603,82,0,334,1.000000),(604,77,0,335,99.000000),(605,82,0,335,1.000000),(606,77,0,336,99.000000),(607,82,0,336,1.000000),(608,77,0,337,99.000000),(609,82,0,337,1.000000),(610,77,0,338,99.000000),(611,82,0,338,1.000000),(612,77,0,339,99.000000),(613,82,0,339,1.000000),(614,77,0,340,99.000000),(615,77,0,341,65.000000),(616,82,0,341,1.000000),(617,77,0,342,65.000000),(618,82,0,342,1.000000),(619,77,0,343,65.000000),(620,82,0,343,1.000000),(621,77,0,344,65.000000),(622,82,0,344,1.000000),(623,77,0,345,65.000000),(624,82,0,345,1.000000),(625,77,0,346,65.000000),(626,82,0,346,1.000000),(627,77,0,347,65.000000),(628,82,0,347,1.000000),(629,77,0,348,65.000000),(630,82,0,348,1.000000),(631,77,0,349,65.000000),(632,82,0,349,1.000000),(633,77,0,350,65.000000),(634,82,0,350,1.000000),(635,77,0,351,65.000000),(636,82,0,351,1.000000),(637,77,0,352,65.000000),(638,82,0,352,1.000000),(639,77,0,353,65.000000),(640,82,0,353,1.000000),(641,77,0,354,65.000000),(642,82,0,354,1.000000),(643,77,0,355,65.000000),(644,82,0,355,1.000000),(645,77,0,356,65.000000),(646,77,0,357,66.000000),(647,82,0,357,1.000000),(648,77,0,358,66.000000),(649,82,0,358,1.000000),(650,77,0,359,66.000000),(651,82,0,359,1.000000),(652,77,0,360,66.000000),(653,82,0,360,1.000000),(654,77,0,361,66.000000),(655,82,0,361,1.000000),(656,77,0,362,66.000000),(657,82,0,362,1.000000),(658,77,0,363,66.000000),(659,82,0,363,1.000000),(660,77,0,364,66.000000),(661,82,0,364,1.000000),(662,77,0,365,66.000000),(663,82,0,365,1.000000),(664,77,0,366,66.000000),(665,82,0,366,1.000000),(666,77,0,367,66.000000),(667,82,0,367,1.000000),(668,77,0,368,66.000000),(669,82,0,368,1.000000),(670,77,0,369,66.000000),(671,82,0,369,1.000000),(672,77,0,370,66.000000),(673,82,0,370,1.000000),(674,77,0,371,66.000000),(675,82,0,371,1.000000),(676,77,0,372,66.000000),(677,77,0,373,60.000000),(678,82,0,373,1.000000),(679,77,0,374,60.000000),(680,82,0,374,1.000000),(681,77,0,375,60.000000),(682,82,0,375,1.000000),(683,77,0,376,60.000000),(684,82,0,376,1.000000),(685,77,0,377,60.000000),(686,82,0,377,1.000000),(687,77,0,378,60.000000),(688,82,0,378,1.000000),(689,77,0,379,60.000000),(690,82,0,379,1.000000),(691,77,0,380,60.000000),(692,82,0,380,1.000000),(693,77,0,381,60.000000),(694,82,0,381,1.000000),(695,77,0,382,60.000000),(696,82,0,382,1.000000),(697,77,0,383,60.000000),(698,82,0,383,1.000000),(699,77,0,384,60.000000),(700,82,0,384,1.000000),(701,77,0,385,60.000000),(702,82,0,385,1.000000),(703,77,0,386,60.000000),(704,82,0,386,1.000000),(705,77,0,387,60.000000),(706,82,0,387,1.000000),(707,77,0,388,60.000000),(708,77,0,389,56.990000),(709,82,0,389,1.000000),(710,77,0,390,56.990000),(711,82,0,390,1.000000),(712,77,0,391,56.990000),(713,82,0,391,1.000000),(714,77,0,392,56.990000),(715,82,0,392,1.000000),(716,77,0,393,56.990000),(717,82,0,393,1.000000),(718,77,0,394,56.990000),(719,82,0,394,1.000000),(720,77,0,395,56.990000),(721,82,0,395,1.000000),(722,77,0,396,56.990000),(723,82,0,396,1.000000),(724,77,0,397,56.990000),(725,82,0,397,1.000000),(726,77,0,398,56.990000),(727,82,0,398,1.000000),(728,77,0,399,56.990000),(729,82,0,399,1.000000),(730,77,0,400,56.990000),(731,82,0,400,1.000000),(732,77,0,401,56.990000),(733,82,0,401,1.000000),(734,77,0,402,56.990000),(735,82,0,402,1.000000),(736,77,0,403,56.990000),(737,82,0,403,1.000000),(738,77,0,404,56.990000),(739,77,0,405,49.000000),(740,82,0,405,1.000000),(741,77,0,406,49.000000),(742,82,0,406,1.000000),(743,77,0,407,49.000000),(744,82,0,407,1.000000),(745,77,0,408,49.000000),(746,82,0,408,1.000000),(747,77,0,409,49.000000),(748,82,0,409,1.000000),(749,77,0,410,49.000000),(750,82,0,410,1.000000),(751,77,0,411,49.000000),(752,82,0,411,1.000000),(753,77,0,412,49.000000),(754,82,0,412,1.000000),(755,77,0,413,49.000000),(756,82,0,413,1.000000),(757,77,0,414,49.000000),(758,82,0,414,1.000000),(759,77,0,415,49.000000),(760,82,0,415,1.000000),(761,77,0,416,49.000000),(762,82,0,416,1.000000),(763,77,0,417,49.000000),(764,82,0,417,1.000000),(765,77,0,418,49.000000),(766,82,0,418,1.000000),(767,77,0,419,49.000000),(768,82,0,419,1.000000),(769,77,0,420,49.000000),(770,77,0,421,45.000000),(771,82,0,421,1.000000),(772,77,0,422,45.000000),(773,82,0,422,1.000000),(774,77,0,423,45.000000),(775,82,0,423,1.000000),(776,77,0,424,45.000000),(777,82,0,424,1.000000),(778,77,0,425,45.000000),(779,82,0,425,1.000000),(780,77,0,426,45.000000),(781,82,0,426,1.000000),(782,77,0,427,45.000000),(783,82,0,427,1.000000),(784,77,0,428,45.000000),(785,82,0,428,1.000000),(786,77,0,429,45.000000),(787,82,0,429,1.000000),(788,77,0,430,45.000000),(789,82,0,430,1.000000),(790,77,0,431,45.000000),(791,82,0,431,1.000000),(792,77,0,432,45.000000),(793,82,0,432,1.000000),(794,77,0,433,45.000000),(795,82,0,433,1.000000),(796,77,0,434,45.000000),(797,82,0,434,1.000000),(798,77,0,435,45.000000),(799,82,0,435,1.000000),(800,77,0,436,45.000000),(801,77,0,437,29.000000),(802,82,0,437,1.000000),(803,77,0,438,29.000000),(804,82,0,438,1.000000),(805,77,0,439,29.000000),(806,82,0,439,1.000000),(807,77,0,440,29.000000),(808,82,0,440,1.000000),(809,77,0,441,29.000000),(810,82,0,441,1.000000),(811,77,0,442,29.000000),(812,82,0,442,1.000000),(813,77,0,443,29.000000),(814,82,0,443,1.000000),(815,77,0,444,29.000000),(816,82,0,444,1.000000),(817,77,0,445,29.000000),(818,82,0,445,1.000000),(819,77,0,446,29.000000),(820,82,0,446,1.000000),(821,77,0,447,29.000000),(822,82,0,447,1.000000),(823,77,0,448,29.000000),(824,82,0,448,1.000000),(825,77,0,449,29.000000),(826,82,0,449,1.000000),(827,77,0,450,29.000000),(828,82,0,450,1.000000),(829,77,0,451,29.000000),(830,82,0,451,1.000000),(831,77,0,452,29.000000),(832,77,0,453,24.000000),(833,82,0,453,1.000000),(834,77,0,454,24.000000),(835,82,0,454,1.000000),(836,77,0,455,24.000000),(837,82,0,455,1.000000),(838,77,0,456,24.000000),(839,82,0,456,1.000000),(840,77,0,457,24.000000),(841,82,0,457,1.000000),(842,77,0,458,24.000000),(843,82,0,458,1.000000),(844,77,0,459,24.000000),(845,82,0,459,1.000000),(846,77,0,460,24.000000),(847,82,0,460,1.000000),(848,77,0,461,24.000000),(849,82,0,461,1.000000),(850,77,0,462,24.000000),(851,82,0,462,1.000000),(852,77,0,463,24.000000),(853,82,0,463,1.000000),(854,77,0,464,24.000000),(855,82,0,464,1.000000),(856,77,0,465,24.000000),(857,82,0,465,1.000000),(858,77,0,466,24.000000),(859,82,0,466,1.000000),(860,77,0,467,24.000000),(861,82,0,467,1.000000),(862,77,0,468,24.000000),(863,77,0,469,32.000000),(864,82,0,469,1.000000),(865,77,0,470,32.000000),(866,82,0,470,1.000000),(867,77,0,471,32.000000),(868,82,0,471,1.000000),(869,77,0,472,32.000000),(870,82,0,472,1.000000),(871,77,0,473,32.000000),(872,82,0,473,1.000000),(873,77,0,474,32.000000),(874,82,0,474,1.000000),(875,77,0,475,32.000000),(876,82,0,475,1.000000),(877,77,0,476,32.000000),(878,82,0,476,1.000000),(879,77,0,477,32.000000),(880,82,0,477,1.000000),(881,77,0,478,32.000000),(882,82,0,478,1.000000),(883,77,0,479,32.000000),(884,82,0,479,1.000000),(885,77,0,480,32.000000),(886,82,0,480,1.000000),(887,77,0,481,32.000000),(888,82,0,481,1.000000),(889,77,0,482,32.000000),(890,82,0,482,1.000000),(891,77,0,483,32.000000),(892,82,0,483,1.000000),(893,77,0,484,32.000000),(894,77,0,485,28.000000),(895,82,0,485,1.000000),(896,77,0,486,28.000000),(897,82,0,486,1.000000),(898,77,0,487,28.000000),(899,82,0,487,1.000000),(900,77,0,488,28.000000),(901,82,0,488,1.000000),(902,77,0,489,28.000000),(903,82,0,489,1.000000),(904,77,0,490,28.000000),(905,82,0,490,1.000000),(906,77,0,491,28.000000),(907,82,0,491,1.000000),(908,77,0,492,28.000000),(909,82,0,492,1.000000),(910,77,0,493,28.000000),(911,82,0,493,1.000000),(912,77,0,494,28.000000),(913,82,0,494,1.000000),(914,77,0,495,28.000000),(915,82,0,495,1.000000),(916,77,0,496,28.000000),(917,82,0,496,1.000000),(918,77,0,497,28.000000),(919,82,0,497,1.000000),(920,77,0,498,28.000000),(921,82,0,498,1.000000),(922,77,0,499,28.000000),(923,82,0,499,1.000000),(924,77,0,500,28.000000),(925,77,0,501,29.000000),(926,82,0,501,1.000000),(927,77,0,502,29.000000),(928,82,0,502,1.000000),(929,77,0,503,29.000000),(930,82,0,503,1.000000),(931,77,0,504,29.000000),(932,82,0,504,1.000000),(933,77,0,505,29.000000),(934,82,0,505,1.000000),(935,77,0,506,29.000000),(936,82,0,506,1.000000),(937,77,0,507,29.000000),(938,82,0,507,1.000000),(939,77,0,508,29.000000),(940,82,0,508,1.000000),(941,77,0,509,29.000000),(942,82,0,509,1.000000),(943,77,0,510,29.000000),(944,82,0,510,1.000000),(945,77,0,511,29.000000),(946,82,0,511,1.000000),(947,77,0,512,29.000000),(948,82,0,512,1.000000),(949,77,0,513,29.000000),(950,82,0,513,1.000000),(951,77,0,514,29.000000),(952,82,0,514,1.000000),(953,77,0,515,29.000000),(954,82,0,515,1.000000),(955,77,0,516,29.000000),(956,77,0,517,29.000000),(957,82,0,517,1.000000),(958,77,0,518,29.000000),(959,82,0,518,1.000000),(960,77,0,519,29.000000),(961,82,0,519,1.000000),(962,77,0,520,29.000000),(963,82,0,520,1.000000),(964,77,0,521,29.000000),(965,82,0,521,1.000000),(966,77,0,522,29.000000),(967,82,0,522,1.000000),(968,77,0,523,29.000000),(969,82,0,523,1.000000),(970,77,0,524,29.000000),(971,82,0,524,1.000000),(972,77,0,525,29.000000),(973,82,0,525,1.000000),(974,77,0,526,29.000000),(975,82,0,526,1.000000),(976,77,0,527,29.000000),(977,82,0,527,1.000000),(978,77,0,528,29.000000),(979,82,0,528,1.000000),(980,77,0,529,29.000000),(981,82,0,529,1.000000),(982,77,0,530,29.000000),(983,82,0,530,1.000000),(984,77,0,531,29.000000),(985,82,0,531,1.000000),(986,77,0,532,29.000000),(987,77,0,533,29.000000),(988,82,0,533,1.000000),(989,77,0,534,29.000000),(990,82,0,534,1.000000),(991,77,0,535,29.000000),(992,82,0,535,1.000000),(993,77,0,536,29.000000),(994,82,0,536,1.000000),(995,77,0,537,29.000000),(996,82,0,537,1.000000),(997,77,0,538,29.000000),(998,82,0,538,1.000000),(999,77,0,539,29.000000),(1000,82,0,539,1.000000),(1001,77,0,540,29.000000),(1002,82,0,540,1.000000),(1003,77,0,541,29.000000),(1004,82,0,541,1.000000),(1005,77,0,542,29.000000),(1006,82,0,542,1.000000),(1007,77,0,543,29.000000),(1008,82,0,543,1.000000),(1009,77,0,544,29.000000),(1010,82,0,544,1.000000),(1011,77,0,545,29.000000),(1012,82,0,545,1.000000),(1013,77,0,546,29.000000),(1014,82,0,546,1.000000),(1015,77,0,547,29.000000),(1016,82,0,547,1.000000),(1017,77,0,548,29.000000),(1018,77,0,549,24.000000),(1019,82,0,549,1.000000),(1020,77,0,550,24.000000),(1021,82,0,550,1.000000),(1022,77,0,551,24.000000),(1023,82,0,551,1.000000),(1024,77,0,552,24.000000),(1025,82,0,552,1.000000),(1026,77,0,553,24.000000),(1027,82,0,553,1.000000),(1028,77,0,554,24.000000),(1029,82,0,554,1.000000),(1030,77,0,555,24.000000),(1031,82,0,555,1.000000),(1032,77,0,556,24.000000),(1033,82,0,556,1.000000),(1034,77,0,557,24.000000),(1035,82,0,557,1.000000),(1036,77,0,558,24.000000),(1037,82,0,558,1.000000),(1038,77,0,559,24.000000),(1039,82,0,559,1.000000),(1040,77,0,560,24.000000),(1041,82,0,560,1.000000),(1042,77,0,561,24.000000),(1043,82,0,561,1.000000),(1044,77,0,562,24.000000),(1045,82,0,562,1.000000),(1046,77,0,563,24.000000),(1047,82,0,563,1.000000),(1048,77,0,564,24.000000),(1049,77,0,565,28.000000),(1050,82,0,565,1.000000),(1051,77,0,566,28.000000),(1052,82,0,566,1.000000),(1053,77,0,567,28.000000),(1054,82,0,567,1.000000),(1055,77,0,568,28.000000),(1056,82,0,568,1.000000),(1057,77,0,569,28.000000),(1058,82,0,569,1.000000),(1059,77,0,570,28.000000),(1060,82,0,570,1.000000),(1061,77,0,571,28.000000),(1062,82,0,571,1.000000),(1063,77,0,572,28.000000),(1064,82,0,572,1.000000),(1065,77,0,573,28.000000),(1066,82,0,573,1.000000),(1067,77,0,574,28.000000),(1068,82,0,574,1.000000),(1069,77,0,575,28.000000),(1070,82,0,575,1.000000),(1071,77,0,576,28.000000),(1072,82,0,576,1.000000),(1073,77,0,577,28.000000),(1074,82,0,577,1.000000),(1075,77,0,578,28.000000),(1076,82,0,578,1.000000),(1077,77,0,579,28.000000),(1078,82,0,579,1.000000),(1079,77,0,580,28.000000),(1080,77,0,581,24.000000),(1081,82,0,581,1.000000),(1082,77,0,582,24.000000),(1083,82,0,582,1.000000),(1084,77,0,583,24.000000),(1085,82,0,583,1.000000),(1086,77,0,584,24.000000),(1087,82,0,584,1.000000),(1088,77,0,585,24.000000),(1089,82,0,585,1.000000),(1090,77,0,586,24.000000),(1091,82,0,586,1.000000),(1092,77,0,587,24.000000),(1093,82,0,587,1.000000),(1094,77,0,588,24.000000),(1095,82,0,588,1.000000),(1096,77,0,589,24.000000),(1097,82,0,589,1.000000),(1098,77,0,590,24.000000),(1099,82,0,590,1.000000),(1100,77,0,591,24.000000),(1101,82,0,591,1.000000),(1102,77,0,592,24.000000),(1103,82,0,592,1.000000),(1104,77,0,593,24.000000),(1105,82,0,593,1.000000),(1106,77,0,594,24.000000),(1107,82,0,594,1.000000),(1108,77,0,595,24.000000),(1109,82,0,595,1.000000),(1110,77,0,596,24.000000),(1111,77,0,597,39.000000),(1112,82,0,597,1.000000),(1113,77,0,598,39.000000),(1114,82,0,598,1.000000),(1115,77,0,599,39.000000),(1116,82,0,599,1.000000),(1117,77,0,600,39.000000),(1118,82,0,600,1.000000),(1119,77,0,601,39.000000),(1120,82,0,601,1.000000),(1121,77,0,602,39.000000),(1122,82,0,602,1.000000),(1123,77,0,603,39.000000),(1124,82,0,603,1.000000),(1125,77,0,604,39.000000),(1126,82,0,604,1.000000),(1127,77,0,605,39.000000),(1128,82,0,605,1.000000),(1129,77,0,606,39.000000),(1130,82,0,606,1.000000),(1131,77,0,607,39.000000),(1132,82,0,607,1.000000),(1133,77,0,608,39.000000),(1134,82,0,608,1.000000),(1135,77,0,609,39.000000),(1136,82,0,609,1.000000),(1137,77,0,610,39.000000),(1138,82,0,610,1.000000),(1139,77,0,611,39.000000),(1140,82,0,611,1.000000),(1141,77,0,612,39.000000),(1142,77,0,613,39.000000),(1143,82,0,613,1.000000),(1144,77,0,614,39.000000),(1145,82,0,614,1.000000),(1146,77,0,615,39.000000),(1147,82,0,615,1.000000),(1148,77,0,616,39.000000),(1149,82,0,616,1.000000),(1150,77,0,617,39.000000),(1151,82,0,617,1.000000),(1152,77,0,618,39.000000),(1153,82,0,618,1.000000),(1154,77,0,619,39.000000),(1155,82,0,619,1.000000),(1156,77,0,620,39.000000),(1157,82,0,620,1.000000),(1158,77,0,621,39.000000),(1159,82,0,621,1.000000),(1160,77,0,622,39.000000),(1161,82,0,622,1.000000),(1162,77,0,623,39.000000),(1163,82,0,623,1.000000),(1164,77,0,624,39.000000),(1165,82,0,624,1.000000),(1166,77,0,625,39.000000),(1167,82,0,625,1.000000),(1168,77,0,626,39.000000),(1169,82,0,626,1.000000),(1170,77,0,627,39.000000),(1171,82,0,627,1.000000),(1172,77,0,628,39.000000),(1173,77,0,629,29.000000),(1174,82,0,629,1.000000),(1175,77,0,630,29.000000),(1176,82,0,630,1.000000),(1177,77,0,631,29.000000),(1178,82,0,631,1.000000),(1179,77,0,632,29.000000),(1180,82,0,632,1.000000),(1181,77,0,633,29.000000),(1182,82,0,633,1.000000),(1183,77,0,634,29.000000),(1184,82,0,634,1.000000),(1185,77,0,635,29.000000),(1186,82,0,635,1.000000),(1187,77,0,636,29.000000),(1188,82,0,636,1.000000),(1189,77,0,637,29.000000),(1190,82,0,637,1.000000),(1191,77,0,638,29.000000),(1192,82,0,638,1.000000),(1193,77,0,639,29.000000),(1194,82,0,639,1.000000),(1195,77,0,640,29.000000),(1196,82,0,640,1.000000),(1197,77,0,641,29.000000),(1198,82,0,641,1.000000),(1199,77,0,642,29.000000),(1200,82,0,642,1.000000),(1201,77,0,643,29.000000),(1202,82,0,643,1.000000),(1203,77,0,644,29.000000),(1204,77,0,645,29.000000),(1205,82,0,645,1.000000),(1206,77,0,646,29.000000),(1207,82,0,646,1.000000),(1208,77,0,647,29.000000),(1209,82,0,647,1.000000),(1210,77,0,648,29.000000),(1211,82,0,648,1.000000),(1212,77,0,649,29.000000),(1213,82,0,649,1.000000),(1214,77,0,650,29.000000),(1215,82,0,650,1.000000),(1216,77,0,651,29.000000),(1217,82,0,651,1.000000),(1218,77,0,652,29.000000),(1219,82,0,652,1.000000),(1220,77,0,653,29.000000),(1221,82,0,653,1.000000),(1222,77,0,654,29.000000),(1223,82,0,654,1.000000),(1224,77,0,655,29.000000),(1225,82,0,655,1.000000),(1226,77,0,656,29.000000),(1227,82,0,656,1.000000),(1228,77,0,657,29.000000),(1229,82,0,657,1.000000),(1230,77,0,658,29.000000),(1231,82,0,658,1.000000),(1232,77,0,659,29.000000),(1233,82,0,659,1.000000),(1234,77,0,660,29.000000),(1235,77,0,661,29.000000),(1236,82,0,661,1.000000),(1237,77,0,662,29.000000),(1238,82,0,662,1.000000),(1239,77,0,663,29.000000),(1240,82,0,663,1.000000),(1241,77,0,664,29.000000),(1242,82,0,664,1.000000),(1243,77,0,665,29.000000),(1244,82,0,665,1.000000),(1245,77,0,666,29.000000),(1246,82,0,666,1.000000),(1247,77,0,667,29.000000),(1248,82,0,667,1.000000),(1249,77,0,668,29.000000),(1250,82,0,668,1.000000),(1251,77,0,669,29.000000),(1252,82,0,669,1.000000),(1253,77,0,670,29.000000),(1254,82,0,670,1.000000),(1255,77,0,671,29.000000),(1256,82,0,671,1.000000),(1257,77,0,672,29.000000),(1258,82,0,672,1.000000),(1259,77,0,673,29.000000),(1260,82,0,673,1.000000),(1261,77,0,674,29.000000),(1262,82,0,674,1.000000),(1263,77,0,675,29.000000),(1264,82,0,675,1.000000),(1265,77,0,676,29.000000),(1266,77,0,677,32.000000),(1267,82,0,677,1.000000),(1268,77,0,678,32.000000),(1269,82,0,678,1.000000),(1270,77,0,679,32.000000),(1271,82,0,679,1.000000),(1272,77,0,680,32.000000),(1273,82,0,680,1.000000),(1274,77,0,681,32.000000),(1275,82,0,681,1.000000),(1276,77,0,682,32.000000),(1277,77,0,683,24.000000),(1278,82,0,683,1.000000),(1279,77,0,684,24.000000),(1280,82,0,684,1.000000),(1281,77,0,685,24.000000),(1282,82,0,685,1.000000),(1283,77,0,686,24.000000),(1284,82,0,686,1.000000),(1285,77,0,687,24.000000),(1286,82,0,687,1.000000),(1287,77,0,688,24.000000),(1288,77,0,689,28.000000),(1289,82,0,689,1.000000),(1290,77,0,690,28.000000),(1291,82,0,690,1.000000),(1292,77,0,691,28.000000),(1293,82,0,691,1.000000),(1294,77,0,692,28.000000),(1295,82,0,692,1.000000),(1296,77,0,693,28.000000),(1297,82,0,693,1.000000),(1298,77,0,694,28.000000),(1299,77,0,695,22.000000),(1300,82,0,695,1.000000),(1301,77,0,696,22.000000),(1302,82,0,696,1.000000),(1303,77,0,697,22.000000),(1304,82,0,697,1.000000),(1305,77,0,698,22.000000),(1306,82,0,698,1.000000),(1307,77,0,699,22.000000),(1308,82,0,699,1.000000),(1309,77,0,700,22.000000),(1310,77,0,701,29.000000),(1311,82,0,701,1.000000),(1312,77,0,702,29.000000),(1313,82,0,702,1.000000),(1314,77,0,703,29.000000),(1315,82,0,703,1.000000),(1316,77,0,704,29.000000),(1317,82,0,704,1.000000),(1318,77,0,705,29.000000),(1319,82,0,705,1.000000),(1320,77,0,706,29.000000),(1321,77,0,707,29.000000),(1322,82,0,707,1.000000),(1323,77,0,708,29.000000),(1324,82,0,708,1.000000),(1325,77,0,709,29.000000),(1326,82,0,709,1.000000),(1327,77,0,710,29.000000),(1328,82,0,710,1.000000),(1329,77,0,711,29.000000),(1330,82,0,711,1.000000),(1331,77,0,712,29.000000),(1332,77,0,713,18.000000),(1333,82,0,713,1.000000),(1334,77,0,714,18.000000),(1335,82,0,714,1.000000),(1336,77,0,715,18.000000),(1337,82,0,715,1.000000),(1338,77,0,716,18.000000),(1339,82,0,716,1.000000),(1340,77,0,717,18.000000),(1341,82,0,717,1.000000),(1342,77,0,718,18.000000),(1343,77,0,719,18.000000),(1344,82,0,719,1.000000),(1345,77,0,720,18.000000),(1346,82,0,720,1.000000),(1347,77,0,721,18.000000),(1348,82,0,721,1.000000),(1349,77,0,722,18.000000),(1350,82,0,722,1.000000),(1351,77,0,723,18.000000),(1352,82,0,723,1.000000),(1353,77,0,724,18.000000),(1354,77,0,725,18.000000),(1355,82,0,725,1.000000),(1356,77,0,726,18.000000),(1357,82,0,726,1.000000),(1358,77,0,727,18.000000),(1359,82,0,727,1.000000),(1360,77,0,728,18.000000),(1361,82,0,728,1.000000),(1362,77,0,729,18.000000),(1363,82,0,729,1.000000),(1364,77,0,730,18.000000),(1365,77,0,731,35.000000),(1366,82,0,731,1.000000),(1367,77,0,732,35.000000),(1368,82,0,732,1.000000),(1369,77,0,733,35.000000),(1370,82,0,733,1.000000),(1371,77,0,734,35.000000),(1372,82,0,734,1.000000),(1373,77,0,735,35.000000),(1374,82,0,735,1.000000),(1375,77,0,736,35.000000),(1376,82,0,736,1.000000),(1377,77,0,737,35.000000),(1378,82,0,737,1.000000),(1379,77,0,738,35.000000),(1380,82,0,738,1.000000),(1381,77,0,739,35.000000),(1382,82,0,739,1.000000),(1383,77,0,740,35.000000),(1384,82,0,740,1.000000),(1385,77,0,741,35.000000),(1386,82,0,741,1.000000),(1387,77,0,742,35.000000),(1388,82,0,742,1.000000),(1389,77,0,743,35.000000),(1390,77,0,744,46.000000),(1391,82,0,744,1.000000),(1392,77,0,745,46.000000),(1393,82,0,745,1.000000),(1394,77,0,746,46.000000),(1395,82,0,746,1.000000),(1396,77,0,747,46.000000),(1397,82,0,747,1.000000),(1398,77,0,748,46.000000),(1399,82,0,748,1.000000),(1400,77,0,749,46.000000),(1401,82,0,749,1.000000),(1402,77,0,750,46.000000),(1403,82,0,750,1.000000),(1404,77,0,751,46.000000),(1405,82,0,751,1.000000),(1406,77,0,752,46.000000),(1407,82,0,752,1.000000),(1408,77,0,753,46.000000),(1409,82,0,753,1.000000),(1410,77,0,754,46.000000),(1411,82,0,754,1.000000),(1412,77,0,755,46.000000),(1413,82,0,755,1.000000),(1414,77,0,756,46.000000),(1415,77,0,757,51.000000),(1416,82,0,757,1.000000),(1417,77,0,758,51.000000),(1418,82,0,758,1.000000),(1419,77,0,759,51.000000),(1420,82,0,759,1.000000),(1421,77,0,760,51.000000),(1422,82,0,760,1.000000),(1423,77,0,761,51.000000),(1424,82,0,761,1.000000),(1425,77,0,762,51.000000),(1426,82,0,762,1.000000),(1427,77,0,763,51.000000),(1428,82,0,763,1.000000),(1429,77,0,764,51.000000),(1430,82,0,764,1.000000),(1431,77,0,765,51.000000),(1432,82,0,765,1.000000),(1433,77,0,766,51.000000),(1434,82,0,766,1.000000),(1435,77,0,767,51.000000),(1436,82,0,767,1.000000),(1437,77,0,768,51.000000),(1438,82,0,768,1.000000),(1439,77,0,769,51.000000),(1440,77,0,770,45.000000),(1441,82,0,770,1.000000),(1442,77,0,771,45.000000),(1443,82,0,771,1.000000),(1444,77,0,772,45.000000),(1445,82,0,772,1.000000),(1446,77,0,773,45.000000),(1447,82,0,773,1.000000),(1448,77,0,774,45.000000),(1449,82,0,774,1.000000),(1450,77,0,775,45.000000),(1451,82,0,775,1.000000),(1452,77,0,776,45.000000),(1453,82,0,776,1.000000),(1454,77,0,777,45.000000),(1455,82,0,777,1.000000),(1456,77,0,778,45.000000),(1457,82,0,778,1.000000),(1458,77,0,779,45.000000),(1459,82,0,779,1.000000),(1460,77,0,780,45.000000),(1461,82,0,780,1.000000),(1462,77,0,781,45.000000),(1463,82,0,781,1.000000),(1464,77,0,782,45.000000),(1465,77,0,783,57.000000),(1466,82,0,783,1.000000),(1467,77,0,784,57.000000),(1468,82,0,784,1.000000),(1469,77,0,785,57.000000),(1470,82,0,785,1.000000),(1471,77,0,786,57.000000),(1472,82,0,786,1.000000),(1473,77,0,787,57.000000),(1474,82,0,787,1.000000),(1475,77,0,788,57.000000),(1476,82,0,788,1.000000),(1477,77,0,789,57.000000),(1478,82,0,789,1.000000),(1479,77,0,790,57.000000),(1480,82,0,790,1.000000),(1481,77,0,791,57.000000),(1482,82,0,791,1.000000),(1483,77,0,792,57.000000),(1484,82,0,792,1.000000),(1485,77,0,793,57.000000),(1486,82,0,793,1.000000),(1487,77,0,794,57.000000),(1488,82,0,794,1.000000),(1489,77,0,795,57.000000),(1490,77,0,796,28.000000),(1491,82,0,796,1.000000),(1492,77,0,797,28.000000),(1493,82,0,797,1.000000),(1494,77,0,798,28.000000),(1495,82,0,798,1.000000),(1496,77,0,799,28.000000),(1497,82,0,799,1.000000),(1498,77,0,800,28.000000),(1499,82,0,800,1.000000),(1500,77,0,801,28.000000),(1501,82,0,801,1.000000),(1502,77,0,802,28.000000),(1503,82,0,802,1.000000),(1504,77,0,803,28.000000),(1505,82,0,803,1.000000),(1506,77,0,804,28.000000),(1507,82,0,804,1.000000),(1508,77,0,805,28.000000),(1509,82,0,805,1.000000),(1510,77,0,806,28.000000),(1511,82,0,806,1.000000),(1512,77,0,807,28.000000),(1513,82,0,807,1.000000),(1514,77,0,808,28.000000),(1515,77,0,809,68.000000),(1516,82,0,809,1.000000),(1517,77,0,810,68.000000),(1518,82,0,810,1.000000),(1519,77,0,811,68.000000),(1520,82,0,811,1.000000),(1521,77,0,812,68.000000),(1522,82,0,812,1.000000),(1523,77,0,813,68.000000),(1524,82,0,813,1.000000),(1525,77,0,814,68.000000),(1526,82,0,814,1.000000),(1527,77,0,815,68.000000),(1528,82,0,815,1.000000),(1529,77,0,816,68.000000),(1530,82,0,816,1.000000),(1531,77,0,817,68.000000),(1532,82,0,817,1.000000),(1533,77,0,818,68.000000),(1534,82,0,818,1.000000),(1535,77,0,819,68.000000),(1536,82,0,819,1.000000),(1537,77,0,820,68.000000),(1538,82,0,820,1.000000),(1539,77,0,821,68.000000),(1540,77,0,822,82.000000),(1541,82,0,822,1.000000),(1542,77,0,823,82.000000),(1543,82,0,823,1.000000),(1544,77,0,824,82.000000),(1545,82,0,824,1.000000),(1546,77,0,825,82.000000),(1547,82,0,825,1.000000),(1548,77,0,826,82.000000),(1549,82,0,826,1.000000),(1550,77,0,827,82.000000),(1551,82,0,827,1.000000),(1552,77,0,828,82.000000),(1553,82,0,828,1.000000),(1554,77,0,829,82.000000),(1555,82,0,829,1.000000),(1556,77,0,830,82.000000),(1557,82,0,830,1.000000),(1558,77,0,831,82.000000),(1559,82,0,831,1.000000),(1560,77,0,832,82.000000),(1561,82,0,832,1.000000),(1562,77,0,833,82.000000),(1563,82,0,833,1.000000),(1564,77,0,834,82.000000),(1565,77,0,835,75.000000),(1566,82,0,835,1.000000),(1567,77,0,836,75.000000),(1568,82,0,836,1.000000),(1569,77,0,837,75.000000),(1570,82,0,837,1.000000),(1571,77,0,838,75.000000),(1572,82,0,838,1.000000),(1573,77,0,839,75.000000),(1574,82,0,839,1.000000),(1575,77,0,840,75.000000),(1576,82,0,840,1.000000),(1577,77,0,841,75.000000),(1578,82,0,841,1.000000),(1579,77,0,842,75.000000),(1580,82,0,842,1.000000),(1581,77,0,843,75.000000),(1582,82,0,843,1.000000),(1583,77,0,844,75.000000),(1584,82,0,844,1.000000),(1585,77,0,845,75.000000),(1586,82,0,845,1.000000),(1587,77,0,846,75.000000),(1588,82,0,846,1.000000),(1589,77,0,847,75.000000),(1590,77,0,848,66.000000),(1591,82,0,848,1.000000),(1592,77,0,849,66.000000),(1593,82,0,849,1.000000),(1594,77,0,850,66.000000),(1595,82,0,850,1.000000),(1596,77,0,851,66.000000),(1597,82,0,851,1.000000),(1598,77,0,852,66.000000),(1599,82,0,852,1.000000),(1600,77,0,853,66.000000),(1601,82,0,853,1.000000),(1602,77,0,854,66.000000),(1603,82,0,854,1.000000),(1604,77,0,855,66.000000),(1605,82,0,855,1.000000),(1606,77,0,856,66.000000),(1607,82,0,856,1.000000),(1608,77,0,857,66.000000),(1609,82,0,857,1.000000),(1610,77,0,858,66.000000),(1611,82,0,858,1.000000),(1612,77,0,859,66.000000),(1613,82,0,859,1.000000),(1614,77,0,860,66.000000),(1615,77,0,861,74.000000),(1616,82,0,861,1.000000),(1617,77,0,862,74.000000),(1618,82,0,862,1.000000),(1619,77,0,863,74.000000),(1620,82,0,863,1.000000),(1621,77,0,864,74.000000),(1622,82,0,864,1.000000),(1623,77,0,865,74.000000),(1624,82,0,865,1.000000),(1625,77,0,866,74.000000),(1626,82,0,866,1.000000),(1627,77,0,867,74.000000),(1628,82,0,867,1.000000),(1629,77,0,868,74.000000),(1630,82,0,868,1.000000),(1631,77,0,869,74.000000),(1632,82,0,869,1.000000),(1633,77,0,870,74.000000),(1634,82,0,870,1.000000),(1635,77,0,871,74.000000),(1636,82,0,871,1.000000),(1637,77,0,872,74.000000),(1638,82,0,872,1.000000),(1639,77,0,873,74.000000),(1640,77,0,874,48.000000),(1641,82,0,874,1.000000),(1642,77,0,875,48.000000),(1643,82,0,875,1.000000),(1644,77,0,876,48.000000),(1645,82,0,876,1.000000),(1646,77,0,877,48.000000),(1647,82,0,877,1.000000),(1648,77,0,878,48.000000),(1649,82,0,878,1.000000),(1650,77,0,879,48.000000),(1651,82,0,879,1.000000),(1652,77,0,880,48.000000),(1653,82,0,880,1.000000),(1654,77,0,881,48.000000),(1655,82,0,881,1.000000),(1656,77,0,882,48.000000),(1657,82,0,882,1.000000),(1658,77,0,883,48.000000),(1659,82,0,883,1.000000),(1660,77,0,884,48.000000),(1661,82,0,884,1.000000),(1662,77,0,885,48.000000),(1663,82,0,885,1.000000),(1664,77,0,886,48.000000),(1665,77,0,887,44.000000),(1666,82,0,887,1.000000),(1667,77,0,888,44.000000),(1668,82,0,888,1.000000),(1669,77,0,889,44.000000),(1670,82,0,889,1.000000),(1671,77,0,890,44.000000),(1672,82,0,890,1.000000),(1673,77,0,891,44.000000),(1674,82,0,891,1.000000),(1675,77,0,892,44.000000),(1676,82,0,892,1.000000),(1677,77,0,893,44.000000),(1678,82,0,893,1.000000),(1679,77,0,894,44.000000),(1680,82,0,894,1.000000),(1681,77,0,895,44.000000),(1682,82,0,895,1.000000),(1683,77,0,896,44.000000),(1684,82,0,896,1.000000),(1685,77,0,897,44.000000),(1686,82,0,897,1.000000),(1687,77,0,898,44.000000),(1688,82,0,898,1.000000),(1689,77,0,899,44.000000),(1690,77,0,900,32.500000),(1691,82,0,900,1.000000),(1692,77,0,901,32.500000),(1693,82,0,901,1.000000),(1694,77,0,902,32.500000),(1695,82,0,902,1.000000),(1696,77,0,903,32.500000),(1697,82,0,903,1.000000),(1698,77,0,904,32.500000),(1699,77,0,905,32.500000),(1700,82,0,905,1.000000),(1701,77,0,906,32.500000),(1702,82,0,906,1.000000),(1703,77,0,907,32.500000),(1704,82,0,907,1.000000),(1705,77,0,908,32.500000),(1706,82,0,908,1.000000),(1707,77,0,909,32.500000),(1708,82,0,909,1.000000),(1709,77,0,910,32.500000),(1710,82,0,910,1.000000),(1711,77,0,911,32.500000),(1712,82,0,911,1.000000),(1713,77,0,912,32.500000),(1714,82,0,912,1.000000),(1715,77,0,913,32.500000),(1716,82,0,913,1.000000),(1717,77,0,914,32.500000),(1718,82,0,914,1.000000),(1719,77,0,915,32.500000),(1720,82,0,915,1.000000),(1721,77,0,916,32.500000),(1722,82,0,916,1.000000),(1723,77,0,917,32.500000),(1724,77,0,918,32.500000),(1725,82,0,918,1.000000),(1726,77,0,919,32.500000),(1727,82,0,919,1.000000),(1728,77,0,920,32.500000),(1729,82,0,920,1.000000),(1730,77,0,921,32.500000),(1731,82,0,921,1.000000),(1732,77,0,922,32.500000),(1733,82,0,922,1.000000),(1734,77,0,923,32.500000),(1735,82,0,923,1.000000),(1736,77,0,924,32.500000),(1737,82,0,924,1.000000),(1738,77,0,925,32.500000),(1739,82,0,925,1.000000),(1740,77,0,926,32.500000),(1741,82,0,926,1.000000),(1742,77,0,927,32.500000),(1743,82,0,927,1.000000),(1744,77,0,928,32.500000),(1745,82,0,928,1.000000),(1746,77,0,929,32.500000),(1747,82,0,929,1.000000),(1748,77,0,930,32.500000),(1749,77,0,931,29.000000),(1750,82,0,931,1.000000),(1751,77,0,932,29.000000),(1752,82,0,932,1.000000),(1753,77,0,933,29.000000),(1754,82,0,933,1.000000),(1755,77,0,934,29.000000),(1756,82,0,934,1.000000),(1757,77,0,935,29.000000),(1758,82,0,935,1.000000),(1759,77,0,936,29.000000),(1760,82,0,936,1.000000),(1761,77,0,937,29.000000),(1762,82,0,937,1.000000),(1763,77,0,938,29.000000),(1764,82,0,938,1.000000),(1765,77,0,939,29.000000),(1766,82,0,939,1.000000),(1767,77,0,940,29.000000),(1768,82,0,940,1.000000),(1769,77,0,941,29.000000),(1770,82,0,941,1.000000),(1771,77,0,942,29.000000),(1772,82,0,942,1.000000),(1773,77,0,943,29.000000),(1774,77,0,944,32.000000),(1775,82,0,944,1.000000),(1776,77,0,945,32.000000),(1777,82,0,945,1.000000),(1778,77,0,946,32.000000),(1779,82,0,946,1.000000),(1780,77,0,947,32.000000),(1781,82,0,947,1.000000),(1782,77,0,948,32.000000),(1783,82,0,948,1.000000),(1784,77,0,949,32.000000),(1785,82,0,949,1.000000),(1786,77,0,950,32.000000),(1787,82,0,950,1.000000),(1788,77,0,951,32.000000),(1789,82,0,951,1.000000),(1790,77,0,952,32.000000),(1791,82,0,952,1.000000),(1792,77,0,953,32.000000),(1793,82,0,953,1.000000),(1794,77,0,954,32.000000),(1795,82,0,954,1.000000),(1796,77,0,955,32.000000),(1797,82,0,955,1.000000),(1798,77,0,956,32.000000),(1799,77,0,957,35.000000),(1800,82,0,957,1.000000),(1801,77,0,958,35.000000),(1802,82,0,958,1.000000),(1803,77,0,959,35.000000),(1804,82,0,959,1.000000),(1805,77,0,960,35.000000),(1806,82,0,960,1.000000),(1807,77,0,961,35.000000),(1808,82,0,961,1.000000),(1809,77,0,962,35.000000),(1810,82,0,962,1.000000),(1811,77,0,963,35.000000),(1812,82,0,963,1.000000),(1813,77,0,964,35.000000),(1814,82,0,964,1.000000),(1815,77,0,965,35.000000),(1816,82,0,965,1.000000),(1817,77,0,966,35.000000),(1818,82,0,966,1.000000),(1819,77,0,967,35.000000),(1820,82,0,967,1.000000),(1821,77,0,968,35.000000),(1822,82,0,968,1.000000),(1823,77,0,969,35.000000),(1824,77,0,970,35.000000),(1825,82,0,970,1.000000),(1826,77,0,971,35.000000),(1827,82,0,971,1.000000),(1828,77,0,972,35.000000),(1829,82,0,972,1.000000),(1830,77,0,973,35.000000),(1831,82,0,973,1.000000),(1832,77,0,974,35.000000),(1833,82,0,974,1.000000),(1834,77,0,975,35.000000),(1835,82,0,975,1.000000),(1836,77,0,976,35.000000),(1837,82,0,976,1.000000),(1838,77,0,977,35.000000),(1839,82,0,977,1.000000),(1840,77,0,978,35.000000),(1841,82,0,978,1.000000),(1842,77,0,979,35.000000),(1843,82,0,979,1.000000),(1844,77,0,980,35.000000),(1845,82,0,980,1.000000),(1846,77,0,981,35.000000),(1847,82,0,981,1.000000),(1848,77,0,982,35.000000),(1849,77,0,983,24.000000),(1850,82,0,983,1.000000),(1851,77,0,984,24.000000),(1852,82,0,984,1.000000),(1853,77,0,985,24.000000),(1854,82,0,985,1.000000),(1855,77,0,986,24.000000),(1856,82,0,986,1.000000),(1857,77,0,987,24.000000),(1858,82,0,987,1.000000),(1859,77,0,988,24.000000),(1860,82,0,988,1.000000),(1861,77,0,989,24.000000),(1862,82,0,989,1.000000),(1863,77,0,990,24.000000),(1864,82,0,990,1.000000),(1865,77,0,991,24.000000),(1866,82,0,991,1.000000),(1867,77,0,992,24.000000),(1868,82,0,992,1.000000),(1869,77,0,993,24.000000),(1870,82,0,993,1.000000),(1871,77,0,994,24.000000),(1872,82,0,994,1.000000),(1873,77,0,995,24.000000),(1874,77,0,996,32.000000),(1875,82,0,996,1.000000),(1876,77,0,997,32.000000),(1877,82,0,997,1.000000),(1878,77,0,998,32.000000),(1879,82,0,998,1.000000),(1880,77,0,999,32.000000),(1881,82,0,999,1.000000),(1882,77,0,1000,32.000000),(1883,82,0,1000,1.000000),(1884,77,0,1001,32.000000),(1885,82,0,1001,1.000000),(1886,77,0,1002,32.000000),(1887,82,0,1002,1.000000),(1888,77,0,1003,32.000000),(1889,82,0,1003,1.000000),(1890,77,0,1004,32.000000),(1891,82,0,1004,1.000000),(1892,77,0,1005,32.000000),(1893,82,0,1005,1.000000),(1894,77,0,1006,32.000000),(1895,82,0,1006,1.000000),(1896,77,0,1007,32.000000),(1897,82,0,1007,1.000000),(1898,77,0,1008,32.000000),(1899,77,0,1009,20.000000),(1900,82,0,1009,1.000000),(1901,77,0,1010,20.000000),(1902,82,0,1010,1.000000),(1903,77,0,1011,20.000000),(1904,82,0,1011,1.000000),(1905,77,0,1012,20.000000),(1906,82,0,1012,1.000000),(1907,77,0,1013,20.000000),(1908,82,0,1013,1.000000),(1909,77,0,1014,20.000000),(1910,82,0,1014,1.000000),(1911,77,0,1015,20.000000),(1912,82,0,1015,1.000000),(1913,77,0,1016,20.000000),(1914,82,0,1016,1.000000),(1915,77,0,1017,20.000000),(1916,82,0,1017,1.000000),(1917,77,0,1018,20.000000),(1918,82,0,1018,1.000000),(1919,77,0,1019,20.000000),(1920,82,0,1019,1.000000),(1921,77,0,1020,20.000000),(1922,82,0,1020,1.000000),(1923,77,0,1021,20.000000),(1924,77,0,1022,27.000000),(1925,82,0,1022,1.000000),(1926,77,0,1023,27.000000),(1927,82,0,1023,1.000000),(1928,77,0,1024,27.000000),(1929,82,0,1024,1.000000),(1930,77,0,1025,27.000000),(1931,82,0,1025,1.000000),(1932,77,0,1026,27.000000),(1933,82,0,1026,1.000000),(1934,77,0,1027,27.000000),(1935,82,0,1027,1.000000),(1936,77,0,1028,27.000000),(1937,82,0,1028,1.000000),(1938,77,0,1029,27.000000),(1939,82,0,1029,1.000000),(1940,77,0,1030,27.000000),(1941,82,0,1030,1.000000),(1942,77,0,1031,27.000000),(1943,82,0,1031,1.000000),(1944,77,0,1032,27.000000),(1945,82,0,1032,1.000000),(1946,77,0,1033,27.000000),(1947,82,0,1033,1.000000),(1948,77,0,1034,27.000000),(1949,77,0,1035,57.000000),(1950,82,0,1035,1.000000),(1951,77,0,1036,57.000000),(1952,82,0,1036,1.000000),(1953,77,0,1037,57.000000),(1954,82,0,1037,1.000000),(1955,77,0,1038,57.000000),(1956,82,0,1038,1.000000),(1957,77,0,1039,57.000000),(1958,82,0,1039,1.000000),(1959,77,0,1040,57.000000),(1960,82,0,1040,1.000000),(1961,77,0,1041,57.000000),(1962,82,0,1041,1.000000),(1963,77,0,1042,57.000000),(1964,82,0,1042,1.000000),(1965,77,0,1043,57.000000),(1966,82,0,1043,1.000000),(1967,77,0,1044,57.000000),(1968,82,0,1044,1.000000),(1969,77,0,1045,57.000000),(1970,82,0,1045,1.000000),(1971,77,0,1046,57.000000),(1972,82,0,1046,1.000000),(1973,77,0,1047,57.000000),(1974,82,0,1047,1.000000),(1975,77,0,1048,57.000000),(1976,82,0,1048,1.000000),(1977,77,0,1049,57.000000),(1978,82,0,1049,1.000000),(1979,77,0,1050,57.000000),(1980,77,0,1051,48.000000),(1981,82,0,1051,1.000000),(1982,77,0,1052,48.000000),(1983,82,0,1052,1.000000),(1984,77,0,1053,48.000000),(1985,82,0,1053,1.000000),(1986,77,0,1054,48.000000),(1987,82,0,1054,1.000000),(1988,77,0,1055,48.000000),(1989,82,0,1055,1.000000),(1990,77,0,1056,48.000000),(1991,82,0,1056,1.000000),(1992,77,0,1057,48.000000),(1993,82,0,1057,1.000000),(1994,77,0,1058,48.000000),(1995,82,0,1058,1.000000),(1996,77,0,1059,48.000000),(1997,82,0,1059,1.000000),(1998,77,0,1060,48.000000),(1999,82,0,1060,1.000000),(2000,77,0,1061,48.000000),(2001,82,0,1061,1.000000),(2002,77,0,1062,48.000000),(2003,82,0,1062,1.000000),(2004,77,0,1063,48.000000),(2005,82,0,1063,1.000000),(2006,77,0,1064,48.000000),(2007,82,0,1064,1.000000),(2008,77,0,1065,48.000000),(2009,82,0,1065,1.000000),(2010,77,0,1066,48.000000),(2011,77,0,1067,57.000000),(2012,82,0,1067,1.000000),(2013,77,0,1068,57.000000),(2014,82,0,1068,1.000000),(2015,77,0,1069,57.000000),(2016,82,0,1069,1.000000),(2017,77,0,1070,57.000000),(2018,82,0,1070,1.000000),(2019,77,0,1071,57.000000),(2020,82,0,1071,1.000000),(2021,77,0,1072,57.000000),(2022,82,0,1072,1.000000),(2023,77,0,1073,57.000000),(2024,82,0,1073,1.000000),(2025,77,0,1074,57.000000),(2026,82,0,1074,1.000000),(2027,77,0,1075,57.000000),(2028,82,0,1075,1.000000),(2029,77,0,1076,57.000000),(2030,82,0,1076,1.000000),(2031,77,0,1077,57.000000),(2032,82,0,1077,1.000000),(2033,77,0,1078,57.000000),(2034,82,0,1078,1.000000),(2035,77,0,1079,57.000000),(2036,82,0,1079,1.000000),(2037,77,0,1080,57.000000),(2038,82,0,1080,1.000000),(2039,77,0,1081,57.000000),(2040,82,0,1081,1.000000),(2041,77,0,1082,57.000000),(2042,77,0,1083,69.000000),(2043,82,0,1083,1.000000),(2044,77,0,1084,69.000000),(2045,82,0,1084,1.000000),(2046,77,0,1085,69.000000),(2047,82,0,1085,1.000000),(2048,77,0,1086,69.000000),(2049,82,0,1086,1.000000),(2050,77,0,1087,69.000000),(2051,82,0,1087,1.000000),(2052,77,0,1088,69.000000),(2053,82,0,1088,1.000000),(2054,77,0,1089,69.000000),(2055,82,0,1089,1.000000),(2056,77,0,1090,69.000000),(2057,82,0,1090,1.000000),(2058,77,0,1091,69.000000),(2059,82,0,1091,1.000000),(2060,77,0,1092,69.000000),(2061,82,0,1092,1.000000),(2062,77,0,1093,69.000000),(2063,82,0,1093,1.000000),(2064,77,0,1094,69.000000),(2065,82,0,1094,1.000000),(2066,77,0,1095,69.000000),(2067,82,0,1095,1.000000),(2068,77,0,1096,69.000000),(2069,82,0,1096,1.000000),(2070,77,0,1097,69.000000),(2071,82,0,1097,1.000000),(2072,77,0,1098,69.000000),(2073,77,0,1099,42.000000),(2074,82,0,1099,1.000000),(2075,77,0,1100,42.000000),(2076,82,0,1100,1.000000),(2077,77,0,1101,42.000000),(2078,82,0,1101,1.000000),(2079,77,0,1102,42.000000),(2080,82,0,1102,1.000000),(2081,77,0,1103,42.000000),(2082,82,0,1103,1.000000),(2083,77,0,1104,42.000000),(2084,82,0,1104,1.000000),(2085,77,0,1105,42.000000),(2086,82,0,1105,1.000000),(2087,77,0,1106,42.000000),(2088,82,0,1106,1.000000),(2089,77,0,1107,42.000000),(2090,82,0,1107,1.000000),(2091,77,0,1108,42.000000),(2092,82,0,1108,1.000000),(2093,77,0,1109,42.000000),(2094,82,0,1109,1.000000),(2095,77,0,1110,42.000000),(2096,82,0,1110,1.000000),(2097,77,0,1111,42.000000),(2098,82,0,1111,1.000000),(2099,77,0,1112,42.000000),(2100,82,0,1112,1.000000),(2101,77,0,1113,42.000000),(2102,82,0,1113,1.000000),(2103,77,0,1114,42.000000),(2104,77,0,1115,59.000000),(2105,82,0,1115,1.000000),(2106,77,0,1116,59.000000),(2107,82,0,1116,1.000000),(2108,77,0,1117,59.000000),(2109,82,0,1117,1.000000),(2110,77,0,1118,59.000000),(2111,82,0,1118,1.000000),(2112,77,0,1119,59.000000),(2113,82,0,1119,1.000000),(2114,77,0,1120,59.000000),(2115,77,0,1121,59.000000),(2116,82,0,1121,1.000000),(2117,77,0,1122,59.000000),(2118,82,0,1122,1.000000),(2119,77,0,1123,59.000000),(2120,82,0,1123,1.000000),(2121,77,0,1124,59.000000),(2122,82,0,1124,1.000000),(2123,77,0,1125,59.000000),(2124,82,0,1125,1.000000),(2125,77,0,1126,59.000000),(2126,82,0,1126,1.000000),(2127,77,0,1127,59.000000),(2128,82,0,1127,1.000000),(2129,77,0,1128,59.000000),(2130,82,0,1128,1.000000),(2131,77,0,1129,59.000000),(2132,82,0,1129,1.000000),(2133,77,0,1130,59.000000),(2134,82,0,1130,1.000000),(2135,77,0,1131,59.000000),(2136,82,0,1131,1.000000),(2137,77,0,1132,59.000000),(2138,82,0,1132,1.000000),(2139,77,0,1133,59.000000),(2140,82,0,1133,1.000000),(2141,77,0,1134,59.000000),(2142,82,0,1134,1.000000),(2143,77,0,1135,59.000000),(2144,82,0,1135,1.000000),(2145,77,0,1136,59.000000),(2146,77,0,1137,48.000000),(2147,82,0,1137,1.000000),(2148,77,0,1138,48.000000),(2149,82,0,1138,1.000000),(2150,77,0,1139,48.000000),(2151,82,0,1139,1.000000),(2152,77,0,1140,48.000000),(2153,82,0,1140,1.000000),(2154,77,0,1141,48.000000),(2155,82,0,1141,1.000000),(2156,77,0,1142,48.000000),(2157,82,0,1142,1.000000),(2158,77,0,1143,48.000000),(2159,82,0,1143,1.000000),(2160,77,0,1144,48.000000),(2161,82,0,1144,1.000000),(2162,77,0,1145,48.000000),(2163,82,0,1145,1.000000),(2164,77,0,1146,48.000000),(2165,82,0,1146,1.000000),(2166,77,0,1147,48.000000),(2167,82,0,1147,1.000000),(2168,77,0,1148,48.000000),(2169,82,0,1148,1.000000),(2170,77,0,1149,48.000000),(2171,82,0,1149,1.000000),(2172,77,0,1150,48.000000),(2173,82,0,1150,1.000000),(2174,77,0,1151,48.000000),(2175,82,0,1151,1.000000),(2176,77,0,1152,48.000000),(2177,77,0,1153,39.000000),(2178,82,0,1153,1.000000),(2179,77,0,1154,39.000000),(2180,82,0,1154,1.000000),(2181,77,0,1155,39.000000),(2182,82,0,1155,1.000000),(2183,77,0,1156,39.000000),(2184,82,0,1156,1.000000),(2185,77,0,1157,39.000000),(2186,82,0,1157,1.000000),(2187,77,0,1158,39.000000),(2188,82,0,1158,1.000000),(2189,77,0,1159,39.000000),(2190,82,0,1159,1.000000),(2191,77,0,1160,39.000000),(2192,82,0,1160,1.000000),(2193,77,0,1161,39.000000),(2194,82,0,1161,1.000000),(2195,77,0,1162,39.000000),(2196,82,0,1162,1.000000),(2197,77,0,1163,39.000000),(2198,82,0,1163,1.000000),(2199,77,0,1164,39.000000),(2200,82,0,1164,1.000000),(2201,77,0,1165,39.000000),(2202,82,0,1165,1.000000),(2203,77,0,1166,39.000000),(2204,82,0,1166,1.000000),(2205,77,0,1167,39.000000),(2206,82,0,1167,1.000000),(2207,77,0,1168,39.000000),(2208,77,0,1169,55.000000),(2209,82,0,1169,1.000000),(2210,77,0,1170,55.000000),(2211,82,0,1170,1.000000),(2212,77,0,1171,55.000000),(2213,82,0,1171,1.000000),(2214,77,0,1172,55.000000),(2215,82,0,1172,1.000000),(2216,77,0,1173,55.000000),(2217,82,0,1173,1.000000),(2218,77,0,1174,55.000000),(2219,82,0,1174,1.000000),(2220,77,0,1175,55.000000),(2221,82,0,1175,1.000000),(2222,77,0,1176,55.000000),(2223,82,0,1176,1.000000),(2224,77,0,1177,55.000000),(2225,82,0,1177,1.000000),(2226,77,0,1178,55.000000),(2227,82,0,1178,1.000000),(2228,77,0,1179,55.000000),(2229,82,0,1179,1.000000),(2230,77,0,1180,55.000000),(2231,82,0,1180,1.000000),(2232,77,0,1181,55.000000),(2233,82,0,1181,1.000000),(2234,77,0,1182,55.000000),(2235,82,0,1182,1.000000),(2236,77,0,1183,55.000000),(2237,82,0,1183,1.000000),(2238,77,0,1184,55.000000),(2239,77,0,1185,54.000000),(2240,82,0,1185,1.000000),(2241,77,0,1186,54.000000),(2242,82,0,1186,1.000000),(2243,77,0,1187,54.000000),(2244,82,0,1187,1.000000),(2245,77,0,1188,54.000000),(2246,82,0,1188,1.000000),(2247,77,0,1189,54.000000),(2248,82,0,1189,1.000000),(2249,77,0,1190,54.000000),(2250,82,0,1190,1.000000),(2251,77,0,1191,54.000000),(2252,82,0,1191,1.000000),(2253,77,0,1192,54.000000),(2254,82,0,1192,1.000000),(2255,77,0,1193,54.000000),(2256,82,0,1193,1.000000),(2257,77,0,1194,54.000000),(2258,82,0,1194,1.000000),(2259,77,0,1195,54.000000),(2260,82,0,1195,1.000000),(2261,77,0,1196,54.000000),(2262,82,0,1196,1.000000),(2263,77,0,1197,54.000000),(2264,82,0,1197,1.000000),(2265,77,0,1198,54.000000),(2266,82,0,1198,1.000000),(2267,77,0,1199,54.000000),(2268,82,0,1199,1.000000),(2269,77,0,1200,54.000000),(2270,77,0,1201,68.000000),(2271,82,0,1201,1.000000),(2272,77,0,1202,68.000000),(2273,82,0,1202,1.000000),(2274,77,0,1203,68.000000),(2275,82,0,1203,1.000000),(2276,77,0,1204,68.000000),(2277,82,0,1204,1.000000),(2278,77,0,1205,68.000000),(2279,82,0,1205,1.000000),(2280,77,0,1206,68.000000),(2281,82,0,1206,1.000000),(2282,77,0,1207,68.000000),(2283,82,0,1207,1.000000),(2284,77,0,1208,68.000000),(2285,82,0,1208,1.000000),(2286,77,0,1209,68.000000),(2287,82,0,1209,1.000000),(2288,77,0,1210,68.000000),(2289,82,0,1210,1.000000),(2290,77,0,1211,68.000000),(2291,82,0,1211,1.000000),(2292,77,0,1212,68.000000),(2293,82,0,1212,1.000000),(2294,77,0,1213,68.000000),(2295,82,0,1213,1.000000),(2296,77,0,1214,68.000000),(2297,82,0,1214,1.000000),(2298,77,0,1215,68.000000),(2299,82,0,1215,1.000000),(2300,77,0,1216,68.000000),(2301,77,0,1217,75.000000),(2302,82,0,1217,1.000000),(2303,77,0,1218,75.000000),(2304,82,0,1218,1.000000),(2305,77,0,1219,75.000000),(2306,82,0,1219,1.000000),(2307,77,0,1220,75.000000),(2308,82,0,1220,1.000000),(2309,77,0,1221,75.000000),(2310,82,0,1221,1.000000),(2311,77,0,1222,75.000000),(2312,82,0,1222,1.000000),(2313,77,0,1223,75.000000),(2314,82,0,1223,1.000000),(2315,77,0,1224,75.000000),(2316,82,0,1224,1.000000),(2317,77,0,1225,75.000000),(2318,82,0,1225,1.000000),(2319,77,0,1226,75.000000),(2320,77,0,1227,56.250000),(2321,82,0,1227,1.000000),(2322,77,0,1228,56.250000),(2323,82,0,1228,1.000000),(2324,77,0,1229,56.250000),(2325,82,0,1229,1.000000),(2326,77,0,1230,56.250000),(2327,82,0,1230,1.000000),(2328,77,0,1231,56.250000),(2329,82,0,1231,1.000000),(2330,77,0,1232,56.250000),(2331,82,0,1232,1.000000),(2332,77,0,1233,56.250000),(2333,82,0,1233,1.000000),(2334,77,0,1234,56.250000),(2335,82,0,1234,1.000000),(2336,77,0,1235,56.250000),(2337,82,0,1235,1.000000),(2338,77,0,1236,56.250000),(2339,82,0,1236,1.000000),(2340,77,0,1237,56.250000),(2341,82,0,1237,1.000000),(2342,77,0,1238,56.250000),(2343,82,0,1238,1.000000),(2344,77,0,1239,56.250000),(2345,82,0,1239,1.000000),(2346,77,0,1240,56.250000),(2347,82,0,1240,1.000000),(2348,77,0,1241,56.250000),(2349,82,0,1241,1.000000),(2350,77,0,1242,56.250000),(2351,77,0,1243,57.000000),(2352,82,0,1243,1.000000),(2353,77,0,1244,57.000000),(2354,82,0,1244,1.000000),(2355,77,0,1245,57.000000),(2356,82,0,1245,1.000000),(2357,77,0,1246,57.000000),(2358,82,0,1246,1.000000),(2359,77,0,1247,57.000000),(2360,82,0,1247,1.000000),(2361,77,0,1248,57.000000),(2362,82,0,1248,1.000000),(2363,77,0,1249,57.000000),(2364,82,0,1249,1.000000),(2365,77,0,1250,57.000000),(2366,82,0,1250,1.000000),(2367,77,0,1251,57.000000),(2368,82,0,1251,1.000000),(2369,77,0,1252,57.000000),(2370,82,0,1252,1.000000),(2371,77,0,1253,57.000000),(2372,82,0,1253,1.000000),(2373,77,0,1254,57.000000),(2374,82,0,1254,1.000000),(2375,77,0,1255,57.000000),(2376,82,0,1255,1.000000),(2377,77,0,1256,57.000000),(2378,82,0,1256,1.000000),(2379,77,0,1257,57.000000),(2380,82,0,1257,1.000000),(2381,77,0,1258,57.000000),(2382,77,0,1259,84.000000),(2383,82,0,1259,1.000000),(2384,77,0,1260,84.000000),(2385,82,0,1260,1.000000),(2386,77,0,1261,84.000000),(2387,82,0,1261,1.000000),(2388,77,0,1262,84.000000),(2389,82,0,1262,1.000000),(2390,77,0,1263,84.000000),(2391,82,0,1263,1.000000),(2392,77,0,1264,84.000000),(2393,82,0,1264,1.000000),(2394,77,0,1265,84.000000),(2395,82,0,1265,1.000000),(2396,77,0,1266,84.000000),(2397,82,0,1266,1.000000),(2398,77,0,1267,84.000000),(2399,82,0,1267,1.000000),(2400,77,0,1268,84.000000),(2401,82,0,1268,1.000000),(2402,77,0,1269,84.000000),(2403,82,0,1269,1.000000),(2404,77,0,1270,84.000000),(2405,82,0,1270,1.000000),(2406,77,0,1271,84.000000),(2407,82,0,1271,1.000000),(2408,77,0,1272,84.000000),(2409,82,0,1272,1.000000),(2410,77,0,1273,84.000000),(2411,82,0,1273,1.000000),(2412,77,0,1274,84.000000),(2413,77,0,1275,60.000000),(2414,82,0,1275,1.000000),(2415,77,0,1276,60.000000),(2416,82,0,1276,1.000000),(2417,77,0,1277,60.000000),(2418,82,0,1277,1.000000),(2419,77,0,1278,60.000000),(2420,82,0,1278,1.000000),(2421,77,0,1279,60.000000),(2422,82,0,1279,1.000000),(2423,77,0,1280,60.000000),(2424,82,0,1280,1.000000),(2425,77,0,1281,60.000000),(2426,82,0,1281,1.000000),(2427,77,0,1282,60.000000),(2428,82,0,1282,1.000000),(2429,77,0,1283,60.000000),(2430,82,0,1283,1.000000),(2431,77,0,1284,60.000000),(2432,82,0,1284,1.000000),(2433,77,0,1285,60.000000),(2434,82,0,1285,1.000000),(2435,77,0,1286,60.000000),(2436,82,0,1286,1.000000),(2437,77,0,1287,60.000000),(2438,82,0,1287,1.000000),(2439,77,0,1288,60.000000),(2440,82,0,1288,1.000000),(2441,77,0,1289,60.000000),(2442,82,0,1289,1.000000),(2443,77,0,1290,60.000000),(2444,77,0,1291,59.000000),(2445,82,0,1291,1.000000),(2446,77,0,1292,59.000000),(2447,82,0,1292,1.000000),(2448,77,0,1293,59.000000),(2449,82,0,1293,1.000000),(2450,77,0,1294,59.000000),(2451,82,0,1294,1.000000),(2452,77,0,1295,59.000000),(2453,82,0,1295,1.000000),(2454,77,0,1296,59.000000),(2455,82,0,1296,1.000000),(2456,77,0,1297,59.000000),(2457,82,0,1297,1.000000),(2458,77,0,1298,59.000000),(2459,82,0,1298,1.000000),(2460,77,0,1299,59.000000),(2461,82,0,1299,1.000000),(2462,77,0,1300,59.000000),(2463,82,0,1300,1.000000),(2464,77,0,1301,59.000000),(2465,82,0,1301,1.000000),(2466,77,0,1302,59.000000),(2467,82,0,1302,1.000000),(2468,77,0,1303,59.000000),(2469,82,0,1303,1.000000),(2470,77,0,1304,59.000000),(2471,82,0,1304,1.000000),(2472,77,0,1305,59.000000),(2473,82,0,1305,1.000000),(2474,77,0,1306,59.000000),(2475,77,0,1307,57.000000),(2476,82,0,1307,1.000000),(2477,77,0,1308,57.000000),(2478,82,0,1308,1.000000),(2479,77,0,1309,57.000000),(2480,82,0,1309,1.000000),(2481,77,0,1310,57.000000),(2482,82,0,1310,1.000000),(2483,77,0,1311,57.000000),(2484,82,0,1311,1.000000),(2485,77,0,1312,57.000000),(2486,82,0,1312,1.000000),(2487,77,0,1313,57.000000),(2488,82,0,1313,1.000000),(2489,77,0,1314,57.000000),(2490,82,0,1314,1.000000),(2491,77,0,1315,57.000000),(2492,82,0,1315,1.000000),(2493,77,0,1316,57.000000),(2494,82,0,1316,1.000000),(2495,77,0,1317,57.000000),(2496,82,0,1317,1.000000),(2497,77,0,1318,57.000000),(2498,82,0,1318,1.000000),(2499,77,0,1319,57.000000),(2500,82,0,1319,1.000000),(2501,77,0,1320,57.000000),(2502,82,0,1320,1.000000),(2503,77,0,1321,57.000000),(2504,82,0,1321,1.000000),(2505,77,0,1322,57.000000),(2506,77,0,1323,32.000000),(2507,82,0,1323,1.000000),(2508,77,0,1324,32.000000),(2509,82,0,1324,1.000000),(2510,77,0,1325,32.000000),(2511,82,0,1325,1.000000),(2512,77,0,1326,32.000000),(2513,82,0,1326,1.000000),(2514,77,0,1327,32.000000),(2515,82,0,1327,1.000000),(2516,77,0,1328,32.000000),(2517,82,0,1328,1.000000),(2518,77,0,1329,32.000000),(2519,82,0,1329,1.000000),(2520,77,0,1330,32.000000),(2521,82,0,1330,1.000000),(2522,77,0,1331,32.000000),(2523,82,0,1331,1.000000),(2524,77,0,1332,32.000000),(2525,82,0,1332,1.000000),(2526,77,0,1333,32.000000),(2527,82,0,1333,1.000000),(2528,77,0,1334,32.000000),(2529,82,0,1334,1.000000),(2530,77,0,1335,32.000000),(2531,82,0,1335,1.000000),(2532,77,0,1336,32.000000),(2533,82,0,1336,1.000000),(2534,77,0,1337,32.000000),(2535,82,0,1337,1.000000),(2536,77,0,1338,32.000000),(2537,77,0,1339,69.000000),(2538,82,0,1339,1.000000),(2539,77,0,1340,69.000000),(2540,82,0,1340,1.000000),(2541,77,0,1341,69.000000),(2542,82,0,1341,1.000000),(2543,77,0,1342,69.000000),(2544,82,0,1342,1.000000),(2545,77,0,1343,69.000000),(2546,82,0,1343,1.000000),(2547,77,0,1344,69.000000),(2548,82,0,1344,1.000000),(2549,77,0,1345,69.000000),(2550,82,0,1345,1.000000),(2551,77,0,1346,69.000000),(2552,82,0,1346,1.000000),(2553,77,0,1347,69.000000),(2554,82,0,1347,1.000000),(2555,77,0,1348,69.000000),(2556,82,0,1348,1.000000),(2557,77,0,1349,69.000000),(2558,82,0,1349,1.000000),(2559,77,0,1350,69.000000),(2560,82,0,1350,1.000000),(2561,77,0,1351,69.000000),(2562,82,0,1351,1.000000),(2563,77,0,1352,69.000000),(2564,82,0,1352,1.000000),(2565,77,0,1353,69.000000),(2566,82,0,1353,1.000000),(2567,77,0,1354,69.000000),(2568,77,0,1355,69.000000),(2569,82,0,1355,1.000000),(2570,77,0,1356,69.000000),(2571,82,0,1356,1.000000),(2572,77,0,1357,69.000000),(2573,82,0,1357,1.000000),(2574,77,0,1358,69.000000),(2575,82,0,1358,1.000000),(2576,77,0,1359,69.000000),(2577,82,0,1359,1.000000),(2578,77,0,1360,69.000000),(2579,82,0,1360,1.000000),(2580,77,0,1361,69.000000),(2581,82,0,1361,1.000000),(2582,77,0,1362,69.000000),(2583,82,0,1362,1.000000),(2584,77,0,1363,69.000000),(2585,82,0,1363,1.000000),(2586,77,0,1364,69.000000),(2587,82,0,1364,1.000000),(2588,77,0,1365,69.000000),(2589,82,0,1365,1.000000),(2590,77,0,1366,69.000000),(2591,82,0,1366,1.000000),(2592,77,0,1367,69.000000),(2593,82,0,1367,1.000000),(2594,77,0,1368,69.000000),(2595,82,0,1368,1.000000),(2596,77,0,1369,69.000000),(2597,82,0,1369,1.000000),(2598,77,0,1370,69.000000),(2599,77,0,1371,77.000000),(2600,82,0,1371,1.000000),(2601,77,0,1372,77.000000),(2602,82,0,1372,1.000000),(2603,77,0,1373,77.000000),(2604,82,0,1373,1.000000),(2605,77,0,1374,77.000000),(2606,82,0,1374,1.000000),(2607,77,0,1375,77.000000),(2608,82,0,1375,1.000000),(2609,77,0,1376,77.000000),(2610,82,0,1376,1.000000),(2611,77,0,1377,77.000000),(2612,82,0,1377,1.000000),(2613,77,0,1378,77.000000),(2614,82,0,1378,1.000000),(2615,77,0,1379,77.000000),(2616,82,0,1379,1.000000),(2617,77,0,1380,77.000000),(2618,82,0,1380,1.000000),(2619,77,0,1381,77.000000),(2620,82,0,1381,1.000000),(2621,77,0,1382,77.000000),(2622,82,0,1382,1.000000),(2623,77,0,1383,77.000000),(2624,82,0,1383,1.000000),(2625,77,0,1384,77.000000),(2626,82,0,1384,1.000000),(2627,77,0,1385,77.000000),(2628,82,0,1385,1.000000),(2629,77,0,1386,77.000000),(2630,77,0,1387,77.000000),(2631,82,0,1387,1.000000),(2632,77,0,1388,77.000000),(2633,82,0,1388,1.000000),(2634,77,0,1389,77.000000),(2635,82,0,1389,1.000000),(2636,77,0,1390,77.000000),(2637,82,0,1390,1.000000),(2638,77,0,1391,77.000000),(2639,82,0,1391,1.000000),(2640,77,0,1392,77.000000),(2641,82,0,1392,1.000000),(2642,77,0,1393,77.000000),(2643,82,0,1393,1.000000),(2644,77,0,1394,77.000000),(2645,82,0,1394,1.000000),(2646,77,0,1395,77.000000),(2647,82,0,1395,1.000000),(2648,77,0,1396,77.000000),(2649,82,0,1396,1.000000),(2650,77,0,1397,77.000000),(2651,82,0,1397,1.000000),(2652,77,0,1398,77.000000),(2653,82,0,1398,1.000000),(2654,77,0,1399,77.000000),(2655,82,0,1399,1.000000),(2656,77,0,1400,77.000000),(2657,82,0,1400,1.000000),(2658,77,0,1401,77.000000),(2659,82,0,1401,1.000000),(2660,77,0,1402,77.000000),(2661,77,0,1403,28.000000),(2662,82,0,1403,1.000000),(2663,77,0,1404,28.000000),(2664,82,0,1404,1.000000),(2665,77,0,1405,28.000000),(2666,82,0,1405,1.000000),(2667,77,0,1406,28.000000),(2668,82,0,1406,1.000000),(2669,77,0,1407,28.000000),(2670,82,0,1407,1.000000),(2671,77,0,1408,28.000000),(2672,82,0,1408,1.000000),(2673,77,0,1409,28.000000),(2674,82,0,1409,1.000000),(2675,77,0,1410,28.000000),(2676,82,0,1410,1.000000),(2677,77,0,1411,28.000000),(2678,82,0,1411,1.000000),(2679,77,0,1412,28.000000),(2680,82,0,1412,1.000000),(2681,77,0,1413,28.000000),(2682,82,0,1413,1.000000),(2683,77,0,1414,28.000000),(2684,82,0,1414,1.000000),(2685,77,0,1415,28.000000),(2686,82,0,1415,1.000000),(2687,77,0,1416,28.000000),(2688,82,0,1416,1.000000),(2689,77,0,1417,28.000000),(2690,82,0,1417,1.000000),(2691,77,0,1418,28.000000),(2692,77,0,1419,29.000000),(2693,82,0,1419,1.000000),(2694,77,0,1420,29.000000),(2695,82,0,1420,1.000000),(2696,77,0,1421,29.000000),(2697,82,0,1421,1.000000),(2698,77,0,1422,29.000000),(2699,82,0,1422,1.000000),(2700,77,0,1423,29.000000),(2701,82,0,1423,1.000000),(2702,77,0,1424,29.000000),(2703,82,0,1424,1.000000),(2704,77,0,1425,29.000000),(2705,82,0,1425,1.000000),(2706,77,0,1426,29.000000),(2707,82,0,1426,1.000000),(2708,77,0,1427,29.000000),(2709,82,0,1427,1.000000),(2710,77,0,1428,29.000000),(2711,82,0,1428,1.000000),(2712,77,0,1429,29.000000),(2713,82,0,1429,1.000000),(2714,77,0,1430,29.000000),(2715,82,0,1430,1.000000),(2716,77,0,1431,29.000000),(2717,82,0,1431,1.000000),(2718,77,0,1432,29.000000),(2719,82,0,1432,1.000000),(2720,77,0,1433,29.000000),(2721,82,0,1433,1.000000),(2722,77,0,1434,29.000000),(2723,77,0,1435,29.000000),(2724,82,0,1435,1.000000),(2725,77,0,1436,29.000000),(2726,82,0,1436,1.000000),(2727,77,0,1437,29.000000),(2728,82,0,1437,1.000000),(2729,77,0,1438,29.000000),(2730,82,0,1438,1.000000),(2731,77,0,1439,29.000000),(2732,82,0,1439,1.000000),(2733,77,0,1440,29.000000),(2734,82,0,1440,1.000000),(2735,77,0,1441,29.000000),(2736,82,0,1441,1.000000),(2737,77,0,1442,29.000000),(2738,82,0,1442,1.000000),(2739,77,0,1443,29.000000),(2740,82,0,1443,1.000000),(2741,77,0,1444,29.000000),(2742,82,0,1444,1.000000),(2743,77,0,1445,29.000000),(2744,82,0,1445,1.000000),(2745,77,0,1446,29.000000),(2746,82,0,1446,1.000000),(2747,77,0,1447,29.000000),(2748,82,0,1447,1.000000),(2749,77,0,1448,29.000000),(2750,82,0,1448,1.000000),(2751,77,0,1449,29.000000),(2752,82,0,1449,1.000000),(2753,77,0,1450,29.000000),(2754,77,0,1451,29.000000),(2755,82,0,1451,1.000000),(2756,77,0,1452,29.000000),(2757,82,0,1452,1.000000),(2758,77,0,1453,29.000000),(2759,82,0,1453,1.000000),(2760,77,0,1454,29.000000),(2761,82,0,1454,1.000000),(2762,77,0,1455,29.000000),(2763,82,0,1455,1.000000),(2764,77,0,1456,29.000000),(2765,82,0,1456,1.000000),(2766,77,0,1457,29.000000),(2767,82,0,1457,1.000000),(2768,77,0,1458,29.000000),(2769,82,0,1458,1.000000),(2770,77,0,1459,29.000000),(2771,82,0,1459,1.000000),(2772,77,0,1460,29.000000),(2773,82,0,1460,1.000000),(2774,77,0,1461,29.000000),(2775,82,0,1461,1.000000),(2776,77,0,1462,29.000000),(2777,82,0,1462,1.000000),(2778,77,0,1463,29.000000),(2779,82,0,1463,1.000000),(2780,77,0,1464,29.000000),(2781,82,0,1464,1.000000),(2782,77,0,1465,29.000000),(2783,82,0,1465,1.000000),(2784,77,0,1466,29.000000),(2785,77,0,1467,42.000000),(2786,82,0,1467,1.000000),(2787,77,0,1468,42.000000),(2788,82,0,1468,1.000000),(2789,77,0,1469,42.000000),(2790,82,0,1469,1.000000),(2791,77,0,1470,42.000000),(2792,82,0,1470,1.000000),(2793,77,0,1471,42.000000),(2794,82,0,1471,1.000000),(2795,77,0,1472,42.000000),(2796,82,0,1472,1.000000),(2797,77,0,1473,42.000000),(2798,82,0,1473,1.000000),(2799,77,0,1474,42.000000),(2800,82,0,1474,1.000000),(2801,77,0,1475,42.000000),(2802,82,0,1475,1.000000),(2803,77,0,1476,42.000000),(2804,82,0,1476,1.000000),(2805,77,0,1477,42.000000),(2806,82,0,1477,1.000000),(2807,77,0,1478,42.000000),(2808,82,0,1478,1.000000),(2809,77,0,1479,42.000000),(2810,82,0,1479,1.000000),(2811,77,0,1480,42.000000),(2812,82,0,1480,1.000000),(2813,77,0,1481,42.000000),(2814,82,0,1481,1.000000),(2815,77,0,1482,42.000000),(2816,77,0,1483,32.000000),(2817,82,0,1483,1.000000),(2818,77,0,1484,32.000000),(2819,82,0,1484,1.000000),(2820,77,0,1485,32.000000),(2821,82,0,1485,1.000000),(2822,77,0,1486,32.000000),(2823,82,0,1486,1.000000),(2824,77,0,1487,32.000000),(2825,82,0,1487,1.000000),(2826,77,0,1488,32.000000),(2827,82,0,1488,1.000000),(2828,77,0,1489,32.000000),(2829,82,0,1489,1.000000),(2830,77,0,1490,32.000000),(2831,82,0,1490,1.000000),(2832,77,0,1491,32.000000),(2833,82,0,1491,1.000000),(2834,77,0,1492,32.000000),(2835,82,0,1492,1.000000),(2836,77,0,1493,32.000000),(2837,82,0,1493,1.000000),(2838,77,0,1494,32.000000),(2839,82,0,1494,1.000000),(2840,77,0,1495,32.000000),(2841,82,0,1495,1.000000),(2842,77,0,1496,32.000000),(2843,82,0,1496,1.000000),(2844,77,0,1497,32.000000),(2845,82,0,1497,1.000000),(2846,77,0,1498,32.000000),(2847,77,0,1499,28.000000),(2848,82,0,1499,1.000000),(2849,77,0,1500,28.000000),(2850,82,0,1500,1.000000),(2851,77,0,1501,28.000000),(2852,82,0,1501,1.000000),(2853,77,0,1502,28.000000),(2854,82,0,1502,1.000000),(2855,77,0,1503,28.000000),(2856,82,0,1503,1.000000),(2857,77,0,1504,28.000000),(2858,82,0,1504,1.000000),(2859,77,0,1505,28.000000),(2860,82,0,1505,1.000000),(2861,77,0,1506,28.000000),(2862,82,0,1506,1.000000),(2863,77,0,1507,28.000000),(2864,82,0,1507,1.000000),(2865,77,0,1508,28.000000),(2866,82,0,1508,1.000000),(2867,77,0,1509,28.000000),(2868,82,0,1509,1.000000),(2869,77,0,1510,28.000000),(2870,82,0,1510,1.000000),(2871,77,0,1511,28.000000),(2872,82,0,1511,1.000000),(2873,77,0,1512,28.000000),(2874,82,0,1512,1.000000),(2875,77,0,1513,28.000000),(2876,82,0,1513,1.000000),(2877,77,0,1514,28.000000),(2878,77,0,1515,32.000000),(2879,82,0,1515,1.000000),(2880,77,0,1516,32.000000),(2881,82,0,1516,1.000000),(2882,77,0,1517,32.000000),(2883,82,0,1517,1.000000),(2884,77,0,1518,32.000000),(2885,82,0,1518,1.000000),(2886,77,0,1519,32.000000),(2887,82,0,1519,1.000000),(2888,77,0,1520,32.000000),(2889,82,0,1520,1.000000),(2890,77,0,1521,32.000000),(2891,82,0,1521,1.000000),(2892,77,0,1522,32.000000),(2893,82,0,1522,1.000000),(2894,77,0,1523,32.000000),(2895,82,0,1523,1.000000),(2896,77,0,1524,32.000000),(2897,82,0,1524,1.000000),(2898,77,0,1525,32.000000),(2899,82,0,1525,1.000000),(2900,77,0,1526,32.000000),(2901,82,0,1526,1.000000),(2902,77,0,1527,32.000000),(2903,82,0,1527,1.000000),(2904,77,0,1528,32.000000),(2905,82,0,1528,1.000000),(2906,77,0,1529,32.000000),(2907,82,0,1529,1.000000),(2908,77,0,1530,32.000000),(2909,77,0,1531,32.000000),(2910,82,0,1531,1.000000),(2911,77,0,1532,32.000000),(2912,82,0,1532,1.000000),(2913,77,0,1533,32.000000),(2914,82,0,1533,1.000000),(2915,77,0,1534,32.000000),(2916,82,0,1534,1.000000),(2917,77,0,1535,32.000000),(2918,82,0,1535,1.000000),(2919,77,0,1536,32.000000),(2920,82,0,1536,1.000000),(2921,77,0,1537,32.000000),(2922,82,0,1537,1.000000),(2923,77,0,1538,32.000000),(2924,82,0,1538,1.000000),(2925,77,0,1539,32.000000),(2926,82,0,1539,1.000000),(2927,77,0,1540,32.000000),(2928,82,0,1540,1.000000),(2929,77,0,1541,32.000000),(2930,82,0,1541,1.000000),(2931,77,0,1542,32.000000),(2932,82,0,1542,1.000000),(2933,77,0,1543,32.000000),(2934,82,0,1543,1.000000),(2935,77,0,1544,32.000000),(2936,82,0,1544,1.000000),(2937,77,0,1545,32.000000),(2938,82,0,1545,1.000000),(2939,77,0,1546,32.000000),(2940,77,0,1547,22.000000),(2941,82,0,1547,1.000000),(2942,77,0,1548,22.000000),(2943,82,0,1548,1.000000),(2944,77,0,1549,22.000000),(2945,82,0,1549,1.000000),(2946,77,0,1550,22.000000),(2947,82,0,1550,1.000000),(2948,77,0,1551,22.000000),(2949,82,0,1551,1.000000),(2950,77,0,1552,22.000000),(2951,82,0,1552,1.000000),(2952,77,0,1553,22.000000),(2953,82,0,1553,1.000000),(2954,77,0,1554,22.000000),(2955,82,0,1554,1.000000),(2956,77,0,1555,22.000000),(2957,82,0,1555,1.000000),(2958,77,0,1556,22.000000),(2959,82,0,1556,1.000000),(2960,77,0,1557,22.000000),(2961,82,0,1557,1.000000),(2962,77,0,1558,22.000000),(2963,82,0,1558,1.000000),(2964,77,0,1559,22.000000),(2965,82,0,1559,1.000000),(2966,77,0,1560,22.000000),(2967,82,0,1560,1.000000),(2968,77,0,1561,22.000000),(2969,82,0,1561,1.000000),(2970,77,0,1562,22.000000),(2971,77,0,1563,24.000000),(2972,82,0,1563,1.000000),(2973,77,0,1564,24.000000),(2974,82,0,1564,1.000000),(2975,77,0,1565,24.000000),(2976,82,0,1565,1.000000),(2977,77,0,1566,24.000000),(2978,82,0,1566,1.000000),(2979,77,0,1567,24.000000),(2980,82,0,1567,1.000000),(2981,77,0,1568,24.000000),(2982,82,0,1568,1.000000),(2983,77,0,1569,24.000000),(2984,82,0,1569,1.000000),(2985,77,0,1570,24.000000),(2986,82,0,1570,1.000000),(2987,77,0,1571,24.000000),(2988,82,0,1571,1.000000),(2989,77,0,1572,24.000000),(2990,82,0,1572,1.000000),(2991,77,0,1573,24.000000),(2992,82,0,1573,1.000000),(2993,77,0,1574,24.000000),(2994,82,0,1574,1.000000),(2995,77,0,1575,24.000000),(2996,82,0,1575,1.000000),(2997,77,0,1576,24.000000),(2998,82,0,1576,1.000000),(2999,77,0,1577,24.000000),(3000,82,0,1577,1.000000),(3001,77,0,1578,24.000000),(3002,77,0,1579,24.000000),(3003,82,0,1579,1.000000),(3004,77,0,1580,24.000000),(3005,82,0,1580,1.000000),(3006,77,0,1581,24.000000),(3007,82,0,1581,1.000000),(3008,77,0,1582,24.000000),(3009,82,0,1582,1.000000),(3010,77,0,1583,24.000000),(3011,82,0,1583,1.000000),(3012,77,0,1584,24.000000),(3013,82,0,1584,1.000000),(3014,77,0,1585,24.000000),(3015,82,0,1585,1.000000),(3016,77,0,1586,24.000000),(3017,82,0,1586,1.000000),(3018,77,0,1587,24.000000),(3019,82,0,1587,1.000000),(3020,77,0,1588,24.000000),(3021,82,0,1588,1.000000),(3022,77,0,1589,24.000000),(3023,82,0,1589,1.000000),(3024,77,0,1590,24.000000),(3025,82,0,1590,1.000000),(3026,77,0,1591,24.000000),(3027,82,0,1591,1.000000),(3028,77,0,1592,24.000000),(3029,82,0,1592,1.000000),(3030,77,0,1593,24.000000),(3031,82,0,1593,1.000000),(3032,77,0,1594,24.000000),(3033,77,0,1595,39.000000),(3034,82,0,1595,1.000000),(3035,77,0,1596,39.000000),(3036,82,0,1596,1.000000),(3037,77,0,1597,39.000000),(3038,82,0,1597,1.000000),(3039,77,0,1598,39.000000),(3040,82,0,1598,1.000000),(3041,77,0,1599,39.000000),(3042,82,0,1599,1.000000),(3043,77,0,1600,39.000000),(3044,82,0,1600,1.000000),(3045,77,0,1601,39.000000),(3046,82,0,1601,1.000000),(3047,77,0,1602,39.000000),(3048,82,0,1602,1.000000),(3049,77,0,1603,39.000000),(3050,82,0,1603,1.000000),(3051,77,0,1604,39.000000),(3052,82,0,1604,1.000000),(3053,77,0,1605,39.000000),(3054,82,0,1605,1.000000),(3055,77,0,1606,39.000000),(3056,82,0,1606,1.000000),(3057,77,0,1607,39.000000),(3058,82,0,1607,1.000000),(3059,77,0,1608,39.000000),(3060,82,0,1608,1.000000),(3061,77,0,1609,39.000000),(3062,82,0,1609,1.000000),(3063,77,0,1610,39.000000),(3064,77,0,1611,39.000000),(3065,82,0,1611,1.000000),(3066,77,0,1612,39.000000),(3067,82,0,1612,1.000000),(3068,77,0,1613,39.000000),(3069,82,0,1613,1.000000),(3070,77,0,1614,39.000000),(3071,82,0,1614,1.000000),(3072,77,0,1615,39.000000),(3073,82,0,1615,1.000000),(3074,77,0,1616,39.000000),(3075,82,0,1616,1.000000),(3076,77,0,1617,39.000000),(3077,82,0,1617,1.000000),(3078,77,0,1618,39.000000),(3079,82,0,1618,1.000000),(3080,77,0,1619,39.000000),(3081,82,0,1619,1.000000),(3082,77,0,1620,39.000000),(3083,82,0,1620,1.000000),(3084,77,0,1621,39.000000),(3085,82,0,1621,1.000000),(3086,77,0,1622,39.000000),(3087,82,0,1622,1.000000),(3088,77,0,1623,39.000000),(3089,82,0,1623,1.000000),(3090,77,0,1624,39.000000),(3091,82,0,1624,1.000000),(3092,77,0,1625,39.000000),(3093,82,0,1625,1.000000),(3094,77,0,1626,39.000000),(3095,77,0,1627,39.000000),(3096,82,0,1627,1.000000),(3097,77,0,1628,39.000000),(3098,82,0,1628,1.000000),(3099,77,0,1629,39.000000),(3100,82,0,1629,1.000000),(3101,77,0,1630,39.000000),(3102,82,0,1630,1.000000),(3103,77,0,1631,39.000000),(3104,82,0,1631,1.000000),(3105,77,0,1632,39.000000),(3106,82,0,1632,1.000000),(3107,77,0,1633,39.000000),(3108,82,0,1633,1.000000),(3109,77,0,1634,39.000000),(3110,82,0,1634,1.000000),(3111,77,0,1635,39.000000),(3112,82,0,1635,1.000000),(3113,77,0,1636,39.000000),(3114,82,0,1636,1.000000),(3115,77,0,1637,39.000000),(3116,82,0,1637,1.000000),(3117,77,0,1638,39.000000),(3118,82,0,1638,1.000000),(3119,77,0,1639,39.000000),(3120,82,0,1639,1.000000),(3121,77,0,1640,39.000000),(3122,82,0,1640,1.000000),(3123,77,0,1641,39.000000),(3124,82,0,1641,1.000000),(3125,77,0,1642,39.000000),(3126,77,0,1643,24.000000),(3127,82,0,1643,1.000000),(3128,77,0,1644,24.000000),(3129,82,0,1644,1.000000),(3130,77,0,1645,24.000000),(3131,82,0,1645,1.000000),(3132,77,0,1646,24.000000),(3133,82,0,1646,1.000000),(3134,77,0,1647,24.000000),(3135,82,0,1647,1.000000),(3136,77,0,1648,24.000000),(3137,82,0,1648,1.000000),(3138,77,0,1649,24.000000),(3139,82,0,1649,1.000000),(3140,77,0,1650,24.000000),(3141,82,0,1650,1.000000),(3142,77,0,1651,24.000000),(3143,82,0,1651,1.000000),(3144,77,0,1652,24.000000),(3145,82,0,1652,1.000000),(3146,77,0,1653,24.000000),(3147,82,0,1653,1.000000),(3148,77,0,1654,24.000000),(3149,82,0,1654,1.000000),(3150,77,0,1655,24.000000),(3151,82,0,1655,1.000000),(3152,77,0,1656,24.000000),(3153,82,0,1656,1.000000),(3154,77,0,1657,24.000000),(3155,82,0,1657,1.000000),(3156,77,0,1658,24.000000),(3157,77,0,1659,39.000000),(3158,82,0,1659,1.000000),(3159,77,0,1660,39.000000),(3160,82,0,1660,1.000000),(3161,77,0,1661,39.000000),(3162,82,0,1661,1.000000),(3163,77,0,1662,39.000000),(3164,82,0,1662,1.000000),(3165,77,0,1663,39.000000),(3166,82,0,1663,1.000000),(3167,77,0,1664,39.000000),(3168,82,0,1664,1.000000),(3169,77,0,1665,39.000000),(3170,82,0,1665,1.000000),(3171,77,0,1666,39.000000),(3172,82,0,1666,1.000000),(3173,77,0,1667,39.000000),(3174,82,0,1667,1.000000),(3175,77,0,1668,39.000000),(3176,82,0,1668,1.000000),(3177,77,0,1669,39.000000),(3178,82,0,1669,1.000000),(3179,77,0,1670,39.000000),(3180,82,0,1670,1.000000),(3181,77,0,1671,39.000000),(3182,82,0,1671,1.000000),(3183,77,0,1672,39.000000),(3184,82,0,1672,1.000000),(3185,77,0,1673,39.000000),(3186,82,0,1673,1.000000),(3187,77,0,1674,39.000000),(3188,77,0,1675,29.000000),(3189,82,0,1675,1.000000),(3190,77,0,1676,29.000000),(3191,82,0,1676,1.000000),(3192,77,0,1677,29.000000),(3193,82,0,1677,1.000000),(3194,77,0,1678,29.000000),(3195,82,0,1678,1.000000),(3196,77,0,1679,29.000000),(3197,82,0,1679,1.000000),(3198,77,0,1680,29.000000),(3199,82,0,1680,1.000000),(3200,77,0,1681,29.000000),(3201,82,0,1681,1.000000),(3202,77,0,1682,29.000000),(3203,82,0,1682,1.000000),(3204,77,0,1683,29.000000),(3205,82,0,1683,1.000000),(3206,77,0,1684,29.000000),(3207,82,0,1684,1.000000),(3208,77,0,1685,29.000000),(3209,82,0,1685,1.000000),(3210,77,0,1686,29.000000),(3211,82,0,1686,1.000000),(3212,77,0,1687,29.000000),(3213,82,0,1687,1.000000),(3214,77,0,1688,29.000000),(3215,82,0,1688,1.000000),(3216,77,0,1689,29.000000),(3217,82,0,1689,1.000000),(3218,77,0,1690,29.000000),(3219,77,0,1691,29.000000),(3220,82,0,1691,1.000000),(3221,77,0,1692,29.000000),(3222,82,0,1692,1.000000),(3223,77,0,1693,29.000000),(3224,82,0,1693,1.000000),(3225,77,0,1694,29.000000),(3226,82,0,1694,1.000000),(3227,77,0,1695,29.000000),(3228,82,0,1695,1.000000),(3229,77,0,1696,29.000000),(3230,82,0,1696,1.000000),(3231,77,0,1697,29.000000),(3232,82,0,1697,1.000000),(3233,77,0,1698,29.000000),(3234,82,0,1698,1.000000),(3235,77,0,1699,29.000000),(3236,82,0,1699,1.000000),(3237,77,0,1700,29.000000),(3238,82,0,1700,1.000000),(3239,77,0,1701,29.000000),(3240,82,0,1701,1.000000),(3241,77,0,1702,29.000000),(3242,82,0,1702,1.000000),(3243,77,0,1703,29.000000),(3244,82,0,1703,1.000000),(3245,77,0,1704,29.000000),(3246,82,0,1704,1.000000),(3247,77,0,1705,29.000000),(3248,82,0,1705,1.000000),(3249,77,0,1706,29.000000),(3250,77,0,1707,39.000000),(3251,82,0,1707,1.000000),(3252,77,0,1708,39.000000),(3253,82,0,1708,1.000000),(3254,77,0,1709,39.000000),(3255,82,0,1709,1.000000),(3256,77,0,1710,39.000000),(3257,82,0,1710,1.000000),(3258,77,0,1711,39.000000),(3259,82,0,1711,1.000000),(3260,77,0,1712,39.000000),(3261,82,0,1712,1.000000),(3262,77,0,1713,39.000000),(3263,82,0,1713,1.000000),(3264,77,0,1714,39.000000),(3265,82,0,1714,1.000000),(3266,77,0,1715,39.000000),(3267,82,0,1715,1.000000),(3268,77,0,1716,39.000000),(3269,82,0,1716,1.000000),(3270,77,0,1717,39.000000),(3271,82,0,1717,1.000000),(3272,77,0,1718,39.000000),(3273,82,0,1718,1.000000),(3274,77,0,1719,39.000000),(3275,82,0,1719,1.000000),(3276,77,0,1720,39.000000),(3277,82,0,1720,1.000000),(3278,77,0,1721,39.000000),(3279,82,0,1721,1.000000),(3280,77,0,1722,39.000000),(3281,77,0,1723,39.000000),(3282,82,0,1723,1.000000),(3283,77,0,1724,39.000000),(3284,82,0,1724,1.000000),(3285,77,0,1725,39.000000),(3286,82,0,1725,1.000000),(3287,77,0,1726,39.000000),(3288,82,0,1726,1.000000),(3289,77,0,1727,39.000000),(3290,82,0,1727,1.000000),(3291,77,0,1728,39.000000),(3292,82,0,1728,1.000000),(3293,77,0,1729,39.000000),(3294,82,0,1729,1.000000),(3295,77,0,1730,39.000000),(3296,82,0,1730,1.000000),(3297,77,0,1731,39.000000),(3298,82,0,1731,1.000000),(3299,77,0,1732,39.000000),(3300,82,0,1732,1.000000),(3301,77,0,1733,39.000000),(3302,82,0,1733,1.000000),(3303,77,0,1734,39.000000),(3304,82,0,1734,1.000000),(3305,77,0,1735,39.000000),(3306,82,0,1735,1.000000),(3307,77,0,1736,39.000000),(3308,82,0,1736,1.000000),(3309,77,0,1737,39.000000),(3310,82,0,1737,1.000000),(3311,77,0,1738,39.000000),(3312,77,0,1739,39.000000),(3313,82,0,1739,1.000000),(3314,77,0,1740,39.000000),(3315,82,0,1740,1.000000),(3316,77,0,1741,39.000000),(3317,82,0,1741,1.000000),(3318,77,0,1742,39.000000),(3319,82,0,1742,1.000000),(3320,77,0,1743,39.000000),(3321,82,0,1743,1.000000),(3322,77,0,1744,39.000000),(3323,82,0,1744,1.000000),(3324,77,0,1745,39.000000),(3325,82,0,1745,1.000000),(3326,77,0,1746,39.000000),(3327,82,0,1746,1.000000),(3328,77,0,1747,39.000000),(3329,82,0,1747,1.000000),(3330,77,0,1748,39.000000),(3331,82,0,1748,1.000000),(3332,77,0,1749,39.000000),(3333,82,0,1749,1.000000),(3334,77,0,1750,39.000000),(3335,82,0,1750,1.000000),(3336,77,0,1751,39.000000),(3337,82,0,1751,1.000000),(3338,77,0,1752,39.000000),(3339,82,0,1752,1.000000),(3340,77,0,1753,39.000000),(3341,82,0,1753,1.000000),(3342,77,0,1754,39.000000),(3343,77,0,1755,39.000000),(3344,82,0,1755,1.000000),(3345,77,0,1756,39.000000),(3346,82,0,1756,1.000000),(3347,77,0,1757,39.000000),(3348,82,0,1757,1.000000),(3349,77,0,1758,39.000000),(3350,82,0,1758,1.000000),(3351,77,0,1759,39.000000),(3352,82,0,1759,1.000000),(3353,77,0,1760,39.000000),(3354,82,0,1760,1.000000),(3355,77,0,1761,39.000000),(3356,82,0,1761,1.000000),(3357,77,0,1762,39.000000),(3358,82,0,1762,1.000000),(3359,77,0,1763,39.000000),(3360,82,0,1763,1.000000),(3361,77,0,1764,39.000000),(3362,82,0,1764,1.000000),(3363,77,0,1765,39.000000),(3364,82,0,1765,1.000000),(3365,77,0,1766,39.000000),(3366,82,0,1766,1.000000),(3367,77,0,1767,39.000000),(3368,82,0,1767,1.000000),(3369,77,0,1768,39.000000),(3370,82,0,1768,1.000000),(3371,77,0,1769,39.000000),(3372,82,0,1769,1.000000),(3373,77,0,1770,39.000000),(3374,77,0,1771,29.000000),(3375,82,0,1771,1.000000),(3376,77,0,1772,29.000000),(3377,82,0,1772,1.000000),(3378,77,0,1773,29.000000),(3379,82,0,1773,1.000000),(3380,77,0,1774,29.000000),(3381,82,0,1774,1.000000),(3382,77,0,1775,29.000000),(3383,82,0,1775,1.000000),(3384,77,0,1776,29.000000),(3385,82,0,1776,1.000000),(3386,77,0,1777,29.000000),(3387,82,0,1777,1.000000),(3388,77,0,1778,29.000000),(3389,82,0,1778,1.000000),(3390,77,0,1779,29.000000),(3391,82,0,1779,1.000000),(3392,77,0,1780,29.000000),(3393,82,0,1780,1.000000),(3394,77,0,1781,29.000000),(3395,82,0,1781,1.000000),(3396,77,0,1782,29.000000),(3397,82,0,1782,1.000000),(3398,77,0,1783,29.000000),(3399,82,0,1783,1.000000),(3400,77,0,1784,29.000000),(3401,82,0,1784,1.000000),(3402,77,0,1785,29.000000),(3403,82,0,1785,1.000000),(3404,77,0,1786,29.000000),(3405,77,0,1787,34.000000),(3406,82,0,1787,1.000000),(3407,77,0,1788,34.000000),(3408,82,0,1788,1.000000),(3409,77,0,1789,34.000000),(3410,82,0,1789,1.000000),(3411,77,0,1790,34.000000),(3412,82,0,1790,1.000000),(3413,77,0,1791,34.000000),(3414,82,0,1791,1.000000),(3415,77,0,1792,34.000000),(3416,82,0,1792,1.000000),(3417,77,0,1793,34.000000),(3418,82,0,1793,1.000000),(3419,77,0,1794,34.000000),(3420,82,0,1794,1.000000),(3421,77,0,1795,34.000000),(3422,82,0,1795,1.000000),(3423,77,0,1796,34.000000),(3424,82,0,1796,1.000000),(3425,77,0,1797,34.000000),(3426,82,0,1797,1.000000),(3427,77,0,1798,34.000000),(3428,82,0,1798,1.000000),(3429,77,0,1799,34.000000),(3430,82,0,1799,1.000000),(3431,77,0,1800,34.000000),(3432,82,0,1800,1.000000),(3433,77,0,1801,34.000000),(3434,82,0,1801,1.000000),(3435,77,0,1802,34.000000),(3436,77,0,1803,34.000000),(3437,82,0,1803,1.000000),(3438,77,0,1804,34.000000),(3439,82,0,1804,1.000000),(3440,77,0,1805,34.000000),(3441,82,0,1805,1.000000),(3442,77,0,1806,34.000000),(3443,82,0,1806,1.000000),(3444,77,0,1807,34.000000),(3445,82,0,1807,1.000000),(3446,77,0,1808,34.000000),(3447,82,0,1808,1.000000),(3448,77,0,1809,34.000000),(3449,82,0,1809,1.000000),(3450,77,0,1810,34.000000),(3451,82,0,1810,1.000000),(3452,77,0,1811,34.000000),(3453,82,0,1811,1.000000),(3454,77,0,1812,34.000000),(3455,82,0,1812,1.000000),(3456,77,0,1813,34.000000),(3457,82,0,1813,1.000000),(3458,77,0,1814,34.000000),(3459,82,0,1814,1.000000),(3460,77,0,1815,34.000000),(3461,82,0,1815,1.000000),(3462,77,0,1816,34.000000),(3463,82,0,1816,1.000000),(3464,77,0,1817,34.000000),(3465,82,0,1817,1.000000),(3466,77,0,1818,34.000000),(3467,77,0,1819,39.000000),(3468,82,0,1819,1.000000),(3469,77,0,1820,39.000000),(3470,82,0,1820,1.000000),(3471,77,0,1821,39.000000),(3472,82,0,1821,1.000000),(3473,77,0,1822,39.000000),(3474,82,0,1822,1.000000),(3475,77,0,1823,39.000000),(3476,82,0,1823,1.000000),(3477,77,0,1824,39.000000),(3478,82,0,1824,1.000000),(3479,77,0,1825,39.000000),(3480,77,0,1826,42.000000),(3481,82,0,1826,1.000000),(3482,77,0,1827,42.000000),(3483,82,0,1827,1.000000),(3484,77,0,1828,42.000000),(3485,82,0,1828,1.000000),(3486,77,0,1829,42.000000),(3487,82,0,1829,1.000000),(3488,77,0,1830,42.000000),(3489,82,0,1830,1.000000),(3490,77,0,1831,42.000000),(3491,82,0,1831,1.000000),(3492,77,0,1832,42.000000),(3493,77,0,1833,48.000000),(3494,82,0,1833,1.000000),(3495,77,0,1834,48.000000),(3496,82,0,1834,1.000000),(3497,77,0,1835,48.000000),(3498,82,0,1835,1.000000),(3499,77,0,1836,48.000000),(3500,82,0,1836,1.000000),(3501,77,0,1837,48.000000),(3502,82,0,1837,1.000000),(3503,77,0,1838,48.000000),(3504,82,0,1838,1.000000),(3505,77,0,1839,48.000000),(3506,77,0,1840,75.000000),(3507,82,0,1840,1.000000),(3508,77,0,1841,75.000000),(3509,82,0,1841,1.000000),(3510,77,0,1842,75.000000),(3511,82,0,1842,1.000000),(3512,77,0,1843,75.000000),(3513,82,0,1843,1.000000),(3514,77,0,1844,75.000000),(3515,82,0,1844,1.000000),(3516,77,0,1845,75.000000),(3517,82,0,1845,1.000000),(3518,77,0,1846,75.000000),(3519,77,0,1847,75.000000),(3520,82,0,1847,1.000000),(3521,77,0,1848,75.000000),(3522,82,0,1848,1.000000),(3523,77,0,1849,75.000000),(3524,82,0,1849,1.000000),(3525,77,0,1850,75.000000),(3526,82,0,1850,1.000000),(3527,77,0,1851,75.000000),(3528,82,0,1851,1.000000),(3529,77,0,1852,75.000000),(3530,82,0,1852,1.000000),(3531,77,0,1853,75.000000),(3532,77,0,1854,59.000000),(3533,82,0,1854,1.000000),(3534,77,0,1855,59.000000),(3535,82,0,1855,1.000000),(3536,77,0,1856,59.000000),(3537,82,0,1856,1.000000),(3538,77,0,1857,59.000000),(3539,82,0,1857,1.000000),(3540,77,0,1858,59.000000),(3541,82,0,1858,1.000000),(3542,77,0,1859,59.000000),(3543,82,0,1859,1.000000),(3544,77,0,1860,59.000000),(3545,77,0,1861,48.000000),(3546,82,0,1861,1.000000),(3547,77,0,1862,48.000000),(3548,82,0,1862,1.000000),(3549,77,0,1863,48.000000),(3550,82,0,1863,1.000000),(3551,77,0,1864,48.000000),(3552,82,0,1864,1.000000),(3553,77,0,1865,48.000000),(3554,82,0,1865,1.000000),(3555,77,0,1866,48.000000),(3556,82,0,1866,1.000000),(3557,77,0,1867,48.000000),(3558,77,0,1868,48.000000),(3559,82,0,1868,1.000000),(3560,77,0,1869,48.000000),(3561,82,0,1869,1.000000),(3562,77,0,1870,48.000000),(3563,82,0,1870,1.000000),(3564,77,0,1871,48.000000),(3565,82,0,1871,1.000000),(3566,77,0,1872,48.000000),(3567,82,0,1872,1.000000),(3568,77,0,1873,48.000000),(3569,82,0,1873,1.000000),(3570,77,0,1874,48.000000),(3571,77,0,1875,51.000000),(3572,82,0,1875,1.000000),(3573,77,0,1876,51.000000),(3574,82,0,1876,1.000000),(3575,77,0,1877,51.000000),(3576,82,0,1877,1.000000),(3577,77,0,1878,51.000000),(3578,82,0,1878,1.000000),(3579,77,0,1879,51.000000),(3580,82,0,1879,1.000000),(3581,77,0,1880,51.000000),(3582,82,0,1880,1.000000),(3583,77,0,1881,51.000000),(3584,77,0,1882,51.000000),(3585,82,0,1882,1.000000),(3586,77,0,1883,51.000000),(3587,82,0,1883,1.000000),(3588,77,0,1884,51.000000),(3589,82,0,1884,1.000000),(3590,77,0,1885,51.000000),(3591,82,0,1885,1.000000),(3592,77,0,1886,51.000000),(3593,82,0,1886,1.000000),(3594,77,0,1887,51.000000),(3595,82,0,1887,1.000000),(3596,77,0,1888,51.000000),(3597,77,0,1889,42.000000),(3598,82,0,1889,1.000000),(3599,77,0,1890,42.000000),(3600,82,0,1890,1.000000),(3601,77,0,1891,42.000000),(3602,82,0,1891,1.000000),(3603,77,0,1892,42.000000),(3604,82,0,1892,1.000000),(3605,77,0,1893,42.000000),(3606,82,0,1893,1.000000),(3607,77,0,1894,42.000000),(3608,82,0,1894,1.000000),(3609,77,0,1895,42.000000),(3610,77,0,1896,63.000000),(3611,82,0,1896,1.000000),(3612,77,0,1897,63.000000),(3613,82,0,1897,1.000000),(3614,77,0,1898,63.000000),(3615,82,0,1898,1.000000),(3616,77,0,1899,63.000000),(3617,82,0,1899,1.000000),(3618,77,0,1900,63.000000),(3619,82,0,1900,1.000000),(3620,77,0,1901,63.000000),(3621,82,0,1901,1.000000),(3622,77,0,1902,63.000000),(3623,77,0,1903,49.000000),(3624,82,0,1903,1.000000),(3625,77,0,1904,49.000000),(3626,82,0,1904,1.000000),(3627,77,0,1905,49.000000),(3628,82,0,1905,1.000000),(3629,77,0,1906,49.000000),(3630,82,0,1906,1.000000),(3631,77,0,1907,49.000000),(3632,82,0,1907,1.000000),(3633,77,0,1908,49.000000),(3634,82,0,1908,1.000000),(3635,77,0,1909,49.000000),(3636,77,0,1910,29.000000),(3637,82,0,1910,1.000000),(3638,77,0,1911,29.000000),(3639,82,0,1911,1.000000),(3640,77,0,1912,29.000000),(3641,82,0,1912,1.000000),(3642,77,0,1913,29.000000),(3643,82,0,1913,1.000000),(3644,77,0,1914,29.000000),(3645,82,0,1914,1.000000),(3646,77,0,1915,29.000000),(3647,82,0,1915,1.000000),(3648,77,0,1916,29.000000),(3649,82,0,1916,1.000000),(3650,77,0,1917,29.000000),(3651,82,0,1917,1.000000),(3652,77,0,1918,29.000000),(3653,82,0,1918,1.000000),(3654,77,0,1919,29.000000),(3655,82,0,1919,1.000000),(3656,77,0,1920,29.000000),(3657,82,0,1920,1.000000),(3658,77,0,1921,29.000000),(3659,82,0,1921,1.000000),(3660,77,0,1922,29.000000),(3661,82,0,1922,1.000000),(3662,77,0,1923,29.000000),(3663,82,0,1923,1.000000),(3664,77,0,1924,29.000000),(3665,82,0,1924,1.000000),(3666,77,0,1925,29.000000),(3667,77,0,1926,28.000000),(3668,82,0,1926,1.000000),(3669,77,0,1927,28.000000),(3670,82,0,1927,1.000000),(3671,77,0,1928,28.000000),(3672,82,0,1928,1.000000),(3673,77,0,1929,28.000000),(3674,82,0,1929,1.000000),(3675,77,0,1930,28.000000),(3676,82,0,1930,1.000000),(3677,77,0,1931,28.000000),(3678,82,0,1931,1.000000),(3679,77,0,1932,28.000000),(3680,82,0,1932,1.000000),(3681,77,0,1933,28.000000),(3682,82,0,1933,1.000000),(3683,77,0,1934,28.000000),(3684,82,0,1934,1.000000),(3685,77,0,1935,28.000000),(3686,82,0,1935,1.000000),(3687,77,0,1936,28.000000),(3688,82,0,1936,1.000000),(3689,77,0,1937,28.000000),(3690,82,0,1937,1.000000),(3691,77,0,1938,28.000000),(3692,82,0,1938,1.000000),(3693,77,0,1939,28.000000),(3694,82,0,1939,1.000000),(3695,77,0,1940,28.000000),(3696,82,0,1940,1.000000),(3697,77,0,1941,28.000000),(3698,77,0,1942,50.000000),(3699,82,0,1942,1.000000),(3700,77,0,1943,50.000000),(3701,82,0,1943,1.000000),(3702,77,0,1944,50.000000),(3703,82,0,1944,1.000000),(3704,77,0,1945,50.000000),(3705,82,0,1945,1.000000),(3706,77,0,1946,50.000000),(3707,82,0,1946,1.000000),(3708,77,0,1947,50.000000),(3709,82,0,1947,1.000000),(3710,77,0,1948,50.000000),(3711,82,0,1948,1.000000),(3712,77,0,1949,50.000000),(3713,82,0,1949,1.000000),(3714,77,0,1950,50.000000),(3715,82,0,1950,1.000000),(3716,77,0,1951,50.000000),(3717,82,0,1951,1.000000),(3718,77,0,1952,50.000000),(3719,82,0,1952,1.000000),(3720,77,0,1953,50.000000),(3721,82,0,1953,1.000000),(3722,77,0,1954,50.000000),(3723,82,0,1954,1.000000),(3724,77,0,1955,50.000000),(3725,82,0,1955,1.000000),(3726,77,0,1956,50.000000),(3727,82,0,1956,1.000000),(3728,77,0,1957,50.000000),(3729,77,0,1958,45.000000),(3730,82,0,1958,1.000000),(3731,77,0,1959,45.000000),(3732,82,0,1959,1.000000),(3733,77,0,1960,45.000000),(3734,82,0,1960,1.000000),(3735,77,0,1961,45.000000),(3736,82,0,1961,1.000000),(3737,77,0,1962,45.000000),(3738,82,0,1962,1.000000),(3739,77,0,1963,45.000000),(3740,82,0,1963,1.000000),(3741,77,0,1964,45.000000),(3742,82,0,1964,1.000000),(3743,77,0,1965,45.000000),(3744,82,0,1965,1.000000),(3745,77,0,1966,45.000000),(3746,82,0,1966,1.000000),(3747,77,0,1967,45.000000),(3748,82,0,1967,1.000000),(3749,77,0,1968,45.000000),(3750,82,0,1968,1.000000),(3751,77,0,1969,45.000000),(3752,82,0,1969,1.000000),(3753,77,0,1970,45.000000),(3754,82,0,1970,1.000000),(3755,77,0,1971,45.000000),(3756,82,0,1971,1.000000),(3757,77,0,1972,45.000000),(3758,82,0,1972,1.000000),(3759,77,0,1973,45.000000),(3760,77,0,1974,28.000000),(3761,82,0,1974,1.000000),(3762,77,0,1975,28.000000),(3763,82,0,1975,1.000000),(3764,77,0,1976,28.000000),(3765,82,0,1976,1.000000),(3766,77,0,1977,28.000000),(3767,82,0,1977,1.000000),(3768,77,0,1978,28.000000),(3769,82,0,1978,1.000000),(3770,77,0,1979,28.000000),(3771,82,0,1979,1.000000),(3772,77,0,1980,28.000000),(3773,82,0,1980,1.000000),(3774,77,0,1981,28.000000),(3775,82,0,1981,1.000000),(3776,77,0,1982,28.000000),(3777,82,0,1982,1.000000),(3778,77,0,1983,28.000000),(3779,82,0,1983,1.000000),(3780,77,0,1984,28.000000),(3781,82,0,1984,1.000000),(3782,77,0,1985,28.000000),(3783,82,0,1985,1.000000),(3784,77,0,1986,28.000000),(3785,82,0,1986,1.000000),(3786,77,0,1987,28.000000),(3787,82,0,1987,1.000000),(3788,77,0,1988,28.000000),(3789,82,0,1988,1.000000),(3790,77,0,1989,28.000000),(3791,77,0,1990,42.000000),(3792,82,0,1990,1.000000),(3793,77,0,1991,42.000000),(3794,82,0,1991,1.000000),(3795,77,0,1992,42.000000),(3796,82,0,1992,1.000000),(3797,77,0,1993,42.000000),(3798,82,0,1993,1.000000),(3799,77,0,1994,42.000000),(3800,82,0,1994,1.000000),(3801,77,0,1995,42.000000),(3802,82,0,1995,1.000000),(3803,77,0,1996,42.000000),(3804,77,0,1997,24.000000),(3805,82,0,1997,1.000000),(3806,77,0,1998,24.000000),(3807,82,0,1998,1.000000),(3808,77,0,1999,24.000000),(3809,82,0,1999,1.000000),(3810,77,0,2000,24.000000),(3811,82,0,2000,1.000000),(3812,77,0,2001,24.000000),(3813,82,0,2001,1.000000),(3814,77,0,2002,24.000000),(3815,82,0,2002,1.000000),(3816,77,0,2003,24.000000),(3817,77,0,2004,44.000000),(3818,82,0,2004,1.000000),(3819,77,0,2005,44.000000),(3820,82,0,2005,1.000000),(3821,77,0,2006,44.000000),(3822,82,0,2006,1.000000),(3823,77,0,2007,44.000000),(3824,82,0,2007,1.000000),(3825,77,0,2008,44.000000),(3826,82,0,2008,1.000000),(3827,77,0,2009,44.000000),(3828,77,0,2010,44.000000),(3829,82,0,2010,1.000000),(3830,77,0,2011,44.000000),(3831,82,0,2011,1.000000),(3832,77,0,2012,44.000000),(3833,82,0,2012,1.000000),(3834,77,0,2013,44.000000),(3835,82,0,2013,1.000000),(3836,77,0,2014,44.000000),(3837,82,0,2014,1.000000),(3838,77,0,2015,44.000000),(3839,82,0,2015,1.000000),(3840,77,0,2016,44.000000),(3841,77,0,2017,40.000000),(3842,82,0,2017,1.000000),(3843,77,0,2018,40.000000),(3844,82,0,2018,1.000000),(3845,77,0,2019,40.000000),(3846,82,0,2019,1.000000),(3847,77,0,2020,40.000000),(3848,82,0,2020,1.000000),(3849,77,0,2021,40.000000),(3850,82,0,2021,1.000000),(3851,77,0,2022,40.000000),(3852,82,0,2022,1.000000),(3853,77,0,2023,40.000000),(3854,77,0,2024,49.000000),(3855,82,0,2024,1.000000),(3856,77,0,2025,49.000000),(3857,82,0,2025,1.000000),(3858,77,0,2026,49.000000),(3859,82,0,2026,1.000000),(3860,77,0,2027,49.000000),(3861,82,0,2027,1.000000),(3862,77,0,2028,49.000000),(3863,82,0,2028,1.000000),(3864,77,0,2029,49.000000),(3865,82,0,2029,1.000000),(3866,77,0,2030,49.000000),(3867,77,0,2031,45.000000),(3868,82,0,2031,1.000000),(3869,77,0,2032,45.000000),(3870,82,0,2032,1.000000),(3871,77,0,2033,45.000000),(3872,82,0,2033,1.000000),(3873,77,0,2034,45.000000),(3874,82,0,2034,1.000000),(3875,77,0,2035,45.000000),(3876,82,0,2035,1.000000),(3877,77,0,2036,45.000000),(3878,82,0,2036,1.000000),(3879,77,0,2037,45.000000),(3880,82,0,2037,1.000000),(3881,77,0,2038,45.000000),(3882,82,0,2038,1.000000),(3883,77,0,2039,45.000000),(3884,82,0,2039,1.000000),(3885,77,0,2040,45.000000),(3886,82,0,2040,1.000000),(3887,77,0,2041,45.000000),(3888,82,0,2041,1.000000),(3889,77,0,2042,45.000000),(3890,82,0,2042,1.000000),(3891,77,0,2043,45.000000),(3892,82,0,2043,1.000000),(3893,77,0,2044,45.000000),(3894,82,0,2044,1.000000),(3895,77,0,2045,45.000000),(3896,82,0,2045,1.000000),(3897,77,0,2046,45.000000),(3898,119,0,1226,79.990000),(3899,119,0,1242,59.990000),(3900,119,0,1258,59.990000),(3901,119,0,1274,89.990000),(3902,119,0,1290,62.990000),(3903,119,0,1386,79.990000),(3904,119,0,1306,62.990000),(3905,119,0,1322,59.990000),(3906,119,0,1338,34.990000),(3907,119,0,1354,72.990000),(3908,119,0,1370,72.990000),(3909,119,0,1402,79.990000);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_gallery`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_gallery` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CAT_PRD_ENTT_GLR_ENTT_ID_ATTR_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_GLR_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_GLR_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Gallery Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_gallery`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_gallery` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_gallery` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_int`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_int`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_int` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int(11) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_INT_STORE_ID` (`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE_ID_STORE_ID_VALUE` (`attribute_id`,`store_id`,`value`),
  CONSTRAINT `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_INT_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_INT_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_INT_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12660 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Integer Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_int`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_int` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_int` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_int` VALUES (1,97,0,1,1),(2,99,0,1,4),(3,97,0,2,1),(4,99,0,2,4),(5,134,0,2,2),(6,146,0,2,1),(7,148,0,2,1),(8,97,0,3,1),(9,99,0,3,4),(10,134,0,3,2),(11,97,0,4,1),(12,99,0,4,4),(13,134,0,4,2),(14,147,0,4,1),(15,97,0,5,1),(16,99,0,5,4),(17,134,0,5,2),(18,147,0,5,1),(19,97,0,6,1),(20,99,0,6,4),(21,134,0,6,2),(22,97,0,7,1),(23,99,0,7,4),(24,134,0,7,2),(25,97,0,8,1),(26,99,0,8,4),(27,134,0,8,2),(28,97,0,9,1),(29,99,0,9,4),(30,134,0,9,2),(31,97,0,10,1),(32,99,0,10,4),(33,134,0,10,2),(34,146,0,10,1),(35,148,0,10,1),(36,97,0,11,1),(37,99,0,11,4),(38,134,0,11,2),(39,146,0,11,1),(40,148,0,11,1),(41,97,0,12,1),(42,99,0,12,4),(43,134,0,12,2),(44,97,0,13,1),(45,99,0,13,4),(46,134,0,13,2),(47,147,0,13,1),(48,97,0,14,1),(49,99,0,14,4),(50,134,0,14,2),(51,145,0,14,1),(52,97,0,15,1),(53,99,0,15,4),(54,134,0,15,2),(55,97,0,16,1),(56,99,0,16,4),(57,134,0,16,2),(58,146,0,16,1),(59,148,0,16,1),(60,97,0,17,1),(61,99,0,17,4),(62,134,0,17,2),(63,97,0,18,1),(64,99,0,18,4),(65,134,0,18,2),(66,97,0,19,1),(67,99,0,19,4),(68,134,0,19,2),(69,146,0,19,1),(70,147,0,19,1),(71,97,0,20,1),(72,99,0,20,4),(73,134,0,20,2),(74,97,0,21,1),(75,99,0,21,4),(76,134,0,21,2),(77,97,0,22,1),(78,99,0,22,4),(79,134,0,22,2),(80,97,0,23,1),(81,99,0,23,4),(82,134,0,23,2),(83,93,0,24,52),(84,97,0,24,1),(85,99,0,24,1),(86,134,0,24,2),(87,143,0,24,91),(88,93,0,25,58),(89,97,0,25,1),(90,99,0,25,1),(91,134,0,25,2),(92,143,0,25,91),(93,93,0,26,50),(94,97,0,26,1),(95,99,0,26,1),(96,134,0,26,2),(97,143,0,26,91),(98,93,0,27,52),(99,97,0,27,1),(100,99,0,27,1),(101,134,0,27,2),(102,143,0,27,92),(103,93,0,28,58),(104,97,0,28,1),(105,99,0,28,1),(106,134,0,28,2),(107,143,0,28,92),(108,93,0,29,50),(109,97,0,29,1),(110,99,0,29,1),(111,134,0,29,2),(112,143,0,29,92),(113,93,0,30,52),(114,97,0,30,1),(115,99,0,30,1),(116,134,0,30,2),(117,143,0,30,93),(118,93,0,31,58),(119,97,0,31,1),(120,99,0,31,1),(121,134,0,31,2),(122,143,0,31,93),(123,93,0,32,50),(124,97,0,32,1),(125,99,0,32,1),(126,134,0,32,2),(127,143,0,32,93),(128,97,0,33,1),(129,99,0,33,1),(130,134,0,33,2),(131,143,0,33,94),(132,97,0,34,1),(133,99,0,34,1),(134,134,0,34,2),(135,143,0,34,95),(136,97,0,35,1),(137,99,0,35,1),(138,134,0,35,2),(139,143,0,35,96),(140,97,0,36,1),(141,99,0,36,4),(142,134,0,36,2),(143,97,0,37,1),(144,99,0,37,4),(145,134,0,37,2),(146,97,0,38,1),(147,99,0,38,4),(148,134,0,38,2),(149,147,0,38,1),(150,97,0,39,1),(151,99,0,39,4),(152,134,0,39,2),(153,147,0,39,1),(154,97,0,40,1),(155,99,0,40,4),(156,134,0,40,2),(157,147,0,40,1),(158,97,0,41,1),(159,99,0,41,4),(160,134,0,41,2),(161,148,0,41,1),(162,97,0,42,1),(163,99,0,42,4),(164,134,0,42,2),(165,148,0,42,1),(166,97,0,43,1),(167,99,0,43,4),(168,134,0,43,2),(169,97,0,44,1),(170,99,0,44,4),(171,134,0,44,2),(172,147,0,44,1),(173,97,0,45,1),(174,99,0,45,4),(175,97,0,46,1),(176,99,0,46,4),(177,121,0,46,0),(178,122,0,46,0),(179,123,0,46,0),(180,124,0,46,0),(181,125,0,46,0),(182,134,0,46,2),(183,97,0,47,1),(184,99,0,47,4),(185,115,0,47,1),(186,130,0,47,0),(187,134,0,47,2),(188,149,0,47,102),(189,97,0,48,1),(190,99,0,48,4),(191,115,0,48,1),(192,130,0,48,0),(193,134,0,48,2),(194,149,0,48,102),(195,97,0,49,1),(196,99,0,49,4),(197,115,0,49,1),(198,130,0,49,0),(199,134,0,49,2),(200,149,0,49,102),(201,97,0,50,1),(202,99,0,50,4),(203,115,0,50,1),(204,130,0,50,0),(205,134,0,50,2),(206,149,0,50,102),(207,97,0,51,1),(208,99,0,51,4),(209,115,0,51,1),(210,130,0,51,0),(211,134,0,51,2),(212,149,0,51,102),(213,97,0,52,1),(214,99,0,52,4),(215,115,0,52,1),(216,130,0,52,1),(217,134,0,52,2),(218,149,0,52,102),(219,97,0,53,1),(220,134,0,53,2),(221,115,0,53,1),(222,99,0,53,1),(223,93,0,53,49),(224,143,0,53,166),(225,97,0,54,1),(226,134,0,54,2),(227,115,0,54,1),(228,99,0,54,1),(229,93,0,54,52),(230,143,0,54,166),(231,97,0,55,1),(232,134,0,55,2),(233,115,0,55,1),(234,99,0,55,1),(235,93,0,55,56),(236,143,0,55,166),(237,97,0,56,1),(238,134,0,56,2),(239,115,0,56,1),(240,99,0,56,1),(241,93,0,56,49),(242,143,0,56,167),(243,97,0,57,1),(244,134,0,57,2),(245,115,0,57,1),(246,99,0,57,1),(247,93,0,57,52),(248,143,0,57,167),(249,97,0,58,1),(250,134,0,58,2),(251,115,0,58,1),(252,99,0,58,1),(253,93,0,58,56),(254,143,0,58,167),(255,97,0,59,1),(256,134,0,59,2),(257,115,0,59,1),(258,99,0,59,1),(259,93,0,59,49),(260,143,0,59,168),(261,97,0,60,1),(262,134,0,60,2),(263,115,0,60,1),(264,99,0,60,1),(265,93,0,60,52),(266,143,0,60,168),(267,97,0,61,1),(268,134,0,61,2),(269,115,0,61,1),(270,99,0,61,1),(271,93,0,61,56),(272,143,0,61,168),(273,97,0,62,1),(274,134,0,62,2),(275,115,0,62,1),(276,99,0,62,1),(277,93,0,62,49),(278,143,0,62,169),(279,97,0,63,1),(280,134,0,63,2),(281,115,0,63,1),(282,99,0,63,1),(283,93,0,63,52),(284,143,0,63,169),(285,97,0,64,1),(286,134,0,64,2),(287,115,0,64,1),(288,99,0,64,1),(289,93,0,64,56),(290,143,0,64,169),(291,97,0,65,1),(292,134,0,65,2),(293,115,0,65,1),(294,99,0,65,1),(295,93,0,65,49),(296,143,0,65,170),(297,97,0,66,1),(298,134,0,66,2),(299,115,0,66,1),(300,99,0,66,1),(301,93,0,66,52),(302,143,0,66,170),(303,97,0,67,1),(304,134,0,67,2),(305,115,0,67,1),(306,99,0,67,1),(307,93,0,67,56),(308,143,0,67,170),(309,97,0,68,1),(310,134,0,68,2),(311,115,0,68,1),(312,99,0,68,4),(313,144,0,68,1),(314,145,0,68,0),(315,146,0,68,0),(316,147,0,68,0),(317,148,0,68,1),(318,97,0,69,1),(319,134,0,69,2),(320,115,0,69,1),(321,99,0,69,1),(322,93,0,69,49),(323,143,0,69,166),(324,97,0,70,1),(325,134,0,70,2),(326,115,0,70,1),(327,99,0,70,1),(328,93,0,70,57),(329,143,0,70,166),(330,97,0,71,1),(331,134,0,71,2),(332,115,0,71,1),(333,99,0,71,1),(334,93,0,71,58),(335,143,0,71,166),(336,97,0,72,1),(337,134,0,72,2),(338,115,0,72,1),(339,99,0,72,1),(340,93,0,72,49),(341,143,0,72,167),(342,97,0,73,1),(343,134,0,73,2),(344,115,0,73,1),(345,99,0,73,1),(346,93,0,73,57),(347,143,0,73,167),(348,97,0,74,1),(349,134,0,74,2),(350,115,0,74,1),(351,99,0,74,1),(352,93,0,74,58),(353,143,0,74,167),(354,97,0,75,1),(355,134,0,75,2),(356,115,0,75,1),(357,99,0,75,1),(358,93,0,75,49),(359,143,0,75,168),(360,97,0,76,1),(361,134,0,76,2),(362,115,0,76,1),(363,99,0,76,1),(364,93,0,76,57),(365,143,0,76,168),(366,97,0,77,1),(367,134,0,77,2),(368,115,0,77,1),(369,99,0,77,1),(370,93,0,77,58),(371,143,0,77,168),(372,97,0,78,1),(373,134,0,78,2),(374,115,0,78,1),(375,99,0,78,1),(376,93,0,78,49),(377,143,0,78,169),(378,97,0,79,1),(379,134,0,79,2),(380,115,0,79,1),(381,99,0,79,1),(382,93,0,79,57),(383,143,0,79,169),(384,97,0,80,1),(385,134,0,80,2),(386,115,0,80,1),(387,99,0,80,1),(388,93,0,80,58),(389,143,0,80,169),(390,97,0,81,1),(391,134,0,81,2),(392,115,0,81,1),(393,99,0,81,1),(394,93,0,81,49),(395,143,0,81,170),(396,97,0,82,1),(397,134,0,82,2),(398,115,0,82,1),(399,99,0,82,1),(400,93,0,82,57),(401,143,0,82,170),(402,97,0,83,1),(403,134,0,83,2),(404,115,0,83,1),(405,99,0,83,1),(406,93,0,83,58),(407,143,0,83,170),(408,97,0,84,1),(409,134,0,84,2),(410,115,0,84,1),(411,99,0,84,4),(412,144,0,84,0),(413,145,0,84,0),(414,146,0,84,0),(415,147,0,84,1),(416,148,0,84,0),(417,97,0,85,1),(418,134,0,85,2),(419,115,0,85,1),(420,99,0,85,1),(421,93,0,85,49),(422,143,0,85,166),(423,97,0,86,1),(424,134,0,86,2),(425,115,0,86,1),(426,99,0,86,1),(427,93,0,86,50),(428,143,0,86,166),(429,97,0,87,1),(430,134,0,87,2),(431,115,0,87,1),(432,99,0,87,1),(433,93,0,87,53),(434,143,0,87,166),(435,97,0,88,1),(436,134,0,88,2),(437,115,0,88,1),(438,99,0,88,1),(439,93,0,88,49),(440,143,0,88,167),(441,97,0,89,1),(442,134,0,89,2),(443,115,0,89,1),(444,99,0,89,1),(445,93,0,89,50),(446,143,0,89,167),(447,97,0,90,1),(448,134,0,90,2),(449,115,0,90,1),(450,99,0,90,1),(451,93,0,90,53),(452,143,0,90,167),(453,97,0,91,1),(454,134,0,91,2),(455,115,0,91,1),(456,99,0,91,1),(457,93,0,91,49),(458,143,0,91,168),(459,97,0,92,1),(460,134,0,92,2),(461,115,0,92,1),(462,99,0,92,1),(463,93,0,92,50),(464,143,0,92,168),(465,97,0,93,1),(466,134,0,93,2),(467,115,0,93,1),(468,99,0,93,1),(469,93,0,93,53),(470,143,0,93,168),(471,97,0,94,1),(472,134,0,94,2),(473,115,0,94,1),(474,99,0,94,1),(475,93,0,94,49),(476,143,0,94,169),(477,97,0,95,1),(478,134,0,95,2),(479,115,0,95,1),(480,99,0,95,1),(481,93,0,95,50),(482,143,0,95,169),(483,97,0,96,1),(484,134,0,96,2),(485,115,0,96,1),(486,99,0,96,1),(487,93,0,96,53),(488,143,0,96,169),(489,97,0,97,1),(490,134,0,97,2),(491,115,0,97,1),(492,99,0,97,1),(493,93,0,97,49),(494,143,0,97,170),(495,97,0,98,1),(496,134,0,98,2),(497,115,0,98,1),(498,99,0,98,1),(499,93,0,98,50),(500,143,0,98,170),(501,97,0,99,1),(502,134,0,99,2),(503,115,0,99,1),(504,99,0,99,1),(505,93,0,99,53),(506,143,0,99,170),(507,97,0,100,1),(508,134,0,100,2),(509,115,0,100,1),(510,99,0,100,4),(511,144,0,100,1),(512,145,0,100,0),(513,146,0,100,1),(514,147,0,100,1),(515,148,0,100,0),(516,97,0,101,1),(517,134,0,101,2),(518,115,0,101,1),(519,99,0,101,1),(520,93,0,101,53),(521,143,0,101,166),(522,97,0,102,1),(523,134,0,102,2),(524,115,0,102,1),(525,99,0,102,1),(526,93,0,102,59),(527,143,0,102,166),(528,97,0,103,1),(529,134,0,103,2),(530,115,0,103,1),(531,99,0,103,1),(532,93,0,103,60),(533,143,0,103,166),(534,97,0,104,1),(535,134,0,104,2),(536,115,0,104,1),(537,99,0,104,1),(538,93,0,104,53),(539,143,0,104,167),(540,97,0,105,1),(541,134,0,105,2),(542,115,0,105,1),(543,99,0,105,1),(544,93,0,105,59),(545,143,0,105,167),(546,97,0,106,1),(547,134,0,106,2),(548,115,0,106,1),(549,99,0,106,1),(550,93,0,106,60),(551,143,0,106,167),(552,97,0,107,1),(553,134,0,107,2),(554,115,0,107,1),(555,99,0,107,1),(556,93,0,107,53),(557,143,0,107,168),(558,97,0,108,1),(559,134,0,108,2),(560,115,0,108,1),(561,99,0,108,1),(562,93,0,108,59),(563,143,0,108,168),(564,97,0,109,1),(565,134,0,109,2),(566,115,0,109,1),(567,99,0,109,1),(568,93,0,109,60),(569,143,0,109,168),(570,97,0,110,1),(571,134,0,110,2),(572,115,0,110,1),(573,99,0,110,1),(574,93,0,110,53),(575,143,0,110,169),(576,97,0,111,1),(577,134,0,111,2),(578,115,0,111,1),(579,99,0,111,1),(580,93,0,111,59),(581,143,0,111,169),(582,97,0,112,1),(583,134,0,112,2),(584,115,0,112,1),(585,99,0,112,1),(586,93,0,112,60),(587,143,0,112,169),(588,97,0,113,1),(589,134,0,113,2),(590,115,0,113,1),(591,99,0,113,1),(592,93,0,113,53),(593,143,0,113,170),(594,97,0,114,1),(595,134,0,114,2),(596,115,0,114,1),(597,99,0,114,1),(598,93,0,114,59),(599,143,0,114,170),(600,97,0,115,1),(601,134,0,115,2),(602,115,0,115,1),(603,99,0,115,1),(604,93,0,115,60),(605,143,0,115,170),(606,97,0,116,1),(607,134,0,116,2),(608,115,0,116,1),(609,99,0,116,4),(610,144,0,116,1),(611,145,0,116,1),(612,146,0,116,0),(613,147,0,116,0),(614,148,0,116,1),(615,97,0,117,1),(616,134,0,117,2),(617,115,0,117,1),(618,99,0,117,1),(619,93,0,117,53),(620,143,0,117,166),(621,97,0,118,1),(622,134,0,118,2),(623,115,0,118,1),(624,99,0,118,1),(625,93,0,118,58),(626,143,0,118,166),(627,97,0,119,1),(628,134,0,119,2),(629,115,0,119,1),(630,99,0,119,1),(631,93,0,119,59),(632,143,0,119,166),(633,97,0,120,1),(634,134,0,120,2),(635,115,0,120,1),(636,99,0,120,1),(637,93,0,120,53),(638,143,0,120,167),(639,97,0,121,1),(640,134,0,121,2),(641,115,0,121,1),(642,99,0,121,1),(643,93,0,121,58),(644,143,0,121,167),(645,97,0,122,1),(646,134,0,122,2),(647,115,0,122,1),(648,99,0,122,1),(649,93,0,122,59),(650,143,0,122,167),(651,97,0,123,1),(652,134,0,123,2),(653,115,0,123,1),(654,99,0,123,1),(655,93,0,123,53),(656,143,0,123,168),(657,97,0,124,1),(658,134,0,124,2),(659,115,0,124,1),(660,99,0,124,1),(661,93,0,124,58),(662,143,0,124,168),(663,97,0,125,1),(664,134,0,125,2),(665,115,0,125,1),(666,99,0,125,1),(667,93,0,125,59),(668,143,0,125,168),(669,97,0,126,1),(670,134,0,126,2),(671,115,0,126,1),(672,99,0,126,1),(673,93,0,126,53),(674,143,0,126,169),(675,97,0,127,1),(676,134,0,127,2),(677,115,0,127,1),(678,99,0,127,1),(679,93,0,127,58),(680,143,0,127,169),(681,97,0,128,1),(682,134,0,128,2),(683,115,0,128,1),(684,99,0,128,1),(685,93,0,128,59),(686,143,0,128,169),(687,97,0,129,1),(688,134,0,129,2),(689,115,0,129,1),(690,99,0,129,1),(691,93,0,129,53),(692,143,0,129,170),(693,97,0,130,1),(694,134,0,130,2),(695,115,0,130,1),(696,99,0,130,1),(697,93,0,130,58),(698,143,0,130,170),(699,97,0,131,1),(700,134,0,131,2),(701,115,0,131,1),(702,99,0,131,1),(703,93,0,131,59),(704,143,0,131,170),(705,97,0,132,1),(706,134,0,132,2),(707,115,0,132,1),(708,99,0,132,4),(709,144,0,132,0),(710,145,0,132,0),(711,146,0,132,0),(712,147,0,132,0),(713,148,0,132,0),(714,97,0,133,1),(715,134,0,133,2),(716,115,0,133,1),(717,99,0,133,1),(718,93,0,133,49),(719,143,0,133,166),(720,97,0,134,1),(721,134,0,134,2),(722,115,0,134,1),(723,99,0,134,1),(724,93,0,134,50),(725,143,0,134,166),(726,97,0,135,1),(727,134,0,135,2),(728,115,0,135,1),(729,99,0,135,1),(730,93,0,135,57),(731,143,0,135,166),(732,97,0,136,1),(733,134,0,136,2),(734,115,0,136,1),(735,99,0,136,1),(736,93,0,136,49),(737,143,0,136,167),(738,97,0,137,1),(739,134,0,137,2),(740,115,0,137,1),(741,99,0,137,1),(742,93,0,137,50),(743,143,0,137,167),(744,97,0,138,1),(745,134,0,138,2),(746,115,0,138,1),(747,99,0,138,1),(748,93,0,138,57),(749,143,0,138,167),(750,97,0,139,1),(751,134,0,139,2),(752,115,0,139,1),(753,99,0,139,1),(754,93,0,139,49),(755,143,0,139,168),(756,97,0,140,1),(757,134,0,140,2),(758,115,0,140,1),(759,99,0,140,1),(760,93,0,140,50),(761,143,0,140,168),(762,97,0,141,1),(763,134,0,141,2),(764,115,0,141,1),(765,99,0,141,1),(766,93,0,141,57),(767,143,0,141,168),(768,97,0,142,1),(769,134,0,142,2),(770,115,0,142,1),(771,99,0,142,1),(772,93,0,142,49),(773,143,0,142,169),(774,97,0,143,1),(775,134,0,143,2),(776,115,0,143,1),(777,99,0,143,1),(778,93,0,143,50),(779,143,0,143,169),(780,97,0,144,1),(781,134,0,144,2),(782,115,0,144,1),(783,99,0,144,1),(784,93,0,144,57),(785,143,0,144,169),(786,97,0,145,1),(787,134,0,145,2),(788,115,0,145,1),(789,99,0,145,1),(790,93,0,145,49),(791,143,0,145,170),(792,97,0,146,1),(793,134,0,146,2),(794,115,0,146,1),(795,99,0,146,1),(796,93,0,146,50),(797,143,0,146,170),(798,97,0,147,1),(799,134,0,147,2),(800,115,0,147,1),(801,99,0,147,1),(802,93,0,147,57),(803,143,0,147,170),(804,97,0,148,1),(805,134,0,148,2),(806,115,0,148,1),(807,99,0,148,4),(808,144,0,148,0),(809,145,0,148,0),(810,146,0,148,0),(811,147,0,148,0),(812,148,0,148,0),(813,97,0,149,1),(814,134,0,149,2),(815,115,0,149,1),(816,99,0,149,1),(817,93,0,149,49),(818,143,0,149,166),(819,97,0,150,1),(820,134,0,150,2),(821,115,0,150,1),(822,99,0,150,1),(823,93,0,150,52),(824,143,0,150,166),(825,97,0,151,1),(826,134,0,151,2),(827,115,0,151,1),(828,99,0,151,1),(829,93,0,151,53),(830,143,0,151,166),(831,97,0,152,1),(832,134,0,152,2),(833,115,0,152,1),(834,99,0,152,1),(835,93,0,152,49),(836,143,0,152,167),(837,97,0,153,1),(838,134,0,153,2),(839,115,0,153,1),(840,99,0,153,1),(841,93,0,153,52),(842,143,0,153,167),(843,97,0,154,1),(844,134,0,154,2),(845,115,0,154,1),(846,99,0,154,1),(847,93,0,154,53),(848,143,0,154,167),(849,97,0,155,1),(850,134,0,155,2),(851,115,0,155,1),(852,99,0,155,1),(853,93,0,155,49),(854,143,0,155,168),(855,97,0,156,1),(856,134,0,156,2),(857,115,0,156,1),(858,99,0,156,1),(859,93,0,156,52),(860,143,0,156,168),(861,97,0,157,1),(862,134,0,157,2),(863,115,0,157,1),(864,99,0,157,1),(865,93,0,157,53),(866,143,0,157,168),(867,97,0,158,1),(868,134,0,158,2),(869,115,0,158,1),(870,99,0,158,1),(871,93,0,158,49),(872,143,0,158,169),(873,97,0,159,1),(874,134,0,159,2),(875,115,0,159,1),(876,99,0,159,1),(877,93,0,159,52),(878,143,0,159,169),(879,97,0,160,1),(880,134,0,160,2),(881,115,0,160,1),(882,99,0,160,1),(883,93,0,160,53),(884,143,0,160,169),(885,97,0,161,1),(886,134,0,161,2),(887,115,0,161,1),(888,99,0,161,1),(889,93,0,161,49),(890,143,0,161,170),(891,97,0,162,1),(892,134,0,162,2),(893,115,0,162,1),(894,99,0,162,1),(895,93,0,162,52),(896,143,0,162,170),(897,97,0,163,1),(898,134,0,163,2),(899,115,0,163,1),(900,99,0,163,1),(901,93,0,163,53),(902,143,0,163,170),(903,97,0,164,1),(904,134,0,164,2),(905,115,0,164,1),(906,99,0,164,4),(907,144,0,164,0),(908,145,0,164,0),(909,146,0,164,0),(910,147,0,164,1),(911,148,0,164,0),(912,97,0,165,1),(913,134,0,165,2),(914,115,0,165,1),(915,99,0,165,1),(916,93,0,165,51),(917,143,0,165,166),(918,97,0,166,1),(919,134,0,166,2),(920,115,0,166,1),(921,99,0,166,1),(922,93,0,166,57),(923,143,0,166,166),(924,97,0,167,1),(925,134,0,167,2),(926,115,0,167,1),(927,99,0,167,1),(928,93,0,167,58),(929,143,0,167,166),(930,97,0,168,1),(931,134,0,168,2),(932,115,0,168,1),(933,99,0,168,1),(934,93,0,168,51),(935,143,0,168,167),(936,97,0,169,1),(937,134,0,169,2),(938,115,0,169,1),(939,99,0,169,1),(940,93,0,169,57),(941,143,0,169,167),(942,97,0,170,1),(943,134,0,170,2),(944,115,0,170,1),(945,99,0,170,1),(946,93,0,170,58),(947,143,0,170,167),(948,97,0,171,1),(949,134,0,171,2),(950,115,0,171,1),(951,99,0,171,1),(952,93,0,171,51),(953,143,0,171,168),(954,97,0,172,1),(955,134,0,172,2),(956,115,0,172,1),(957,99,0,172,1),(958,93,0,172,57),(959,143,0,172,168),(960,97,0,173,1),(961,134,0,173,2),(962,115,0,173,1),(963,99,0,173,1),(964,93,0,173,58),(965,143,0,173,168),(966,97,0,174,1),(967,134,0,174,2),(968,115,0,174,1),(969,99,0,174,1),(970,93,0,174,51),(971,143,0,174,169),(972,97,0,175,1),(973,134,0,175,2),(974,115,0,175,1),(975,99,0,175,1),(976,93,0,175,57),(977,143,0,175,169),(978,97,0,176,1),(979,134,0,176,2),(980,115,0,176,1),(981,99,0,176,1),(982,93,0,176,58),(983,143,0,176,169),(984,97,0,177,1),(985,134,0,177,2),(986,115,0,177,1),(987,99,0,177,1),(988,93,0,177,51),(989,143,0,177,170),(990,97,0,178,1),(991,134,0,178,2),(992,115,0,178,1),(993,99,0,178,1),(994,93,0,178,57),(995,143,0,178,170),(996,97,0,179,1),(997,134,0,179,2),(998,115,0,179,1),(999,99,0,179,1),(1000,93,0,179,58),(1001,143,0,179,170),(1002,97,0,180,1),(1003,134,0,180,2),(1004,115,0,180,1),(1005,99,0,180,4),(1006,144,0,180,0),(1007,145,0,180,0),(1008,146,0,180,0),(1009,147,0,180,0),(1010,148,0,180,0),(1011,97,0,181,1),(1012,134,0,181,2),(1013,115,0,181,1),(1014,99,0,181,1),(1015,93,0,181,50),(1016,143,0,181,166),(1017,97,0,182,1),(1018,134,0,182,2),(1019,115,0,182,1),(1020,99,0,182,1),(1021,93,0,182,53),(1022,143,0,182,166),(1023,97,0,183,1),(1024,134,0,183,2),(1025,115,0,183,1),(1026,99,0,183,1),(1027,93,0,183,58),(1028,143,0,183,166),(1029,97,0,184,1),(1030,134,0,184,2),(1031,115,0,184,1),(1032,99,0,184,1),(1033,93,0,184,50),(1034,143,0,184,167),(1035,97,0,185,1),(1036,134,0,185,2),(1037,115,0,185,1),(1038,99,0,185,1),(1039,93,0,185,53),(1040,143,0,185,167),(1041,97,0,186,1),(1042,134,0,186,2),(1043,115,0,186,1),(1044,99,0,186,1),(1045,93,0,186,58),(1046,143,0,186,167),(1047,97,0,187,1),(1048,134,0,187,2),(1049,115,0,187,1),(1050,99,0,187,1),(1051,93,0,187,50),(1052,143,0,187,168),(1053,97,0,188,1),(1054,134,0,188,2),(1055,115,0,188,1),(1056,99,0,188,1),(1057,93,0,188,53),(1058,143,0,188,168),(1059,97,0,189,1),(1060,134,0,189,2),(1061,115,0,189,1),(1062,99,0,189,1),(1063,93,0,189,58),(1064,143,0,189,168),(1065,97,0,190,1),(1066,134,0,190,2),(1067,115,0,190,1),(1068,99,0,190,1),(1069,93,0,190,50),(1070,143,0,190,169),(1071,97,0,191,1),(1072,134,0,191,2),(1073,115,0,191,1),(1074,99,0,191,1),(1075,93,0,191,53),(1076,143,0,191,169),(1077,97,0,192,1),(1078,134,0,192,2),(1079,115,0,192,1),(1080,99,0,192,1),(1081,93,0,192,58),(1082,143,0,192,169),(1083,97,0,193,1),(1084,134,0,193,2),(1085,115,0,193,1),(1086,99,0,193,1),(1087,93,0,193,50),(1088,143,0,193,170),(1089,97,0,194,1),(1090,134,0,194,2),(1091,115,0,194,1),(1092,99,0,194,1),(1093,93,0,194,53),(1094,143,0,194,170),(1095,97,0,195,1),(1096,134,0,195,2),(1097,115,0,195,1),(1098,99,0,195,1),(1099,93,0,195,58),(1100,143,0,195,170),(1101,97,0,196,1),(1102,134,0,196,2),(1103,115,0,196,1),(1104,99,0,196,4),(1105,144,0,196,0),(1106,145,0,196,0),(1107,146,0,196,1),(1108,147,0,196,0),(1109,148,0,196,0),(1110,97,0,197,1),(1111,134,0,197,2),(1112,115,0,197,1),(1113,99,0,197,1),(1114,93,0,197,49),(1115,143,0,197,166),(1116,97,0,198,1),(1117,134,0,198,2),(1118,115,0,198,1),(1119,99,0,198,1),(1120,93,0,198,50),(1121,143,0,198,166),(1122,97,0,199,1),(1123,134,0,199,2),(1124,115,0,199,1),(1125,99,0,199,1),(1126,93,0,199,58),(1127,143,0,199,166),(1128,97,0,200,1),(1129,134,0,200,2),(1130,115,0,200,1),(1131,99,0,200,1),(1132,93,0,200,49),(1133,143,0,200,167),(1134,97,0,201,1),(1135,134,0,201,2),(1136,115,0,201,1),(1137,99,0,201,1),(1138,93,0,201,50),(1139,143,0,201,167),(1140,97,0,202,1),(1141,134,0,202,2),(1142,115,0,202,1),(1143,99,0,202,1),(1144,93,0,202,58),(1145,143,0,202,167),(1146,97,0,203,1),(1147,134,0,203,2),(1148,115,0,203,1),(1149,99,0,203,1),(1150,93,0,203,49),(1151,143,0,203,168),(1152,97,0,204,1),(1153,134,0,204,2),(1154,115,0,204,1),(1155,99,0,204,1),(1156,93,0,204,50),(1157,143,0,204,168),(1158,97,0,205,1),(1159,134,0,205,2),(1160,115,0,205,1),(1161,99,0,205,1),(1162,93,0,205,58),(1163,143,0,205,168),(1164,97,0,206,1),(1165,134,0,206,2),(1166,115,0,206,1),(1167,99,0,206,1),(1168,93,0,206,49),(1169,143,0,206,169),(1170,97,0,207,1),(1171,134,0,207,2),(1172,115,0,207,1),(1173,99,0,207,1),(1174,93,0,207,50),(1175,143,0,207,169),(1176,97,0,208,1),(1177,134,0,208,2),(1178,115,0,208,1),(1179,99,0,208,1),(1180,93,0,208,58),(1181,143,0,208,169),(1182,97,0,209,1),(1183,134,0,209,2),(1184,115,0,209,1),(1185,99,0,209,1),(1186,93,0,209,49),(1187,143,0,209,170),(1188,97,0,210,1),(1189,134,0,210,2),(1190,115,0,210,1),(1191,99,0,210,1),(1192,93,0,210,50),(1193,143,0,210,170),(1194,97,0,211,1),(1195,134,0,211,2),(1196,115,0,211,1),(1197,99,0,211,1),(1198,93,0,211,58),(1199,143,0,211,170),(1200,97,0,212,1),(1201,134,0,212,2),(1202,115,0,212,1),(1203,99,0,212,4),(1204,144,0,212,0),(1205,145,0,212,1),(1206,146,0,212,0),(1207,147,0,212,0),(1208,148,0,212,1),(1209,97,0,213,1),(1210,134,0,213,2),(1211,115,0,213,1),(1212,99,0,213,1),(1213,93,0,213,56),(1214,143,0,213,166),(1215,97,0,214,1),(1216,134,0,214,2),(1217,115,0,214,1),(1218,99,0,214,1),(1219,93,0,214,58),(1220,143,0,214,166),(1221,97,0,215,1),(1222,134,0,215,2),(1223,115,0,215,1),(1224,99,0,215,1),(1225,93,0,215,59),(1226,143,0,215,166),(1227,97,0,216,1),(1228,134,0,216,2),(1229,115,0,216,1),(1230,99,0,216,1),(1231,93,0,216,56),(1232,143,0,216,167),(1233,97,0,217,1),(1234,134,0,217,2),(1235,115,0,217,1),(1236,99,0,217,1),(1237,93,0,217,58),(1238,143,0,217,167),(1239,97,0,218,1),(1240,134,0,218,2),(1241,115,0,218,1),(1242,99,0,218,1),(1243,93,0,218,59),(1244,143,0,218,167),(1245,97,0,219,1),(1246,134,0,219,2),(1247,115,0,219,1),(1248,99,0,219,1),(1249,93,0,219,56),(1250,143,0,219,168),(1251,97,0,220,1),(1252,134,0,220,2),(1253,115,0,220,1),(1254,99,0,220,1),(1255,93,0,220,58),(1256,143,0,220,168),(1257,97,0,221,1),(1258,134,0,221,2),(1259,115,0,221,1),(1260,99,0,221,1),(1261,93,0,221,59),(1262,143,0,221,168),(1263,97,0,222,1),(1264,134,0,222,2),(1265,115,0,222,1),(1266,99,0,222,1),(1267,93,0,222,56),(1268,143,0,222,169),(1269,97,0,223,1),(1270,134,0,223,2),(1271,115,0,223,1),(1272,99,0,223,1),(1273,93,0,223,58),(1274,143,0,223,169),(1275,97,0,224,1),(1276,134,0,224,2),(1277,115,0,224,1),(1278,99,0,224,1),(1279,93,0,224,59),(1280,143,0,224,169),(1281,97,0,225,1),(1282,134,0,225,2),(1283,115,0,225,1),(1284,99,0,225,1),(1285,93,0,225,56),(1286,143,0,225,170),(1287,97,0,226,1),(1288,134,0,226,2),(1289,115,0,226,1),(1290,99,0,226,1),(1291,93,0,226,58),(1292,143,0,226,170),(1293,97,0,227,1),(1294,134,0,227,2),(1295,115,0,227,1),(1296,99,0,227,1),(1297,93,0,227,59),(1298,143,0,227,170),(1299,97,0,228,1),(1300,134,0,228,2),(1301,115,0,228,1),(1302,99,0,228,4),(1303,144,0,228,0),(1304,145,0,228,0),(1305,146,0,228,0),(1306,147,0,228,0),(1307,148,0,228,0),(1308,97,0,229,1),(1309,134,0,229,2),(1310,115,0,229,1),(1311,99,0,229,1),(1312,93,0,229,50),(1313,143,0,229,166),(1314,97,0,230,1),(1315,134,0,230,2),(1316,115,0,230,1),(1317,99,0,230,1),(1318,93,0,230,53),(1319,143,0,230,166),(1320,97,0,231,1),(1321,134,0,231,2),(1322,115,0,231,1),(1323,99,0,231,1),(1324,93,0,231,58),(1325,143,0,231,166),(1326,97,0,232,1),(1327,134,0,232,2),(1328,115,0,232,1),(1329,99,0,232,1),(1330,93,0,232,50),(1331,143,0,232,167),(1332,97,0,233,1),(1333,134,0,233,2),(1334,115,0,233,1),(1335,99,0,233,1),(1336,93,0,233,53),(1337,143,0,233,167),(1338,97,0,234,1),(1339,134,0,234,2),(1340,115,0,234,1),(1341,99,0,234,1),(1342,93,0,234,58),(1343,143,0,234,167),(1344,97,0,235,1),(1345,134,0,235,2),(1346,115,0,235,1),(1347,99,0,235,1),(1348,93,0,235,50),(1349,143,0,235,168),(1350,97,0,236,1),(1351,134,0,236,2),(1352,115,0,236,1),(1353,99,0,236,1),(1354,93,0,236,53),(1355,143,0,236,168),(1356,97,0,237,1),(1357,134,0,237,2),(1358,115,0,237,1),(1359,99,0,237,1),(1360,93,0,237,58),(1361,143,0,237,168),(1362,97,0,238,1),(1363,134,0,238,2),(1364,115,0,238,1),(1365,99,0,238,1),(1366,93,0,238,50),(1367,143,0,238,169),(1368,97,0,239,1),(1369,134,0,239,2),(1370,115,0,239,1),(1371,99,0,239,1),(1372,93,0,239,53),(1373,143,0,239,169),(1374,97,0,240,1),(1375,134,0,240,2),(1376,115,0,240,1),(1377,99,0,240,1),(1378,93,0,240,58),(1379,143,0,240,169),(1380,97,0,241,1),(1381,134,0,241,2),(1382,115,0,241,1),(1383,99,0,241,1),(1384,93,0,241,50),(1385,143,0,241,170),(1386,97,0,242,1),(1387,134,0,242,2),(1388,115,0,242,1),(1389,99,0,242,1),(1390,93,0,242,53),(1391,143,0,242,170),(1392,97,0,243,1),(1393,134,0,243,2),(1394,115,0,243,1),(1395,99,0,243,1),(1396,93,0,243,58),(1397,143,0,243,170),(1398,97,0,244,1),(1399,134,0,244,2),(1400,115,0,244,1),(1401,99,0,244,4),(1402,144,0,244,0),(1403,145,0,244,0),(1404,146,0,244,0),(1405,147,0,244,0),(1406,148,0,244,0),(1407,97,0,245,1),(1408,134,0,245,2),(1409,115,0,245,1),(1410,99,0,245,1),(1411,93,0,245,50),(1412,143,0,245,166),(1413,97,0,246,1),(1414,134,0,246,2),(1415,115,0,246,1),(1416,99,0,246,1),(1417,93,0,246,53),(1418,143,0,246,166),(1419,97,0,247,1),(1420,134,0,247,2),(1421,115,0,247,1),(1422,99,0,247,1),(1423,93,0,247,54),(1424,143,0,247,166),(1425,97,0,248,1),(1426,134,0,248,2),(1427,115,0,248,1),(1428,99,0,248,1),(1429,93,0,248,50),(1430,143,0,248,167),(1431,97,0,249,1),(1432,134,0,249,2),(1433,115,0,249,1),(1434,99,0,249,1),(1435,93,0,249,53),(1436,143,0,249,167),(1437,97,0,250,1),(1438,134,0,250,2),(1439,115,0,250,1),(1440,99,0,250,1),(1441,93,0,250,54),(1442,143,0,250,167),(1443,97,0,251,1),(1444,134,0,251,2),(1445,115,0,251,1),(1446,99,0,251,1),(1447,93,0,251,50),(1448,143,0,251,168),(1449,97,0,252,1),(1450,134,0,252,2),(1451,115,0,252,1),(1452,99,0,252,1),(1453,93,0,252,53),(1454,143,0,252,168),(1455,97,0,253,1),(1456,134,0,253,2),(1457,115,0,253,1),(1458,99,0,253,1),(1459,93,0,253,54),(1460,143,0,253,168),(1461,97,0,254,1),(1462,134,0,254,2),(1463,115,0,254,1),(1464,99,0,254,1),(1465,93,0,254,50),(1466,143,0,254,169),(1467,97,0,255,1),(1468,134,0,255,2),(1469,115,0,255,1),(1470,99,0,255,1),(1471,93,0,255,53),(1472,143,0,255,169),(1473,97,0,256,1),(1474,134,0,256,2),(1475,115,0,256,1),(1476,99,0,256,1),(1477,93,0,256,54),(1478,143,0,256,169),(1479,97,0,257,1),(1480,134,0,257,2),(1481,115,0,257,1),(1482,99,0,257,1),(1483,93,0,257,50),(1484,143,0,257,170),(1485,97,0,258,1),(1486,134,0,258,2),(1487,115,0,258,1),(1488,99,0,258,1),(1489,93,0,258,53),(1490,143,0,258,170),(1491,97,0,259,1),(1492,134,0,259,2),(1493,115,0,259,1),(1494,99,0,259,1),(1495,93,0,259,54),(1496,143,0,259,170),(1497,97,0,260,1),(1498,134,0,260,2),(1499,115,0,260,1),(1500,99,0,260,4),(1501,144,0,260,0),(1502,145,0,260,1),(1503,146,0,260,1),(1504,147,0,260,0),(1505,148,0,260,0),(1506,97,0,261,1),(1507,134,0,261,2),(1508,115,0,261,1),(1509,99,0,261,1),(1510,93,0,261,56),(1511,143,0,261,166),(1512,97,0,262,1),(1513,134,0,262,2),(1514,115,0,262,1),(1515,99,0,262,1),(1516,93,0,262,58),(1517,143,0,262,166),(1518,97,0,263,1),(1519,134,0,263,2),(1520,115,0,263,1),(1521,99,0,263,1),(1522,93,0,263,60),(1523,143,0,263,166),(1524,97,0,264,1),(1525,134,0,264,2),(1526,115,0,264,1),(1527,99,0,264,1),(1528,93,0,264,56),(1529,143,0,264,167),(1530,97,0,265,1),(1531,134,0,265,2),(1532,115,0,265,1),(1533,99,0,265,1),(1534,93,0,265,58),(1535,143,0,265,167),(1536,97,0,266,1),(1537,134,0,266,2),(1538,115,0,266,1),(1539,99,0,266,1),(1540,93,0,266,60),(1541,143,0,266,167),(1542,97,0,267,1),(1543,134,0,267,2),(1544,115,0,267,1),(1545,99,0,267,1),(1546,93,0,267,56),(1547,143,0,267,168),(1548,97,0,268,1),(1549,134,0,268,2),(1550,115,0,268,1),(1551,99,0,268,1),(1552,93,0,268,58),(1553,143,0,268,168),(1554,97,0,269,1),(1555,134,0,269,2),(1556,115,0,269,1),(1557,99,0,269,1),(1558,93,0,269,60),(1559,143,0,269,168),(1560,97,0,270,1),(1561,134,0,270,2),(1562,115,0,270,1),(1563,99,0,270,1),(1564,93,0,270,56),(1565,143,0,270,169),(1566,97,0,271,1),(1567,134,0,271,2),(1568,115,0,271,1),(1569,99,0,271,1),(1570,93,0,271,58),(1571,143,0,271,169),(1572,97,0,272,1),(1573,134,0,272,2),(1574,115,0,272,1),(1575,99,0,272,1),(1576,93,0,272,60),(1577,143,0,272,169),(1578,97,0,273,1),(1579,134,0,273,2),(1580,115,0,273,1),(1581,99,0,273,1),(1582,93,0,273,56),(1583,143,0,273,170),(1584,97,0,274,1),(1585,134,0,274,2),(1586,115,0,274,1),(1587,99,0,274,1),(1588,93,0,274,58),(1589,143,0,274,170),(1590,97,0,275,1),(1591,134,0,275,2),(1592,115,0,275,1),(1593,99,0,275,1),(1594,93,0,275,60),(1595,143,0,275,170),(1596,97,0,276,1),(1597,134,0,276,2),(1598,115,0,276,1),(1599,99,0,276,4),(1600,144,0,276,0),(1601,145,0,276,1),(1602,146,0,276,0),(1603,147,0,276,0),(1604,148,0,276,1),(1605,97,0,277,1),(1606,134,0,277,2),(1607,115,0,277,1),(1608,99,0,277,1),(1609,93,0,277,53),(1610,143,0,277,166),(1611,97,0,278,1),(1612,134,0,278,2),(1613,115,0,278,1),(1614,99,0,278,1),(1615,93,0,278,56),(1616,143,0,278,166),(1617,97,0,279,1),(1618,134,0,279,2),(1619,115,0,279,1),(1620,99,0,279,1),(1621,93,0,279,58),(1622,143,0,279,166),(1623,97,0,280,1),(1624,134,0,280,2),(1625,115,0,280,1),(1626,99,0,280,1),(1627,93,0,280,53),(1628,143,0,280,167),(1629,97,0,281,1),(1630,134,0,281,2),(1631,115,0,281,1),(1632,99,0,281,1),(1633,93,0,281,56),(1634,143,0,281,167),(1635,97,0,282,1),(1636,134,0,282,2),(1637,115,0,282,1),(1638,99,0,282,1),(1639,93,0,282,58),(1640,143,0,282,167),(1641,97,0,283,1),(1642,134,0,283,2),(1643,115,0,283,1),(1644,99,0,283,1),(1645,93,0,283,53),(1646,143,0,283,168),(1647,97,0,284,1),(1648,134,0,284,2),(1649,115,0,284,1),(1650,99,0,284,1),(1651,93,0,284,56),(1652,143,0,284,168),(1653,97,0,285,1),(1654,134,0,285,2),(1655,115,0,285,1),(1656,99,0,285,1),(1657,93,0,285,58),(1658,143,0,285,168),(1659,97,0,286,1),(1660,134,0,286,2),(1661,115,0,286,1),(1662,99,0,286,1),(1663,93,0,286,53),(1664,143,0,286,169),(1665,97,0,287,1),(1666,134,0,287,2),(1667,115,0,287,1),(1668,99,0,287,1),(1669,93,0,287,56),(1670,143,0,287,169),(1671,97,0,288,1),(1672,134,0,288,2),(1673,115,0,288,1),(1674,99,0,288,1),(1675,93,0,288,58),(1676,143,0,288,169),(1677,97,0,289,1),(1678,134,0,289,2),(1679,115,0,289,1),(1680,99,0,289,1),(1681,93,0,289,53),(1682,143,0,289,170),(1683,97,0,290,1),(1684,134,0,290,2),(1685,115,0,290,1),(1686,99,0,290,1),(1687,93,0,290,56),(1688,143,0,290,170),(1689,97,0,291,1),(1690,134,0,291,2),(1691,115,0,291,1),(1692,99,0,291,1),(1693,93,0,291,58),(1694,143,0,291,170),(1695,97,0,292,1),(1696,134,0,292,2),(1697,115,0,292,1),(1698,99,0,292,4),(1699,144,0,292,0),(1700,145,0,292,1),(1701,146,0,292,0),(1702,147,0,292,1),(1703,148,0,292,0),(1704,97,0,293,1),(1705,134,0,293,2),(1706,115,0,293,1),(1707,99,0,293,1),(1708,93,0,293,49),(1709,143,0,293,166),(1710,97,0,294,1),(1711,134,0,294,2),(1712,115,0,294,1),(1713,99,0,294,1),(1714,93,0,294,50),(1715,143,0,294,166),(1716,97,0,295,1),(1717,134,0,295,2),(1718,115,0,295,1),(1719,99,0,295,1),(1720,93,0,295,57),(1721,143,0,295,166),(1722,97,0,296,1),(1723,134,0,296,2),(1724,115,0,296,1),(1725,99,0,296,1),(1726,93,0,296,49),(1727,143,0,296,167),(1728,97,0,297,1),(1729,134,0,297,2),(1730,115,0,297,1),(1731,99,0,297,1),(1732,93,0,297,50),(1733,143,0,297,167),(1734,97,0,298,1),(1735,134,0,298,2),(1736,115,0,298,1),(1737,99,0,298,1),(1738,93,0,298,57),(1739,143,0,298,167),(1740,97,0,299,1),(1741,134,0,299,2),(1742,115,0,299,1),(1743,99,0,299,1),(1744,93,0,299,49),(1745,143,0,299,168),(1746,97,0,300,1),(1747,134,0,300,2),(1748,115,0,300,1),(1749,99,0,300,1),(1750,93,0,300,50),(1751,143,0,300,168),(1752,97,0,301,1),(1753,134,0,301,2),(1754,115,0,301,1),(1755,99,0,301,1),(1756,93,0,301,57),(1757,143,0,301,168),(1758,97,0,302,1),(1759,134,0,302,2),(1760,115,0,302,1),(1761,99,0,302,1),(1762,93,0,302,49),(1763,143,0,302,169),(1764,97,0,303,1),(1765,134,0,303,2),(1766,115,0,303,1),(1767,99,0,303,1),(1768,93,0,303,50),(1769,143,0,303,169),(1770,97,0,304,1),(1771,134,0,304,2),(1772,115,0,304,1),(1773,99,0,304,1),(1774,93,0,304,57),(1775,143,0,304,169),(1776,97,0,305,1),(1777,134,0,305,2),(1778,115,0,305,1),(1779,99,0,305,1),(1780,93,0,305,49),(1781,143,0,305,170),(1782,97,0,306,1),(1783,134,0,306,2),(1784,115,0,306,1),(1785,99,0,306,1),(1786,93,0,306,50),(1787,143,0,306,170),(1788,97,0,307,1),(1789,134,0,307,2),(1790,115,0,307,1),(1791,99,0,307,1),(1792,93,0,307,57),(1793,143,0,307,170),(1794,97,0,308,1),(1795,134,0,308,2),(1796,115,0,308,1),(1797,99,0,308,4),(1798,144,0,308,1),(1799,145,0,308,0),(1800,146,0,308,0),(1801,147,0,308,0),(1802,148,0,308,0),(1803,97,0,309,1),(1804,134,0,309,2),(1805,115,0,309,1),(1806,99,0,309,1),(1807,93,0,309,49),(1808,143,0,309,166),(1809,97,0,310,1),(1810,134,0,310,2),(1811,115,0,310,1),(1812,99,0,310,1),(1813,93,0,310,58),(1814,143,0,310,166),(1815,97,0,311,1),(1816,134,0,311,2),(1817,115,0,311,1),(1818,99,0,311,1),(1819,93,0,311,60),(1820,143,0,311,166),(1821,97,0,312,1),(1822,134,0,312,2),(1823,115,0,312,1),(1824,99,0,312,1),(1825,93,0,312,49),(1826,143,0,312,167),(1827,97,0,313,1),(1828,134,0,313,2),(1829,115,0,313,1),(1830,99,0,313,1),(1831,93,0,313,58),(1832,143,0,313,167),(1833,97,0,314,1),(1834,134,0,314,2),(1835,115,0,314,1),(1836,99,0,314,1),(1837,93,0,314,60),(1838,143,0,314,167),(1839,97,0,315,1),(1840,134,0,315,2),(1841,115,0,315,1),(1842,99,0,315,1),(1843,93,0,315,49),(1844,143,0,315,168),(1845,97,0,316,1),(1846,134,0,316,2),(1847,115,0,316,1),(1848,99,0,316,1),(1849,93,0,316,58),(1850,143,0,316,168),(1851,97,0,317,1),(1852,134,0,317,2),(1853,115,0,317,1),(1854,99,0,317,1),(1855,93,0,317,60),(1856,143,0,317,168),(1857,97,0,318,1),(1858,134,0,318,2),(1859,115,0,318,1),(1860,99,0,318,1),(1861,93,0,318,49),(1862,143,0,318,169),(1863,97,0,319,1),(1864,134,0,319,2),(1865,115,0,319,1),(1866,99,0,319,1),(1867,93,0,319,58),(1868,143,0,319,169),(1869,97,0,320,1),(1870,134,0,320,2),(1871,115,0,320,1),(1872,99,0,320,1),(1873,93,0,320,60),(1874,143,0,320,169),(1875,97,0,321,1),(1876,134,0,321,2),(1877,115,0,321,1),(1878,99,0,321,1),(1879,93,0,321,49),(1880,143,0,321,170),(1881,97,0,322,1),(1882,134,0,322,2),(1883,115,0,322,1),(1884,99,0,322,1),(1885,93,0,322,58),(1886,143,0,322,170),(1887,97,0,323,1),(1888,134,0,323,2),(1889,115,0,323,1),(1890,99,0,323,1),(1891,93,0,323,60),(1892,143,0,323,170),(1893,97,0,324,1),(1894,134,0,324,2),(1895,115,0,324,1),(1896,99,0,324,4),(1897,144,0,324,0),(1898,145,0,324,0),(1899,146,0,324,0),(1900,147,0,324,0),(1901,148,0,324,0),(1902,97,0,325,1),(1903,134,0,325,2),(1904,115,0,325,1),(1905,99,0,325,1),(1906,93,0,325,50),(1907,143,0,325,166),(1908,97,0,326,1),(1909,134,0,326,2),(1910,115,0,326,1),(1911,99,0,326,1),(1912,93,0,326,52),(1913,143,0,326,166),(1914,97,0,327,1),(1915,134,0,327,2),(1916,115,0,327,1),(1917,99,0,327,1),(1918,93,0,327,53),(1919,143,0,327,166),(1920,97,0,328,1),(1921,134,0,328,2),(1922,115,0,328,1),(1923,99,0,328,1),(1924,93,0,328,50),(1925,143,0,328,167),(1926,97,0,329,1),(1927,134,0,329,2),(1928,115,0,329,1),(1929,99,0,329,1),(1930,93,0,329,52),(1931,143,0,329,167),(1932,97,0,330,1),(1933,134,0,330,2),(1934,115,0,330,1),(1935,99,0,330,1),(1936,93,0,330,53),(1937,143,0,330,167),(1938,97,0,331,1),(1939,134,0,331,2),(1940,115,0,331,1),(1941,99,0,331,1),(1942,93,0,331,50),(1943,143,0,331,168),(1944,97,0,332,1),(1945,134,0,332,2),(1946,115,0,332,1),(1947,99,0,332,1),(1948,93,0,332,52),(1949,143,0,332,168),(1950,97,0,333,1),(1951,134,0,333,2),(1952,115,0,333,1),(1953,99,0,333,1),(1954,93,0,333,53),(1955,143,0,333,168),(1956,97,0,334,1),(1957,134,0,334,2),(1958,115,0,334,1),(1959,99,0,334,1),(1960,93,0,334,50),(1961,143,0,334,169),(1962,97,0,335,1),(1963,134,0,335,2),(1964,115,0,335,1),(1965,99,0,335,1),(1966,93,0,335,52),(1967,143,0,335,169),(1968,97,0,336,1),(1969,134,0,336,2),(1970,115,0,336,1),(1971,99,0,336,1),(1972,93,0,336,53),(1973,143,0,336,169),(1974,97,0,337,1),(1975,134,0,337,2),(1976,115,0,337,1),(1977,99,0,337,1),(1978,93,0,337,50),(1979,143,0,337,170),(1980,97,0,338,1),(1981,134,0,338,2),(1982,115,0,338,1),(1983,99,0,338,1),(1984,93,0,338,52),(1985,143,0,338,170),(1986,97,0,339,1),(1987,134,0,339,2),(1988,115,0,339,1),(1989,99,0,339,1),(1990,93,0,339,53),(1991,143,0,339,170),(1992,97,0,340,1),(1993,134,0,340,2),(1994,115,0,340,1),(1995,99,0,340,4),(1996,144,0,340,0),(1997,145,0,340,0),(1998,146,0,340,1),(1999,147,0,340,0),(2000,148,0,340,0),(2001,97,0,341,1),(2002,134,0,341,2),(2003,115,0,341,1),(2004,99,0,341,1),(2005,93,0,341,50),(2006,143,0,341,166),(2007,97,0,342,1),(2008,134,0,342,2),(2009,115,0,342,1),(2010,99,0,342,1),(2011,93,0,342,59),(2012,143,0,342,166),(2013,97,0,343,1),(2014,134,0,343,2),(2015,115,0,343,1),(2016,99,0,343,1),(2017,93,0,343,60),(2018,143,0,343,166),(2019,97,0,344,1),(2020,134,0,344,2),(2021,115,0,344,1),(2022,99,0,344,1),(2023,93,0,344,50),(2024,143,0,344,167),(2025,97,0,345,1),(2026,134,0,345,2),(2027,115,0,345,1),(2028,99,0,345,1),(2029,93,0,345,59),(2030,143,0,345,167),(2031,97,0,346,1),(2032,134,0,346,2),(2033,115,0,346,1),(2034,99,0,346,1),(2035,93,0,346,60),(2036,143,0,346,167),(2037,97,0,347,1),(2038,134,0,347,2),(2039,115,0,347,1),(2040,99,0,347,1),(2041,93,0,347,50),(2042,143,0,347,168),(2043,97,0,348,1),(2044,134,0,348,2),(2045,115,0,348,1),(2046,99,0,348,1),(2047,93,0,348,59),(2048,143,0,348,168),(2049,97,0,349,1),(2050,134,0,349,2),(2051,115,0,349,1),(2052,99,0,349,1),(2053,93,0,349,60),(2054,143,0,349,168),(2055,97,0,350,1),(2056,134,0,350,2),(2057,115,0,350,1),(2058,99,0,350,1),(2059,93,0,350,50),(2060,143,0,350,169),(2061,97,0,351,1),(2062,134,0,351,2),(2063,115,0,351,1),(2064,99,0,351,1),(2065,93,0,351,59),(2066,143,0,351,169),(2067,97,0,352,1),(2068,134,0,352,2),(2069,115,0,352,1),(2070,99,0,352,1),(2071,93,0,352,60),(2072,143,0,352,169),(2073,97,0,353,1),(2074,134,0,353,2),(2075,115,0,353,1),(2076,99,0,353,1),(2077,93,0,353,50),(2078,143,0,353,170),(2079,97,0,354,1),(2080,134,0,354,2),(2081,115,0,354,1),(2082,99,0,354,1),(2083,93,0,354,59),(2084,143,0,354,170),(2085,97,0,355,1),(2086,134,0,355,2),(2087,115,0,355,1),(2088,99,0,355,1),(2089,93,0,355,60),(2090,143,0,355,170),(2091,97,0,356,1),(2092,134,0,356,2),(2093,115,0,356,1),(2094,99,0,356,4),(2095,144,0,356,0),(2096,145,0,356,0),(2097,146,0,356,0),(2098,147,0,356,0),(2099,148,0,356,0),(2100,97,0,357,1),(2101,134,0,357,2),(2102,115,0,357,1),(2103,99,0,357,1),(2104,93,0,357,49),(2105,143,0,357,166),(2106,97,0,358,1),(2107,134,0,358,2),(2108,115,0,358,1),(2109,99,0,358,1),(2110,93,0,358,56),(2111,143,0,358,166),(2112,97,0,359,1),(2113,134,0,359,2),(2114,115,0,359,1),(2115,99,0,359,1),(2116,93,0,359,58),(2117,143,0,359,166),(2118,97,0,360,1),(2119,134,0,360,2),(2120,115,0,360,1),(2121,99,0,360,1),(2122,93,0,360,49),(2123,143,0,360,167),(2124,97,0,361,1),(2125,134,0,361,2),(2126,115,0,361,1),(2127,99,0,361,1),(2128,93,0,361,56),(2129,143,0,361,167),(2130,97,0,362,1),(2131,134,0,362,2),(2132,115,0,362,1),(2133,99,0,362,1),(2134,93,0,362,58),(2135,143,0,362,167),(2136,97,0,363,1),(2137,134,0,363,2),(2138,115,0,363,1),(2139,99,0,363,1),(2140,93,0,363,49),(2141,143,0,363,168),(2142,97,0,364,1),(2143,134,0,364,2),(2144,115,0,364,1),(2145,99,0,364,1),(2146,93,0,364,56),(2147,143,0,364,168),(2148,97,0,365,1),(2149,134,0,365,2),(2150,115,0,365,1),(2151,99,0,365,1),(2152,93,0,365,58),(2153,143,0,365,168),(2154,97,0,366,1),(2155,134,0,366,2),(2156,115,0,366,1),(2157,99,0,366,1),(2158,93,0,366,49),(2159,143,0,366,169),(2160,97,0,367,1),(2161,134,0,367,2),(2162,115,0,367,1),(2163,99,0,367,1),(2164,93,0,367,56),(2165,143,0,367,169),(2166,97,0,368,1),(2167,134,0,368,2),(2168,115,0,368,1),(2169,99,0,368,1),(2170,93,0,368,58),(2171,143,0,368,169),(2172,97,0,369,1),(2173,134,0,369,2),(2174,115,0,369,1),(2175,99,0,369,1),(2176,93,0,369,49),(2177,143,0,369,170),(2178,97,0,370,1),(2179,134,0,370,2),(2180,115,0,370,1),(2181,99,0,370,1),(2182,93,0,370,56),(2183,143,0,370,170),(2184,97,0,371,1),(2185,134,0,371,2),(2186,115,0,371,1),(2187,99,0,371,1),(2188,93,0,371,58),(2189,143,0,371,170),(2190,97,0,372,1),(2191,134,0,372,2),(2192,115,0,372,1),(2193,99,0,372,4),(2194,144,0,372,0),(2195,145,0,372,0),(2196,146,0,372,0),(2197,147,0,372,0),(2198,148,0,372,0),(2199,97,0,373,1),(2200,134,0,373,2),(2201,115,0,373,1),(2202,99,0,373,1),(2203,93,0,373,49),(2204,143,0,373,166),(2205,97,0,374,1),(2206,134,0,374,2),(2207,115,0,374,1),(2208,99,0,374,1),(2209,93,0,374,53),(2210,143,0,374,166),(2211,97,0,375,1),(2212,134,0,375,2),(2213,115,0,375,1),(2214,99,0,375,1),(2215,93,0,375,58),(2216,143,0,375,166),(2217,97,0,376,1),(2218,134,0,376,2),(2219,115,0,376,1),(2220,99,0,376,1),(2221,93,0,376,49),(2222,143,0,376,167),(2223,97,0,377,1),(2224,134,0,377,2),(2225,115,0,377,1),(2226,99,0,377,1),(2227,93,0,377,53),(2228,143,0,377,167),(2229,97,0,378,1),(2230,134,0,378,2),(2231,115,0,378,1),(2232,99,0,378,1),(2233,93,0,378,58),(2234,143,0,378,167),(2235,97,0,379,1),(2236,134,0,379,2),(2237,115,0,379,1),(2238,99,0,379,1),(2239,93,0,379,49),(2240,143,0,379,168),(2241,97,0,380,1),(2242,134,0,380,2),(2243,115,0,380,1),(2244,99,0,380,1),(2245,93,0,380,53),(2246,143,0,380,168),(2247,97,0,381,1),(2248,134,0,381,2),(2249,115,0,381,1),(2250,99,0,381,1),(2251,93,0,381,58),(2252,143,0,381,168),(2253,97,0,382,1),(2254,134,0,382,2),(2255,115,0,382,1),(2256,99,0,382,1),(2257,93,0,382,49),(2258,143,0,382,169),(2259,97,0,383,1),(2260,134,0,383,2),(2261,115,0,383,1),(2262,99,0,383,1),(2263,93,0,383,53),(2264,143,0,383,169),(2265,97,0,384,1),(2266,134,0,384,2),(2267,115,0,384,1),(2268,99,0,384,1),(2269,93,0,384,58),(2270,143,0,384,169),(2271,97,0,385,1),(2272,134,0,385,2),(2273,115,0,385,1),(2274,99,0,385,1),(2275,93,0,385,49),(2276,143,0,385,170),(2277,97,0,386,1),(2278,134,0,386,2),(2279,115,0,386,1),(2280,99,0,386,1),(2281,93,0,386,53),(2282,143,0,386,170),(2283,97,0,387,1),(2284,134,0,387,2),(2285,115,0,387,1),(2286,99,0,387,1),(2287,93,0,387,58),(2288,143,0,387,170),(2289,97,0,388,1),(2290,134,0,388,2),(2291,115,0,388,1),(2292,99,0,388,4),(2293,144,0,388,0),(2294,145,0,388,1),(2295,146,0,388,0),(2296,147,0,388,0),(2297,148,0,388,1),(2298,97,0,389,1),(2299,134,0,389,2),(2300,115,0,389,1),(2301,99,0,389,1),(2302,93,0,389,50),(2303,143,0,389,166),(2304,97,0,390,1),(2305,134,0,390,2),(2306,115,0,390,1),(2307,99,0,390,1),(2308,93,0,390,53),(2309,143,0,390,166),(2310,97,0,391,1),(2311,134,0,391,2),(2312,115,0,391,1),(2313,99,0,391,1),(2314,93,0,391,57),(2315,143,0,391,166),(2316,97,0,392,1),(2317,134,0,392,2),(2318,115,0,392,1),(2319,99,0,392,1),(2320,93,0,392,50),(2321,143,0,392,167),(2322,97,0,393,1),(2323,134,0,393,2),(2324,115,0,393,1),(2325,99,0,393,1),(2326,93,0,393,53),(2327,143,0,393,167),(2328,97,0,394,1),(2329,134,0,394,2),(2330,115,0,394,1),(2331,99,0,394,1),(2332,93,0,394,57),(2333,143,0,394,167),(2334,97,0,395,1),(2335,134,0,395,2),(2336,115,0,395,1),(2337,99,0,395,1),(2338,93,0,395,50),(2339,143,0,395,168),(2340,97,0,396,1),(2341,134,0,396,2),(2342,115,0,396,1),(2343,99,0,396,1),(2344,93,0,396,53),(2345,143,0,396,168),(2346,97,0,397,1),(2347,134,0,397,2),(2348,115,0,397,1),(2349,99,0,397,1),(2350,93,0,397,57),(2351,143,0,397,168),(2352,97,0,398,1),(2353,134,0,398,2),(2354,115,0,398,1),(2355,99,0,398,1),(2356,93,0,398,50),(2357,143,0,398,169),(2358,97,0,399,1),(2359,134,0,399,2),(2360,115,0,399,1),(2361,99,0,399,1),(2362,93,0,399,53),(2363,143,0,399,169),(2364,97,0,400,1),(2365,134,0,400,2),(2366,115,0,400,1),(2367,99,0,400,1),(2368,93,0,400,57),(2369,143,0,400,169),(2370,97,0,401,1),(2371,134,0,401,2),(2372,115,0,401,1),(2373,99,0,401,1),(2374,93,0,401,50),(2375,143,0,401,170),(2376,97,0,402,1),(2377,134,0,402,2),(2378,115,0,402,1),(2379,99,0,402,1),(2380,93,0,402,53),(2381,143,0,402,170),(2382,97,0,403,1),(2383,134,0,403,2),(2384,115,0,403,1),(2385,99,0,403,1),(2386,93,0,403,57),(2387,143,0,403,170),(2388,97,0,404,1),(2389,134,0,404,2),(2390,115,0,404,1),(2391,99,0,404,4),(2392,144,0,404,1),(2393,145,0,404,0),(2394,146,0,404,1),(2395,147,0,404,0),(2396,148,0,404,0),(2397,97,0,405,1),(2398,134,0,405,2),(2399,115,0,405,1),(2400,99,0,405,1),(2401,93,0,405,49),(2402,143,0,405,166),(2403,97,0,406,1),(2404,134,0,406,2),(2405,115,0,406,1),(2406,99,0,406,1),(2407,93,0,406,53),(2408,143,0,406,166),(2409,97,0,407,1),(2410,134,0,407,2),(2411,115,0,407,1),(2412,99,0,407,1),(2413,93,0,407,58),(2414,143,0,407,166),(2415,97,0,408,1),(2416,134,0,408,2),(2417,115,0,408,1),(2418,99,0,408,1),(2419,93,0,408,49),(2420,143,0,408,167),(2421,97,0,409,1),(2422,134,0,409,2),(2423,115,0,409,1),(2424,99,0,409,1),(2425,93,0,409,53),(2426,143,0,409,167),(2427,97,0,410,1),(2428,134,0,410,2),(2429,115,0,410,1),(2430,99,0,410,1),(2431,93,0,410,58),(2432,143,0,410,167),(2433,97,0,411,1),(2434,134,0,411,2),(2435,115,0,411,1),(2436,99,0,411,1),(2437,93,0,411,49),(2438,143,0,411,168),(2439,97,0,412,1),(2440,134,0,412,2),(2441,115,0,412,1),(2442,99,0,412,1),(2443,93,0,412,53),(2444,143,0,412,168),(2445,97,0,413,1),(2446,134,0,413,2),(2447,115,0,413,1),(2448,99,0,413,1),(2449,93,0,413,58),(2450,143,0,413,168),(2451,97,0,414,1),(2452,134,0,414,2),(2453,115,0,414,1),(2454,99,0,414,1),(2455,93,0,414,49),(2456,143,0,414,169),(2457,97,0,415,1),(2458,134,0,415,2),(2459,115,0,415,1),(2460,99,0,415,1),(2461,93,0,415,53),(2462,143,0,415,169),(2463,97,0,416,1),(2464,134,0,416,2),(2465,115,0,416,1),(2466,99,0,416,1),(2467,93,0,416,58),(2468,143,0,416,169),(2469,97,0,417,1),(2470,134,0,417,2),(2471,115,0,417,1),(2472,99,0,417,1),(2473,93,0,417,49),(2474,143,0,417,170),(2475,97,0,418,1),(2476,134,0,418,2),(2477,115,0,418,1),(2478,99,0,418,1),(2479,93,0,418,53),(2480,143,0,418,170),(2481,97,0,419,1),(2482,134,0,419,2),(2483,115,0,419,1),(2484,99,0,419,1),(2485,93,0,419,58),(2486,143,0,419,170),(2487,97,0,420,1),(2488,134,0,420,2),(2489,115,0,420,1),(2490,99,0,420,4),(2491,144,0,420,0),(2492,145,0,420,0),(2493,146,0,420,0),(2494,147,0,420,1),(2495,148,0,420,0),(2496,97,0,421,1),(2497,134,0,421,2),(2498,115,0,421,1),(2499,99,0,421,1),(2500,93,0,421,49),(2501,143,0,421,166),(2502,97,0,422,1),(2503,134,0,422,2),(2504,115,0,422,1),(2505,99,0,422,1),(2506,93,0,422,50),(2507,143,0,422,166),(2508,97,0,423,1),(2509,134,0,423,2),(2510,115,0,423,1),(2511,99,0,423,1),(2512,93,0,423,56),(2513,143,0,423,166),(2514,97,0,424,1),(2515,134,0,424,2),(2516,115,0,424,1),(2517,99,0,424,1),(2518,93,0,424,49),(2519,143,0,424,167),(2520,97,0,425,1),(2521,134,0,425,2),(2522,115,0,425,1),(2523,99,0,425,1),(2524,93,0,425,50),(2525,143,0,425,167),(2526,97,0,426,1),(2527,134,0,426,2),(2528,115,0,426,1),(2529,99,0,426,1),(2530,93,0,426,56),(2531,143,0,426,167),(2532,97,0,427,1),(2533,134,0,427,2),(2534,115,0,427,1),(2535,99,0,427,1),(2536,93,0,427,49),(2537,143,0,427,168),(2538,97,0,428,1),(2539,134,0,428,2),(2540,115,0,428,1),(2541,99,0,428,1),(2542,93,0,428,50),(2543,143,0,428,168),(2544,97,0,429,1),(2545,134,0,429,2),(2546,115,0,429,1),(2547,99,0,429,1),(2548,93,0,429,56),(2549,143,0,429,168),(2550,97,0,430,1),(2551,134,0,430,2),(2552,115,0,430,1),(2553,99,0,430,1),(2554,93,0,430,49),(2555,143,0,430,169),(2556,97,0,431,1),(2557,134,0,431,2),(2558,115,0,431,1),(2559,99,0,431,1),(2560,93,0,431,50),(2561,143,0,431,169),(2562,97,0,432,1),(2563,134,0,432,2),(2564,115,0,432,1),(2565,99,0,432,1),(2566,93,0,432,56),(2567,143,0,432,169),(2568,97,0,433,1),(2569,134,0,433,2),(2570,115,0,433,1),(2571,99,0,433,1),(2572,93,0,433,49),(2573,143,0,433,170),(2574,97,0,434,1),(2575,134,0,434,2),(2576,115,0,434,1),(2577,99,0,434,1),(2578,93,0,434,50),(2579,143,0,434,170),(2580,97,0,435,1),(2581,134,0,435,2),(2582,115,0,435,1),(2583,99,0,435,1),(2584,93,0,435,56),(2585,143,0,435,170),(2586,97,0,436,1),(2587,134,0,436,2),(2588,115,0,436,1),(2589,99,0,436,4),(2590,144,0,436,0),(2591,145,0,436,0),(2592,146,0,436,0),(2593,147,0,436,0),(2594,148,0,436,0),(2595,97,0,437,1),(2596,134,0,437,2),(2597,115,0,437,1),(2598,99,0,437,1),(2599,93,0,437,49),(2600,143,0,437,166),(2601,97,0,438,1),(2602,134,0,438,2),(2603,115,0,438,1),(2604,99,0,438,1),(2605,93,0,438,56),(2606,143,0,438,166),(2607,97,0,439,1),(2608,134,0,439,2),(2609,115,0,439,1),(2610,99,0,439,1),(2611,93,0,439,58),(2612,143,0,439,166),(2613,97,0,440,1),(2614,134,0,440,2),(2615,115,0,440,1),(2616,99,0,440,1),(2617,93,0,440,49),(2618,143,0,440,167),(2619,97,0,441,1),(2620,134,0,441,2),(2621,115,0,441,1),(2622,99,0,441,1),(2623,93,0,441,56),(2624,143,0,441,167),(2625,97,0,442,1),(2626,134,0,442,2),(2627,115,0,442,1),(2628,99,0,442,1),(2629,93,0,442,58),(2630,143,0,442,167),(2631,97,0,443,1),(2632,134,0,443,2),(2633,115,0,443,1),(2634,99,0,443,1),(2635,93,0,443,49),(2636,143,0,443,168),(2637,97,0,444,1),(2638,134,0,444,2),(2639,115,0,444,1),(2640,99,0,444,1),(2641,93,0,444,56),(2642,143,0,444,168),(2643,97,0,445,1),(2644,134,0,445,2),(2645,115,0,445,1),(2646,99,0,445,1),(2647,93,0,445,58),(2648,143,0,445,168),(2649,97,0,446,1),(2650,134,0,446,2),(2651,115,0,446,1),(2652,99,0,446,1),(2653,93,0,446,49),(2654,143,0,446,169),(2655,97,0,447,1),(2656,134,0,447,2),(2657,115,0,447,1),(2658,99,0,447,1),(2659,93,0,447,56),(2660,143,0,447,169),(2661,97,0,448,1),(2662,134,0,448,2),(2663,115,0,448,1),(2664,99,0,448,1),(2665,93,0,448,58),(2666,143,0,448,169),(2667,97,0,449,1),(2668,134,0,449,2),(2669,115,0,449,1),(2670,99,0,449,1),(2671,93,0,449,49),(2672,143,0,449,170),(2673,97,0,450,1),(2674,134,0,450,2),(2675,115,0,450,1),(2676,99,0,450,1),(2677,93,0,450,56),(2678,143,0,450,170),(2679,97,0,451,1),(2680,134,0,451,2),(2681,115,0,451,1),(2682,99,0,451,1),(2683,93,0,451,58),(2684,143,0,451,170),(2685,97,0,452,1),(2686,134,0,452,2),(2687,115,0,452,1),(2688,99,0,452,4),(2689,144,0,452,0),(2690,145,0,452,1),(2691,146,0,452,0),(2692,147,0,452,1),(2693,148,0,452,0),(2694,97,0,453,1),(2695,134,0,453,2),(2696,115,0,453,1),(2697,99,0,453,1),(2698,93,0,453,49),(2699,143,0,453,166),(2700,97,0,454,1),(2701,134,0,454,2),(2702,115,0,454,1),(2703,99,0,454,1),(2704,93,0,454,50),(2705,143,0,454,166),(2706,97,0,455,1),(2707,134,0,455,2),(2708,115,0,455,1),(2709,99,0,455,1),(2710,93,0,455,57),(2711,143,0,455,166),(2712,97,0,456,1),(2713,134,0,456,2),(2714,115,0,456,1),(2715,99,0,456,1),(2716,93,0,456,49),(2717,143,0,456,167),(2718,97,0,457,1),(2719,134,0,457,2),(2720,115,0,457,1),(2721,99,0,457,1),(2722,93,0,457,50),(2723,143,0,457,167),(2724,97,0,458,1),(2725,134,0,458,2),(2726,115,0,458,1),(2727,99,0,458,1),(2728,93,0,458,57),(2729,143,0,458,167),(2730,97,0,459,1),(2731,134,0,459,2),(2732,115,0,459,1),(2733,99,0,459,1),(2734,93,0,459,49),(2735,143,0,459,168),(2736,97,0,460,1),(2737,134,0,460,2),(2738,115,0,460,1),(2739,99,0,460,1),(2740,93,0,460,50),(2741,143,0,460,168),(2742,97,0,461,1),(2743,134,0,461,2),(2744,115,0,461,1),(2745,99,0,461,1),(2746,93,0,461,57),(2747,143,0,461,168),(2748,97,0,462,1),(2749,134,0,462,2),(2750,115,0,462,1),(2751,99,0,462,1),(2752,93,0,462,49),(2753,143,0,462,169),(2754,97,0,463,1),(2755,134,0,463,2),(2756,115,0,463,1),(2757,99,0,463,1),(2758,93,0,463,50),(2759,143,0,463,169),(2760,97,0,464,1),(2761,134,0,464,2),(2762,115,0,464,1),(2763,99,0,464,1),(2764,93,0,464,57),(2765,143,0,464,169),(2766,97,0,465,1),(2767,134,0,465,2),(2768,115,0,465,1),(2769,99,0,465,1),(2770,93,0,465,49),(2771,143,0,465,170),(2772,97,0,466,1),(2773,134,0,466,2),(2774,115,0,466,1),(2775,99,0,466,1),(2776,93,0,466,50),(2777,143,0,466,170),(2778,97,0,467,1),(2779,134,0,467,2),(2780,115,0,467,1),(2781,99,0,467,1),(2782,93,0,467,57),(2783,143,0,467,170),(2784,97,0,468,1),(2785,134,0,468,2),(2786,115,0,468,1),(2787,99,0,468,4),(2788,144,0,468,1),(2789,145,0,468,1),(2790,146,0,468,0),(2791,147,0,468,0),(2792,148,0,468,0),(2793,97,0,469,1),(2794,134,0,469,2),(2795,115,0,469,1),(2796,99,0,469,1),(2797,93,0,469,49),(2798,143,0,469,166),(2799,97,0,470,1),(2800,134,0,470,2),(2801,115,0,470,1),(2802,99,0,470,1),(2803,93,0,470,50),(2804,143,0,470,166),(2805,97,0,471,1),(2806,134,0,471,2),(2807,115,0,471,1),(2808,99,0,471,1),(2809,93,0,471,58),(2810,143,0,471,166),(2811,97,0,472,1),(2812,134,0,472,2),(2813,115,0,472,1),(2814,99,0,472,1),(2815,93,0,472,49),(2816,143,0,472,167),(2817,97,0,473,1),(2818,134,0,473,2),(2819,115,0,473,1),(2820,99,0,473,1),(2821,93,0,473,50),(2822,143,0,473,167),(2823,97,0,474,1),(2824,134,0,474,2),(2825,115,0,474,1),(2826,99,0,474,1),(2827,93,0,474,58),(2828,143,0,474,167),(2829,97,0,475,1),(2830,134,0,475,2),(2831,115,0,475,1),(2832,99,0,475,1),(2833,93,0,475,49),(2834,143,0,475,168),(2835,97,0,476,1),(2836,134,0,476,2),(2837,115,0,476,1),(2838,99,0,476,1),(2839,93,0,476,50),(2840,143,0,476,168),(2841,97,0,477,1),(2842,134,0,477,2),(2843,115,0,477,1),(2844,99,0,477,1),(2845,93,0,477,58),(2846,143,0,477,168),(2847,97,0,478,1),(2848,134,0,478,2),(2849,115,0,478,1),(2850,99,0,478,1),(2851,93,0,478,49),(2852,143,0,478,169),(2853,97,0,479,1),(2854,134,0,479,2),(2855,115,0,479,1),(2856,99,0,479,1),(2857,93,0,479,50),(2858,143,0,479,169),(2859,97,0,480,1),(2860,134,0,480,2),(2861,115,0,480,1),(2862,99,0,480,1),(2863,93,0,480,58),(2864,143,0,480,169),(2865,97,0,481,1),(2866,134,0,481,2),(2867,115,0,481,1),(2868,99,0,481,1),(2869,93,0,481,49),(2870,143,0,481,170),(2871,97,0,482,1),(2872,134,0,482,2),(2873,115,0,482,1),(2874,99,0,482,1),(2875,93,0,482,50),(2876,143,0,482,170),(2877,97,0,483,1),(2878,134,0,483,2),(2879,115,0,483,1),(2880,99,0,483,1),(2881,93,0,483,58),(2882,143,0,483,170),(2883,97,0,484,1),(2884,134,0,484,2),(2885,115,0,484,1),(2886,99,0,484,4),(2887,144,0,484,0),(2888,145,0,484,0),(2889,146,0,484,1),(2890,147,0,484,0),(2891,148,0,484,0),(2892,97,0,485,1),(2893,134,0,485,2),(2894,115,0,485,1),(2895,99,0,485,1),(2896,93,0,485,50),(2897,143,0,485,166),(2898,97,0,486,1),(2899,134,0,486,2),(2900,115,0,486,1),(2901,99,0,486,1),(2902,93,0,486,53),(2903,143,0,486,166),(2904,97,0,487,1),(2905,134,0,487,2),(2906,115,0,487,1),(2907,99,0,487,1),(2908,93,0,487,60),(2909,143,0,487,166),(2910,97,0,488,1),(2911,134,0,488,2),(2912,115,0,488,1),(2913,99,0,488,1),(2914,93,0,488,50),(2915,143,0,488,167),(2916,97,0,489,1),(2917,134,0,489,2),(2918,115,0,489,1),(2919,99,0,489,1),(2920,93,0,489,53),(2921,143,0,489,167),(2922,97,0,490,1),(2923,134,0,490,2),(2924,115,0,490,1),(2925,99,0,490,1),(2926,93,0,490,60),(2927,143,0,490,167),(2928,97,0,491,1),(2929,134,0,491,2),(2930,115,0,491,1),(2931,99,0,491,1),(2932,93,0,491,50),(2933,143,0,491,168),(2934,97,0,492,1),(2935,134,0,492,2),(2936,115,0,492,1),(2937,99,0,492,1),(2938,93,0,492,53),(2939,143,0,492,168),(2940,97,0,493,1),(2941,134,0,493,2),(2942,115,0,493,1),(2943,99,0,493,1),(2944,93,0,493,60),(2945,143,0,493,168),(2946,97,0,494,1),(2947,134,0,494,2),(2948,115,0,494,1),(2949,99,0,494,1),(2950,93,0,494,50),(2951,143,0,494,169),(2952,97,0,495,1),(2953,134,0,495,2),(2954,115,0,495,1),(2955,99,0,495,1),(2956,93,0,495,53),(2957,143,0,495,169),(2958,97,0,496,1),(2959,134,0,496,2),(2960,115,0,496,1),(2961,99,0,496,1),(2962,93,0,496,60),(2963,143,0,496,169),(2964,97,0,497,1),(2965,134,0,497,2),(2966,115,0,497,1),(2967,99,0,497,1),(2968,93,0,497,50),(2969,143,0,497,170),(2970,97,0,498,1),(2971,134,0,498,2),(2972,115,0,498,1),(2973,99,0,498,1),(2974,93,0,498,53),(2975,143,0,498,170),(2976,97,0,499,1),(2977,134,0,499,2),(2978,115,0,499,1),(2979,99,0,499,1),(2980,93,0,499,60),(2981,143,0,499,170),(2982,97,0,500,1),(2983,134,0,500,2),(2984,115,0,500,1),(2985,99,0,500,4),(2986,144,0,500,0),(2987,145,0,500,1),(2988,146,0,500,0),(2989,147,0,500,0),(2990,148,0,500,1),(2991,97,0,501,1),(2992,134,0,501,2),(2993,115,0,501,1),(2994,99,0,501,1),(2995,93,0,501,49),(2996,143,0,501,166),(2997,97,0,502,1),(2998,134,0,502,2),(2999,115,0,502,1),(3000,99,0,502,1),(3001,93,0,502,50),(3002,143,0,502,166),(3003,97,0,503,1),(3004,134,0,503,2),(3005,115,0,503,1),(3006,99,0,503,1),(3007,93,0,503,58),(3008,143,0,503,166),(3009,97,0,504,1),(3010,134,0,504,2),(3011,115,0,504,1),(3012,99,0,504,1),(3013,93,0,504,49),(3014,143,0,504,167),(3015,97,0,505,1),(3016,134,0,505,2),(3017,115,0,505,1),(3018,99,0,505,1),(3019,93,0,505,50),(3020,143,0,505,167),(3021,97,0,506,1),(3022,134,0,506,2),(3023,115,0,506,1),(3024,99,0,506,1),(3025,93,0,506,58),(3026,143,0,506,167),(3027,97,0,507,1),(3028,134,0,507,2),(3029,115,0,507,1),(3030,99,0,507,1),(3031,93,0,507,49),(3032,143,0,507,168),(3033,97,0,508,1),(3034,134,0,508,2),(3035,115,0,508,1),(3036,99,0,508,1),(3037,93,0,508,50),(3038,143,0,508,168),(3039,97,0,509,1),(3040,134,0,509,2),(3041,115,0,509,1),(3042,99,0,509,1),(3043,93,0,509,58),(3044,143,0,509,168),(3045,97,0,510,1),(3046,134,0,510,2),(3047,115,0,510,1),(3048,99,0,510,1),(3049,93,0,510,49),(3050,143,0,510,169),(3051,97,0,511,1),(3052,134,0,511,2),(3053,115,0,511,1),(3054,99,0,511,1),(3055,93,0,511,50),(3056,143,0,511,169),(3057,97,0,512,1),(3058,134,0,512,2),(3059,115,0,512,1),(3060,99,0,512,1),(3061,93,0,512,58),(3062,143,0,512,169),(3063,97,0,513,1),(3064,134,0,513,2),(3065,115,0,513,1),(3066,99,0,513,1),(3067,93,0,513,49),(3068,143,0,513,170),(3069,97,0,514,1),(3070,134,0,514,2),(3071,115,0,514,1),(3072,99,0,514,1),(3073,93,0,514,50),(3074,143,0,514,170),(3075,97,0,515,1),(3076,134,0,515,2),(3077,115,0,515,1),(3078,99,0,515,1),(3079,93,0,515,58),(3080,143,0,515,170),(3081,97,0,516,1),(3082,134,0,516,2),(3083,115,0,516,1),(3084,99,0,516,4),(3085,144,0,516,0),(3086,145,0,516,0),(3087,146,0,516,0),(3088,147,0,516,1),(3089,148,0,516,0),(3090,97,0,517,1),(3091,134,0,517,2),(3092,115,0,517,1),(3093,99,0,517,1),(3094,93,0,517,52),(3095,143,0,517,166),(3096,97,0,518,1),(3097,134,0,518,2),(3098,115,0,518,1),(3099,99,0,518,1),(3100,93,0,518,53),(3101,143,0,518,166),(3102,97,0,519,1),(3103,134,0,519,2),(3104,115,0,519,1),(3105,99,0,519,1),(3106,93,0,519,56),(3107,143,0,519,166),(3108,97,0,520,1),(3109,134,0,520,2),(3110,115,0,520,1),(3111,99,0,520,1),(3112,93,0,520,52),(3113,143,0,520,167),(3114,97,0,521,1),(3115,134,0,521,2),(3116,115,0,521,1),(3117,99,0,521,1),(3118,93,0,521,53),(3119,143,0,521,167),(3120,97,0,522,1),(3121,134,0,522,2),(3122,115,0,522,1),(3123,99,0,522,1),(3124,93,0,522,56),(3125,143,0,522,167),(3126,97,0,523,1),(3127,134,0,523,2),(3128,115,0,523,1),(3129,99,0,523,1),(3130,93,0,523,52),(3131,143,0,523,168),(3132,97,0,524,1),(3133,134,0,524,2),(3134,115,0,524,1),(3135,99,0,524,1),(3136,93,0,524,53),(3137,143,0,524,168),(3138,97,0,525,1),(3139,134,0,525,2),(3140,115,0,525,1),(3141,99,0,525,1),(3142,93,0,525,56),(3143,143,0,525,168),(3144,97,0,526,1),(3145,134,0,526,2),(3146,115,0,526,1),(3147,99,0,526,1),(3148,93,0,526,52),(3149,143,0,526,169),(3150,97,0,527,1),(3151,134,0,527,2),(3152,115,0,527,1),(3153,99,0,527,1),(3154,93,0,527,53),(3155,143,0,527,169),(3156,97,0,528,1),(3157,134,0,528,2),(3158,115,0,528,1),(3159,99,0,528,1),(3160,93,0,528,56),(3161,143,0,528,169),(3162,97,0,529,1),(3163,134,0,529,2),(3164,115,0,529,1),(3165,99,0,529,1),(3166,93,0,529,52),(3167,143,0,529,170),(3168,97,0,530,1),(3169,134,0,530,2),(3170,115,0,530,1),(3171,99,0,530,1),(3172,93,0,530,53),(3173,143,0,530,170),(3174,97,0,531,1),(3175,134,0,531,2),(3176,115,0,531,1),(3177,99,0,531,1),(3178,93,0,531,56),(3179,143,0,531,170),(3180,97,0,532,1),(3181,134,0,532,2),(3182,115,0,532,1),(3183,99,0,532,4),(3184,144,0,532,0),(3185,145,0,532,1),(3186,146,0,532,1),(3187,147,0,532,0),(3188,148,0,532,0),(3189,97,0,533,1),(3190,134,0,533,2),(3191,115,0,533,1),(3192,99,0,533,1),(3193,93,0,533,50),(3194,143,0,533,166),(3195,97,0,534,1),(3196,134,0,534,2),(3197,115,0,534,1),(3198,99,0,534,1),(3199,93,0,534,53),(3200,143,0,534,166),(3201,97,0,535,1),(3202,134,0,535,2),(3203,115,0,535,1),(3204,99,0,535,1),(3205,93,0,535,60),(3206,143,0,535,166),(3207,97,0,536,1),(3208,134,0,536,2),(3209,115,0,536,1),(3210,99,0,536,1),(3211,93,0,536,50),(3212,143,0,536,167),(3213,97,0,537,1),(3214,134,0,537,2),(3215,115,0,537,1),(3216,99,0,537,1),(3217,93,0,537,53),(3218,143,0,537,167),(3219,97,0,538,1),(3220,134,0,538,2),(3221,115,0,538,1),(3222,99,0,538,1),(3223,93,0,538,60),(3224,143,0,538,167),(3225,97,0,539,1),(3226,134,0,539,2),(3227,115,0,539,1),(3228,99,0,539,1),(3229,93,0,539,50),(3230,143,0,539,168),(3231,97,0,540,1),(3232,134,0,540,2),(3233,115,0,540,1),(3234,99,0,540,1),(3235,93,0,540,53),(3236,143,0,540,168),(3237,97,0,541,1),(3238,134,0,541,2),(3239,115,0,541,1),(3240,99,0,541,1),(3241,93,0,541,60),(3242,143,0,541,168),(3243,97,0,542,1),(3244,134,0,542,2),(3245,115,0,542,1),(3246,99,0,542,1),(3247,93,0,542,50),(3248,143,0,542,169),(3249,97,0,543,1),(3250,134,0,543,2),(3251,115,0,543,1),(3252,99,0,543,1),(3253,93,0,543,53),(3254,143,0,543,169),(3255,97,0,544,1),(3256,134,0,544,2),(3257,115,0,544,1),(3258,99,0,544,1),(3259,93,0,544,60),(3260,143,0,544,169),(3261,97,0,545,1),(3262,134,0,545,2),(3263,115,0,545,1),(3264,99,0,545,1),(3265,93,0,545,50),(3266,143,0,545,170),(3267,97,0,546,1),(3268,134,0,546,2),(3269,115,0,546,1),(3270,99,0,546,1),(3271,93,0,546,53),(3272,143,0,546,170),(3273,97,0,547,1),(3274,134,0,547,2),(3275,115,0,547,1),(3276,99,0,547,1),(3277,93,0,547,60),(3278,143,0,547,170),(3279,97,0,548,1),(3280,134,0,548,2),(3281,115,0,548,1),(3282,99,0,548,4),(3283,144,0,548,0),(3284,145,0,548,0),(3285,146,0,548,0),(3286,147,0,548,1),(3287,148,0,548,0),(3288,97,0,549,1),(3289,134,0,549,2),(3290,115,0,549,1),(3291,99,0,549,1),(3292,93,0,549,49),(3293,143,0,549,166),(3294,97,0,550,1),(3295,134,0,550,2),(3296,115,0,550,1),(3297,99,0,550,1),(3298,93,0,550,51),(3299,143,0,550,166),(3300,97,0,551,1),(3301,134,0,551,2),(3302,115,0,551,1),(3303,99,0,551,1),(3304,93,0,551,60),(3305,143,0,551,166),(3306,97,0,552,1),(3307,134,0,552,2),(3308,115,0,552,1),(3309,99,0,552,1),(3310,93,0,552,49),(3311,143,0,552,167),(3312,97,0,553,1),(3313,134,0,553,2),(3314,115,0,553,1),(3315,99,0,553,1),(3316,93,0,553,51),(3317,143,0,553,167),(3318,97,0,554,1),(3319,134,0,554,2),(3320,115,0,554,1),(3321,99,0,554,1),(3322,93,0,554,60),(3323,143,0,554,167),(3324,97,0,555,1),(3325,134,0,555,2),(3326,115,0,555,1),(3327,99,0,555,1),(3328,93,0,555,49),(3329,143,0,555,168),(3330,97,0,556,1),(3331,134,0,556,2),(3332,115,0,556,1),(3333,99,0,556,1),(3334,93,0,556,51),(3335,143,0,556,168),(3336,97,0,557,1),(3337,134,0,557,2),(3338,115,0,557,1),(3339,99,0,557,1),(3340,93,0,557,60),(3341,143,0,557,168),(3342,97,0,558,1),(3343,134,0,558,2),(3344,115,0,558,1),(3345,99,0,558,1),(3346,93,0,558,49),(3347,143,0,558,169),(3348,97,0,559,1),(3349,134,0,559,2),(3350,115,0,559,1),(3351,99,0,559,1),(3352,93,0,559,51),(3353,143,0,559,169),(3354,97,0,560,1),(3355,134,0,560,2),(3356,115,0,560,1),(3357,99,0,560,1),(3358,93,0,560,60),(3359,143,0,560,169),(3360,97,0,561,1),(3361,134,0,561,2),(3362,115,0,561,1),(3363,99,0,561,1),(3364,93,0,561,49),(3365,143,0,561,170),(3366,97,0,562,1),(3367,134,0,562,2),(3368,115,0,562,1),(3369,99,0,562,1),(3370,93,0,562,51),(3371,143,0,562,170),(3372,97,0,563,1),(3373,134,0,563,2),(3374,115,0,563,1),(3375,99,0,563,1),(3376,93,0,563,60),(3377,143,0,563,170),(3378,97,0,564,1),(3379,134,0,564,2),(3380,115,0,564,1),(3381,99,0,564,4),(3382,144,0,564,0),(3383,145,0,564,0),(3384,146,0,564,0),(3385,147,0,564,0),(3386,148,0,564,0),(3387,97,0,565,1),(3388,134,0,565,2),(3389,115,0,565,1),(3390,99,0,565,1),(3391,93,0,565,49),(3392,143,0,565,166),(3393,97,0,566,1),(3394,134,0,566,2),(3395,115,0,566,1),(3396,99,0,566,1),(3397,93,0,566,50),(3398,143,0,566,166),(3399,97,0,567,1),(3400,134,0,567,2),(3401,115,0,567,1),(3402,99,0,567,1),(3403,93,0,567,52),(3404,143,0,567,166),(3405,97,0,568,1),(3406,134,0,568,2),(3407,115,0,568,1),(3408,99,0,568,1),(3409,93,0,568,49),(3410,143,0,568,167),(3411,97,0,569,1),(3412,134,0,569,2),(3413,115,0,569,1),(3414,99,0,569,1),(3415,93,0,569,50),(3416,143,0,569,167),(3417,97,0,570,1),(3418,134,0,570,2),(3419,115,0,570,1),(3420,99,0,570,1),(3421,93,0,570,52),(3422,143,0,570,167),(3423,97,0,571,1),(3424,134,0,571,2),(3425,115,0,571,1),(3426,99,0,571,1),(3427,93,0,571,49),(3428,143,0,571,168),(3429,97,0,572,1),(3430,134,0,572,2),(3431,115,0,572,1),(3432,99,0,572,1),(3433,93,0,572,50),(3434,143,0,572,168),(3435,97,0,573,1),(3436,134,0,573,2),(3437,115,0,573,1),(3438,99,0,573,1),(3439,93,0,573,52),(3440,143,0,573,168),(3441,97,0,574,1),(3442,134,0,574,2),(3443,115,0,574,1),(3444,99,0,574,1),(3445,93,0,574,49),(3446,143,0,574,169),(3447,97,0,575,1),(3448,134,0,575,2),(3449,115,0,575,1),(3450,99,0,575,1),(3451,93,0,575,50),(3452,143,0,575,169),(3453,97,0,576,1),(3454,134,0,576,2),(3455,115,0,576,1),(3456,99,0,576,1),(3457,93,0,576,52),(3458,143,0,576,169),(3459,97,0,577,1),(3460,134,0,577,2),(3461,115,0,577,1),(3462,99,0,577,1),(3463,93,0,577,49),(3464,143,0,577,170),(3465,97,0,578,1),(3466,134,0,578,2),(3467,115,0,578,1),(3468,99,0,578,1),(3469,93,0,578,50),(3470,143,0,578,170),(3471,97,0,579,1),(3472,134,0,579,2),(3473,115,0,579,1),(3474,99,0,579,1),(3475,93,0,579,52),(3476,143,0,579,170),(3477,97,0,580,1),(3478,134,0,580,2),(3479,115,0,580,1),(3480,99,0,580,4),(3481,144,0,580,0),(3482,145,0,580,0),(3483,146,0,580,0),(3484,147,0,580,0),(3485,148,0,580,1),(3486,97,0,581,1),(3487,134,0,581,2),(3488,115,0,581,1),(3489,99,0,581,1),(3490,93,0,581,49),(3491,143,0,581,166),(3492,97,0,582,1),(3493,134,0,582,2),(3494,115,0,582,1),(3495,99,0,582,1),(3496,93,0,582,50),(3497,143,0,582,166),(3498,97,0,583,1),(3499,134,0,583,2),(3500,115,0,583,1),(3501,99,0,583,1),(3502,93,0,583,58),(3503,143,0,583,166),(3504,97,0,584,1),(3505,134,0,584,2),(3506,115,0,584,1),(3507,99,0,584,1),(3508,93,0,584,49),(3509,143,0,584,167),(3510,97,0,585,1),(3511,134,0,585,2),(3512,115,0,585,1),(3513,99,0,585,1),(3514,93,0,585,50),(3515,143,0,585,167),(3516,97,0,586,1),(3517,134,0,586,2),(3518,115,0,586,1),(3519,99,0,586,1),(3520,93,0,586,58),(3521,143,0,586,167),(3522,97,0,587,1),(3523,134,0,587,2),(3524,115,0,587,1),(3525,99,0,587,1),(3526,93,0,587,49),(3527,143,0,587,168),(3528,97,0,588,1),(3529,134,0,588,2),(3530,115,0,588,1),(3531,99,0,588,1),(3532,93,0,588,50),(3533,143,0,588,168),(3534,97,0,589,1),(3535,134,0,589,2),(3536,115,0,589,1),(3537,99,0,589,1),(3538,93,0,589,58),(3539,143,0,589,168),(3540,97,0,590,1),(3541,134,0,590,2),(3542,115,0,590,1),(3543,99,0,590,1),(3544,93,0,590,49),(3545,143,0,590,169),(3546,97,0,591,1),(3547,134,0,591,2),(3548,115,0,591,1),(3549,99,0,591,1),(3550,93,0,591,50),(3551,143,0,591,169),(3552,97,0,592,1),(3553,134,0,592,2),(3554,115,0,592,1),(3555,99,0,592,1),(3556,93,0,592,58),(3557,143,0,592,169),(3558,97,0,593,1),(3559,134,0,593,2),(3560,115,0,593,1),(3561,99,0,593,1),(3562,93,0,593,49),(3563,143,0,593,170),(3564,97,0,594,1),(3565,134,0,594,2),(3566,115,0,594,1),(3567,99,0,594,1),(3568,93,0,594,50),(3569,143,0,594,170),(3570,97,0,595,1),(3571,134,0,595,2),(3572,115,0,595,1),(3573,99,0,595,1),(3574,93,0,595,58),(3575,143,0,595,170),(3576,97,0,596,1),(3577,134,0,596,2),(3578,115,0,596,1),(3579,99,0,596,4),(3580,144,0,596,0),(3581,145,0,596,0),(3582,146,0,596,0),(3583,147,0,596,0),(3584,148,0,596,0),(3585,97,0,597,1),(3586,134,0,597,2),(3587,115,0,597,1),(3588,99,0,597,1),(3589,93,0,597,49),(3590,143,0,597,166),(3591,97,0,598,1),(3592,134,0,598,2),(3593,115,0,598,1),(3594,99,0,598,1),(3595,93,0,598,53),(3596,143,0,598,166),(3597,97,0,599,1),(3598,134,0,599,2),(3599,115,0,599,1),(3600,99,0,599,1),(3601,93,0,599,59),(3602,143,0,599,166),(3603,97,0,600,1),(3604,134,0,600,2),(3605,115,0,600,1),(3606,99,0,600,1),(3607,93,0,600,49),(3608,143,0,600,167),(3609,97,0,601,1),(3610,134,0,601,2),(3611,115,0,601,1),(3612,99,0,601,1),(3613,93,0,601,53),(3614,143,0,601,167),(3615,97,0,602,1),(3616,134,0,602,2),(3617,115,0,602,1),(3618,99,0,602,1),(3619,93,0,602,59),(3620,143,0,602,167),(3621,97,0,603,1),(3622,134,0,603,2),(3623,115,0,603,1),(3624,99,0,603,1),(3625,93,0,603,49),(3626,143,0,603,168),(3627,97,0,604,1),(3628,134,0,604,2),(3629,115,0,604,1),(3630,99,0,604,1),(3631,93,0,604,53),(3632,143,0,604,168),(3633,97,0,605,1),(3634,134,0,605,2),(3635,115,0,605,1),(3636,99,0,605,1),(3637,93,0,605,59),(3638,143,0,605,168),(3639,97,0,606,1),(3640,134,0,606,2),(3641,115,0,606,1),(3642,99,0,606,1),(3643,93,0,606,49),(3644,143,0,606,169),(3645,97,0,607,1),(3646,134,0,607,2),(3647,115,0,607,1),(3648,99,0,607,1),(3649,93,0,607,53),(3650,143,0,607,169),(3651,97,0,608,1),(3652,134,0,608,2),(3653,115,0,608,1),(3654,99,0,608,1),(3655,93,0,608,59),(3656,143,0,608,169),(3657,97,0,609,1),(3658,134,0,609,2),(3659,115,0,609,1),(3660,99,0,609,1),(3661,93,0,609,49),(3662,143,0,609,170),(3663,97,0,610,1),(3664,134,0,610,2),(3665,115,0,610,1),(3666,99,0,610,1),(3667,93,0,610,53),(3668,143,0,610,170),(3669,97,0,611,1),(3670,134,0,611,2),(3671,115,0,611,1),(3672,99,0,611,1),(3673,93,0,611,59),(3674,143,0,611,170),(3675,97,0,612,1),(3676,134,0,612,2),(3677,115,0,612,1),(3678,99,0,612,4),(3679,144,0,612,0),(3680,145,0,612,0),(3681,146,0,612,0),(3682,147,0,612,0),(3683,148,0,612,0),(3684,97,0,613,1),(3685,134,0,613,2),(3686,115,0,613,1),(3687,99,0,613,1),(3688,93,0,613,49),(3689,143,0,613,166),(3690,97,0,614,1),(3691,134,0,614,2),(3692,115,0,614,1),(3693,99,0,614,1),(3694,93,0,614,50),(3695,143,0,614,166),(3696,97,0,615,1),(3697,134,0,615,2),(3698,115,0,615,1),(3699,99,0,615,1),(3700,93,0,615,58),(3701,143,0,615,166),(3702,97,0,616,1),(3703,134,0,616,2),(3704,115,0,616,1),(3705,99,0,616,1),(3706,93,0,616,49),(3707,143,0,616,167),(3708,97,0,617,1),(3709,134,0,617,2),(3710,115,0,617,1),(3711,99,0,617,1),(3712,93,0,617,50),(3713,143,0,617,167),(3714,97,0,618,1),(3715,134,0,618,2),(3716,115,0,618,1),(3717,99,0,618,1),(3718,93,0,618,58),(3719,143,0,618,167),(3720,97,0,619,1),(3721,134,0,619,2),(3722,115,0,619,1),(3723,99,0,619,1),(3724,93,0,619,49),(3725,143,0,619,168),(3726,97,0,620,1),(3727,134,0,620,2),(3728,115,0,620,1),(3729,99,0,620,1),(3730,93,0,620,50),(3731,143,0,620,168),(3732,97,0,621,1),(3733,134,0,621,2),(3734,115,0,621,1),(3735,99,0,621,1),(3736,93,0,621,58),(3737,143,0,621,168),(3738,97,0,622,1),(3739,134,0,622,2),(3740,115,0,622,1),(3741,99,0,622,1),(3742,93,0,622,49),(3743,143,0,622,169),(3744,97,0,623,1),(3745,134,0,623,2),(3746,115,0,623,1),(3747,99,0,623,1),(3748,93,0,623,50),(3749,143,0,623,169),(3750,97,0,624,1),(3751,134,0,624,2),(3752,115,0,624,1),(3753,99,0,624,1),(3754,93,0,624,58),(3755,143,0,624,169),(3756,97,0,625,1),(3757,134,0,625,2),(3758,115,0,625,1),(3759,99,0,625,1),(3760,93,0,625,49),(3761,143,0,625,170),(3762,97,0,626,1),(3763,134,0,626,2),(3764,115,0,626,1),(3765,99,0,626,1),(3766,93,0,626,50),(3767,143,0,626,170),(3768,97,0,627,1),(3769,134,0,627,2),(3770,115,0,627,1),(3771,99,0,627,1),(3772,93,0,627,58),(3773,143,0,627,170),(3774,97,0,628,1),(3775,134,0,628,2),(3776,115,0,628,1),(3777,99,0,628,4),(3778,144,0,628,0),(3779,145,0,628,0),(3780,146,0,628,1),(3781,147,0,628,1),(3782,148,0,628,0),(3783,97,0,629,1),(3784,134,0,629,2),(3785,115,0,629,1),(3786,99,0,629,1),(3787,93,0,629,52),(3788,143,0,629,166),(3789,97,0,630,1),(3790,134,0,630,2),(3791,115,0,630,1),(3792,99,0,630,1),(3793,93,0,630,56),(3794,143,0,630,166),(3795,97,0,631,1),(3796,134,0,631,2),(3797,115,0,631,1),(3798,99,0,631,1),(3799,93,0,631,58),(3800,143,0,631,166),(3801,97,0,632,1),(3802,134,0,632,2),(3803,115,0,632,1),(3804,99,0,632,1),(3805,93,0,632,52),(3806,143,0,632,167),(3807,97,0,633,1),(3808,134,0,633,2),(3809,115,0,633,1),(3810,99,0,633,1),(3811,93,0,633,56),(3812,143,0,633,167),(3813,97,0,634,1),(3814,134,0,634,2),(3815,115,0,634,1),(3816,99,0,634,1),(3817,93,0,634,58),(3818,143,0,634,167),(3819,97,0,635,1),(3820,134,0,635,2),(3821,115,0,635,1),(3822,99,0,635,1),(3823,93,0,635,52),(3824,143,0,635,168),(3825,97,0,636,1),(3826,134,0,636,2),(3827,115,0,636,1),(3828,99,0,636,1),(3829,93,0,636,56),(3830,143,0,636,168),(3831,97,0,637,1),(3832,134,0,637,2),(3833,115,0,637,1),(3834,99,0,637,1),(3835,93,0,637,58),(3836,143,0,637,168),(3837,97,0,638,1),(3838,134,0,638,2),(3839,115,0,638,1),(3840,99,0,638,1),(3841,93,0,638,52),(3842,143,0,638,169),(3843,97,0,639,1),(3844,134,0,639,2),(3845,115,0,639,1),(3846,99,0,639,1),(3847,93,0,639,56),(3848,143,0,639,169),(3849,97,0,640,1),(3850,134,0,640,2),(3851,115,0,640,1),(3852,99,0,640,1),(3853,93,0,640,58),(3854,143,0,640,169),(3855,97,0,641,1),(3856,134,0,641,2),(3857,115,0,641,1),(3858,99,0,641,1),(3859,93,0,641,52),(3860,143,0,641,170),(3861,97,0,642,1),(3862,134,0,642,2),(3863,115,0,642,1),(3864,99,0,642,1),(3865,93,0,642,56),(3866,143,0,642,170),(3867,97,0,643,1),(3868,134,0,643,2),(3869,115,0,643,1),(3870,99,0,643,1),(3871,93,0,643,58),(3872,143,0,643,170),(3873,97,0,644,1),(3874,134,0,644,2),(3875,115,0,644,1),(3876,99,0,644,4),(3877,144,0,644,0),(3878,145,0,644,0),(3879,146,0,644,0),(3880,147,0,644,0),(3881,148,0,644,0),(3882,97,0,645,1),(3883,134,0,645,2),(3884,115,0,645,1),(3885,99,0,645,1),(3886,93,0,645,52),(3887,143,0,645,166),(3888,97,0,646,1),(3889,134,0,646,2),(3890,115,0,646,1),(3891,99,0,646,1),(3892,93,0,646,58),(3893,143,0,646,166),(3894,97,0,647,1),(3895,134,0,647,2),(3896,115,0,647,1),(3897,99,0,647,1),(3898,93,0,647,59),(3899,143,0,647,166),(3900,97,0,648,1),(3901,134,0,648,2),(3902,115,0,648,1),(3903,99,0,648,1),(3904,93,0,648,52),(3905,143,0,648,167),(3906,97,0,649,1),(3907,134,0,649,2),(3908,115,0,649,1),(3909,99,0,649,1),(3910,93,0,649,58),(3911,143,0,649,167),(3912,97,0,650,1),(3913,134,0,650,2),(3914,115,0,650,1),(3915,99,0,650,1),(3916,93,0,650,59),(3917,143,0,650,167),(3918,97,0,651,1),(3919,134,0,651,2),(3920,115,0,651,1),(3921,99,0,651,1),(3922,93,0,651,52),(3923,143,0,651,168),(3924,97,0,652,1),(3925,134,0,652,2),(3926,115,0,652,1),(3927,99,0,652,1),(3928,93,0,652,58),(3929,143,0,652,168),(3930,97,0,653,1),(3931,134,0,653,2),(3932,115,0,653,1),(3933,99,0,653,1),(3934,93,0,653,59),(3935,143,0,653,168),(3936,97,0,654,1),(3937,134,0,654,2),(3938,115,0,654,1),(3939,99,0,654,1),(3940,93,0,654,52),(3941,143,0,654,169),(3942,97,0,655,1),(3943,134,0,655,2),(3944,115,0,655,1),(3945,99,0,655,1),(3946,93,0,655,58),(3947,143,0,655,169),(3948,97,0,656,1),(3949,134,0,656,2),(3950,115,0,656,1),(3951,99,0,656,1),(3952,93,0,656,59),(3953,143,0,656,169),(3954,97,0,657,1),(3955,134,0,657,2),(3956,115,0,657,1),(3957,99,0,657,1),(3958,93,0,657,52),(3959,143,0,657,170),(3960,97,0,658,1),(3961,134,0,658,2),(3962,115,0,658,1),(3963,99,0,658,1),(3964,93,0,658,58),(3965,143,0,658,170),(3966,97,0,659,1),(3967,134,0,659,2),(3968,115,0,659,1),(3969,99,0,659,1),(3970,93,0,659,59),(3971,143,0,659,170),(3972,97,0,660,1),(3973,134,0,660,2),(3974,115,0,660,1),(3975,99,0,660,4),(3976,144,0,660,0),(3977,145,0,660,0),(3978,146,0,660,0),(3979,147,0,660,0),(3980,148,0,660,0),(3981,97,0,661,1),(3982,134,0,661,2),(3983,115,0,661,1),(3984,99,0,661,1),(3985,93,0,661,50),(3986,143,0,661,166),(3987,97,0,662,1),(3988,134,0,662,2),(3989,115,0,662,1),(3990,99,0,662,1),(3991,93,0,662,58),(3992,143,0,662,166),(3993,97,0,663,1),(3994,134,0,663,2),(3995,115,0,663,1),(3996,99,0,663,1),(3997,93,0,663,60),(3998,143,0,663,166),(3999,97,0,664,1),(4000,134,0,664,2),(4001,115,0,664,1),(4002,99,0,664,1),(4003,93,0,664,50),(4004,143,0,664,167),(4005,97,0,665,1),(4006,134,0,665,2),(4007,115,0,665,1),(4008,99,0,665,1),(4009,93,0,665,58),(4010,143,0,665,167),(4011,97,0,666,1),(4012,134,0,666,2),(4013,115,0,666,1),(4014,99,0,666,1),(4015,93,0,666,60),(4016,143,0,666,167),(4017,97,0,667,1),(4018,134,0,667,2),(4019,115,0,667,1),(4020,99,0,667,1),(4021,93,0,667,50),(4022,143,0,667,168),(4023,97,0,668,1),(4024,134,0,668,2),(4025,115,0,668,1),(4026,99,0,668,1),(4027,93,0,668,58),(4028,143,0,668,168),(4029,97,0,669,1),(4030,134,0,669,2),(4031,115,0,669,1),(4032,99,0,669,1),(4033,93,0,669,60),(4034,143,0,669,168),(4035,97,0,670,1),(4036,134,0,670,2),(4037,115,0,670,1),(4038,99,0,670,1),(4039,93,0,670,50),(4040,143,0,670,169),(4041,97,0,671,1),(4042,134,0,671,2),(4043,115,0,671,1),(4044,99,0,671,1),(4045,93,0,671,58),(4046,143,0,671,169),(4047,97,0,672,1),(4048,134,0,672,2),(4049,115,0,672,1),(4050,99,0,672,1),(4051,93,0,672,60),(4052,143,0,672,169),(4053,97,0,673,1),(4054,134,0,673,2),(4055,115,0,673,1),(4056,99,0,673,1),(4057,93,0,673,50),(4058,143,0,673,170),(4059,97,0,674,1),(4060,134,0,674,2),(4061,115,0,674,1),(4062,99,0,674,1),(4063,93,0,674,58),(4064,143,0,674,170),(4065,97,0,675,1),(4066,134,0,675,2),(4067,115,0,675,1),(4068,99,0,675,1),(4069,93,0,675,60),(4070,143,0,675,170),(4071,97,0,676,1),(4072,134,0,676,2),(4073,115,0,676,1),(4074,99,0,676,4),(4075,144,0,676,0),(4076,145,0,676,0),(4077,146,0,676,0),(4078,147,0,676,0),(4079,148,0,676,0),(4080,97,0,677,1),(4081,134,0,677,2),(4082,115,0,677,1),(4083,99,0,677,1),(4084,93,0,677,50),(4085,143,0,677,166),(4086,97,0,678,1),(4087,134,0,678,2),(4088,115,0,678,1),(4089,99,0,678,1),(4090,93,0,678,50),(4091,143,0,678,167),(4092,97,0,679,1),(4093,134,0,679,2),(4094,115,0,679,1),(4095,99,0,679,1),(4096,93,0,679,50),(4097,143,0,679,168),(4098,97,0,680,1),(4099,134,0,680,2),(4100,115,0,680,1),(4101,99,0,680,1),(4102,93,0,680,50),(4103,143,0,680,169),(4104,97,0,681,1),(4105,134,0,681,2),(4106,115,0,681,1),(4107,99,0,681,1),(4108,93,0,681,50),(4109,143,0,681,170),(4110,97,0,682,1),(4111,134,0,682,2),(4112,115,0,682,1),(4113,99,0,682,4),(4114,144,0,682,0),(4115,145,0,682,1),(4116,146,0,682,1),(4117,147,0,682,1),(4118,148,0,682,0),(4119,97,0,683,1),(4120,134,0,683,2),(4121,115,0,683,1),(4122,99,0,683,1),(4123,93,0,683,50),(4124,143,0,683,166),(4125,97,0,684,1),(4126,134,0,684,2),(4127,115,0,684,1),(4128,99,0,684,1),(4129,93,0,684,50),(4130,143,0,684,167),(4131,97,0,685,1),(4132,134,0,685,2),(4133,115,0,685,1),(4134,99,0,685,1),(4135,93,0,685,50),(4136,143,0,685,168),(4137,97,0,686,1),(4138,134,0,686,2),(4139,115,0,686,1),(4140,99,0,686,1),(4141,93,0,686,50),(4142,143,0,686,169),(4143,97,0,687,1),(4144,134,0,687,2),(4145,115,0,687,1),(4146,99,0,687,1),(4147,93,0,687,50),(4148,143,0,687,170),(4149,97,0,688,1),(4150,134,0,688,2),(4151,115,0,688,1),(4152,99,0,688,4),(4153,144,0,688,0),(4154,145,0,688,1),(4155,146,0,688,0),(4156,147,0,688,0),(4157,148,0,688,0),(4158,97,0,689,1),(4159,134,0,689,2),(4160,115,0,689,1),(4161,99,0,689,1),(4162,93,0,689,49),(4163,143,0,689,166),(4164,97,0,690,1),(4165,134,0,690,2),(4166,115,0,690,1),(4167,99,0,690,1),(4168,93,0,690,49),(4169,143,0,690,167),(4170,97,0,691,1),(4171,134,0,691,2),(4172,115,0,691,1),(4173,99,0,691,1),(4174,93,0,691,49),(4175,143,0,691,168),(4176,97,0,692,1),(4177,134,0,692,2),(4178,115,0,692,1),(4179,99,0,692,1),(4180,93,0,692,49),(4181,143,0,692,169),(4182,97,0,693,1),(4183,134,0,693,2),(4184,115,0,693,1),(4185,99,0,693,1),(4186,93,0,693,49),(4187,143,0,693,170),(4188,97,0,694,1),(4189,134,0,694,2),(4190,115,0,694,1),(4191,99,0,694,4),(4192,144,0,694,0),(4193,145,0,694,1),(4194,146,0,694,0),(4195,147,0,694,0),(4196,148,0,694,0),(4197,97,0,695,1),(4198,134,0,695,2),(4199,115,0,695,1),(4200,99,0,695,1),(4201,93,0,695,52),(4202,143,0,695,166),(4203,97,0,696,1),(4204,134,0,696,2),(4205,115,0,696,1),(4206,99,0,696,1),(4207,93,0,696,52),(4208,143,0,696,167),(4209,97,0,697,1),(4210,134,0,697,2),(4211,115,0,697,1),(4212,99,0,697,1),(4213,93,0,697,52),(4214,143,0,697,168),(4215,97,0,698,1),(4216,134,0,698,2),(4217,115,0,698,1),(4218,99,0,698,1),(4219,93,0,698,52),(4220,143,0,698,169),(4221,97,0,699,1),(4222,134,0,699,2),(4223,115,0,699,1),(4224,99,0,699,1),(4225,93,0,699,52),(4226,143,0,699,170),(4227,97,0,700,1),(4228,134,0,700,2),(4229,115,0,700,1),(4230,99,0,700,4),(4231,144,0,700,1),(4232,145,0,700,0),(4233,146,0,700,0),(4234,147,0,700,0),(4235,148,0,700,0),(4236,97,0,701,1),(4237,134,0,701,2),(4238,115,0,701,1),(4239,99,0,701,1),(4240,93,0,701,53),(4241,143,0,701,166),(4242,97,0,702,1),(4243,134,0,702,2),(4244,115,0,702,1),(4245,99,0,702,1),(4246,93,0,702,53),(4247,143,0,702,167),(4248,97,0,703,1),(4249,134,0,703,2),(4250,115,0,703,1),(4251,99,0,703,1),(4252,93,0,703,53),(4253,143,0,703,168),(4254,97,0,704,1),(4255,134,0,704,2),(4256,115,0,704,1),(4257,99,0,704,1),(4258,93,0,704,53),(4259,143,0,704,169),(4260,97,0,705,1),(4261,134,0,705,2),(4262,115,0,705,1),(4263,99,0,705,1),(4264,93,0,705,53),(4265,143,0,705,170),(4266,97,0,706,1),(4267,134,0,706,2),(4268,115,0,706,1),(4269,99,0,706,4),(4270,144,0,706,0),(4271,145,0,706,0),(4272,146,0,706,1),(4273,147,0,706,1),(4274,148,0,706,0),(4275,97,0,707,1),(4276,134,0,707,2),(4277,115,0,707,1),(4278,99,0,707,1),(4279,93,0,707,50),(4280,143,0,707,166),(4281,97,0,708,1),(4282,134,0,708,2),(4283,115,0,708,1),(4284,99,0,708,1),(4285,93,0,708,50),(4286,143,0,708,167),(4287,97,0,709,1),(4288,134,0,709,2),(4289,115,0,709,1),(4290,99,0,709,1),(4291,93,0,709,50),(4292,143,0,709,168),(4293,97,0,710,1),(4294,134,0,710,2),(4295,115,0,710,1),(4296,99,0,710,1),(4297,93,0,710,50),(4298,143,0,710,169),(4299,97,0,711,1),(4300,134,0,711,2),(4301,115,0,711,1),(4302,99,0,711,1),(4303,93,0,711,50),(4304,143,0,711,170),(4305,97,0,712,1),(4306,134,0,712,2),(4307,115,0,712,1),(4308,99,0,712,4),(4309,144,0,712,0),(4310,145,0,712,0),(4311,146,0,712,0),(4312,147,0,712,1),(4313,148,0,712,0),(4314,97,0,713,1),(4315,134,0,713,2),(4316,115,0,713,1),(4317,99,0,713,1),(4318,93,0,713,60),(4319,143,0,713,166),(4320,97,0,714,1),(4321,134,0,714,2),(4322,115,0,714,1),(4323,99,0,714,1),(4324,93,0,714,60),(4325,143,0,714,167),(4326,97,0,715,1),(4327,134,0,715,2),(4328,115,0,715,1),(4329,99,0,715,1),(4330,93,0,715,60),(4331,143,0,715,168),(4332,97,0,716,1),(4333,134,0,716,2),(4334,115,0,716,1),(4335,99,0,716,1),(4336,93,0,716,60),(4337,143,0,716,169),(4338,97,0,717,1),(4339,134,0,717,2),(4340,115,0,717,1),(4341,99,0,717,1),(4342,93,0,717,60),(4343,143,0,717,170),(4344,97,0,718,1),(4345,134,0,718,2),(4346,115,0,718,1),(4347,99,0,718,4),(4348,144,0,718,0),(4349,145,0,718,0),(4350,146,0,718,0),(4351,147,0,718,0),(4352,148,0,718,1),(4353,97,0,719,1),(4354,134,0,719,2),(4355,115,0,719,1),(4356,99,0,719,1),(4357,93,0,719,50),(4358,143,0,719,166),(4359,97,0,720,1),(4360,134,0,720,2),(4361,115,0,720,1),(4362,99,0,720,1),(4363,93,0,720,50),(4364,143,0,720,167),(4365,97,0,721,1),(4366,134,0,721,2),(4367,115,0,721,1),(4368,99,0,721,1),(4369,93,0,721,50),(4370,143,0,721,168),(4371,97,0,722,1),(4372,134,0,722,2),(4373,115,0,722,1),(4374,99,0,722,1),(4375,93,0,722,50),(4376,143,0,722,169),(4377,97,0,723,1),(4378,134,0,723,2),(4379,115,0,723,1),(4380,99,0,723,1),(4381,93,0,723,50),(4382,143,0,723,170),(4383,97,0,724,1),(4384,134,0,724,2),(4385,115,0,724,1),(4386,99,0,724,4),(4387,144,0,724,1),(4388,145,0,724,0),(4389,146,0,724,0),(4390,147,0,724,0),(4391,148,0,724,1),(4392,97,0,725,1),(4393,134,0,725,2),(4394,115,0,725,1),(4395,99,0,725,1),(4396,93,0,725,50),(4397,143,0,725,166),(4398,97,0,726,1),(4399,134,0,726,2),(4400,115,0,726,1),(4401,99,0,726,1),(4402,93,0,726,50),(4403,143,0,726,167),(4404,97,0,727,1),(4405,134,0,727,2),(4406,115,0,727,1),(4407,99,0,727,1),(4408,93,0,727,50),(4409,143,0,727,168),(4410,97,0,728,1),(4411,134,0,728,2),(4412,115,0,728,1),(4413,99,0,728,1),(4414,93,0,728,50),(4415,143,0,728,169),(4416,97,0,729,1),(4417,134,0,729,2),(4418,115,0,729,1),(4419,99,0,729,1),(4420,93,0,729,50),(4421,143,0,729,170),(4422,97,0,730,1),(4423,134,0,730,2),(4424,115,0,730,1),(4425,99,0,730,4),(4426,144,0,730,0),(4427,145,0,730,0),(4428,146,0,730,0),(4429,147,0,730,0),(4430,148,0,730,1),(4431,97,0,731,1),(4432,134,0,731,2),(4433,115,0,731,1),(4434,99,0,731,1),(4435,93,0,731,49),(4436,143,0,731,175),(4437,97,0,732,1),(4438,134,0,732,2),(4439,115,0,732,1),(4440,99,0,732,1),(4441,93,0,732,52),(4442,143,0,732,175),(4443,97,0,733,1),(4444,134,0,733,2),(4445,115,0,733,1),(4446,99,0,733,1),(4447,93,0,733,57),(4448,143,0,733,175),(4449,97,0,734,1),(4450,134,0,734,2),(4451,115,0,734,1),(4452,99,0,734,1),(4453,93,0,734,49),(4454,143,0,734,176),(4455,97,0,735,1),(4456,134,0,735,2),(4457,115,0,735,1),(4458,99,0,735,1),(4459,93,0,735,52),(4460,143,0,735,176),(4461,97,0,736,1),(4462,134,0,736,2),(4463,115,0,736,1),(4464,99,0,736,1),(4465,93,0,736,57),(4466,143,0,736,176),(4467,97,0,737,1),(4468,134,0,737,2),(4469,115,0,737,1),(4470,99,0,737,1),(4471,93,0,737,49),(4472,143,0,737,177),(4473,97,0,738,1),(4474,134,0,738,2),(4475,115,0,738,1),(4476,99,0,738,1),(4477,93,0,738,52),(4478,143,0,738,177),(4479,97,0,739,1),(4480,134,0,739,2),(4481,115,0,739,1),(4482,99,0,739,1),(4483,93,0,739,57),(4484,143,0,739,177),(4485,97,0,740,1),(4486,134,0,740,2),(4487,115,0,740,1),(4488,99,0,740,1),(4489,93,0,740,49),(4490,143,0,740,178),(4491,97,0,741,1),(4492,134,0,741,2),(4493,115,0,741,1),(4494,99,0,741,1),(4495,93,0,741,52),(4496,143,0,741,178),(4497,97,0,742,1),(4498,134,0,742,2),(4499,115,0,742,1),(4500,99,0,742,1),(4501,93,0,742,57),(4502,143,0,742,178),(4503,97,0,743,1),(4504,134,0,743,2),(4505,115,0,743,1),(4506,99,0,743,4),(4507,144,0,743,0),(4508,145,0,743,0),(4509,146,0,743,0),(4510,147,0,743,0),(4511,148,0,743,0),(4512,97,0,744,1),(4513,134,0,744,2),(4514,115,0,744,1),(4515,99,0,744,1),(4516,93,0,744,50),(4517,143,0,744,175),(4518,97,0,745,1),(4519,134,0,745,2),(4520,115,0,745,1),(4521,99,0,745,1),(4522,93,0,745,52),(4523,143,0,745,175),(4524,97,0,746,1),(4525,134,0,746,2),(4526,115,0,746,1),(4527,99,0,746,1),(4528,93,0,746,58),(4529,143,0,746,175),(4530,97,0,747,1),(4531,134,0,747,2),(4532,115,0,747,1),(4533,99,0,747,1),(4534,93,0,747,50),(4535,143,0,747,176),(4536,97,0,748,1),(4537,134,0,748,2),(4538,115,0,748,1),(4539,99,0,748,1),(4540,93,0,748,52),(4541,143,0,748,176),(4542,97,0,749,1),(4543,134,0,749,2),(4544,115,0,749,1),(4545,99,0,749,1),(4546,93,0,749,58),(4547,143,0,749,176),(4548,97,0,750,1),(4549,134,0,750,2),(4550,115,0,750,1),(4551,99,0,750,1),(4552,93,0,750,50),(4553,143,0,750,177),(4554,97,0,751,1),(4555,134,0,751,2),(4556,115,0,751,1),(4557,99,0,751,1),(4558,93,0,751,52),(4559,143,0,751,177),(4560,97,0,752,1),(4561,134,0,752,2),(4562,115,0,752,1),(4563,99,0,752,1),(4564,93,0,752,58),(4565,143,0,752,177),(4566,97,0,753,1),(4567,134,0,753,2),(4568,115,0,753,1),(4569,99,0,753,1),(4570,93,0,753,50),(4571,143,0,753,178),(4572,97,0,754,1),(4573,134,0,754,2),(4574,115,0,754,1),(4575,99,0,754,1),(4576,93,0,754,52),(4577,143,0,754,178),(4578,97,0,755,1),(4579,134,0,755,2),(4580,115,0,755,1),(4581,99,0,755,1),(4582,93,0,755,58),(4583,143,0,755,178),(4584,97,0,756,1),(4585,134,0,756,2),(4586,115,0,756,1),(4587,99,0,756,4),(4588,144,0,756,0),(4589,145,0,756,1),(4590,146,0,756,0),(4591,147,0,756,0),(4592,148,0,756,0),(4593,97,0,757,1),(4594,134,0,757,2),(4595,115,0,757,1),(4596,99,0,757,1),(4597,93,0,757,50),(4598,143,0,757,175),(4599,97,0,758,1),(4600,134,0,758,2),(4601,115,0,758,1),(4602,99,0,758,1),(4603,93,0,758,53),(4604,143,0,758,175),(4605,97,0,759,1),(4606,134,0,759,2),(4607,115,0,759,1),(4608,99,0,759,1),(4609,93,0,759,58),(4610,143,0,759,175),(4611,97,0,760,1),(4612,134,0,760,2),(4613,115,0,760,1),(4614,99,0,760,1),(4615,93,0,760,50),(4616,143,0,760,176),(4617,97,0,761,1),(4618,134,0,761,2),(4619,115,0,761,1),(4620,99,0,761,1),(4621,93,0,761,53),(4622,143,0,761,176),(4623,97,0,762,1),(4624,134,0,762,2),(4625,115,0,762,1),(4626,99,0,762,1),(4627,93,0,762,58),(4628,143,0,762,176),(4629,97,0,763,1),(4630,134,0,763,2),(4631,115,0,763,1),(4632,99,0,763,1),(4633,93,0,763,50),(4634,143,0,763,177),(4635,97,0,764,1),(4636,134,0,764,2),(4637,115,0,764,1),(4638,99,0,764,1),(4639,93,0,764,53),(4640,143,0,764,177),(4641,97,0,765,1),(4642,134,0,765,2),(4643,115,0,765,1),(4644,99,0,765,1),(4645,93,0,765,58),(4646,143,0,765,177),(4647,97,0,766,1),(4648,134,0,766,2),(4649,115,0,766,1),(4650,99,0,766,1),(4651,93,0,766,50),(4652,143,0,766,178),(4653,97,0,767,1),(4654,134,0,767,2),(4655,115,0,767,1),(4656,99,0,767,1),(4657,93,0,767,53),(4658,143,0,767,178),(4659,97,0,768,1),(4660,134,0,768,2),(4661,115,0,768,1),(4662,99,0,768,1),(4663,93,0,768,58),(4664,143,0,768,178),(4665,97,0,769,1),(4666,134,0,769,2),(4667,115,0,769,1),(4668,99,0,769,4),(4669,144,0,769,0),(4670,145,0,769,0),(4671,146,0,769,0),(4672,147,0,769,1),(4673,148,0,769,0),(4674,97,0,770,1),(4675,134,0,770,2),(4676,115,0,770,1),(4677,99,0,770,1),(4678,93,0,770,49),(4679,143,0,770,175),(4680,97,0,771,1),(4681,134,0,771,2),(4682,115,0,771,1),(4683,99,0,771,1),(4684,93,0,771,52),(4685,143,0,771,175),(4686,97,0,772,1),(4687,134,0,772,2),(4688,115,0,772,1),(4689,99,0,772,1),(4690,93,0,772,53),(4691,143,0,772,175),(4692,97,0,773,1),(4693,134,0,773,2),(4694,115,0,773,1),(4695,99,0,773,1),(4696,93,0,773,49),(4697,143,0,773,176),(4698,97,0,774,1),(4699,134,0,774,2),(4700,115,0,774,1),(4701,99,0,774,1),(4702,93,0,774,52),(4703,143,0,774,176),(4704,97,0,775,1),(4705,134,0,775,2),(4706,115,0,775,1),(4707,99,0,775,1),(4708,93,0,775,53),(4709,143,0,775,176),(4710,97,0,776,1),(4711,134,0,776,2),(4712,115,0,776,1),(4713,99,0,776,1),(4714,93,0,776,49),(4715,143,0,776,177),(4716,97,0,777,1),(4717,134,0,777,2),(4718,115,0,777,1),(4719,99,0,777,1),(4720,93,0,777,52),(4721,143,0,777,177),(4722,97,0,778,1),(4723,134,0,778,2),(4724,115,0,778,1),(4725,99,0,778,1),(4726,93,0,778,53),(4727,143,0,778,177),(4728,97,0,779,1),(4729,134,0,779,2),(4730,115,0,779,1),(4731,99,0,779,1),(4732,93,0,779,49),(4733,143,0,779,178),(4734,97,0,780,1),(4735,134,0,780,2),(4736,115,0,780,1),(4737,99,0,780,1),(4738,93,0,780,52),(4739,143,0,780,178),(4740,97,0,781,1),(4741,134,0,781,2),(4742,115,0,781,1),(4743,99,0,781,1),(4744,93,0,781,53),(4745,143,0,781,178),(4746,97,0,782,1),(4747,134,0,782,2),(4748,115,0,782,1),(4749,99,0,782,4),(4750,144,0,782,0),(4751,145,0,782,0),(4752,146,0,782,0),(4753,147,0,782,0),(4754,148,0,782,0),(4755,97,0,783,1),(4756,134,0,783,2),(4757,115,0,783,1),(4758,99,0,783,1),(4759,93,0,783,49),(4760,143,0,783,175),(4761,97,0,784,1),(4762,134,0,784,2),(4763,115,0,784,1),(4764,99,0,784,1),(4765,93,0,784,50),(4766,143,0,784,175),(4767,97,0,785,1),(4768,134,0,785,2),(4769,115,0,785,1),(4770,99,0,785,1),(4771,93,0,785,53),(4772,143,0,785,175),(4773,97,0,786,1),(4774,134,0,786,2),(4775,115,0,786,1),(4776,99,0,786,1),(4777,93,0,786,49),(4778,143,0,786,176),(4779,97,0,787,1),(4780,134,0,787,2),(4781,115,0,787,1),(4782,99,0,787,1),(4783,93,0,787,50),(4784,143,0,787,176),(4785,97,0,788,1),(4786,134,0,788,2),(4787,115,0,788,1),(4788,99,0,788,1),(4789,93,0,788,53),(4790,143,0,788,176),(4791,97,0,789,1),(4792,134,0,789,2),(4793,115,0,789,1),(4794,99,0,789,1),(4795,93,0,789,49),(4796,143,0,789,177),(4797,97,0,790,1),(4798,134,0,790,2),(4799,115,0,790,1),(4800,99,0,790,1),(4801,93,0,790,50),(4802,143,0,790,177),(4803,97,0,791,1),(4804,134,0,791,2),(4805,115,0,791,1),(4806,99,0,791,1),(4807,93,0,791,53),(4808,143,0,791,177),(4809,97,0,792,1),(4810,134,0,792,2),(4811,115,0,792,1),(4812,99,0,792,1),(4813,93,0,792,49),(4814,143,0,792,178),(4815,97,0,793,1),(4816,134,0,793,2),(4817,115,0,793,1),(4818,99,0,793,1),(4819,93,0,793,50),(4820,143,0,793,178),(4821,97,0,794,1),(4822,134,0,794,2),(4823,115,0,794,1),(4824,99,0,794,1),(4825,93,0,794,53),(4826,143,0,794,178),(4827,97,0,795,1),(4828,134,0,795,2),(4829,115,0,795,1),(4830,99,0,795,4),(4831,144,0,795,0),(4832,145,0,795,0),(4833,146,0,795,0),(4834,147,0,795,1),(4835,148,0,795,0),(4836,97,0,796,1),(4837,134,0,796,2),(4838,115,0,796,1),(4839,99,0,796,1),(4840,93,0,796,52),(4841,143,0,796,175),(4842,97,0,797,1),(4843,134,0,797,2),(4844,115,0,797,1),(4845,99,0,797,1),(4846,93,0,797,53),(4847,143,0,797,175),(4848,97,0,798,1),(4849,134,0,798,2),(4850,115,0,798,1),(4851,99,0,798,1),(4852,93,0,798,56),(4853,143,0,798,175),(4854,97,0,799,1),(4855,134,0,799,2),(4856,115,0,799,1),(4857,99,0,799,1),(4858,93,0,799,52),(4859,143,0,799,176),(4860,97,0,800,1),(4861,134,0,800,2),(4862,115,0,800,1),(4863,99,0,800,1),(4864,93,0,800,53),(4865,143,0,800,176),(4866,97,0,801,1),(4867,134,0,801,2),(4868,115,0,801,1),(4869,99,0,801,1),(4870,93,0,801,56),(4871,143,0,801,176),(4872,97,0,802,1),(4873,134,0,802,2),(4874,115,0,802,1),(4875,99,0,802,1),(4876,93,0,802,52),(4877,143,0,802,177),(4878,97,0,803,1),(4879,134,0,803,2),(4880,115,0,803,1),(4881,99,0,803,1),(4882,93,0,803,53),(4883,143,0,803,177),(4884,97,0,804,1),(4885,134,0,804,2),(4886,115,0,804,1),(4887,99,0,804,1),(4888,93,0,804,56),(4889,143,0,804,177),(4890,97,0,805,1),(4891,134,0,805,2),(4892,115,0,805,1),(4893,99,0,805,1),(4894,93,0,805,52),(4895,143,0,805,178),(4896,97,0,806,1),(4897,134,0,806,2),(4898,115,0,806,1),(4899,99,0,806,1),(4900,93,0,806,53),(4901,143,0,806,178),(4902,97,0,807,1),(4903,134,0,807,2),(4904,115,0,807,1),(4905,99,0,807,1),(4906,93,0,807,56),(4907,143,0,807,178),(4908,97,0,808,1),(4909,134,0,808,2),(4910,115,0,808,1),(4911,99,0,808,4),(4912,144,0,808,1),(4913,145,0,808,0),(4914,146,0,808,0),(4915,147,0,808,0),(4916,148,0,808,0),(4917,97,0,809,1),(4918,134,0,809,2),(4919,115,0,809,1),(4920,99,0,809,1),(4921,93,0,809,49),(4922,143,0,809,175),(4923,97,0,810,1),(4924,134,0,810,2),(4925,115,0,810,1),(4926,99,0,810,1),(4927,93,0,810,50),(4928,143,0,810,175),(4929,97,0,811,1),(4930,134,0,811,2),(4931,115,0,811,1),(4932,99,0,811,1),(4933,93,0,811,57),(4934,143,0,811,175),(4935,97,0,812,1),(4936,134,0,812,2),(4937,115,0,812,1),(4938,99,0,812,1),(4939,93,0,812,49),(4940,143,0,812,176),(4941,97,0,813,1),(4942,134,0,813,2),(4943,115,0,813,1),(4944,99,0,813,1),(4945,93,0,813,50),(4946,143,0,813,176),(4947,97,0,814,1),(4948,134,0,814,2),(4949,115,0,814,1),(4950,99,0,814,1),(4951,93,0,814,57),(4952,143,0,814,176),(4953,97,0,815,1),(4954,134,0,815,2),(4955,115,0,815,1),(4956,99,0,815,1),(4957,93,0,815,49),(4958,143,0,815,177),(4959,97,0,816,1),(4960,134,0,816,2),(4961,115,0,816,1),(4962,99,0,816,1),(4963,93,0,816,50),(4964,143,0,816,177),(4965,97,0,817,1),(4966,134,0,817,2),(4967,115,0,817,1),(4968,99,0,817,1),(4969,93,0,817,57),(4970,143,0,817,177),(4971,97,0,818,1),(4972,134,0,818,2),(4973,115,0,818,1),(4974,99,0,818,1),(4975,93,0,818,49),(4976,143,0,818,178),(4977,97,0,819,1),(4978,134,0,819,2),(4979,115,0,819,1),(4980,99,0,819,1),(4981,93,0,819,50),(4982,143,0,819,178),(4983,97,0,820,1),(4984,134,0,820,2),(4985,115,0,820,1),(4986,99,0,820,1),(4987,93,0,820,57),(4988,143,0,820,178),(4989,97,0,821,1),(4990,134,0,821,2),(4991,115,0,821,1),(4992,99,0,821,4),(4993,144,0,821,0),(4994,145,0,821,0),(4995,146,0,821,0),(4996,147,0,821,1),(4997,148,0,821,0),(4998,97,0,822,1),(4999,134,0,822,2),(5000,115,0,822,1),(5001,99,0,822,1),(5002,93,0,822,50),(5003,143,0,822,175),(5004,97,0,823,1),(5005,134,0,823,2),(5006,115,0,823,1),(5007,99,0,823,1),(5008,93,0,823,53),(5009,143,0,823,175),(5010,97,0,824,1),(5011,134,0,824,2),(5012,115,0,824,1),(5013,99,0,824,1),(5014,93,0,824,58),(5015,143,0,824,175),(5016,97,0,825,1),(5017,134,0,825,2),(5018,115,0,825,1),(5019,99,0,825,1),(5020,93,0,825,50),(5021,143,0,825,176),(5022,97,0,826,1),(5023,134,0,826,2),(5024,115,0,826,1),(5025,99,0,826,1),(5026,93,0,826,53),(5027,143,0,826,176),(5028,97,0,827,1),(5029,134,0,827,2),(5030,115,0,827,1),(5031,99,0,827,1),(5032,93,0,827,58),(5033,143,0,827,176),(5034,97,0,828,1),(5035,134,0,828,2),(5036,115,0,828,1),(5037,99,0,828,1),(5038,93,0,828,50),(5039,143,0,828,177),(5040,97,0,829,1),(5041,134,0,829,2),(5042,115,0,829,1),(5043,99,0,829,1),(5044,93,0,829,53),(5045,143,0,829,177),(5046,97,0,830,1),(5047,134,0,830,2),(5048,115,0,830,1),(5049,99,0,830,1),(5050,93,0,830,58),(5051,143,0,830,177),(5052,97,0,831,1),(5053,134,0,831,2),(5054,115,0,831,1),(5055,99,0,831,1),(5056,93,0,831,50),(5057,143,0,831,178),(5058,97,0,832,1),(5059,134,0,832,2),(5060,115,0,832,1),(5061,99,0,832,1),(5062,93,0,832,53),(5063,143,0,832,178),(5064,97,0,833,1),(5065,134,0,833,2),(5066,115,0,833,1),(5067,99,0,833,1),(5068,93,0,833,58),(5069,143,0,833,178),(5070,97,0,834,1),(5071,134,0,834,2),(5072,115,0,834,1),(5073,99,0,834,4),(5074,144,0,834,0),(5075,145,0,834,0),(5076,146,0,834,0),(5077,147,0,834,1),(5078,148,0,834,0),(5079,97,0,835,1),(5080,134,0,835,2),(5081,115,0,835,1),(5082,99,0,835,1),(5083,93,0,835,49),(5084,143,0,835,175),(5085,97,0,836,1),(5086,134,0,836,2),(5087,115,0,836,1),(5088,99,0,836,1),(5089,93,0,836,50),(5090,143,0,836,175),(5091,97,0,837,1),(5092,134,0,837,2),(5093,115,0,837,1),(5094,99,0,837,1),(5095,93,0,837,58),(5096,143,0,837,175),(5097,97,0,838,1),(5098,134,0,838,2),(5099,115,0,838,1),(5100,99,0,838,1),(5101,93,0,838,49),(5102,143,0,838,176),(5103,97,0,839,1),(5104,134,0,839,2),(5105,115,0,839,1),(5106,99,0,839,1),(5107,93,0,839,50),(5108,143,0,839,176),(5109,97,0,840,1),(5110,134,0,840,2),(5111,115,0,840,1),(5112,99,0,840,1),(5113,93,0,840,58),(5114,143,0,840,176),(5115,97,0,841,1),(5116,134,0,841,2),(5117,115,0,841,1),(5118,99,0,841,1),(5119,93,0,841,49),(5120,143,0,841,177),(5121,97,0,842,1),(5122,134,0,842,2),(5123,115,0,842,1),(5124,99,0,842,1),(5125,93,0,842,50),(5126,143,0,842,177),(5127,97,0,843,1),(5128,134,0,843,2),(5129,115,0,843,1),(5130,99,0,843,1),(5131,93,0,843,58),(5132,143,0,843,177),(5133,97,0,844,1),(5134,134,0,844,2),(5135,115,0,844,1),(5136,99,0,844,1),(5137,93,0,844,49),(5138,143,0,844,178),(5139,97,0,845,1),(5140,134,0,845,2),(5141,115,0,845,1),(5142,99,0,845,1),(5143,93,0,845,50),(5144,143,0,845,178),(5145,97,0,846,1),(5146,134,0,846,2),(5147,115,0,846,1),(5148,99,0,846,1),(5149,93,0,846,58),(5150,143,0,846,178),(5151,97,0,847,1),(5152,134,0,847,2),(5153,115,0,847,1),(5154,99,0,847,4),(5155,144,0,847,0),(5156,145,0,847,1),(5157,146,0,847,1),(5158,147,0,847,1),(5159,148,0,847,0),(5160,97,0,848,1),(5161,134,0,848,2),(5162,115,0,848,1),(5163,99,0,848,1),(5164,93,0,848,49),(5165,143,0,848,175),(5166,97,0,849,1),(5167,134,0,849,2),(5168,115,0,849,1),(5169,99,0,849,1),(5170,93,0,849,50),(5171,143,0,849,175),(5172,97,0,850,1),(5173,134,0,850,2),(5174,115,0,850,1),(5175,99,0,850,1),(5176,93,0,850,53),(5177,143,0,850,175),(5178,97,0,851,1),(5179,134,0,851,2),(5180,115,0,851,1),(5181,99,0,851,1),(5182,93,0,851,49),(5183,143,0,851,176),(5184,97,0,852,1),(5185,134,0,852,2),(5186,115,0,852,1),(5187,99,0,852,1),(5188,93,0,852,50),(5189,143,0,852,176),(5190,97,0,853,1),(5191,134,0,853,2),(5192,115,0,853,1),(5193,99,0,853,1),(5194,93,0,853,53),(5195,143,0,853,176),(5196,97,0,854,1),(5197,134,0,854,2),(5198,115,0,854,1),(5199,99,0,854,1),(5200,93,0,854,49),(5201,143,0,854,177),(5202,97,0,855,1),(5203,134,0,855,2),(5204,115,0,855,1),(5205,99,0,855,1),(5206,93,0,855,50),(5207,143,0,855,177),(5208,97,0,856,1),(5209,134,0,856,2),(5210,115,0,856,1),(5211,99,0,856,1),(5212,93,0,856,53),(5213,143,0,856,177),(5214,97,0,857,1),(5215,134,0,857,2),(5216,115,0,857,1),(5217,99,0,857,1),(5218,93,0,857,49),(5219,143,0,857,178),(5220,97,0,858,1),(5221,134,0,858,2),(5222,115,0,858,1),(5223,99,0,858,1),(5224,93,0,858,50),(5225,143,0,858,178),(5226,97,0,859,1),(5227,134,0,859,2),(5228,115,0,859,1),(5229,99,0,859,1),(5230,93,0,859,53),(5231,143,0,859,178),(5232,97,0,860,1),(5233,134,0,860,2),(5234,115,0,860,1),(5235,99,0,860,4),(5236,144,0,860,0),(5237,145,0,860,0),(5238,146,0,860,1),(5239,147,0,860,0),(5240,148,0,860,0),(5241,97,0,861,1),(5242,134,0,861,2),(5243,115,0,861,1),(5244,99,0,861,1),(5245,93,0,861,50),(5246,143,0,861,175),(5247,97,0,862,1),(5248,134,0,862,2),(5249,115,0,862,1),(5250,99,0,862,1),(5251,93,0,862,51),(5252,143,0,862,175),(5253,97,0,863,1),(5254,134,0,863,2),(5255,115,0,863,1),(5256,99,0,863,1),(5257,93,0,863,53),(5258,143,0,863,175),(5259,97,0,864,1),(5260,134,0,864,2),(5261,115,0,864,1),(5262,99,0,864,1),(5263,93,0,864,50),(5264,143,0,864,176),(5265,97,0,865,1),(5266,134,0,865,2),(5267,115,0,865,1),(5268,99,0,865,1),(5269,93,0,865,51),(5270,143,0,865,176),(5271,97,0,866,1),(5272,134,0,866,2),(5273,115,0,866,1),(5274,99,0,866,1),(5275,93,0,866,53),(5276,143,0,866,176),(5277,97,0,867,1),(5278,134,0,867,2),(5279,115,0,867,1),(5280,99,0,867,1),(5281,93,0,867,50),(5282,143,0,867,177),(5283,97,0,868,1),(5284,134,0,868,2),(5285,115,0,868,1),(5286,99,0,868,1),(5287,93,0,868,51),(5288,143,0,868,177),(5289,97,0,869,1),(5290,134,0,869,2),(5291,115,0,869,1),(5292,99,0,869,1),(5293,93,0,869,53),(5294,143,0,869,177),(5295,97,0,870,1),(5296,134,0,870,2),(5297,115,0,870,1),(5298,99,0,870,1),(5299,93,0,870,50),(5300,143,0,870,178),(5301,97,0,871,1),(5302,134,0,871,2),(5303,115,0,871,1),(5304,99,0,871,1),(5305,93,0,871,51),(5306,143,0,871,178),(5307,97,0,872,1),(5308,134,0,872,2),(5309,115,0,872,1),(5310,99,0,872,1),(5311,93,0,872,53),(5312,143,0,872,178),(5313,97,0,873,1),(5314,134,0,873,2),(5315,115,0,873,1),(5316,99,0,873,4),(5317,144,0,873,0),(5318,145,0,873,1),(5319,146,0,873,1),(5320,147,0,873,0),(5321,148,0,873,0),(5322,97,0,874,1),(5323,134,0,874,2),(5324,115,0,874,1),(5325,99,0,874,1),(5326,93,0,874,49),(5327,143,0,874,175),(5328,97,0,875,1),(5329,134,0,875,2),(5330,115,0,875,1),(5331,99,0,875,1),(5332,93,0,875,50),(5333,143,0,875,175),(5334,97,0,876,1),(5335,134,0,876,2),(5336,115,0,876,1),(5337,99,0,876,1),(5338,93,0,876,58),(5339,143,0,876,175),(5340,97,0,877,1),(5341,134,0,877,2),(5342,115,0,877,1),(5343,99,0,877,1),(5344,93,0,877,49),(5345,143,0,877,176),(5346,97,0,878,1),(5347,134,0,878,2),(5348,115,0,878,1),(5349,99,0,878,1),(5350,93,0,878,50),(5351,143,0,878,176),(5352,97,0,879,1),(5353,134,0,879,2),(5354,115,0,879,1),(5355,99,0,879,1),(5356,93,0,879,58),(5357,143,0,879,176),(5358,97,0,880,1),(5359,134,0,880,2),(5360,115,0,880,1),(5361,99,0,880,1),(5362,93,0,880,49),(5363,143,0,880,177),(5364,97,0,881,1),(5365,134,0,881,2),(5366,115,0,881,1),(5367,99,0,881,1),(5368,93,0,881,50),(5369,143,0,881,177),(5370,97,0,882,1),(5371,134,0,882,2),(5372,115,0,882,1),(5373,99,0,882,1),(5374,93,0,882,58),(5375,143,0,882,177),(5376,97,0,883,1),(5377,134,0,883,2),(5378,115,0,883,1),(5379,99,0,883,1),(5380,93,0,883,49),(5381,143,0,883,178),(5382,97,0,884,1),(5383,134,0,884,2),(5384,115,0,884,1),(5385,99,0,884,1),(5386,93,0,884,50),(5387,143,0,884,178),(5388,97,0,885,1),(5389,134,0,885,2),(5390,115,0,885,1),(5391,99,0,885,1),(5392,93,0,885,58),(5393,143,0,885,178),(5394,97,0,886,1),(5395,134,0,886,2),(5396,115,0,886,1),(5397,99,0,886,4),(5398,144,0,886,0),(5399,145,0,886,0),(5400,146,0,886,0),(5401,147,0,886,0),(5402,148,0,886,0),(5403,97,0,887,1),(5404,134,0,887,2),(5405,115,0,887,1),(5406,99,0,887,1),(5407,93,0,887,49),(5408,143,0,887,175),(5409,97,0,888,1),(5410,134,0,888,2),(5411,115,0,888,1),(5412,99,0,888,1),(5413,93,0,888,50),(5414,143,0,888,175),(5415,97,0,889,1),(5416,134,0,889,2),(5417,115,0,889,1),(5418,99,0,889,1),(5419,93,0,889,58),(5420,143,0,889,175),(5421,97,0,890,1),(5422,134,0,890,2),(5423,115,0,890,1),(5424,99,0,890,1),(5425,93,0,890,49),(5426,143,0,890,176),(5427,97,0,891,1),(5428,134,0,891,2),(5429,115,0,891,1),(5430,99,0,891,1),(5431,93,0,891,50),(5432,143,0,891,176),(5433,97,0,892,1),(5434,134,0,892,2),(5435,115,0,892,1),(5436,99,0,892,1),(5437,93,0,892,58),(5438,143,0,892,176),(5439,97,0,893,1),(5440,134,0,893,2),(5441,115,0,893,1),(5442,99,0,893,1),(5443,93,0,893,49),(5444,143,0,893,177),(5445,97,0,894,1),(5446,134,0,894,2),(5447,115,0,894,1),(5448,99,0,894,1),(5449,93,0,894,50),(5450,143,0,894,177),(5451,97,0,895,1),(5452,134,0,895,2),(5453,115,0,895,1),(5454,99,0,895,1),(5455,93,0,895,58),(5456,143,0,895,177),(5457,97,0,896,1),(5458,134,0,896,2),(5459,115,0,896,1),(5460,99,0,896,1),(5461,93,0,896,49),(5462,143,0,896,178),(5463,97,0,897,1),(5464,134,0,897,2),(5465,115,0,897,1),(5466,99,0,897,1),(5467,93,0,897,50),(5468,143,0,897,178),(5469,97,0,898,1),(5470,134,0,898,2),(5471,115,0,898,1),(5472,99,0,898,1),(5473,93,0,898,58),(5474,143,0,898,178),(5475,97,0,899,1),(5476,134,0,899,2),(5477,115,0,899,1),(5478,99,0,899,4),(5479,144,0,899,0),(5480,145,0,899,0),(5481,146,0,899,1),(5482,147,0,899,0),(5483,148,0,899,0),(5484,97,0,900,1),(5485,134,0,900,2),(5486,115,0,900,1),(5487,99,0,900,1),(5488,93,0,900,49),(5489,143,0,900,175),(5490,97,0,901,1),(5491,134,0,901,2),(5492,115,0,901,1),(5493,99,0,901,1),(5494,93,0,901,49),(5495,143,0,901,176),(5496,97,0,902,1),(5497,134,0,902,2),(5498,115,0,902,1),(5499,99,0,902,1),(5500,93,0,902,49),(5501,143,0,902,177),(5502,97,0,903,1),(5503,134,0,903,2),(5504,115,0,903,1),(5505,99,0,903,1),(5506,93,0,903,49),(5507,143,0,903,178),(5508,97,0,904,1),(5509,134,0,904,2),(5510,115,0,904,1),(5511,99,0,904,4),(5512,144,0,904,0),(5513,145,0,904,0),(5514,146,0,904,0),(5515,147,0,904,0),(5516,148,0,904,0),(5517,97,0,905,1),(5518,134,0,905,2),(5519,115,0,905,1),(5520,99,0,905,1),(5521,93,0,905,49),(5522,143,0,905,175),(5523,97,0,906,1),(5524,134,0,906,2),(5525,115,0,906,1),(5526,99,0,906,1),(5527,93,0,906,50),(5528,143,0,906,175),(5529,97,0,907,1),(5530,134,0,907,2),(5531,115,0,907,1),(5532,99,0,907,1),(5533,93,0,907,53),(5534,143,0,907,175),(5535,97,0,908,1),(5536,134,0,908,2),(5537,115,0,908,1),(5538,99,0,908,1),(5539,93,0,908,49),(5540,143,0,908,176),(5541,97,0,909,1),(5542,134,0,909,2),(5543,115,0,909,1),(5544,99,0,909,1),(5545,93,0,909,50),(5546,143,0,909,176),(5547,97,0,910,1),(5548,134,0,910,2),(5549,115,0,910,1),(5550,99,0,910,1),(5551,93,0,910,53),(5552,143,0,910,176),(5553,97,0,911,1),(5554,134,0,911,2),(5555,115,0,911,1),(5556,99,0,911,1),(5557,93,0,911,49),(5558,143,0,911,177),(5559,97,0,912,1),(5560,134,0,912,2),(5561,115,0,912,1),(5562,99,0,912,1),(5563,93,0,912,50),(5564,143,0,912,177),(5565,97,0,913,1),(5566,134,0,913,2),(5567,115,0,913,1),(5568,99,0,913,1),(5569,93,0,913,53),(5570,143,0,913,177),(5571,97,0,914,1),(5572,134,0,914,2),(5573,115,0,914,1),(5574,99,0,914,1),(5575,93,0,914,49),(5576,143,0,914,178),(5577,97,0,915,1),(5578,134,0,915,2),(5579,115,0,915,1),(5580,99,0,915,1),(5581,93,0,915,50),(5582,143,0,915,178),(5583,97,0,916,1),(5584,134,0,916,2),(5585,115,0,916,1),(5586,99,0,916,1),(5587,93,0,916,53),(5588,143,0,916,178),(5589,97,0,917,1),(5590,134,0,917,2),(5591,115,0,917,1),(5592,99,0,917,4),(5593,144,0,917,0),(5594,145,0,917,1),(5595,146,0,917,0),(5596,147,0,917,0),(5597,148,0,917,0),(5598,97,0,918,1),(5599,134,0,918,2),(5600,115,0,918,1),(5601,99,0,918,1),(5602,93,0,918,52),(5603,143,0,918,175),(5604,97,0,919,1),(5605,134,0,919,2),(5606,115,0,919,1),(5607,99,0,919,1),(5608,93,0,919,57),(5609,143,0,919,175),(5610,97,0,920,1),(5611,134,0,920,2),(5612,115,0,920,1),(5613,99,0,920,1),(5614,93,0,920,60),(5615,143,0,920,175),(5616,97,0,921,1),(5617,134,0,921,2),(5618,115,0,921,1),(5619,99,0,921,1),(5620,93,0,921,52),(5621,143,0,921,176),(5622,97,0,922,1),(5623,134,0,922,2),(5624,115,0,922,1),(5625,99,0,922,1),(5626,93,0,922,57),(5627,143,0,922,176),(5628,97,0,923,1),(5629,134,0,923,2),(5630,115,0,923,1),(5631,99,0,923,1),(5632,93,0,923,60),(5633,143,0,923,176),(5634,97,0,924,1),(5635,134,0,924,2),(5636,115,0,924,1),(5637,99,0,924,1),(5638,93,0,924,52),(5639,143,0,924,177),(5640,97,0,925,1),(5641,134,0,925,2),(5642,115,0,925,1),(5643,99,0,925,1),(5644,93,0,925,57),(5645,143,0,925,177),(5646,97,0,926,1),(5647,134,0,926,2),(5648,115,0,926,1),(5649,99,0,926,1),(5650,93,0,926,60),(5651,143,0,926,177),(5652,97,0,927,1),(5653,134,0,927,2),(5654,115,0,927,1),(5655,99,0,927,1),(5656,93,0,927,52),(5657,143,0,927,178),(5658,97,0,928,1),(5659,134,0,928,2),(5660,115,0,928,1),(5661,99,0,928,1),(5662,93,0,928,57),(5663,143,0,928,178),(5664,97,0,929,1),(5665,134,0,929,2),(5666,115,0,929,1),(5667,99,0,929,1),(5668,93,0,929,60),(5669,143,0,929,178),(5670,97,0,930,1),(5671,134,0,930,2),(5672,115,0,930,1),(5673,99,0,930,4),(5674,144,0,930,0),(5675,145,0,930,0),(5676,146,0,930,0),(5677,147,0,930,0),(5678,148,0,930,0),(5679,97,0,931,1),(5680,134,0,931,2),(5681,115,0,931,1),(5682,99,0,931,1),(5683,93,0,931,49),(5684,143,0,931,175),(5685,97,0,932,1),(5686,134,0,932,2),(5687,115,0,932,1),(5688,99,0,932,1),(5689,93,0,932,50),(5690,143,0,932,175),(5691,97,0,933,1),(5692,134,0,933,2),(5693,115,0,933,1),(5694,99,0,933,1),(5695,93,0,933,52),(5696,143,0,933,175),(5697,97,0,934,1),(5698,134,0,934,2),(5699,115,0,934,1),(5700,99,0,934,1),(5701,93,0,934,49),(5702,143,0,934,176),(5703,97,0,935,1),(5704,134,0,935,2),(5705,115,0,935,1),(5706,99,0,935,1),(5707,93,0,935,50),(5708,143,0,935,176),(5709,97,0,936,1),(5710,134,0,936,2),(5711,115,0,936,1),(5712,99,0,936,1),(5713,93,0,936,52),(5714,143,0,936,176),(5715,97,0,937,1),(5716,134,0,937,2),(5717,115,0,937,1),(5718,99,0,937,1),(5719,93,0,937,49),(5720,143,0,937,177),(5721,97,0,938,1),(5722,134,0,938,2),(5723,115,0,938,1),(5724,99,0,938,1),(5725,93,0,938,50),(5726,143,0,938,177),(5727,97,0,939,1),(5728,134,0,939,2),(5729,115,0,939,1),(5730,99,0,939,1),(5731,93,0,939,52),(5732,143,0,939,177),(5733,97,0,940,1),(5734,134,0,940,2),(5735,115,0,940,1),(5736,99,0,940,1),(5737,93,0,940,49),(5738,143,0,940,178),(5739,97,0,941,1),(5740,134,0,941,2),(5741,115,0,941,1),(5742,99,0,941,1),(5743,93,0,941,50),(5744,143,0,941,178),(5745,97,0,942,1),(5746,134,0,942,2),(5747,115,0,942,1),(5748,99,0,942,1),(5749,93,0,942,52),(5750,143,0,942,178),(5751,97,0,943,1),(5752,134,0,943,2),(5753,115,0,943,1),(5754,99,0,943,4),(5755,144,0,943,0),(5756,145,0,943,1),(5757,146,0,943,0),(5758,147,0,943,0),(5759,148,0,943,0),(5760,97,0,944,1),(5761,134,0,944,2),(5762,115,0,944,1),(5763,99,0,944,1),(5764,93,0,944,50),(5765,143,0,944,175),(5766,97,0,945,1),(5767,134,0,945,2),(5768,115,0,945,1),(5769,99,0,945,1),(5770,93,0,945,52),(5771,143,0,945,175),(5772,97,0,946,1),(5773,134,0,946,2),(5774,115,0,946,1),(5775,99,0,946,1),(5776,93,0,946,58),(5777,143,0,946,175),(5778,97,0,947,1),(5779,134,0,947,2),(5780,115,0,947,1),(5781,99,0,947,1),(5782,93,0,947,50),(5783,143,0,947,176),(5784,97,0,948,1),(5785,134,0,948,2),(5786,115,0,948,1),(5787,99,0,948,1),(5788,93,0,948,52),(5789,143,0,948,176),(5790,97,0,949,1),(5791,134,0,949,2),(5792,115,0,949,1),(5793,99,0,949,1),(5794,93,0,949,58),(5795,143,0,949,176),(5796,97,0,950,1),(5797,134,0,950,2),(5798,115,0,950,1),(5799,99,0,950,1),(5800,93,0,950,50),(5801,143,0,950,177),(5802,97,0,951,1),(5803,134,0,951,2),(5804,115,0,951,1),(5805,99,0,951,1),(5806,93,0,951,52),(5807,143,0,951,177),(5808,97,0,952,1),(5809,134,0,952,2),(5810,115,0,952,1),(5811,99,0,952,1),(5812,93,0,952,58),(5813,143,0,952,177),(5814,97,0,953,1),(5815,134,0,953,2),(5816,115,0,953,1),(5817,99,0,953,1),(5818,93,0,953,50),(5819,143,0,953,178),(5820,97,0,954,1),(5821,134,0,954,2),(5822,115,0,954,1),(5823,99,0,954,1),(5824,93,0,954,52),(5825,143,0,954,178),(5826,97,0,955,1),(5827,134,0,955,2),(5828,115,0,955,1),(5829,99,0,955,1),(5830,93,0,955,58),(5831,143,0,955,178),(5832,97,0,956,1),(5833,134,0,956,2),(5834,115,0,956,1),(5835,99,0,956,4),(5836,144,0,956,0),(5837,145,0,956,0),(5838,146,0,956,0),(5839,147,0,956,1),(5840,148,0,956,0),(5841,97,0,957,1),(5842,134,0,957,2),(5843,115,0,957,1),(5844,99,0,957,1),(5845,93,0,957,49),(5846,143,0,957,175),(5847,97,0,958,1),(5848,134,0,958,2),(5849,115,0,958,1),(5850,99,0,958,1),(5851,93,0,958,50),(5852,143,0,958,175),(5853,97,0,959,1),(5854,134,0,959,2),(5855,115,0,959,1),(5856,99,0,959,1),(5857,93,0,959,57),(5858,143,0,959,175),(5859,97,0,960,1),(5860,134,0,960,2),(5861,115,0,960,1),(5862,99,0,960,1),(5863,93,0,960,49),(5864,143,0,960,176),(5865,97,0,961,1),(5866,134,0,961,2),(5867,115,0,961,1),(5868,99,0,961,1),(5869,93,0,961,50),(5870,143,0,961,176),(5871,97,0,962,1),(5872,134,0,962,2),(5873,115,0,962,1),(5874,99,0,962,1),(5875,93,0,962,57),(5876,143,0,962,176),(5877,97,0,963,1),(5878,134,0,963,2),(5879,115,0,963,1),(5880,99,0,963,1),(5881,93,0,963,49),(5882,143,0,963,177),(5883,97,0,964,1),(5884,134,0,964,2),(5885,115,0,964,1),(5886,99,0,964,1),(5887,93,0,964,50),(5888,143,0,964,177),(5889,97,0,965,1),(5890,134,0,965,2),(5891,115,0,965,1),(5892,99,0,965,1),(5893,93,0,965,57),(5894,143,0,965,177),(5895,97,0,966,1),(5896,134,0,966,2),(5897,115,0,966,1),(5898,99,0,966,1),(5899,93,0,966,49),(5900,143,0,966,178),(5901,97,0,967,1),(5902,134,0,967,2),(5903,115,0,967,1),(5904,99,0,967,1),(5905,93,0,967,50),(5906,143,0,967,178),(5907,97,0,968,1),(5908,134,0,968,2),(5909,115,0,968,1),(5910,99,0,968,1),(5911,93,0,968,57),(5912,143,0,968,178),(5913,97,0,969,1),(5914,134,0,969,2),(5915,115,0,969,1),(5916,99,0,969,4),(5917,144,0,969,0),(5918,145,0,969,1),(5919,146,0,969,1),(5920,147,0,969,0),(5921,148,0,969,1),(5922,97,0,970,1),(5923,134,0,970,2),(5924,115,0,970,1),(5925,99,0,970,1),(5926,93,0,970,49),(5927,143,0,970,175),(5928,97,0,971,1),(5929,134,0,971,2),(5930,115,0,971,1),(5931,99,0,971,1),(5932,93,0,971,50),(5933,143,0,971,175),(5934,97,0,972,1),(5935,134,0,972,2),(5936,115,0,972,1),(5937,99,0,972,1),(5938,93,0,972,53),(5939,143,0,972,175),(5940,97,0,973,1),(5941,134,0,973,2),(5942,115,0,973,1),(5943,99,0,973,1),(5944,93,0,973,49),(5945,143,0,973,176),(5946,97,0,974,1),(5947,134,0,974,2),(5948,115,0,974,1),(5949,99,0,974,1),(5950,93,0,974,50),(5951,143,0,974,176),(5952,97,0,975,1),(5953,134,0,975,2),(5954,115,0,975,1),(5955,99,0,975,1),(5956,93,0,975,53),(5957,143,0,975,176),(5958,97,0,976,1),(5959,134,0,976,2),(5960,115,0,976,1),(5961,99,0,976,1),(5962,93,0,976,49),(5963,143,0,976,177),(5964,97,0,977,1),(5965,134,0,977,2),(5966,115,0,977,1),(5967,99,0,977,1),(5968,93,0,977,50),(5969,143,0,977,177),(5970,97,0,978,1),(5971,134,0,978,2),(5972,115,0,978,1),(5973,99,0,978,1),(5974,93,0,978,53),(5975,143,0,978,177),(5976,97,0,979,1),(5977,134,0,979,2),(5978,115,0,979,1),(5979,99,0,979,1),(5980,93,0,979,49),(5981,143,0,979,178),(5982,97,0,980,1),(5983,134,0,980,2),(5984,115,0,980,1),(5985,99,0,980,1),(5986,93,0,980,50),(5987,143,0,980,178),(5988,97,0,981,1),(5989,134,0,981,2),(5990,115,0,981,1),(5991,99,0,981,1),(5992,93,0,981,53),(5993,143,0,981,178),(5994,97,0,982,1),(5995,134,0,982,2),(5996,115,0,982,1),(5997,99,0,982,4),(5998,144,0,982,0),(5999,145,0,982,0),(6000,146,0,982,0),(6001,147,0,982,0),(6002,148,0,982,1),(6003,97,0,983,1),(6004,134,0,983,2),(6005,115,0,983,1),(6006,99,0,983,1),(6007,93,0,983,49),(6008,143,0,983,175),(6009,97,0,984,1),(6010,134,0,984,2),(6011,115,0,984,1),(6012,99,0,984,1),(6013,93,0,984,50),(6014,143,0,984,175),(6015,97,0,985,1),(6016,134,0,985,2),(6017,115,0,985,1),(6018,99,0,985,1),(6019,93,0,985,53),(6020,143,0,985,175),(6021,97,0,986,1),(6022,134,0,986,2),(6023,115,0,986,1),(6024,99,0,986,1),(6025,93,0,986,49),(6026,143,0,986,176),(6027,97,0,987,1),(6028,134,0,987,2),(6029,115,0,987,1),(6030,99,0,987,1),(6031,93,0,987,50),(6032,143,0,987,176),(6033,97,0,988,1),(6034,134,0,988,2),(6035,115,0,988,1),(6036,99,0,988,1),(6037,93,0,988,53),(6038,143,0,988,176),(6039,97,0,989,1),(6040,134,0,989,2),(6041,115,0,989,1),(6042,99,0,989,1),(6043,93,0,989,49),(6044,143,0,989,177),(6045,97,0,990,1),(6046,134,0,990,2),(6047,115,0,990,1),(6048,99,0,990,1),(6049,93,0,990,50),(6050,143,0,990,177),(6051,97,0,991,1),(6052,134,0,991,2),(6053,115,0,991,1),(6054,99,0,991,1),(6055,93,0,991,53),(6056,143,0,991,177),(6057,97,0,992,1),(6058,134,0,992,2),(6059,115,0,992,1),(6060,99,0,992,1),(6061,93,0,992,49),(6062,143,0,992,178),(6063,97,0,993,1),(6064,134,0,993,2),(6065,115,0,993,1),(6066,99,0,993,1),(6067,93,0,993,50),(6068,143,0,993,178),(6069,97,0,994,1),(6070,134,0,994,2),(6071,115,0,994,1),(6072,99,0,994,1),(6073,93,0,994,53),(6074,143,0,994,178),(6075,97,0,995,1),(6076,134,0,995,2),(6077,115,0,995,1),(6078,99,0,995,4),(6079,144,0,995,0),(6080,145,0,995,1),(6081,146,0,995,0),(6082,147,0,995,0),(6083,148,0,995,0),(6084,97,0,996,1),(6085,134,0,996,2),(6086,115,0,996,1),(6087,99,0,996,1),(6088,93,0,996,50),(6089,143,0,996,175),(6090,97,0,997,1),(6091,134,0,997,2),(6092,115,0,997,1),(6093,99,0,997,1),(6094,93,0,997,53),(6095,143,0,997,175),(6096,97,0,998,1),(6097,134,0,998,2),(6098,115,0,998,1),(6099,99,0,998,1),(6100,93,0,998,57),(6101,143,0,998,175),(6102,97,0,999,1),(6103,134,0,999,2),(6104,115,0,999,1),(6105,99,0,999,1),(6106,93,0,999,50),(6107,143,0,999,176),(6108,97,0,1000,1),(6109,134,0,1000,2),(6110,115,0,1000,1),(6111,99,0,1000,1),(6112,93,0,1000,53),(6113,143,0,1000,176),(6114,97,0,1001,1),(6115,134,0,1001,2),(6116,115,0,1001,1),(6117,99,0,1001,1),(6118,93,0,1001,57),(6119,143,0,1001,176),(6120,97,0,1002,1),(6121,134,0,1002,2),(6122,115,0,1002,1),(6123,99,0,1002,1),(6124,93,0,1002,50),(6125,143,0,1002,177),(6126,97,0,1003,1),(6127,134,0,1003,2),(6128,115,0,1003,1),(6129,99,0,1003,1),(6130,93,0,1003,53),(6131,143,0,1003,177),(6132,97,0,1004,1),(6133,134,0,1004,2),(6134,115,0,1004,1),(6135,99,0,1004,1),(6136,93,0,1004,57),(6137,143,0,1004,177),(6138,97,0,1005,1),(6139,134,0,1005,2),(6140,115,0,1005,1),(6141,99,0,1005,1),(6142,93,0,1005,50),(6143,143,0,1005,178),(6144,97,0,1006,1),(6145,134,0,1006,2),(6146,115,0,1006,1),(6147,99,0,1006,1),(6148,93,0,1006,53),(6149,143,0,1006,178),(6150,97,0,1007,1),(6151,134,0,1007,2),(6152,115,0,1007,1),(6153,99,0,1007,1),(6154,93,0,1007,57),(6155,143,0,1007,178),(6156,97,0,1008,1),(6157,134,0,1008,2),(6158,115,0,1008,1),(6159,99,0,1008,4),(6160,144,0,1008,0),(6161,145,0,1008,0),(6162,146,0,1008,0),(6163,147,0,1008,1),(6164,148,0,1008,0),(6165,97,0,1009,1),(6166,134,0,1009,2),(6167,115,0,1009,1),(6168,99,0,1009,1),(6169,93,0,1009,49),(6170,143,0,1009,175),(6171,97,0,1010,1),(6172,134,0,1010,2),(6173,115,0,1010,1),(6174,99,0,1010,1),(6175,93,0,1010,50),(6176,143,0,1010,175),(6177,97,0,1011,1),(6178,134,0,1011,2),(6179,115,0,1011,1),(6180,99,0,1011,1),(6181,93,0,1011,58),(6182,143,0,1011,175),(6183,97,0,1012,1),(6184,134,0,1012,2),(6185,115,0,1012,1),(6186,99,0,1012,1),(6187,93,0,1012,49),(6188,143,0,1012,176),(6189,97,0,1013,1),(6190,134,0,1013,2),(6191,115,0,1013,1),(6192,99,0,1013,1),(6193,93,0,1013,50),(6194,143,0,1013,176),(6195,97,0,1014,1),(6196,134,0,1014,2),(6197,115,0,1014,1),(6198,99,0,1014,1),(6199,93,0,1014,58),(6200,143,0,1014,176),(6201,97,0,1015,1),(6202,134,0,1015,2),(6203,115,0,1015,1),(6204,99,0,1015,1),(6205,93,0,1015,49),(6206,143,0,1015,177),(6207,97,0,1016,1),(6208,134,0,1016,2),(6209,115,0,1016,1),(6210,99,0,1016,1),(6211,93,0,1016,50),(6212,143,0,1016,177),(6213,97,0,1017,1),(6214,134,0,1017,2),(6215,115,0,1017,1),(6216,99,0,1017,1),(6217,93,0,1017,58),(6218,143,0,1017,177),(6219,97,0,1018,1),(6220,134,0,1018,2),(6221,115,0,1018,1),(6222,99,0,1018,1),(6223,93,0,1018,49),(6224,143,0,1018,178),(6225,97,0,1019,1),(6226,134,0,1019,2),(6227,115,0,1019,1),(6228,99,0,1019,1),(6229,93,0,1019,50),(6230,143,0,1019,178),(6231,97,0,1020,1),(6232,134,0,1020,2),(6233,115,0,1020,1),(6234,99,0,1020,1),(6235,93,0,1020,58),(6236,143,0,1020,178),(6237,97,0,1021,1),(6238,134,0,1021,2),(6239,115,0,1021,1),(6240,99,0,1021,4),(6241,144,0,1021,0),(6242,145,0,1021,0),(6243,146,0,1021,0),(6244,147,0,1021,0),(6245,148,0,1021,0),(6246,97,0,1022,1),(6247,134,0,1022,2),(6248,115,0,1022,1),(6249,99,0,1022,1),(6250,93,0,1022,49),(6251,143,0,1022,175),(6252,97,0,1023,1),(6253,134,0,1023,2),(6254,115,0,1023,1),(6255,99,0,1023,1),(6256,93,0,1023,52),(6257,143,0,1023,175),(6258,97,0,1024,1),(6259,134,0,1024,2),(6260,115,0,1024,1),(6261,99,0,1024,1),(6262,93,0,1024,58),(6263,143,0,1024,175),(6264,97,0,1025,1),(6265,134,0,1025,2),(6266,115,0,1025,1),(6267,99,0,1025,1),(6268,93,0,1025,49),(6269,143,0,1025,176),(6270,97,0,1026,1),(6271,134,0,1026,2),(6272,115,0,1026,1),(6273,99,0,1026,1),(6274,93,0,1026,52),(6275,143,0,1026,176),(6276,97,0,1027,1),(6277,134,0,1027,2),(6278,115,0,1027,1),(6279,99,0,1027,1),(6280,93,0,1027,58),(6281,143,0,1027,176),(6282,97,0,1028,1),(6283,134,0,1028,2),(6284,115,0,1028,1),(6285,99,0,1028,1),(6286,93,0,1028,49),(6287,143,0,1028,177),(6288,97,0,1029,1),(6289,134,0,1029,2),(6290,115,0,1029,1),(6291,99,0,1029,1),(6292,93,0,1029,52),(6293,143,0,1029,177),(6294,97,0,1030,1),(6295,134,0,1030,2),(6296,115,0,1030,1),(6297,99,0,1030,1),(6298,93,0,1030,58),(6299,143,0,1030,177),(6300,97,0,1031,1),(6301,134,0,1031,2),(6302,115,0,1031,1),(6303,99,0,1031,1),(6304,93,0,1031,49),(6305,143,0,1031,178),(6306,97,0,1032,1),(6307,134,0,1032,2),(6308,115,0,1032,1),(6309,99,0,1032,1),(6310,93,0,1032,52),(6311,143,0,1032,178),(6312,97,0,1033,1),(6313,134,0,1033,2),(6314,115,0,1033,1),(6315,99,0,1033,1),(6316,93,0,1033,58),(6317,143,0,1033,178),(6318,97,0,1034,1),(6319,134,0,1034,2),(6320,115,0,1034,1),(6321,99,0,1034,4),(6322,144,0,1034,0),(6323,145,0,1034,0),(6324,146,0,1034,0),(6325,147,0,1034,0),(6326,148,0,1034,1),(6327,97,0,1035,1),(6328,134,0,1035,2),(6329,115,0,1035,1),(6330,99,0,1035,1),(6331,93,0,1035,53),(6332,143,0,1035,166),(6333,97,0,1036,1),(6334,134,0,1036,2),(6335,115,0,1036,1),(6336,99,0,1036,1),(6337,93,0,1036,56),(6338,143,0,1036,166),(6339,97,0,1037,1),(6340,134,0,1037,2),(6341,115,0,1037,1),(6342,99,0,1037,1),(6343,93,0,1037,57),(6344,143,0,1037,166),(6345,97,0,1038,1),(6346,134,0,1038,2),(6347,115,0,1038,1),(6348,99,0,1038,1),(6349,93,0,1038,53),(6350,143,0,1038,167),(6351,97,0,1039,1),(6352,134,0,1039,2),(6353,115,0,1039,1),(6354,99,0,1039,1),(6355,93,0,1039,56),(6356,143,0,1039,167),(6357,97,0,1040,1),(6358,134,0,1040,2),(6359,115,0,1040,1),(6360,99,0,1040,1),(6361,93,0,1040,57),(6362,143,0,1040,167),(6363,97,0,1041,1),(6364,134,0,1041,2),(6365,115,0,1041,1),(6366,99,0,1041,1),(6367,93,0,1041,53),(6368,143,0,1041,168),(6369,97,0,1042,1),(6370,134,0,1042,2),(6371,115,0,1042,1),(6372,99,0,1042,1),(6373,93,0,1042,56),(6374,143,0,1042,168),(6375,97,0,1043,1),(6376,134,0,1043,2),(6377,115,0,1043,1),(6378,99,0,1043,1),(6379,93,0,1043,57),(6380,143,0,1043,168),(6381,97,0,1044,1),(6382,134,0,1044,2),(6383,115,0,1044,1),(6384,99,0,1044,1),(6385,93,0,1044,53),(6386,143,0,1044,169),(6387,97,0,1045,1),(6388,134,0,1045,2),(6389,115,0,1045,1),(6390,99,0,1045,1),(6391,93,0,1045,56),(6392,143,0,1045,169),(6393,97,0,1046,1),(6394,134,0,1046,2),(6395,115,0,1046,1),(6396,99,0,1046,1),(6397,93,0,1046,57),(6398,143,0,1046,169),(6399,97,0,1047,1),(6400,134,0,1047,2),(6401,115,0,1047,1),(6402,99,0,1047,1),(6403,93,0,1047,53),(6404,143,0,1047,170),(6405,97,0,1048,1),(6406,134,0,1048,2),(6407,115,0,1048,1),(6408,99,0,1048,1),(6409,93,0,1048,56),(6410,143,0,1048,170),(6411,97,0,1049,1),(6412,134,0,1049,2),(6413,115,0,1049,1),(6414,99,0,1049,1),(6415,93,0,1049,57),(6416,143,0,1049,170),(6417,97,0,1050,1),(6418,134,0,1050,2),(6419,115,0,1050,1),(6420,99,0,1050,4),(6421,144,0,1050,0),(6422,145,0,1050,0),(6423,146,0,1050,1),(6424,147,0,1050,1),(6425,148,0,1050,0),(6426,97,0,1051,1),(6427,134,0,1051,2),(6428,115,0,1051,1),(6429,99,0,1051,1),(6430,93,0,1051,50),(6431,143,0,1051,166),(6432,97,0,1052,1),(6433,134,0,1052,2),(6434,115,0,1052,1),(6435,99,0,1052,1),(6436,93,0,1052,53),(6437,143,0,1052,166),(6438,97,0,1053,1),(6439,134,0,1053,2),(6440,115,0,1053,1),(6441,99,0,1053,1),(6442,93,0,1053,56),(6443,143,0,1053,166),(6444,97,0,1054,1),(6445,134,0,1054,2),(6446,115,0,1054,1),(6447,99,0,1054,1),(6448,93,0,1054,50),(6449,143,0,1054,167),(6450,97,0,1055,1),(6451,134,0,1055,2),(6452,115,0,1055,1),(6453,99,0,1055,1),(6454,93,0,1055,53),(6455,143,0,1055,167),(6456,97,0,1056,1),(6457,134,0,1056,2),(6458,115,0,1056,1),(6459,99,0,1056,1),(6460,93,0,1056,56),(6461,143,0,1056,167),(6462,97,0,1057,1),(6463,134,0,1057,2),(6464,115,0,1057,1),(6465,99,0,1057,1),(6466,93,0,1057,50),(6467,143,0,1057,168),(6468,97,0,1058,1),(6469,134,0,1058,2),(6470,115,0,1058,1),(6471,99,0,1058,1),(6472,93,0,1058,53),(6473,143,0,1058,168),(6474,97,0,1059,1),(6475,134,0,1059,2),(6476,115,0,1059,1),(6477,99,0,1059,1),(6478,93,0,1059,56),(6479,143,0,1059,168),(6480,97,0,1060,1),(6481,134,0,1060,2),(6482,115,0,1060,1),(6483,99,0,1060,1),(6484,93,0,1060,50),(6485,143,0,1060,169),(6486,97,0,1061,1),(6487,134,0,1061,2),(6488,115,0,1061,1),(6489,99,0,1061,1),(6490,93,0,1061,53),(6491,143,0,1061,169),(6492,97,0,1062,1),(6493,134,0,1062,2),(6494,115,0,1062,1),(6495,99,0,1062,1),(6496,93,0,1062,56),(6497,143,0,1062,169),(6498,97,0,1063,1),(6499,134,0,1063,2),(6500,115,0,1063,1),(6501,99,0,1063,1),(6502,93,0,1063,50),(6503,143,0,1063,170),(6504,97,0,1064,1),(6505,134,0,1064,2),(6506,115,0,1064,1),(6507,99,0,1064,1),(6508,93,0,1064,53),(6509,143,0,1064,170),(6510,97,0,1065,1),(6511,134,0,1065,2),(6512,115,0,1065,1),(6513,99,0,1065,1),(6514,93,0,1065,56),(6515,143,0,1065,170),(6516,97,0,1066,1),(6517,134,0,1066,2),(6518,115,0,1066,1),(6519,99,0,1066,4),(6520,144,0,1066,0),(6521,145,0,1066,0),(6522,146,0,1066,0),(6523,147,0,1066,0),(6524,148,0,1066,1),(6525,97,0,1067,1),(6526,134,0,1067,2),(6527,115,0,1067,1),(6528,99,0,1067,1),(6529,93,0,1067,53),(6530,143,0,1067,166),(6531,97,0,1068,1),(6532,134,0,1068,2),(6533,115,0,1068,1),(6534,99,0,1068,1),(6535,93,0,1068,57),(6536,143,0,1068,166),(6537,97,0,1069,1),(6538,134,0,1069,2),(6539,115,0,1069,1),(6540,99,0,1069,1),(6541,93,0,1069,58),(6542,143,0,1069,166),(6543,97,0,1070,1),(6544,134,0,1070,2),(6545,115,0,1070,1),(6546,99,0,1070,1),(6547,93,0,1070,53),(6548,143,0,1070,167),(6549,97,0,1071,1),(6550,134,0,1071,2),(6551,115,0,1071,1),(6552,99,0,1071,1),(6553,93,0,1071,57),(6554,143,0,1071,167),(6555,97,0,1072,1),(6556,134,0,1072,2),(6557,115,0,1072,1),(6558,99,0,1072,1),(6559,93,0,1072,58),(6560,143,0,1072,167),(6561,97,0,1073,1),(6562,134,0,1073,2),(6563,115,0,1073,1),(6564,99,0,1073,1),(6565,93,0,1073,53),(6566,143,0,1073,168),(6567,97,0,1074,1),(6568,134,0,1074,2),(6569,115,0,1074,1),(6570,99,0,1074,1),(6571,93,0,1074,57),(6572,143,0,1074,168),(6573,97,0,1075,1),(6574,134,0,1075,2),(6575,115,0,1075,1),(6576,99,0,1075,1),(6577,93,0,1075,58),(6578,143,0,1075,168),(6579,97,0,1076,1),(6580,134,0,1076,2),(6581,115,0,1076,1),(6582,99,0,1076,1),(6583,93,0,1076,53),(6584,143,0,1076,169),(6585,97,0,1077,1),(6586,134,0,1077,2),(6587,115,0,1077,1),(6588,99,0,1077,1),(6589,93,0,1077,57),(6590,143,0,1077,169),(6591,97,0,1078,1),(6592,134,0,1078,2),(6593,115,0,1078,1),(6594,99,0,1078,1),(6595,93,0,1078,58),(6596,143,0,1078,169),(6597,97,0,1079,1),(6598,134,0,1079,2),(6599,115,0,1079,1),(6600,99,0,1079,1),(6601,93,0,1079,53),(6602,143,0,1079,170),(6603,97,0,1080,1),(6604,134,0,1080,2),(6605,115,0,1080,1),(6606,99,0,1080,1),(6607,93,0,1080,57),(6608,143,0,1080,170),(6609,97,0,1081,1),(6610,134,0,1081,2),(6611,115,0,1081,1),(6612,99,0,1081,1),(6613,93,0,1081,58),(6614,143,0,1081,170),(6615,97,0,1082,1),(6616,134,0,1082,2),(6617,115,0,1082,1),(6618,99,0,1082,4),(6619,144,0,1082,0),(6620,145,0,1082,0),(6621,146,0,1082,0),(6622,147,0,1082,0),(6623,148,0,1082,0),(6624,97,0,1083,1),(6625,134,0,1083,2),(6626,115,0,1083,1),(6627,99,0,1083,1),(6628,93,0,1083,50),(6629,143,0,1083,166),(6630,97,0,1084,1),(6631,134,0,1084,2),(6632,115,0,1084,1),(6633,99,0,1084,1),(6634,93,0,1084,56),(6635,143,0,1084,166),(6636,97,0,1085,1),(6637,134,0,1085,2),(6638,115,0,1085,1),(6639,99,0,1085,1),(6640,93,0,1085,57),(6641,143,0,1085,166),(6642,97,0,1086,1),(6643,134,0,1086,2),(6644,115,0,1086,1),(6645,99,0,1086,1),(6646,93,0,1086,50),(6647,143,0,1086,167),(6648,97,0,1087,1),(6649,134,0,1087,2),(6650,115,0,1087,1),(6651,99,0,1087,1),(6652,93,0,1087,56),(6653,143,0,1087,167),(6654,97,0,1088,1),(6655,134,0,1088,2),(6656,115,0,1088,1),(6657,99,0,1088,1),(6658,93,0,1088,57),(6659,143,0,1088,167),(6660,97,0,1089,1),(6661,134,0,1089,2),(6662,115,0,1089,1),(6663,99,0,1089,1),(6664,93,0,1089,50),(6665,143,0,1089,168),(6666,97,0,1090,1),(6667,134,0,1090,2),(6668,115,0,1090,1),(6669,99,0,1090,1),(6670,93,0,1090,56),(6671,143,0,1090,168),(6672,97,0,1091,1),(6673,134,0,1091,2),(6674,115,0,1091,1),(6675,99,0,1091,1),(6676,93,0,1091,57),(6677,143,0,1091,168),(6678,97,0,1092,1),(6679,134,0,1092,2),(6680,115,0,1092,1),(6681,99,0,1092,1),(6682,93,0,1092,50),(6683,143,0,1092,169),(6684,97,0,1093,1),(6685,134,0,1093,2),(6686,115,0,1093,1),(6687,99,0,1093,1),(6688,93,0,1093,56),(6689,143,0,1093,169),(6690,97,0,1094,1),(6691,134,0,1094,2),(6692,115,0,1094,1),(6693,99,0,1094,1),(6694,93,0,1094,57),(6695,143,0,1094,169),(6696,97,0,1095,1),(6697,134,0,1095,2),(6698,115,0,1095,1),(6699,99,0,1095,1),(6700,93,0,1095,50),(6701,143,0,1095,170),(6702,97,0,1096,1),(6703,134,0,1096,2),(6704,115,0,1096,1),(6705,99,0,1096,1),(6706,93,0,1096,56),(6707,143,0,1096,170),(6708,97,0,1097,1),(6709,134,0,1097,2),(6710,115,0,1097,1),(6711,99,0,1097,1),(6712,93,0,1097,57),(6713,143,0,1097,170),(6714,97,0,1098,1),(6715,134,0,1098,2),(6716,115,0,1098,1),(6717,99,0,1098,4),(6718,144,0,1098,0),(6719,145,0,1098,0),(6720,146,0,1098,0),(6721,147,0,1098,0),(6722,148,0,1098,0),(6723,97,0,1099,1),(6724,134,0,1099,2),(6725,115,0,1099,1),(6726,99,0,1099,1),(6727,93,0,1099,56),(6728,143,0,1099,166),(6729,97,0,1100,1),(6730,134,0,1100,2),(6731,115,0,1100,1),(6732,99,0,1100,1),(6733,93,0,1100,57),(6734,143,0,1100,166),(6735,97,0,1101,1),(6736,134,0,1101,2),(6737,115,0,1101,1),(6738,99,0,1101,1),(6739,93,0,1101,59),(6740,143,0,1101,166),(6741,97,0,1102,1),(6742,134,0,1102,2),(6743,115,0,1102,1),(6744,99,0,1102,1),(6745,93,0,1102,56),(6746,143,0,1102,167),(6747,97,0,1103,1),(6748,134,0,1103,2),(6749,115,0,1103,1),(6750,99,0,1103,1),(6751,93,0,1103,57),(6752,143,0,1103,167),(6753,97,0,1104,1),(6754,134,0,1104,2),(6755,115,0,1104,1),(6756,99,0,1104,1),(6757,93,0,1104,59),(6758,143,0,1104,167),(6759,97,0,1105,1),(6760,134,0,1105,2),(6761,115,0,1105,1),(6762,99,0,1105,1),(6763,93,0,1105,56),(6764,143,0,1105,168),(6765,97,0,1106,1),(6766,134,0,1106,2),(6767,115,0,1106,1),(6768,99,0,1106,1),(6769,93,0,1106,57),(6770,143,0,1106,168),(6771,97,0,1107,1),(6772,134,0,1107,2),(6773,115,0,1107,1),(6774,99,0,1107,1),(6775,93,0,1107,59),(6776,143,0,1107,168),(6777,97,0,1108,1),(6778,134,0,1108,2),(6779,115,0,1108,1),(6780,99,0,1108,1),(6781,93,0,1108,56),(6782,143,0,1108,169),(6783,97,0,1109,1),(6784,134,0,1109,2),(6785,115,0,1109,1),(6786,99,0,1109,1),(6787,93,0,1109,57),(6788,143,0,1109,169),(6789,97,0,1110,1),(6790,134,0,1110,2),(6791,115,0,1110,1),(6792,99,0,1110,1),(6793,93,0,1110,59),(6794,143,0,1110,169),(6795,97,0,1111,1),(6796,134,0,1111,2),(6797,115,0,1111,1),(6798,99,0,1111,1),(6799,93,0,1111,56),(6800,143,0,1111,170),(6801,97,0,1112,1),(6802,134,0,1112,2),(6803,115,0,1112,1),(6804,99,0,1112,1),(6805,93,0,1112,57),(6806,143,0,1112,170),(6807,97,0,1113,1),(6808,134,0,1113,2),(6809,115,0,1113,1),(6810,99,0,1113,1),(6811,93,0,1113,59),(6812,143,0,1113,170),(6813,97,0,1114,1),(6814,134,0,1114,2),(6815,115,0,1114,1),(6816,99,0,1114,4),(6817,144,0,1114,0),(6818,145,0,1114,0),(6819,146,0,1114,0),(6820,147,0,1114,0),(6821,148,0,1114,0),(6822,97,0,1115,1),(6823,134,0,1115,2),(6824,115,0,1115,1),(6825,99,0,1115,1),(6826,93,0,1115,57),(6827,143,0,1115,166),(6828,97,0,1116,1),(6829,134,0,1116,2),(6830,115,0,1116,1),(6831,99,0,1116,1),(6832,93,0,1116,57),(6833,143,0,1116,167),(6834,97,0,1117,1),(6835,134,0,1117,2),(6836,115,0,1117,1),(6837,99,0,1117,1),(6838,93,0,1117,57),(6839,143,0,1117,168),(6840,97,0,1118,1),(6841,134,0,1118,2),(6842,115,0,1118,1),(6843,99,0,1118,1),(6844,93,0,1118,57),(6845,143,0,1118,169),(6846,97,0,1119,1),(6847,134,0,1119,2),(6848,115,0,1119,1),(6849,99,0,1119,1),(6850,93,0,1119,57),(6851,143,0,1119,170),(6852,97,0,1120,1),(6853,134,0,1120,2),(6854,115,0,1120,1),(6855,99,0,1120,4),(6856,144,0,1120,0),(6857,145,0,1120,0),(6858,146,0,1120,0),(6859,147,0,1120,0),(6860,148,0,1120,0),(6861,97,0,1121,1),(6862,134,0,1121,2),(6863,115,0,1121,1),(6864,99,0,1121,1),(6865,93,0,1121,52),(6866,143,0,1121,166),(6867,97,0,1122,1),(6868,134,0,1122,2),(6869,115,0,1122,1),(6870,99,0,1122,1),(6871,93,0,1122,57),(6872,143,0,1122,166),(6873,97,0,1123,1),(6874,134,0,1123,2),(6875,115,0,1123,1),(6876,99,0,1123,1),(6877,93,0,1123,59),(6878,143,0,1123,166),(6879,97,0,1124,1),(6880,134,0,1124,2),(6881,115,0,1124,1),(6882,99,0,1124,1),(6883,93,0,1124,52),(6884,143,0,1124,167),(6885,97,0,1125,1),(6886,134,0,1125,2),(6887,115,0,1125,1),(6888,99,0,1125,1),(6889,93,0,1125,57),(6890,143,0,1125,167),(6891,97,0,1126,1),(6892,134,0,1126,2),(6893,115,0,1126,1),(6894,99,0,1126,1),(6895,93,0,1126,59),(6896,143,0,1126,167),(6897,97,0,1127,1),(6898,134,0,1127,2),(6899,115,0,1127,1),(6900,99,0,1127,1),(6901,93,0,1127,52),(6902,143,0,1127,168),(6903,97,0,1128,1),(6904,134,0,1128,2),(6905,115,0,1128,1),(6906,99,0,1128,1),(6907,93,0,1128,57),(6908,143,0,1128,168),(6909,97,0,1129,1),(6910,134,0,1129,2),(6911,115,0,1129,1),(6912,99,0,1129,1),(6913,93,0,1129,59),(6914,143,0,1129,168),(6915,97,0,1130,1),(6916,134,0,1130,2),(6917,115,0,1130,1),(6918,99,0,1130,1),(6919,93,0,1130,52),(6920,143,0,1130,169),(6921,97,0,1131,1),(6922,134,0,1131,2),(6923,115,0,1131,1),(6924,99,0,1131,1),(6925,93,0,1131,57),(6926,143,0,1131,169),(6927,97,0,1132,1),(6928,134,0,1132,2),(6929,115,0,1132,1),(6930,99,0,1132,1),(6931,93,0,1132,59),(6932,143,0,1132,169),(6933,97,0,1133,1),(6934,134,0,1133,2),(6935,115,0,1133,1),(6936,99,0,1133,1),(6937,93,0,1133,52),(6938,143,0,1133,170),(6939,97,0,1134,1),(6940,134,0,1134,2),(6941,115,0,1134,1),(6942,99,0,1134,1),(6943,93,0,1134,57),(6944,143,0,1134,170),(6945,97,0,1135,1),(6946,134,0,1135,2),(6947,115,0,1135,1),(6948,99,0,1135,1),(6949,93,0,1135,59),(6950,143,0,1135,170),(6951,97,0,1136,1),(6952,134,0,1136,2),(6953,115,0,1136,1),(6954,99,0,1136,4),(6955,144,0,1136,0),(6956,145,0,1136,0),(6957,146,0,1136,1),(6958,147,0,1136,1),(6959,148,0,1136,0),(6960,97,0,1137,1),(6961,134,0,1137,2),(6962,115,0,1137,1),(6963,99,0,1137,1),(6964,93,0,1137,56),(6965,143,0,1137,166),(6966,97,0,1138,1),(6967,134,0,1138,2),(6968,115,0,1138,1),(6969,99,0,1138,1),(6970,93,0,1138,57),(6971,143,0,1138,166),(6972,97,0,1139,1),(6973,134,0,1139,2),(6974,115,0,1139,1),(6975,99,0,1139,1),(6976,93,0,1139,59),(6977,143,0,1139,166),(6978,97,0,1140,1),(6979,134,0,1140,2),(6980,115,0,1140,1),(6981,99,0,1140,1),(6982,93,0,1140,56),(6983,143,0,1140,167),(6984,97,0,1141,1),(6985,134,0,1141,2),(6986,115,0,1141,1),(6987,99,0,1141,1),(6988,93,0,1141,57),(6989,143,0,1141,167),(6990,97,0,1142,1),(6991,134,0,1142,2),(6992,115,0,1142,1),(6993,99,0,1142,1),(6994,93,0,1142,59),(6995,143,0,1142,167),(6996,97,0,1143,1),(6997,134,0,1143,2),(6998,115,0,1143,1),(6999,99,0,1143,1),(7000,93,0,1143,56),(7001,143,0,1143,168),(7002,97,0,1144,1),(7003,134,0,1144,2),(7004,115,0,1144,1),(7005,99,0,1144,1),(7006,93,0,1144,57),(7007,143,0,1144,168),(7008,97,0,1145,1),(7009,134,0,1145,2),(7010,115,0,1145,1),(7011,99,0,1145,1),(7012,93,0,1145,59),(7013,143,0,1145,168),(7014,97,0,1146,1),(7015,134,0,1146,2),(7016,115,0,1146,1),(7017,99,0,1146,1),(7018,93,0,1146,56),(7019,143,0,1146,169),(7020,97,0,1147,1),(7021,134,0,1147,2),(7022,115,0,1147,1),(7023,99,0,1147,1),(7024,93,0,1147,57),(7025,143,0,1147,169),(7026,97,0,1148,1),(7027,134,0,1148,2),(7028,115,0,1148,1),(7029,99,0,1148,1),(7030,93,0,1148,59),(7031,143,0,1148,169),(7032,97,0,1149,1),(7033,134,0,1149,2),(7034,115,0,1149,1),(7035,99,0,1149,1),(7036,93,0,1149,56),(7037,143,0,1149,170),(7038,97,0,1150,1),(7039,134,0,1150,2),(7040,115,0,1150,1),(7041,99,0,1150,1),(7042,93,0,1150,57),(7043,143,0,1150,170),(7044,97,0,1151,1),(7045,134,0,1151,2),(7046,115,0,1151,1),(7047,99,0,1151,1),(7048,93,0,1151,59),(7049,143,0,1151,170),(7050,97,0,1152,1),(7051,134,0,1152,2),(7052,115,0,1152,1),(7053,99,0,1152,4),(7054,144,0,1152,0),(7055,145,0,1152,1),(7056,146,0,1152,0),(7057,147,0,1152,0),(7058,148,0,1152,1),(7059,97,0,1153,1),(7060,134,0,1153,2),(7061,115,0,1153,1),(7062,99,0,1153,1),(7063,93,0,1153,53),(7064,143,0,1153,166),(7065,97,0,1154,1),(7066,134,0,1154,2),(7067,115,0,1154,1),(7068,99,0,1154,1),(7069,93,0,1154,57),(7070,143,0,1154,166),(7071,97,0,1155,1),(7072,134,0,1155,2),(7073,115,0,1155,1),(7074,99,0,1155,1),(7075,93,0,1155,58),(7076,143,0,1155,166),(7077,97,0,1156,1),(7078,134,0,1156,2),(7079,115,0,1156,1),(7080,99,0,1156,1),(7081,93,0,1156,53),(7082,143,0,1156,167),(7083,97,0,1157,1),(7084,134,0,1157,2),(7085,115,0,1157,1),(7086,99,0,1157,1),(7087,93,0,1157,57),(7088,143,0,1157,167),(7089,97,0,1158,1),(7090,134,0,1158,2),(7091,115,0,1158,1),(7092,99,0,1158,1),(7093,93,0,1158,58),(7094,143,0,1158,167),(7095,97,0,1159,1),(7096,134,0,1159,2),(7097,115,0,1159,1),(7098,99,0,1159,1),(7099,93,0,1159,53),(7100,143,0,1159,168),(7101,97,0,1160,1),(7102,134,0,1160,2),(7103,115,0,1160,1),(7104,99,0,1160,1),(7105,93,0,1160,57),(7106,143,0,1160,168),(7107,97,0,1161,1),(7108,134,0,1161,2),(7109,115,0,1161,1),(7110,99,0,1161,1),(7111,93,0,1161,58),(7112,143,0,1161,168),(7113,97,0,1162,1),(7114,134,0,1162,2),(7115,115,0,1162,1),(7116,99,0,1162,1),(7117,93,0,1162,53),(7118,143,0,1162,169),(7119,97,0,1163,1),(7120,134,0,1163,2),(7121,115,0,1163,1),(7122,99,0,1163,1),(7123,93,0,1163,57),(7124,143,0,1163,169),(7125,97,0,1164,1),(7126,134,0,1164,2),(7127,115,0,1164,1),(7128,99,0,1164,1),(7129,93,0,1164,58),(7130,143,0,1164,169),(7131,97,0,1165,1),(7132,134,0,1165,2),(7133,115,0,1165,1),(7134,99,0,1165,1),(7135,93,0,1165,53),(7136,143,0,1165,170),(7137,97,0,1166,1),(7138,134,0,1166,2),(7139,115,0,1166,1),(7140,99,0,1166,1),(7141,93,0,1166,57),(7142,143,0,1166,170),(7143,97,0,1167,1),(7144,134,0,1167,2),(7145,115,0,1167,1),(7146,99,0,1167,1),(7147,93,0,1167,58),(7148,143,0,1167,170),(7149,97,0,1168,1),(7150,134,0,1168,2),(7151,115,0,1168,1),(7152,99,0,1168,4),(7153,144,0,1168,1),(7154,145,0,1168,0),(7155,146,0,1168,0),(7156,147,0,1168,0),(7157,148,0,1168,0),(7158,97,0,1169,1),(7159,134,0,1169,2),(7160,115,0,1169,1),(7161,99,0,1169,1),(7162,93,0,1169,50),(7163,143,0,1169,166),(7164,97,0,1170,1),(7165,134,0,1170,2),(7166,115,0,1170,1),(7167,99,0,1170,1),(7168,93,0,1170,52),(7169,143,0,1170,166),(7170,97,0,1171,1),(7171,134,0,1171,2),(7172,115,0,1171,1),(7173,99,0,1171,1),(7174,93,0,1171,60),(7175,143,0,1171,166),(7176,97,0,1172,1),(7177,134,0,1172,2),(7178,115,0,1172,1),(7179,99,0,1172,1),(7180,93,0,1172,50),(7181,143,0,1172,167),(7182,97,0,1173,1),(7183,134,0,1173,2),(7184,115,0,1173,1),(7185,99,0,1173,1),(7186,93,0,1173,52),(7187,143,0,1173,167),(7188,97,0,1174,1),(7189,134,0,1174,2),(7190,115,0,1174,1),(7191,99,0,1174,1),(7192,93,0,1174,60),(7193,143,0,1174,167),(7194,97,0,1175,1),(7195,134,0,1175,2),(7196,115,0,1175,1),(7197,99,0,1175,1),(7198,93,0,1175,50),(7199,143,0,1175,168),(7200,97,0,1176,1),(7201,134,0,1176,2),(7202,115,0,1176,1),(7203,99,0,1176,1),(7204,93,0,1176,52),(7205,143,0,1176,168),(7206,97,0,1177,1),(7207,134,0,1177,2),(7208,115,0,1177,1),(7209,99,0,1177,1),(7210,93,0,1177,60),(7211,143,0,1177,168),(7212,97,0,1178,1),(7213,134,0,1178,2),(7214,115,0,1178,1),(7215,99,0,1178,1),(7216,93,0,1178,50),(7217,143,0,1178,169),(7218,97,0,1179,1),(7219,134,0,1179,2),(7220,115,0,1179,1),(7221,99,0,1179,1),(7222,93,0,1179,52),(7223,143,0,1179,169),(7224,97,0,1180,1),(7225,134,0,1180,2),(7226,115,0,1180,1),(7227,99,0,1180,1),(7228,93,0,1180,60),(7229,143,0,1180,169),(7230,97,0,1181,1),(7231,134,0,1181,2),(7232,115,0,1181,1),(7233,99,0,1181,1),(7234,93,0,1181,50),(7235,143,0,1181,170),(7236,97,0,1182,1),(7237,134,0,1182,2),(7238,115,0,1182,1),(7239,99,0,1182,1),(7240,93,0,1182,52),(7241,143,0,1182,170),(7242,97,0,1183,1),(7243,134,0,1183,2),(7244,115,0,1183,1),(7245,99,0,1183,1),(7246,93,0,1183,60),(7247,143,0,1183,170),(7248,97,0,1184,1),(7249,134,0,1184,2),(7250,115,0,1184,1),(7251,99,0,1184,4),(7252,144,0,1184,0),(7253,145,0,1184,0),(7254,146,0,1184,0),(7255,147,0,1184,1),(7256,148,0,1184,0),(7257,97,0,1185,1),(7258,134,0,1185,2),(7259,115,0,1185,1),(7260,99,0,1185,1),(7261,93,0,1185,50),(7262,143,0,1185,166),(7263,97,0,1186,1),(7264,134,0,1186,2),(7265,115,0,1186,1),(7266,99,0,1186,1),(7267,93,0,1186,53),(7268,143,0,1186,166),(7269,97,0,1187,1),(7270,134,0,1187,2),(7271,115,0,1187,1),(7272,99,0,1187,1),(7273,93,0,1187,56),(7274,143,0,1187,166),(7275,97,0,1188,1),(7276,134,0,1188,2),(7277,115,0,1188,1),(7278,99,0,1188,1),(7279,93,0,1188,50),(7280,143,0,1188,167),(7281,97,0,1189,1),(7282,134,0,1189,2),(7283,115,0,1189,1),(7284,99,0,1189,1),(7285,93,0,1189,53),(7286,143,0,1189,167),(7287,97,0,1190,1),(7288,134,0,1190,2),(7289,115,0,1190,1),(7290,99,0,1190,1),(7291,93,0,1190,56),(7292,143,0,1190,167),(7293,97,0,1191,1),(7294,134,0,1191,2),(7295,115,0,1191,1),(7296,99,0,1191,1),(7297,93,0,1191,50),(7298,143,0,1191,168),(7299,97,0,1192,1),(7300,134,0,1192,2),(7301,115,0,1192,1),(7302,99,0,1192,1),(7303,93,0,1192,53),(7304,143,0,1192,168),(7305,97,0,1193,1),(7306,134,0,1193,2),(7307,115,0,1193,1),(7308,99,0,1193,1),(7309,93,0,1193,56),(7310,143,0,1193,168),(7311,97,0,1194,1),(7312,134,0,1194,2),(7313,115,0,1194,1),(7314,99,0,1194,1),(7315,93,0,1194,50),(7316,143,0,1194,169),(7317,97,0,1195,1),(7318,134,0,1195,2),(7319,115,0,1195,1),(7320,99,0,1195,1),(7321,93,0,1195,53),(7322,143,0,1195,169),(7323,97,0,1196,1),(7324,134,0,1196,2),(7325,115,0,1196,1),(7326,99,0,1196,1),(7327,93,0,1196,56),(7328,143,0,1196,169),(7329,97,0,1197,1),(7330,134,0,1197,2),(7331,115,0,1197,1),(7332,99,0,1197,1),(7333,93,0,1197,50),(7334,143,0,1197,170),(7335,97,0,1198,1),(7336,134,0,1198,2),(7337,115,0,1198,1),(7338,99,0,1198,1),(7339,93,0,1198,53),(7340,143,0,1198,170),(7341,97,0,1199,1),(7342,134,0,1199,2),(7343,115,0,1199,1),(7344,99,0,1199,1),(7345,93,0,1199,56),(7346,143,0,1199,170),(7347,97,0,1200,1),(7348,134,0,1200,2),(7349,115,0,1200,1),(7350,99,0,1200,4),(7351,144,0,1200,0),(7352,145,0,1200,0),(7353,146,0,1200,1),(7354,147,0,1200,0),(7355,148,0,1200,0),(7356,97,0,1201,1),(7357,134,0,1201,2),(7358,115,0,1201,1),(7359,99,0,1201,1),(7360,93,0,1201,52),(7361,143,0,1201,166),(7362,97,0,1202,1),(7363,134,0,1202,2),(7364,115,0,1202,1),(7365,99,0,1202,1),(7366,93,0,1202,53),(7367,143,0,1202,166),(7368,97,0,1203,1),(7369,134,0,1203,2),(7370,115,0,1203,1),(7371,99,0,1203,1),(7372,93,0,1203,57),(7373,143,0,1203,166),(7374,97,0,1204,1),(7375,134,0,1204,2),(7376,115,0,1204,1),(7377,99,0,1204,1),(7378,93,0,1204,52),(7379,143,0,1204,167),(7380,97,0,1205,1),(7381,134,0,1205,2),(7382,115,0,1205,1),(7383,99,0,1205,1),(7384,93,0,1205,53),(7385,143,0,1205,167),(7386,97,0,1206,1),(7387,134,0,1206,2),(7388,115,0,1206,1),(7389,99,0,1206,1),(7390,93,0,1206,57),(7391,143,0,1206,167),(7392,97,0,1207,1),(7393,134,0,1207,2),(7394,115,0,1207,1),(7395,99,0,1207,1),(7396,93,0,1207,52),(7397,143,0,1207,168),(7398,97,0,1208,1),(7399,134,0,1208,2),(7400,115,0,1208,1),(7401,99,0,1208,1),(7402,93,0,1208,53),(7403,143,0,1208,168),(7404,97,0,1209,1),(7405,134,0,1209,2),(7406,115,0,1209,1),(7407,99,0,1209,1),(7408,93,0,1209,57),(7409,143,0,1209,168),(7410,97,0,1210,1),(7411,134,0,1210,2),(7412,115,0,1210,1),(7413,99,0,1210,1),(7414,93,0,1210,52),(7415,143,0,1210,169),(7416,97,0,1211,1),(7417,134,0,1211,2),(7418,115,0,1211,1),(7419,99,0,1211,1),(7420,93,0,1211,53),(7421,143,0,1211,169),(7422,97,0,1212,1),(7423,134,0,1212,2),(7424,115,0,1212,1),(7425,99,0,1212,1),(7426,93,0,1212,57),(7427,143,0,1212,169),(7428,97,0,1213,1),(7429,134,0,1213,2),(7430,115,0,1213,1),(7431,99,0,1213,1),(7432,93,0,1213,52),(7433,143,0,1213,170),(7434,97,0,1214,1),(7435,134,0,1214,2),(7436,115,0,1214,1),(7437,99,0,1214,1),(7438,93,0,1214,53),(7439,143,0,1214,170),(7440,97,0,1215,1),(7441,134,0,1215,2),(7442,115,0,1215,1),(7443,99,0,1215,1),(7444,93,0,1215,57),(7445,143,0,1215,170),(7446,97,0,1216,1),(7447,134,0,1216,2),(7448,115,0,1216,1),(7449,99,0,1216,4),(7450,144,0,1216,1),(7451,145,0,1216,1),(7452,146,0,1216,0),(7453,147,0,1216,0),(7454,148,0,1216,0),(7455,97,0,1217,1),(7456,134,0,1217,2),(7457,115,0,1217,1),(7458,99,0,1217,1),(7459,93,0,1217,50),(7460,143,0,1217,167),(7461,97,0,1218,1),(7462,134,0,1218,2),(7463,115,0,1218,1),(7464,99,0,1218,1),(7465,93,0,1218,58),(7466,143,0,1218,167),(7467,97,0,1219,1),(7468,134,0,1219,2),(7469,115,0,1219,1),(7470,99,0,1219,1),(7471,93,0,1219,60),(7472,143,0,1219,167),(7473,97,0,1220,1),(7474,134,0,1220,2),(7475,115,0,1220,1),(7476,99,0,1220,1),(7477,93,0,1220,50),(7478,143,0,1220,168),(7479,97,0,1221,1),(7480,134,0,1221,2),(7481,115,0,1221,1),(7482,99,0,1221,1),(7483,93,0,1221,58),(7484,143,0,1221,168),(7485,97,0,1222,1),(7486,134,0,1222,2),(7487,115,0,1222,1),(7488,99,0,1222,1),(7489,93,0,1222,60),(7490,143,0,1222,168),(7491,97,0,1223,1),(7492,134,0,1223,2),(7493,115,0,1223,1),(7494,99,0,1223,1),(7495,93,0,1223,50),(7496,143,0,1223,169),(7497,97,0,1224,1),(7498,134,0,1224,2),(7499,115,0,1224,1),(7500,99,0,1224,1),(7501,93,0,1224,58),(7502,143,0,1224,169),(7503,97,0,1225,1),(7504,134,0,1225,2),(7505,115,0,1225,1),(7506,99,0,1225,1),(7507,93,0,1225,60),(7508,143,0,1225,169),(7509,97,0,1226,1),(7510,134,0,1226,2),(7511,115,0,1226,1),(7512,99,0,1226,4),(7513,144,0,1226,1),(7514,145,0,1226,0),(7515,146,0,1226,1),(7516,147,0,1226,1),(7517,148,0,1226,0),(7518,97,0,1227,1),(7519,134,0,1227,2),(7520,115,0,1227,1),(7521,99,0,1227,1),(7522,93,0,1227,49),(7523,143,0,1227,166),(7524,97,0,1228,1),(7525,134,0,1228,2),(7526,115,0,1228,1),(7527,99,0,1228,1),(7528,93,0,1228,50),(7529,143,0,1228,166),(7530,97,0,1229,1),(7531,134,0,1229,2),(7532,115,0,1229,1),(7533,99,0,1229,1),(7534,93,0,1229,52),(7535,143,0,1229,166),(7536,97,0,1230,1),(7537,134,0,1230,2),(7538,115,0,1230,1),(7539,99,0,1230,1),(7540,93,0,1230,49),(7541,143,0,1230,167),(7542,97,0,1231,1),(7543,134,0,1231,2),(7544,115,0,1231,1),(7545,99,0,1231,1),(7546,93,0,1231,50),(7547,143,0,1231,167),(7548,97,0,1232,1),(7549,134,0,1232,2),(7550,115,0,1232,1),(7551,99,0,1232,1),(7552,93,0,1232,52),(7553,143,0,1232,167),(7554,97,0,1233,1),(7555,134,0,1233,2),(7556,115,0,1233,1),(7557,99,0,1233,1),(7558,93,0,1233,49),(7559,143,0,1233,168),(7560,97,0,1234,1),(7561,134,0,1234,2),(7562,115,0,1234,1),(7563,99,0,1234,1),(7564,93,0,1234,50),(7565,143,0,1234,168),(7566,97,0,1235,1),(7567,134,0,1235,2),(7568,115,0,1235,1),(7569,99,0,1235,1),(7570,93,0,1235,52),(7571,143,0,1235,168),(7572,97,0,1236,1),(7573,134,0,1236,2),(7574,115,0,1236,1),(7575,99,0,1236,1),(7576,93,0,1236,49),(7577,143,0,1236,169),(7578,97,0,1237,1),(7579,134,0,1237,2),(7580,115,0,1237,1),(7581,99,0,1237,1),(7582,93,0,1237,50),(7583,143,0,1237,169),(7584,97,0,1238,1),(7585,134,0,1238,2),(7586,115,0,1238,1),(7587,99,0,1238,1),(7588,93,0,1238,52),(7589,143,0,1238,169),(7590,97,0,1239,1),(7591,134,0,1239,2),(7592,115,0,1239,1),(7593,99,0,1239,1),(7594,93,0,1239,49),(7595,143,0,1239,170),(7596,97,0,1240,1),(7597,134,0,1240,2),(7598,115,0,1240,1),(7599,99,0,1240,1),(7600,93,0,1240,50),(7601,143,0,1240,170),(7602,97,0,1241,1),(7603,134,0,1241,2),(7604,115,0,1241,1),(7605,99,0,1241,1),(7606,93,0,1241,52),(7607,143,0,1241,170),(7608,97,0,1242,1),(7609,134,0,1242,2),(7610,115,0,1242,1),(7611,99,0,1242,4),(7612,144,0,1242,0),(7613,145,0,1242,0),(7614,146,0,1242,0),(7615,147,0,1242,0),(7616,148,0,1242,1),(7617,97,0,1243,1),(7618,134,0,1243,2),(7619,115,0,1243,1),(7620,99,0,1243,1),(7621,93,0,1243,50),(7622,143,0,1243,166),(7623,97,0,1244,1),(7624,134,0,1244,2),(7625,115,0,1244,1),(7626,99,0,1244,1),(7627,93,0,1244,56),(7628,143,0,1244,166),(7629,97,0,1245,1),(7630,134,0,1245,2),(7631,115,0,1245,1),(7632,99,0,1245,1),(7633,93,0,1245,58),(7634,143,0,1245,166),(7635,97,0,1246,1),(7636,134,0,1246,2),(7637,115,0,1246,1),(7638,99,0,1246,1),(7639,93,0,1246,50),(7640,143,0,1246,167),(7641,97,0,1247,1),(7642,134,0,1247,2),(7643,115,0,1247,1),(7644,99,0,1247,1),(7645,93,0,1247,56),(7646,143,0,1247,167),(7647,97,0,1248,1),(7648,134,0,1248,2),(7649,115,0,1248,1),(7650,99,0,1248,1),(7651,93,0,1248,58),(7652,143,0,1248,167),(7653,97,0,1249,1),(7654,134,0,1249,2),(7655,115,0,1249,1),(7656,99,0,1249,1),(7657,93,0,1249,50),(7658,143,0,1249,168),(7659,97,0,1250,1),(7660,134,0,1250,2),(7661,115,0,1250,1),(7662,99,0,1250,1),(7663,93,0,1250,56),(7664,143,0,1250,168),(7665,97,0,1251,1),(7666,134,0,1251,2),(7667,115,0,1251,1),(7668,99,0,1251,1),(7669,93,0,1251,58),(7670,143,0,1251,168),(7671,97,0,1252,1),(7672,134,0,1252,2),(7673,115,0,1252,1),(7674,99,0,1252,1),(7675,93,0,1252,50),(7676,143,0,1252,169),(7677,97,0,1253,1),(7678,134,0,1253,2),(7679,115,0,1253,1),(7680,99,0,1253,1),(7681,93,0,1253,56),(7682,143,0,1253,169),(7683,97,0,1254,1),(7684,134,0,1254,2),(7685,115,0,1254,1),(7686,99,0,1254,1),(7687,93,0,1254,58),(7688,143,0,1254,169),(7689,97,0,1255,1),(7690,134,0,1255,2),(7691,115,0,1255,1),(7692,99,0,1255,1),(7693,93,0,1255,50),(7694,143,0,1255,170),(7695,97,0,1256,1),(7696,134,0,1256,2),(7697,115,0,1256,1),(7698,99,0,1256,1),(7699,93,0,1256,56),(7700,143,0,1256,170),(7701,97,0,1257,1),(7702,134,0,1257,2),(7703,115,0,1257,1),(7704,99,0,1257,1),(7705,93,0,1257,58),(7706,143,0,1257,170),(7707,97,0,1258,1),(7708,134,0,1258,2),(7709,115,0,1258,1),(7710,99,0,1258,4),(7711,144,0,1258,0),(7712,145,0,1258,0),(7713,146,0,1258,0),(7714,147,0,1258,0),(7715,148,0,1258,0),(7716,97,0,1259,1),(7717,134,0,1259,2),(7718,115,0,1259,1),(7719,99,0,1259,1),(7720,93,0,1259,56),(7721,143,0,1259,166),(7722,97,0,1260,1),(7723,134,0,1260,2),(7724,115,0,1260,1),(7725,99,0,1260,1),(7726,93,0,1260,58),(7727,143,0,1260,166),(7728,97,0,1261,1),(7729,134,0,1261,2),(7730,115,0,1261,1),(7731,99,0,1261,1),(7732,93,0,1261,59),(7733,143,0,1261,166),(7734,97,0,1262,1),(7735,134,0,1262,2),(7736,115,0,1262,1),(7737,99,0,1262,1),(7738,93,0,1262,56),(7739,143,0,1262,167),(7740,97,0,1263,1),(7741,134,0,1263,2),(7742,115,0,1263,1),(7743,99,0,1263,1),(7744,93,0,1263,58),(7745,143,0,1263,167),(7746,97,0,1264,1),(7747,134,0,1264,2),(7748,115,0,1264,1),(7749,99,0,1264,1),(7750,93,0,1264,59),(7751,143,0,1264,167),(7752,97,0,1265,1),(7753,134,0,1265,2),(7754,115,0,1265,1),(7755,99,0,1265,1),(7756,93,0,1265,56),(7757,143,0,1265,168),(7758,97,0,1266,1),(7759,134,0,1266,2),(7760,115,0,1266,1),(7761,99,0,1266,1),(7762,93,0,1266,58),(7763,143,0,1266,168),(7764,97,0,1267,1),(7765,134,0,1267,2),(7766,115,0,1267,1),(7767,99,0,1267,1),(7768,93,0,1267,59),(7769,143,0,1267,168),(7770,97,0,1268,1),(7771,134,0,1268,2),(7772,115,0,1268,1),(7773,99,0,1268,1),(7774,93,0,1268,56),(7775,143,0,1268,169),(7776,97,0,1269,1),(7777,134,0,1269,2),(7778,115,0,1269,1),(7779,99,0,1269,1),(7780,93,0,1269,58),(7781,143,0,1269,169),(7782,97,0,1270,1),(7783,134,0,1270,2),(7784,115,0,1270,1),(7785,99,0,1270,1),(7786,93,0,1270,59),(7787,143,0,1270,169),(7788,97,0,1271,1),(7789,134,0,1271,2),(7790,115,0,1271,1),(7791,99,0,1271,1),(7792,93,0,1271,56),(7793,143,0,1271,170),(7794,97,0,1272,1),(7795,134,0,1272,2),(7796,115,0,1272,1),(7797,99,0,1272,1),(7798,93,0,1272,58),(7799,143,0,1272,170),(7800,97,0,1273,1),(7801,134,0,1273,2),(7802,115,0,1273,1),(7803,99,0,1273,1),(7804,93,0,1273,59),(7805,143,0,1273,170),(7806,97,0,1274,1),(7807,134,0,1274,2),(7808,115,0,1274,1),(7809,99,0,1274,4),(7810,144,0,1274,0),(7811,145,0,1274,1),(7812,146,0,1274,0),(7813,147,0,1274,1),(7814,148,0,1274,0),(7815,97,0,1275,1),(7816,134,0,1275,2),(7817,115,0,1275,1),(7818,99,0,1275,1),(7819,93,0,1275,51),(7820,143,0,1275,166),(7821,97,0,1276,1),(7822,134,0,1276,2),(7823,115,0,1276,1),(7824,99,0,1276,1),(7825,93,0,1276,53),(7826,143,0,1276,166),(7827,97,0,1277,1),(7828,134,0,1277,2),(7829,115,0,1277,1),(7830,99,0,1277,1),(7831,93,0,1277,58),(7832,143,0,1277,166),(7833,97,0,1278,1),(7834,134,0,1278,2),(7835,115,0,1278,1),(7836,99,0,1278,1),(7837,93,0,1278,51),(7838,143,0,1278,167),(7839,97,0,1279,1),(7840,134,0,1279,2),(7841,115,0,1279,1),(7842,99,0,1279,1),(7843,93,0,1279,53),(7844,143,0,1279,167),(7845,97,0,1280,1),(7846,134,0,1280,2),(7847,115,0,1280,1),(7848,99,0,1280,1),(7849,93,0,1280,58),(7850,143,0,1280,167),(7851,97,0,1281,1),(7852,134,0,1281,2),(7853,115,0,1281,1),(7854,99,0,1281,1),(7855,93,0,1281,51),(7856,143,0,1281,168),(7857,97,0,1282,1),(7858,134,0,1282,2),(7859,115,0,1282,1),(7860,99,0,1282,1),(7861,93,0,1282,53),(7862,143,0,1282,168),(7863,97,0,1283,1),(7864,134,0,1283,2),(7865,115,0,1283,1),(7866,99,0,1283,1),(7867,93,0,1283,58),(7868,143,0,1283,168),(7869,97,0,1284,1),(7870,134,0,1284,2),(7871,115,0,1284,1),(7872,99,0,1284,1),(7873,93,0,1284,51),(7874,143,0,1284,169),(7875,97,0,1285,1),(7876,134,0,1285,2),(7877,115,0,1285,1),(7878,99,0,1285,1),(7879,93,0,1285,53),(7880,143,0,1285,169),(7881,97,0,1286,1),(7882,134,0,1286,2),(7883,115,0,1286,1),(7884,99,0,1286,1),(7885,93,0,1286,58),(7886,143,0,1286,169),(7887,97,0,1287,1),(7888,134,0,1287,2),(7889,115,0,1287,1),(7890,99,0,1287,1),(7891,93,0,1287,51),(7892,143,0,1287,170),(7893,97,0,1288,1),(7894,134,0,1288,2),(7895,115,0,1288,1),(7896,99,0,1288,1),(7897,93,0,1288,53),(7898,143,0,1288,170),(7899,97,0,1289,1),(7900,134,0,1289,2),(7901,115,0,1289,1),(7902,99,0,1289,1),(7903,93,0,1289,58),(7904,143,0,1289,170),(7905,97,0,1290,1),(7906,134,0,1290,2),(7907,115,0,1290,1),(7908,99,0,1290,4),(7909,144,0,1290,0),(7910,145,0,1290,0),(7911,146,0,1290,0),(7912,147,0,1290,0),(7913,148,0,1290,0),(7914,97,0,1291,1),(7915,134,0,1291,2),(7916,115,0,1291,1),(7917,99,0,1291,1),(7918,93,0,1291,56),(7919,143,0,1291,166),(7920,97,0,1292,1),(7921,134,0,1292,2),(7922,115,0,1292,1),(7923,99,0,1292,1),(7924,93,0,1292,57),(7925,143,0,1292,166),(7926,97,0,1293,1),(7927,134,0,1293,2),(7928,115,0,1293,1),(7929,99,0,1293,1),(7930,93,0,1293,58),(7931,143,0,1293,166),(7932,97,0,1294,1),(7933,134,0,1294,2),(7934,115,0,1294,1),(7935,99,0,1294,1),(7936,93,0,1294,56),(7937,143,0,1294,167),(7938,97,0,1295,1),(7939,134,0,1295,2),(7940,115,0,1295,1),(7941,99,0,1295,1),(7942,93,0,1295,57),(7943,143,0,1295,167),(7944,97,0,1296,1),(7945,134,0,1296,2),(7946,115,0,1296,1),(7947,99,0,1296,1),(7948,93,0,1296,58),(7949,143,0,1296,167),(7950,97,0,1297,1),(7951,134,0,1297,2),(7952,115,0,1297,1),(7953,99,0,1297,1),(7954,93,0,1297,56),(7955,143,0,1297,168),(7956,97,0,1298,1),(7957,134,0,1298,2),(7958,115,0,1298,1),(7959,99,0,1298,1),(7960,93,0,1298,57),(7961,143,0,1298,168),(7962,97,0,1299,1),(7963,134,0,1299,2),(7964,115,0,1299,1),(7965,99,0,1299,1),(7966,93,0,1299,58),(7967,143,0,1299,168),(7968,97,0,1300,1),(7969,134,0,1300,2),(7970,115,0,1300,1),(7971,99,0,1300,1),(7972,93,0,1300,56),(7973,143,0,1300,169),(7974,97,0,1301,1),(7975,134,0,1301,2),(7976,115,0,1301,1),(7977,99,0,1301,1),(7978,93,0,1301,57),(7979,143,0,1301,169),(7980,97,0,1302,1),(7981,134,0,1302,2),(7982,115,0,1302,1),(7983,99,0,1302,1),(7984,93,0,1302,58),(7985,143,0,1302,169),(7986,97,0,1303,1),(7987,134,0,1303,2),(7988,115,0,1303,1),(7989,99,0,1303,1),(7990,93,0,1303,56),(7991,143,0,1303,170),(7992,97,0,1304,1),(7993,134,0,1304,2),(7994,115,0,1304,1),(7995,99,0,1304,1),(7996,93,0,1304,57),(7997,143,0,1304,170),(7998,97,0,1305,1),(7999,134,0,1305,2),(8000,115,0,1305,1),(8001,99,0,1305,1),(8002,93,0,1305,58),(8003,143,0,1305,170),(8004,97,0,1306,1),(8005,134,0,1306,2),(8006,115,0,1306,1),(8007,99,0,1306,4),(8008,144,0,1306,0),(8009,145,0,1306,0),(8010,146,0,1306,0),(8011,147,0,1306,0),(8012,148,0,1306,0),(8013,97,0,1307,1),(8014,134,0,1307,2),(8015,115,0,1307,1),(8016,99,0,1307,1),(8017,93,0,1307,52),(8018,143,0,1307,166),(8019,97,0,1308,1),(8020,134,0,1308,2),(8021,115,0,1308,1),(8022,99,0,1308,1),(8023,93,0,1308,56),(8024,143,0,1308,166),(8025,97,0,1309,1),(8026,134,0,1309,2),(8027,115,0,1309,1),(8028,99,0,1309,1),(8029,93,0,1309,57),(8030,143,0,1309,166),(8031,97,0,1310,1),(8032,134,0,1310,2),(8033,115,0,1310,1),(8034,99,0,1310,1),(8035,93,0,1310,52),(8036,143,0,1310,167),(8037,97,0,1311,1),(8038,134,0,1311,2),(8039,115,0,1311,1),(8040,99,0,1311,1),(8041,93,0,1311,56),(8042,143,0,1311,167),(8043,97,0,1312,1),(8044,134,0,1312,2),(8045,115,0,1312,1),(8046,99,0,1312,1),(8047,93,0,1312,57),(8048,143,0,1312,167),(8049,97,0,1313,1),(8050,134,0,1313,2),(8051,115,0,1313,1),(8052,99,0,1313,1),(8053,93,0,1313,52),(8054,143,0,1313,168),(8055,97,0,1314,1),(8056,134,0,1314,2),(8057,115,0,1314,1),(8058,99,0,1314,1),(8059,93,0,1314,56),(8060,143,0,1314,168),(8061,97,0,1315,1),(8062,134,0,1315,2),(8063,115,0,1315,1),(8064,99,0,1315,1),(8065,93,0,1315,57),(8066,143,0,1315,168),(8067,97,0,1316,1),(8068,134,0,1316,2),(8069,115,0,1316,1),(8070,99,0,1316,1),(8071,93,0,1316,52),(8072,143,0,1316,169),(8073,97,0,1317,1),(8074,134,0,1317,2),(8075,115,0,1317,1),(8076,99,0,1317,1),(8077,93,0,1317,56),(8078,143,0,1317,169),(8079,97,0,1318,1),(8080,134,0,1318,2),(8081,115,0,1318,1),(8082,99,0,1318,1),(8083,93,0,1318,57),(8084,143,0,1318,169),(8085,97,0,1319,1),(8086,134,0,1319,2),(8087,115,0,1319,1),(8088,99,0,1319,1),(8089,93,0,1319,52),(8090,143,0,1319,170),(8091,97,0,1320,1),(8092,134,0,1320,2),(8093,115,0,1320,1),(8094,99,0,1320,1),(8095,93,0,1320,56),(8096,143,0,1320,170),(8097,97,0,1321,1),(8098,134,0,1321,2),(8099,115,0,1321,1),(8100,99,0,1321,1),(8101,93,0,1321,57),(8102,143,0,1321,170),(8103,97,0,1322,1),(8104,134,0,1322,2),(8105,115,0,1322,1),(8106,99,0,1322,4),(8107,144,0,1322,1),(8108,145,0,1322,0),(8109,146,0,1322,1),(8110,147,0,1322,0),(8111,148,0,1322,1),(8112,97,0,1323,1),(8113,134,0,1323,2),(8114,115,0,1323,1),(8115,99,0,1323,1),(8116,93,0,1323,50),(8117,143,0,1323,166),(8118,97,0,1324,1),(8119,134,0,1324,2),(8120,115,0,1324,1),(8121,99,0,1324,1),(8122,93,0,1324,52),(8123,143,0,1324,166),(8124,97,0,1325,1),(8125,134,0,1325,2),(8126,115,0,1325,1),(8127,99,0,1325,1),(8128,93,0,1325,53),(8129,143,0,1325,166),(8130,97,0,1326,1),(8131,134,0,1326,2),(8132,115,0,1326,1),(8133,99,0,1326,1),(8134,93,0,1326,50),(8135,143,0,1326,167),(8136,97,0,1327,1),(8137,134,0,1327,2),(8138,115,0,1327,1),(8139,99,0,1327,1),(8140,93,0,1327,52),(8141,143,0,1327,167),(8142,97,0,1328,1),(8143,134,0,1328,2),(8144,115,0,1328,1),(8145,99,0,1328,1),(8146,93,0,1328,53),(8147,143,0,1328,167),(8148,97,0,1329,1),(8149,134,0,1329,2),(8150,115,0,1329,1),(8151,99,0,1329,1),(8152,93,0,1329,50),(8153,143,0,1329,168),(8154,97,0,1330,1),(8155,134,0,1330,2),(8156,115,0,1330,1),(8157,99,0,1330,1),(8158,93,0,1330,52),(8159,143,0,1330,168),(8160,97,0,1331,1),(8161,134,0,1331,2),(8162,115,0,1331,1),(8163,99,0,1331,1),(8164,93,0,1331,53),(8165,143,0,1331,168),(8166,97,0,1332,1),(8167,134,0,1332,2),(8168,115,0,1332,1),(8169,99,0,1332,1),(8170,93,0,1332,50),(8171,143,0,1332,169),(8172,97,0,1333,1),(8173,134,0,1333,2),(8174,115,0,1333,1),(8175,99,0,1333,1),(8176,93,0,1333,52),(8177,143,0,1333,169),(8178,97,0,1334,1),(8179,134,0,1334,2),(8180,115,0,1334,1),(8181,99,0,1334,1),(8182,93,0,1334,53),(8183,143,0,1334,169),(8184,97,0,1335,1),(8185,134,0,1335,2),(8186,115,0,1335,1),(8187,99,0,1335,1),(8188,93,0,1335,50),(8189,143,0,1335,170),(8190,97,0,1336,1),(8191,134,0,1336,2),(8192,115,0,1336,1),(8193,99,0,1336,1),(8194,93,0,1336,52),(8195,143,0,1336,170),(8196,97,0,1337,1),(8197,134,0,1337,2),(8198,115,0,1337,1),(8199,99,0,1337,1),(8200,93,0,1337,53),(8201,143,0,1337,170),(8202,97,0,1338,1),(8203,134,0,1338,2),(8204,115,0,1338,1),(8205,99,0,1338,4),(8206,144,0,1338,1),(8207,145,0,1338,0),(8208,146,0,1338,1),(8209,147,0,1338,0),(8210,148,0,1338,0),(8211,97,0,1339,1),(8212,134,0,1339,2),(8213,115,0,1339,1),(8214,99,0,1339,1),(8215,93,0,1339,49),(8216,143,0,1339,166),(8217,97,0,1340,1),(8218,134,0,1340,2),(8219,115,0,1340,1),(8220,99,0,1340,1),(8221,93,0,1340,56),(8222,143,0,1340,166),(8223,97,0,1341,1),(8224,134,0,1341,2),(8225,115,0,1341,1),(8226,99,0,1341,1),(8227,93,0,1341,60),(8228,143,0,1341,166),(8229,97,0,1342,1),(8230,134,0,1342,2),(8231,115,0,1342,1),(8232,99,0,1342,1),(8233,93,0,1342,49),(8234,143,0,1342,167),(8235,97,0,1343,1),(8236,134,0,1343,2),(8237,115,0,1343,1),(8238,99,0,1343,1),(8239,93,0,1343,56),(8240,143,0,1343,167),(8241,97,0,1344,1),(8242,134,0,1344,2),(8243,115,0,1344,1),(8244,99,0,1344,1),(8245,93,0,1344,60),(8246,143,0,1344,167),(8247,97,0,1345,1),(8248,134,0,1345,2),(8249,115,0,1345,1),(8250,99,0,1345,1),(8251,93,0,1345,49),(8252,143,0,1345,168),(8253,97,0,1346,1),(8254,134,0,1346,2),(8255,115,0,1346,1),(8256,99,0,1346,1),(8257,93,0,1346,56),(8258,143,0,1346,168),(8259,97,0,1347,1),(8260,134,0,1347,2),(8261,115,0,1347,1),(8262,99,0,1347,1),(8263,93,0,1347,60),(8264,143,0,1347,168),(8265,97,0,1348,1),(8266,134,0,1348,2),(8267,115,0,1348,1),(8268,99,0,1348,1),(8269,93,0,1348,49),(8270,143,0,1348,169),(8271,97,0,1349,1),(8272,134,0,1349,2),(8273,115,0,1349,1),(8274,99,0,1349,1),(8275,93,0,1349,56),(8276,143,0,1349,169),(8277,97,0,1350,1),(8278,134,0,1350,2),(8279,115,0,1350,1),(8280,99,0,1350,1),(8281,93,0,1350,60),(8282,143,0,1350,169),(8283,97,0,1351,1),(8284,134,0,1351,2),(8285,115,0,1351,1),(8286,99,0,1351,1),(8287,93,0,1351,49),(8288,143,0,1351,170),(8289,97,0,1352,1),(8290,134,0,1352,2),(8291,115,0,1352,1),(8292,99,0,1352,1),(8293,93,0,1352,56),(8294,143,0,1352,170),(8295,97,0,1353,1),(8296,134,0,1353,2),(8297,115,0,1353,1),(8298,99,0,1353,1),(8299,93,0,1353,60),(8300,143,0,1353,170),(8301,97,0,1354,1),(8302,134,0,1354,2),(8303,115,0,1354,1),(8304,99,0,1354,4),(8305,144,0,1354,0),(8306,145,0,1354,1),(8307,146,0,1354,0),(8308,147,0,1354,1),(8309,148,0,1354,0),(8310,97,0,1355,1),(8311,134,0,1355,2),(8312,115,0,1355,1),(8313,99,0,1355,1),(8314,93,0,1355,49),(8315,143,0,1355,166),(8316,97,0,1356,1),(8317,134,0,1356,2),(8318,115,0,1356,1),(8319,99,0,1356,1),(8320,93,0,1356,50),(8321,143,0,1356,166),(8322,97,0,1357,1),(8323,134,0,1357,2),(8324,115,0,1357,1),(8325,99,0,1357,1),(8326,93,0,1357,56),(8327,143,0,1357,166),(8328,97,0,1358,1),(8329,134,0,1358,2),(8330,115,0,1358,1),(8331,99,0,1358,1),(8332,93,0,1358,49),(8333,143,0,1358,167),(8334,97,0,1359,1),(8335,134,0,1359,2),(8336,115,0,1359,1),(8337,99,0,1359,1),(8338,93,0,1359,50),(8339,143,0,1359,167),(8340,97,0,1360,1),(8341,134,0,1360,2),(8342,115,0,1360,1),(8343,99,0,1360,1),(8344,93,0,1360,56),(8345,143,0,1360,167),(8346,97,0,1361,1),(8347,134,0,1361,2),(8348,115,0,1361,1),(8349,99,0,1361,1),(8350,93,0,1361,49),(8351,143,0,1361,168),(8352,97,0,1362,1),(8353,134,0,1362,2),(8354,115,0,1362,1),(8355,99,0,1362,1),(8356,93,0,1362,50),(8357,143,0,1362,168),(8358,97,0,1363,1),(8359,134,0,1363,2),(8360,115,0,1363,1),(8361,99,0,1363,1),(8362,93,0,1363,56),(8363,143,0,1363,168),(8364,97,0,1364,1),(8365,134,0,1364,2),(8366,115,0,1364,1),(8367,99,0,1364,1),(8368,93,0,1364,49),(8369,143,0,1364,169),(8370,97,0,1365,1),(8371,134,0,1365,2),(8372,115,0,1365,1),(8373,99,0,1365,1),(8374,93,0,1365,50),(8375,143,0,1365,169),(8376,97,0,1366,1),(8377,134,0,1366,2),(8378,115,0,1366,1),(8379,99,0,1366,1),(8380,93,0,1366,56),(8381,143,0,1366,169),(8382,97,0,1367,1),(8383,134,0,1367,2),(8384,115,0,1367,1),(8385,99,0,1367,1),(8386,93,0,1367,49),(8387,143,0,1367,170),(8388,97,0,1368,1),(8389,134,0,1368,2),(8390,115,0,1368,1),(8391,99,0,1368,1),(8392,93,0,1368,50),(8393,143,0,1368,170),(8394,97,0,1369,1),(8395,134,0,1369,2),(8396,115,0,1369,1),(8397,99,0,1369,1),(8398,93,0,1369,56),(8399,143,0,1369,170),(8400,97,0,1370,1),(8401,134,0,1370,2),(8402,115,0,1370,1),(8403,99,0,1370,4),(8404,144,0,1370,0),(8405,145,0,1370,0),(8406,146,0,1370,0),(8407,147,0,1370,1),(8408,148,0,1370,0),(8409,97,0,1371,1),(8410,134,0,1371,2),(8411,115,0,1371,1),(8412,99,0,1371,1),(8413,93,0,1371,50),(8414,143,0,1371,166),(8415,97,0,1372,1),(8416,134,0,1372,2),(8417,115,0,1372,1),(8418,99,0,1372,1),(8419,93,0,1372,53),(8420,143,0,1372,166),(8421,97,0,1373,1),(8422,134,0,1373,2),(8423,115,0,1373,1),(8424,99,0,1373,1),(8425,93,0,1373,57),(8426,143,0,1373,166),(8427,97,0,1374,1),(8428,134,0,1374,2),(8429,115,0,1374,1),(8430,99,0,1374,1),(8431,93,0,1374,50),(8432,143,0,1374,167),(8433,97,0,1375,1),(8434,134,0,1375,2),(8435,115,0,1375,1),(8436,99,0,1375,1),(8437,93,0,1375,53),(8438,143,0,1375,167),(8439,97,0,1376,1),(8440,134,0,1376,2),(8441,115,0,1376,1),(8442,99,0,1376,1),(8443,93,0,1376,57),(8444,143,0,1376,167),(8445,97,0,1377,1),(8446,134,0,1377,2),(8447,115,0,1377,1),(8448,99,0,1377,1),(8449,93,0,1377,50),(8450,143,0,1377,168),(8451,97,0,1378,1),(8452,134,0,1378,2),(8453,115,0,1378,1),(8454,99,0,1378,1),(8455,93,0,1378,53),(8456,143,0,1378,168),(8457,97,0,1379,1),(8458,134,0,1379,2),(8459,115,0,1379,1),(8460,99,0,1379,1),(8461,93,0,1379,57),(8462,143,0,1379,168),(8463,97,0,1380,1),(8464,134,0,1380,2),(8465,115,0,1380,1),(8466,99,0,1380,1),(8467,93,0,1380,50),(8468,143,0,1380,169),(8469,97,0,1381,1),(8470,134,0,1381,2),(8471,115,0,1381,1),(8472,99,0,1381,1),(8473,93,0,1381,53),(8474,143,0,1381,169),(8475,97,0,1382,1),(8476,134,0,1382,2),(8477,115,0,1382,1),(8478,99,0,1382,1),(8479,93,0,1382,57),(8480,143,0,1382,169),(8481,97,0,1383,1),(8482,134,0,1383,2),(8483,115,0,1383,1),(8484,99,0,1383,1),(8485,93,0,1383,50),(8486,143,0,1383,170),(8487,97,0,1384,1),(8488,134,0,1384,2),(8489,115,0,1384,1),(8490,99,0,1384,1),(8491,93,0,1384,53),(8492,143,0,1384,170),(8493,97,0,1385,1),(8494,134,0,1385,2),(8495,115,0,1385,1),(8496,99,0,1385,1),(8497,93,0,1385,57),(8498,143,0,1385,170),(8499,97,0,1386,1),(8500,134,0,1386,2),(8501,115,0,1386,1),(8502,99,0,1386,4),(8503,144,0,1386,0),(8504,145,0,1386,1),(8505,146,0,1386,0),(8506,147,0,1386,0),(8507,148,0,1386,1),(8508,97,0,1387,1),(8509,134,0,1387,2),(8510,115,0,1387,1),(8511,99,0,1387,1),(8512,93,0,1387,49),(8513,143,0,1387,166),(8514,97,0,1388,1),(8515,134,0,1388,2),(8516,115,0,1388,1),(8517,99,0,1388,1),(8518,93,0,1388,50),(8519,143,0,1388,166),(8520,97,0,1389,1),(8521,134,0,1389,2),(8522,115,0,1389,1),(8523,99,0,1389,1),(8524,93,0,1389,57),(8525,143,0,1389,166),(8526,97,0,1390,1),(8527,134,0,1390,2),(8528,115,0,1390,1),(8529,99,0,1390,1),(8530,93,0,1390,49),(8531,143,0,1390,167),(8532,97,0,1391,1),(8533,134,0,1391,2),(8534,115,0,1391,1),(8535,99,0,1391,1),(8536,93,0,1391,50),(8537,143,0,1391,167),(8538,97,0,1392,1),(8539,134,0,1392,2),(8540,115,0,1392,1),(8541,99,0,1392,1),(8542,93,0,1392,57),(8543,143,0,1392,167),(8544,97,0,1393,1),(8545,134,0,1393,2),(8546,115,0,1393,1),(8547,99,0,1393,1),(8548,93,0,1393,49),(8549,143,0,1393,168),(8550,97,0,1394,1),(8551,134,0,1394,2),(8552,115,0,1394,1),(8553,99,0,1394,1),(8554,93,0,1394,50),(8555,143,0,1394,168),(8556,97,0,1395,1),(8557,134,0,1395,2),(8558,115,0,1395,1),(8559,99,0,1395,1),(8560,93,0,1395,57),(8561,143,0,1395,168),(8562,97,0,1396,1),(8563,134,0,1396,2),(8564,115,0,1396,1),(8565,99,0,1396,1),(8566,93,0,1396,49),(8567,143,0,1396,169),(8568,97,0,1397,1),(8569,134,0,1397,2),(8570,115,0,1397,1),(8571,99,0,1397,1),(8572,93,0,1397,50),(8573,143,0,1397,169),(8574,97,0,1398,1),(8575,134,0,1398,2),(8576,115,0,1398,1),(8577,99,0,1398,1),(8578,93,0,1398,57),(8579,143,0,1398,169),(8580,97,0,1399,1),(8581,134,0,1399,2),(8582,115,0,1399,1),(8583,99,0,1399,1),(8584,93,0,1399,49),(8585,143,0,1399,170),(8586,97,0,1400,1),(8587,134,0,1400,2),(8588,115,0,1400,1),(8589,99,0,1400,1),(8590,93,0,1400,50),(8591,143,0,1400,170),(8592,97,0,1401,1),(8593,134,0,1401,2),(8594,115,0,1401,1),(8595,99,0,1401,1),(8596,93,0,1401,57),(8597,143,0,1401,170),(8598,97,0,1402,1),(8599,134,0,1402,2),(8600,115,0,1402,1),(8601,99,0,1402,4),(8602,144,0,1402,0),(8603,145,0,1402,1),(8604,146,0,1402,0),(8605,147,0,1402,0),(8606,148,0,1402,1),(8607,97,0,1403,1),(8608,134,0,1403,2),(8609,115,0,1403,1),(8610,99,0,1403,1),(8611,93,0,1403,50),(8612,143,0,1403,166),(8613,97,0,1404,1),(8614,134,0,1404,2),(8615,115,0,1404,1),(8616,99,0,1404,1),(8617,93,0,1404,53),(8618,143,0,1404,166),(8619,97,0,1405,1),(8620,134,0,1405,2),(8621,115,0,1405,1),(8622,99,0,1405,1),(8623,93,0,1405,58),(8624,143,0,1405,166),(8625,97,0,1406,1),(8626,134,0,1406,2),(8627,115,0,1406,1),(8628,99,0,1406,1),(8629,93,0,1406,50),(8630,143,0,1406,167),(8631,97,0,1407,1),(8632,134,0,1407,2),(8633,115,0,1407,1),(8634,99,0,1407,1),(8635,93,0,1407,53),(8636,143,0,1407,167),(8637,97,0,1408,1),(8638,134,0,1408,2),(8639,115,0,1408,1),(8640,99,0,1408,1),(8641,93,0,1408,58),(8642,143,0,1408,167),(8643,97,0,1409,1),(8644,134,0,1409,2),(8645,115,0,1409,1),(8646,99,0,1409,1),(8647,93,0,1409,50),(8648,143,0,1409,168),(8649,97,0,1410,1),(8650,134,0,1410,2),(8651,115,0,1410,1),(8652,99,0,1410,1),(8653,93,0,1410,53),(8654,143,0,1410,168),(8655,97,0,1411,1),(8656,134,0,1411,2),(8657,115,0,1411,1),(8658,99,0,1411,1),(8659,93,0,1411,58),(8660,143,0,1411,168),(8661,97,0,1412,1),(8662,134,0,1412,2),(8663,115,0,1412,1),(8664,99,0,1412,1),(8665,93,0,1412,50),(8666,143,0,1412,169),(8667,97,0,1413,1),(8668,134,0,1413,2),(8669,115,0,1413,1),(8670,99,0,1413,1),(8671,93,0,1413,53),(8672,143,0,1413,169),(8673,97,0,1414,1),(8674,134,0,1414,2),(8675,115,0,1414,1),(8676,99,0,1414,1),(8677,93,0,1414,58),(8678,143,0,1414,169),(8679,97,0,1415,1),(8680,134,0,1415,2),(8681,115,0,1415,1),(8682,99,0,1415,1),(8683,93,0,1415,50),(8684,143,0,1415,170),(8685,97,0,1416,1),(8686,134,0,1416,2),(8687,115,0,1416,1),(8688,99,0,1416,1),(8689,93,0,1416,53),(8690,143,0,1416,170),(8691,97,0,1417,1),(8692,134,0,1417,2),(8693,115,0,1417,1),(8694,99,0,1417,1),(8695,93,0,1417,58),(8696,143,0,1417,170),(8697,97,0,1418,1),(8698,134,0,1418,2),(8699,115,0,1418,1),(8700,99,0,1418,4),(8701,144,0,1418,0),(8702,145,0,1418,0),(8703,146,0,1418,0),(8704,147,0,1418,1),(8705,148,0,1418,0),(8706,97,0,1419,1),(8707,134,0,1419,2),(8708,115,0,1419,1),(8709,99,0,1419,1),(8710,93,0,1419,50),(8711,143,0,1419,166),(8712,97,0,1420,1),(8713,134,0,1420,2),(8714,115,0,1420,1),(8715,99,0,1420,1),(8716,93,0,1420,53),(8717,143,0,1420,166),(8718,97,0,1421,1),(8719,134,0,1421,2),(8720,115,0,1421,1),(8721,99,0,1421,1),(8722,93,0,1421,58),(8723,143,0,1421,166),(8724,97,0,1422,1),(8725,134,0,1422,2),(8726,115,0,1422,1),(8727,99,0,1422,1),(8728,93,0,1422,50),(8729,143,0,1422,167),(8730,97,0,1423,1),(8731,134,0,1423,2),(8732,115,0,1423,1),(8733,99,0,1423,1),(8734,93,0,1423,53),(8735,143,0,1423,167),(8736,97,0,1424,1),(8737,134,0,1424,2),(8738,115,0,1424,1),(8739,99,0,1424,1),(8740,93,0,1424,58),(8741,143,0,1424,167),(8742,97,0,1425,1),(8743,134,0,1425,2),(8744,115,0,1425,1),(8745,99,0,1425,1),(8746,93,0,1425,50),(8747,143,0,1425,168),(8748,97,0,1426,1),(8749,134,0,1426,2),(8750,115,0,1426,1),(8751,99,0,1426,1),(8752,93,0,1426,53),(8753,143,0,1426,168),(8754,97,0,1427,1),(8755,134,0,1427,2),(8756,115,0,1427,1),(8757,99,0,1427,1),(8758,93,0,1427,58),(8759,143,0,1427,168),(8760,97,0,1428,1),(8761,134,0,1428,2),(8762,115,0,1428,1),(8763,99,0,1428,1),(8764,93,0,1428,50),(8765,143,0,1428,169),(8766,97,0,1429,1),(8767,134,0,1429,2),(8768,115,0,1429,1),(8769,99,0,1429,1),(8770,93,0,1429,53),(8771,143,0,1429,169),(8772,97,0,1430,1),(8773,134,0,1430,2),(8774,115,0,1430,1),(8775,99,0,1430,1),(8776,93,0,1430,58),(8777,143,0,1430,169),(8778,97,0,1431,1),(8779,134,0,1431,2),(8780,115,0,1431,1),(8781,99,0,1431,1),(8782,93,0,1431,50),(8783,143,0,1431,170),(8784,97,0,1432,1),(8785,134,0,1432,2),(8786,115,0,1432,1),(8787,99,0,1432,1),(8788,93,0,1432,53),(8789,143,0,1432,170),(8790,97,0,1433,1),(8791,134,0,1433,2),(8792,115,0,1433,1),(8793,99,0,1433,1),(8794,93,0,1433,58),(8795,143,0,1433,170),(8796,97,0,1434,1),(8797,134,0,1434,2),(8798,115,0,1434,1),(8799,99,0,1434,4),(8800,144,0,1434,0),(8801,145,0,1434,1),(8802,146,0,1434,0),(8803,147,0,1434,0),(8804,148,0,1434,0),(8805,97,0,1435,1),(8806,134,0,1435,2),(8807,115,0,1435,1),(8808,99,0,1435,1),(8809,93,0,1435,50),(8810,143,0,1435,166),(8811,97,0,1436,1),(8812,134,0,1436,2),(8813,115,0,1436,1),(8814,99,0,1436,1),(8815,93,0,1436,53),(8816,143,0,1436,166),(8817,97,0,1437,1),(8818,134,0,1437,2),(8819,115,0,1437,1),(8820,99,0,1437,1),(8821,93,0,1437,58),(8822,143,0,1437,166),(8823,97,0,1438,1),(8824,134,0,1438,2),(8825,115,0,1438,1),(8826,99,0,1438,1),(8827,93,0,1438,50),(8828,143,0,1438,167),(8829,97,0,1439,1),(8830,134,0,1439,2),(8831,115,0,1439,1),(8832,99,0,1439,1),(8833,93,0,1439,53),(8834,143,0,1439,167),(8835,97,0,1440,1),(8836,134,0,1440,2),(8837,115,0,1440,1),(8838,99,0,1440,1),(8839,93,0,1440,58),(8840,143,0,1440,167),(8841,97,0,1441,1),(8842,134,0,1441,2),(8843,115,0,1441,1),(8844,99,0,1441,1),(8845,93,0,1441,50),(8846,143,0,1441,168),(8847,97,0,1442,1),(8848,134,0,1442,2),(8849,115,0,1442,1),(8850,99,0,1442,1),(8851,93,0,1442,53),(8852,143,0,1442,168),(8853,97,0,1443,1),(8854,134,0,1443,2),(8855,115,0,1443,1),(8856,99,0,1443,1),(8857,93,0,1443,58),(8858,143,0,1443,168),(8859,97,0,1444,1),(8860,134,0,1444,2),(8861,115,0,1444,1),(8862,99,0,1444,1),(8863,93,0,1444,50),(8864,143,0,1444,169),(8865,97,0,1445,1),(8866,134,0,1445,2),(8867,115,0,1445,1),(8868,99,0,1445,1),(8869,93,0,1445,53),(8870,143,0,1445,169),(8871,97,0,1446,1),(8872,134,0,1446,2),(8873,115,0,1446,1),(8874,99,0,1446,1),(8875,93,0,1446,58),(8876,143,0,1446,169),(8877,97,0,1447,1),(8878,134,0,1447,2),(8879,115,0,1447,1),(8880,99,0,1447,1),(8881,93,0,1447,50),(8882,143,0,1447,170),(8883,97,0,1448,1),(8884,134,0,1448,2),(8885,115,0,1448,1),(8886,99,0,1448,1),(8887,93,0,1448,53),(8888,143,0,1448,170),(8889,97,0,1449,1),(8890,134,0,1449,2),(8891,115,0,1449,1),(8892,99,0,1449,1),(8893,93,0,1449,58),(8894,143,0,1449,170),(8895,97,0,1450,1),(8896,134,0,1450,2),(8897,115,0,1450,1),(8898,99,0,1450,4),(8899,144,0,1450,1),(8900,145,0,1450,0),(8901,146,0,1450,0),(8902,147,0,1450,1),(8903,148,0,1450,0),(8904,97,0,1451,1),(8905,134,0,1451,2),(8906,115,0,1451,1),(8907,99,0,1451,1),(8908,93,0,1451,52),(8909,143,0,1451,166),(8910,97,0,1452,1),(8911,134,0,1452,2),(8912,115,0,1452,1),(8913,99,0,1452,1),(8914,93,0,1452,57),(8915,143,0,1452,166),(8916,97,0,1453,1),(8917,134,0,1453,2),(8918,115,0,1453,1),(8919,99,0,1453,1),(8920,93,0,1453,58),(8921,143,0,1453,166),(8922,97,0,1454,1),(8923,134,0,1454,2),(8924,115,0,1454,1),(8925,99,0,1454,1),(8926,93,0,1454,52),(8927,143,0,1454,167),(8928,97,0,1455,1),(8929,134,0,1455,2),(8930,115,0,1455,1),(8931,99,0,1455,1),(8932,93,0,1455,57),(8933,143,0,1455,167),(8934,97,0,1456,1),(8935,134,0,1456,2),(8936,115,0,1456,1),(8937,99,0,1456,1),(8938,93,0,1456,58),(8939,143,0,1456,167),(8940,97,0,1457,1),(8941,134,0,1457,2),(8942,115,0,1457,1),(8943,99,0,1457,1),(8944,93,0,1457,52),(8945,143,0,1457,168),(8946,97,0,1458,1),(8947,134,0,1458,2),(8948,115,0,1458,1),(8949,99,0,1458,1),(8950,93,0,1458,57),(8951,143,0,1458,168),(8952,97,0,1459,1),(8953,134,0,1459,2),(8954,115,0,1459,1),(8955,99,0,1459,1),(8956,93,0,1459,58),(8957,143,0,1459,168),(8958,97,0,1460,1),(8959,134,0,1460,2),(8960,115,0,1460,1),(8961,99,0,1460,1),(8962,93,0,1460,52),(8963,143,0,1460,169),(8964,97,0,1461,1),(8965,134,0,1461,2),(8966,115,0,1461,1),(8967,99,0,1461,1),(8968,93,0,1461,57),(8969,143,0,1461,169),(8970,97,0,1462,1),(8971,134,0,1462,2),(8972,115,0,1462,1),(8973,99,0,1462,1),(8974,93,0,1462,58),(8975,143,0,1462,169),(8976,97,0,1463,1),(8977,134,0,1463,2),(8978,115,0,1463,1),(8979,99,0,1463,1),(8980,93,0,1463,52),(8981,143,0,1463,170),(8982,97,0,1464,1),(8983,134,0,1464,2),(8984,115,0,1464,1),(8985,99,0,1464,1),(8986,93,0,1464,57),(8987,143,0,1464,170),(8988,97,0,1465,1),(8989,134,0,1465,2),(8990,115,0,1465,1),(8991,99,0,1465,1),(8992,93,0,1465,58),(8993,143,0,1465,170),(8994,97,0,1466,1),(8995,134,0,1466,2),(8996,115,0,1466,1),(8997,99,0,1466,4),(8998,144,0,1466,1),(8999,145,0,1466,0),(9000,146,0,1466,0),(9001,147,0,1466,1),(9002,148,0,1466,0),(9003,97,0,1467,1),(9004,134,0,1467,2),(9005,115,0,1467,1),(9006,99,0,1467,1),(9007,93,0,1467,49),(9008,143,0,1467,166),(9009,97,0,1468,1),(9010,134,0,1468,2),(9011,115,0,1468,1),(9012,99,0,1468,1),(9013,93,0,1468,59),(9014,143,0,1468,166),(9015,97,0,1469,1),(9016,134,0,1469,2),(9017,115,0,1469,1),(9018,99,0,1469,1),(9019,93,0,1469,60),(9020,143,0,1469,166),(9021,97,0,1470,1),(9022,134,0,1470,2),(9023,115,0,1470,1),(9024,99,0,1470,1),(9025,93,0,1470,49),(9026,143,0,1470,167),(9027,97,0,1471,1),(9028,134,0,1471,2),(9029,115,0,1471,1),(9030,99,0,1471,1),(9031,93,0,1471,59),(9032,143,0,1471,167),(9033,97,0,1472,1),(9034,134,0,1472,2),(9035,115,0,1472,1),(9036,99,0,1472,1),(9037,93,0,1472,60),(9038,143,0,1472,167),(9039,97,0,1473,1),(9040,134,0,1473,2),(9041,115,0,1473,1),(9042,99,0,1473,1),(9043,93,0,1473,49),(9044,143,0,1473,168),(9045,97,0,1474,1),(9046,134,0,1474,2),(9047,115,0,1474,1),(9048,99,0,1474,1),(9049,93,0,1474,59),(9050,143,0,1474,168),(9051,97,0,1475,1),(9052,134,0,1475,2),(9053,115,0,1475,1),(9054,99,0,1475,1),(9055,93,0,1475,60),(9056,143,0,1475,168),(9057,97,0,1476,1),(9058,134,0,1476,2),(9059,115,0,1476,1),(9060,99,0,1476,1),(9061,93,0,1476,49),(9062,143,0,1476,169),(9063,97,0,1477,1),(9064,134,0,1477,2),(9065,115,0,1477,1),(9066,99,0,1477,1),(9067,93,0,1477,59),(9068,143,0,1477,169),(9069,97,0,1478,1),(9070,134,0,1478,2),(9071,115,0,1478,1),(9072,99,0,1478,1),(9073,93,0,1478,60),(9074,143,0,1478,169),(9075,97,0,1479,1),(9076,134,0,1479,2),(9077,115,0,1479,1),(9078,99,0,1479,1),(9079,93,0,1479,49),(9080,143,0,1479,170),(9081,97,0,1480,1),(9082,134,0,1480,2),(9083,115,0,1480,1),(9084,99,0,1480,1),(9085,93,0,1480,59),(9086,143,0,1480,170),(9087,97,0,1481,1),(9088,134,0,1481,2),(9089,115,0,1481,1),(9090,99,0,1481,1),(9091,93,0,1481,60),(9092,143,0,1481,170),(9093,97,0,1482,1),(9094,134,0,1482,2),(9095,115,0,1482,1),(9096,99,0,1482,4),(9097,144,0,1482,0),(9098,145,0,1482,1),(9099,146,0,1482,1),(9100,147,0,1482,1),(9101,148,0,1482,0),(9102,97,0,1483,1),(9103,134,0,1483,2),(9104,115,0,1483,1),(9105,99,0,1483,1),(9106,93,0,1483,49),(9107,143,0,1483,166),(9108,97,0,1484,1),(9109,134,0,1484,2),(9110,115,0,1484,1),(9111,99,0,1484,1),(9112,93,0,1484,50),(9113,143,0,1484,166),(9114,97,0,1485,1),(9115,134,0,1485,2),(9116,115,0,1485,1),(9117,99,0,1485,1),(9118,93,0,1485,58),(9119,143,0,1485,166),(9120,97,0,1486,1),(9121,134,0,1486,2),(9122,115,0,1486,1),(9123,99,0,1486,1),(9124,93,0,1486,49),(9125,143,0,1486,167),(9126,97,0,1487,1),(9127,134,0,1487,2),(9128,115,0,1487,1),(9129,99,0,1487,1),(9130,93,0,1487,50),(9131,143,0,1487,167),(9132,97,0,1488,1),(9133,134,0,1488,2),(9134,115,0,1488,1),(9135,99,0,1488,1),(9136,93,0,1488,58),(9137,143,0,1488,167),(9138,97,0,1489,1),(9139,134,0,1489,2),(9140,115,0,1489,1),(9141,99,0,1489,1),(9142,93,0,1489,49),(9143,143,0,1489,168),(9144,97,0,1490,1),(9145,134,0,1490,2),(9146,115,0,1490,1),(9147,99,0,1490,1),(9148,93,0,1490,50),(9149,143,0,1490,168),(9150,97,0,1491,1),(9151,134,0,1491,2),(9152,115,0,1491,1),(9153,99,0,1491,1),(9154,93,0,1491,58),(9155,143,0,1491,168),(9156,97,0,1492,1),(9157,134,0,1492,2),(9158,115,0,1492,1),(9159,99,0,1492,1),(9160,93,0,1492,49),(9161,143,0,1492,169),(9162,97,0,1493,1),(9163,134,0,1493,2),(9164,115,0,1493,1),(9165,99,0,1493,1),(9166,93,0,1493,50),(9167,143,0,1493,169),(9168,97,0,1494,1),(9169,134,0,1494,2),(9170,115,0,1494,1),(9171,99,0,1494,1),(9172,93,0,1494,58),(9173,143,0,1494,169),(9174,97,0,1495,1),(9175,134,0,1495,2),(9176,115,0,1495,1),(9177,99,0,1495,1),(9178,93,0,1495,49),(9179,143,0,1495,170),(9180,97,0,1496,1),(9181,134,0,1496,2),(9182,115,0,1496,1),(9183,99,0,1496,1),(9184,93,0,1496,50),(9185,143,0,1496,170),(9186,97,0,1497,1),(9187,134,0,1497,2),(9188,115,0,1497,1),(9189,99,0,1497,1),(9190,93,0,1497,58),(9191,143,0,1497,170),(9192,97,0,1498,1),(9193,134,0,1498,2),(9194,115,0,1498,1),(9195,99,0,1498,4),(9196,144,0,1498,0),(9197,145,0,1498,0),(9198,146,0,1498,0),(9199,147,0,1498,0),(9200,148,0,1498,1),(9201,97,0,1499,1),(9202,134,0,1499,2),(9203,115,0,1499,1),(9204,99,0,1499,1),(9205,93,0,1499,50),(9206,143,0,1499,166),(9207,97,0,1500,1),(9208,134,0,1500,2),(9209,115,0,1500,1),(9210,99,0,1500,1),(9211,93,0,1500,58),(9212,143,0,1500,166),(9213,97,0,1501,1),(9214,134,0,1501,2),(9215,115,0,1501,1),(9216,99,0,1501,1),(9217,93,0,1501,59),(9218,143,0,1501,166),(9219,97,0,1502,1),(9220,134,0,1502,2),(9221,115,0,1502,1),(9222,99,0,1502,1),(9223,93,0,1502,50),(9224,143,0,1502,167),(9225,97,0,1503,1),(9226,134,0,1503,2),(9227,115,0,1503,1),(9228,99,0,1503,1),(9229,93,0,1503,58),(9230,143,0,1503,167),(9231,97,0,1504,1),(9232,134,0,1504,2),(9233,115,0,1504,1),(9234,99,0,1504,1),(9235,93,0,1504,59),(9236,143,0,1504,167),(9237,97,0,1505,1),(9238,134,0,1505,2),(9239,115,0,1505,1),(9240,99,0,1505,1),(9241,93,0,1505,50),(9242,143,0,1505,168),(9243,97,0,1506,1),(9244,134,0,1506,2),(9245,115,0,1506,1),(9246,99,0,1506,1),(9247,93,0,1506,58),(9248,143,0,1506,168),(9249,97,0,1507,1),(9250,134,0,1507,2),(9251,115,0,1507,1),(9252,99,0,1507,1),(9253,93,0,1507,59),(9254,143,0,1507,168),(9255,97,0,1508,1),(9256,134,0,1508,2),(9257,115,0,1508,1),(9258,99,0,1508,1),(9259,93,0,1508,50),(9260,143,0,1508,169),(9261,97,0,1509,1),(9262,134,0,1509,2),(9263,115,0,1509,1),(9264,99,0,1509,1),(9265,93,0,1509,58),(9266,143,0,1509,169),(9267,97,0,1510,1),(9268,134,0,1510,2),(9269,115,0,1510,1),(9270,99,0,1510,1),(9271,93,0,1510,59),(9272,143,0,1510,169),(9273,97,0,1511,1),(9274,134,0,1511,2),(9275,115,0,1511,1),(9276,99,0,1511,1),(9277,93,0,1511,50),(9278,143,0,1511,170),(9279,97,0,1512,1),(9280,134,0,1512,2),(9281,115,0,1512,1),(9282,99,0,1512,1),(9283,93,0,1512,58),(9284,143,0,1512,170),(9285,97,0,1513,1),(9286,134,0,1513,2),(9287,115,0,1513,1),(9288,99,0,1513,1),(9289,93,0,1513,59),(9290,143,0,1513,170),(9291,97,0,1514,1),(9292,134,0,1514,2),(9293,115,0,1514,1),(9294,99,0,1514,4),(9295,144,0,1514,1),(9296,145,0,1514,0),(9297,146,0,1514,0),(9298,147,0,1514,0),(9299,148,0,1514,1),(9300,97,0,1515,1),(9301,134,0,1515,2),(9302,115,0,1515,1),(9303,99,0,1515,1),(9304,93,0,1515,53),(9305,143,0,1515,166),(9306,97,0,1516,1),(9307,134,0,1516,2),(9308,115,0,1516,1),(9309,99,0,1516,1),(9310,93,0,1516,58),(9311,143,0,1516,166),(9312,97,0,1517,1),(9313,134,0,1517,2),(9314,115,0,1517,1),(9315,99,0,1517,1),(9316,93,0,1517,60),(9317,143,0,1517,166),(9318,97,0,1518,1),(9319,134,0,1518,2),(9320,115,0,1518,1),(9321,99,0,1518,1),(9322,93,0,1518,53),(9323,143,0,1518,167),(9324,97,0,1519,1),(9325,134,0,1519,2),(9326,115,0,1519,1),(9327,99,0,1519,1),(9328,93,0,1519,58),(9329,143,0,1519,167),(9330,97,0,1520,1),(9331,134,0,1520,2),(9332,115,0,1520,1),(9333,99,0,1520,1),(9334,93,0,1520,60),(9335,143,0,1520,167),(9336,97,0,1521,1),(9337,134,0,1521,2),(9338,115,0,1521,1),(9339,99,0,1521,1),(9340,93,0,1521,53),(9341,143,0,1521,168),(9342,97,0,1522,1),(9343,134,0,1522,2),(9344,115,0,1522,1),(9345,99,0,1522,1),(9346,93,0,1522,58),(9347,143,0,1522,168),(9348,97,0,1523,1),(9349,134,0,1523,2),(9350,115,0,1523,1),(9351,99,0,1523,1),(9352,93,0,1523,60),(9353,143,0,1523,168),(9354,97,0,1524,1),(9355,134,0,1524,2),(9356,115,0,1524,1),(9357,99,0,1524,1),(9358,93,0,1524,53),(9359,143,0,1524,169),(9360,97,0,1525,1),(9361,134,0,1525,2),(9362,115,0,1525,1),(9363,99,0,1525,1),(9364,93,0,1525,58),(9365,143,0,1525,169),(9366,97,0,1526,1),(9367,134,0,1526,2),(9368,115,0,1526,1),(9369,99,0,1526,1),(9370,93,0,1526,60),(9371,143,0,1526,169),(9372,97,0,1527,1),(9373,134,0,1527,2),(9374,115,0,1527,1),(9375,99,0,1527,1),(9376,93,0,1527,53),(9377,143,0,1527,170),(9378,97,0,1528,1),(9379,134,0,1528,2),(9380,115,0,1528,1),(9381,99,0,1528,1),(9382,93,0,1528,58),(9383,143,0,1528,170),(9384,97,0,1529,1),(9385,134,0,1529,2),(9386,115,0,1529,1),(9387,99,0,1529,1),(9388,93,0,1529,60),(9389,143,0,1529,170),(9390,97,0,1530,1),(9391,134,0,1530,2),(9392,115,0,1530,1),(9393,99,0,1530,4),(9394,144,0,1530,0),(9395,145,0,1530,1),(9396,146,0,1530,0),(9397,147,0,1530,0),(9398,148,0,1530,0),(9399,97,0,1531,1),(9400,134,0,1531,2),(9401,115,0,1531,1),(9402,99,0,1531,1),(9403,93,0,1531,53),(9404,143,0,1531,166),(9405,97,0,1532,1),(9406,134,0,1532,2),(9407,115,0,1532,1),(9408,99,0,1532,1),(9409,93,0,1532,56),(9410,143,0,1532,166),(9411,97,0,1533,1),(9412,134,0,1533,2),(9413,115,0,1533,1),(9414,99,0,1533,1),(9415,93,0,1533,60),(9416,143,0,1533,166),(9417,97,0,1534,1),(9418,134,0,1534,2),(9419,115,0,1534,1),(9420,99,0,1534,1),(9421,93,0,1534,53),(9422,143,0,1534,167),(9423,97,0,1535,1),(9424,134,0,1535,2),(9425,115,0,1535,1),(9426,99,0,1535,1),(9427,93,0,1535,56),(9428,143,0,1535,167),(9429,97,0,1536,1),(9430,134,0,1536,2),(9431,115,0,1536,1),(9432,99,0,1536,1),(9433,93,0,1536,60),(9434,143,0,1536,167),(9435,97,0,1537,1),(9436,134,0,1537,2),(9437,115,0,1537,1),(9438,99,0,1537,1),(9439,93,0,1537,53),(9440,143,0,1537,168),(9441,97,0,1538,1),(9442,134,0,1538,2),(9443,115,0,1538,1),(9444,99,0,1538,1),(9445,93,0,1538,56),(9446,143,0,1538,168),(9447,97,0,1539,1),(9448,134,0,1539,2),(9449,115,0,1539,1),(9450,99,0,1539,1),(9451,93,0,1539,60),(9452,143,0,1539,168),(9453,97,0,1540,1),(9454,134,0,1540,2),(9455,115,0,1540,1),(9456,99,0,1540,1),(9457,93,0,1540,53),(9458,143,0,1540,169),(9459,97,0,1541,1),(9460,134,0,1541,2),(9461,115,0,1541,1),(9462,99,0,1541,1),(9463,93,0,1541,56),(9464,143,0,1541,169),(9465,97,0,1542,1),(9466,134,0,1542,2),(9467,115,0,1542,1),(9468,99,0,1542,1),(9469,93,0,1542,60),(9470,143,0,1542,169),(9471,97,0,1543,1),(9472,134,0,1543,2),(9473,115,0,1543,1),(9474,99,0,1543,1),(9475,93,0,1543,53),(9476,143,0,1543,170),(9477,97,0,1544,1),(9478,134,0,1544,2),(9479,115,0,1544,1),(9480,99,0,1544,1),(9481,93,0,1544,56),(9482,143,0,1544,170),(9483,97,0,1545,1),(9484,134,0,1545,2),(9485,115,0,1545,1),(9486,99,0,1545,1),(9487,93,0,1545,60),(9488,143,0,1545,170),(9489,97,0,1546,1),(9490,134,0,1546,2),(9491,115,0,1546,1),(9492,99,0,1546,4),(9493,144,0,1546,0),(9494,145,0,1546,0),(9495,146,0,1546,1),(9496,147,0,1546,0),(9497,148,0,1546,1),(9498,97,0,1547,1),(9499,134,0,1547,2),(9500,115,0,1547,1),(9501,99,0,1547,1),(9502,93,0,1547,50),(9503,143,0,1547,166),(9504,97,0,1548,1),(9505,134,0,1548,2),(9506,115,0,1548,1),(9507,99,0,1548,1),(9508,93,0,1548,56),(9509,143,0,1548,166),(9510,97,0,1549,1),(9511,134,0,1549,2),(9512,115,0,1549,1),(9513,99,0,1549,1),(9514,93,0,1549,57),(9515,143,0,1549,166),(9516,97,0,1550,1),(9517,134,0,1550,2),(9518,115,0,1550,1),(9519,99,0,1550,1),(9520,93,0,1550,50),(9521,143,0,1550,167),(9522,97,0,1551,1),(9523,134,0,1551,2),(9524,115,0,1551,1),(9525,99,0,1551,1),(9526,93,0,1551,56),(9527,143,0,1551,167),(9528,97,0,1552,1),(9529,134,0,1552,2),(9530,115,0,1552,1),(9531,99,0,1552,1),(9532,93,0,1552,57),(9533,143,0,1552,167),(9534,97,0,1553,1),(9535,134,0,1553,2),(9536,115,0,1553,1),(9537,99,0,1553,1),(9538,93,0,1553,50),(9539,143,0,1553,168),(9540,97,0,1554,1),(9541,134,0,1554,2),(9542,115,0,1554,1),(9543,99,0,1554,1),(9544,93,0,1554,56),(9545,143,0,1554,168),(9546,97,0,1555,1),(9547,134,0,1555,2),(9548,115,0,1555,1),(9549,99,0,1555,1),(9550,93,0,1555,57),(9551,143,0,1555,168),(9552,97,0,1556,1),(9553,134,0,1556,2),(9554,115,0,1556,1),(9555,99,0,1556,1),(9556,93,0,1556,50),(9557,143,0,1556,169),(9558,97,0,1557,1),(9559,134,0,1557,2),(9560,115,0,1557,1),(9561,99,0,1557,1),(9562,93,0,1557,56),(9563,143,0,1557,169),(9564,97,0,1558,1),(9565,134,0,1558,2),(9566,115,0,1558,1),(9567,99,0,1558,1),(9568,93,0,1558,57),(9569,143,0,1558,169),(9570,97,0,1559,1),(9571,134,0,1559,2),(9572,115,0,1559,1),(9573,99,0,1559,1),(9574,93,0,1559,50),(9575,143,0,1559,170),(9576,97,0,1560,1),(9577,134,0,1560,2),(9578,115,0,1560,1),(9579,99,0,1560,1),(9580,93,0,1560,56),(9581,143,0,1560,170),(9582,97,0,1561,1),(9583,134,0,1561,2),(9584,115,0,1561,1),(9585,99,0,1561,1),(9586,93,0,1561,57),(9587,143,0,1561,170),(9588,97,0,1562,1),(9589,134,0,1562,2),(9590,115,0,1562,1),(9591,99,0,1562,4),(9592,144,0,1562,1),(9593,145,0,1562,1),(9594,146,0,1562,0),(9595,147,0,1562,0),(9596,148,0,1562,0),(9597,97,0,1563,1),(9598,134,0,1563,2),(9599,115,0,1563,1),(9600,99,0,1563,1),(9601,93,0,1563,49),(9602,143,0,1563,166),(9603,97,0,1564,1),(9604,134,0,1564,2),(9605,115,0,1564,1),(9606,99,0,1564,1),(9607,93,0,1564,53),(9608,143,0,1564,166),(9609,97,0,1565,1),(9610,134,0,1565,2),(9611,115,0,1565,1),(9612,99,0,1565,1),(9613,93,0,1565,60),(9614,143,0,1565,166),(9615,97,0,1566,1),(9616,134,0,1566,2),(9617,115,0,1566,1),(9618,99,0,1566,1),(9619,93,0,1566,49),(9620,143,0,1566,167),(9621,97,0,1567,1),(9622,134,0,1567,2),(9623,115,0,1567,1),(9624,99,0,1567,1),(9625,93,0,1567,53),(9626,143,0,1567,167),(9627,97,0,1568,1),(9628,134,0,1568,2),(9629,115,0,1568,1),(9630,99,0,1568,1),(9631,93,0,1568,60),(9632,143,0,1568,167),(9633,97,0,1569,1),(9634,134,0,1569,2),(9635,115,0,1569,1),(9636,99,0,1569,1),(9637,93,0,1569,49),(9638,143,0,1569,168),(9639,97,0,1570,1),(9640,134,0,1570,2),(9641,115,0,1570,1),(9642,99,0,1570,1),(9643,93,0,1570,53),(9644,143,0,1570,168),(9645,97,0,1571,1),(9646,134,0,1571,2),(9647,115,0,1571,1),(9648,99,0,1571,1),(9649,93,0,1571,60),(9650,143,0,1571,168),(9651,97,0,1572,1),(9652,134,0,1572,2),(9653,115,0,1572,1),(9654,99,0,1572,1),(9655,93,0,1572,49),(9656,143,0,1572,169),(9657,97,0,1573,1),(9658,134,0,1573,2),(9659,115,0,1573,1),(9660,99,0,1573,1),(9661,93,0,1573,53),(9662,143,0,1573,169),(9663,97,0,1574,1),(9664,134,0,1574,2),(9665,115,0,1574,1),(9666,99,0,1574,1),(9667,93,0,1574,60),(9668,143,0,1574,169),(9669,97,0,1575,1),(9670,134,0,1575,2),(9671,115,0,1575,1),(9672,99,0,1575,1),(9673,93,0,1575,49),(9674,143,0,1575,170),(9675,97,0,1576,1),(9676,134,0,1576,2),(9677,115,0,1576,1),(9678,99,0,1576,1),(9679,93,0,1576,53),(9680,143,0,1576,170),(9681,97,0,1577,1),(9682,134,0,1577,2),(9683,115,0,1577,1),(9684,99,0,1577,1),(9685,93,0,1577,60),(9686,143,0,1577,170),(9687,97,0,1578,1),(9688,134,0,1578,2),(9689,115,0,1578,1),(9690,99,0,1578,4),(9691,144,0,1578,0),(9692,145,0,1578,0),(9693,146,0,1578,0),(9694,147,0,1578,0),(9695,148,0,1578,0),(9696,97,0,1579,1),(9697,134,0,1579,2),(9698,115,0,1579,1),(9699,99,0,1579,1),(9700,93,0,1579,49),(9701,143,0,1579,166),(9702,97,0,1580,1),(9703,134,0,1580,2),(9704,115,0,1580,1),(9705,99,0,1580,1),(9706,93,0,1580,56),(9707,143,0,1580,166),(9708,97,0,1581,1),(9709,134,0,1581,2),(9710,115,0,1581,1),(9711,99,0,1581,1),(9712,93,0,1581,60),(9713,143,0,1581,166),(9714,97,0,1582,1),(9715,134,0,1582,2),(9716,115,0,1582,1),(9717,99,0,1582,1),(9718,93,0,1582,49),(9719,143,0,1582,167),(9720,97,0,1583,1),(9721,134,0,1583,2),(9722,115,0,1583,1),(9723,99,0,1583,1),(9724,93,0,1583,56),(9725,143,0,1583,167),(9726,97,0,1584,1),(9727,134,0,1584,2),(9728,115,0,1584,1),(9729,99,0,1584,1),(9730,93,0,1584,60),(9731,143,0,1584,167),(9732,97,0,1585,1),(9733,134,0,1585,2),(9734,115,0,1585,1),(9735,99,0,1585,1),(9736,93,0,1585,49),(9737,143,0,1585,168),(9738,97,0,1586,1),(9739,134,0,1586,2),(9740,115,0,1586,1),(9741,99,0,1586,1),(9742,93,0,1586,56),(9743,143,0,1586,168),(9744,97,0,1587,1),(9745,134,0,1587,2),(9746,115,0,1587,1),(9747,99,0,1587,1),(9748,93,0,1587,60),(9749,143,0,1587,168),(9750,97,0,1588,1),(9751,134,0,1588,2),(9752,115,0,1588,1),(9753,99,0,1588,1),(9754,93,0,1588,49),(9755,143,0,1588,169),(9756,97,0,1589,1),(9757,134,0,1589,2),(9758,115,0,1589,1),(9759,99,0,1589,1),(9760,93,0,1589,56),(9761,143,0,1589,169),(9762,97,0,1590,1),(9763,134,0,1590,2),(9764,115,0,1590,1),(9765,99,0,1590,1),(9766,93,0,1590,60),(9767,143,0,1590,169),(9768,97,0,1591,1),(9769,134,0,1591,2),(9770,115,0,1591,1),(9771,99,0,1591,1),(9772,93,0,1591,49),(9773,143,0,1591,170),(9774,97,0,1592,1),(9775,134,0,1592,2),(9776,115,0,1592,1),(9777,99,0,1592,1),(9778,93,0,1592,56),(9779,143,0,1592,170),(9780,97,0,1593,1),(9781,134,0,1593,2),(9782,115,0,1593,1),(9783,99,0,1593,1),(9784,93,0,1593,60),(9785,143,0,1593,170),(9786,97,0,1594,1),(9787,134,0,1594,2),(9788,115,0,1594,1),(9789,99,0,1594,4),(9790,144,0,1594,0),(9791,145,0,1594,0),(9792,146,0,1594,0),(9793,147,0,1594,0),(9794,148,0,1594,0),(9795,97,0,1595,1),(9796,134,0,1595,2),(9797,115,0,1595,1),(9798,99,0,1595,1),(9799,93,0,1595,49),(9800,143,0,1595,166),(9801,97,0,1596,1),(9802,134,0,1596,2),(9803,115,0,1596,1),(9804,99,0,1596,1),(9805,93,0,1596,52),(9806,143,0,1596,166),(9807,97,0,1597,1),(9808,134,0,1597,2),(9809,115,0,1597,1),(9810,99,0,1597,1),(9811,93,0,1597,57),(9812,143,0,1597,166),(9813,97,0,1598,1),(9814,134,0,1598,2),(9815,115,0,1598,1),(9816,99,0,1598,1),(9817,93,0,1598,49),(9818,143,0,1598,167),(9819,97,0,1599,1),(9820,134,0,1599,2),(9821,115,0,1599,1),(9822,99,0,1599,1),(9823,93,0,1599,52),(9824,143,0,1599,167),(9825,97,0,1600,1),(9826,134,0,1600,2),(9827,115,0,1600,1),(9828,99,0,1600,1),(9829,93,0,1600,57),(9830,143,0,1600,167),(9831,97,0,1601,1),(9832,134,0,1601,2),(9833,115,0,1601,1),(9834,99,0,1601,1),(9835,93,0,1601,49),(9836,143,0,1601,168),(9837,97,0,1602,1),(9838,134,0,1602,2),(9839,115,0,1602,1),(9840,99,0,1602,1),(9841,93,0,1602,52),(9842,143,0,1602,168),(9843,97,0,1603,1),(9844,134,0,1603,2),(9845,115,0,1603,1),(9846,99,0,1603,1),(9847,93,0,1603,57),(9848,143,0,1603,168),(9849,97,0,1604,1),(9850,134,0,1604,2),(9851,115,0,1604,1),(9852,99,0,1604,1),(9853,93,0,1604,49),(9854,143,0,1604,169),(9855,97,0,1605,1),(9856,134,0,1605,2),(9857,115,0,1605,1),(9858,99,0,1605,1),(9859,93,0,1605,52),(9860,143,0,1605,169),(9861,97,0,1606,1),(9862,134,0,1606,2),(9863,115,0,1606,1),(9864,99,0,1606,1),(9865,93,0,1606,57),(9866,143,0,1606,169),(9867,97,0,1607,1),(9868,134,0,1607,2),(9869,115,0,1607,1),(9870,99,0,1607,1),(9871,93,0,1607,49),(9872,143,0,1607,170),(9873,97,0,1608,1),(9874,134,0,1608,2),(9875,115,0,1608,1),(9876,99,0,1608,1),(9877,93,0,1608,52),(9878,143,0,1608,170),(9879,97,0,1609,1),(9880,134,0,1609,2),(9881,115,0,1609,1),(9882,99,0,1609,1),(9883,93,0,1609,57),(9884,143,0,1609,170),(9885,97,0,1610,1),(9886,134,0,1610,2),(9887,115,0,1610,1),(9888,99,0,1610,4),(9889,144,0,1610,1),(9890,145,0,1610,0),(9891,146,0,1610,0),(9892,147,0,1610,0),(9893,148,0,1610,1),(9894,97,0,1611,1),(9895,134,0,1611,2),(9896,115,0,1611,1),(9897,99,0,1611,1),(9898,93,0,1611,50),(9899,143,0,1611,166),(9900,97,0,1612,1),(9901,134,0,1612,2),(9902,115,0,1612,1),(9903,99,0,1612,1),(9904,93,0,1612,56),(9905,143,0,1612,166),(9906,97,0,1613,1),(9907,134,0,1613,2),(9908,115,0,1613,1),(9909,99,0,1613,1),(9910,93,0,1613,60),(9911,143,0,1613,166),(9912,97,0,1614,1),(9913,134,0,1614,2),(9914,115,0,1614,1),(9915,99,0,1614,1),(9916,93,0,1614,50),(9917,143,0,1614,167),(9918,97,0,1615,1),(9919,134,0,1615,2),(9920,115,0,1615,1),(9921,99,0,1615,1),(9922,93,0,1615,56),(9923,143,0,1615,167),(9924,97,0,1616,1),(9925,134,0,1616,2),(9926,115,0,1616,1),(9927,99,0,1616,1),(9928,93,0,1616,60),(9929,143,0,1616,167),(9930,97,0,1617,1),(9931,134,0,1617,2),(9932,115,0,1617,1),(9933,99,0,1617,1),(9934,93,0,1617,50),(9935,143,0,1617,168),(9936,97,0,1618,1),(9937,134,0,1618,2),(9938,115,0,1618,1),(9939,99,0,1618,1),(9940,93,0,1618,56),(9941,143,0,1618,168),(9942,97,0,1619,1),(9943,134,0,1619,2),(9944,115,0,1619,1),(9945,99,0,1619,1),(9946,93,0,1619,60),(9947,143,0,1619,168),(9948,97,0,1620,1),(9949,134,0,1620,2),(9950,115,0,1620,1),(9951,99,0,1620,1),(9952,93,0,1620,50),(9953,143,0,1620,169),(9954,97,0,1621,1),(9955,134,0,1621,2),(9956,115,0,1621,1),(9957,99,0,1621,1),(9958,93,0,1621,56),(9959,143,0,1621,169),(9960,97,0,1622,1),(9961,134,0,1622,2),(9962,115,0,1622,1),(9963,99,0,1622,1),(9964,93,0,1622,60),(9965,143,0,1622,169),(9966,97,0,1623,1),(9967,134,0,1623,2),(9968,115,0,1623,1),(9969,99,0,1623,1),(9970,93,0,1623,50),(9971,143,0,1623,170),(9972,97,0,1624,1),(9973,134,0,1624,2),(9974,115,0,1624,1),(9975,99,0,1624,1),(9976,93,0,1624,56),(9977,143,0,1624,170),(9978,97,0,1625,1),(9979,134,0,1625,2),(9980,115,0,1625,1),(9981,99,0,1625,1),(9982,93,0,1625,60),(9983,143,0,1625,170),(9984,97,0,1626,1),(9985,134,0,1626,2),(9986,115,0,1626,1),(9987,99,0,1626,4),(9988,144,0,1626,0),(9989,145,0,1626,0),(9990,146,0,1626,0),(9991,147,0,1626,0),(9992,148,0,1626,0),(9993,97,0,1627,1),(9994,134,0,1627,2),(9995,115,0,1627,1),(9996,99,0,1627,1),(9997,93,0,1627,53),(9998,143,0,1627,166),(9999,97,0,1628,1),(10000,134,0,1628,2),(10001,115,0,1628,1),(10002,99,0,1628,1),(10003,93,0,1628,58),(10004,143,0,1628,166),(10005,97,0,1629,1),(10006,134,0,1629,2),(10007,115,0,1629,1),(10008,99,0,1629,1),(10009,93,0,1629,60),(10010,143,0,1629,166),(10011,97,0,1630,1),(10012,134,0,1630,2),(10013,115,0,1630,1),(10014,99,0,1630,1),(10015,93,0,1630,53),(10016,143,0,1630,167),(10017,97,0,1631,1),(10018,134,0,1631,2),(10019,115,0,1631,1),(10020,99,0,1631,1),(10021,93,0,1631,58),(10022,143,0,1631,167),(10023,97,0,1632,1),(10024,134,0,1632,2),(10025,115,0,1632,1),(10026,99,0,1632,1),(10027,93,0,1632,60),(10028,143,0,1632,167),(10029,97,0,1633,1),(10030,134,0,1633,2),(10031,115,0,1633,1),(10032,99,0,1633,1),(10033,93,0,1633,53),(10034,143,0,1633,168),(10035,97,0,1634,1),(10036,134,0,1634,2),(10037,115,0,1634,1),(10038,99,0,1634,1),(10039,93,0,1634,58),(10040,143,0,1634,168),(10041,97,0,1635,1),(10042,134,0,1635,2),(10043,115,0,1635,1),(10044,99,0,1635,1),(10045,93,0,1635,60),(10046,143,0,1635,168),(10047,97,0,1636,1),(10048,134,0,1636,2),(10049,115,0,1636,1),(10050,99,0,1636,1),(10051,93,0,1636,53),(10052,143,0,1636,169),(10053,97,0,1637,1),(10054,134,0,1637,2),(10055,115,0,1637,1),(10056,99,0,1637,1),(10057,93,0,1637,58),(10058,143,0,1637,169),(10059,97,0,1638,1),(10060,134,0,1638,2),(10061,115,0,1638,1),(10062,99,0,1638,1),(10063,93,0,1638,60),(10064,143,0,1638,169),(10065,97,0,1639,1),(10066,134,0,1639,2),(10067,115,0,1639,1),(10068,99,0,1639,1),(10069,93,0,1639,53),(10070,143,0,1639,170),(10071,97,0,1640,1),(10072,134,0,1640,2),(10073,115,0,1640,1),(10074,99,0,1640,1),(10075,93,0,1640,58),(10076,143,0,1640,170),(10077,97,0,1641,1),(10078,134,0,1641,2),(10079,115,0,1641,1),(10080,99,0,1641,1),(10081,93,0,1641,60),(10082,143,0,1641,170),(10083,97,0,1642,1),(10084,134,0,1642,2),(10085,115,0,1642,1),(10086,99,0,1642,4),(10087,144,0,1642,0),(10088,145,0,1642,1),(10089,146,0,1642,0),(10090,147,0,1642,1),(10091,148,0,1642,0),(10092,97,0,1643,1),(10093,134,0,1643,2),(10094,115,0,1643,1),(10095,99,0,1643,1),(10096,93,0,1643,50),(10097,143,0,1643,166),(10098,97,0,1644,1),(10099,134,0,1644,2),(10100,115,0,1644,1),(10101,99,0,1644,1),(10102,93,0,1644,57),(10103,143,0,1644,166),(10104,97,0,1645,1),(10105,134,0,1645,2),(10106,115,0,1645,1),(10107,99,0,1645,1),(10108,93,0,1645,60),(10109,143,0,1645,166),(10110,97,0,1646,1),(10111,134,0,1646,2),(10112,115,0,1646,1),(10113,99,0,1646,1),(10114,93,0,1646,50),(10115,143,0,1646,167),(10116,97,0,1647,1),(10117,134,0,1647,2),(10118,115,0,1647,1),(10119,99,0,1647,1),(10120,93,0,1647,57),(10121,143,0,1647,167),(10122,97,0,1648,1),(10123,134,0,1648,2),(10124,115,0,1648,1),(10125,99,0,1648,1),(10126,93,0,1648,60),(10127,143,0,1648,167),(10128,97,0,1649,1),(10129,134,0,1649,2),(10130,115,0,1649,1),(10131,99,0,1649,1),(10132,93,0,1649,50),(10133,143,0,1649,168),(10134,97,0,1650,1),(10135,134,0,1650,2),(10136,115,0,1650,1),(10137,99,0,1650,1),(10138,93,0,1650,57),(10139,143,0,1650,168),(10140,97,0,1651,1),(10141,134,0,1651,2),(10142,115,0,1651,1),(10143,99,0,1651,1),(10144,93,0,1651,60),(10145,143,0,1651,168),(10146,97,0,1652,1),(10147,134,0,1652,2),(10148,115,0,1652,1),(10149,99,0,1652,1),(10150,93,0,1652,50),(10151,143,0,1652,169),(10152,97,0,1653,1),(10153,134,0,1653,2),(10154,115,0,1653,1),(10155,99,0,1653,1),(10156,93,0,1653,57),(10157,143,0,1653,169),(10158,97,0,1654,1),(10159,134,0,1654,2),(10160,115,0,1654,1),(10161,99,0,1654,1),(10162,93,0,1654,60),(10163,143,0,1654,169),(10164,97,0,1655,1),(10165,134,0,1655,2),(10166,115,0,1655,1),(10167,99,0,1655,1),(10168,93,0,1655,50),(10169,143,0,1655,170),(10170,97,0,1656,1),(10171,134,0,1656,2),(10172,115,0,1656,1),(10173,99,0,1656,1),(10174,93,0,1656,57),(10175,143,0,1656,170),(10176,97,0,1657,1),(10177,134,0,1657,2),(10178,115,0,1657,1),(10179,99,0,1657,1),(10180,93,0,1657,60),(10181,143,0,1657,170),(10182,97,0,1658,1),(10183,134,0,1658,2),(10184,115,0,1658,1),(10185,99,0,1658,4),(10186,144,0,1658,0),(10187,145,0,1658,0),(10188,146,0,1658,0),(10189,147,0,1658,0),(10190,148,0,1658,0),(10191,97,0,1659,1),(10192,134,0,1659,2),(10193,115,0,1659,1),(10194,99,0,1659,1),(10195,93,0,1659,49),(10196,143,0,1659,166),(10197,97,0,1660,1),(10198,134,0,1660,2),(10199,115,0,1660,1),(10200,99,0,1660,1),(10201,93,0,1660,56),(10202,143,0,1660,166),(10203,97,0,1661,1),(10204,134,0,1661,2),(10205,115,0,1661,1),(10206,99,0,1661,1),(10207,93,0,1661,57),(10208,143,0,1661,166),(10209,97,0,1662,1),(10210,134,0,1662,2),(10211,115,0,1662,1),(10212,99,0,1662,1),(10213,93,0,1662,49),(10214,143,0,1662,167),(10215,97,0,1663,1),(10216,134,0,1663,2),(10217,115,0,1663,1),(10218,99,0,1663,1),(10219,93,0,1663,56),(10220,143,0,1663,167),(10221,97,0,1664,1),(10222,134,0,1664,2),(10223,115,0,1664,1),(10224,99,0,1664,1),(10225,93,0,1664,57),(10226,143,0,1664,167),(10227,97,0,1665,1),(10228,134,0,1665,2),(10229,115,0,1665,1),(10230,99,0,1665,1),(10231,93,0,1665,49),(10232,143,0,1665,168),(10233,97,0,1666,1),(10234,134,0,1666,2),(10235,115,0,1666,1),(10236,99,0,1666,1),(10237,93,0,1666,56),(10238,143,0,1666,168),(10239,97,0,1667,1),(10240,134,0,1667,2),(10241,115,0,1667,1),(10242,99,0,1667,1),(10243,93,0,1667,57),(10244,143,0,1667,168),(10245,97,0,1668,1),(10246,134,0,1668,2),(10247,115,0,1668,1),(10248,99,0,1668,1),(10249,93,0,1668,49),(10250,143,0,1668,169),(10251,97,0,1669,1),(10252,134,0,1669,2),(10253,115,0,1669,1),(10254,99,0,1669,1),(10255,93,0,1669,56),(10256,143,0,1669,169),(10257,97,0,1670,1),(10258,134,0,1670,2),(10259,115,0,1670,1),(10260,99,0,1670,1),(10261,93,0,1670,57),(10262,143,0,1670,169),(10263,97,0,1671,1),(10264,134,0,1671,2),(10265,115,0,1671,1),(10266,99,0,1671,1),(10267,93,0,1671,49),(10268,143,0,1671,170),(10269,97,0,1672,1),(10270,134,0,1672,2),(10271,115,0,1672,1),(10272,99,0,1672,1),(10273,93,0,1672,56),(10274,143,0,1672,170),(10275,97,0,1673,1),(10276,134,0,1673,2),(10277,115,0,1673,1),(10278,99,0,1673,1),(10279,93,0,1673,57),(10280,143,0,1673,170),(10281,97,0,1674,1),(10282,134,0,1674,2),(10283,115,0,1674,1),(10284,99,0,1674,4),(10285,144,0,1674,0),(10286,145,0,1674,0),(10287,146,0,1674,0),(10288,147,0,1674,0),(10289,148,0,1674,0),(10290,97,0,1675,1),(10291,134,0,1675,2),(10292,115,0,1675,1),(10293,99,0,1675,1),(10294,93,0,1675,49),(10295,143,0,1675,166),(10296,97,0,1676,1),(10297,134,0,1676,2),(10298,115,0,1676,1),(10299,99,0,1676,1),(10300,93,0,1676,50),(10301,143,0,1676,166),(10302,97,0,1677,1),(10303,134,0,1677,2),(10304,115,0,1677,1),(10305,99,0,1677,1),(10306,93,0,1677,56),(10307,143,0,1677,166),(10308,97,0,1678,1),(10309,134,0,1678,2),(10310,115,0,1678,1),(10311,99,0,1678,1),(10312,93,0,1678,49),(10313,143,0,1678,167),(10314,97,0,1679,1),(10315,134,0,1679,2),(10316,115,0,1679,1),(10317,99,0,1679,1),(10318,93,0,1679,50),(10319,143,0,1679,167),(10320,97,0,1680,1),(10321,134,0,1680,2),(10322,115,0,1680,1),(10323,99,0,1680,1),(10324,93,0,1680,56),(10325,143,0,1680,167),(10326,97,0,1681,1),(10327,134,0,1681,2),(10328,115,0,1681,1),(10329,99,0,1681,1),(10330,93,0,1681,49),(10331,143,0,1681,168),(10332,97,0,1682,1),(10333,134,0,1682,2),(10334,115,0,1682,1),(10335,99,0,1682,1),(10336,93,0,1682,50),(10337,143,0,1682,168),(10338,97,0,1683,1),(10339,134,0,1683,2),(10340,115,0,1683,1),(10341,99,0,1683,1),(10342,93,0,1683,56),(10343,143,0,1683,168),(10344,97,0,1684,1),(10345,134,0,1684,2),(10346,115,0,1684,1),(10347,99,0,1684,1),(10348,93,0,1684,49),(10349,143,0,1684,169),(10350,97,0,1685,1),(10351,134,0,1685,2),(10352,115,0,1685,1),(10353,99,0,1685,1),(10354,93,0,1685,50),(10355,143,0,1685,169),(10356,97,0,1686,1),(10357,134,0,1686,2),(10358,115,0,1686,1),(10359,99,0,1686,1),(10360,93,0,1686,56),(10361,143,0,1686,169),(10362,97,0,1687,1),(10363,134,0,1687,2),(10364,115,0,1687,1),(10365,99,0,1687,1),(10366,93,0,1687,49),(10367,143,0,1687,170),(10368,97,0,1688,1),(10369,134,0,1688,2),(10370,115,0,1688,1),(10371,99,0,1688,1),(10372,93,0,1688,50),(10373,143,0,1688,170),(10374,97,0,1689,1),(10375,134,0,1689,2),(10376,115,0,1689,1),(10377,99,0,1689,1),(10378,93,0,1689,56),(10379,143,0,1689,170),(10380,97,0,1690,1),(10381,134,0,1690,2),(10382,115,0,1690,1),(10383,99,0,1690,4),(10384,144,0,1690,1),(10385,145,0,1690,0),(10386,146,0,1690,0),(10387,147,0,1690,0),(10388,148,0,1690,0),(10389,97,0,1691,1),(10390,134,0,1691,2),(10391,115,0,1691,1),(10392,99,0,1691,1),(10393,93,0,1691,53),(10394,143,0,1691,166),(10395,97,0,1692,1),(10396,134,0,1692,2),(10397,115,0,1692,1),(10398,99,0,1692,1),(10399,93,0,1692,56),(10400,143,0,1692,166),(10401,97,0,1693,1),(10402,134,0,1693,2),(10403,115,0,1693,1),(10404,99,0,1693,1),(10405,93,0,1693,60),(10406,143,0,1693,166),(10407,97,0,1694,1),(10408,134,0,1694,2),(10409,115,0,1694,1),(10410,99,0,1694,1),(10411,93,0,1694,53),(10412,143,0,1694,167),(10413,97,0,1695,1),(10414,134,0,1695,2),(10415,115,0,1695,1),(10416,99,0,1695,1),(10417,93,0,1695,56),(10418,143,0,1695,167),(10419,97,0,1696,1),(10420,134,0,1696,2),(10421,115,0,1696,1),(10422,99,0,1696,1),(10423,93,0,1696,60),(10424,143,0,1696,167),(10425,97,0,1697,1),(10426,134,0,1697,2),(10427,115,0,1697,1),(10428,99,0,1697,1),(10429,93,0,1697,53),(10430,143,0,1697,168),(10431,97,0,1698,1),(10432,134,0,1698,2),(10433,115,0,1698,1),(10434,99,0,1698,1),(10435,93,0,1698,56),(10436,143,0,1698,168),(10437,97,0,1699,1),(10438,134,0,1699,2),(10439,115,0,1699,1),(10440,99,0,1699,1),(10441,93,0,1699,60),(10442,143,0,1699,168),(10443,97,0,1700,1),(10444,134,0,1700,2),(10445,115,0,1700,1),(10446,99,0,1700,1),(10447,93,0,1700,53),(10448,143,0,1700,169),(10449,97,0,1701,1),(10450,134,0,1701,2),(10451,115,0,1701,1),(10452,99,0,1701,1),(10453,93,0,1701,56),(10454,143,0,1701,169),(10455,97,0,1702,1),(10456,134,0,1702,2),(10457,115,0,1702,1),(10458,99,0,1702,1),(10459,93,0,1702,60),(10460,143,0,1702,169),(10461,97,0,1703,1),(10462,134,0,1703,2),(10463,115,0,1703,1),(10464,99,0,1703,1),(10465,93,0,1703,53),(10466,143,0,1703,170),(10467,97,0,1704,1),(10468,134,0,1704,2),(10469,115,0,1704,1),(10470,99,0,1704,1),(10471,93,0,1704,56),(10472,143,0,1704,170),(10473,97,0,1705,1),(10474,134,0,1705,2),(10475,115,0,1705,1),(10476,99,0,1705,1),(10477,93,0,1705,60),(10478,143,0,1705,170),(10479,97,0,1706,1),(10480,134,0,1706,2),(10481,115,0,1706,1),(10482,99,0,1706,4),(10483,144,0,1706,0),(10484,145,0,1706,0),(10485,146,0,1706,0),(10486,147,0,1706,0),(10487,148,0,1706,0),(10488,97,0,1707,1),(10489,134,0,1707,2),(10490,115,0,1707,1),(10491,99,0,1707,1),(10492,93,0,1707,56),(10493,143,0,1707,166),(10494,97,0,1708,1),(10495,134,0,1708,2),(10496,115,0,1708,1),(10497,99,0,1708,1),(10498,93,0,1708,57),(10499,143,0,1708,166),(10500,97,0,1709,1),(10501,134,0,1709,2),(10502,115,0,1709,1),(10503,99,0,1709,1),(10504,93,0,1709,58),(10505,143,0,1709,166),(10506,97,0,1710,1),(10507,134,0,1710,2),(10508,115,0,1710,1),(10509,99,0,1710,1),(10510,93,0,1710,56),(10511,143,0,1710,167),(10512,97,0,1711,1),(10513,134,0,1711,2),(10514,115,0,1711,1),(10515,99,0,1711,1),(10516,93,0,1711,57),(10517,143,0,1711,167),(10518,97,0,1712,1),(10519,134,0,1712,2),(10520,115,0,1712,1),(10521,99,0,1712,1),(10522,93,0,1712,58),(10523,143,0,1712,167),(10524,97,0,1713,1),(10525,134,0,1713,2),(10526,115,0,1713,1),(10527,99,0,1713,1),(10528,93,0,1713,56),(10529,143,0,1713,168),(10530,97,0,1714,1),(10531,134,0,1714,2),(10532,115,0,1714,1),(10533,99,0,1714,1),(10534,93,0,1714,57),(10535,143,0,1714,168),(10536,97,0,1715,1),(10537,134,0,1715,2),(10538,115,0,1715,1),(10539,99,0,1715,1),(10540,93,0,1715,58),(10541,143,0,1715,168),(10542,97,0,1716,1),(10543,134,0,1716,2),(10544,115,0,1716,1),(10545,99,0,1716,1),(10546,93,0,1716,56),(10547,143,0,1716,169),(10548,97,0,1717,1),(10549,134,0,1717,2),(10550,115,0,1717,1),(10551,99,0,1717,1),(10552,93,0,1717,57),(10553,143,0,1717,169),(10554,97,0,1718,1),(10555,134,0,1718,2),(10556,115,0,1718,1),(10557,99,0,1718,1),(10558,93,0,1718,58),(10559,143,0,1718,169),(10560,97,0,1719,1),(10561,134,0,1719,2),(10562,115,0,1719,1),(10563,99,0,1719,1),(10564,93,0,1719,56),(10565,143,0,1719,170),(10566,97,0,1720,1),(10567,134,0,1720,2),(10568,115,0,1720,1),(10569,99,0,1720,1),(10570,93,0,1720,57),(10571,143,0,1720,170),(10572,97,0,1721,1),(10573,134,0,1721,2),(10574,115,0,1721,1),(10575,99,0,1721,1),(10576,93,0,1721,58),(10577,143,0,1721,170),(10578,97,0,1722,1),(10579,134,0,1722,2),(10580,115,0,1722,1),(10581,99,0,1722,4),(10582,144,0,1722,0),(10583,145,0,1722,0),(10584,146,0,1722,1),(10585,147,0,1722,1),(10586,148,0,1722,0),(10587,97,0,1723,1),(10588,134,0,1723,2),(10589,115,0,1723,1),(10590,99,0,1723,1),(10591,93,0,1723,50),(10592,143,0,1723,166),(10593,97,0,1724,1),(10594,134,0,1724,2),(10595,115,0,1724,1),(10596,99,0,1724,1),(10597,93,0,1724,57),(10598,143,0,1724,166),(10599,97,0,1725,1),(10600,134,0,1725,2),(10601,115,0,1725,1),(10602,99,0,1725,1),(10603,93,0,1725,58),(10604,143,0,1725,166),(10605,97,0,1726,1),(10606,134,0,1726,2),(10607,115,0,1726,1),(10608,99,0,1726,1),(10609,93,0,1726,50),(10610,143,0,1726,167),(10611,97,0,1727,1),(10612,134,0,1727,2),(10613,115,0,1727,1),(10614,99,0,1727,1),(10615,93,0,1727,57),(10616,143,0,1727,167),(10617,97,0,1728,1),(10618,134,0,1728,2),(10619,115,0,1728,1),(10620,99,0,1728,1),(10621,93,0,1728,58),(10622,143,0,1728,167),(10623,97,0,1729,1),(10624,134,0,1729,2),(10625,115,0,1729,1),(10626,99,0,1729,1),(10627,93,0,1729,50),(10628,143,0,1729,168),(10629,97,0,1730,1),(10630,134,0,1730,2),(10631,115,0,1730,1),(10632,99,0,1730,1),(10633,93,0,1730,57),(10634,143,0,1730,168),(10635,97,0,1731,1),(10636,134,0,1731,2),(10637,115,0,1731,1),(10638,99,0,1731,1),(10639,93,0,1731,58),(10640,143,0,1731,168),(10641,97,0,1732,1),(10642,134,0,1732,2),(10643,115,0,1732,1),(10644,99,0,1732,1),(10645,93,0,1732,50),(10646,143,0,1732,169),(10647,97,0,1733,1),(10648,134,0,1733,2),(10649,115,0,1733,1),(10650,99,0,1733,1),(10651,93,0,1733,57),(10652,143,0,1733,169),(10653,97,0,1734,1),(10654,134,0,1734,2),(10655,115,0,1734,1),(10656,99,0,1734,1),(10657,93,0,1734,58),(10658,143,0,1734,169),(10659,97,0,1735,1),(10660,134,0,1735,2),(10661,115,0,1735,1),(10662,99,0,1735,1),(10663,93,0,1735,50),(10664,143,0,1735,170),(10665,97,0,1736,1),(10666,134,0,1736,2),(10667,115,0,1736,1),(10668,99,0,1736,1),(10669,93,0,1736,57),(10670,143,0,1736,170),(10671,97,0,1737,1),(10672,134,0,1737,2),(10673,115,0,1737,1),(10674,99,0,1737,1),(10675,93,0,1737,58),(10676,143,0,1737,170),(10677,97,0,1738,1),(10678,134,0,1738,2),(10679,115,0,1738,1),(10680,99,0,1738,4),(10681,144,0,1738,1),(10682,145,0,1738,1),(10683,146,0,1738,0),(10684,147,0,1738,0),(10685,148,0,1738,0),(10686,97,0,1739,1),(10687,134,0,1739,2),(10688,115,0,1739,1),(10689,99,0,1739,1),(10690,93,0,1739,56),(10691,143,0,1739,166),(10692,97,0,1740,1),(10693,134,0,1740,2),(10694,115,0,1740,1),(10695,99,0,1740,1),(10696,93,0,1740,57),(10697,143,0,1740,166),(10698,97,0,1741,1),(10699,134,0,1741,2),(10700,115,0,1741,1),(10701,99,0,1741,1),(10702,93,0,1741,59),(10703,143,0,1741,166),(10704,97,0,1742,1),(10705,134,0,1742,2),(10706,115,0,1742,1),(10707,99,0,1742,1),(10708,93,0,1742,56),(10709,143,0,1742,167),(10710,97,0,1743,1),(10711,134,0,1743,2),(10712,115,0,1743,1),(10713,99,0,1743,1),(10714,93,0,1743,57),(10715,143,0,1743,167),(10716,97,0,1744,1),(10717,134,0,1744,2),(10718,115,0,1744,1),(10719,99,0,1744,1),(10720,93,0,1744,59),(10721,143,0,1744,167),(10722,97,0,1745,1),(10723,134,0,1745,2),(10724,115,0,1745,1),(10725,99,0,1745,1),(10726,93,0,1745,56),(10727,143,0,1745,168),(10728,97,0,1746,1),(10729,134,0,1746,2),(10730,115,0,1746,1),(10731,99,0,1746,1),(10732,93,0,1746,57),(10733,143,0,1746,168),(10734,97,0,1747,1),(10735,134,0,1747,2),(10736,115,0,1747,1),(10737,99,0,1747,1),(10738,93,0,1747,59),(10739,143,0,1747,168),(10740,97,0,1748,1),(10741,134,0,1748,2),(10742,115,0,1748,1),(10743,99,0,1748,1),(10744,93,0,1748,56),(10745,143,0,1748,169),(10746,97,0,1749,1),(10747,134,0,1749,2),(10748,115,0,1749,1),(10749,99,0,1749,1),(10750,93,0,1749,57),(10751,143,0,1749,169),(10752,97,0,1750,1),(10753,134,0,1750,2),(10754,115,0,1750,1),(10755,99,0,1750,1),(10756,93,0,1750,59),(10757,143,0,1750,169),(10758,97,0,1751,1),(10759,134,0,1751,2),(10760,115,0,1751,1),(10761,99,0,1751,1),(10762,93,0,1751,56),(10763,143,0,1751,170),(10764,97,0,1752,1),(10765,134,0,1752,2),(10766,115,0,1752,1),(10767,99,0,1752,1),(10768,93,0,1752,57),(10769,143,0,1752,170),(10770,97,0,1753,1),(10771,134,0,1753,2),(10772,115,0,1753,1),(10773,99,0,1753,1),(10774,93,0,1753,59),(10775,143,0,1753,170),(10776,97,0,1754,1),(10777,134,0,1754,2),(10778,115,0,1754,1),(10779,99,0,1754,4),(10780,144,0,1754,0),(10781,145,0,1754,0),(10782,146,0,1754,1),(10783,147,0,1754,0),(10784,148,0,1754,0),(10785,97,0,1755,1),(10786,134,0,1755,2),(10787,115,0,1755,1),(10788,99,0,1755,1),(10789,93,0,1755,50),(10790,143,0,1755,166),(10791,97,0,1756,1),(10792,134,0,1756,2),(10793,115,0,1756,1),(10794,99,0,1756,1),(10795,93,0,1756,58),(10796,143,0,1756,166),(10797,97,0,1757,1),(10798,134,0,1757,2),(10799,115,0,1757,1),(10800,99,0,1757,1),(10801,93,0,1757,60),(10802,143,0,1757,166),(10803,97,0,1758,1),(10804,134,0,1758,2),(10805,115,0,1758,1),(10806,99,0,1758,1),(10807,93,0,1758,50),(10808,143,0,1758,167),(10809,97,0,1759,1),(10810,134,0,1759,2),(10811,115,0,1759,1),(10812,99,0,1759,1),(10813,93,0,1759,58),(10814,143,0,1759,167),(10815,97,0,1760,1),(10816,134,0,1760,2),(10817,115,0,1760,1),(10818,99,0,1760,1),(10819,93,0,1760,60),(10820,143,0,1760,167),(10821,97,0,1761,1),(10822,134,0,1761,2),(10823,115,0,1761,1),(10824,99,0,1761,1),(10825,93,0,1761,50),(10826,143,0,1761,168),(10827,97,0,1762,1),(10828,134,0,1762,2),(10829,115,0,1762,1),(10830,99,0,1762,1),(10831,93,0,1762,58),(10832,143,0,1762,168),(10833,97,0,1763,1),(10834,134,0,1763,2),(10835,115,0,1763,1),(10836,99,0,1763,1),(10837,93,0,1763,60),(10838,143,0,1763,168),(10839,97,0,1764,1),(10840,134,0,1764,2),(10841,115,0,1764,1),(10842,99,0,1764,1),(10843,93,0,1764,50),(10844,143,0,1764,169),(10845,97,0,1765,1),(10846,134,0,1765,2),(10847,115,0,1765,1),(10848,99,0,1765,1),(10849,93,0,1765,58),(10850,143,0,1765,169),(10851,97,0,1766,1),(10852,134,0,1766,2),(10853,115,0,1766,1),(10854,99,0,1766,1),(10855,93,0,1766,60),(10856,143,0,1766,169),(10857,97,0,1767,1),(10858,134,0,1767,2),(10859,115,0,1767,1),(10860,99,0,1767,1),(10861,93,0,1767,50),(10862,143,0,1767,170),(10863,97,0,1768,1),(10864,134,0,1768,2),(10865,115,0,1768,1),(10866,99,0,1768,1),(10867,93,0,1768,58),(10868,143,0,1768,170),(10869,97,0,1769,1),(10870,134,0,1769,2),(10871,115,0,1769,1),(10872,99,0,1769,1),(10873,93,0,1769,60),(10874,143,0,1769,170),(10875,97,0,1770,1),(10876,134,0,1770,2),(10877,115,0,1770,1),(10878,99,0,1770,4),(10879,144,0,1770,0),(10880,145,0,1770,0),(10881,146,0,1770,0),(10882,147,0,1770,0),(10883,148,0,1770,0),(10884,97,0,1771,1),(10885,134,0,1771,2),(10886,115,0,1771,1),(10887,99,0,1771,1),(10888,93,0,1771,53),(10889,143,0,1771,166),(10890,97,0,1772,1),(10891,134,0,1772,2),(10892,115,0,1772,1),(10893,99,0,1772,1),(10894,93,0,1772,59),(10895,143,0,1772,166),(10896,97,0,1773,1),(10897,134,0,1773,2),(10898,115,0,1773,1),(10899,99,0,1773,1),(10900,93,0,1773,60),(10901,143,0,1773,166),(10902,97,0,1774,1),(10903,134,0,1774,2),(10904,115,0,1774,1),(10905,99,0,1774,1),(10906,93,0,1774,53),(10907,143,0,1774,167),(10908,97,0,1775,1),(10909,134,0,1775,2),(10910,115,0,1775,1),(10911,99,0,1775,1),(10912,93,0,1775,59),(10913,143,0,1775,167),(10914,97,0,1776,1),(10915,134,0,1776,2),(10916,115,0,1776,1),(10917,99,0,1776,1),(10918,93,0,1776,60),(10919,143,0,1776,167),(10920,97,0,1777,1),(10921,134,0,1777,2),(10922,115,0,1777,1),(10923,99,0,1777,1),(10924,93,0,1777,53),(10925,143,0,1777,168),(10926,97,0,1778,1),(10927,134,0,1778,2),(10928,115,0,1778,1),(10929,99,0,1778,1),(10930,93,0,1778,59),(10931,143,0,1778,168),(10932,97,0,1779,1),(10933,134,0,1779,2),(10934,115,0,1779,1),(10935,99,0,1779,1),(10936,93,0,1779,60),(10937,143,0,1779,168),(10938,97,0,1780,1),(10939,134,0,1780,2),(10940,115,0,1780,1),(10941,99,0,1780,1),(10942,93,0,1780,53),(10943,143,0,1780,169),(10944,97,0,1781,1),(10945,134,0,1781,2),(10946,115,0,1781,1),(10947,99,0,1781,1),(10948,93,0,1781,59),(10949,143,0,1781,169),(10950,97,0,1782,1),(10951,134,0,1782,2),(10952,115,0,1782,1),(10953,99,0,1782,1),(10954,93,0,1782,60),(10955,143,0,1782,169),(10956,97,0,1783,1),(10957,134,0,1783,2),(10958,115,0,1783,1),(10959,99,0,1783,1),(10960,93,0,1783,53),(10961,143,0,1783,170),(10962,97,0,1784,1),(10963,134,0,1784,2),(10964,115,0,1784,1),(10965,99,0,1784,1),(10966,93,0,1784,59),(10967,143,0,1784,170),(10968,97,0,1785,1),(10969,134,0,1785,2),(10970,115,0,1785,1),(10971,99,0,1785,1),(10972,93,0,1785,60),(10973,143,0,1785,170),(10974,97,0,1786,1),(10975,134,0,1786,2),(10976,115,0,1786,1),(10977,99,0,1786,4),(10978,144,0,1786,0),(10979,145,0,1786,1),(10980,146,0,1786,0),(10981,147,0,1786,0),(10982,148,0,1786,0),(10983,97,0,1787,1),(10984,134,0,1787,2),(10985,115,0,1787,1),(10986,99,0,1787,1),(10987,93,0,1787,49),(10988,143,0,1787,166),(10989,97,0,1788,1),(10990,134,0,1788,2),(10991,115,0,1788,1),(10992,99,0,1788,1),(10993,93,0,1788,57),(10994,143,0,1788,166),(10995,97,0,1789,1),(10996,134,0,1789,2),(10997,115,0,1789,1),(10998,99,0,1789,1),(10999,93,0,1789,60),(11000,143,0,1789,166),(11001,97,0,1790,1),(11002,134,0,1790,2),(11003,115,0,1790,1),(11004,99,0,1790,1),(11005,93,0,1790,49),(11006,143,0,1790,167),(11007,97,0,1791,1),(11008,134,0,1791,2),(11009,115,0,1791,1),(11010,99,0,1791,1),(11011,93,0,1791,57),(11012,143,0,1791,167),(11013,97,0,1792,1),(11014,134,0,1792,2),(11015,115,0,1792,1),(11016,99,0,1792,1),(11017,93,0,1792,60),(11018,143,0,1792,167),(11019,97,0,1793,1),(11020,134,0,1793,2),(11021,115,0,1793,1),(11022,99,0,1793,1),(11023,93,0,1793,49),(11024,143,0,1793,168),(11025,97,0,1794,1),(11026,134,0,1794,2),(11027,115,0,1794,1),(11028,99,0,1794,1),(11029,93,0,1794,57),(11030,143,0,1794,168),(11031,97,0,1795,1),(11032,134,0,1795,2),(11033,115,0,1795,1),(11034,99,0,1795,1),(11035,93,0,1795,60),(11036,143,0,1795,168),(11037,97,0,1796,1),(11038,134,0,1796,2),(11039,115,0,1796,1),(11040,99,0,1796,1),(11041,93,0,1796,49),(11042,143,0,1796,169),(11043,97,0,1797,1),(11044,134,0,1797,2),(11045,115,0,1797,1),(11046,99,0,1797,1),(11047,93,0,1797,57),(11048,143,0,1797,169),(11049,97,0,1798,1),(11050,134,0,1798,2),(11051,115,0,1798,1),(11052,99,0,1798,1),(11053,93,0,1798,60),(11054,143,0,1798,169),(11055,97,0,1799,1),(11056,134,0,1799,2),(11057,115,0,1799,1),(11058,99,0,1799,1),(11059,93,0,1799,49),(11060,143,0,1799,170),(11061,97,0,1800,1),(11062,134,0,1800,2),(11063,115,0,1800,1),(11064,99,0,1800,1),(11065,93,0,1800,57),(11066,143,0,1800,170),(11067,97,0,1801,1),(11068,134,0,1801,2),(11069,115,0,1801,1),(11070,99,0,1801,1),(11071,93,0,1801,60),(11072,143,0,1801,170),(11073,97,0,1802,1),(11074,134,0,1802,2),(11075,115,0,1802,1),(11076,99,0,1802,4),(11077,144,0,1802,0),(11078,145,0,1802,1),(11079,146,0,1802,0),(11080,147,0,1802,0),(11081,148,0,1802,1),(11082,97,0,1803,1),(11083,134,0,1803,2),(11084,115,0,1803,1),(11085,99,0,1803,1),(11086,93,0,1803,57),(11087,143,0,1803,166),(11088,97,0,1804,1),(11089,134,0,1804,2),(11090,115,0,1804,1),(11091,99,0,1804,1),(11092,93,0,1804,59),(11093,143,0,1804,166),(11094,97,0,1805,1),(11095,134,0,1805,2),(11096,115,0,1805,1),(11097,99,0,1805,1),(11098,93,0,1805,60),(11099,143,0,1805,166),(11100,97,0,1806,1),(11101,134,0,1806,2),(11102,115,0,1806,1),(11103,99,0,1806,1),(11104,93,0,1806,57),(11105,143,0,1806,167),(11106,97,0,1807,1),(11107,134,0,1807,2),(11108,115,0,1807,1),(11109,99,0,1807,1),(11110,93,0,1807,59),(11111,143,0,1807,167),(11112,97,0,1808,1),(11113,134,0,1808,2),(11114,115,0,1808,1),(11115,99,0,1808,1),(11116,93,0,1808,60),(11117,143,0,1808,167),(11118,97,0,1809,1),(11119,134,0,1809,2),(11120,115,0,1809,1),(11121,99,0,1809,1),(11122,93,0,1809,57),(11123,143,0,1809,168),(11124,97,0,1810,1),(11125,134,0,1810,2),(11126,115,0,1810,1),(11127,99,0,1810,1),(11128,93,0,1810,59),(11129,143,0,1810,168),(11130,97,0,1811,1),(11131,134,0,1811,2),(11132,115,0,1811,1),(11133,99,0,1811,1),(11134,93,0,1811,60),(11135,143,0,1811,168),(11136,97,0,1812,1),(11137,134,0,1812,2),(11138,115,0,1812,1),(11139,99,0,1812,1),(11140,93,0,1812,57),(11141,143,0,1812,169),(11142,97,0,1813,1),(11143,134,0,1813,2),(11144,115,0,1813,1),(11145,99,0,1813,1),(11146,93,0,1813,59),(11147,143,0,1813,169),(11148,97,0,1814,1),(11149,134,0,1814,2),(11150,115,0,1814,1),(11151,99,0,1814,1),(11152,93,0,1814,60),(11153,143,0,1814,169),(11154,97,0,1815,1),(11155,134,0,1815,2),(11156,115,0,1815,1),(11157,99,0,1815,1),(11158,93,0,1815,57),(11159,143,0,1815,170),(11160,97,0,1816,1),(11161,134,0,1816,2),(11162,115,0,1816,1),(11163,99,0,1816,1),(11164,93,0,1816,59),(11165,143,0,1816,170),(11166,97,0,1817,1),(11167,134,0,1817,2),(11168,115,0,1817,1),(11169,99,0,1817,1),(11170,93,0,1817,60),(11171,143,0,1817,170),(11172,97,0,1818,1),(11173,134,0,1818,2),(11174,115,0,1818,1),(11175,99,0,1818,4),(11176,144,0,1818,0),(11177,145,0,1818,1),(11178,146,0,1818,1),(11179,147,0,1818,0),(11180,148,0,1818,1),(11181,97,0,1819,1),(11182,134,0,1819,2),(11183,115,0,1819,1),(11184,99,0,1819,1),(11185,93,0,1819,49),(11186,143,0,1819,171),(11187,97,0,1820,1),(11188,134,0,1820,2),(11189,115,0,1820,1),(11190,99,0,1820,1),(11191,93,0,1820,52),(11192,143,0,1820,171),(11193,97,0,1821,1),(11194,134,0,1821,2),(11195,115,0,1821,1),(11196,99,0,1821,1),(11197,93,0,1821,59),(11198,143,0,1821,171),(11199,97,0,1822,1),(11200,134,0,1822,2),(11201,115,0,1822,1),(11202,99,0,1822,1),(11203,93,0,1822,49),(11204,143,0,1822,172),(11205,97,0,1823,1),(11206,134,0,1823,2),(11207,115,0,1823,1),(11208,99,0,1823,1),(11209,93,0,1823,52),(11210,143,0,1823,172),(11211,97,0,1824,1),(11212,134,0,1824,2),(11213,115,0,1824,1),(11214,99,0,1824,1),(11215,93,0,1824,59),(11216,143,0,1824,172),(11217,97,0,1825,1),(11218,134,0,1825,2),(11219,115,0,1825,1),(11220,99,0,1825,4),(11221,144,0,1825,1),(11222,145,0,1825,1),(11223,146,0,1825,0),(11224,147,0,1825,0),(11225,148,0,1825,0),(11226,97,0,1826,1),(11227,134,0,1826,2),(11228,115,0,1826,1),(11229,99,0,1826,1),(11230,93,0,1826,50),(11231,143,0,1826,171),(11232,97,0,1827,1),(11233,134,0,1827,2),(11234,115,0,1827,1),(11235,99,0,1827,1),(11236,93,0,1827,57),(11237,143,0,1827,171),(11238,97,0,1828,1),(11239,134,0,1828,2),(11240,115,0,1828,1),(11241,99,0,1828,1),(11242,93,0,1828,58),(11243,143,0,1828,171),(11244,97,0,1829,1),(11245,134,0,1829,2),(11246,115,0,1829,1),(11247,99,0,1829,1),(11248,93,0,1829,50),(11249,143,0,1829,172),(11250,97,0,1830,1),(11251,134,0,1830,2),(11252,115,0,1830,1),(11253,99,0,1830,1),(11254,93,0,1830,57),(11255,143,0,1830,172),(11256,97,0,1831,1),(11257,134,0,1831,2),(11258,115,0,1831,1),(11259,99,0,1831,1),(11260,93,0,1831,58),(11261,143,0,1831,172),(11262,97,0,1832,1),(11263,134,0,1832,2),(11264,115,0,1832,1),(11265,99,0,1832,4),(11266,144,0,1832,0),(11267,145,0,1832,1),(11268,146,0,1832,0),(11269,147,0,1832,0),(11270,148,0,1832,0),(11271,97,0,1833,1),(11272,134,0,1833,2),(11273,115,0,1833,1),(11274,99,0,1833,1),(11275,93,0,1833,49),(11276,143,0,1833,171),(11277,97,0,1834,1),(11278,134,0,1834,2),(11279,115,0,1834,1),(11280,99,0,1834,1),(11281,93,0,1834,50),(11282,143,0,1834,171),(11283,97,0,1835,1),(11284,134,0,1835,2),(11285,115,0,1835,1),(11286,99,0,1835,1),(11287,93,0,1835,57),(11288,143,0,1835,171),(11289,97,0,1836,1),(11290,134,0,1836,2),(11291,115,0,1836,1),(11292,99,0,1836,1),(11293,93,0,1836,49),(11294,143,0,1836,172),(11295,97,0,1837,1),(11296,134,0,1837,2),(11297,115,0,1837,1),(11298,99,0,1837,1),(11299,93,0,1837,50),(11300,143,0,1837,172),(11301,97,0,1838,1),(11302,134,0,1838,2),(11303,115,0,1838,1),(11304,99,0,1838,1),(11305,93,0,1838,57),(11306,143,0,1838,172),(11307,97,0,1839,1),(11308,134,0,1839,2),(11309,115,0,1839,1),(11310,99,0,1839,4),(11311,144,0,1839,0),(11312,145,0,1839,0),(11313,146,0,1839,0),(11314,147,0,1839,1),(11315,148,0,1839,0),(11316,97,0,1840,1),(11317,134,0,1840,2),(11318,115,0,1840,1),(11319,99,0,1840,1),(11320,93,0,1840,49),(11321,143,0,1840,171),(11322,97,0,1841,1),(11323,134,0,1841,2),(11324,115,0,1841,1),(11325,99,0,1841,1),(11326,93,0,1841,50),(11327,143,0,1841,171),(11328,97,0,1842,1),(11329,134,0,1842,2),(11330,115,0,1842,1),(11331,99,0,1842,1),(11332,93,0,1842,59),(11333,143,0,1842,171),(11334,97,0,1843,1),(11335,134,0,1843,2),(11336,115,0,1843,1),(11337,99,0,1843,1),(11338,93,0,1843,49),(11339,143,0,1843,172),(11340,97,0,1844,1),(11341,134,0,1844,2),(11342,115,0,1844,1),(11343,99,0,1844,1),(11344,93,0,1844,50),(11345,143,0,1844,172),(11346,97,0,1845,1),(11347,134,0,1845,2),(11348,115,0,1845,1),(11349,99,0,1845,1),(11350,93,0,1845,59),(11351,143,0,1845,172),(11352,97,0,1846,1),(11353,134,0,1846,2),(11354,115,0,1846,1),(11355,99,0,1846,4),(11356,144,0,1846,0),(11357,145,0,1846,0),(11358,146,0,1846,0),(11359,147,0,1846,0),(11360,148,0,1846,0),(11361,97,0,1847,1),(11362,134,0,1847,2),(11363,115,0,1847,1),(11364,99,0,1847,1),(11365,93,0,1847,50),(11366,143,0,1847,171),(11367,97,0,1848,1),(11368,134,0,1848,2),(11369,115,0,1848,1),(11370,99,0,1848,1),(11371,93,0,1848,52),(11372,143,0,1848,171),(11373,97,0,1849,1),(11374,134,0,1849,2),(11375,115,0,1849,1),(11376,99,0,1849,1),(11377,93,0,1849,58),(11378,143,0,1849,171),(11379,97,0,1850,1),(11380,134,0,1850,2),(11381,115,0,1850,1),(11382,99,0,1850,1),(11383,93,0,1850,50),(11384,143,0,1850,172),(11385,97,0,1851,1),(11386,134,0,1851,2),(11387,115,0,1851,1),(11388,99,0,1851,1),(11389,93,0,1851,52),(11390,143,0,1851,172),(11391,97,0,1852,1),(11392,134,0,1852,2),(11393,115,0,1852,1),(11394,99,0,1852,1),(11395,93,0,1852,58),(11396,143,0,1852,172),(11397,97,0,1853,1),(11398,134,0,1853,2),(11399,115,0,1853,1),(11400,99,0,1853,4),(11401,144,0,1853,0),(11402,145,0,1853,0),(11403,146,0,1853,1),(11404,147,0,1853,0),(11405,148,0,1853,0),(11406,97,0,1854,1),(11407,134,0,1854,2),(11408,115,0,1854,1),(11409,99,0,1854,1),(11410,93,0,1854,49),(11411,143,0,1854,171),(11412,97,0,1855,1),(11413,134,0,1855,2),(11414,115,0,1855,1),(11415,99,0,1855,1),(11416,93,0,1855,50),(11417,143,0,1855,171),(11418,97,0,1856,1),(11419,134,0,1856,2),(11420,115,0,1856,1),(11421,99,0,1856,1),(11422,93,0,1856,56),(11423,143,0,1856,171),(11424,97,0,1857,1),(11425,134,0,1857,2),(11426,115,0,1857,1),(11427,99,0,1857,1),(11428,93,0,1857,49),(11429,143,0,1857,172),(11430,97,0,1858,1),(11431,134,0,1858,2),(11432,115,0,1858,1),(11433,99,0,1858,1),(11434,93,0,1858,50),(11435,143,0,1858,172),(11436,97,0,1859,1),(11437,134,0,1859,2),(11438,115,0,1859,1),(11439,99,0,1859,1),(11440,93,0,1859,56),(11441,143,0,1859,172),(11442,97,0,1860,1),(11443,134,0,1860,2),(11444,115,0,1860,1),(11445,99,0,1860,4),(11446,144,0,1860,0),(11447,145,0,1860,0),(11448,146,0,1860,1),(11449,147,0,1860,0),(11450,148,0,1860,0),(11451,97,0,1861,1),(11452,134,0,1861,2),(11453,115,0,1861,1),(11454,99,0,1861,1),(11455,93,0,1861,49),(11456,143,0,1861,171),(11457,97,0,1862,1),(11458,134,0,1862,2),(11459,115,0,1862,1),(11460,99,0,1862,1),(11461,93,0,1862,50),(11462,143,0,1862,171),(11463,97,0,1863,1),(11464,134,0,1863,2),(11465,115,0,1863,1),(11466,99,0,1863,1),(11467,93,0,1863,56),(11468,143,0,1863,171),(11469,97,0,1864,1),(11470,134,0,1864,2),(11471,115,0,1864,1),(11472,99,0,1864,1),(11473,93,0,1864,49),(11474,143,0,1864,172),(11475,97,0,1865,1),(11476,134,0,1865,2),(11477,115,0,1865,1),(11478,99,0,1865,1),(11479,93,0,1865,50),(11480,143,0,1865,172),(11481,97,0,1866,1),(11482,134,0,1866,2),(11483,115,0,1866,1),(11484,99,0,1866,1),(11485,93,0,1866,56),(11486,143,0,1866,172),(11487,97,0,1867,1),(11488,134,0,1867,2),(11489,115,0,1867,1),(11490,99,0,1867,4),(11491,144,0,1867,0),(11492,145,0,1867,1),(11493,146,0,1867,0),(11494,147,0,1867,0),(11495,148,0,1867,0),(11496,97,0,1868,1),(11497,134,0,1868,2),(11498,115,0,1868,1),(11499,99,0,1868,1),(11500,93,0,1868,49),(11501,143,0,1868,171),(11502,97,0,1869,1),(11503,134,0,1869,2),(11504,115,0,1869,1),(11505,99,0,1869,1),(11506,93,0,1869,53),(11507,143,0,1869,171),(11508,97,0,1870,1),(11509,134,0,1870,2),(11510,115,0,1870,1),(11511,99,0,1870,1),(11512,93,0,1870,58),(11513,143,0,1870,171),(11514,97,0,1871,1),(11515,134,0,1871,2),(11516,115,0,1871,1),(11517,99,0,1871,1),(11518,93,0,1871,49),(11519,143,0,1871,172),(11520,97,0,1872,1),(11521,134,0,1872,2),(11522,115,0,1872,1),(11523,99,0,1872,1),(11524,93,0,1872,53),(11525,143,0,1872,172),(11526,97,0,1873,1),(11527,134,0,1873,2),(11528,115,0,1873,1),(11529,99,0,1873,1),(11530,93,0,1873,58),(11531,143,0,1873,172),(11532,97,0,1874,1),(11533,134,0,1874,2),(11534,115,0,1874,1),(11535,99,0,1874,4),(11536,144,0,1874,0),(11537,145,0,1874,0),(11538,146,0,1874,0),(11539,147,0,1874,0),(11540,148,0,1874,0),(11541,97,0,1875,1),(11542,134,0,1875,2),(11543,115,0,1875,1),(11544,99,0,1875,1),(11545,93,0,1875,49),(11546,143,0,1875,171),(11547,97,0,1876,1),(11548,134,0,1876,2),(11549,115,0,1876,1),(11550,99,0,1876,1),(11551,93,0,1876,50),(11552,143,0,1876,171),(11553,97,0,1877,1),(11554,134,0,1877,2),(11555,115,0,1877,1),(11556,99,0,1877,1),(11557,93,0,1877,57),(11558,143,0,1877,171),(11559,97,0,1878,1),(11560,134,0,1878,2),(11561,115,0,1878,1),(11562,99,0,1878,1),(11563,93,0,1878,49),(11564,143,0,1878,172),(11565,97,0,1879,1),(11566,134,0,1879,2),(11567,115,0,1879,1),(11568,99,0,1879,1),(11569,93,0,1879,50),(11570,143,0,1879,172),(11571,97,0,1880,1),(11572,134,0,1880,2),(11573,115,0,1880,1),(11574,99,0,1880,1),(11575,93,0,1880,57),(11576,143,0,1880,172),(11577,97,0,1881,1),(11578,134,0,1881,2),(11579,115,0,1881,1),(11580,99,0,1881,4),(11581,144,0,1881,0),(11582,145,0,1881,0),(11583,146,0,1881,0),(11584,147,0,1881,0),(11585,148,0,1881,0),(11586,97,0,1882,1),(11587,134,0,1882,2),(11588,115,0,1882,1),(11589,99,0,1882,1),(11590,93,0,1882,49),(11591,143,0,1882,171),(11592,97,0,1883,1),(11593,134,0,1883,2),(11594,115,0,1883,1),(11595,99,0,1883,1),(11596,93,0,1883,52),(11597,143,0,1883,171),(11598,97,0,1884,1),(11599,134,0,1884,2),(11600,115,0,1884,1),(11601,99,0,1884,1),(11602,93,0,1884,59),(11603,143,0,1884,171),(11604,97,0,1885,1),(11605,134,0,1885,2),(11606,115,0,1885,1),(11607,99,0,1885,1),(11608,93,0,1885,49),(11609,143,0,1885,172),(11610,97,0,1886,1),(11611,134,0,1886,2),(11612,115,0,1886,1),(11613,99,0,1886,1),(11614,93,0,1886,52),(11615,143,0,1886,172),(11616,97,0,1887,1),(11617,134,0,1887,2),(11618,115,0,1887,1),(11619,99,0,1887,1),(11620,93,0,1887,59),(11621,143,0,1887,172),(11622,97,0,1888,1),(11623,134,0,1888,2),(11624,115,0,1888,1),(11625,99,0,1888,4),(11626,144,0,1888,1),(11627,145,0,1888,0),(11628,146,0,1888,0),(11629,147,0,1888,0),(11630,148,0,1888,0),(11631,97,0,1889,1),(11632,134,0,1889,2),(11633,115,0,1889,1),(11634,99,0,1889,1),(11635,93,0,1889,50),(11636,143,0,1889,171),(11637,97,0,1890,1),(11638,134,0,1890,2),(11639,115,0,1890,1),(11640,99,0,1890,1),(11641,93,0,1890,53),(11642,143,0,1890,171),(11643,97,0,1891,1),(11644,134,0,1891,2),(11645,115,0,1891,1),(11646,99,0,1891,1),(11647,93,0,1891,58),(11648,143,0,1891,171),(11649,97,0,1892,1),(11650,134,0,1892,2),(11651,115,0,1892,1),(11652,99,0,1892,1),(11653,93,0,1892,50),(11654,143,0,1892,172),(11655,97,0,1893,1),(11656,134,0,1893,2),(11657,115,0,1893,1),(11658,99,0,1893,1),(11659,93,0,1893,53),(11660,143,0,1893,172),(11661,97,0,1894,1),(11662,134,0,1894,2),(11663,115,0,1894,1),(11664,99,0,1894,1),(11665,93,0,1894,58),(11666,143,0,1894,172),(11667,97,0,1895,1),(11668,134,0,1895,2),(11669,115,0,1895,1),(11670,99,0,1895,4),(11671,144,0,1895,0),(11672,145,0,1895,0),(11673,146,0,1895,0),(11674,147,0,1895,0),(11675,148,0,1895,0),(11676,97,0,1896,1),(11677,134,0,1896,2),(11678,115,0,1896,1),(11679,99,0,1896,1),(11680,93,0,1896,50),(11681,143,0,1896,171),(11682,97,0,1897,1),(11683,134,0,1897,2),(11684,115,0,1897,1),(11685,99,0,1897,1),(11686,93,0,1897,52),(11687,143,0,1897,171),(11688,97,0,1898,1),(11689,134,0,1898,2),(11690,115,0,1898,1),(11691,99,0,1898,1),(11692,93,0,1898,53),(11693,143,0,1898,171),(11694,97,0,1899,1),(11695,134,0,1899,2),(11696,115,0,1899,1),(11697,99,0,1899,1),(11698,93,0,1899,50),(11699,143,0,1899,172),(11700,97,0,1900,1),(11701,134,0,1900,2),(11702,115,0,1900,1),(11703,99,0,1900,1),(11704,93,0,1900,52),(11705,143,0,1900,172),(11706,97,0,1901,1),(11707,134,0,1901,2),(11708,115,0,1901,1),(11709,99,0,1901,1),(11710,93,0,1901,53),(11711,143,0,1901,172),(11712,97,0,1902,1),(11713,134,0,1902,2),(11714,115,0,1902,1),(11715,99,0,1902,4),(11716,144,0,1902,1),(11717,145,0,1902,1),(11718,146,0,1902,0),(11719,147,0,1902,0),(11720,148,0,1902,0),(11721,97,0,1903,1),(11722,134,0,1903,2),(11723,115,0,1903,1),(11724,99,0,1903,1),(11725,93,0,1903,50),(11726,143,0,1903,171),(11727,97,0,1904,1),(11728,134,0,1904,2),(11729,115,0,1904,1),(11730,99,0,1904,1),(11731,93,0,1904,53),(11732,143,0,1904,171),(11733,97,0,1905,1),(11734,134,0,1905,2),(11735,115,0,1905,1),(11736,99,0,1905,1),(11737,93,0,1905,56),(11738,143,0,1905,171),(11739,97,0,1906,1),(11740,134,0,1906,2),(11741,115,0,1906,1),(11742,99,0,1906,1),(11743,93,0,1906,50),(11744,143,0,1906,172),(11745,97,0,1907,1),(11746,134,0,1907,2),(11747,115,0,1907,1),(11748,99,0,1907,1),(11749,93,0,1907,53),(11750,143,0,1907,172),(11751,97,0,1908,1),(11752,134,0,1908,2),(11753,115,0,1908,1),(11754,99,0,1908,1),(11755,93,0,1908,56),(11756,143,0,1908,172),(11757,97,0,1909,1),(11758,134,0,1909,2),(11759,115,0,1909,1),(11760,99,0,1909,4),(11761,144,0,1909,1),(11762,145,0,1909,0),(11763,146,0,1909,1),(11764,147,0,1909,0),(11765,148,0,1909,0),(11766,97,0,1910,1),(11767,134,0,1910,2),(11768,115,0,1910,1),(11769,99,0,1910,1),(11770,93,0,1910,49),(11771,143,0,1910,171),(11772,97,0,1911,1),(11773,134,0,1911,2),(11774,115,0,1911,1),(11775,99,0,1911,1),(11776,93,0,1911,53),(11777,143,0,1911,171),(11778,97,0,1912,1),(11779,134,0,1912,2),(11780,115,0,1912,1),(11781,99,0,1912,1),(11782,93,0,1912,58),(11783,143,0,1912,171),(11784,97,0,1913,1),(11785,134,0,1913,2),(11786,115,0,1913,1),(11787,99,0,1913,1),(11788,93,0,1913,49),(11789,143,0,1913,172),(11790,97,0,1914,1),(11791,134,0,1914,2),(11792,115,0,1914,1),(11793,99,0,1914,1),(11794,93,0,1914,53),(11795,143,0,1914,172),(11796,97,0,1915,1),(11797,134,0,1915,2),(11798,115,0,1915,1),(11799,99,0,1915,1),(11800,93,0,1915,58),(11801,143,0,1915,172),(11802,97,0,1916,1),(11803,134,0,1916,2),(11804,115,0,1916,1),(11805,99,0,1916,1),(11806,93,0,1916,49),(11807,143,0,1916,173),(11808,97,0,1917,1),(11809,134,0,1917,2),(11810,115,0,1917,1),(11811,99,0,1917,1),(11812,93,0,1917,53),(11813,143,0,1917,173),(11814,97,0,1918,1),(11815,134,0,1918,2),(11816,115,0,1918,1),(11817,99,0,1918,1),(11818,93,0,1918,58),(11819,143,0,1918,173),(11820,97,0,1919,1),(11821,134,0,1919,2),(11822,115,0,1919,1),(11823,99,0,1919,1),(11824,93,0,1919,49),(11825,143,0,1919,174),(11826,97,0,1920,1),(11827,134,0,1920,2),(11828,115,0,1920,1),(11829,99,0,1920,1),(11830,93,0,1920,53),(11831,143,0,1920,174),(11832,97,0,1921,1),(11833,134,0,1921,2),(11834,115,0,1921,1),(11835,99,0,1921,1),(11836,93,0,1921,58),(11837,143,0,1921,174),(11838,97,0,1922,1),(11839,134,0,1922,2),(11840,115,0,1922,1),(11841,99,0,1922,1),(11842,93,0,1922,49),(11843,143,0,1922,175),(11844,97,0,1923,1),(11845,134,0,1923,2),(11846,115,0,1923,1),(11847,99,0,1923,1),(11848,93,0,1923,53),(11849,143,0,1923,175),(11850,97,0,1924,1),(11851,134,0,1924,2),(11852,115,0,1924,1),(11853,99,0,1924,1),(11854,93,0,1924,58),(11855,143,0,1924,175),(11856,97,0,1925,1),(11857,134,0,1925,2),(11858,115,0,1925,1),(11859,99,0,1925,4),(11860,144,0,1925,1),(11861,145,0,1925,0),(11862,146,0,1925,0),(11863,147,0,1925,1),(11864,148,0,1925,0),(11865,97,0,1926,1),(11866,134,0,1926,2),(11867,115,0,1926,1),(11868,99,0,1926,1),(11869,93,0,1926,52),(11870,143,0,1926,171),(11871,97,0,1927,1),(11872,134,0,1927,2),(11873,115,0,1927,1),(11874,99,0,1927,1),(11875,93,0,1927,56),(11876,143,0,1927,171),(11877,97,0,1928,1),(11878,134,0,1928,2),(11879,115,0,1928,1),(11880,99,0,1928,1),(11881,93,0,1928,60),(11882,143,0,1928,171),(11883,97,0,1929,1),(11884,134,0,1929,2),(11885,115,0,1929,1),(11886,99,0,1929,1),(11887,93,0,1929,52),(11888,143,0,1929,172),(11889,97,0,1930,1),(11890,134,0,1930,2),(11891,115,0,1930,1),(11892,99,0,1930,1),(11893,93,0,1930,56),(11894,143,0,1930,172),(11895,97,0,1931,1),(11896,134,0,1931,2),(11897,115,0,1931,1),(11898,99,0,1931,1),(11899,93,0,1931,60),(11900,143,0,1931,172),(11901,97,0,1932,1),(11902,134,0,1932,2),(11903,115,0,1932,1),(11904,99,0,1932,1),(11905,93,0,1932,52),(11906,143,0,1932,173),(11907,97,0,1933,1),(11908,134,0,1933,2),(11909,115,0,1933,1),(11910,99,0,1933,1),(11911,93,0,1933,56),(11912,143,0,1933,173),(11913,97,0,1934,1),(11914,134,0,1934,2),(11915,115,0,1934,1),(11916,99,0,1934,1),(11917,93,0,1934,60),(11918,143,0,1934,173),(11919,97,0,1935,1),(11920,134,0,1935,2),(11921,115,0,1935,1),(11922,99,0,1935,1),(11923,93,0,1935,52),(11924,143,0,1935,174),(11925,97,0,1936,1),(11926,134,0,1936,2),(11927,115,0,1936,1),(11928,99,0,1936,1),(11929,93,0,1936,56),(11930,143,0,1936,174),(11931,97,0,1937,1),(11932,134,0,1937,2),(11933,115,0,1937,1),(11934,99,0,1937,1),(11935,93,0,1937,60),(11936,143,0,1937,174),(11937,97,0,1938,1),(11938,134,0,1938,2),(11939,115,0,1938,1),(11940,99,0,1938,1),(11941,93,0,1938,52),(11942,143,0,1938,175),(11943,97,0,1939,1),(11944,134,0,1939,2),(11945,115,0,1939,1),(11946,99,0,1939,1),(11947,93,0,1939,56),(11948,143,0,1939,175),(11949,97,0,1940,1),(11950,134,0,1940,2),(11951,115,0,1940,1),(11952,99,0,1940,1),(11953,93,0,1940,60),(11954,143,0,1940,175),(11955,97,0,1941,1),(11956,134,0,1941,2),(11957,115,0,1941,1),(11958,99,0,1941,4),(11959,144,0,1941,0),(11960,145,0,1941,0),(11961,146,0,1941,0),(11962,147,0,1941,0),(11963,148,0,1941,1),(11964,97,0,1942,1),(11965,134,0,1942,2),(11966,115,0,1942,1),(11967,99,0,1942,1),(11968,93,0,1942,50),(11969,143,0,1942,171),(11970,97,0,1943,1),(11971,134,0,1943,2),(11972,115,0,1943,1),(11973,99,0,1943,1),(11974,93,0,1943,52),(11975,143,0,1943,171),(11976,97,0,1944,1),(11977,134,0,1944,2),(11978,115,0,1944,1),(11979,99,0,1944,1),(11980,93,0,1944,56),(11981,143,0,1944,171),(11982,97,0,1945,1),(11983,134,0,1945,2),(11984,115,0,1945,1),(11985,99,0,1945,1),(11986,93,0,1945,50),(11987,143,0,1945,172),(11988,97,0,1946,1),(11989,134,0,1946,2),(11990,115,0,1946,1),(11991,99,0,1946,1),(11992,93,0,1946,52),(11993,143,0,1946,172),(11994,97,0,1947,1),(11995,134,0,1947,2),(11996,115,0,1947,1),(11997,99,0,1947,1),(11998,93,0,1947,56),(11999,143,0,1947,172),(12000,97,0,1948,1),(12001,134,0,1948,2),(12002,115,0,1948,1),(12003,99,0,1948,1),(12004,93,0,1948,50),(12005,143,0,1948,173),(12006,97,0,1949,1),(12007,134,0,1949,2),(12008,115,0,1949,1),(12009,99,0,1949,1),(12010,93,0,1949,52),(12011,143,0,1949,173),(12012,97,0,1950,1),(12013,134,0,1950,2),(12014,115,0,1950,1),(12015,99,0,1950,1),(12016,93,0,1950,56),(12017,143,0,1950,173),(12018,97,0,1951,1),(12019,134,0,1951,2),(12020,115,0,1951,1),(12021,99,0,1951,1),(12022,93,0,1951,50),(12023,143,0,1951,174),(12024,97,0,1952,1),(12025,134,0,1952,2),(12026,115,0,1952,1),(12027,99,0,1952,1),(12028,93,0,1952,52),(12029,143,0,1952,174),(12030,97,0,1953,1),(12031,134,0,1953,2),(12032,115,0,1953,1),(12033,99,0,1953,1),(12034,93,0,1953,56),(12035,143,0,1953,174),(12036,97,0,1954,1),(12037,134,0,1954,2),(12038,115,0,1954,1),(12039,99,0,1954,1),(12040,93,0,1954,50),(12041,143,0,1954,175),(12042,97,0,1955,1),(12043,134,0,1955,2),(12044,115,0,1955,1),(12045,99,0,1955,1),(12046,93,0,1955,52),(12047,143,0,1955,175),(12048,97,0,1956,1),(12049,134,0,1956,2),(12050,115,0,1956,1),(12051,99,0,1956,1),(12052,93,0,1956,56),(12053,143,0,1956,175),(12054,97,0,1957,1),(12055,134,0,1957,2),(12056,115,0,1957,1),(12057,99,0,1957,4),(12058,144,0,1957,1),(12059,145,0,1957,1),(12060,146,0,1957,0),(12061,147,0,1957,1),(12062,148,0,1957,0),(12063,97,0,1958,1),(12064,134,0,1958,2),(12065,115,0,1958,1),(12066,99,0,1958,1),(12067,93,0,1958,49),(12068,143,0,1958,171),(12069,97,0,1959,1),(12070,134,0,1959,2),(12071,115,0,1959,1),(12072,99,0,1959,1),(12073,93,0,1959,53),(12074,143,0,1959,171),(12075,97,0,1960,1),(12076,134,0,1960,2),(12077,115,0,1960,1),(12078,99,0,1960,1),(12079,93,0,1960,56),(12080,143,0,1960,171),(12081,97,0,1961,1),(12082,134,0,1961,2),(12083,115,0,1961,1),(12084,99,0,1961,1),(12085,93,0,1961,49),(12086,143,0,1961,172),(12087,97,0,1962,1),(12088,134,0,1962,2),(12089,115,0,1962,1),(12090,99,0,1962,1),(12091,93,0,1962,53),(12092,143,0,1962,172),(12093,97,0,1963,1),(12094,134,0,1963,2),(12095,115,0,1963,1),(12096,99,0,1963,1),(12097,93,0,1963,56),(12098,143,0,1963,172),(12099,97,0,1964,1),(12100,134,0,1964,2),(12101,115,0,1964,1),(12102,99,0,1964,1),(12103,93,0,1964,49),(12104,143,0,1964,173),(12105,97,0,1965,1),(12106,134,0,1965,2),(12107,115,0,1965,1),(12108,99,0,1965,1),(12109,93,0,1965,53),(12110,143,0,1965,173),(12111,97,0,1966,1),(12112,134,0,1966,2),(12113,115,0,1966,1),(12114,99,0,1966,1),(12115,93,0,1966,56),(12116,143,0,1966,173),(12117,97,0,1967,1),(12118,134,0,1967,2),(12119,115,0,1967,1),(12120,99,0,1967,1),(12121,93,0,1967,49),(12122,143,0,1967,174),(12123,97,0,1968,1),(12124,134,0,1968,2),(12125,115,0,1968,1),(12126,99,0,1968,1),(12127,93,0,1968,53),(12128,143,0,1968,174),(12129,97,0,1969,1),(12130,134,0,1969,2),(12131,115,0,1969,1),(12132,99,0,1969,1),(12133,93,0,1969,56),(12134,143,0,1969,174),(12135,97,0,1970,1),(12136,134,0,1970,2),(12137,115,0,1970,1),(12138,99,0,1970,1),(12139,93,0,1970,49),(12140,143,0,1970,175),(12141,97,0,1971,1),(12142,134,0,1971,2),(12143,115,0,1971,1),(12144,99,0,1971,1),(12145,93,0,1971,53),(12146,143,0,1971,175),(12147,97,0,1972,1),(12148,134,0,1972,2),(12149,115,0,1972,1),(12150,99,0,1972,1),(12151,93,0,1972,56),(12152,143,0,1972,175),(12153,97,0,1973,1),(12154,134,0,1973,2),(12155,115,0,1973,1),(12156,99,0,1973,4),(12157,144,0,1973,0),(12158,145,0,1973,0),(12159,146,0,1973,0),(12160,147,0,1973,0),(12161,148,0,1973,0),(12162,97,0,1974,1),(12163,134,0,1974,2),(12164,115,0,1974,1),(12165,99,0,1974,1),(12166,93,0,1974,50),(12167,143,0,1974,171),(12168,97,0,1975,1),(12169,134,0,1975,2),(12170,115,0,1975,1),(12171,99,0,1975,1),(12172,93,0,1975,57),(12173,143,0,1975,171),(12174,97,0,1976,1),(12175,134,0,1976,2),(12176,115,0,1976,1),(12177,99,0,1976,1),(12178,93,0,1976,60),(12179,143,0,1976,171),(12180,97,0,1977,1),(12181,134,0,1977,2),(12182,115,0,1977,1),(12183,99,0,1977,1),(12184,93,0,1977,50),(12185,143,0,1977,172),(12186,97,0,1978,1),(12187,134,0,1978,2),(12188,115,0,1978,1),(12189,99,0,1978,1),(12190,93,0,1978,57),(12191,143,0,1978,172),(12192,97,0,1979,1),(12193,134,0,1979,2),(12194,115,0,1979,1),(12195,99,0,1979,1),(12196,93,0,1979,60),(12197,143,0,1979,172),(12198,97,0,1980,1),(12199,134,0,1980,2),(12200,115,0,1980,1),(12201,99,0,1980,1),(12202,93,0,1980,50),(12203,143,0,1980,173),(12204,97,0,1981,1),(12205,134,0,1981,2),(12206,115,0,1981,1),(12207,99,0,1981,1),(12208,93,0,1981,57),(12209,143,0,1981,173),(12210,97,0,1982,1),(12211,134,0,1982,2),(12212,115,0,1982,1),(12213,99,0,1982,1),(12214,93,0,1982,60),(12215,143,0,1982,173),(12216,97,0,1983,1),(12217,134,0,1983,2),(12218,115,0,1983,1),(12219,99,0,1983,1),(12220,93,0,1983,50),(12221,143,0,1983,174),(12222,97,0,1984,1),(12223,134,0,1984,2),(12224,115,0,1984,1),(12225,99,0,1984,1),(12226,93,0,1984,57),(12227,143,0,1984,174),(12228,97,0,1985,1),(12229,134,0,1985,2),(12230,115,0,1985,1),(12231,99,0,1985,1),(12232,93,0,1985,60),(12233,143,0,1985,174),(12234,97,0,1986,1),(12235,134,0,1986,2),(12236,115,0,1986,1),(12237,99,0,1986,1),(12238,93,0,1986,50),(12239,143,0,1986,175),(12240,97,0,1987,1),(12241,134,0,1987,2),(12242,115,0,1987,1),(12243,99,0,1987,1),(12244,93,0,1987,57),(12245,143,0,1987,175),(12246,97,0,1988,1),(12247,134,0,1988,2),(12248,115,0,1988,1),(12249,99,0,1988,1),(12250,93,0,1988,60),(12251,143,0,1988,175),(12252,97,0,1989,1),(12253,134,0,1989,2),(12254,115,0,1989,1),(12255,99,0,1989,4),(12256,144,0,1989,0),(12257,145,0,1989,0),(12258,146,0,1989,0),(12259,147,0,1989,0),(12260,148,0,1989,1),(12261,97,0,1990,1),(12262,134,0,1990,2),(12263,115,0,1990,1),(12264,99,0,1990,1),(12265,93,0,1990,52),(12266,143,0,1990,171),(12267,97,0,1991,1),(12268,134,0,1991,2),(12269,115,0,1991,1),(12270,99,0,1991,1),(12271,93,0,1991,56),(12272,143,0,1991,171),(12273,97,0,1992,1),(12274,134,0,1992,2),(12275,115,0,1992,1),(12276,99,0,1992,1),(12277,93,0,1992,57),(12278,143,0,1992,171),(12279,97,0,1993,1),(12280,134,0,1993,2),(12281,115,0,1993,1),(12282,99,0,1993,1),(12283,93,0,1993,52),(12284,143,0,1993,172),(12285,97,0,1994,1),(12286,134,0,1994,2),(12287,115,0,1994,1),(12288,99,0,1994,1),(12289,93,0,1994,56),(12290,143,0,1994,172),(12291,97,0,1995,1),(12292,134,0,1995,2),(12293,115,0,1995,1),(12294,99,0,1995,1),(12295,93,0,1995,57),(12296,143,0,1995,172),(12297,97,0,1996,1),(12298,134,0,1996,2),(12299,115,0,1996,1),(12300,99,0,1996,4),(12301,144,0,1996,0),(12302,145,0,1996,0),(12303,146,0,1996,0),(12304,147,0,1996,0),(12305,148,0,1996,0),(12306,97,0,1997,1),(12307,134,0,1997,2),(12308,115,0,1997,1),(12309,99,0,1997,1),(12310,93,0,1997,49),(12311,143,0,1997,171),(12312,97,0,1998,1),(12313,134,0,1998,2),(12314,115,0,1998,1),(12315,99,0,1998,1),(12316,93,0,1998,50),(12317,143,0,1998,171),(12318,97,0,1999,1),(12319,134,0,1999,2),(12320,115,0,1999,1),(12321,99,0,1999,1),(12322,93,0,1999,57),(12323,143,0,1999,171),(12324,97,0,2000,1),(12325,134,0,2000,2),(12326,115,0,2000,1),(12327,99,0,2000,1),(12328,93,0,2000,49),(12329,143,0,2000,172),(12330,97,0,2001,1),(12331,134,0,2001,2),(12332,115,0,2001,1),(12333,99,0,2001,1),(12334,93,0,2001,50),(12335,143,0,2001,172),(12336,97,0,2002,1),(12337,134,0,2002,2),(12338,115,0,2002,1),(12339,99,0,2002,1),(12340,93,0,2002,57),(12341,143,0,2002,172),(12342,97,0,2003,1),(12343,134,0,2003,2),(12344,115,0,2003,1),(12345,99,0,2003,4),(12346,144,0,2003,0),(12347,145,0,2003,0),(12348,146,0,2003,0),(12349,147,0,2003,1),(12350,148,0,2003,0),(12351,97,0,2004,1),(12352,134,0,2004,2),(12353,115,0,2004,1),(12354,99,0,2004,1),(12355,93,0,2004,57),(12356,143,0,2004,171),(12357,97,0,2005,1),(12358,134,0,2005,2),(12359,115,0,2005,1),(12360,99,0,2005,1),(12361,93,0,2005,57),(12362,143,0,2005,172),(12363,97,0,2006,1),(12364,134,0,2006,2),(12365,115,0,2006,1),(12366,99,0,2006,1),(12367,93,0,2006,57),(12368,143,0,2006,173),(12369,97,0,2007,1),(12370,134,0,2007,2),(12371,115,0,2007,1),(12372,99,0,2007,1),(12373,93,0,2007,57),(12374,143,0,2007,174),(12375,97,0,2008,1),(12376,134,0,2008,2),(12377,115,0,2008,1),(12378,99,0,2008,1),(12379,93,0,2008,57),(12380,143,0,2008,175),(12381,97,0,2009,1),(12382,134,0,2009,2),(12383,115,0,2009,1),(12384,99,0,2009,4),(12385,144,0,2009,0),(12386,145,0,2009,1),(12387,146,0,2009,0),(12388,147,0,2009,0),(12389,148,0,2009,0),(12390,97,0,2010,1),(12391,134,0,2010,2),(12392,115,0,2010,1),(12393,99,0,2010,1),(12394,93,0,2010,52),(12395,143,0,2010,171),(12396,97,0,2011,1),(12397,134,0,2011,2),(12398,115,0,2011,1),(12399,99,0,2011,1),(12400,93,0,2011,53),(12401,143,0,2011,171),(12402,97,0,2012,1),(12403,134,0,2012,2),(12404,115,0,2012,1),(12405,99,0,2012,1),(12406,93,0,2012,59),(12407,143,0,2012,171),(12408,97,0,2013,1),(12409,134,0,2013,2),(12410,115,0,2013,1),(12411,99,0,2013,1),(12412,93,0,2013,52),(12413,143,0,2013,172),(12414,97,0,2014,1),(12415,134,0,2014,2),(12416,115,0,2014,1),(12417,99,0,2014,1),(12418,93,0,2014,53),(12419,143,0,2014,172),(12420,97,0,2015,1),(12421,134,0,2015,2),(12422,115,0,2015,1),(12423,99,0,2015,1),(12424,93,0,2015,59),(12425,143,0,2015,172),(12426,97,0,2016,1),(12427,134,0,2016,2),(12428,115,0,2016,1),(12429,99,0,2016,4),(12430,144,0,2016,0),(12431,145,0,2016,0),(12432,146,0,2016,0),(12433,147,0,2016,0),(12434,148,0,2016,0),(12435,97,0,2017,1),(12436,134,0,2017,2),(12437,115,0,2017,1),(12438,99,0,2017,1),(12439,93,0,2017,49),(12440,143,0,2017,171),(12441,97,0,2018,1),(12442,134,0,2018,2),(12443,115,0,2018,1),(12444,99,0,2018,1),(12445,93,0,2018,56),(12446,143,0,2018,171),(12447,97,0,2019,1),(12448,134,0,2019,2),(12449,115,0,2019,1),(12450,99,0,2019,1),(12451,93,0,2019,59),(12452,143,0,2019,171),(12453,97,0,2020,1),(12454,134,0,2020,2),(12455,115,0,2020,1),(12456,99,0,2020,1),(12457,93,0,2020,49),(12458,143,0,2020,172),(12459,97,0,2021,1),(12460,134,0,2021,2),(12461,115,0,2021,1),(12462,99,0,2021,1),(12463,93,0,2021,56),(12464,143,0,2021,172),(12465,97,0,2022,1),(12466,134,0,2022,2),(12467,115,0,2022,1),(12468,99,0,2022,1),(12469,93,0,2022,59),(12470,143,0,2022,172),(12471,97,0,2023,1),(12472,134,0,2023,2),(12473,115,0,2023,1),(12474,99,0,2023,4),(12475,144,0,2023,1),(12476,145,0,2023,0),(12477,146,0,2023,0),(12478,147,0,2023,0),(12479,148,0,2023,0),(12480,97,0,2024,1),(12481,134,0,2024,2),(12482,115,0,2024,1),(12483,99,0,2024,1),(12484,93,0,2024,50),(12485,143,0,2024,171),(12486,97,0,2025,1),(12487,134,0,2025,2),(12488,115,0,2025,1),(12489,99,0,2025,1),(12490,93,0,2025,56),(12491,143,0,2025,171),(12492,97,0,2026,1),(12493,134,0,2026,2),(12494,115,0,2026,1),(12495,99,0,2026,1),(12496,93,0,2026,58),(12497,143,0,2026,171),(12498,97,0,2027,1),(12499,134,0,2027,2),(12500,115,0,2027,1),(12501,99,0,2027,1),(12502,93,0,2027,50),(12503,143,0,2027,172),(12504,97,0,2028,1),(12505,134,0,2028,2),(12506,115,0,2028,1),(12507,99,0,2028,1),(12508,93,0,2028,56),(12509,143,0,2028,172),(12510,97,0,2029,1),(12511,134,0,2029,2),(12512,115,0,2029,1),(12513,99,0,2029,1),(12514,93,0,2029,58),(12515,143,0,2029,172),(12516,97,0,2030,1),(12517,134,0,2030,2),(12518,115,0,2030,1),(12519,99,0,2030,4),(12520,144,0,2030,0),(12521,145,0,2030,1),(12522,146,0,2030,1),(12523,147,0,2030,0),(12524,148,0,2030,0),(12525,97,0,2031,1),(12526,134,0,2031,2),(12527,115,0,2031,1),(12528,99,0,2031,1),(12529,93,0,2031,53),(12530,143,0,2031,171),(12531,97,0,2032,1),(12532,134,0,2032,2),(12533,115,0,2032,1),(12534,99,0,2032,1),(12535,93,0,2032,57),(12536,143,0,2032,171),(12537,97,0,2033,1),(12538,134,0,2033,2),(12539,115,0,2033,1),(12540,99,0,2033,1),(12541,93,0,2033,58),(12542,143,0,2033,171),(12543,97,0,2034,1),(12544,134,0,2034,2),(12545,115,0,2034,1),(12546,99,0,2034,1),(12547,93,0,2034,53),(12548,143,0,2034,172),(12549,97,0,2035,1),(12550,134,0,2035,2),(12551,115,0,2035,1),(12552,99,0,2035,1),(12553,93,0,2035,57),(12554,143,0,2035,172),(12555,97,0,2036,1),(12556,134,0,2036,2),(12557,115,0,2036,1),(12558,99,0,2036,1),(12559,93,0,2036,58),(12560,143,0,2036,172),(12561,97,0,2037,1),(12562,134,0,2037,2),(12563,115,0,2037,1),(12564,99,0,2037,1),(12565,93,0,2037,53),(12566,143,0,2037,173),(12567,97,0,2038,1),(12568,134,0,2038,2),(12569,115,0,2038,1),(12570,99,0,2038,1),(12571,93,0,2038,57),(12572,143,0,2038,173),(12573,97,0,2039,1),(12574,134,0,2039,2),(12575,115,0,2039,1),(12576,99,0,2039,1),(12577,93,0,2039,58),(12578,143,0,2039,173),(12579,97,0,2040,1),(12580,134,0,2040,2),(12581,115,0,2040,1),(12582,99,0,2040,1),(12583,93,0,2040,53),(12584,143,0,2040,174),(12585,97,0,2041,1),(12586,134,0,2041,2),(12587,115,0,2041,1),(12588,99,0,2041,1),(12589,93,0,2041,57),(12590,143,0,2041,174),(12591,97,0,2042,1),(12592,134,0,2042,2),(12593,115,0,2042,1),(12594,99,0,2042,1),(12595,93,0,2042,58),(12596,143,0,2042,174),(12597,97,0,2043,1),(12598,134,0,2043,2),(12599,115,0,2043,1),(12600,99,0,2043,1),(12601,93,0,2043,53),(12602,143,0,2043,175),(12603,97,0,2044,1),(12604,134,0,2044,2),(12605,115,0,2044,1),(12606,99,0,2044,1),(12607,93,0,2044,57),(12608,143,0,2044,175),(12609,97,0,2045,1),(12610,134,0,2045,2),(12611,115,0,2045,1),(12612,99,0,2045,1),(12613,93,0,2045,58),(12614,143,0,2045,175),(12615,97,0,2046,1),(12616,134,0,2046,2),(12617,115,0,2046,1),(12618,99,0,2046,4),(12619,144,0,2046,0),(12620,145,0,2046,0),(12621,146,0,2046,1),(12622,147,0,2046,0),(12623,148,0,2046,0),(12624,97,1,1226,1),(12625,99,1,1226,4),(12626,134,1,1226,2),(12627,97,1,1242,1),(12628,99,1,1242,4),(12629,134,1,1242,2),(12630,97,1,1258,1),(12631,99,1,1258,4),(12632,134,1,1258,2),(12633,97,1,1274,1),(12634,99,1,1274,4),(12635,134,1,1274,2),(12636,97,1,1290,1),(12637,99,1,1290,4),(12638,134,1,1290,2),(12639,97,1,1386,1),(12640,99,1,1386,4),(12641,134,1,1386,2),(12642,97,1,1306,1),(12643,99,1,1306,4),(12644,134,1,1306,2),(12645,97,1,1322,1),(12646,99,1,1322,4),(12647,134,1,1322,2),(12648,97,1,1338,1),(12649,99,1,1338,4),(12650,134,1,1338,2),(12651,97,1,1354,1),(12652,99,1,1354,4),(12653,134,1,1354,2),(12654,97,1,1370,1),(12655,99,1,1370,4),(12656,134,1,1370,2),(12657,97,1,1402,1),(12658,99,1,1402,4),(12659,134,1,1402,2);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_media_gallery`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_media_gallery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_media_gallery` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  `media_type` varchar(32) NOT NULL DEFAULT 'image' COMMENT 'Media entry type',
  `disabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Visibility status',
  PRIMARY KEY (`value_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3423 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Media Gallery Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_media_gallery`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_media_gallery` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_media_gallery` VALUES (1,90,'/m/b/mb01-blue-0.jpg','image',0),(2,90,'/m/b/mb04-black-0.jpg','image',0),(3,90,'/m/b/mb04-black-0_alt1.jpg','image',0),(4,90,'/m/b/mb03-black-0.jpg','image',0),(5,90,'/m/b/mb03-black-0_alt1.jpg','image',0),(6,90,'/m/b/mb05-black-0.jpg','image',0),(7,90,'/m/b/mb06-gray-0.jpg','image',0),(8,90,'/m/b/mb02-gray-0.jpg','image',0),(9,90,'/m/b/mb02-blue-0.jpg','image',0),(10,90,'/u/b/ub02-black-0.jpg','image',0),(11,90,'/w/b/wb01-black-0.jpg','image',0),(12,90,'/w/b/wb02-green-0.jpg','image',0),(13,90,'/w/b/wb05-red-0.jpg','image',0),(14,90,'/w/b/wb06-red-0.jpg','image',0),(15,90,'/w/b/wb06-red-0_alt1.jpg','image',0),(16,90,'/w/b/wb03-purple-0.jpg','image',0),(17,90,'/w/b/wb07-brown-0.jpg','image',0),(18,90,'/w/b/wb04-blue-0.jpg','image',0),(19,90,'/u/g/ug06-lb-0.jpg','image',0),(20,90,'/u/g/ug07-bk-0.jpg','image',0),(21,90,'/u/g/ug07-bk-0_alt1.jpg','image',0),(22,90,'/u/g/ug04-bk-0.jpg','image',0),(23,90,'/u/g/ug02-bk-0.jpg','image',0),(24,90,'/u/g/ug05-gr-0.jpg','image',0),(25,90,'/u/g/ug01-bk-0.jpg','image',0),(26,90,'/l/u/luma-yoga-brick.jpg','image',0),(27,90,'/l/u/luma-foam-roller.jpg','image',0),(28,90,'/u/g/ug03-bk-0.jpg','image',0),(29,90,'/l/u/luma-stability-ball-gray.jpg','image',0),(30,90,'/l/u/luma-stability-ball-pink.jpg','image',0),(31,90,'/l/u/luma-stability-ball.jpg','image',0),(32,90,'/l/u/luma-stability-ball-gray.jpg','image',0),(33,90,'/l/u/luma-stability-ball-pink.jpg','image',0),(34,90,'/l/u/luma-stability-ball.jpg','image',0),(35,90,'/l/u/luma-stability-ball-gray.jpg','image',0),(36,90,'/l/u/luma-stability-ball-pink.jpg','image',0),(37,90,'/l/u/luma-stability-ball.jpg','image',0),(38,90,'/l/u/luma-yoga-strap.jpg','image',0),(39,90,'/l/u/luma-yoga-strap.jpg','image',0),(40,90,'/l/u/luma-yoga-strap.jpg','image',0),(41,90,'/m/g/mg04-bk-0.jpg','image',0),(42,90,'/m/g/mg01-bk-0.jpg','image',0),(43,90,'/m/g/mg03-br-0.jpg','image',0),(44,90,'/m/g/mg05-br-0.jpg','image',0),(45,90,'/m/g/mg02-bk-0.jpg','image',0),(46,90,'/w/g/wg09-gr-0.jpg','image',0),(47,90,'/w/g/wg01-bk-0.jpg','image',0),(48,90,'/w/g/wg03-gr-0.jpg','image',0),(49,90,'/w/g/wg03-sa-0.jpg','image',0),(50,90,'/w/g/wg02-bk-0.jpg','image',0),(51,90,'/l/u/luma-yoga-strap-set.jpg','image',0),(52,90,'/l/u/luma-yoga-kit-2.jpg','image',0),(53,90,'/l/t/lt01.jpg','image',0),(54,90,'/l/t/lt02.jpg','image',0),(55,90,'/l/t/lt03.jpg','image',0),(56,90,'/l/t/lt04.jpg','image',0),(57,90,'/l/t/lt05.jpg','image',0),(58,90,'/l/t/lt06.jpg','image',0),(59,90,'/m/h/mh01-black_main_1.jpg','image',0),(60,90,'/m/h/mh01-gray_main_1.jpg','image',0),(61,90,'/m/h/mh01-gray_alt1_1.jpg','image',0),(62,90,'/m/h/mh01-gray_back_1.jpg','image',0),(63,90,'/m/h/mh01-orange_main_1.jpg','image',0),(64,90,'/m/h/mh01-black_main_1.jpg','image',0),(65,90,'/m/h/mh01-gray_main_1.jpg','image',0),(66,90,'/m/h/mh01-gray_alt1_1.jpg','image',0),(67,90,'/m/h/mh01-gray_back_1.jpg','image',0),(68,90,'/m/h/mh01-orange_main_1.jpg','image',0),(69,90,'/m/h/mh01-black_main_1.jpg','image',0),(70,90,'/m/h/mh01-gray_main_1.jpg','image',0),(71,90,'/m/h/mh01-gray_alt1_1.jpg','image',0),(72,90,'/m/h/mh01-gray_back_1.jpg','image',0),(73,90,'/m/h/mh01-orange_main_1.jpg','image',0),(74,90,'/m/h/mh01-black_main_1.jpg','image',0),(75,90,'/m/h/mh01-gray_main_1.jpg','image',0),(76,90,'/m/h/mh01-gray_alt1_1.jpg','image',0),(77,90,'/m/h/mh01-gray_back_1.jpg','image',0),(78,90,'/m/h/mh01-orange_main_1.jpg','image',0),(79,90,'/m/h/mh01-black_main_1.jpg','image',0),(80,90,'/m/h/mh01-gray_main_1.jpg','image',0),(81,90,'/m/h/mh01-gray_alt1_1.jpg','image',0),(82,90,'/m/h/mh01-gray_back_1.jpg','image',0),(83,90,'/m/h/mh01-orange_main_1.jpg','image',0),(84,90,'/m/h/mh01-gray_main_1.jpg','image',0),(85,90,'/m/h/mh01-gray_alt1_1.jpg','image',0),(86,90,'/m/h/mh01-gray_back_1.jpg','image',0),(87,90,'/m/h/mh02-black_main_1.jpg','image',0),(88,90,'/m/h/mh02-black_alt1_1.jpg','image',0),(89,90,'/m/h/mh02-black_back_1.jpg','image',0),(90,90,'/m/h/mh02-purple_main_1.jpg','image',0),(91,90,'/m/h/mh02-red_main_1.jpg','image',0),(92,90,'/m/h/mh02-black_main_1.jpg','image',0),(93,90,'/m/h/mh02-black_alt1_1.jpg','image',0),(94,90,'/m/h/mh02-black_back_1.jpg','image',0),(95,90,'/m/h/mh02-purple_main_1.jpg','image',0),(96,90,'/m/h/mh02-red_main_1.jpg','image',0),(97,90,'/m/h/mh02-black_main_1.jpg','image',0),(98,90,'/m/h/mh02-black_alt1_1.jpg','image',0),(99,90,'/m/h/mh02-black_back_1.jpg','image',0),(100,90,'/m/h/mh02-purple_main_1.jpg','image',0),(101,90,'/m/h/mh02-red_main_1.jpg','image',0),(102,90,'/m/h/mh02-black_main_1.jpg','image',0),(103,90,'/m/h/mh02-black_alt1_1.jpg','image',0),(104,90,'/m/h/mh02-black_back_1.jpg','image',0),(105,90,'/m/h/mh02-purple_main_1.jpg','image',0),(106,90,'/m/h/mh02-red_main_1.jpg','image',0),(107,90,'/m/h/mh02-black_main_1.jpg','image',0),(108,90,'/m/h/mh02-black_alt1_1.jpg','image',0),(109,90,'/m/h/mh02-black_back_1.jpg','image',0),(110,90,'/m/h/mh02-purple_main_1.jpg','image',0),(111,90,'/m/h/mh02-red_main_1.jpg','image',0),(112,90,'/m/h/mh02-black_main_1.jpg','image',0),(113,90,'/m/h/mh02-black_alt1_1.jpg','image',0),(114,90,'/m/h/mh02-black_back_1.jpg','image',0),(115,90,'/m/h/mh03-black_main_1.jpg','image',0),(116,90,'/m/h/mh03-black_alt1_1.jpg','image',0),(117,90,'/m/h/mh03-black_back_1.jpg','image',0),(118,90,'/m/h/mh03-blue_main_1.jpg','image',0),(119,90,'/m/h/mh03-green_main_1.jpg','image',0),(120,90,'/m/h/mh03-black_main_1.jpg','image',0),(121,90,'/m/h/mh03-black_alt1_1.jpg','image',0),(122,90,'/m/h/mh03-black_back_1.jpg','image',0),(123,90,'/m/h/mh03-blue_main_1.jpg','image',0),(124,90,'/m/h/mh03-green_main_1.jpg','image',0),(125,90,'/m/h/mh03-black_main_1.jpg','image',0),(126,90,'/m/h/mh03-black_alt1_1.jpg','image',0),(127,90,'/m/h/mh03-black_back_1.jpg','image',0),(128,90,'/m/h/mh03-blue_main_1.jpg','image',0),(129,90,'/m/h/mh03-green_main_1.jpg','image',0),(130,90,'/m/h/mh03-black_main_1.jpg','image',0),(131,90,'/m/h/mh03-black_alt1_1.jpg','image',0),(132,90,'/m/h/mh03-black_back_1.jpg','image',0),(133,90,'/m/h/mh03-blue_main_1.jpg','image',0),(134,90,'/m/h/mh03-green_main_1.jpg','image',0),(135,90,'/m/h/mh03-black_main_1.jpg','image',0),(136,90,'/m/h/mh03-black_alt1_1.jpg','image',0),(137,90,'/m/h/mh03-black_back_1.jpg','image',0),(138,90,'/m/h/mh03-blue_main_1.jpg','image',0),(139,90,'/m/h/mh03-green_main_1.jpg','image',0),(140,90,'/m/h/mh03-black_main_1.jpg','image',0),(141,90,'/m/h/mh03-black_alt1_1.jpg','image',0),(142,90,'/m/h/mh03-black_back_1.jpg','image',0),(143,90,'/m/h/mh04-green_main_1.jpg','image',0),(144,90,'/m/h/mh04-green_alt1_1.jpg','image',0),(145,90,'/m/h/mh04-green_back_1.jpg','image',0),(146,90,'/m/h/mh04-white_main_1.jpg','image',0),(147,90,'/m/h/mh04-yellow_main_1.jpg','image',0),(148,90,'/m/h/mh04-green_main_1.jpg','image',0),(149,90,'/m/h/mh04-green_alt1_1.jpg','image',0),(150,90,'/m/h/mh04-green_back_1.jpg','image',0),(151,90,'/m/h/mh04-white_main_1.jpg','image',0),(152,90,'/m/h/mh04-yellow_main_1.jpg','image',0),(153,90,'/m/h/mh04-green_main_1.jpg','image',0),(154,90,'/m/h/mh04-green_alt1_1.jpg','image',0),(155,90,'/m/h/mh04-green_back_1.jpg','image',0),(156,90,'/m/h/mh04-white_main_1.jpg','image',0),(157,90,'/m/h/mh04-yellow_main_1.jpg','image',0),(158,90,'/m/h/mh04-green_main_1.jpg','image',0),(159,90,'/m/h/mh04-green_alt1_1.jpg','image',0),(160,90,'/m/h/mh04-green_back_1.jpg','image',0),(161,90,'/m/h/mh04-white_main_1.jpg','image',0),(162,90,'/m/h/mh04-yellow_main_1.jpg','image',0),(163,90,'/m/h/mh04-green_main_1.jpg','image',0),(164,90,'/m/h/mh04-green_alt1_1.jpg','image',0),(165,90,'/m/h/mh04-green_back_1.jpg','image',0),(166,90,'/m/h/mh04-white_main_1.jpg','image',0),(167,90,'/m/h/mh04-yellow_main_1.jpg','image',0),(168,90,'/m/h/mh04-green_main_1.jpg','image',0),(169,90,'/m/h/mh04-green_alt1_1.jpg','image',0),(170,90,'/m/h/mh04-green_back_1.jpg','image',0),(171,90,'/m/h/mh05-green_main_1.jpg','image',0),(172,90,'/m/h/mh05-red_main_1.jpg','image',0),(173,90,'/m/h/mh05-white_main_1.jpg','image',0),(174,90,'/m/h/mh05-white_alt1_1.jpg','image',0),(175,90,'/m/h/mh05-white_back_1.jpg','image',0),(176,90,'/m/h/mh05-green_main_1.jpg','image',0),(177,90,'/m/h/mh05-red_main_1.jpg','image',0),(178,90,'/m/h/mh05-white_main_1.jpg','image',0),(179,90,'/m/h/mh05-white_alt1_1.jpg','image',0),(180,90,'/m/h/mh05-white_back_1.jpg','image',0),(181,90,'/m/h/mh05-green_main_1.jpg','image',0),(182,90,'/m/h/mh05-red_main_1.jpg','image',0),(183,90,'/m/h/mh05-white_main_1.jpg','image',0),(184,90,'/m/h/mh05-white_alt1_1.jpg','image',0),(185,90,'/m/h/mh05-white_back_1.jpg','image',0),(186,90,'/m/h/mh05-green_main_1.jpg','image',0),(187,90,'/m/h/mh05-red_main_1.jpg','image',0),(188,90,'/m/h/mh05-white_main_1.jpg','image',0),(189,90,'/m/h/mh05-white_alt1_1.jpg','image',0),(190,90,'/m/h/mh05-white_back_1.jpg','image',0),(191,90,'/m/h/mh05-green_main_1.jpg','image',0),(192,90,'/m/h/mh05-red_main_1.jpg','image',0),(193,90,'/m/h/mh05-white_main_1.jpg','image',0),(194,90,'/m/h/mh05-white_alt1_1.jpg','image',0),(195,90,'/m/h/mh05-white_back_1.jpg','image',0),(196,90,'/m/h/mh05-white_main_1.jpg','image',0),(197,90,'/m/h/mh05-white_alt1_1.jpg','image',0),(198,90,'/m/h/mh05-white_back_1.jpg','image',0),(199,90,'/m/h/mh06-black_main_1.jpg','image',0),(200,90,'/m/h/mh06-blue_main_1.jpg','image',0),(201,90,'/m/h/mh06-blue_alt1_1.jpg','image',0),(202,90,'/m/h/mh06-blue_back_1.jpg','image',0),(203,90,'/m/h/mh06-purple_main_1.jpg','image',0),(204,90,'/m/h/mh06-black_main_1.jpg','image',0),(205,90,'/m/h/mh06-blue_main_1.jpg','image',0),(206,90,'/m/h/mh06-blue_alt1_1.jpg','image',0),(207,90,'/m/h/mh06-blue_back_1.jpg','image',0),(208,90,'/m/h/mh06-purple_main_1.jpg','image',0),(209,90,'/m/h/mh06-black_main_1.jpg','image',0),(210,90,'/m/h/mh06-blue_main_1.jpg','image',0),(211,90,'/m/h/mh06-blue_alt1_1.jpg','image',0),(212,90,'/m/h/mh06-blue_back_1.jpg','image',0),(213,90,'/m/h/mh06-purple_main_1.jpg','image',0),(214,90,'/m/h/mh06-black_main_1.jpg','image',0),(215,90,'/m/h/mh06-blue_main_1.jpg','image',0),(216,90,'/m/h/mh06-blue_alt1_1.jpg','image',0),(217,90,'/m/h/mh06-blue_back_1.jpg','image',0),(218,90,'/m/h/mh06-purple_main_1.jpg','image',0),(219,90,'/m/h/mh06-black_main_1.jpg','image',0),(220,90,'/m/h/mh06-blue_main_1.jpg','image',0),(221,90,'/m/h/mh06-blue_alt1_1.jpg','image',0),(222,90,'/m/h/mh06-blue_back_1.jpg','image',0),(223,90,'/m/h/mh06-purple_main_1.jpg','image',0),(224,90,'/m/h/mh06-blue_main_1.jpg','image',0),(225,90,'/m/h/mh06-blue_alt1_1.jpg','image',0),(226,90,'/m/h/mh06-blue_back_1.jpg','image',0),(227,90,'/m/h/mh07-black_main_1.jpg','image',0),(228,90,'/m/h/mh07-gray_main_1.jpg','image',0),(229,90,'/m/h/mh07-gray_alt1_1.jpg','image',0),(230,90,'/m/h/mh07-gray_back_1.jpg','image',0),(231,90,'/m/h/mh07-green_main_1.jpg','image',0),(232,90,'/m/h/mh07-black_main_1.jpg','image',0),(233,90,'/m/h/mh07-gray_main_2.jpg','image',0),(234,90,'/m/h/mh07-gray_alt1_2.jpg','image',0),(235,90,'/m/h/mh07-gray_back_2.jpg','image',0),(236,90,'/m/h/mh07-green_main_2.jpg','image',0),(237,90,'/m/h/mh07-black_main_2.jpg','image',0),(238,90,'/m/h/mh07-gray_main_2.jpg','image',0),(239,90,'/m/h/mh07-gray_alt1_2.jpg','image',0),(240,90,'/m/h/mh07-gray_back_2.jpg','image',0),(241,90,'/m/h/mh07-green_main_2.jpg','image',0),(242,90,'/m/h/mh07-black_main_2.jpg','image',0),(243,90,'/m/h/mh07-gray_main_2.jpg','image',0),(244,90,'/m/h/mh07-gray_alt1_2.jpg','image',0),(245,90,'/m/h/mh07-gray_back_2.jpg','image',0),(246,90,'/m/h/mh07-green_main_2.jpg','image',0),(247,90,'/m/h/mh07-black_main_2.jpg','image',0),(248,90,'/m/h/mh07-gray_main_2.jpg','image',0),(249,90,'/m/h/mh07-gray_alt1_2.jpg','image',0),(250,90,'/m/h/mh07-gray_back_2.jpg','image',0),(251,90,'/m/h/mh07-green_main_2.jpg','image',0),(252,90,'/m/h/mh07-gray_main_2.jpg','image',0),(253,90,'/m/h/mh07-gray_alt1_2.jpg','image',0),(254,90,'/m/h/mh07-gray_back_2.jpg','image',0),(255,90,'/m/h/mh08-brown_main_1.jpg','image',0),(256,90,'/m/h/mh08-brown_alt1_1.jpg','image',0),(257,90,'/m/h/mh08-brown_back_1.jpg','image',0),(258,90,'/m/h/mh08-purple_main_1.jpg','image',0),(259,90,'/m/h/mh08-red_main_1.jpg','image',0),(260,90,'/m/h/mh08-brown_main_1.jpg','image',0),(261,90,'/m/h/mh08-brown_alt1_1.jpg','image',0),(262,90,'/m/h/mh08-brown_back_1.jpg','image',0),(263,90,'/m/h/mh08-purple_main_1.jpg','image',0),(264,90,'/m/h/mh08-red_main_1.jpg','image',0),(265,90,'/m/h/mh08-brown_main_1.jpg','image',0),(266,90,'/m/h/mh08-brown_alt1_1.jpg','image',0),(267,90,'/m/h/mh08-brown_back_1.jpg','image',0),(268,90,'/m/h/mh08-purple_main_1.jpg','image',0),(269,90,'/m/h/mh08-red_main_1.jpg','image',0),(270,90,'/m/h/mh08-brown_main_1.jpg','image',0),(271,90,'/m/h/mh08-brown_alt1_1.jpg','image',0),(272,90,'/m/h/mh08-brown_back_1.jpg','image',0),(273,90,'/m/h/mh08-purple_main_1.jpg','image',0),(274,90,'/m/h/mh08-red_main_1.jpg','image',0),(275,90,'/m/h/mh08-brown_main_1.jpg','image',0),(276,90,'/m/h/mh08-brown_alt1_1.jpg','image',0),(277,90,'/m/h/mh08-brown_back_1.jpg','image',0),(278,90,'/m/h/mh08-purple_main_1.jpg','image',0),(279,90,'/m/h/mh08-red_main_1.jpg','image',0),(280,90,'/m/h/mh08-brown_main_1.jpg','image',0),(281,90,'/m/h/mh08-brown_alt1_1.jpg','image',0),(282,90,'/m/h/mh08-brown_back_1.jpg','image',0),(283,90,'/m/h/mh09-blue_main_1.jpg','image',0),(284,90,'/m/h/mh09-blue_alt1_1.jpg','image',0),(285,90,'/m/h/mh09-blue_back_1.jpg','image',0),(286,90,'/m/h/mh09-green_main_1.jpg','image',0),(287,90,'/m/h/mh09-red_main_1.jpg','image',0),(288,90,'/m/h/mh09-blue_main_1.jpg','image',0),(289,90,'/m/h/mh09-blue_alt1_1.jpg','image',0),(290,90,'/m/h/mh09-blue_back_1.jpg','image',0),(291,90,'/m/h/mh09-green_main_1.jpg','image',0),(292,90,'/m/h/mh09-red_main_1.jpg','image',0),(293,90,'/m/h/mh09-blue_main_1.jpg','image',0),(294,90,'/m/h/mh09-blue_alt1_1.jpg','image',0),(295,90,'/m/h/mh09-blue_back_1.jpg','image',0),(296,90,'/m/h/mh09-green_main_1.jpg','image',0),(297,90,'/m/h/mh09-red_main_1.jpg','image',0),(298,90,'/m/h/mh09-blue_main_1.jpg','image',0),(299,90,'/m/h/mh09-blue_alt1_1.jpg','image',0),(300,90,'/m/h/mh09-blue_back_1.jpg','image',0),(301,90,'/m/h/mh09-green_main_1.jpg','image',0),(302,90,'/m/h/mh09-red_main_1.jpg','image',0),(303,90,'/m/h/mh09-blue_main_1.jpg','image',0),(304,90,'/m/h/mh09-blue_alt1_1.jpg','image',0),(305,90,'/m/h/mh09-blue_back_1.jpg','image',0),(306,90,'/m/h/mh09-green_main_1.jpg','image',0),(307,90,'/m/h/mh09-red_main_1.jpg','image',0),(308,90,'/m/h/mh09-blue_main_1.jpg','image',0),(309,90,'/m/h/mh09-blue_alt1_1.jpg','image',0),(310,90,'/m/h/mh09-blue_back_1.jpg','image',0),(311,90,'/m/h/mh10-black_main_1.jpg','image',0),(312,90,'/m/h/mh10-blue_main_1.jpg','image',0),(313,90,'/m/h/mh10-blue_alt1_1.jpg','image',0),(314,90,'/m/h/mh10-blue_back_1.jpg','image',0),(315,90,'/m/h/mh10-red_main_1.jpg','image',0),(316,90,'/m/h/mh10-black_main_1.jpg','image',0),(317,90,'/m/h/mh10-blue_main_1.jpg','image',0),(318,90,'/m/h/mh10-blue_alt1_1.jpg','image',0),(319,90,'/m/h/mh10-blue_back_1.jpg','image',0),(320,90,'/m/h/mh10-red_main_1.jpg','image',0),(321,90,'/m/h/mh10-black_main_1.jpg','image',0),(322,90,'/m/h/mh10-blue_main_1.jpg','image',0),(323,90,'/m/h/mh10-blue_alt1_1.jpg','image',0),(324,90,'/m/h/mh10-blue_back_1.jpg','image',0),(325,90,'/m/h/mh10-red_main_1.jpg','image',0),(326,90,'/m/h/mh10-black_main_1.jpg','image',0),(327,90,'/m/h/mh10-blue_main_1.jpg','image',0),(328,90,'/m/h/mh10-blue_alt1_1.jpg','image',0),(329,90,'/m/h/mh10-blue_back_1.jpg','image',0),(330,90,'/m/h/mh10-red_main_1.jpg','image',0),(331,90,'/m/h/mh10-black_main_1.jpg','image',0),(332,90,'/m/h/mh10-blue_main_1.jpg','image',0),(333,90,'/m/h/mh10-blue_alt1_1.jpg','image',0),(334,90,'/m/h/mh10-blue_back_1.jpg','image',0),(335,90,'/m/h/mh10-red_main_1.jpg','image',0),(336,90,'/m/h/mh10-blue_main_1.jpg','image',0),(337,90,'/m/h/mh10-blue_alt1_1.jpg','image',0),(338,90,'/m/h/mh10-blue_back_1.jpg','image',0),(339,90,'/m/h/mh11-orange_main_1.jpg','image',0),(340,90,'/m/h/mh11-red_main_1.jpg','image',0),(341,90,'/m/h/mh11-white_main_1.jpg','image',0),(342,90,'/m/h/mh11-white_alt1_1.jpg','image',0),(343,90,'/m/h/mh11-white_back_1.jpg','image',0),(344,90,'/m/h/mh11-orange_main_1.jpg','image',0),(345,90,'/m/h/mh11-red_main_1.jpg','image',0),(346,90,'/m/h/mh11-white_main_1.jpg','image',0),(347,90,'/m/h/mh11-white_alt1_1.jpg','image',0),(348,90,'/m/h/mh11-white_back_1.jpg','image',0),(349,90,'/m/h/mh11-orange_main_1.jpg','image',0),(350,90,'/m/h/mh11-red_main_1.jpg','image',0),(351,90,'/m/h/mh11-white_main_1.jpg','image',0),(352,90,'/m/h/mh11-white_alt1_1.jpg','image',0),(353,90,'/m/h/mh11-white_back_1.jpg','image',0),(354,90,'/m/h/mh11-orange_main_1.jpg','image',0),(355,90,'/m/h/mh11-red_main_1.jpg','image',0),(356,90,'/m/h/mh11-white_main_1.jpg','image',0),(357,90,'/m/h/mh11-white_alt1_1.jpg','image',0),(358,90,'/m/h/mh11-white_back_1.jpg','image',0),(359,90,'/m/h/mh11-orange_main_1.jpg','image',0),(360,90,'/m/h/mh11-red_main_1.jpg','image',0),(361,90,'/m/h/mh11-white_main_1.jpg','image',0),(362,90,'/m/h/mh11-white_alt1_1.jpg','image',0),(363,90,'/m/h/mh11-white_back_1.jpg','image',0),(364,90,'/m/h/mh11-white_main_1.jpg','image',0),(365,90,'/m/h/mh11-white_alt1_1.jpg','image',0),(366,90,'/m/h/mh11-white_back_1.jpg','image',0),(367,90,'/m/h/mh12-blue_main_1.jpg','image',0),(368,90,'/m/h/mh12-green_main_1.jpg','image',0),(369,90,'/m/h/mh12-green_alt1_1.jpg','image',0),(370,90,'/m/h/mh12-green_back_1.jpg','image',0),(371,90,'/m/h/mh12-red_main_1.jpg','image',0),(372,90,'/m/h/mh12-blue_main_1.jpg','image',0),(373,90,'/m/h/mh12-green_main_1.jpg','image',0),(374,90,'/m/h/mh12-green_alt1_1.jpg','image',0),(375,90,'/m/h/mh12-green_back_1.jpg','image',0),(376,90,'/m/h/mh12-red_main_1.jpg','image',0),(377,90,'/m/h/mh12-blue_main_1.jpg','image',0),(378,90,'/m/h/mh12-green_main_1.jpg','image',0),(379,90,'/m/h/mh12-green_alt1_1.jpg','image',0),(380,90,'/m/h/mh12-green_back_1.jpg','image',0),(381,90,'/m/h/mh12-red_main_1.jpg','image',0),(382,90,'/m/h/mh12-blue_main_1.jpg','image',0),(383,90,'/m/h/mh12-green_main_1.jpg','image',0),(384,90,'/m/h/mh12-green_alt1_1.jpg','image',0),(385,90,'/m/h/mh12-green_back_1.jpg','image',0),(386,90,'/m/h/mh12-red_main_1.jpg','image',0),(387,90,'/m/h/mh12-blue_main_1.jpg','image',0),(388,90,'/m/h/mh12-green_main_1.jpg','image',0),(389,90,'/m/h/mh12-green_alt1_1.jpg','image',0),(390,90,'/m/h/mh12-green_back_1.jpg','image',0),(391,90,'/m/h/mh12-red_main_1.jpg','image',0),(392,90,'/m/h/mh12-green_main_1.jpg','image',0),(393,90,'/m/h/mh12-green_alt1_1.jpg','image',0),(394,90,'/m/h/mh12-green_back_1.jpg','image',0),(395,90,'/m/h/mh13-blue_main_1.jpg','image',0),(396,90,'/m/h/mh13-blue_alt1_1.jpg','image',0),(397,90,'/m/h/mh13-blue_back_1.jpg','image',0),(398,90,'/m/h/mh13-green_main_1.jpg','image',0),(399,90,'/m/h/mh13-lavender_main_1.jpg','image',0),(400,90,'/m/h/mh13-blue_main_1.jpg','image',0),(401,90,'/m/h/mh13-blue_alt1_1.jpg','image',0),(402,90,'/m/h/mh13-blue_back_1.jpg','image',0),(403,90,'/m/h/mh13-green_main_1.jpg','image',0),(404,90,'/m/h/mh13-lavender_main_1.jpg','image',0),(405,90,'/m/h/mh13-blue_main_1.jpg','image',0),(406,90,'/m/h/mh13-blue_alt1_1.jpg','image',0),(407,90,'/m/h/mh13-blue_back_1.jpg','image',0),(408,90,'/m/h/mh13-green_main_1.jpg','image',0),(409,90,'/m/h/mh13-lavender_main_2.jpg','image',0),(410,90,'/m/h/mh13-blue_main_2.jpg','image',0),(411,90,'/m/h/mh13-blue_alt1_2.jpg','image',0),(412,90,'/m/h/mh13-blue_back_2.jpg','image',0),(413,90,'/m/h/mh13-green_main_2.jpg','image',0),(414,90,'/m/h/mh13-lavender_main_2.jpg','image',0),(415,90,'/m/h/mh13-blue_main_2.jpg','image',0),(416,90,'/m/h/mh13-blue_alt1_2.jpg','image',0),(417,90,'/m/h/mh13-blue_back_2.jpg','image',0),(418,90,'/m/h/mh13-green_main_2.jpg','image',0),(419,90,'/m/h/mh13-lavender_main_2.jpg','image',0),(420,90,'/m/h/mh13-blue_main_2.jpg','image',0),(421,90,'/m/h/mh13-blue_alt1_2.jpg','image',0),(422,90,'/m/h/mh13-blue_back_2.jpg','image',0),(423,90,'/m/j/mj01-orange_main_1.jpg','image',0),(424,90,'/m/j/mj01-red_main_1.jpg','image',0),(425,90,'/m/j/mj01-yellow_main_1.jpg','image',0),(426,90,'/m/j/mj01-yellow_alt1_1.jpg','image',0),(427,90,'/m/j/mj01-yellow_back_1.jpg','image',0),(428,90,'/m/j/mj01-orange_main_1.jpg','image',0),(429,90,'/m/j/mj01-red_main_1.jpg','image',0),(430,90,'/m/j/mj01-yellow_main_1.jpg','image',0),(431,90,'/m/j/mj01-yellow_alt1_1.jpg','image',0),(432,90,'/m/j/mj01-yellow_back_1.jpg','image',0),(433,90,'/m/j/mj01-orange_main_1.jpg','image',0),(434,90,'/m/j/mj01-red_main_1.jpg','image',0),(435,90,'/m/j/mj01-yellow_main_1.jpg','image',0),(436,90,'/m/j/mj01-yellow_alt1_1.jpg','image',0),(437,90,'/m/j/mj01-yellow_back_1.jpg','image',0),(438,90,'/m/j/mj01-orange_main_1.jpg','image',0),(439,90,'/m/j/mj01-red_main_1.jpg','image',0),(440,90,'/m/j/mj01-yellow_main_1.jpg','image',0),(441,90,'/m/j/mj01-yellow_alt1_1.jpg','image',0),(442,90,'/m/j/mj01-yellow_back_1.jpg','image',0),(443,90,'/m/j/mj01-orange_main_1.jpg','image',0),(444,90,'/m/j/mj01-red_main_1.jpg','image',0),(445,90,'/m/j/mj01-yellow_main_1.jpg','image',0),(446,90,'/m/j/mj01-yellow_alt1_1.jpg','image',0),(447,90,'/m/j/mj01-yellow_back_1.jpg','image',0),(448,90,'/m/j/mj01-yellow_main_1.jpg','image',0),(449,90,'/m/j/mj01-yellow_alt1_1.jpg','image',0),(450,90,'/m/j/mj01-yellow_back_1.jpg','image',0),(451,90,'/m/j/mj02-green_main_1.jpg','image',0),(452,90,'/m/j/mj02-green_alt1_1.jpg','image',0),(453,90,'/m/j/mj02-green_back_1.jpg','image',0),(454,90,'/m/j/mj02-orange_main_1.jpg','image',0),(455,90,'/m/j/mj02-red_main_1.jpg','image',0),(456,90,'/m/j/mj02-green_main_1.jpg','image',0),(457,90,'/m/j/mj02-green_alt1_1.jpg','image',0),(458,90,'/m/j/mj02-green_back_1.jpg','image',0),(459,90,'/m/j/mj02-orange_main_1.jpg','image',0),(460,90,'/m/j/mj02-red_main_1.jpg','image',0),(461,90,'/m/j/mj02-green_main_1.jpg','image',0),(462,90,'/m/j/mj02-green_alt1_1.jpg','image',0),(463,90,'/m/j/mj02-green_back_1.jpg','image',0),(464,90,'/m/j/mj02-orange_main_1.jpg','image',0),(465,90,'/m/j/mj02-red_main_1.jpg','image',0),(466,90,'/m/j/mj02-green_main_1.jpg','image',0),(467,90,'/m/j/mj02-green_alt1_1.jpg','image',0),(468,90,'/m/j/mj02-green_back_1.jpg','image',0),(469,90,'/m/j/mj02-orange_main_1.jpg','image',0),(470,90,'/m/j/mj02-red_main_1.jpg','image',0),(471,90,'/m/j/mj02-green_main_1.jpg','image',0),(472,90,'/m/j/mj02-green_alt1_1.jpg','image',0),(473,90,'/m/j/mj02-green_back_1.jpg','image',0),(474,90,'/m/j/mj02-orange_main_1.jpg','image',0),(475,90,'/m/j/mj02-red_main_1.jpg','image',0),(476,90,'/m/j/mj02-green_main_1.jpg','image',0),(477,90,'/m/j/mj02-green_alt1_1.jpg','image',0),(478,90,'/m/j/mj02-green_back_1.jpg','image',0),(479,90,'/m/j/mj04-black_main_1.jpg','image',0),(480,90,'/m/j/mj04-black_alt1_1.jpg','image',0),(481,90,'/m/j/mj04-black_back_1.jpg','image',0),(482,90,'/m/j/mj04-blue_main_1.jpg','image',0),(483,90,'/m/j/mj04-purple_main_1.jpg','image',0),(484,90,'/m/j/mj04-black_main_1.jpg','image',0),(485,90,'/m/j/mj04-black_alt1_1.jpg','image',0),(486,90,'/m/j/mj04-black_back_1.jpg','image',0),(487,90,'/m/j/mj04-blue_main_1.jpg','image',0),(488,90,'/m/j/mj04-purple_main_1.jpg','image',0),(489,90,'/m/j/mj04-black_main_1.jpg','image',0),(490,90,'/m/j/mj04-black_alt1_1.jpg','image',0),(491,90,'/m/j/mj04-black_back_1.jpg','image',0),(492,90,'/m/j/mj04-blue_main_1.jpg','image',0),(493,90,'/m/j/mj04-purple_main_1.jpg','image',0),(494,90,'/m/j/mj04-black_main_1.jpg','image',0),(495,90,'/m/j/mj04-black_alt1_1.jpg','image',0),(496,90,'/m/j/mj04-black_back_1.jpg','image',0),(497,90,'/m/j/mj04-blue_main_1.jpg','image',0),(498,90,'/m/j/mj04-purple_main_1.jpg','image',0),(499,90,'/m/j/mj04-black_main_1.jpg','image',0),(500,90,'/m/j/mj04-black_alt1_1.jpg','image',0),(501,90,'/m/j/mj04-black_back_1.jpg','image',0),(502,90,'/m/j/mj04-blue_main_1.jpg','image',0),(503,90,'/m/j/mj04-purple_main_1.jpg','image',0),(504,90,'/m/j/mj04-black_main_1.jpg','image',0),(505,90,'/m/j/mj04-black_alt1_1.jpg','image',0),(506,90,'/m/j/mj04-black_back_1.jpg','image',0),(507,90,'/m/j/mj07-black_main_1.jpg','image',0),(508,90,'/m/j/mj07-red_main_1.jpg','image',0),(509,90,'/m/j/mj07-red_alt1_1.jpg','image',0),(510,90,'/m/j/mj07-red_back_1.jpg','image',0),(511,90,'/m/j/mj07-yellow_main_1.jpg','image',0),(512,90,'/m/j/mj07-black_main_1.jpg','image',0),(513,90,'/m/j/mj07-red_main_1.jpg','image',0),(514,90,'/m/j/mj07-red_alt1_1.jpg','image',0),(515,90,'/m/j/mj07-red_back_1.jpg','image',0),(516,90,'/m/j/mj07-yellow_main_1.jpg','image',0),(517,90,'/m/j/mj07-black_main_1.jpg','image',0),(518,90,'/m/j/mj07-red_main_1.jpg','image',0),(519,90,'/m/j/mj07-red_alt1_1.jpg','image',0),(520,90,'/m/j/mj07-red_back_1.jpg','image',0),(521,90,'/m/j/mj07-yellow_main_1.jpg','image',0),(522,90,'/m/j/mj07-black_main_1.jpg','image',0),(523,90,'/m/j/mj07-red_main_1.jpg','image',0),(524,90,'/m/j/mj07-red_alt1_1.jpg','image',0),(525,90,'/m/j/mj07-red_back_1.jpg','image',0),(526,90,'/m/j/mj07-yellow_main_1.jpg','image',0),(527,90,'/m/j/mj07-black_main_1.jpg','image',0),(528,90,'/m/j/mj07-red_main_1.jpg','image',0),(529,90,'/m/j/mj07-red_alt1_1.jpg','image',0),(530,90,'/m/j/mj07-red_back_1.jpg','image',0),(531,90,'/m/j/mj07-yellow_main_1.jpg','image',0),(532,90,'/m/j/mj07-red_main_1.jpg','image',0),(533,90,'/m/j/mj07-red_alt1_1.jpg','image',0),(534,90,'/m/j/mj07-red_back_1.jpg','image',0),(535,90,'/m/j/mj08-blue_main_1.jpg','image',0),(536,90,'/m/j/mj08-gray_main_1.jpg','image',0),(537,90,'/m/j/mj08-gray_alt1_1.jpg','image',0),(538,90,'/m/j/mj08-gray_back_1.jpg','image',0),(539,90,'/m/j/mj08-green_main_1.jpg','image',0),(540,90,'/m/j/mj08-blue_main_1.jpg','image',0),(541,90,'/m/j/mj08-gray_main_1.jpg','image',0),(542,90,'/m/j/mj08-gray_alt1_1.jpg','image',0),(543,90,'/m/j/mj08-gray_back_1.jpg','image',0),(544,90,'/m/j/mj08-green_main_1.jpg','image',0),(545,90,'/m/j/mj08-blue_main_1.jpg','image',0),(546,90,'/m/j/mj08-gray_main_1.jpg','image',0),(547,90,'/m/j/mj08-gray_alt1_1.jpg','image',0),(548,90,'/m/j/mj08-gray_back_1.jpg','image',0),(549,90,'/m/j/mj08-green_main_1.jpg','image',0),(550,90,'/m/j/mj08-blue_main_1.jpg','image',0),(551,90,'/m/j/mj08-gray_main_1.jpg','image',0),(552,90,'/m/j/mj08-gray_alt1_1.jpg','image',0),(553,90,'/m/j/mj08-gray_back_1.jpg','image',0),(554,90,'/m/j/mj08-green_main_1.jpg','image',0),(555,90,'/m/j/mj08-blue_main_1.jpg','image',0),(556,90,'/m/j/mj08-gray_main_1.jpg','image',0),(557,90,'/m/j/mj08-gray_alt1_1.jpg','image',0),(558,90,'/m/j/mj08-gray_back_1.jpg','image',0),(559,90,'/m/j/mj08-green_main_1.jpg','image',0),(560,90,'/m/j/mj08-gray_main_1.jpg','image',0),(561,90,'/m/j/mj08-gray_alt1_1.jpg','image',0),(562,90,'/m/j/mj08-gray_back_1.jpg','image',0),(563,90,'/m/j/mj09-blue_main_1.jpg','image',0),(564,90,'/m/j/mj09-white_main_1.jpg','image',0),(565,90,'/m/j/mj09-yellow_main_1.jpg','image',0),(566,90,'/m/j/mj09-yellow_alt1_1.jpg','image',0),(567,90,'/m/j/mj09-yellow_back_1.jpg','image',0),(568,90,'/m/j/mj09-blue_main_1.jpg','image',0),(569,90,'/m/j/mj09-white_main_1.jpg','image',0),(570,90,'/m/j/mj09-yellow_main_1.jpg','image',0),(571,90,'/m/j/mj09-yellow_alt1_1.jpg','image',0),(572,90,'/m/j/mj09-yellow_back_1.jpg','image',0),(573,90,'/m/j/mj09-blue_main_1.jpg','image',0),(574,90,'/m/j/mj09-white_main_1.jpg','image',0),(575,90,'/m/j/mj09-yellow_main_1.jpg','image',0),(576,90,'/m/j/mj09-yellow_alt1_1.jpg','image',0),(577,90,'/m/j/mj09-yellow_back_1.jpg','image',0),(578,90,'/m/j/mj09-blue_main_1.jpg','image',0),(579,90,'/m/j/mj09-white_main_1.jpg','image',0),(580,90,'/m/j/mj09-yellow_main_1.jpg','image',0),(581,90,'/m/j/mj09-yellow_alt1_1.jpg','image',0),(582,90,'/m/j/mj09-yellow_back_1.jpg','image',0),(583,90,'/m/j/mj09-blue_main_2.jpg','image',0),(584,90,'/m/j/mj09-white_main_2.jpg','image',0),(585,90,'/m/j/mj09-yellow_main_2.jpg','image',0),(586,90,'/m/j/mj09-yellow_alt1_2.jpg','image',0),(587,90,'/m/j/mj09-yellow_back_2.jpg','image',0),(588,90,'/m/j/mj09-yellow_main_2.jpg','image',0),(589,90,'/m/j/mj09-yellow_alt1_2.jpg','image',0),(590,90,'/m/j/mj09-yellow_back_2.jpg','image',0),(591,90,'/m/j/mj10-black_main_1.jpg','image',0),(592,90,'/m/j/mj10-orange_main_1.jpg','image',0),(593,90,'/m/j/mj10-red_main_1.jpg','image',0),(594,90,'/m/j/mj10-red_alt1_1.jpg','image',0),(595,90,'/m/j/mj10-red_back_1.jpg','image',0),(596,90,'/m/j/mj10-black_main_1.jpg','image',0),(597,90,'/m/j/mj10-orange_main_1.jpg','image',0),(598,90,'/m/j/mj10-red_main_1.jpg','image',0),(599,90,'/m/j/mj10-red_alt1_1.jpg','image',0),(600,90,'/m/j/mj10-red_back_1.jpg','image',0),(601,90,'/m/j/mj10-black_main_1.jpg','image',0),(602,90,'/m/j/mj10-orange_main_1.jpg','image',0),(603,90,'/m/j/mj10-red_main_1.jpg','image',0),(604,90,'/m/j/mj10-red_alt1_1.jpg','image',0),(605,90,'/m/j/mj10-red_back_1.jpg','image',0),(606,90,'/m/j/mj10-black_main_1.jpg','image',0),(607,90,'/m/j/mj10-orange_main_1.jpg','image',0),(608,90,'/m/j/mj10-red_main_1.jpg','image',0),(609,90,'/m/j/mj10-red_alt1_1.jpg','image',0),(610,90,'/m/j/mj10-red_back_1.jpg','image',0),(611,90,'/m/j/mj10-black_main_1.jpg','image',0),(612,90,'/m/j/mj10-orange_main_1.jpg','image',0),(613,90,'/m/j/mj10-red_main_1.jpg','image',0),(614,90,'/m/j/mj10-red_alt1_1.jpg','image',0),(615,90,'/m/j/mj10-red_back_1.jpg','image',0),(616,90,'/m/j/mj10-red_main_1.jpg','image',0),(617,90,'/m/j/mj10-red_alt1_1.jpg','image',0),(618,90,'/m/j/mj10-red_back_1.jpg','image',0),(619,90,'/m/j/mj11-black_main_1.jpg','image',0),(620,90,'/m/j/mj11-black_alt1_1.jpg','image',0),(621,90,'/m/j/mj11-black_back_1.jpg','image',0),(622,90,'/m/j/mj11-green_main_1.jpg','image',0),(623,90,'/m/j/mj11-red_main_1.jpg','image',0),(624,90,'/m/j/mj11-black_main_1.jpg','image',0),(625,90,'/m/j/mj11-black_alt1_1.jpg','image',0),(626,90,'/m/j/mj11-black_back_1.jpg','image',0),(627,90,'/m/j/mj11-green_main_1.jpg','image',0),(628,90,'/m/j/mj11-red_main_1.jpg','image',0),(629,90,'/m/j/mj11-black_main_1.jpg','image',0),(630,90,'/m/j/mj11-black_alt1_1.jpg','image',0),(631,90,'/m/j/mj11-black_back_1.jpg','image',0),(632,90,'/m/j/mj11-green_main_1.jpg','image',0),(633,90,'/m/j/mj11-red_main_1.jpg','image',0),(634,90,'/m/j/mj11-black_main_1.jpg','image',0),(635,90,'/m/j/mj11-black_alt1_1.jpg','image',0),(636,90,'/m/j/mj11-black_back_1.jpg','image',0),(637,90,'/m/j/mj11-green_main_1.jpg','image',0),(638,90,'/m/j/mj11-red_main_1.jpg','image',0),(639,90,'/m/j/mj11-black_main_1.jpg','image',0),(640,90,'/m/j/mj11-black_alt1_1.jpg','image',0),(641,90,'/m/j/mj11-black_back_1.jpg','image',0),(642,90,'/m/j/mj11-green_main_1.jpg','image',0),(643,90,'/m/j/mj11-red_main_1.jpg','image',0),(644,90,'/m/j/mj11-black_main_1.jpg','image',0),(645,90,'/m/j/mj11-black_alt1_1.jpg','image',0),(646,90,'/m/j/mj11-black_back_1.jpg','image',0),(647,90,'/m/j/mj06-blue_main_1.jpg','image',0),(648,90,'/m/j/mj06-blue_alt1_1.jpg','image',0),(649,90,'/m/j/mj06-blue_back_1.jpg','image',0),(650,90,'/m/j/mj06-green_main_1.jpg','image',0),(651,90,'/m/j/mj06-purple_main_1.jpg','image',0),(652,90,'/m/j/mj06-blue_main_1.jpg','image',0),(653,90,'/m/j/mj06-blue_alt1_1.jpg','image',0),(654,90,'/m/j/mj06-blue_back_1.jpg','image',0),(655,90,'/m/j/mj06-green_main_1.jpg','image',0),(656,90,'/m/j/mj06-purple_main_1.jpg','image',0),(657,90,'/m/j/mj06-blue_main_1.jpg','image',0),(658,90,'/m/j/mj06-blue_alt1_1.jpg','image',0),(659,90,'/m/j/mj06-blue_back_1.jpg','image',0),(660,90,'/m/j/mj06-green_main_1.jpg','image',0),(661,90,'/m/j/mj06-purple_main_1.jpg','image',0),(662,90,'/m/j/mj06-blue_main_1.jpg','image',0),(663,90,'/m/j/mj06-blue_alt1_1.jpg','image',0),(664,90,'/m/j/mj06-blue_back_1.jpg','image',0),(665,90,'/m/j/mj06-green_main_1.jpg','image',0),(666,90,'/m/j/mj06-purple_main_1.jpg','image',0),(667,90,'/m/j/mj06-blue_main_1.jpg','image',0),(668,90,'/m/j/mj06-blue_alt1_1.jpg','image',0),(669,90,'/m/j/mj06-blue_back_1.jpg','image',0),(670,90,'/m/j/mj06-green_main_1.jpg','image',0),(671,90,'/m/j/mj06-purple_main_1.jpg','image',0),(672,90,'/m/j/mj06-blue_main_1.jpg','image',0),(673,90,'/m/j/mj06-blue_alt1_1.jpg','image',0),(674,90,'/m/j/mj06-blue_back_1.jpg','image',0),(675,90,'/m/j/mj03-black_main_1.jpg','image',0),(676,90,'/m/j/mj03-black_alt1_1.jpg','image',0),(677,90,'/m/j/mj03-black_back_1.jpg','image',0),(678,90,'/m/j/mj03-green_main_1.jpg','image',0),(679,90,'/m/j/mj03-red_main_1.jpg','image',0),(680,90,'/m/j/mj03-black_main_1.jpg','image',0),(681,90,'/m/j/mj03-black_alt1_1.jpg','image',0),(682,90,'/m/j/mj03-black_back_1.jpg','image',0),(683,90,'/m/j/mj03-green_main_1.jpg','image',0),(684,90,'/m/j/mj03-red_main_1.jpg','image',0),(685,90,'/m/j/mj03-black_main_1.jpg','image',0),(686,90,'/m/j/mj03-black_alt1_1.jpg','image',0),(687,90,'/m/j/mj03-black_back_1.jpg','image',0),(688,90,'/m/j/mj03-green_main_1.jpg','image',0),(689,90,'/m/j/mj03-red_main_1.jpg','image',0),(690,90,'/m/j/mj03-black_main_1.jpg','image',0),(691,90,'/m/j/mj03-black_alt1_1.jpg','image',0),(692,90,'/m/j/mj03-black_back_1.jpg','image',0),(693,90,'/m/j/mj03-green_main_1.jpg','image',0),(694,90,'/m/j/mj03-red_main_1.jpg','image',0),(695,90,'/m/j/mj03-black_main_1.jpg','image',0),(696,90,'/m/j/mj03-black_alt1_1.jpg','image',0),(697,90,'/m/j/mj03-black_back_1.jpg','image',0),(698,90,'/m/j/mj03-green_main_1.jpg','image',0),(699,90,'/m/j/mj03-red_main_1.jpg','image',0),(700,90,'/m/j/mj03-black_main_1.jpg','image',0),(701,90,'/m/j/mj03-black_alt1_1.jpg','image',0),(702,90,'/m/j/mj03-black_back_1.jpg','image',0),(703,90,'/m/j/mj12-black_main_1.jpg','image',0),(704,90,'/m/j/mj12-blue_main_1.jpg','image',0),(705,90,'/m/j/mj12-orange_main_1.jpg','image',0),(706,90,'/m/j/mj12-orange_alt1_1.jpg','image',0),(707,90,'/m/j/mj12-orange_back_1.jpg','image',0),(708,90,'/m/j/mj12-black_main_1.jpg','image',0),(709,90,'/m/j/mj12-blue_main_1.jpg','image',0),(710,90,'/m/j/mj12-orange_main_1.jpg','image',0),(711,90,'/m/j/mj12-orange_alt1_1.jpg','image',0),(712,90,'/m/j/mj12-orange_back_1.jpg','image',0),(713,90,'/m/j/mj12-black_main_1.jpg','image',0),(714,90,'/m/j/mj12-blue_main_1.jpg','image',0),(715,90,'/m/j/mj12-orange_main_1.jpg','image',0),(716,90,'/m/j/mj12-orange_alt1_1.jpg','image',0),(717,90,'/m/j/mj12-orange_back_1.jpg','image',0),(718,90,'/m/j/mj12-black_main_1.jpg','image',0),(719,90,'/m/j/mj12-blue_main_1.jpg','image',0),(720,90,'/m/j/mj12-orange_main_1.jpg','image',0),(721,90,'/m/j/mj12-orange_alt1_1.jpg','image',0),(722,90,'/m/j/mj12-orange_back_1.jpg','image',0),(723,90,'/m/j/mj12-black_main_1.jpg','image',0),(724,90,'/m/j/mj12-blue_main_1.jpg','image',0),(725,90,'/m/j/mj12-orange_main_1.jpg','image',0),(726,90,'/m/j/mj12-orange_alt1_1.jpg','image',0),(727,90,'/m/j/mj12-orange_back_1.jpg','image',0),(728,90,'/m/j/mj12-orange_main_1.jpg','image',0),(729,90,'/m/j/mj12-orange_alt1_1.jpg','image',0),(730,90,'/m/j/mj12-orange_back_1.jpg','image',0),(731,90,'/m/s/ms04-black_main_1.jpg','image',0),(732,90,'/m/s/ms04-orange_main_1.jpg','image',0),(733,90,'/m/s/ms04-orange_back_1.jpg','image',0),(734,90,'/m/s/ms04-red_main_1.jpg','image',0),(735,90,'/m/s/ms04-black_main_1.jpg','image',0),(736,90,'/m/s/ms04-orange_main_1.jpg','image',0),(737,90,'/m/s/ms04-orange_back_1.jpg','image',0),(738,90,'/m/s/ms04-red_main_1.jpg','image',0),(739,90,'/m/s/ms04-black_main_1.jpg','image',0),(740,90,'/m/s/ms04-orange_main_1.jpg','image',0),(741,90,'/m/s/ms04-orange_back_1.jpg','image',0),(742,90,'/m/s/ms04-red_main_1.jpg','image',0),(743,90,'/m/s/ms04-black_main_1.jpg','image',0),(744,90,'/m/s/ms04-orange_main_1.jpg','image',0),(745,90,'/m/s/ms04-orange_back_1.jpg','image',0),(746,90,'/m/s/ms04-red_main_1.jpg','image',0),(747,90,'/m/s/ms04-black_main_1.jpg','image',0),(748,90,'/m/s/ms04-orange_main_1.jpg','image',0),(749,90,'/m/s/ms04-orange_back_1.jpg','image',0),(750,90,'/m/s/ms04-red_main_1.jpg','image',0),(751,90,'/m/s/ms04-orange_main_1.jpg','image',0),(752,90,'/m/s/ms04-orange_back_1.jpg','image',0),(753,90,'/m/s/ms05-black_main_1.jpg','image',0),(754,90,'/m/s/ms05-blue_main_1.jpg','image',0),(755,90,'/m/s/ms05-blue_back_1.jpg','image',0),(756,90,'/m/s/ms05-purple_main_1.jpg','image',0),(757,90,'/m/s/ms05-black_main_1.jpg','image',0),(758,90,'/m/s/ms05-blue_main_1.jpg','image',0),(759,90,'/m/s/ms05-blue_back_1.jpg','image',0),(760,90,'/m/s/ms05-purple_main_1.jpg','image',0),(761,90,'/m/s/ms05-black_main_1.jpg','image',0),(762,90,'/m/s/ms05-blue_main_1.jpg','image',0),(763,90,'/m/s/ms05-blue_back_1.jpg','image',0),(764,90,'/m/s/ms05-purple_main_1.jpg','image',0),(765,90,'/m/s/ms05-black_main_1.jpg','image',0),(766,90,'/m/s/ms05-blue_main_1.jpg','image',0),(767,90,'/m/s/ms05-blue_back_1.jpg','image',0),(768,90,'/m/s/ms05-purple_main_1.jpg','image',0),(769,90,'/m/s/ms05-black_main_1.jpg','image',0),(770,90,'/m/s/ms05-blue_main_1.jpg','image',0),(771,90,'/m/s/ms05-blue_back_1.jpg','image',0),(772,90,'/m/s/ms05-purple_main_1.jpg','image',0),(773,90,'/m/s/ms05-blue_main_1.jpg','image',0),(774,90,'/m/s/ms05-blue_back_1.jpg','image',0),(775,90,'/m/s/ms09-black_main_1.jpg','image',0),(776,90,'/m/s/ms09-blue_main_1.jpg','image',0),(777,90,'/m/s/ms09-blue_alt1_1.jpg','image',0),(778,90,'/m/s/ms09-blue_back_1.jpg','image',0),(779,90,'/m/s/ms09-red_main_1.jpg','image',0),(780,90,'/m/s/ms09-black_main_1.jpg','image',0),(781,90,'/m/s/ms09-blue_main_1.jpg','image',0),(782,90,'/m/s/ms09-blue_alt1_1.jpg','image',0),(783,90,'/m/s/ms09-blue_back_1.jpg','image',0),(784,90,'/m/s/ms09-red_main_1.jpg','image',0),(785,90,'/m/s/ms09-black_main_1.jpg','image',0),(786,90,'/m/s/ms09-blue_main_1.jpg','image',0),(787,90,'/m/s/ms09-blue_alt1_1.jpg','image',0),(788,90,'/m/s/ms09-blue_back_1.jpg','image',0),(789,90,'/m/s/ms09-red_main_1.jpg','image',0),(790,90,'/m/s/ms09-black_main_1.jpg','image',0),(791,90,'/m/s/ms09-blue_main_1.jpg','image',0),(792,90,'/m/s/ms09-blue_alt1_1.jpg','image',0),(793,90,'/m/s/ms09-blue_back_1.jpg','image',0),(794,90,'/m/s/ms09-red_main_1.jpg','image',0),(795,90,'/m/s/ms09-black_main_1.jpg','image',0),(796,90,'/m/s/ms09-blue_main_1.jpg','image',0),(797,90,'/m/s/ms09-blue_alt1_1.jpg','image',0),(798,90,'/m/s/ms09-blue_back_1.jpg','image',0),(799,90,'/m/s/ms09-red_main_1.jpg','image',0),(800,90,'/m/s/ms09-blue_main_1.jpg','image',0),(801,90,'/m/s/ms09-blue_alt1_1.jpg','image',0),(802,90,'/m/s/ms09-blue_back_1.jpg','image',0),(803,90,'/m/s/ms11-blue_main_1.jpg','image',0),(804,90,'/m/s/ms11-green_main_1.jpg','image',0),(805,90,'/m/s/ms11-green_back_1.jpg','image',0),(806,90,'/m/s/ms11-yellow_main_1.jpg','image',0),(807,90,'/m/s/ms11-blue_main_1.jpg','image',0),(808,90,'/m/s/ms11-green_main_1.jpg','image',0),(809,90,'/m/s/ms11-green_back_1.jpg','image',0),(810,90,'/m/s/ms11-yellow_main_1.jpg','image',0),(811,90,'/m/s/ms11-blue_main_1.jpg','image',0),(812,90,'/m/s/ms11-green_main_1.jpg','image',0),(813,90,'/m/s/ms11-green_back_1.jpg','image',0),(814,90,'/m/s/ms11-yellow_main_1.jpg','image',0),(815,90,'/m/s/ms11-blue_main_1.jpg','image',0),(816,90,'/m/s/ms11-green_main_1.jpg','image',0),(817,90,'/m/s/ms11-green_back_1.jpg','image',0),(818,90,'/m/s/ms11-yellow_main_1.jpg','image',0),(819,90,'/m/s/ms11-blue_main_1.jpg','image',0),(820,90,'/m/s/ms11-green_main_1.jpg','image',0),(821,90,'/m/s/ms11-green_back_1.jpg','image',0),(822,90,'/m/s/ms11-yellow_main_1.jpg','image',0),(823,90,'/m/s/ms11-green_main_1.jpg','image',0),(824,90,'/m/s/ms11-green_back_1.jpg','image',0),(825,90,'/m/s/ms12-black_main_1.jpg','image',0),(826,90,'/m/s/ms12-blue_main_1.jpg','image',0),(827,90,'/m/s/ms12-red_main_1.jpg','image',0),(828,90,'/m/s/ms12-red_alt1_1.jpg','image',0),(829,90,'/m/s/ms12-red_back_1.jpg','image',0),(830,90,'/m/s/ms12-black_main_1.jpg','image',0),(831,90,'/m/s/ms12-blue_main_1.jpg','image',0),(832,90,'/m/s/ms12-red_main_1.jpg','image',0),(833,90,'/m/s/ms12-red_alt1_1.jpg','image',0),(834,90,'/m/s/ms12-red_back_1.jpg','image',0),(835,90,'/m/s/ms12-black_main_1.jpg','image',0),(836,90,'/m/s/ms12-blue_main_1.jpg','image',0),(837,90,'/m/s/ms12-red_main_1.jpg','image',0),(838,90,'/m/s/ms12-red_alt1_1.jpg','image',0),(839,90,'/m/s/ms12-red_back_1.jpg','image',0),(840,90,'/m/s/ms12-black_main_1.jpg','image',0),(841,90,'/m/s/ms12-blue_main_1.jpg','image',0),(842,90,'/m/s/ms12-red_main_1.jpg','image',0),(843,90,'/m/s/ms12-red_alt1_1.jpg','image',0),(844,90,'/m/s/ms12-red_back_1.jpg','image',0),(845,90,'/m/s/ms12-black_main_1.jpg','image',0),(846,90,'/m/s/ms12-blue_main_1.jpg','image',0),(847,90,'/m/s/ms12-red_main_1.jpg','image',0),(848,90,'/m/s/ms12-red_alt1_1.jpg','image',0),(849,90,'/m/s/ms12-red_back_1.jpg','image',0),(850,90,'/m/s/ms12-red_main_1.jpg','image',0),(851,90,'/m/s/ms12-red_alt1_1.jpg','image',0),(852,90,'/m/s/ms12-red_back_1.jpg','image',0),(853,90,'/m/s/ms03-gray_main_1.jpg','image',0),(854,90,'/m/s/ms03-gray_alt1_1.jpg','image',0),(855,90,'/m/s/ms03-gray_back_1.jpg','image',0),(856,90,'/m/s/ms03-green_main_1.jpg','image',0),(857,90,'/m/s/ms03-orange_main_1.jpg','image',0),(858,90,'/m/s/ms03-gray_main_1.jpg','image',0),(859,90,'/m/s/ms03-gray_alt1_1.jpg','image',0),(860,90,'/m/s/ms03-gray_back_1.jpg','image',0),(861,90,'/m/s/ms03-green_main_1.jpg','image',0),(862,90,'/m/s/ms03-orange_main_1.jpg','image',0),(863,90,'/m/s/ms03-gray_main_1.jpg','image',0),(864,90,'/m/s/ms03-gray_alt1_1.jpg','image',0),(865,90,'/m/s/ms03-gray_back_1.jpg','image',0),(866,90,'/m/s/ms03-green_main_1.jpg','image',0),(867,90,'/m/s/ms03-orange_main_1.jpg','image',0),(868,90,'/m/s/ms03-gray_main_1.jpg','image',0),(869,90,'/m/s/ms03-gray_alt1_1.jpg','image',0),(870,90,'/m/s/ms03-gray_back_1.jpg','image',0),(871,90,'/m/s/ms03-green_main_1.jpg','image',0),(872,90,'/m/s/ms03-orange_main_1.jpg','image',0),(873,90,'/m/s/ms03-gray_main_1.jpg','image',0),(874,90,'/m/s/ms03-gray_alt1_1.jpg','image',0),(875,90,'/m/s/ms03-gray_back_1.jpg','image',0),(876,90,'/m/s/ms03-green_main_1.jpg','image',0),(877,90,'/m/s/ms03-orange_main_1.jpg','image',0),(878,90,'/m/s/ms03-black_main_1.jpg','image',0),(879,90,'/m/s/ms03-black_back_1.jpg','image',0),(880,90,'/m/s/ms06-blue_main_1.jpg','image',0),(881,90,'/m/s/ms06-blue_alt1_1.jpg','image',0),(882,90,'/m/s/ms06-blue_back_1.jpg','image',0),(883,90,'/m/s/ms06-green_main_1.jpg','image',0),(884,90,'/m/s/ms06-yellow_main_1.jpg','image',0),(885,90,'/m/s/ms06-blue_main_1.jpg','image',0),(886,90,'/m/s/ms06-blue_alt1_1.jpg','image',0),(887,90,'/m/s/ms06-blue_back_1.jpg','image',0),(888,90,'/m/s/ms06-green_main_1.jpg','image',0),(889,90,'/m/s/ms06-yellow_main_1.jpg','image',0),(890,90,'/m/s/ms06-blue_main_1.jpg','image',0),(891,90,'/m/s/ms06-blue_alt1_1.jpg','image',0),(892,90,'/m/s/ms06-blue_back_1.jpg','image',0),(893,90,'/m/s/ms06-green_main_1.jpg','image',0),(894,90,'/m/s/ms06-yellow_main_1.jpg','image',0),(895,90,'/m/s/ms06-blue_main_1.jpg','image',0),(896,90,'/m/s/ms06-blue_alt1_1.jpg','image',0),(897,90,'/m/s/ms06-blue_back_1.jpg','image',0),(898,90,'/m/s/ms06-green_main_1.jpg','image',0),(899,90,'/m/s/ms06-yellow_main_1.jpg','image',0),(900,90,'/m/s/ms06-blue_main_1.jpg','image',0),(901,90,'/m/s/ms06-blue_alt1_1.jpg','image',0),(902,90,'/m/s/ms06-blue_back_1.jpg','image',0),(903,90,'/m/s/ms06-green_main_1.jpg','image',0),(904,90,'/m/s/ms06-yellow_main_1.jpg','image',0),(905,90,'/m/s/ms06-blue_main_1.jpg','image',0),(906,90,'/m/s/ms06-blue_alt1_1.jpg','image',0),(907,90,'/m/s/ms06-blue_back_1.jpg','image',0),(908,90,'/m/s/ms01-black_main_1.jpg','image',0),(909,90,'/m/s/ms01-brown_main_1.jpg','image',0),(910,90,'/m/s/ms01-brown_back_1.jpg','image',0),(911,90,'/m/s/ms01-yellow_main_1.jpg','image',0),(912,90,'/m/s/ms01-black_main_1.jpg','image',0),(913,90,'/m/s/ms01-brown_main_2.jpg','image',0),(914,90,'/m/s/ms01-brown_back_2.jpg','image',0),(915,90,'/m/s/ms01-yellow_main_2.jpg','image',0),(916,90,'/m/s/ms01-black_main_2.jpg','image',0),(917,90,'/m/s/ms01-brown_main_2.jpg','image',0),(918,90,'/m/s/ms01-brown_back_2.jpg','image',0),(919,90,'/m/s/ms01-yellow_main_2.jpg','image',0),(920,90,'/m/s/ms01-black_main_2.jpg','image',0),(921,90,'/m/s/ms01-brown_main_2.jpg','image',0),(922,90,'/m/s/ms01-brown_back_2.jpg','image',0),(923,90,'/m/s/ms01-yellow_main_2.jpg','image',0),(924,90,'/m/s/ms01-black_main_2.jpg','image',0),(925,90,'/m/s/ms01-brown_main_2.jpg','image',0),(926,90,'/m/s/ms01-brown_back_2.jpg','image',0),(927,90,'/m/s/ms01-yellow_main_2.jpg','image',0),(928,90,'/m/s/ms01-blue_main_1.jpg','image',0),(929,90,'/m/s/ms01-blue_back_1.jpg','image',0),(930,90,'/m/s/ms02-black_main_1.jpg','image',0),(931,90,'/m/s/ms02-blue_main_1.jpg','image',0),(932,90,'/m/s/ms02-gray_main_1.jpg','image',0),(933,90,'/m/s/ms02-gray_alt1_1.jpg','image',0),(934,90,'/m/s/ms02-gray_back_1.jpg','image',0),(935,90,'/m/s/ms02-black_main_1.jpg','image',0),(936,90,'/m/s/ms02-blue_main_1.jpg','image',0),(937,90,'/m/s/ms02-gray_main_1.jpg','image',0),(938,90,'/m/s/ms02-gray_alt1_1.jpg','image',0),(939,90,'/m/s/ms02-gray_back_1.jpg','image',0),(940,90,'/m/s/ms02-black_main_1.jpg','image',0),(941,90,'/m/s/ms02-blue_main_1.jpg','image',0),(942,90,'/m/s/ms02-gray_main_1.jpg','image',0),(943,90,'/m/s/ms02-gray_alt1_1.jpg','image',0),(944,90,'/m/s/ms02-gray_back_1.jpg','image',0),(945,90,'/m/s/ms02-black_main_1.jpg','image',0),(946,90,'/m/s/ms02-blue_main_1.jpg','image',0),(947,90,'/m/s/ms02-gray_main_1.jpg','image',0),(948,90,'/m/s/ms02-gray_alt1_1.jpg','image',0),(949,90,'/m/s/ms02-gray_back_1.jpg','image',0),(950,90,'/m/s/ms02-black_main_1.jpg','image',0),(951,90,'/m/s/ms02-blue_main_1.jpg','image',0),(952,90,'/m/s/ms02-gray_main_1.jpg','image',0),(953,90,'/m/s/ms02-gray_alt1_1.jpg','image',0),(954,90,'/m/s/ms02-gray_back_1.jpg','image',0),(955,90,'/m/s/ms02-gray_main_1.jpg','image',0),(956,90,'/m/s/ms02-gray_alt1_1.jpg','image',0),(957,90,'/m/s/ms02-gray_back_1.jpg','image',0),(958,90,'/m/s/ms10-black_main_1.jpg','image',0),(959,90,'/m/s/ms10-blue_main_1.jpg','image',0),(960,90,'/m/s/ms10-blue_alt1_1.jpg','image',0),(961,90,'/m/s/ms10-blue_back_1.jpg','image',0),(962,90,'/m/s/ms10-red_main_1.jpg','image',0),(963,90,'/m/s/ms10-black_main_1.jpg','image',0),(964,90,'/m/s/ms10-blue_main_1.jpg','image',0),(965,90,'/m/s/ms10-blue_alt1_1.jpg','image',0),(966,90,'/m/s/ms10-blue_back_1.jpg','image',0),(967,90,'/m/s/ms10-red_main_1.jpg','image',0),(968,90,'/m/s/ms10-black_main_1.jpg','image',0),(969,90,'/m/s/ms10-blue_main_1.jpg','image',0),(970,90,'/m/s/ms10-blue_alt1_1.jpg','image',0),(971,90,'/m/s/ms10-blue_back_1.jpg','image',0),(972,90,'/m/s/ms10-red_main_1.jpg','image',0),(973,90,'/m/s/ms10-black_main_1.jpg','image',0),(974,90,'/m/s/ms10-blue_main_1.jpg','image',0),(975,90,'/m/s/ms10-blue_alt1_1.jpg','image',0),(976,90,'/m/s/ms10-blue_back_1.jpg','image',0),(977,90,'/m/s/ms10-red_main_1.jpg','image',0),(978,90,'/m/s/ms10-black_main_1.jpg','image',0),(979,90,'/m/s/ms10-blue_main_1.jpg','image',0),(980,90,'/m/s/ms10-blue_alt1_1.jpg','image',0),(981,90,'/m/s/ms10-blue_back_1.jpg','image',0),(982,90,'/m/s/ms10-red_main_1.jpg','image',0),(983,90,'/m/s/ms10-blue_main_1.jpg','image',0),(984,90,'/m/s/ms10-blue_alt1_1.jpg','image',0),(985,90,'/m/s/ms10-blue_back_1.jpg','image',0),(986,90,'/m/s/ms07-black_main_1.jpg','image',0),(987,90,'/m/s/ms07-green_main_1.jpg','image',0),(988,90,'/m/s/ms07-green_alt1_1.jpg','image',0),(989,90,'/m/s/ms07-green_back_1.jpg','image',0),(990,90,'/m/s/ms07-white_main_1.jpg','image',0),(991,90,'/m/s/ms07-black_main_1.jpg','image',0),(992,90,'/m/s/ms07-green_main_1.jpg','image',0),(993,90,'/m/s/ms07-green_alt1_1.jpg','image',0),(994,90,'/m/s/ms07-green_back_1.jpg','image',0),(995,90,'/m/s/ms07-white_main_1.jpg','image',0),(996,90,'/m/s/ms07-black_main_1.jpg','image',0),(997,90,'/m/s/ms07-green_main_1.jpg','image',0),(998,90,'/m/s/ms07-green_alt1_1.jpg','image',0),(999,90,'/m/s/ms07-green_back_1.jpg','image',0),(1000,90,'/m/s/ms07-white_main_1.jpg','image',0),(1001,90,'/m/s/ms07-black_main_1.jpg','image',0),(1002,90,'/m/s/ms07-green_main_1.jpg','image',0),(1003,90,'/m/s/ms07-green_alt1_1.jpg','image',0),(1004,90,'/m/s/ms07-green_back_1.jpg','image',0),(1005,90,'/m/s/ms07-white_main_1.jpg','image',0),(1006,90,'/m/s/ms07-black_main_1.jpg','image',0),(1007,90,'/m/s/ms07-green_main_1.jpg','image',0),(1008,90,'/m/s/ms07-green_alt1_1.jpg','image',0),(1009,90,'/m/s/ms07-green_back_1.jpg','image',0),(1010,90,'/m/s/ms07-white_main_1.jpg','image',0),(1011,90,'/m/s/ms07-green_main_1.jpg','image',0),(1012,90,'/m/s/ms07-green_alt1_1.jpg','image',0),(1013,90,'/m/s/ms07-green_back_1.jpg','image',0),(1014,90,'/m/s/ms08-black_main_1.jpg','image',0),(1015,90,'/m/s/ms08-black_back_1.jpg','image',0),(1016,90,'/m/s/ms08-blue_main_1.jpg','image',0),(1017,90,'/m/s/ms08-red_main_1.jpg','image',0),(1018,90,'/m/s/ms08-black_main_1.jpg','image',0),(1019,90,'/m/s/ms08-black_back_1.jpg','image',0),(1020,90,'/m/s/ms08-blue_main_1.jpg','image',0),(1021,90,'/m/s/ms08-red_main_1.jpg','image',0),(1022,90,'/m/s/ms08-black_main_1.jpg','image',0),(1023,90,'/m/s/ms08-black_back_1.jpg','image',0),(1024,90,'/m/s/ms08-blue_main_1.jpg','image',0),(1025,90,'/m/s/ms08-red_main_1.jpg','image',0),(1026,90,'/m/s/ms08-black_main_1.jpg','image',0),(1027,90,'/m/s/ms08-black_back_1.jpg','image',0),(1028,90,'/m/s/ms08-blue_main_1.jpg','image',0),(1029,90,'/m/s/ms08-red_main_1.jpg','image',0),(1030,90,'/m/s/ms08-black_main_1.jpg','image',0),(1031,90,'/m/s/ms08-black_back_1.jpg','image',0),(1032,90,'/m/s/ms08-blue_main_1.jpg','image',0),(1033,90,'/m/s/ms08-red_main_1.jpg','image',0),(1034,90,'/m/s/ms08-black_main_1.jpg','image',0),(1035,90,'/m/s/ms08-black_back_1.jpg','image',0),(1036,90,'/m/t/mt01-gray_main_1.jpg','image',0),(1037,90,'/m/t/mt01-orange_main_1.jpg','image',0),(1038,90,'/m/t/mt01-red_main_1.jpg','image',0),(1039,90,'/m/t/mt01-red_alt1_1.jpg','image',0),(1040,90,'/m/t/mt01-red_back_1.jpg','image',0),(1041,90,'/m/t/mt01-gray_main_1.jpg','image',0),(1042,90,'/m/t/mt01-orange_main_1.jpg','image',0),(1043,90,'/m/t/mt01-red_main_1.jpg','image',0),(1044,90,'/m/t/mt01-red_alt1_1.jpg','image',0),(1045,90,'/m/t/mt01-red_back_1.jpg','image',0),(1046,90,'/m/t/mt01-gray_main_1.jpg','image',0),(1047,90,'/m/t/mt01-orange_main_1.jpg','image',0),(1048,90,'/m/t/mt01-red_main_1.jpg','image',0),(1049,90,'/m/t/mt01-red_alt1_1.jpg','image',0),(1050,90,'/m/t/mt01-red_back_1.jpg','image',0),(1051,90,'/m/t/mt01-gray_main_1.jpg','image',0),(1052,90,'/m/t/mt01-orange_main_1.jpg','image',0),(1053,90,'/m/t/mt01-red_main_1.jpg','image',0),(1054,90,'/m/t/mt01-red_alt1_1.jpg','image',0),(1055,90,'/m/t/mt01-red_back_1.jpg','image',0),(1056,90,'/m/t/mt01-gray_main_1.jpg','image',0),(1057,90,'/m/t/mt01-orange_main_1.jpg','image',0),(1058,90,'/m/t/mt01-red_main_1.jpg','image',0),(1059,90,'/m/t/mt01-red_alt1_1.jpg','image',0),(1060,90,'/m/t/mt01-red_back_1.jpg','image',0),(1061,90,'/m/t/mt01-red_main_1.jpg','image',0),(1062,90,'/m/t/mt01-red_alt1_1.jpg','image',0),(1063,90,'/m/t/mt01-red_back_1.jpg','image',0),(1064,90,'/m/t/mt02-gray_main_1.jpg','image',0),(1065,90,'/m/t/mt02-red_main_1.jpg','image',0),(1066,90,'/m/t/mt02-white_main_1.jpg','image',0),(1067,90,'/m/t/mt02-white_alt1_1.jpg','image',0),(1068,90,'/m/t/mt02-white_back_1.jpg','image',0),(1069,90,'/m/t/mt02-white_sideb_1.jpg','image',0),(1070,90,'/m/t/mt02-gray_main_1.jpg','image',0),(1071,90,'/m/t/mt02-red_main_1.jpg','image',0),(1072,90,'/m/t/mt02-white_main_1.jpg','image',0),(1073,90,'/m/t/mt02-white_alt1_1.jpg','image',0),(1074,90,'/m/t/mt02-white_back_1.jpg','image',0),(1075,90,'/m/t/mt02-white_sideb_1.jpg','image',0),(1076,90,'/m/t/mt02-gray_main_1.jpg','image',0),(1077,90,'/m/t/mt02-red_main_1.jpg','image',0),(1078,90,'/m/t/mt02-white_main_2.jpg','image',0),(1079,90,'/m/t/mt02-white_alt1_2.jpg','image',0),(1080,90,'/m/t/mt02-white_back_2.jpg','image',0),(1081,90,'/m/t/mt02-white_sideb_2.jpg','image',0),(1082,90,'/m/t/mt02-gray_main_2.jpg','image',0),(1083,90,'/m/t/mt02-red_main_2.jpg','image',0),(1084,90,'/m/t/mt02-white_main_2.jpg','image',0),(1085,90,'/m/t/mt02-white_alt1_2.jpg','image',0),(1086,90,'/m/t/mt02-white_back_2.jpg','image',0),(1087,90,'/m/t/mt02-white_sideb_2.jpg','image',0),(1088,90,'/m/t/mt02-gray_main_2.jpg','image',0),(1089,90,'/m/t/mt02-red_main_2.jpg','image',0),(1090,90,'/m/t/mt02-white_main_2.jpg','image',0),(1091,90,'/m/t/mt02-white_alt1_2.jpg','image',0),(1092,90,'/m/t/mt02-white_back_2.jpg','image',0),(1093,90,'/m/t/mt02-white_sideb_2.jpg','image',0),(1094,90,'/m/t/mt02-white_main_2.jpg','image',0),(1095,90,'/m/t/mt02-white_alt1_2.jpg','image',0),(1096,90,'/m/t/mt02-white_back_2.jpg','image',0),(1097,90,'/m/t/mt02-white_sideb_2.jpg','image',0),(1098,90,'/m/t/mt03-blue_main_1.jpg','image',0),(1099,90,'/m/t/mt03-red_main_1.jpg','image',0),(1100,90,'/m/t/mt03-yellow_main_1.jpg','image',0),(1101,90,'/m/t/mt03-blue_main_1.jpg','image',0),(1102,90,'/m/t/mt03-red_main_1.jpg','image',0),(1103,90,'/m/t/mt03-yellow_main_1.jpg','image',0),(1104,90,'/m/t/mt03-blue_main_1.jpg','image',0),(1105,90,'/m/t/mt03-red_main_1.jpg','image',0),(1106,90,'/m/t/mt03-yellow_main_1.jpg','image',0),(1107,90,'/m/t/mt03-blue_main_1.jpg','image',0),(1108,90,'/m/t/mt03-red_main_1.jpg','image',0),(1109,90,'/m/t/mt03-yellow_main_1.jpg','image',0),(1110,90,'/m/t/mt03-blue_main_1.jpg','image',0),(1111,90,'/m/t/mt03-red_main_1.jpg','image',0),(1112,90,'/m/t/mt03-yellow_main_1.jpg','image',0),(1113,90,'/m/t/mt03-red_main_1.jpg','image',0),(1114,90,'/m/t/mt04-blue_main_1.jpg','image',0),(1115,90,'/m/t/mt04-blue_alt1_1.jpg','image',0),(1116,90,'/m/t/mt04-blue_back_1.jpg','image',0),(1117,90,'/m/t/mt04-blue_main_1.jpg','image',0),(1118,90,'/m/t/mt04-blue_alt1_1.jpg','image',0),(1119,90,'/m/t/mt04-blue_back_1.jpg','image',0),(1120,90,'/m/t/mt04-blue_main_1.jpg','image',0),(1121,90,'/m/t/mt04-blue_alt1_1.jpg','image',0),(1122,90,'/m/t/mt04-blue_back_1.jpg','image',0),(1123,90,'/m/t/mt04-blue_main_1.jpg','image',0),(1124,90,'/m/t/mt04-blue_alt1_1.jpg','image',0),(1125,90,'/m/t/mt04-blue_back_1.jpg','image',0),(1126,90,'/m/t/mt04-blue_main_1.jpg','image',0),(1127,90,'/m/t/mt04-blue_alt1_1.jpg','image',0),(1128,90,'/m/t/mt04-blue_back_1.jpg','image',0),(1129,90,'/m/t/mt04-blue_main_1.jpg','image',0),(1130,90,'/m/t/mt04-blue_alt1_1.jpg','image',0),(1131,90,'/m/t/mt04-blue_back_1.jpg','image',0),(1132,90,'/m/t/mt05-blue_main_1.jpg','image',0),(1133,90,'/m/t/mt05-blue_back_1.jpg','image',0),(1134,90,'/m/t/mt05-blue_main_1.jpg','image',0),(1135,90,'/m/t/mt05-blue_back_1.jpg','image',0),(1136,90,'/m/t/mt05-blue_main_1.jpg','image',0),(1137,90,'/m/t/mt05-blue_back_1.jpg','image',0),(1138,90,'/m/t/mt05-blue_main_1.jpg','image',0),(1139,90,'/m/t/mt05-blue_back_1.jpg','image',0),(1140,90,'/m/t/mt05-blue_main_1.jpg','image',0),(1141,90,'/m/t/mt05-blue_back_1.jpg','image',0),(1142,90,'/m/t/mt05-blue_main_1.jpg','image',0),(1143,90,'/m/t/mt05-blue_back_1.jpg','image',0),(1144,90,'/m/t/mt06-black_main_1.jpg','image',0),(1145,90,'/m/t/mt06-black_back_1.jpg','image',0),(1146,90,'/m/t/mt06-black_main_1.jpg','image',0),(1147,90,'/m/t/mt06-black_back_1.jpg','image',0),(1148,90,'/m/t/mt06-black_main_1.jpg','image',0),(1149,90,'/m/t/mt06-black_back_1.jpg','image',0),(1150,90,'/m/t/mt06-black_main_1.jpg','image',0),(1151,90,'/m/t/mt06-black_back_1.jpg','image',0),(1152,90,'/m/t/mt06-black_main_1.jpg','image',0),(1153,90,'/m/t/mt06-black_back_1.jpg','image',0),(1154,90,'/m/t/mt06-black_main_1.jpg','image',0),(1155,90,'/m/t/mt06-black_back_1.jpg','image',0),(1156,90,'/m/t/mt07-gray_main_1.jpg','image',0),(1157,90,'/m/t/mt07-gray_back_1.jpg','image',0),(1158,90,'/m/t/mt07-gray_main_1.jpg','image',0),(1159,90,'/m/t/mt07-gray_back_1.jpg','image',0),(1160,90,'/m/t/mt07-gray_main_1.jpg','image',0),(1161,90,'/m/t/mt07-gray_back_1.jpg','image',0),(1162,90,'/m/t/mt07-gray_main_1.jpg','image',0),(1163,90,'/m/t/mt07-gray_back_1.jpg','image',0),(1164,90,'/m/t/mt07-gray_main_1.jpg','image',0),(1165,90,'/m/t/mt07-gray_back_1.jpg','image',0),(1166,90,'/m/t/mt07-gray_main_1.jpg','image',0),(1167,90,'/m/t/mt07-gray_back_1.jpg','image',0),(1168,90,'/m/t/mt08-green_main_1.jpg','image',0),(1169,90,'/m/t/mt08-green_alt1_1.jpg','image',0),(1170,90,'/m/t/mt08-green_back_1.jpg','image',0),(1171,90,'/m/t/mt08-green_main_1.jpg','image',0),(1172,90,'/m/t/mt08-green_alt1_1.jpg','image',0),(1173,90,'/m/t/mt08-green_back_1.jpg','image',0),(1174,90,'/m/t/mt08-green_main_1.jpg','image',0),(1175,90,'/m/t/mt08-green_alt1_1.jpg','image',0),(1176,90,'/m/t/mt08-green_back_1.jpg','image',0),(1177,90,'/m/t/mt08-green_main_1.jpg','image',0),(1178,90,'/m/t/mt08-green_alt1_1.jpg','image',0),(1179,90,'/m/t/mt08-green_back_1.jpg','image',0),(1180,90,'/m/t/mt08-green_main_1.jpg','image',0),(1181,90,'/m/t/mt08-green_alt1_1.jpg','image',0),(1182,90,'/m/t/mt08-green_back_1.jpg','image',0),(1183,90,'/m/t/mt08-green_main_1.jpg','image',0),(1184,90,'/m/t/mt08-green_alt1_1.jpg','image',0),(1185,90,'/m/t/mt08-green_back_1.jpg','image',0),(1186,90,'/m/t/mt09-blue_main_1.jpg','image',0),(1187,90,'/m/t/mt09-blue_alt1_1.jpg','image',0),(1188,90,'/m/t/mt09-blue_back_1.jpg','image',0),(1189,90,'/m/t/mt09-blue_main_1.jpg','image',0),(1190,90,'/m/t/mt09-blue_alt1_1.jpg','image',0),(1191,90,'/m/t/mt09-blue_back_1.jpg','image',0),(1192,90,'/m/t/mt09-blue_main_1.jpg','image',0),(1193,90,'/m/t/mt09-blue_alt1_1.jpg','image',0),(1194,90,'/m/t/mt09-blue_back_1.jpg','image',0),(1195,90,'/m/t/mt09-blue_main_1.jpg','image',0),(1196,90,'/m/t/mt09-blue_alt1_1.jpg','image',0),(1197,90,'/m/t/mt09-blue_back_1.jpg','image',0),(1198,90,'/m/t/mt09-blue_main_1.jpg','image',0),(1199,90,'/m/t/mt09-blue_alt1_1.jpg','image',0),(1200,90,'/m/t/mt09-blue_back_1.jpg','image',0),(1201,90,'/m/t/mt09-blue_main_1.jpg','image',0),(1202,90,'/m/t/mt09-blue_alt1_1.jpg','image',0),(1203,90,'/m/t/mt09-blue_back_1.jpg','image',0),(1204,90,'/m/t/mt10-yellow_main_1.jpg','image',0),(1205,90,'/m/t/mt10-yellow_back_1.jpg','image',0),(1206,90,'/m/t/mt10-yellow_main_1.jpg','image',0),(1207,90,'/m/t/mt10-yellow_back_1.jpg','image',0),(1208,90,'/m/t/mt10-yellow_main_1.jpg','image',0),(1209,90,'/m/t/mt10-yellow_back_1.jpg','image',0),(1210,90,'/m/t/mt10-yellow_main_1.jpg','image',0),(1211,90,'/m/t/mt10-yellow_back_1.jpg','image',0),(1212,90,'/m/t/mt10-yellow_main_1.jpg','image',0),(1213,90,'/m/t/mt10-yellow_back_1.jpg','image',0),(1214,90,'/m/t/mt10-yellow_main_1.jpg','image',0),(1215,90,'/m/t/mt10-yellow_back_1.jpg','image',0),(1216,90,'/m/t/mt11-blue_main_1.jpg','image',0),(1217,90,'/m/t/mt11-blue_back_1.jpg','image',0),(1218,90,'/m/t/mt11-blue_main_1.jpg','image',0),(1219,90,'/m/t/mt11-blue_back_1.jpg','image',0),(1220,90,'/m/t/mt11-blue_main_1.jpg','image',0),(1221,90,'/m/t/mt11-blue_back_1.jpg','image',0),(1222,90,'/m/t/mt11-blue_main_1.jpg','image',0),(1223,90,'/m/t/mt11-blue_back_1.jpg','image',0),(1224,90,'/m/t/mt11-blue_main_1.jpg','image',0),(1225,90,'/m/t/mt11-blue_back_1.jpg','image',0),(1226,90,'/m/t/mt11-blue_main_1.jpg','image',0),(1227,90,'/m/t/mt11-blue_back_1.jpg','image',0),(1228,90,'/m/t/mt12-blue_main_1.jpg','image',0),(1229,90,'/m/t/mt12-blue_back_1.jpg','image',0),(1230,90,'/m/t/mt12-blue_main_1.jpg','image',0),(1231,90,'/m/t/mt12-blue_back_1.jpg','image',0),(1232,90,'/m/t/mt12-blue_main_1.jpg','image',0),(1233,90,'/m/t/mt12-blue_back_1.jpg','image',0),(1234,90,'/m/t/mt12-blue_main_1.jpg','image',0),(1235,90,'/m/t/mt12-blue_back_1.jpg','image',0),(1236,90,'/m/t/mt12-blue_main_1.jpg','image',0),(1237,90,'/m/t/mt12-blue_back_1.jpg','image',0),(1238,90,'/m/t/mt12-blue_main_1.jpg','image',0),(1239,90,'/m/t/mt12-blue_back_1.jpg','image',0),(1240,90,'/m/p/mp01-black_main_1.jpg','image',0),(1241,90,'/m/p/mp01-gray_main_1.jpg','image',0),(1242,90,'/m/p/mp01-gray_back_1.jpg','image',0),(1243,90,'/m/p/mp01-purple_main_1.jpg','image',0),(1244,90,'/m/p/mp01-black_main_1.jpg','image',0),(1245,90,'/m/p/mp01-gray_main_1.jpg','image',0),(1246,90,'/m/p/mp01-gray_back_1.jpg','image',0),(1247,90,'/m/p/mp01-purple_main_1.jpg','image',0),(1248,90,'/m/p/mp01-black_main_1.jpg','image',0),(1249,90,'/m/p/mp01-gray_main_1.jpg','image',0),(1250,90,'/m/p/mp01-gray_back_1.jpg','image',0),(1251,90,'/m/p/mp01-purple_main_1.jpg','image',0),(1252,90,'/m/p/mp01-black_main_1.jpg','image',0),(1253,90,'/m/p/mp01-gray_main_1.jpg','image',0),(1254,90,'/m/p/mp01-gray_back_1.jpg','image',0),(1255,90,'/m/p/mp01-purple_main_1.jpg','image',0),(1256,90,'/m/p/mp01-gray_main_1.jpg','image',0),(1257,90,'/m/p/mp01-gray_back_1.jpg','image',0),(1258,90,'/m/p/mp02-blue_main_1.jpg','image',0),(1259,90,'/m/p/mp02-gray_main_1.jpg','image',0),(1260,90,'/m/p/mp02-gray_back_1.jpg','image',0),(1261,90,'/m/p/mp02-red_main_1.jpg','image',0),(1262,90,'/m/p/mp02-blue_main_1.jpg','image',0),(1263,90,'/m/p/mp02-gray_main_1.jpg','image',0),(1264,90,'/m/p/mp02-gray_back_1.jpg','image',0),(1265,90,'/m/p/mp02-red_main_1.jpg','image',0),(1266,90,'/m/p/mp02-blue_main_1.jpg','image',0),(1267,90,'/m/p/mp02-gray_main_1.jpg','image',0),(1268,90,'/m/p/mp02-gray_back_1.jpg','image',0),(1269,90,'/m/p/mp02-red_main_1.jpg','image',0),(1270,90,'/m/p/mp02-blue_main_2.jpg','image',0),(1271,90,'/m/p/mp02-gray_main_2.jpg','image',0),(1272,90,'/m/p/mp02-gray_back_2.jpg','image',0),(1273,90,'/m/p/mp02-red_main_2.jpg','image',0),(1274,90,'/m/p/mp02-gray_main_2.jpg','image',0),(1275,90,'/m/p/mp02-gray_back_2.jpg','image',0),(1276,90,'/m/p/mp03-blue_main_1.jpg','image',0),(1277,90,'/m/p/mp03-green_main_1.jpg','image',0),(1278,90,'/m/p/mp03-red_main_1.jpg','image',0),(1279,90,'/m/p/mp03-blue_main_1.jpg','image',0),(1280,90,'/m/p/mp03-green_main_1.jpg','image',0),(1281,90,'/m/p/mp03-red_main_1.jpg','image',0),(1282,90,'/m/p/mp03-blue_main_1.jpg','image',0),(1283,90,'/m/p/mp03-green_main_1.jpg','image',0),(1284,90,'/m/p/mp03-red_main_1.jpg','image',0),(1285,90,'/m/p/mp03-blue_main_1.jpg','image',0),(1286,90,'/m/p/mp03-green_main_1.jpg','image',0),(1287,90,'/m/p/mp03-red_main_1.jpg','image',0),(1288,90,'/m/p/mp03-black_main_1.jpg','image',0),(1289,90,'/m/p/mp03-black_alt1_1.jpg','image',0),(1290,90,'/m/p/mp03-black_back_1.jpg','image',0),(1291,90,'/m/p/mp04-black_main_1.jpg','image',0),(1292,90,'/m/p/mp04-gray_main_1.jpg','image',0),(1293,90,'/m/p/mp04-gray_back_1.jpg','image',0),(1294,90,'/m/p/mp04-green_main_1.jpg','image',0),(1295,90,'/m/p/mp04-black_main_1.jpg','image',0),(1296,90,'/m/p/mp04-gray_main_1.jpg','image',0),(1297,90,'/m/p/mp04-gray_back_1.jpg','image',0),(1298,90,'/m/p/mp04-green_main_1.jpg','image',0),(1299,90,'/m/p/mp04-black_main_1.jpg','image',0),(1300,90,'/m/p/mp04-gray_main_1.jpg','image',0),(1301,90,'/m/p/mp04-gray_back_1.jpg','image',0),(1302,90,'/m/p/mp04-green_main_1.jpg','image',0),(1303,90,'/m/p/mp04-black_main_1.jpg','image',0),(1304,90,'/m/p/mp04-gray_main_1.jpg','image',0),(1305,90,'/m/p/mp04-gray_back_1.jpg','image',0),(1306,90,'/m/p/mp04-green_main_1.jpg','image',0),(1307,90,'/m/p/mp04-gray_main_1.jpg','image',0),(1308,90,'/m/p/mp04-gray_back_1.jpg','image',0),(1309,90,'/m/p/mp05-black_main_1.jpg','image',0),(1310,90,'/m/p/mp05-blue_main_1.jpg','image',0),(1311,90,'/m/p/mp05-blue_back_1.jpg','image',0),(1312,90,'/m/p/mp05-blue_outfit_1.jpg','image',0),(1313,90,'/m/p/mp05-green_main_1.jpg','image',0),(1314,90,'/m/p/mp05-black_main_1.jpg','image',0),(1315,90,'/m/p/mp05-blue_main_1.jpg','image',0),(1316,90,'/m/p/mp05-blue_back_1.jpg','image',0),(1317,90,'/m/p/mp05-blue_outfit_1.jpg','image',0),(1318,90,'/m/p/mp05-green_main_1.jpg','image',0),(1319,90,'/m/p/mp05-black_main_1.jpg','image',0),(1320,90,'/m/p/mp05-blue_main_1.jpg','image',0),(1321,90,'/m/p/mp05-blue_back_1.jpg','image',0),(1322,90,'/m/p/mp05-blue_outfit_1.jpg','image',0),(1323,90,'/m/p/mp05-green_main_1.jpg','image',0),(1324,90,'/m/p/mp05-black_main_1.jpg','image',0),(1325,90,'/m/p/mp05-blue_main_1.jpg','image',0),(1326,90,'/m/p/mp05-blue_back_1.jpg','image',0),(1327,90,'/m/p/mp05-blue_outfit_1.jpg','image',0),(1328,90,'/m/p/mp05-green_main_1.jpg','image',0),(1329,90,'/m/p/mp05-blue_main_1.jpg','image',0),(1330,90,'/m/p/mp05-blue_back_1.jpg','image',0),(1331,90,'/m/p/mp05-blue_outfit_1.jpg','image',0),(1332,90,'/m/p/mp06-gray_main_1.jpg','image',0),(1333,90,'/m/p/mp06-gray_back_1.jpg','image',0),(1334,90,'/m/p/mp06-gray_outfit_1.jpg','image',0),(1335,90,'/m/p/mp06-green_main_1.jpg','image',0),(1336,90,'/m/p/mp06-orange_main_1.jpg','image',0),(1337,90,'/m/p/mp06-gray_main_1.jpg','image',0),(1338,90,'/m/p/mp06-gray_back_1.jpg','image',0),(1339,90,'/m/p/mp06-gray_outfit_1.jpg','image',0),(1340,90,'/m/p/mp06-green_main_1.jpg','image',0),(1341,90,'/m/p/mp06-orange_main_1.jpg','image',0),(1342,90,'/m/p/mp06-gray_main_1.jpg','image',0),(1343,90,'/m/p/mp06-gray_back_1.jpg','image',0),(1344,90,'/m/p/mp06-gray_outfit_1.jpg','image',0),(1345,90,'/m/p/mp06-green_main_1.jpg','image',0),(1346,90,'/m/p/mp06-orange_main_1.jpg','image',0),(1347,90,'/m/p/mp06-gray_main_1.jpg','image',0),(1348,90,'/m/p/mp06-gray_back_1.jpg','image',0),(1349,90,'/m/p/mp06-gray_outfit_1.jpg','image',0),(1350,90,'/m/p/mp06-green_main_1.jpg','image',0),(1351,90,'/m/p/mp06-orange_main_1.jpg','image',0),(1352,90,'/m/p/mp06-gray_main_1.jpg','image',0),(1353,90,'/m/p/mp06-gray_back_1.jpg','image',0),(1354,90,'/m/p/mp06-gray_outfit_1.jpg','image',0),(1355,90,'/m/p/mp07-black_main_1.jpg','image',0),(1356,90,'/m/p/mp07-blue_main_1.jpg','image',0),(1357,90,'/m/p/mp07-blue_alt1_1.jpg','image',0),(1358,90,'/m/p/mp07-blue_back_1.jpg','image',0),(1359,90,'/m/p/mp07-blue_side_a_1.jpg','image',0),(1360,90,'/m/p/mp07-blue_side_b_1.jpg','image',0),(1361,90,'/m/p/mp07-purple_main_1.jpg','image',0),(1362,90,'/m/p/mp07-black_main_1.jpg','image',0),(1363,90,'/m/p/mp07-blue_main_1.jpg','image',0),(1364,90,'/m/p/mp07-blue_alt1_1.jpg','image',0),(1365,90,'/m/p/mp07-blue_back_1.jpg','image',0),(1366,90,'/m/p/mp07-blue_side_a_1.jpg','image',0),(1367,90,'/m/p/mp07-blue_side_b_1.jpg','image',0),(1368,90,'/m/p/mp07-purple_main_1.jpg','image',0),(1369,90,'/m/p/mp07-black_main_1.jpg','image',0),(1370,90,'/m/p/mp07-blue_main_1.jpg','image',0),(1371,90,'/m/p/mp07-blue_alt1_1.jpg','image',0),(1372,90,'/m/p/mp07-blue_back_1.jpg','image',0),(1373,90,'/m/p/mp07-blue_side_a_1.jpg','image',0),(1374,90,'/m/p/mp07-blue_side_b_1.jpg','image',0),(1375,90,'/m/p/mp07-purple_main_1.jpg','image',0),(1376,90,'/m/p/mp07-black_main_1.jpg','image',0),(1377,90,'/m/p/mp07-blue_main_1.jpg','image',0),(1378,90,'/m/p/mp07-blue_alt1_1.jpg','image',0),(1379,90,'/m/p/mp07-blue_back_1.jpg','image',0),(1380,90,'/m/p/mp07-blue_side_a_1.jpg','image',0),(1381,90,'/m/p/mp07-blue_side_b_1.jpg','image',0),(1382,90,'/m/p/mp07-purple_main_1.jpg','image',0),(1383,90,'/m/p/mp07-blue_main_1.jpg','image',0),(1384,90,'/m/p/mp07-blue_alt1_1.jpg','image',0),(1385,90,'/m/p/mp07-blue_back_1.jpg','image',0),(1386,90,'/m/p/mp07-blue_side_a_1.jpg','image',0),(1387,90,'/m/p/mp07-blue_side_b_1.jpg','image',0),(1388,90,'/m/p/mp08-blue_main_1.jpg','image',0),(1389,90,'/m/p/mp08-green_main_1.jpg','image',0),(1390,90,'/m/p/mp08-green_alt1_1.jpg','image',0),(1391,90,'/m/p/mp08-green_back_1.jpg','image',0),(1392,90,'/m/p/mp08-red_main_1.jpg','image',0),(1393,90,'/m/p/mp08-blue_main_1.jpg','image',0),(1394,90,'/m/p/mp08-green_main_1.jpg','image',0),(1395,90,'/m/p/mp08-green_alt1_1.jpg','image',0),(1396,90,'/m/p/mp08-green_back_1.jpg','image',0),(1397,90,'/m/p/mp08-red_main_1.jpg','image',0),(1398,90,'/m/p/mp08-blue_main_1.jpg','image',0),(1399,90,'/m/p/mp08-green_main_1.jpg','image',0),(1400,90,'/m/p/mp08-green_alt1_1.jpg','image',0),(1401,90,'/m/p/mp08-green_back_1.jpg','image',0),(1402,90,'/m/p/mp08-red_main_1.jpg','image',0),(1403,90,'/m/p/mp08-blue_main_1.jpg','image',0),(1404,90,'/m/p/mp08-green_main_1.jpg','image',0),(1405,90,'/m/p/mp08-green_alt1_1.jpg','image',0),(1406,90,'/m/p/mp08-green_back_1.jpg','image',0),(1407,90,'/m/p/mp08-red_main_1.jpg','image',0),(1408,90,'/m/p/mp08-green_main_1.jpg','image',0),(1409,90,'/m/p/mp08-green_alt1_1.jpg','image',0),(1410,90,'/m/p/mp08-green_back_1.jpg','image',0),(1411,90,'/m/p/mp09-black_main_1.jpg','image',0),(1412,90,'/m/p/mp09-blue_main_1.jpg','image',0),(1413,90,'/m/p/mp09-blue_alt1_1.jpg','image',0),(1414,90,'/m/p/mp09-blue_back_1.jpg','image',0),(1415,90,'/m/p/mp09-red_main_1.jpg','image',0),(1416,90,'/m/p/mp09-black_main_1.jpg','image',0),(1417,90,'/m/p/mp09-blue_main_1.jpg','image',0),(1418,90,'/m/p/mp09-blue_alt1_1.jpg','image',0),(1419,90,'/m/p/mp09-blue_back_1.jpg','image',0),(1420,90,'/m/p/mp09-red_main_1.jpg','image',0),(1421,90,'/m/p/mp09-black_main_1.jpg','image',0),(1422,90,'/m/p/mp09-blue_main_1.jpg','image',0),(1423,90,'/m/p/mp09-blue_alt1_1.jpg','image',0),(1424,90,'/m/p/mp09-blue_back_1.jpg','image',0),(1425,90,'/m/p/mp09-red_main_1.jpg','image',0),(1426,90,'/m/p/mp09-black_main_1.jpg','image',0),(1427,90,'/m/p/mp09-blue_main_1.jpg','image',0),(1428,90,'/m/p/mp09-blue_alt1_1.jpg','image',0),(1429,90,'/m/p/mp09-blue_back_1.jpg','image',0),(1430,90,'/m/p/mp09-red_main_1.jpg','image',0),(1431,90,'/m/p/mp09-blue_main_1.jpg','image',0),(1432,90,'/m/p/mp09-blue_alt1_1.jpg','image',0),(1433,90,'/m/p/mp09-blue_back_1.jpg','image',0),(1434,90,'/m/p/mp10-black_main_1.jpg','image',0),(1435,90,'/m/p/mp10-black_alt1_1.jpg','image',0),(1436,90,'/m/p/mp10-black_back_1.jpg','image',0),(1437,90,'/m/p/mp10-blue_main_1.jpg','image',0),(1438,90,'/m/p/mp10-green_main_1.jpg','image',0),(1439,90,'/m/p/mp10-black_main_1.jpg','image',0),(1440,90,'/m/p/mp10-black_alt1_1.jpg','image',0),(1441,90,'/m/p/mp10-black_back_1.jpg','image',0),(1442,90,'/m/p/mp10-blue_main_1.jpg','image',0),(1443,90,'/m/p/mp10-green_main_2.jpg','image',0),(1444,90,'/m/p/mp10-black_main_2.jpg','image',0),(1445,90,'/m/p/mp10-black_alt1_2.jpg','image',0),(1446,90,'/m/p/mp10-black_back_2.jpg','image',0),(1447,90,'/m/p/mp10-blue_main_2.jpg','image',0),(1448,90,'/m/p/mp10-green_main_2.jpg','image',0),(1449,90,'/m/p/mp10-black_main_2.jpg','image',0),(1450,90,'/m/p/mp10-black_alt1_2.jpg','image',0),(1451,90,'/m/p/mp10-black_back_2.jpg','image',0),(1452,90,'/m/p/mp10-blue_main_2.jpg','image',0),(1453,90,'/m/p/mp10-green_main_2.jpg','image',0),(1454,90,'/m/p/mp10-black_main_2.jpg','image',0),(1455,90,'/m/p/mp10-black_alt1_2.jpg','image',0),(1456,90,'/m/p/mp10-black_back_2.jpg','image',0),(1457,90,'/m/p/mp11-blue_main_1.jpg','image',0),(1458,90,'/m/p/mp11-brown_main_1.jpg','image',0),(1459,90,'/m/p/mp11-brown_alt1_1.jpg','image',0),(1460,90,'/m/p/mp11-brown_back_1.jpg','image',0),(1461,90,'/m/p/mp11-green_main_1.jpg','image',0),(1462,90,'/m/p/mp11-blue_main_1.jpg','image',0),(1463,90,'/m/p/mp11-brown_main_1.jpg','image',0),(1464,90,'/m/p/mp11-brown_alt1_1.jpg','image',0),(1465,90,'/m/p/mp11-brown_back_1.jpg','image',0),(1466,90,'/m/p/mp11-green_main_1.jpg','image',0),(1467,90,'/m/p/mp11-blue_main_1.jpg','image',0),(1468,90,'/m/p/mp11-brown_main_1.jpg','image',0),(1469,90,'/m/p/mp11-brown_alt1_1.jpg','image',0),(1470,90,'/m/p/mp11-brown_back_1.jpg','image',0),(1471,90,'/m/p/mp11-green_main_1.jpg','image',0),(1472,90,'/m/p/mp11-blue_main_1.jpg','image',0),(1473,90,'/m/p/mp11-brown_main_1.jpg','image',0),(1474,90,'/m/p/mp11-brown_alt1_1.jpg','image',0),(1475,90,'/m/p/mp11-brown_back_1.jpg','image',0),(1476,90,'/m/p/mp11-green_main_1.jpg','image',0),(1477,90,'/m/p/mp11-brown_main_1.jpg','image',0),(1478,90,'/m/p/mp11-brown_alt1_1.jpg','image',0),(1479,90,'/m/p/mp11-brown_back_1.jpg','image',0),(1480,90,'/m/p/mp12-black_main_1.jpg','image',0),(1481,90,'/m/p/mp12-black_back_1.jpg','image',0),(1482,90,'/m/p/mp12-blue_main_1.jpg','image',0),(1483,90,'/m/p/mp12-red_main_1.jpg','image',0),(1484,90,'/m/p/mp12-black_main_1.jpg','image',0),(1485,90,'/m/p/mp12-black_back_1.jpg','image',0),(1486,90,'/m/p/mp12-blue_main_1.jpg','image',0),(1487,90,'/m/p/mp12-red_main_1.jpg','image',0),(1488,90,'/m/p/mp12-black_main_1.jpg','image',0),(1489,90,'/m/p/mp12-black_back_1.jpg','image',0),(1490,90,'/m/p/mp12-blue_main_1.jpg','image',0),(1491,90,'/m/p/mp12-red_main_1.jpg','image',0),(1492,90,'/m/p/mp12-black_main_1.jpg','image',0),(1493,90,'/m/p/mp12-black_back_1.jpg','image',0),(1494,90,'/m/p/mp12-blue_main_1.jpg','image',0),(1495,90,'/m/p/mp12-red_main_1.jpg','image',0),(1496,90,'/m/p/mp12-black_main_1.jpg','image',0),(1497,90,'/m/p/mp12-black_back_1.jpg','image',0),(1498,90,'/m/s/msh01-black_main_1.jpg','image',0),(1499,90,'/m/s/msh01-blue_main_1.jpg','image',0),(1500,90,'/m/s/msh01-blue_back_1.jpg','image',0),(1501,90,'/m/s/msh01-red_main_1.jpg','image',0),(1502,90,'/m/s/msh01-black_main_1.jpg','image',0),(1503,90,'/m/s/msh01-blue_main_1.jpg','image',0),(1504,90,'/m/s/msh01-blue_back_1.jpg','image',0),(1505,90,'/m/s/msh01-red_main_1.jpg','image',0),(1506,90,'/m/s/msh01-black_main_1.jpg','image',0),(1507,90,'/m/s/msh01-blue_main_1.jpg','image',0),(1508,90,'/m/s/msh01-blue_back_1.jpg','image',0),(1509,90,'/m/s/msh01-red_main_1.jpg','image',0),(1510,90,'/m/s/msh01-black_main_1.jpg','image',0),(1511,90,'/m/s/msh01-blue_main_1.jpg','image',0),(1512,90,'/m/s/msh01-blue_back_1.jpg','image',0),(1513,90,'/m/s/msh01-red_main_1.jpg','image',0),(1514,90,'/m/s/msh01-blue_main_1.jpg','image',0),(1515,90,'/m/s/msh01-blue_back_1.jpg','image',0),(1516,90,'/m/s/msh02-black_main_1.jpg','image',0),(1517,90,'/m/s/msh02-black_alt1_1.jpg','image',0),(1518,90,'/m/s/msh02-black_back_1.jpg','image',0),(1519,90,'/m/s/msh02-black_main_1.jpg','image',0),(1520,90,'/m/s/msh02-black_alt1_1.jpg','image',0),(1521,90,'/m/s/msh02-black_back_1.jpg','image',0),(1522,90,'/m/s/msh02-black_main_1.jpg','image',0),(1523,90,'/m/s/msh02-black_alt1_1.jpg','image',0),(1524,90,'/m/s/msh02-black_back_1.jpg','image',0),(1525,90,'/m/s/msh02-black_main_1.jpg','image',0),(1526,90,'/m/s/msh02-black_alt1_1.jpg','image',0),(1527,90,'/m/s/msh02-black_back_1.jpg','image',0),(1528,90,'/m/s/msh02-black_main_1.jpg','image',0),(1529,90,'/m/s/msh02-black_alt1_1.jpg','image',0),(1530,90,'/m/s/msh02-black_back_1.jpg','image',0),(1531,90,'/m/s/msh03-black_main_1.jpg','image',0),(1532,90,'/m/s/msh03-blue_main_1.jpg','image',0),(1533,90,'/m/s/msh03-blue_alt1_1.jpg','image',0),(1534,90,'/m/s/msh03-blue_back_1.jpg','image',0),(1535,90,'/m/s/msh03-green_main_1.jpg','image',0),(1536,90,'/m/s/msh03-black_main_1.jpg','image',0),(1537,90,'/m/s/msh03-blue_main_1.jpg','image',0),(1538,90,'/m/s/msh03-blue_alt1_1.jpg','image',0),(1539,90,'/m/s/msh03-blue_back_1.jpg','image',0),(1540,90,'/m/s/msh03-green_main_1.jpg','image',0),(1541,90,'/m/s/msh03-black_main_1.jpg','image',0),(1542,90,'/m/s/msh03-blue_main_1.jpg','image',0),(1543,90,'/m/s/msh03-blue_alt1_1.jpg','image',0),(1544,90,'/m/s/msh03-blue_back_1.jpg','image',0),(1545,90,'/m/s/msh03-green_main_1.jpg','image',0),(1546,90,'/m/s/msh03-black_main_1.jpg','image',0),(1547,90,'/m/s/msh03-blue_main_1.jpg','image',0),(1548,90,'/m/s/msh03-blue_alt1_1.jpg','image',0),(1549,90,'/m/s/msh03-blue_back_1.jpg','image',0),(1550,90,'/m/s/msh03-green_main_1.jpg','image',0),(1551,90,'/m/s/msh03-blue_main_1.jpg','image',0),(1552,90,'/m/s/msh03-blue_alt1_1.jpg','image',0),(1553,90,'/m/s/msh03-blue_back_1.jpg','image',0),(1554,90,'/m/s/msh04-gray_main_1.jpg','image',0),(1555,90,'/m/s/msh04-gray_back_1.jpg','image',0),(1556,90,'/m/s/msh04-purple_main_1.jpg','image',0),(1557,90,'/m/s/msh04-yellow_main_1.jpg','image',0),(1558,90,'/m/s/msh04-gray_main_1.jpg','image',0),(1559,90,'/m/s/msh04-gray_back_1.jpg','image',0),(1560,90,'/m/s/msh04-purple_main_1.jpg','image',0),(1561,90,'/m/s/msh04-yellow_main_1.jpg','image',0),(1562,90,'/m/s/msh04-gray_main_1.jpg','image',0),(1563,90,'/m/s/msh04-gray_back_1.jpg','image',0),(1564,90,'/m/s/msh04-purple_main_1.jpg','image',0),(1565,90,'/m/s/msh04-yellow_main_1.jpg','image',0),(1566,90,'/m/s/msh04-gray_main_1.jpg','image',0),(1567,90,'/m/s/msh04-gray_back_1.jpg','image',0),(1568,90,'/m/s/msh04-purple_main_1.jpg','image',0),(1569,90,'/m/s/msh04-yellow_main_1.jpg','image',0),(1570,90,'/m/s/msh04-gray_main_1.jpg','image',0),(1571,90,'/m/s/msh04-gray_back_1.jpg','image',0),(1572,90,'/m/s/msh05-black_main_1.jpg','image',0),(1573,90,'/m/s/msh05-blue_main_1.jpg','image',0),(1574,90,'/m/s/msh05-gray_main_1.jpg','image',0),(1575,90,'/m/s/msh05-gray_alt1_1.jpg','image',0),(1576,90,'/m/s/msh05-gray_back_1.jpg','image',0),(1577,90,'/m/s/msh05-black_main_1.jpg','image',0),(1578,90,'/m/s/msh05-blue_main_1.jpg','image',0),(1579,90,'/m/s/msh05-gray_main_1.jpg','image',0),(1580,90,'/m/s/msh05-gray_alt1_1.jpg','image',0),(1581,90,'/m/s/msh05-gray_back_1.jpg','image',0),(1582,90,'/m/s/msh05-black_main_1.jpg','image',0),(1583,90,'/m/s/msh05-blue_main_1.jpg','image',0),(1584,90,'/m/s/msh05-gray_main_1.jpg','image',0),(1585,90,'/m/s/msh05-gray_alt1_1.jpg','image',0),(1586,90,'/m/s/msh05-gray_back_1.jpg','image',0),(1587,90,'/m/s/msh05-black_main_1.jpg','image',0),(1588,90,'/m/s/msh05-blue_main_1.jpg','image',0),(1589,90,'/m/s/msh05-gray_main_1.jpg','image',0),(1590,90,'/m/s/msh05-gray_alt1_1.jpg','image',0),(1591,90,'/m/s/msh05-gray_back_1.jpg','image',0),(1592,90,'/m/s/msh05-gray_main_1.jpg','image',0),(1593,90,'/m/s/msh05-gray_alt1_1.jpg','image',0),(1594,90,'/m/s/msh05-gray_back_1.jpg','image',0),(1595,90,'/m/s/msh06-blue_main_1.jpg','image',0),(1596,90,'/m/s/msh06-gray_main_1.jpg','image',0),(1597,90,'/m/s/msh06-gray_alt1_1.jpg','image',0),(1598,90,'/m/s/msh06-gray_back_1.jpg','image',0),(1599,90,'/m/s/msh06-red_main_1.jpg','image',0),(1600,90,'/m/s/msh06-blue_main_1.jpg','image',0),(1601,90,'/m/s/msh06-gray_main_1.jpg','image',0),(1602,90,'/m/s/msh06-gray_alt1_1.jpg','image',0),(1603,90,'/m/s/msh06-gray_back_1.jpg','image',0),(1604,90,'/m/s/msh06-red_main_1.jpg','image',0),(1605,90,'/m/s/msh06-blue_main_1.jpg','image',0),(1606,90,'/m/s/msh06-gray_main_1.jpg','image',0),(1607,90,'/m/s/msh06-gray_alt1_1.jpg','image',0),(1608,90,'/m/s/msh06-gray_back_1.jpg','image',0),(1609,90,'/m/s/msh06-red_main_1.jpg','image',0),(1610,90,'/m/s/msh06-blue_main_2.jpg','image',0),(1611,90,'/m/s/msh06-gray_main_2.jpg','image',0),(1612,90,'/m/s/msh06-gray_alt1_2.jpg','image',0),(1613,90,'/m/s/msh06-gray_back_2.jpg','image',0),(1614,90,'/m/s/msh06-red_main_2.jpg','image',0),(1615,90,'/m/s/msh06-gray_main_2.jpg','image',0),(1616,90,'/m/s/msh06-gray_alt1_2.jpg','image',0),(1617,90,'/m/s/msh06-gray_back_2.jpg','image',0),(1618,90,'/m/s/msh07-black_main_1.jpg','image',0),(1619,90,'/m/s/msh07-black_alt1_1.jpg','image',0),(1620,90,'/m/s/msh07-black_back_1.jpg','image',0),(1621,90,'/m/s/msh07-blue_main_1.jpg','image',0),(1622,90,'/m/s/msh07-purple_main_1.jpg','image',0),(1623,90,'/m/s/msh07-black_main_1.jpg','image',0),(1624,90,'/m/s/msh07-black_alt1_1.jpg','image',0),(1625,90,'/m/s/msh07-black_back_1.jpg','image',0),(1626,90,'/m/s/msh07-blue_main_1.jpg','image',0),(1627,90,'/m/s/msh07-purple_main_1.jpg','image',0),(1628,90,'/m/s/msh07-black_main_1.jpg','image',0),(1629,90,'/m/s/msh07-black_alt1_1.jpg','image',0),(1630,90,'/m/s/msh07-black_back_1.jpg','image',0),(1631,90,'/m/s/msh07-blue_main_1.jpg','image',0),(1632,90,'/m/s/msh07-purple_main_1.jpg','image',0),(1633,90,'/m/s/msh07-black_main_1.jpg','image',0),(1634,90,'/m/s/msh07-black_alt1_1.jpg','image',0),(1635,90,'/m/s/msh07-black_back_1.jpg','image',0),(1636,90,'/m/s/msh07-blue_main_1.jpg','image',0),(1637,90,'/m/s/msh07-purple_main_1.jpg','image',0),(1638,90,'/m/s/msh07-black_main_1.jpg','image',0),(1639,90,'/m/s/msh07-black_alt1_1.jpg','image',0),(1640,90,'/m/s/msh07-black_back_1.jpg','image',0),(1641,90,'/m/s/msh08-black_main_1.jpg','image',0),(1642,90,'/m/s/msh08-black_back_1.jpg','image',0),(1643,90,'/m/s/msh08-blue_main_1.jpg','image',0),(1644,90,'/m/s/msh08-green_main_1.jpg','image',0),(1645,90,'/m/s/msh08-black_main_1.jpg','image',0),(1646,90,'/m/s/msh08-black_back_1.jpg','image',0),(1647,90,'/m/s/msh08-blue_main_1.jpg','image',0),(1648,90,'/m/s/msh08-green_main_1.jpg','image',0),(1649,90,'/m/s/msh08-black_main_1.jpg','image',0),(1650,90,'/m/s/msh08-black_back_1.jpg','image',0),(1651,90,'/m/s/msh08-blue_main_1.jpg','image',0),(1652,90,'/m/s/msh08-green_main_1.jpg','image',0),(1653,90,'/m/s/msh08-black_main_1.jpg','image',0),(1654,90,'/m/s/msh08-black_back_1.jpg','image',0),(1655,90,'/m/s/msh08-blue_main_1.jpg','image',0),(1656,90,'/m/s/msh08-green_main_1.jpg','image',0),(1657,90,'/m/s/msh08-black_main_1.jpg','image',0),(1658,90,'/m/s/msh08-black_back_1.jpg','image',0),(1659,90,'/m/s/msh09-black_main_1.jpg','image',0),(1660,90,'/m/s/msh09-blue_main_1.jpg','image',0),(1661,90,'/m/s/msh09-blue_alt1_1.jpg','image',0),(1662,90,'/m/s/msh09-blue_back_1.jpg','image',0),(1663,90,'/m/s/msh09-green_main_1.jpg','image',0),(1664,90,'/m/s/msh09-black_main_1.jpg','image',0),(1665,90,'/m/s/msh09-blue_main_1.jpg','image',0),(1666,90,'/m/s/msh09-blue_alt1_1.jpg','image',0),(1667,90,'/m/s/msh09-blue_back_1.jpg','image',0),(1668,90,'/m/s/msh09-green_main_1.jpg','image',0),(1669,90,'/m/s/msh09-black_main_1.jpg','image',0),(1670,90,'/m/s/msh09-blue_main_1.jpg','image',0),(1671,90,'/m/s/msh09-blue_alt1_1.jpg','image',0),(1672,90,'/m/s/msh09-blue_back_1.jpg','image',0),(1673,90,'/m/s/msh09-green_main_1.jpg','image',0),(1674,90,'/m/s/msh09-black_main_1.jpg','image',0),(1675,90,'/m/s/msh09-blue_main_1.jpg','image',0),(1676,90,'/m/s/msh09-blue_alt1_1.jpg','image',0),(1677,90,'/m/s/msh09-blue_back_1.jpg','image',0),(1678,90,'/m/s/msh09-green_main_1.jpg','image',0),(1679,90,'/m/s/msh09-blue_main_1.jpg','image',0),(1680,90,'/m/s/msh09-blue_alt1_1.jpg','image',0),(1681,90,'/m/s/msh09-blue_back_1.jpg','image',0),(1682,90,'/m/s/msh10-blue_main_1.jpg','image',0),(1683,90,'/m/s/msh10-blue_alt1_1.jpg','image',0),(1684,90,'/m/s/msh10-blue_back_1.jpg','image',0),(1685,90,'/m/s/msh10-green_main_1.jpg','image',0),(1686,90,'/m/s/msh10-purple_main_1.jpg','image',0),(1687,90,'/m/s/msh10-blue_main_1.jpg','image',0),(1688,90,'/m/s/msh10-blue_alt1_1.jpg','image',0),(1689,90,'/m/s/msh10-blue_back_1.jpg','image',0),(1690,90,'/m/s/msh10-green_main_1.jpg','image',0),(1691,90,'/m/s/msh10-purple_main_1.jpg','image',0),(1692,90,'/m/s/msh10-blue_main_1.jpg','image',0),(1693,90,'/m/s/msh10-blue_alt1_1.jpg','image',0),(1694,90,'/m/s/msh10-blue_back_1.jpg','image',0),(1695,90,'/m/s/msh10-green_main_1.jpg','image',0),(1696,90,'/m/s/msh10-purple_main_1.jpg','image',0),(1697,90,'/m/s/msh10-blue_main_1.jpg','image',0),(1698,90,'/m/s/msh10-blue_alt1_1.jpg','image',0),(1699,90,'/m/s/msh10-blue_back_1.jpg','image',0),(1700,90,'/m/s/msh10-green_main_1.jpg','image',0),(1701,90,'/m/s/msh10-purple_main_1.jpg','image',0),(1702,90,'/m/s/msh10-blue_main_1.jpg','image',0),(1703,90,'/m/s/msh10-blue_alt1_1.jpg','image',0),(1704,90,'/m/s/msh10-blue_back_1.jpg','image',0),(1705,90,'/m/s/msh11-black_main_1.jpg','image',0),(1706,90,'/m/s/msh11-blue_main_1.jpg','image',0),(1707,90,'/m/s/msh11-blue_back_1.jpg','image',0),(1708,90,'/m/s/msh11-red_main_1.jpg','image',0),(1709,90,'/m/s/msh11-black_main_1.jpg','image',0),(1710,90,'/m/s/msh11-blue_main_1.jpg','image',0),(1711,90,'/m/s/msh11-blue_back_1.jpg','image',0),(1712,90,'/m/s/msh11-red_main_1.jpg','image',0),(1713,90,'/m/s/msh11-black_main_1.jpg','image',0),(1714,90,'/m/s/msh11-blue_main_1.jpg','image',0),(1715,90,'/m/s/msh11-blue_back_1.jpg','image',0),(1716,90,'/m/s/msh11-red_main_1.jpg','image',0),(1717,90,'/m/s/msh11-black_main_1.jpg','image',0),(1718,90,'/m/s/msh11-blue_main_1.jpg','image',0),(1719,90,'/m/s/msh11-blue_back_1.jpg','image',0),(1720,90,'/m/s/msh11-red_main_1.jpg','image',0),(1721,90,'/m/s/msh11-blue_main_1.jpg','image',0),(1722,90,'/m/s/msh11-blue_back_1.jpg','image',0),(1723,90,'/m/s/msh12-black_main_1.jpg','image',0),(1724,90,'/m/s/msh12-gray_main_1.jpg','image',0),(1725,90,'/m/s/msh12-red_main_1.jpg','image',0),(1726,90,'/m/s/msh12-red_back_1.jpg','image',0),(1727,90,'/m/s/msh12-black_main_1.jpg','image',0),(1728,90,'/m/s/msh12-gray_main_1.jpg','image',0),(1729,90,'/m/s/msh12-red_main_1.jpg','image',0),(1730,90,'/m/s/msh12-red_back_1.jpg','image',0),(1731,90,'/m/s/msh12-black_main_1.jpg','image',0),(1732,90,'/m/s/msh12-gray_main_1.jpg','image',0),(1733,90,'/m/s/msh12-red_main_1.jpg','image',0),(1734,90,'/m/s/msh12-red_back_1.jpg','image',0),(1735,90,'/m/s/msh12-black_main_1.jpg','image',0),(1736,90,'/m/s/msh12-gray_main_1.jpg','image',0),(1737,90,'/m/s/msh12-red_main_1.jpg','image',0),(1738,90,'/m/s/msh12-red_back_1.jpg','image',0),(1739,90,'/m/s/msh12-red_main_1.jpg','image',0),(1740,90,'/m/s/msh12-red_back_1.jpg','image',0),(1741,90,'/w/h/wh01-green_main_1.jpg','image',0),(1742,90,'/w/h/wh01-green_alt1_1.jpg','image',0),(1743,90,'/w/h/wh01-green_back_1.jpg','image',0),(1744,90,'/w/h/wh01-orange_main_1.jpg','image',0),(1745,90,'/w/h/wh01-purple_main_1.jpg','image',0),(1746,90,'/w/h/wh01-green_main_1.jpg','image',0),(1747,90,'/w/h/wh01-green_alt1_1.jpg','image',0),(1748,90,'/w/h/wh01-green_back_1.jpg','image',0),(1749,90,'/w/h/wh01-orange_main_1.jpg','image',0),(1750,90,'/w/h/wh01-purple_main_1.jpg','image',0),(1751,90,'/w/h/wh01-green_main_1.jpg','image',0),(1752,90,'/w/h/wh01-green_alt1_1.jpg','image',0),(1753,90,'/w/h/wh01-green_back_1.jpg','image',0),(1754,90,'/w/h/wh01-orange_main_1.jpg','image',0),(1755,90,'/w/h/wh01-purple_main_1.jpg','image',0),(1756,90,'/w/h/wh01-green_main_1.jpg','image',0),(1757,90,'/w/h/wh01-green_alt1_1.jpg','image',0),(1758,90,'/w/h/wh01-green_back_1.jpg','image',0),(1759,90,'/w/h/wh01-orange_main_1.jpg','image',0),(1760,90,'/w/h/wh01-purple_main_1.jpg','image',0),(1761,90,'/w/h/wh01-green_main_1.jpg','image',0),(1762,90,'/w/h/wh01-green_alt1_1.jpg','image',0),(1763,90,'/w/h/wh01-green_back_1.jpg','image',0),(1764,90,'/w/h/wh01-orange_main_1.jpg','image',0),(1765,90,'/w/h/wh01-purple_main_1.jpg','image',0),(1766,90,'/w/h/wh01-green_main_1.jpg','image',0),(1767,90,'/w/h/wh01-green_alt1_1.jpg','image',0),(1768,90,'/w/h/wh01-green_back_1.jpg','image',0),(1769,90,'/w/h/wh02-blue_main_1.jpg','image',0),(1770,90,'/w/h/wh02-blue_alt1_1.jpg','image',0),(1771,90,'/w/h/wh02-blue_back_1.jpg','image',0),(1772,90,'/w/h/wh02-green_main_1.jpg','image',0),(1773,90,'/w/h/wh02-orange_main_1.jpg','image',0),(1774,90,'/w/h/wh02-blue_main_2.jpg','image',0),(1775,90,'/w/h/wh02-blue_alt1_2.jpg','image',0),(1776,90,'/w/h/wh02-blue_back_2.jpg','image',0),(1777,90,'/w/h/wh02-green_main_2.jpg','image',0),(1778,90,'/w/h/wh02-orange_main_1.jpg','image',0),(1779,90,'/w/h/wh02-blue_main_2.jpg','image',0),(1780,90,'/w/h/wh02-blue_alt1_2.jpg','image',0),(1781,90,'/w/h/wh02-blue_back_2.jpg','image',0),(1782,90,'/w/h/wh02-green_main_2.jpg','image',0),(1783,90,'/w/h/wh02-orange_main_1.jpg','image',0),(1784,90,'/w/h/wh02-blue_main_2.jpg','image',0),(1785,90,'/w/h/wh02-blue_alt1_2.jpg','image',0),(1786,90,'/w/h/wh02-blue_back_2.jpg','image',0),(1787,90,'/w/h/wh02-green_main_2.jpg','image',0),(1788,90,'/w/h/wh02-orange_main_1.jpg','image',0),(1789,90,'/w/h/wh02-blue_main_2.jpg','image',0),(1790,90,'/w/h/wh02-blue_alt1_2.jpg','image',0),(1791,90,'/w/h/wh02-blue_back_2.jpg','image',0),(1792,90,'/w/h/wh02-green_main_2.jpg','image',0),(1793,90,'/w/h/wh02-orange_main_1.jpg','image',0),(1794,90,'/w/h/wh02-blue_main_2.jpg','image',0),(1795,90,'/w/h/wh02-blue_alt1_2.jpg','image',0),(1796,90,'/w/h/wh02-blue_back_2.jpg','image',0),(1797,90,'/w/h/wh03-green_main_1.jpg','image',0),(1798,90,'/w/h/wh03-purple_main_1.jpg','image',0),(1799,90,'/w/h/wh03-red_main_1.jpg','image',0),(1800,90,'/w/h/wh03-red_alt1_1.jpg','image',0),(1801,90,'/w/h/wh03-red_back_1.jpg','image',0),(1802,90,'/w/h/wh03-green_main_1.jpg','image',0),(1803,90,'/w/h/wh03-purple_main_1.jpg','image',0),(1804,90,'/w/h/wh03-red_main_1.jpg','image',0),(1805,90,'/w/h/wh03-red_alt1_1.jpg','image',0),(1806,90,'/w/h/wh03-red_back_1.jpg','image',0),(1807,90,'/w/h/wh03-green_main_1.jpg','image',0),(1808,90,'/w/h/wh03-purple_main_1.jpg','image',0),(1809,90,'/w/h/wh03-red_main_1.jpg','image',0),(1810,90,'/w/h/wh03-red_alt1_1.jpg','image',0),(1811,90,'/w/h/wh03-red_back_1.jpg','image',0),(1812,90,'/w/h/wh03-green_main_1.jpg','image',0),(1813,90,'/w/h/wh03-purple_main_1.jpg','image',0),(1814,90,'/w/h/wh03-red_main_1.jpg','image',0),(1815,90,'/w/h/wh03-red_alt1_1.jpg','image',0),(1816,90,'/w/h/wh03-red_back_1.jpg','image',0),(1817,90,'/w/h/wh03-green_main_1.jpg','image',0),(1818,90,'/w/h/wh03-purple_main_1.jpg','image',0),(1819,90,'/w/h/wh03-red_main_1.jpg','image',0),(1820,90,'/w/h/wh03-red_alt1_1.jpg','image',0),(1821,90,'/w/h/wh03-red_back_1.jpg','image',0),(1822,90,'/w/h/wh03-red_main_1.jpg','image',0),(1823,90,'/w/h/wh03-red_alt1_1.jpg','image',0),(1824,90,'/w/h/wh03-red_back_1.jpg','image',0),(1825,90,'/w/h/wh04-blue_main_1.jpg','image',0),(1826,90,'/w/h/wh04-blue_alt1_1.jpg','image',0),(1827,90,'/w/h/wh04-blue_back_1.jpg','image',0),(1828,90,'/w/h/wh04-orange_main_1.jpg','image',0),(1829,90,'/w/h/wh04-purple_main_1.jpg','image',0),(1830,90,'/w/h/wh04-blue_main_1.jpg','image',0),(1831,90,'/w/h/wh04-blue_alt1_1.jpg','image',0),(1832,90,'/w/h/wh04-blue_back_1.jpg','image',0),(1833,90,'/w/h/wh04-orange_main_1.jpg','image',0),(1834,90,'/w/h/wh04-purple_main_1.jpg','image',0),(1835,90,'/w/h/wh04-blue_main_1.jpg','image',0),(1836,90,'/w/h/wh04-blue_alt1_1.jpg','image',0),(1837,90,'/w/h/wh04-blue_back_1.jpg','image',0),(1838,90,'/w/h/wh04-orange_main_1.jpg','image',0),(1839,90,'/w/h/wh04-purple_main_1.jpg','image',0),(1840,90,'/w/h/wh04-blue_main_1.jpg','image',0),(1841,90,'/w/h/wh04-blue_alt1_1.jpg','image',0),(1842,90,'/w/h/wh04-blue_back_1.jpg','image',0),(1843,90,'/w/h/wh04-orange_main_1.jpg','image',0),(1844,90,'/w/h/wh04-purple_main_1.jpg','image',0),(1845,90,'/w/h/wh04-blue_main_1.jpg','image',0),(1846,90,'/w/h/wh04-blue_alt1_1.jpg','image',0),(1847,90,'/w/h/wh04-blue_back_1.jpg','image',0),(1848,90,'/w/h/wh04-orange_main_1.jpg','image',0),(1849,90,'/w/h/wh04-purple_main_1.jpg','image',0),(1850,90,'/w/h/wh04-blue_main_1.jpg','image',0),(1851,90,'/w/h/wh04-blue_alt1_1.jpg','image',0),(1852,90,'/w/h/wh04-blue_back_1.jpg','image',0),(1853,90,'/w/h/wh05-orange_main_1.jpg','image',0),(1854,90,'/w/h/wh05-purple_main_1.jpg','image',0),(1855,90,'/w/h/wh05-white_main_1.jpg','image',0),(1856,90,'/w/h/wh05-white_back_1.jpg','image',0),(1857,90,'/w/h/wh05-orange_main_1.jpg','image',0),(1858,90,'/w/h/wh05-purple_main_1.jpg','image',0),(1859,90,'/w/h/wh05-white_main_1.jpg','image',0),(1860,90,'/w/h/wh05-white_back_1.jpg','image',0),(1861,90,'/w/h/wh05-orange_main_1.jpg','image',0),(1862,90,'/w/h/wh05-purple_main_1.jpg','image',0),(1863,90,'/w/h/wh05-white_main_1.jpg','image',0),(1864,90,'/w/h/wh05-white_back_1.jpg','image',0),(1865,90,'/w/h/wh05-orange_main_1.jpg','image',0),(1866,90,'/w/h/wh05-purple_main_1.jpg','image',0),(1867,90,'/w/h/wh05-white_main_1.jpg','image',0),(1868,90,'/w/h/wh05-white_back_1.jpg','image',0),(1869,90,'/w/h/wh05-orange_main_1.jpg','image',0),(1870,90,'/w/h/wh05-purple_main_1.jpg','image',0),(1871,90,'/w/h/wh05-white_main_1.jpg','image',0),(1872,90,'/w/h/wh05-white_back_1.jpg','image',0),(1873,90,'/w/h/wh05-white_main_1.jpg','image',0),(1874,90,'/w/h/wh05-white_back_1.jpg','image',0),(1875,90,'/w/h/wh06-purple_main_1.jpg','image',0),(1876,90,'/w/h/wh06-purple_alt1_1.jpg','image',0),(1877,90,'/w/h/wh06-purple_back_1.jpg','image',0),(1878,90,'/w/h/wh06-purple_main_1.jpg','image',0),(1879,90,'/w/h/wh06-purple_alt1_1.jpg','image',0),(1880,90,'/w/h/wh06-purple_back_1.jpg','image',0),(1881,90,'/w/h/wh06-purple_main_1.jpg','image',0),(1882,90,'/w/h/wh06-purple_alt1_1.jpg','image',0),(1883,90,'/w/h/wh06-purple_back_1.jpg','image',0),(1884,90,'/w/h/wh06-purple_main_1.jpg','image',0),(1885,90,'/w/h/wh06-purple_alt1_1.jpg','image',0),(1886,90,'/w/h/wh06-purple_back_1.jpg','image',0),(1887,90,'/w/h/wh06-purple_main_1.jpg','image',0),(1888,90,'/w/h/wh06-purple_alt1_1.jpg','image',0),(1889,90,'/w/h/wh06-purple_back_1.jpg','image',0),(1890,90,'/w/h/wh06-purple_main_1.jpg','image',0),(1891,90,'/w/h/wh06-purple_alt1_1.jpg','image',0),(1892,90,'/w/h/wh06-purple_back_1.jpg','image',0),(1893,90,'/w/h/wh07-gray_main_1.jpg','image',0),(1894,90,'/w/h/wh07-gray_alt1_1.jpg','image',0),(1895,90,'/w/h/wh07-gray_back_1.jpg','image',0),(1896,90,'/w/h/wh07-purple_main_1.jpg','image',0),(1897,90,'/w/h/wh07-white_main_1.jpg','image',0),(1898,90,'/w/h/wh07-gray_main_1.jpg','image',0),(1899,90,'/w/h/wh07-gray_alt1_1.jpg','image',0),(1900,90,'/w/h/wh07-gray_back_1.jpg','image',0),(1901,90,'/w/h/wh07-purple_main_1.jpg','image',0),(1902,90,'/w/h/wh07-white_main_1.jpg','image',0),(1903,90,'/w/h/wh07-gray_main_1.jpg','image',0),(1904,90,'/w/h/wh07-gray_alt1_1.jpg','image',0),(1905,90,'/w/h/wh07-gray_back_1.jpg','image',0),(1906,90,'/w/h/wh07-purple_main_1.jpg','image',0),(1907,90,'/w/h/wh07-white_main_1.jpg','image',0),(1908,90,'/w/h/wh07-gray_main_1.jpg','image',0),(1909,90,'/w/h/wh07-gray_alt1_1.jpg','image',0),(1910,90,'/w/h/wh07-gray_back_1.jpg','image',0),(1911,90,'/w/h/wh07-purple_main_1.jpg','image',0),(1912,90,'/w/h/wh07-white_main_1.jpg','image',0),(1913,90,'/w/h/wh07-gray_main_1.jpg','image',0),(1914,90,'/w/h/wh07-gray_alt1_1.jpg','image',0),(1915,90,'/w/h/wh07-gray_back_1.jpg','image',0),(1916,90,'/w/h/wh07-purple_main_1.jpg','image',0),(1917,90,'/w/h/wh07-white_main_1.jpg','image',0),(1918,90,'/w/h/wh07-gray_main_1.jpg','image',0),(1919,90,'/w/h/wh07-gray_alt1_1.jpg','image',0),(1920,90,'/w/h/wh07-gray_back_1.jpg','image',0),(1921,90,'/w/h/wh08-orange_main_1.jpg','image',0),(1922,90,'/w/h/wh08-purple_main_1.jpg','image',0),(1923,90,'/w/h/wh08-white_main_1.jpg','image',0),(1924,90,'/w/h/wh08-white_alt1_1.jpg','image',0),(1925,90,'/w/h/wh08-white_alternate_1.jpg','image',0),(1926,90,'/w/h/wh08-white_back_1.jpg','image',0),(1927,90,'/w/h/wh08-orange_main_1.jpg','image',0),(1928,90,'/w/h/wh08-purple_main_1.jpg','image',0),(1929,90,'/w/h/wh08-white_main_1.jpg','image',0),(1930,90,'/w/h/wh08-white_alt1_1.jpg','image',0),(1931,90,'/w/h/wh08-white_alternate_1.jpg','image',0),(1932,90,'/w/h/wh08-white_back_1.jpg','image',0),(1933,90,'/w/h/wh08-orange_main_1.jpg','image',0),(1934,90,'/w/h/wh08-purple_main_1.jpg','image',0),(1935,90,'/w/h/wh08-white_main_1.jpg','image',0),(1936,90,'/w/h/wh08-white_alt1_1.jpg','image',0),(1937,90,'/w/h/wh08-white_alternate_1.jpg','image',0),(1938,90,'/w/h/wh08-white_back_1.jpg','image',0),(1939,90,'/w/h/wh08-orange_main_1.jpg','image',0),(1940,90,'/w/h/wh08-purple_main_1.jpg','image',0),(1941,90,'/w/h/wh08-white_main_1.jpg','image',0),(1942,90,'/w/h/wh08-white_alt1_1.jpg','image',0),(1943,90,'/w/h/wh08-white_alternate_1.jpg','image',0),(1944,90,'/w/h/wh08-white_back_1.jpg','image',0),(1945,90,'/w/h/wh08-orange_main_1.jpg','image',0),(1946,90,'/w/h/wh08-purple_main_1.jpg','image',0),(1947,90,'/w/h/wh08-white_main_1.jpg','image',0),(1948,90,'/w/h/wh08-white_alt1_1.jpg','image',0),(1949,90,'/w/h/wh08-white_alternate_1.jpg','image',0),(1950,90,'/w/h/wh08-white_back_1.jpg','image',0),(1951,90,'/w/h/wh08-white_main_1.jpg','image',0),(1952,90,'/w/h/wh08-white_alt1_1.jpg','image',0),(1953,90,'/w/h/wh08-white_alternate_1.jpg','image',0),(1954,90,'/w/h/wh08-white_back_1.jpg','image',0),(1955,90,'/w/h/wh09-green_main_1.jpg','image',0),(1956,90,'/w/h/wh09-purple_main_1.jpg','image',0),(1957,90,'/w/h/wh09-purple_alt1_1.jpg','image',0),(1958,90,'/w/h/wh09-purple_back_1.jpg','image',0),(1959,90,'/w/h/wh09-red_main_1.jpg','image',0),(1960,90,'/w/h/wh09-green_main_1.jpg','image',0),(1961,90,'/w/h/wh09-purple_main_1.jpg','image',0),(1962,90,'/w/h/wh09-purple_alt1_1.jpg','image',0),(1963,90,'/w/h/wh09-purple_back_1.jpg','image',0),(1964,90,'/w/h/wh09-red_main_1.jpg','image',0),(1965,90,'/w/h/wh09-green_main_1.jpg','image',0),(1966,90,'/w/h/wh09-purple_main_1.jpg','image',0),(1967,90,'/w/h/wh09-purple_alt1_1.jpg','image',0),(1968,90,'/w/h/wh09-purple_back_1.jpg','image',0),(1969,90,'/w/h/wh09-red_main_1.jpg','image',0),(1970,90,'/w/h/wh09-green_main_1.jpg','image',0),(1971,90,'/w/h/wh09-purple_main_1.jpg','image',0),(1972,90,'/w/h/wh09-purple_alt1_1.jpg','image',0),(1973,90,'/w/h/wh09-purple_back_1.jpg','image',0),(1974,90,'/w/h/wh09-red_main_1.jpg','image',0),(1975,90,'/w/h/wh09-green_main_1.jpg','image',0),(1976,90,'/w/h/wh09-purple_main_1.jpg','image',0),(1977,90,'/w/h/wh09-purple_alt1_1.jpg','image',0),(1978,90,'/w/h/wh09-purple_back_1.jpg','image',0),(1979,90,'/w/h/wh09-red_main_1.jpg','image',0),(1980,90,'/w/h/wh09-purple_main_1.jpg','image',0),(1981,90,'/w/h/wh09-purple_alt1_1.jpg','image',0),(1982,90,'/w/h/wh09-purple_back_1.jpg','image',0),(1983,90,'/w/h/wh10-blue_main_1.jpg','image',0),(1984,90,'/w/h/wh10-gray_main_1.jpg','image',0),(1985,90,'/w/h/wh10-gray_alt1_1.jpg','image',0),(1986,90,'/w/h/wh10-gray_back_1.jpg','image',0),(1987,90,'/w/h/wh10-yellow_main_1.jpg','image',0),(1988,90,'/w/h/wh10-blue_main_1.jpg','image',0),(1989,90,'/w/h/wh10-gray_main_1.jpg','image',0),(1990,90,'/w/h/wh10-gray_alt1_1.jpg','image',0),(1991,90,'/w/h/wh10-gray_back_1.jpg','image',0),(1992,90,'/w/h/wh10-yellow_main_1.jpg','image',0),(1993,90,'/w/h/wh10-blue_main_1.jpg','image',0),(1994,90,'/w/h/wh10-gray_main_1.jpg','image',0),(1995,90,'/w/h/wh10-gray_alt1_1.jpg','image',0),(1996,90,'/w/h/wh10-gray_back_1.jpg','image',0),(1997,90,'/w/h/wh10-yellow_main_1.jpg','image',0),(1998,90,'/w/h/wh10-blue_main_1.jpg','image',0),(1999,90,'/w/h/wh10-gray_main_1.jpg','image',0),(2000,90,'/w/h/wh10-gray_alt1_1.jpg','image',0),(2001,90,'/w/h/wh10-gray_back_1.jpg','image',0),(2002,90,'/w/h/wh10-yellow_main_1.jpg','image',0),(2003,90,'/w/h/wh10-blue_main_1.jpg','image',0),(2004,90,'/w/h/wh10-gray_main_1.jpg','image',0),(2005,90,'/w/h/wh10-gray_alt1_1.jpg','image',0),(2006,90,'/w/h/wh10-gray_back_1.jpg','image',0),(2007,90,'/w/h/wh10-yellow_main_1.jpg','image',0),(2008,90,'/w/h/wh10-gray_main_1.jpg','image',0),(2009,90,'/w/h/wh10-gray_alt1_1.jpg','image',0),(2010,90,'/w/h/wh10-gray_back_1.jpg','image',0),(2011,90,'/w/h/wh11-blue_main_1.jpg','image',0),(2012,90,'/w/h/wh11-blue_back_1.jpg','image',0),(2013,90,'/w/h/wh11-green_main_1.jpg','image',0),(2014,90,'/w/h/wh11-orange_main_1.jpg','image',0),(2015,90,'/w/h/wh11-blue_main_1.jpg','image',0),(2016,90,'/w/h/wh11-blue_back_1.jpg','image',0),(2017,90,'/w/h/wh11-green_main_1.jpg','image',0),(2018,90,'/w/h/wh11-orange_main_1.jpg','image',0),(2019,90,'/w/h/wh11-blue_main_1.jpg','image',0),(2020,90,'/w/h/wh11-blue_back_1.jpg','image',0),(2021,90,'/w/h/wh11-green_main_1.jpg','image',0),(2022,90,'/w/h/wh11-orange_main_1.jpg','image',0),(2023,90,'/w/h/wh11-blue_main_1.jpg','image',0),(2024,90,'/w/h/wh11-blue_back_1.jpg','image',0),(2025,90,'/w/h/wh11-green_main_1.jpg','image',0),(2026,90,'/w/h/wh11-orange_main_1.jpg','image',0),(2027,90,'/w/h/wh11-blue_main_1.jpg','image',0),(2028,90,'/w/h/wh11-blue_back_1.jpg','image',0),(2029,90,'/w/h/wh11-green_main_1.jpg','image',0),(2030,90,'/w/h/wh11-orange_main_1.jpg','image',0),(2031,90,'/w/h/wh11-blue_main_1.jpg','image',0),(2032,90,'/w/h/wh11-blue_back_1.jpg','image',0),(2033,90,'/w/h/wh12-gray_main_1.jpg','image',0),(2034,90,'/w/h/wh12-gray_back_1.jpg','image',0),(2035,90,'/w/h/wh12-green_main_1.jpg','image',0),(2036,90,'/w/h/wh12-purple_main_1.jpg','image',0),(2037,90,'/w/h/wh12-gray_main_1.jpg','image',0),(2038,90,'/w/h/wh12-gray_back_1.jpg','image',0),(2039,90,'/w/h/wh12-green_main_1.jpg','image',0),(2040,90,'/w/h/wh12-purple_main_1.jpg','image',0),(2041,90,'/w/h/wh12-gray_main_1.jpg','image',0),(2042,90,'/w/h/wh12-gray_back_1.jpg','image',0),(2043,90,'/w/h/wh12-green_main_1.jpg','image',0),(2044,90,'/w/h/wh12-purple_main_1.jpg','image',0),(2045,90,'/w/h/wh12-gray_main_1.jpg','image',0),(2046,90,'/w/h/wh12-gray_back_1.jpg','image',0),(2047,90,'/w/h/wh12-green_main_1.jpg','image',0),(2048,90,'/w/h/wh12-purple_main_1.jpg','image',0),(2049,90,'/w/h/wh12-gray_main_1.jpg','image',0),(2050,90,'/w/h/wh12-gray_back_1.jpg','image',0),(2051,90,'/w/h/wh12-green_main_1.jpg','image',0),(2052,90,'/w/h/wh12-purple_main_1.jpg','image',0),(2053,90,'/w/h/wh12-gray_main_1.jpg','image',0),(2054,90,'/w/h/wh12-gray_back_1.jpg','image',0),(2055,90,'/w/j/wj01-blue_main_1.jpg','image',0),(2056,90,'/w/j/wj01-red_main_1.jpg','image',0),(2057,90,'/w/j/wj01-red_alt1_1.jpg','image',0),(2058,90,'/w/j/wj01-red_back_1.jpg','image',0),(2059,90,'/w/j/wj01-yellow_main_1.jpg','image',0),(2060,90,'/w/j/wj01-blue_main_1.jpg','image',0),(2061,90,'/w/j/wj01-red_main_1.jpg','image',0),(2062,90,'/w/j/wj01-red_alt1_1.jpg','image',0),(2063,90,'/w/j/wj01-red_back_1.jpg','image',0),(2064,90,'/w/j/wj01-yellow_main_1.jpg','image',0),(2065,90,'/w/j/wj01-blue_main_1.jpg','image',0),(2066,90,'/w/j/wj01-red_main_1.jpg','image',0),(2067,90,'/w/j/wj01-red_alt1_1.jpg','image',0),(2068,90,'/w/j/wj01-red_back_1.jpg','image',0),(2069,90,'/w/j/wj01-yellow_main_1.jpg','image',0),(2070,90,'/w/j/wj01-red_main_1.jpg','image',0),(2071,90,'/w/j/wj01-red_alt1_1.jpg','image',0),(2072,90,'/w/j/wj01-red_back_1.jpg','image',0),(2073,90,'/w/j/wj02-black_main_1.jpg','image',0),(2074,90,'/w/j/wj02-blue_main_1.jpg','image',0),(2075,90,'/w/j/wj02-gray_main_1.jpg','image',0),(2076,90,'/w/j/wj02-gray_alt1_1.jpg','image',0),(2077,90,'/w/j/wj02-gray_back_1.jpg','image',0),(2078,90,'/w/j/wj02-black_main_1.jpg','image',0),(2079,90,'/w/j/wj02-blue_main_1.jpg','image',0),(2080,90,'/w/j/wj02-gray_main_1.jpg','image',0),(2081,90,'/w/j/wj02-gray_alt1_1.jpg','image',0),(2082,90,'/w/j/wj02-gray_back_1.jpg','image',0),(2083,90,'/w/j/wj02-black_main_1.jpg','image',0),(2084,90,'/w/j/wj02-blue_main_1.jpg','image',0),(2085,90,'/w/j/wj02-gray_main_1.jpg','image',0),(2086,90,'/w/j/wj02-gray_alt1_1.jpg','image',0),(2087,90,'/w/j/wj02-gray_back_1.jpg','image',0),(2088,90,'/w/j/wj02-black_main_1.jpg','image',0),(2089,90,'/w/j/wj02-blue_main_1.jpg','image',0),(2090,90,'/w/j/wj02-gray_main_1.jpg','image',0),(2091,90,'/w/j/wj02-gray_alt1_1.jpg','image',0),(2092,90,'/w/j/wj02-gray_back_1.jpg','image',0),(2093,90,'/w/j/wj02-black_main_1.jpg','image',0),(2094,90,'/w/j/wj02-blue_main_1.jpg','image',0),(2095,90,'/w/j/wj02-gray_main_1.jpg','image',0),(2096,90,'/w/j/wj02-gray_alt1_1.jpg','image',0),(2097,90,'/w/j/wj02-gray_back_1.jpg','image',0),(2098,90,'/w/j/wj02-gray_main_1.jpg','image',0),(2099,90,'/w/j/wj02-gray_alt1_1.jpg','image',0),(2100,90,'/w/j/wj02-gray_back_1.jpg','image',0),(2101,90,'/w/j/wj03-blue_main_1.jpg','image',0),(2102,90,'/w/j/wj03-orange_main_1.jpg','image',0),(2103,90,'/w/j/wj03-red_main_1.jpg','image',0),(2104,90,'/w/j/wj03-red_alt1_1.jpg','image',0),(2105,90,'/w/j/wj03-red_back_1.jpg','image',0),(2106,90,'/w/j/wj03-blue_main_1.jpg','image',0),(2107,90,'/w/j/wj03-orange_main_1.jpg','image',0),(2108,90,'/w/j/wj03-red_main_1.jpg','image',0),(2109,90,'/w/j/wj03-red_alt1_1.jpg','image',0),(2110,90,'/w/j/wj03-red_back_1.jpg','image',0),(2111,90,'/w/j/wj03-blue_main_1.jpg','image',0),(2112,90,'/w/j/wj03-orange_main_1.jpg','image',0),(2113,90,'/w/j/wj03-red_main_1.jpg','image',0),(2114,90,'/w/j/wj03-red_alt1_1.jpg','image',0),(2115,90,'/w/j/wj03-red_back_1.jpg','image',0),(2116,90,'/w/j/wj03-blue_main_1.jpg','image',0),(2117,90,'/w/j/wj03-orange_main_2.jpg','image',0),(2118,90,'/w/j/wj03-red_main_2.jpg','image',0),(2119,90,'/w/j/wj03-red_alt1_2.jpg','image',0),(2120,90,'/w/j/wj03-red_back_2.jpg','image',0),(2121,90,'/w/j/wj03-blue_main_2.jpg','image',0),(2122,90,'/w/j/wj03-orange_main_2.jpg','image',0),(2123,90,'/w/j/wj03-red_main_2.jpg','image',0),(2124,90,'/w/j/wj03-red_alt1_2.jpg','image',0),(2125,90,'/w/j/wj03-red_back_2.jpg','image',0),(2126,90,'/w/j/wj03-red_main_2.jpg','image',0),(2127,90,'/w/j/wj03-red_alt1_2.jpg','image',0),(2128,90,'/w/j/wj03-red_back_2.jpg','image',0),(2129,90,'/w/j/wj04-orange_main_1.jpg','image',0),(2130,90,'/w/j/wj04-red_main_1.jpg','image',0),(2131,90,'/w/j/wj04-white_main_1.jpg','image',0),(2132,90,'/w/j/wj04-white_alt1_1.jpg','image',0),(2133,90,'/w/j/wj04-white_alternate_1.jpg','image',0),(2134,90,'/w/j/wj04-white_back_1.jpg','image',0),(2135,90,'/w/j/wj04-orange_main_1.jpg','image',0),(2136,90,'/w/j/wj04-red_main_1.jpg','image',0),(2137,90,'/w/j/wj04-white_main_1.jpg','image',0),(2138,90,'/w/j/wj04-white_alt1_1.jpg','image',0),(2139,90,'/w/j/wj04-white_alternate_1.jpg','image',0),(2140,90,'/w/j/wj04-white_back_1.jpg','image',0),(2141,90,'/w/j/wj04-orange_main_1.jpg','image',0),(2142,90,'/w/j/wj04-red_main_1.jpg','image',0),(2143,90,'/w/j/wj04-white_main_1.jpg','image',0),(2144,90,'/w/j/wj04-white_alt1_1.jpg','image',0),(2145,90,'/w/j/wj04-white_alternate_1.jpg','image',0),(2146,90,'/w/j/wj04-white_back_1.jpg','image',0),(2147,90,'/w/j/wj04-orange_main_1.jpg','image',0),(2148,90,'/w/j/wj04-red_main_1.jpg','image',0),(2149,90,'/w/j/wj04-white_main_1.jpg','image',0),(2150,90,'/w/j/wj04-white_alt1_1.jpg','image',0),(2151,90,'/w/j/wj04-white_alternate_1.jpg','image',0),(2152,90,'/w/j/wj04-white_back_1.jpg','image',0),(2153,90,'/w/j/wj04-orange_main_1.jpg','image',0),(2154,90,'/w/j/wj04-red_main_1.jpg','image',0),(2155,90,'/w/j/wj04-white_main_1.jpg','image',0),(2156,90,'/w/j/wj04-white_alt1_1.jpg','image',0),(2157,90,'/w/j/wj04-white_alternate_1.jpg','image',0),(2158,90,'/w/j/wj04-white_back_1.jpg','image',0),(2159,90,'/w/j/wj04-white_main_1.jpg','image',0),(2160,90,'/w/j/wj04-white_alt1_1.jpg','image',0),(2161,90,'/w/j/wj04-white_alternate_1.jpg','image',0),(2162,90,'/w/j/wj04-white_back_1.jpg','image',0),(2163,90,'/w/j/wj05-brown_main_1.jpg','image',0),(2164,90,'/w/j/wj05-brown_alt1_1.jpg','image',0),(2165,90,'/w/j/wj05-brown_back_1.jpg','image',0),(2166,90,'/w/j/wj05-green_main_1.jpg','image',0),(2167,90,'/w/j/wj05-red_main_1.jpg','image',0),(2168,90,'/w/j/wj05-brown_main_1.jpg','image',0),(2169,90,'/w/j/wj05-brown_alt1_1.jpg','image',0),(2170,90,'/w/j/wj05-brown_back_1.jpg','image',0),(2171,90,'/w/j/wj05-green_main_1.jpg','image',0),(2172,90,'/w/j/wj05-red_main_1.jpg','image',0),(2173,90,'/w/j/wj05-brown_main_1.jpg','image',0),(2174,90,'/w/j/wj05-brown_alt1_1.jpg','image',0),(2175,90,'/w/j/wj05-brown_back_1.jpg','image',0),(2176,90,'/w/j/wj05-green_main_1.jpg','image',0),(2177,90,'/w/j/wj05-red_main_1.jpg','image',0),(2178,90,'/w/j/wj05-brown_main_1.jpg','image',0),(2179,90,'/w/j/wj05-brown_alt1_1.jpg','image',0),(2180,90,'/w/j/wj05-brown_back_1.jpg','image',0),(2181,90,'/w/j/wj05-green_main_1.jpg','image',0),(2182,90,'/w/j/wj05-red_main_1.jpg','image',0),(2183,90,'/w/j/wj05-brown_main_1.jpg','image',0),(2184,90,'/w/j/wj05-brown_alt1_1.jpg','image',0),(2185,90,'/w/j/wj05-brown_back_1.jpg','image',0),(2186,90,'/w/j/wj05-green_main_1.jpg','image',0),(2187,90,'/w/j/wj05-red_main_1.jpg','image',0),(2188,90,'/w/j/wj05-brown_main_1.jpg','image',0),(2189,90,'/w/j/wj05-brown_alt1_1.jpg','image',0),(2190,90,'/w/j/wj05-brown_back_1.jpg','image',0),(2191,90,'/w/j/wj07-orange_main_1.jpg','image',0),(2192,90,'/w/j/wj07-purple_main_1.jpg','image',0),(2193,90,'/w/j/wj07-purple_alt1_1.jpg','image',0),(2194,90,'/w/j/wj07-purple_back_1.jpg','image',0),(2195,90,'/w/j/wj07-red_main_1.jpg','image',0),(2196,90,'/w/j/wj07-orange_main_1.jpg','image',0),(2197,90,'/w/j/wj07-purple_main_1.jpg','image',0),(2198,90,'/w/j/wj07-purple_alt1_1.jpg','image',0),(2199,90,'/w/j/wj07-purple_back_1.jpg','image',0),(2200,90,'/w/j/wj07-red_main_1.jpg','image',0),(2201,90,'/w/j/wj07-orange_main_1.jpg','image',0),(2202,90,'/w/j/wj07-purple_main_1.jpg','image',0),(2203,90,'/w/j/wj07-purple_alt1_1.jpg','image',0),(2204,90,'/w/j/wj07-purple_back_1.jpg','image',0),(2205,90,'/w/j/wj07-red_main_1.jpg','image',0),(2206,90,'/w/j/wj07-orange_main_1.jpg','image',0),(2207,90,'/w/j/wj07-purple_main_1.jpg','image',0),(2208,90,'/w/j/wj07-purple_alt1_1.jpg','image',0),(2209,90,'/w/j/wj07-purple_back_1.jpg','image',0),(2210,90,'/w/j/wj07-red_main_1.jpg','image',0),(2211,90,'/w/j/wj07-orange_main_1.jpg','image',0),(2212,90,'/w/j/wj07-purple_main_1.jpg','image',0),(2213,90,'/w/j/wj07-purple_alt1_1.jpg','image',0),(2214,90,'/w/j/wj07-purple_back_1.jpg','image',0),(2215,90,'/w/j/wj07-red_main_1.jpg','image',0),(2216,90,'/w/j/wj07-purple_main_1.jpg','image',0),(2217,90,'/w/j/wj07-purple_alt1_1.jpg','image',0),(2218,90,'/w/j/wj07-purple_back_1.jpg','image',0),(2219,90,'/w/j/wj08-gray_main_1.jpg','image',0),(2220,90,'/w/j/wj08-gray_alt1_1.jpg','image',0),(2221,90,'/w/j/wj08-gray_alternate_1.jpg','image',0),(2222,90,'/w/j/wj08-gray_back_1.jpg','image',0),(2223,90,'/w/j/wj08-orange_main_1.jpg','image',0),(2224,90,'/w/j/wj08-purple_main_1.jpg','image',0),(2225,90,'/w/j/wj08-gray_main_1.jpg','image',0),(2226,90,'/w/j/wj08-gray_alt1_1.jpg','image',0),(2227,90,'/w/j/wj08-gray_alternate_1.jpg','image',0),(2228,90,'/w/j/wj08-gray_back_1.jpg','image',0),(2229,90,'/w/j/wj08-orange_main_1.jpg','image',0),(2230,90,'/w/j/wj08-purple_main_1.jpg','image',0),(2231,90,'/w/j/wj08-gray_main_1.jpg','image',0),(2232,90,'/w/j/wj08-gray_alt1_1.jpg','image',0),(2233,90,'/w/j/wj08-gray_alternate_1.jpg','image',0),(2234,90,'/w/j/wj08-gray_back_1.jpg','image',0),(2235,90,'/w/j/wj08-orange_main_1.jpg','image',0),(2236,90,'/w/j/wj08-purple_main_1.jpg','image',0),(2237,90,'/w/j/wj08-gray_main_1.jpg','image',0),(2238,90,'/w/j/wj08-gray_alt1_1.jpg','image',0),(2239,90,'/w/j/wj08-gray_alternate_1.jpg','image',0),(2240,90,'/w/j/wj08-gray_back_1.jpg','image',0),(2241,90,'/w/j/wj08-orange_main_1.jpg','image',0),(2242,90,'/w/j/wj08-purple_main_1.jpg','image',0),(2243,90,'/w/j/wj08-gray_main_1.jpg','image',0),(2244,90,'/w/j/wj08-gray_alt1_1.jpg','image',0),(2245,90,'/w/j/wj08-gray_alternate_1.jpg','image',0),(2246,90,'/w/j/wj08-gray_back_1.jpg','image',0),(2247,90,'/w/j/wj08-orange_main_1.jpg','image',0),(2248,90,'/w/j/wj08-purple_main_1.jpg','image',0),(2249,90,'/w/j/wj08-gray_main_1.jpg','image',0),(2250,90,'/w/j/wj08-gray_alt1_1.jpg','image',0),(2251,90,'/w/j/wj08-gray_alternate_1.jpg','image',0),(2252,90,'/w/j/wj08-gray_back_1.jpg','image',0),(2253,90,'/w/j/wj09-blue_main_1.jpg','image',0),(2254,90,'/w/j/wj09-gray_main_1.jpg','image',0),(2255,90,'/w/j/wj09-green_main_1.jpg','image',0),(2256,90,'/w/j/wj09-green_alt1_1.jpg','image',0),(2257,90,'/w/j/wj09-green_back_1.jpg','image',0),(2258,90,'/w/j/wj09-blue_main_1.jpg','image',0),(2259,90,'/w/j/wj09-gray_main_1.jpg','image',0),(2260,90,'/w/j/wj09-green_main_1.jpg','image',0),(2261,90,'/w/j/wj09-green_alt1_1.jpg','image',0),(2262,90,'/w/j/wj09-green_back_1.jpg','image',0),(2263,90,'/w/j/wj09-blue_main_1.jpg','image',0),(2264,90,'/w/j/wj09-gray_main_1.jpg','image',0),(2265,90,'/w/j/wj09-green_main_1.jpg','image',0),(2266,90,'/w/j/wj09-green_alt1_1.jpg','image',0),(2267,90,'/w/j/wj09-green_back_1.jpg','image',0),(2268,90,'/w/j/wj09-blue_main_1.jpg','image',0),(2269,90,'/w/j/wj09-gray_main_1.jpg','image',0),(2270,90,'/w/j/wj09-green_main_1.jpg','image',0),(2271,90,'/w/j/wj09-green_alt1_1.jpg','image',0),(2272,90,'/w/j/wj09-green_back_1.jpg','image',0),(2273,90,'/w/j/wj09-blue_main_1.jpg','image',0),(2274,90,'/w/j/wj09-gray_main_1.jpg','image',0),(2275,90,'/w/j/wj09-green_main_1.jpg','image',0),(2276,90,'/w/j/wj09-green_alt1_1.jpg','image',0),(2277,90,'/w/j/wj09-green_back_1.jpg','image',0),(2278,90,'/w/j/wj09-green_main_1.jpg','image',0),(2279,90,'/w/j/wj09-green_alt1_1.jpg','image',0),(2280,90,'/w/j/wj09-green_back_1.jpg','image',0),(2281,90,'/w/j/wj10-black_main_1.jpg','image',0),(2282,90,'/w/j/wj10-orange_main_1.jpg','image',0),(2283,90,'/w/j/wj10-yellow_main_1.jpg','image',0),(2284,90,'/w/j/wj10-yellow_alt1_1.jpg','image',0),(2285,90,'/w/j/wj10-yellow_back_1.jpg','image',0),(2286,90,'/w/j/wj10-black_main_1.jpg','image',0),(2287,90,'/w/j/wj10-orange_main_1.jpg','image',0),(2288,90,'/w/j/wj10-yellow_main_1.jpg','image',0),(2289,90,'/w/j/wj10-yellow_alt1_1.jpg','image',0),(2290,90,'/w/j/wj10-yellow_back_1.jpg','image',0),(2291,90,'/w/j/wj10-black_main_1.jpg','image',0),(2292,90,'/w/j/wj10-orange_main_1.jpg','image',0),(2293,90,'/w/j/wj10-yellow_main_1.jpg','image',0),(2294,90,'/w/j/wj10-yellow_alt1_1.jpg','image',0),(2295,90,'/w/j/wj10-yellow_back_1.jpg','image',0),(2296,90,'/w/j/wj10-black_main_1.jpg','image',0),(2297,90,'/w/j/wj10-orange_main_1.jpg','image',0),(2298,90,'/w/j/wj10-yellow_main_1.jpg','image',0),(2299,90,'/w/j/wj10-yellow_alt1_1.jpg','image',0),(2300,90,'/w/j/wj10-yellow_back_1.jpg','image',0),(2301,90,'/w/j/wj10-black_main_1.jpg','image',0),(2302,90,'/w/j/wj10-orange_main_1.jpg','image',0),(2303,90,'/w/j/wj10-yellow_main_2.jpg','image',0),(2304,90,'/w/j/wj10-yellow_alt1_2.jpg','image',0),(2305,90,'/w/j/wj10-yellow_back_2.jpg','image',0),(2306,90,'/w/j/wj10-yellow_main_2.jpg','image',0),(2307,90,'/w/j/wj10-yellow_alt1_2.jpg','image',0),(2308,90,'/w/j/wj10-yellow_back_2.jpg','image',0),(2309,90,'/w/j/wj11-black_main_1.jpg','image',0),(2310,90,'/w/j/wj11-blue_main_1.jpg','image',0),(2311,90,'/w/j/wj11-blue_alt1_1.jpg','image',0),(2312,90,'/w/j/wj11-blue_back_1.jpg','image',0),(2313,90,'/w/j/wj11-orange_main_1.jpg','image',0),(2314,90,'/w/j/wj11-black_main_1.jpg','image',0),(2315,90,'/w/j/wj11-blue_main_1.jpg','image',0),(2316,90,'/w/j/wj11-blue_alt1_1.jpg','image',0),(2317,90,'/w/j/wj11-blue_back_1.jpg','image',0),(2318,90,'/w/j/wj11-orange_main_1.jpg','image',0),(2319,90,'/w/j/wj11-black_main_1.jpg','image',0),(2320,90,'/w/j/wj11-blue_main_1.jpg','image',0),(2321,90,'/w/j/wj11-blue_alt1_1.jpg','image',0),(2322,90,'/w/j/wj11-blue_back_1.jpg','image',0),(2323,90,'/w/j/wj11-orange_main_1.jpg','image',0),(2324,90,'/w/j/wj11-black_main_1.jpg','image',0),(2325,90,'/w/j/wj11-blue_main_1.jpg','image',0),(2326,90,'/w/j/wj11-blue_alt1_1.jpg','image',0),(2327,90,'/w/j/wj11-blue_back_1.jpg','image',0),(2328,90,'/w/j/wj11-orange_main_1.jpg','image',0),(2329,90,'/w/j/wj11-black_main_1.jpg','image',0),(2330,90,'/w/j/wj11-blue_main_1.jpg','image',0),(2331,90,'/w/j/wj11-blue_alt1_1.jpg','image',0),(2332,90,'/w/j/wj11-blue_back_1.jpg','image',0),(2333,90,'/w/j/wj11-orange_main_1.jpg','image',0),(2334,90,'/w/j/wj11-blue_main_1.jpg','image',0),(2335,90,'/w/j/wj11-blue_alt1_1.jpg','image',0),(2336,90,'/w/j/wj11-blue_back_1.jpg','image',0),(2337,90,'/w/j/wj06-blue_main_1.jpg','image',0),(2338,90,'/w/j/wj06-green_main_1.jpg','image',0),(2339,90,'/w/j/wj06-purple_main_1.jpg','image',0),(2340,90,'/w/j/wj06-purple_alt1_1.jpg','image',0),(2341,90,'/w/j/wj06-purple_back_1.jpg','image',0),(2342,90,'/w/j/wj06-blue_main_1.jpg','image',0),(2343,90,'/w/j/wj06-green_main_1.jpg','image',0),(2344,90,'/w/j/wj06-purple_main_1.jpg','image',0),(2345,90,'/w/j/wj06-purple_alt1_1.jpg','image',0),(2346,90,'/w/j/wj06-purple_back_1.jpg','image',0),(2347,90,'/w/j/wj06-blue_main_1.jpg','image',0),(2348,90,'/w/j/wj06-green_main_1.jpg','image',0),(2349,90,'/w/j/wj06-purple_main_1.jpg','image',0),(2350,90,'/w/j/wj06-purple_alt1_1.jpg','image',0),(2351,90,'/w/j/wj06-purple_back_1.jpg','image',0),(2352,90,'/w/j/wj06-blue_main_1.jpg','image',0),(2353,90,'/w/j/wj06-green_main_1.jpg','image',0),(2354,90,'/w/j/wj06-purple_main_1.jpg','image',0),(2355,90,'/w/j/wj06-purple_alt1_1.jpg','image',0),(2356,90,'/w/j/wj06-purple_back_1.jpg','image',0),(2357,90,'/w/j/wj06-blue_main_1.jpg','image',0),(2358,90,'/w/j/wj06-green_main_1.jpg','image',0),(2359,90,'/w/j/wj06-purple_main_1.jpg','image',0),(2360,90,'/w/j/wj06-purple_alt1_1.jpg','image',0),(2361,90,'/w/j/wj06-purple_back_1.jpg','image',0),(2362,90,'/w/j/wj06-purple_main_1.jpg','image',0),(2363,90,'/w/j/wj06-purple_alt1_1.jpg','image',0),(2364,90,'/w/j/wj06-purple_back_1.jpg','image',0),(2365,90,'/w/j/wj12-black_main_1.jpg','image',0),(2366,90,'/w/j/wj12-blue_main_1.jpg','image',0),(2367,90,'/w/j/wj12-blue_alt1_1.jpg','image',0),(2368,90,'/w/j/wj12-blue_back_1.jpg','image',0),(2369,90,'/w/j/wj12-purple_main_1.jpg','image',0),(2370,90,'/w/j/wj12-black_main_1.jpg','image',0),(2371,90,'/w/j/wj12-blue_main_1.jpg','image',0),(2372,90,'/w/j/wj12-blue_alt1_1.jpg','image',0),(2373,90,'/w/j/wj12-blue_back_1.jpg','image',0),(2374,90,'/w/j/wj12-purple_main_1.jpg','image',0),(2375,90,'/w/j/wj12-black_main_1.jpg','image',0),(2376,90,'/w/j/wj12-blue_main_1.jpg','image',0),(2377,90,'/w/j/wj12-blue_alt1_1.jpg','image',0),(2378,90,'/w/j/wj12-blue_back_1.jpg','image',0),(2379,90,'/w/j/wj12-purple_main_1.jpg','image',0),(2380,90,'/w/j/wj12-black_main_1.jpg','image',0),(2381,90,'/w/j/wj12-blue_main_1.jpg','image',0),(2382,90,'/w/j/wj12-blue_alt1_1.jpg','image',0),(2383,90,'/w/j/wj12-blue_back_1.jpg','image',0),(2384,90,'/w/j/wj12-purple_main_1.jpg','image',0),(2385,90,'/w/j/wj12-black_main_1.jpg','image',0),(2386,90,'/w/j/wj12-blue_main_1.jpg','image',0),(2387,90,'/w/j/wj12-blue_alt1_1.jpg','image',0),(2388,90,'/w/j/wj12-blue_back_1.jpg','image',0),(2389,90,'/w/j/wj12-purple_main_1.jpg','image',0),(2390,90,'/w/j/wj12-blue_main_1.jpg','image',0),(2391,90,'/w/j/wj12-blue_alt1_1.jpg','image',0),(2392,90,'/w/j/wj12-blue_back_1.jpg','image',0),(2393,90,'/w/s/ws02-blue_main_1.jpg','image',0),(2394,90,'/w/s/ws02-green_main_1.jpg','image',0),(2395,90,'/w/s/ws02-green_back_1.jpg','image',0),(2396,90,'/w/s/ws02-red_main_1.jpg','image',0),(2397,90,'/w/s/ws02-blue_main_1.jpg','image',0),(2398,90,'/w/s/ws02-green_main_1.jpg','image',0),(2399,90,'/w/s/ws02-green_back_1.jpg','image',0),(2400,90,'/w/s/ws02-red_main_1.jpg','image',0),(2401,90,'/w/s/ws02-blue_main_1.jpg','image',0),(2402,90,'/w/s/ws02-green_main_1.jpg','image',0),(2403,90,'/w/s/ws02-green_back_1.jpg','image',0),(2404,90,'/w/s/ws02-red_main_1.jpg','image',0),(2405,90,'/w/s/ws02-blue_main_1.jpg','image',0),(2406,90,'/w/s/ws02-green_main_1.jpg','image',0),(2407,90,'/w/s/ws02-green_back_1.jpg','image',0),(2408,90,'/w/s/ws02-red_main_1.jpg','image',0),(2409,90,'/w/s/ws02-blue_main_1.jpg','image',0),(2410,90,'/w/s/ws02-green_main_1.jpg','image',0),(2411,90,'/w/s/ws02-green_back_1.jpg','image',0),(2412,90,'/w/s/ws02-red_main_1.jpg','image',0),(2413,90,'/w/s/ws02-green_main_1.jpg','image',0),(2414,90,'/w/s/ws02-green_back_1.jpg','image',0),(2415,90,'/w/s/ws03-blue_main_1.jpg','image',0),(2416,90,'/w/s/ws03-green_main_1.jpg','image',0),(2417,90,'/w/s/ws03-red_main_1.jpg','image',0),(2418,90,'/w/s/ws03-red_alt1_1.jpg','image',0),(2419,90,'/w/s/ws03-red_back_1.jpg','image',0),(2420,90,'/w/s/ws03-blue_main_1.jpg','image',0),(2421,90,'/w/s/ws03-green_main_1.jpg','image',0),(2422,90,'/w/s/ws03-red_main_1.jpg','image',0),(2423,90,'/w/s/ws03-red_alt1_1.jpg','image',0),(2424,90,'/w/s/ws03-red_back_1.jpg','image',0),(2425,90,'/w/s/ws03-blue_main_1.jpg','image',0),(2426,90,'/w/s/ws03-green_main_1.jpg','image',0),(2427,90,'/w/s/ws03-red_main_1.jpg','image',0),(2428,90,'/w/s/ws03-red_alt1_1.jpg','image',0),(2429,90,'/w/s/ws03-red_back_1.jpg','image',0),(2430,90,'/w/s/ws03-blue_main_1.jpg','image',0),(2431,90,'/w/s/ws03-green_main_1.jpg','image',0),(2432,90,'/w/s/ws03-red_main_1.jpg','image',0),(2433,90,'/w/s/ws03-red_alt1_1.jpg','image',0),(2434,90,'/w/s/ws03-red_back_1.jpg','image',0),(2435,90,'/w/s/ws03-blue_main_1.jpg','image',0),(2436,90,'/w/s/ws03-green_main_1.jpg','image',0),(2437,90,'/w/s/ws03-red_main_1.jpg','image',0),(2438,90,'/w/s/ws03-red_alt1_1.jpg','image',0),(2439,90,'/w/s/ws03-red_back_1.jpg','image',0),(2440,90,'/w/s/ws03-red_main_1.jpg','image',0),(2441,90,'/w/s/ws03-red_alt1_1.jpg','image',0),(2442,90,'/w/s/ws03-red_back_1.jpg','image',0),(2443,90,'/w/s/ws04-blue_main_1.jpg','image',0),(2444,90,'/w/s/ws04-green_main_1.jpg','image',0),(2445,90,'/w/s/ws04-green_back_1.jpg','image',0),(2446,90,'/w/s/ws04-red_main_1.jpg','image',0),(2447,90,'/w/s/ws04-blue_main_1.jpg','image',0),(2448,90,'/w/s/ws04-green_main_1.jpg','image',0),(2449,90,'/w/s/ws04-green_back_1.jpg','image',0),(2450,90,'/w/s/ws04-red_main_1.jpg','image',0),(2451,90,'/w/s/ws04-blue_main_1.jpg','image',0),(2452,90,'/w/s/ws04-green_main_1.jpg','image',0),(2453,90,'/w/s/ws04-green_back_1.jpg','image',0),(2454,90,'/w/s/ws04-red_main_1.jpg','image',0),(2455,90,'/w/s/ws04-blue_main_1.jpg','image',0),(2456,90,'/w/s/ws04-green_main_1.jpg','image',0),(2457,90,'/w/s/ws04-green_back_1.jpg','image',0),(2458,90,'/w/s/ws04-red_main_1.jpg','image',0),(2459,90,'/w/s/ws04-blue_main_1.jpg','image',0),(2460,90,'/w/s/ws04-green_main_1.jpg','image',0),(2461,90,'/w/s/ws04-green_back_1.jpg','image',0),(2462,90,'/w/s/ws04-red_main_1.jpg','image',0),(2463,90,'/w/s/ws04-green_main_1.jpg','image',0),(2464,90,'/w/s/ws04-green_back_1.jpg','image',0),(2465,90,'/w/s/ws06-gray_main_1.jpg','image',0),(2466,90,'/w/s/ws06-purple_main_1.jpg','image',0),(2467,90,'/w/s/ws06-purple_back_1.jpg','image',0),(2468,90,'/w/s/ws06-red_main_1.jpg','image',0),(2469,90,'/w/s/ws06-gray_main_2.jpg','image',0),(2470,90,'/w/s/ws06-purple_main_2.jpg','image',0),(2471,90,'/w/s/ws06-purple_back_2.jpg','image',0),(2472,90,'/w/s/ws06-red_main_1.jpg','image',0),(2473,90,'/w/s/ws06-gray_main_2.jpg','image',0),(2474,90,'/w/s/ws06-purple_main_2.jpg','image',0),(2475,90,'/w/s/ws06-purple_back_2.jpg','image',0),(2476,90,'/w/s/ws06-red_main_1.jpg','image',0),(2477,90,'/w/s/ws06-gray_main_2.jpg','image',0),(2478,90,'/w/s/ws06-purple_main_2.jpg','image',0),(2479,90,'/w/s/ws06-purple_back_2.jpg','image',0),(2480,90,'/w/s/ws06-red_main_1.jpg','image',0),(2481,90,'/w/s/ws06-gray_main_2.jpg','image',0),(2482,90,'/w/s/ws06-purple_main_2.jpg','image',0),(2483,90,'/w/s/ws06-purple_back_2.jpg','image',0),(2484,90,'/w/s/ws06-red_main_1.jpg','image',0),(2485,90,'/w/s/ws06-purple_main_2.jpg','image',0),(2486,90,'/w/s/ws06-purple_back_2.jpg','image',0),(2487,90,'/w/s/ws07-black_main_1.jpg','image',0),(2488,90,'/w/s/ws07-black_alt1_1.jpg','image',0),(2489,90,'/w/s/ws07-black_back_1.jpg','image',0),(2490,90,'/w/s/ws07-white_main_1.jpg','image',0),(2491,90,'/w/s/ws07-yellow_main_1.jpg','image',0),(2492,90,'/w/s/ws07-black_main_1.jpg','image',0),(2493,90,'/w/s/ws07-black_alt1_1.jpg','image',0),(2494,90,'/w/s/ws07-black_back_1.jpg','image',0),(2495,90,'/w/s/ws07-white_main_1.jpg','image',0),(2496,90,'/w/s/ws07-yellow_main_1.jpg','image',0),(2497,90,'/w/s/ws07-black_main_1.jpg','image',0),(2498,90,'/w/s/ws07-black_alt1_1.jpg','image',0),(2499,90,'/w/s/ws07-black_back_1.jpg','image',0),(2500,90,'/w/s/ws07-white_main_1.jpg','image',0),(2501,90,'/w/s/ws07-yellow_main_1.jpg','image',0),(2502,90,'/w/s/ws07-black_main_1.jpg','image',0),(2503,90,'/w/s/ws07-black_alt1_1.jpg','image',0),(2504,90,'/w/s/ws07-black_back_1.jpg','image',0),(2505,90,'/w/s/ws07-white_main_1.jpg','image',0),(2506,90,'/w/s/ws07-yellow_main_1.jpg','image',0),(2507,90,'/w/s/ws07-black_main_1.jpg','image',0),(2508,90,'/w/s/ws07-black_alt1_1.jpg','image',0),(2509,90,'/w/s/ws07-black_back_1.jpg','image',0),(2510,90,'/w/s/ws07-white_main_1.jpg','image',0),(2511,90,'/w/s/ws07-yellow_main_1.jpg','image',0),(2512,90,'/w/s/ws07-black_main_1.jpg','image',0),(2513,90,'/w/s/ws07-black_alt1_1.jpg','image',0),(2514,90,'/w/s/ws07-black_back_1.jpg','image',0),(2515,90,'/w/s/ws08-black_main_1.jpg','image',0),(2516,90,'/w/s/ws08-blue_main_1.jpg','image',0),(2517,90,'/w/s/ws08-blue_back_1.jpg','image',0),(2518,90,'/w/s/ws08-red_main_1.jpg','image',0),(2519,90,'/w/s/ws08-black_main_1.jpg','image',0),(2520,90,'/w/s/ws08-blue_main_1.jpg','image',0),(2521,90,'/w/s/ws08-blue_back_1.jpg','image',0),(2522,90,'/w/s/ws08-red_main_1.jpg','image',0),(2523,90,'/w/s/ws08-black_main_1.jpg','image',0),(2524,90,'/w/s/ws08-blue_main_1.jpg','image',0),(2525,90,'/w/s/ws08-blue_back_1.jpg','image',0),(2526,90,'/w/s/ws08-red_main_1.jpg','image',0),(2527,90,'/w/s/ws08-black_main_1.jpg','image',0),(2528,90,'/w/s/ws08-blue_main_1.jpg','image',0),(2529,90,'/w/s/ws08-blue_back_1.jpg','image',0),(2530,90,'/w/s/ws08-red_main_1.jpg','image',0),(2531,90,'/w/s/ws08-black_main_1.jpg','image',0),(2532,90,'/w/s/ws08-blue_main_1.jpg','image',0),(2533,90,'/w/s/ws08-blue_back_1.jpg','image',0),(2534,90,'/w/s/ws08-red_main_1.jpg','image',0),(2535,90,'/w/s/ws08-blue_main_1.jpg','image',0),(2536,90,'/w/s/ws08-blue_back_1.jpg','image',0),(2537,90,'/w/s/ws09-blue_main_1.jpg','image',0),(2538,90,'/w/s/ws09-blue_back_1.jpg','image',0),(2539,90,'/w/s/ws09-red_main_1.jpg','image',0),(2540,90,'/w/s/ws09-white_main_1.jpg','image',0),(2541,90,'/w/s/ws09-blue_main_1.jpg','image',0),(2542,90,'/w/s/ws09-blue_back_1.jpg','image',0),(2543,90,'/w/s/ws09-red_main_1.jpg','image',0),(2544,90,'/w/s/ws09-white_main_1.jpg','image',0),(2545,90,'/w/s/ws09-blue_main_1.jpg','image',0),(2546,90,'/w/s/ws09-blue_back_1.jpg','image',0),(2547,90,'/w/s/ws09-red_main_1.jpg','image',0),(2548,90,'/w/s/ws09-white_main_1.jpg','image',0),(2549,90,'/w/s/ws09-blue_main_1.jpg','image',0),(2550,90,'/w/s/ws09-blue_back_1.jpg','image',0),(2551,90,'/w/s/ws09-red_main_1.jpg','image',0),(2552,90,'/w/s/ws09-white_main_1.jpg','image',0),(2553,90,'/w/s/ws09-blue_main_1.jpg','image',0),(2554,90,'/w/s/ws09-blue_back_1.jpg','image',0),(2555,90,'/w/s/ws09-red_main_1.jpg','image',0),(2556,90,'/w/s/ws09-white_main_1.jpg','image',0),(2557,90,'/w/s/ws09-blue_main_1.jpg','image',0),(2558,90,'/w/s/ws09-blue_back_1.jpg','image',0),(2559,90,'/w/s/ws10-green_main_1.jpg','image',0),(2560,90,'/w/s/ws10-red_main_1.jpg','image',0),(2561,90,'/w/s/ws10-red_back_1.jpg','image',0),(2562,90,'/w/s/ws10-yellow_main_1.jpg','image',0),(2563,90,'/w/s/ws10-green_main_1.jpg','image',0),(2564,90,'/w/s/ws10-red_main_1.jpg','image',0),(2565,90,'/w/s/ws10-red_back_1.jpg','image',0),(2566,90,'/w/s/ws10-yellow_main_1.jpg','image',0),(2567,90,'/w/s/ws10-green_main_1.jpg','image',0),(2568,90,'/w/s/ws10-red_main_1.jpg','image',0),(2569,90,'/w/s/ws10-red_back_1.jpg','image',0),(2570,90,'/w/s/ws10-yellow_main_1.jpg','image',0),(2571,90,'/w/s/ws10-green_main_1.jpg','image',0),(2572,90,'/w/s/ws10-red_main_1.jpg','image',0),(2573,90,'/w/s/ws10-red_back_1.jpg','image',0),(2574,90,'/w/s/ws10-yellow_main_1.jpg','image',0),(2575,90,'/w/s/ws10-green_main_1.jpg','image',0),(2576,90,'/w/s/ws10-red_main_1.jpg','image',0),(2577,90,'/w/s/ws10-red_back_1.jpg','image',0),(2578,90,'/w/s/ws10-yellow_main_1.jpg','image',0),(2579,90,'/w/s/ws10-red_main_1.jpg','image',0),(2580,90,'/w/s/ws10-red_back_1.jpg','image',0),(2581,90,'/w/s/ws11-green_main_1.jpg','image',0),(2582,90,'/w/s/ws11-orange_main_1.jpg','image',0),(2583,90,'/w/s/ws11-yellow_main_1.jpg','image',0),(2584,90,'/w/s/ws11-yellow_back_1.jpg','image',0),(2585,90,'/w/s/ws11-green_main_1.jpg','image',0),(2586,90,'/w/s/ws11-orange_main_1.jpg','image',0),(2587,90,'/w/s/ws11-yellow_main_1.jpg','image',0),(2588,90,'/w/s/ws11-yellow_back_1.jpg','image',0),(2589,90,'/w/s/ws11-green_main_1.jpg','image',0),(2590,90,'/w/s/ws11-orange_main_1.jpg','image',0),(2591,90,'/w/s/ws11-yellow_main_1.jpg','image',0),(2592,90,'/w/s/ws11-yellow_back_1.jpg','image',0),(2593,90,'/w/s/ws11-green_main_1.jpg','image',0),(2594,90,'/w/s/ws11-orange_main_1.jpg','image',0),(2595,90,'/w/s/ws11-yellow_main_1.jpg','image',0),(2596,90,'/w/s/ws11-yellow_back_1.jpg','image',0),(2597,90,'/w/s/ws11-green_main_1.jpg','image',0),(2598,90,'/w/s/ws11-orange_main_1.jpg','image',0),(2599,90,'/w/s/ws11-yellow_main_1.jpg','image',0),(2600,90,'/w/s/ws11-yellow_back_1.jpg','image',0),(2601,90,'/w/s/ws11-yellow_main_1.jpg','image',0),(2602,90,'/w/s/ws11-yellow_back_1.jpg','image',0),(2603,90,'/w/s/ws12-blue_main_1.jpg','image',0),(2604,90,'/w/s/ws12-orange_main_1.jpg','image',0),(2605,90,'/w/s/ws12-orange_back_1.jpg','image',0),(2606,90,'/w/s/ws12-purple_main_1.jpg','image',0),(2607,90,'/w/s/ws12-blue_main_1.jpg','image',0),(2608,90,'/w/s/ws12-orange_main_1.jpg','image',0),(2609,90,'/w/s/ws12-orange_back_1.jpg','image',0),(2610,90,'/w/s/ws12-purple_main_1.jpg','image',0),(2611,90,'/w/s/ws12-blue_main_2.jpg','image',0),(2612,90,'/w/s/ws12-orange_main_2.jpg','image',0),(2613,90,'/w/s/ws12-orange_back_2.jpg','image',0),(2614,90,'/w/s/ws12-purple_main_2.jpg','image',0),(2615,90,'/w/s/ws12-blue_main_2.jpg','image',0),(2616,90,'/w/s/ws12-orange_main_2.jpg','image',0),(2617,90,'/w/s/ws12-orange_back_2.jpg','image',0),(2618,90,'/w/s/ws12-purple_main_2.jpg','image',0),(2619,90,'/w/s/ws12-blue_main_2.jpg','image',0),(2620,90,'/w/s/ws12-orange_main_2.jpg','image',0),(2621,90,'/w/s/ws12-orange_back_2.jpg','image',0),(2622,90,'/w/s/ws12-purple_main_2.jpg','image',0),(2623,90,'/w/s/ws12-orange_main_2.jpg','image',0),(2624,90,'/w/s/ws12-orange_back_2.jpg','image',0),(2625,90,'/w/s/ws01-black_main_1.jpg','image',0),(2626,90,'/w/s/ws01-black_back_1.jpg','image',0),(2627,90,'/w/s/ws01-green_main_1.jpg','image',0),(2628,90,'/w/s/ws01-yellow_main_1.jpg','image',0),(2629,90,'/w/s/ws01-black_main_1.jpg','image',0),(2630,90,'/w/s/ws01-black_back_1.jpg','image',0),(2631,90,'/w/s/ws01-green_main_1.jpg','image',0),(2632,90,'/w/s/ws01-yellow_main_1.jpg','image',0),(2633,90,'/w/s/ws01-black_main_1.jpg','image',0),(2634,90,'/w/s/ws01-black_back_1.jpg','image',0),(2635,90,'/w/s/ws01-green_main_1.jpg','image',0),(2636,90,'/w/s/ws01-yellow_main_1.jpg','image',0),(2637,90,'/w/s/ws01-black_main_1.jpg','image',0),(2638,90,'/w/s/ws01-black_back_1.jpg','image',0),(2639,90,'/w/s/ws01-green_main_1.jpg','image',0),(2640,90,'/w/s/ws01-yellow_main_1.jpg','image',0),(2641,90,'/w/s/ws01-black_main_1.jpg','image',0),(2642,90,'/w/s/ws01-black_back_1.jpg','image',0),(2643,90,'/w/s/ws01-green_main_1.jpg','image',0),(2644,90,'/w/s/ws01-yellow_main_1.jpg','image',0),(2645,90,'/w/s/ws01-black_main_1.jpg','image',0),(2646,90,'/w/s/ws01-black_back_1.jpg','image',0),(2647,90,'/w/s/ws05-black_main_1.jpg','image',0),(2648,90,'/w/s/ws05-black_alt1_1.jpg','image',0),(2649,90,'/w/s/ws05-black_back_1.jpg','image',0),(2650,90,'/w/s/ws05-orange_main_1.jpg','image',0),(2651,90,'/w/s/ws05-yellow_main_1.jpg','image',0),(2652,90,'/w/s/ws05-black_main_1.jpg','image',0),(2653,90,'/w/s/ws05-black_alt1_1.jpg','image',0),(2654,90,'/w/s/ws05-black_back_1.jpg','image',0),(2655,90,'/w/s/ws05-orange_main_1.jpg','image',0),(2656,90,'/w/s/ws05-yellow_main_1.jpg','image',0),(2657,90,'/w/s/ws05-black_main_1.jpg','image',0),(2658,90,'/w/s/ws05-black_alt1_1.jpg','image',0),(2659,90,'/w/s/ws05-black_back_1.jpg','image',0),(2660,90,'/w/s/ws05-orange_main_1.jpg','image',0),(2661,90,'/w/s/ws05-yellow_main_1.jpg','image',0),(2662,90,'/w/s/ws05-black_main_1.jpg','image',0),(2663,90,'/w/s/ws05-black_alt1_1.jpg','image',0),(2664,90,'/w/s/ws05-black_back_1.jpg','image',0),(2665,90,'/w/s/ws05-orange_main_1.jpg','image',0),(2666,90,'/w/s/ws05-yellow_main_1.jpg','image',0),(2667,90,'/w/s/ws05-black_main_1.jpg','image',0),(2668,90,'/w/s/ws05-black_alt1_1.jpg','image',0),(2669,90,'/w/s/ws05-black_back_1.jpg','image',0),(2670,90,'/w/s/ws05-orange_main_1.jpg','image',0),(2671,90,'/w/s/ws05-yellow_main_1.jpg','image',0),(2672,90,'/w/s/ws05-black_main_1.jpg','image',0),(2673,90,'/w/s/ws05-black_alt1_1.jpg','image',0),(2674,90,'/w/s/ws05-black_back_1.jpg','image',0),(2675,90,'/w/b/wb01-black_main_1.jpg','image',0),(2676,90,'/w/b/wb01-black-0_1.jpg','image',0),(2677,90,'/w/b/wb01-gray_main_1.jpg','image',0),(2678,90,'/w/b/wb01-gray_alt1_1.jpg','image',0),(2679,90,'/w/b/wb01-gray_back_1.jpg','image',0),(2680,90,'/w/b/wb01-purple_main_1.jpg','image',0),(2681,90,'/w/b/wb01-black_main_1.jpg','image',0),(2682,90,'/w/b/wb01-black-0_1.jpg','image',0),(2683,90,'/w/b/wb01-gray_main_1.jpg','image',0),(2684,90,'/w/b/wb01-gray_alt1_1.jpg','image',0),(2685,90,'/w/b/wb01-gray_back_1.jpg','image',0),(2686,90,'/w/b/wb01-purple_main_1.jpg','image',0),(2687,90,'/w/b/wb01-black_main_1.jpg','image',0),(2688,90,'/w/b/wb01-black-0_1.jpg','image',0),(2689,90,'/w/b/wb01-gray_main_1.jpg','image',0),(2690,90,'/w/b/wb01-gray_alt1_1.jpg','image',0),(2691,90,'/w/b/wb01-gray_back_1.jpg','image',0),(2692,90,'/w/b/wb01-purple_main_1.jpg','image',0),(2693,90,'/w/b/wb01-black_main_1.jpg','image',0),(2694,90,'/w/b/wb01-black-0_1.jpg','image',0),(2695,90,'/w/b/wb01-gray_main_1.jpg','image',0),(2696,90,'/w/b/wb01-gray_alt1_1.jpg','image',0),(2697,90,'/w/b/wb01-gray_back_1.jpg','image',0),(2698,90,'/w/b/wb01-purple_main_1.jpg','image',0),(2699,90,'/w/b/wb01-black_main_1.jpg','image',0),(2700,90,'/w/b/wb01-black-0_1.jpg','image',0),(2701,90,'/w/b/wb01-gray_main_1.jpg','image',0),(2702,90,'/w/b/wb01-gray_alt1_1.jpg','image',0),(2703,90,'/w/b/wb01-gray_back_1.jpg','image',0),(2704,90,'/w/b/wb01-purple_main_1.jpg','image',0),(2705,90,'/w/b/wb01-gray_main_1.jpg','image',0),(2706,90,'/w/b/wb01-gray_alt1_1.jpg','image',0),(2707,90,'/w/b/wb01-gray_back_1.jpg','image',0),(2708,90,'/w/b/wb02-blue_main_1.jpg','image',0),(2709,90,'/w/b/wb02-blue_alt1_1.jpg','image',0),(2710,90,'/w/b/wb02-blue_back_1.jpg','image',0),(2711,90,'/w/b/wb02-orange_main_1.jpg','image',0),(2712,90,'/w/b/wb02-yellow_main_1.jpg','image',0),(2713,90,'/w/b/wb02-blue_main_1.jpg','image',0),(2714,90,'/w/b/wb02-blue_alt1_1.jpg','image',0),(2715,90,'/w/b/wb02-blue_back_1.jpg','image',0),(2716,90,'/w/b/wb02-orange_main_1.jpg','image',0),(2717,90,'/w/b/wb02-yellow_main_1.jpg','image',0),(2718,90,'/w/b/wb02-blue_main_1.jpg','image',0),(2719,90,'/w/b/wb02-blue_alt1_1.jpg','image',0),(2720,90,'/w/b/wb02-blue_back_1.jpg','image',0),(2721,90,'/w/b/wb02-orange_main_1.jpg','image',0),(2722,90,'/w/b/wb02-yellow_main_1.jpg','image',0),(2723,90,'/w/b/wb02-blue_main_1.jpg','image',0),(2724,90,'/w/b/wb02-blue_alt1_1.jpg','image',0),(2725,90,'/w/b/wb02-blue_back_1.jpg','image',0),(2726,90,'/w/b/wb02-orange_main_1.jpg','image',0),(2727,90,'/w/b/wb02-yellow_main_1.jpg','image',0),(2728,90,'/w/b/wb02-blue_main_1.jpg','image',0),(2729,90,'/w/b/wb02-blue_alt1_1.jpg','image',0),(2730,90,'/w/b/wb02-blue_back_1.jpg','image',0),(2731,90,'/w/b/wb02-orange_main_1.jpg','image',0),(2732,90,'/w/b/wb02-yellow_main_1.jpg','image',0),(2733,90,'/w/b/wb02-blue_main_1.jpg','image',0),(2734,90,'/w/b/wb02-blue_alt1_1.jpg','image',0),(2735,90,'/w/b/wb02-blue_back_1.jpg','image',0),(2736,90,'/w/b/wb03-green_main_1.jpg','image',0),(2737,90,'/w/b/wb03-green_alt1_1.jpg','image',0),(2738,90,'/w/b/wb03-green_back_1.jpg','image',0),(2739,90,'/w/b/wb03-red_main_1.jpg','image',0),(2740,90,'/w/b/wb03-yellow_main_1.jpg','image',0),(2741,90,'/w/b/wb03-green_main_1.jpg','image',0),(2742,90,'/w/b/wb03-green_alt1_1.jpg','image',0),(2743,90,'/w/b/wb03-green_back_1.jpg','image',0),(2744,90,'/w/b/wb03-red_main_1.jpg','image',0),(2745,90,'/w/b/wb03-yellow_main_1.jpg','image',0),(2746,90,'/w/b/wb03-green_main_1.jpg','image',0),(2747,90,'/w/b/wb03-green_alt1_1.jpg','image',0),(2748,90,'/w/b/wb03-green_back_1.jpg','image',0),(2749,90,'/w/b/wb03-red_main_1.jpg','image',0),(2750,90,'/w/b/wb03-yellow_main_1.jpg','image',0),(2751,90,'/w/b/wb03-green_main_1.jpg','image',0),(2752,90,'/w/b/wb03-green_alt1_1.jpg','image',0),(2753,90,'/w/b/wb03-green_back_1.jpg','image',0),(2754,90,'/w/b/wb03-red_main_1.jpg','image',0),(2755,90,'/w/b/wb03-yellow_main_1.jpg','image',0),(2756,90,'/w/b/wb03-green_main_1.jpg','image',0),(2757,90,'/w/b/wb03-green_alt1_1.jpg','image',0),(2758,90,'/w/b/wb03-green_back_1.jpg','image',0),(2759,90,'/w/b/wb03-red_main_1.jpg','image',0),(2760,90,'/w/b/wb03-yellow_main_1.jpg','image',0),(2761,90,'/w/b/wb03-green_main_1.jpg','image',0),(2762,90,'/w/b/wb03-green_alt1_1.jpg','image',0),(2763,90,'/w/b/wb03-green_back_1.jpg','image',0),(2764,90,'/w/b/wb04-blue_main_1.jpg','image',0),(2765,90,'/w/b/wb04-blue-0_1.jpg','image',0),(2766,90,'/w/b/wb04-blue_alt1_1.jpg','image',0),(2767,90,'/w/b/wb04-blue_back_1.jpg','image',0),(2768,90,'/w/b/wb04-purple_main_1.jpg','image',0),(2769,90,'/w/b/wb04-yellow_main_1.jpg','image',0),(2770,90,'/w/b/wb04-blue_main_1.jpg','image',0),(2771,90,'/w/b/wb04-blue-0_1.jpg','image',0),(2772,90,'/w/b/wb04-blue_alt1_1.jpg','image',0),(2773,90,'/w/b/wb04-blue_back_1.jpg','image',0),(2774,90,'/w/b/wb04-purple_main_1.jpg','image',0),(2775,90,'/w/b/wb04-yellow_main_1.jpg','image',0),(2776,90,'/w/b/wb04-blue_main_1.jpg','image',0),(2777,90,'/w/b/wb04-blue-0_1.jpg','image',0),(2778,90,'/w/b/wb04-blue_alt1_1.jpg','image',0),(2779,90,'/w/b/wb04-blue_back_1.jpg','image',0),(2780,90,'/w/b/wb04-purple_main_1.jpg','image',0),(2781,90,'/w/b/wb04-yellow_main_1.jpg','image',0),(2782,90,'/w/b/wb04-blue_main_1.jpg','image',0),(2783,90,'/w/b/wb04-blue-0_1.jpg','image',0),(2784,90,'/w/b/wb04-blue_alt1_1.jpg','image',0),(2785,90,'/w/b/wb04-blue_back_1.jpg','image',0),(2786,90,'/w/b/wb04-purple_main_2.jpg','image',0),(2787,90,'/w/b/wb04-yellow_main_2.jpg','image',0),(2788,90,'/w/b/wb04-blue_main_2.jpg','image',0),(2789,90,'/w/b/wb04-blue-0_2.jpg','image',0),(2790,90,'/w/b/wb04-blue_alt1_2.jpg','image',0),(2791,90,'/w/b/wb04-blue_back_2.jpg','image',0),(2792,90,'/w/b/wb04-purple_main_2.jpg','image',0),(2793,90,'/w/b/wb04-yellow_main_2.jpg','image',0),(2794,90,'/w/b/wb04-blue_main_2.jpg','image',0),(2795,90,'/w/b/wb04-blue-0_2.jpg','image',0),(2796,90,'/w/b/wb04-blue_alt1_2.jpg','image',0),(2797,90,'/w/b/wb04-blue_back_2.jpg','image',0),(2798,90,'/w/b/wb05-black_main_1.jpg','image',0),(2799,90,'/w/b/wb05-black_back_1.jpg','image',0),(2800,90,'/w/b/wb05-orange_main_1.jpg','image',0),(2801,90,'/w/b/wb05-purple_main_1.jpg','image',0),(2802,90,'/w/b/wb05-black_main_1.jpg','image',0),(2803,90,'/w/b/wb05-black_back_1.jpg','image',0),(2804,90,'/w/b/wb05-orange_main_1.jpg','image',0),(2805,90,'/w/b/wb05-purple_main_1.jpg','image',0),(2806,90,'/w/b/wb05-black_main_1.jpg','image',0),(2807,90,'/w/b/wb05-black_back_1.jpg','image',0),(2808,90,'/w/b/wb05-orange_main_1.jpg','image',0),(2809,90,'/w/b/wb05-purple_main_1.jpg','image',0),(2810,90,'/w/b/wb05-black_main_1.jpg','image',0),(2811,90,'/w/b/wb05-black_back_1.jpg','image',0),(2812,90,'/w/b/wb05-orange_main_1.jpg','image',0),(2813,90,'/w/b/wb05-purple_main_1.jpg','image',0),(2814,90,'/w/b/wb05-black_main_1.jpg','image',0),(2815,90,'/w/b/wb05-black_back_1.jpg','image',0),(2816,90,'/w/b/wb05-orange_main_1.jpg','image',0),(2817,90,'/w/b/wb05-purple_main_1.jpg','image',0),(2818,90,'/w/b/wb05-black_main_1.jpg','image',0),(2819,90,'/w/b/wb05-black_back_1.jpg','image',0),(2820,90,'/w/t/wt01-black_main_1.jpg','image',0),(2821,90,'/w/t/wt01-blue_main_1.jpg','image',0),(2822,90,'/w/t/wt01-blue_back_1.jpg','image',0),(2823,90,'/w/t/wt01-orange_main_1.jpg','image',0),(2824,90,'/w/t/wt01-black_main_1.jpg','image',0),(2825,90,'/w/t/wt01-blue_main_1.jpg','image',0),(2826,90,'/w/t/wt01-blue_back_1.jpg','image',0),(2827,90,'/w/t/wt01-orange_main_1.jpg','image',0),(2828,90,'/w/t/wt01-black_main_1.jpg','image',0),(2829,90,'/w/t/wt01-blue_main_1.jpg','image',0),(2830,90,'/w/t/wt01-blue_back_1.jpg','image',0),(2831,90,'/w/t/wt01-orange_main_1.jpg','image',0),(2832,90,'/w/t/wt01-black_main_1.jpg','image',0),(2833,90,'/w/t/wt01-blue_main_1.jpg','image',0),(2834,90,'/w/t/wt01-blue_back_1.jpg','image',0),(2835,90,'/w/t/wt01-orange_main_1.jpg','image',0),(2836,90,'/w/t/wt01-black_main_1.jpg','image',0),(2837,90,'/w/t/wt01-blue_main_1.jpg','image',0),(2838,90,'/w/t/wt01-blue_back_1.jpg','image',0),(2839,90,'/w/t/wt01-orange_main_1.jpg','image',0),(2840,90,'/w/t/wt01-blue_main_1.jpg','image',0),(2841,90,'/w/t/wt01-blue_back_1.jpg','image',0),(2842,90,'/w/t/wt02-green_main_1.jpg','image',0),(2843,90,'/w/t/wt02-orange_main_1.jpg','image',0),(2844,90,'/w/t/wt02-orange_back_1.jpg','image',0),(2845,90,'/w/t/wt02-yellow_main_1.jpg','image',0),(2846,90,'/w/t/wt02-green_main_1.jpg','image',0),(2847,90,'/w/t/wt02-orange_main_1.jpg','image',0),(2848,90,'/w/t/wt02-orange_back_1.jpg','image',0),(2849,90,'/w/t/wt02-yellow_main_1.jpg','image',0),(2850,90,'/w/t/wt02-green_main_1.jpg','image',0),(2851,90,'/w/t/wt02-orange_main_1.jpg','image',0),(2852,90,'/w/t/wt02-orange_back_1.jpg','image',0),(2853,90,'/w/t/wt02-yellow_main_1.jpg','image',0),(2854,90,'/w/t/wt02-green_main_1.jpg','image',0),(2855,90,'/w/t/wt02-orange_main_1.jpg','image',0),(2856,90,'/w/t/wt02-orange_back_1.jpg','image',0),(2857,90,'/w/t/wt02-yellow_main_1.jpg','image',0),(2858,90,'/w/t/wt02-green_main_1.jpg','image',0),(2859,90,'/w/t/wt02-orange_main_1.jpg','image',0),(2860,90,'/w/t/wt02-orange_back_1.jpg','image',0),(2861,90,'/w/t/wt02-yellow_main_1.jpg','image',0),(2862,90,'/w/t/wt02-orange_main_1.jpg','image',0),(2863,90,'/w/t/wt02-orange_back_1.jpg','image',0),(2864,90,'/w/t/wt03-orange_main_1.jpg','image',0),(2865,90,'/w/t/wt03-purple_main_1.jpg','image',0),(2866,90,'/w/t/wt03-red_main_1.jpg','image',0),(2867,90,'/w/t/wt03-red_alt1_1.jpg','image',0),(2868,90,'/w/t/wt03-red_back_1.jpg','image',0),(2869,90,'/w/t/wt03-orange_main_1.jpg','image',0),(2870,90,'/w/t/wt03-purple_main_1.jpg','image',0),(2871,90,'/w/t/wt03-red_main_1.jpg','image',0),(2872,90,'/w/t/wt03-red_alt1_1.jpg','image',0),(2873,90,'/w/t/wt03-red_back_1.jpg','image',0),(2874,90,'/w/t/wt03-orange_main_1.jpg','image',0),(2875,90,'/w/t/wt03-purple_main_1.jpg','image',0),(2876,90,'/w/t/wt03-red_main_1.jpg','image',0),(2877,90,'/w/t/wt03-red_alt1_1.jpg','image',0),(2878,90,'/w/t/wt03-red_back_1.jpg','image',0),(2879,90,'/w/t/wt03-orange_main_1.jpg','image',0),(2880,90,'/w/t/wt03-purple_main_1.jpg','image',0),(2881,90,'/w/t/wt03-red_main_1.jpg','image',0),(2882,90,'/w/t/wt03-red_alt1_1.jpg','image',0),(2883,90,'/w/t/wt03-red_back_1.jpg','image',0),(2884,90,'/w/t/wt03-orange_main_1.jpg','image',0),(2885,90,'/w/t/wt03-purple_main_1.jpg','image',0),(2886,90,'/w/t/wt03-red_main_1.jpg','image',0),(2887,90,'/w/t/wt03-red_alt1_1.jpg','image',0),(2888,90,'/w/t/wt03-red_back_1.jpg','image',0),(2889,90,'/w/t/wt03-red_main_1.jpg','image',0),(2890,90,'/w/t/wt03-red_alt1_1.jpg','image',0),(2891,90,'/w/t/wt03-red_back_1.jpg','image',0),(2892,90,'/w/t/wt04-blue_main_1.jpg','image',0),(2893,90,'/w/t/wt04-blue_back_1.jpg','image',0),(2894,90,'/w/t/wt04-purple_main_1.jpg','image',0),(2895,90,'/w/t/wt04-red_main_1.jpg','image',0),(2896,90,'/w/t/wt04-blue_main_1.jpg','image',0),(2897,90,'/w/t/wt04-blue_back_1.jpg','image',0),(2898,90,'/w/t/wt04-purple_main_1.jpg','image',0),(2899,90,'/w/t/wt04-red_main_1.jpg','image',0),(2900,90,'/w/t/wt04-blue_main_1.jpg','image',0),(2901,90,'/w/t/wt04-blue_back_1.jpg','image',0),(2902,90,'/w/t/wt04-purple_main_1.jpg','image',0),(2903,90,'/w/t/wt04-red_main_1.jpg','image',0),(2904,90,'/w/t/wt04-blue_main_1.jpg','image',0),(2905,90,'/w/t/wt04-blue_back_1.jpg','image',0),(2906,90,'/w/t/wt04-purple_main_1.jpg','image',0),(2907,90,'/w/t/wt04-red_main_1.jpg','image',0),(2908,90,'/w/t/wt04-blue_main_1.jpg','image',0),(2909,90,'/w/t/wt04-blue_back_1.jpg','image',0),(2910,90,'/w/t/wt04-purple_main_1.jpg','image',0),(2911,90,'/w/t/wt04-red_main_1.jpg','image',0),(2912,90,'/w/t/wt04-blue_main_1.jpg','image',0),(2913,90,'/w/t/wt04-blue_back_1.jpg','image',0),(2914,90,'/w/t/wt05-orange_main_1.jpg','image',0),(2915,90,'/w/t/wt05-purple_main_1.jpg','image',0),(2916,90,'/w/t/wt05-purple_alt1_1.jpg','image',0),(2917,90,'/w/t/wt05-purple_back_1.jpg','image',0),(2918,90,'/w/t/wt05-white_main_1.jpg','image',0),(2919,90,'/w/t/wt05-orange_main_1.jpg','image',0),(2920,90,'/w/t/wt05-purple_main_1.jpg','image',0),(2921,90,'/w/t/wt05-purple_alt1_1.jpg','image',0),(2922,90,'/w/t/wt05-purple_back_1.jpg','image',0),(2923,90,'/w/t/wt05-white_main_1.jpg','image',0),(2924,90,'/w/t/wt05-orange_main_1.jpg','image',0),(2925,90,'/w/t/wt05-purple_main_1.jpg','image',0),(2926,90,'/w/t/wt05-purple_alt1_1.jpg','image',0),(2927,90,'/w/t/wt05-purple_back_1.jpg','image',0),(2928,90,'/w/t/wt05-white_main_1.jpg','image',0),(2929,90,'/w/t/wt05-orange_main_1.jpg','image',0),(2930,90,'/w/t/wt05-purple_main_1.jpg','image',0),(2931,90,'/w/t/wt05-purple_alt1_1.jpg','image',0),(2932,90,'/w/t/wt05-purple_back_1.jpg','image',0),(2933,90,'/w/t/wt05-white_main_1.jpg','image',0),(2934,90,'/w/t/wt05-orange_main_1.jpg','image',0),(2935,90,'/w/t/wt05-purple_main_1.jpg','image',0),(2936,90,'/w/t/wt05-purple_alt1_1.jpg','image',0),(2937,90,'/w/t/wt05-purple_back_1.jpg','image',0),(2938,90,'/w/t/wt05-white_main_2.jpg','image',0),(2939,90,'/w/t/wt05-purple_main_2.jpg','image',0),(2940,90,'/w/t/wt05-purple_alt1_2.jpg','image',0),(2941,90,'/w/t/wt05-purple_back_2.jpg','image',0),(2942,90,'/w/t/wt06-blue_main_1.jpg','image',0),(2943,90,'/w/t/wt06-blue_back_1.jpg','image',0),(2944,90,'/w/t/wt06-red_main_1.jpg','image',0),(2945,90,'/w/t/wt06-yellow_main_1.jpg','image',0),(2946,90,'/w/t/wt06-blue_main_1.jpg','image',0),(2947,90,'/w/t/wt06-blue_back_1.jpg','image',0),(2948,90,'/w/t/wt06-red_main_1.jpg','image',0),(2949,90,'/w/t/wt06-yellow_main_1.jpg','image',0),(2950,90,'/w/t/wt06-blue_main_1.jpg','image',0),(2951,90,'/w/t/wt06-blue_back_1.jpg','image',0),(2952,90,'/w/t/wt06-red_main_1.jpg','image',0),(2953,90,'/w/t/wt06-yellow_main_1.jpg','image',0),(2954,90,'/w/t/wt06-blue_main_1.jpg','image',0),(2955,90,'/w/t/wt06-blue_back_1.jpg','image',0),(2956,90,'/w/t/wt06-red_main_1.jpg','image',0),(2957,90,'/w/t/wt06-yellow_main_1.jpg','image',0),(2958,90,'/w/t/wt06-blue_main_1.jpg','image',0),(2959,90,'/w/t/wt06-blue_back_1.jpg','image',0),(2960,90,'/w/t/wt06-red_main_1.jpg','image',0),(2961,90,'/w/t/wt06-yellow_main_1.jpg','image',0),(2962,90,'/w/t/wt06-blue_main_1.jpg','image',0),(2963,90,'/w/t/wt06-blue_back_1.jpg','image',0),(2964,90,'/w/t/wt07-green_main_1.jpg','image',0),(2965,90,'/w/t/wt07-green_alt1_1.jpg','image',0),(2966,90,'/w/t/wt07-green_back_1.jpg','image',0),(2967,90,'/w/t/wt07-white_main_1.jpg','image',0),(2968,90,'/w/t/wt07-yellow_main_1.jpg','image',0),(2969,90,'/w/t/wt07-green_main_1.jpg','image',0),(2970,90,'/w/t/wt07-green_alt1_1.jpg','image',0),(2971,90,'/w/t/wt07-green_back_1.jpg','image',0),(2972,90,'/w/t/wt07-white_main_1.jpg','image',0),(2973,90,'/w/t/wt07-yellow_main_1.jpg','image',0),(2974,90,'/w/t/wt07-green_main_1.jpg','image',0),(2975,90,'/w/t/wt07-green_alt1_1.jpg','image',0),(2976,90,'/w/t/wt07-green_back_1.jpg','image',0),(2977,90,'/w/t/wt07-white_main_1.jpg','image',0),(2978,90,'/w/t/wt07-yellow_main_1.jpg','image',0),(2979,90,'/w/t/wt07-green_main_1.jpg','image',0),(2980,90,'/w/t/wt07-green_alt1_1.jpg','image',0),(2981,90,'/w/t/wt07-green_back_1.jpg','image',0),(2982,90,'/w/t/wt07-white_main_1.jpg','image',0),(2983,90,'/w/t/wt07-yellow_main_1.jpg','image',0),(2984,90,'/w/t/wt07-green_main_1.jpg','image',0),(2985,90,'/w/t/wt07-green_alt1_1.jpg','image',0),(2986,90,'/w/t/wt07-green_back_1.jpg','image',0),(2987,90,'/w/t/wt07-white_main_1.jpg','image',0),(2988,90,'/w/t/wt07-yellow_main_1.jpg','image',0),(2989,90,'/w/t/wt07-green_main_1.jpg','image',0),(2990,90,'/w/t/wt07-green_alt1_1.jpg','image',0),(2991,90,'/w/t/wt07-green_back_1.jpg','image',0),(2992,90,'/w/t/wt08-black_main_1.jpg','image',0),(2993,90,'/w/t/wt08-black_alt1_1.jpg','image',0),(2994,90,'/w/t/wt08-black_back_1.jpg','image',0),(2995,90,'/w/t/wt08-purple_main_1.jpg','image',0),(2996,90,'/w/t/wt08-yellow_main_1.jpg','image',0),(2997,90,'/w/t/wt08-black_main_1.jpg','image',0),(2998,90,'/w/t/wt08-black_alt1_1.jpg','image',0),(2999,90,'/w/t/wt08-black_back_1.jpg','image',0),(3000,90,'/w/t/wt08-purple_main_1.jpg','image',0),(3001,90,'/w/t/wt08-yellow_main_1.jpg','image',0),(3002,90,'/w/t/wt08-black_main_1.jpg','image',0),(3003,90,'/w/t/wt08-black_alt1_1.jpg','image',0),(3004,90,'/w/t/wt08-black_back_1.jpg','image',0),(3005,90,'/w/t/wt08-purple_main_1.jpg','image',0),(3006,90,'/w/t/wt08-yellow_main_1.jpg','image',0),(3007,90,'/w/t/wt08-black_main_1.jpg','image',0),(3008,90,'/w/t/wt08-black_alt1_1.jpg','image',0),(3009,90,'/w/t/wt08-black_back_1.jpg','image',0),(3010,90,'/w/t/wt08-purple_main_1.jpg','image',0),(3011,90,'/w/t/wt08-yellow_main_1.jpg','image',0),(3012,90,'/w/t/wt08-black_main_1.jpg','image',0),(3013,90,'/w/t/wt08-black_alt1_1.jpg','image',0),(3014,90,'/w/t/wt08-black_back_1.jpg','image',0),(3015,90,'/w/t/wt08-purple_main_1.jpg','image',0),(3016,90,'/w/t/wt08-yellow_main_1.jpg','image',0),(3017,90,'/w/t/wt08-black_main_1.jpg','image',0),(3018,90,'/w/t/wt08-black_alt1_1.jpg','image',0),(3019,90,'/w/t/wt08-black_back_1.jpg','image',0),(3020,90,'/w/t/wt09-purple_main_1.jpg','image',0),(3021,90,'/w/t/wt09-white_main_1.jpg','image',0),(3022,90,'/w/t/wt09-white_back_1.jpg','image',0),(3023,90,'/w/t/wt09-yellow_main_1.jpg','image',0),(3024,90,'/w/t/wt09-purple_main_1.jpg','image',0),(3025,90,'/w/t/wt09-white_main_1.jpg','image',0),(3026,90,'/w/t/wt09-white_back_1.jpg','image',0),(3027,90,'/w/t/wt09-yellow_main_1.jpg','image',0),(3028,90,'/w/t/wt09-purple_main_1.jpg','image',0),(3029,90,'/w/t/wt09-white_main_1.jpg','image',0),(3030,90,'/w/t/wt09-white_back_1.jpg','image',0),(3031,90,'/w/t/wt09-yellow_main_1.jpg','image',0),(3032,90,'/w/t/wt09-purple_main_1.jpg','image',0),(3033,90,'/w/t/wt09-white_main_1.jpg','image',0),(3034,90,'/w/t/wt09-white_back_1.jpg','image',0),(3035,90,'/w/t/wt09-yellow_main_1.jpg','image',0),(3036,90,'/w/t/wt09-purple_main_1.jpg','image',0),(3037,90,'/w/t/wt09-white_main_1.jpg','image',0),(3038,90,'/w/t/wt09-white_back_1.jpg','image',0),(3039,90,'/w/t/wt09-yellow_main_1.jpg','image',0),(3040,90,'/w/t/wt09-white_main_1.jpg','image',0),(3041,90,'/w/t/wt09-white_back_1.jpg','image',0),(3042,90,'/w/p/wp01-black_main_1.jpg','image',0),(3043,90,'/w/p/wp01-gray_main_1.jpg','image',0),(3044,90,'/w/p/wp01-gray_back_1.jpg','image',0),(3045,90,'/w/p/wp01-white_main_1.jpg','image',0),(3046,90,'/w/p/wp01-black_main_1.jpg','image',0),(3047,90,'/w/p/wp01-gray_main_1.jpg','image',0),(3048,90,'/w/p/wp01-gray_back_1.jpg','image',0),(3049,90,'/w/p/wp01-white_main_1.jpg','image',0),(3050,90,'/w/p/wp01-gray_main_1.jpg','image',0),(3051,90,'/w/p/wp01-gray_back_1.jpg','image',0),(3052,90,'/w/p/wp02-blue_main_1.jpg','image',0),(3053,90,'/w/p/wp02-blue_back_1.jpg','image',0),(3054,90,'/w/p/wp02-purple_main_1.jpg','image',0),(3055,90,'/w/p/wp02-red_main_1.jpg','image',0),(3056,90,'/w/p/wp02-blue_main_1.jpg','image',0),(3057,90,'/w/p/wp02-blue_back_1.jpg','image',0),(3058,90,'/w/p/wp02-purple_main_1.jpg','image',0),(3059,90,'/w/p/wp02-red_main_1.jpg','image',0),(3060,90,'/w/p/wp02-blue_main_1.jpg','image',0),(3061,90,'/w/p/wp02-blue_back_1.jpg','image',0),(3062,90,'/w/p/wp03-black_main_1.jpg','image',0),(3063,90,'/w/p/wp03-blue_main_1.jpg','image',0),(3064,90,'/w/p/wp03-blue_alt1_1.jpg','image',0),(3065,90,'/w/p/wp03-blue_back_1.jpg','image',0),(3066,90,'/w/p/wp03-purple_main_1.jpg','image',0),(3067,90,'/w/p/wp03-black_main_1.jpg','image',0),(3068,90,'/w/p/wp03-blue_main_1.jpg','image',0),(3069,90,'/w/p/wp03-blue_alt1_1.jpg','image',0),(3070,90,'/w/p/wp03-blue_back_1.jpg','image',0),(3071,90,'/w/p/wp03-purple_main_1.jpg','image',0),(3072,90,'/w/p/wp03-blue_main_1.jpg','image',0),(3073,90,'/w/p/wp03-blue_alt1_1.jpg','image',0),(3074,90,'/w/p/wp03-blue_back_1.jpg','image',0),(3075,90,'/w/p/wp04-black_main_1.jpg','image',0),(3076,90,'/w/p/wp04-blue_main_1.jpg','image',0),(3077,90,'/w/p/wp04-blue_alt1_1.jpg','image',0),(3078,90,'/w/p/wp04-blue_alternate_1.jpg','image',0),(3079,90,'/w/p/wp04-blue_back_1.jpg','image',0),(3080,90,'/w/p/wp04-white_main_1.jpg','image',0),(3081,90,'/w/p/wp04-black_main_1.jpg','image',0),(3082,90,'/w/p/wp04-blue_main_1.jpg','image',0),(3083,90,'/w/p/wp04-blue_alt1_1.jpg','image',0),(3084,90,'/w/p/wp04-blue_alternate_1.jpg','image',0),(3085,90,'/w/p/wp04-blue_back_1.jpg','image',0),(3086,90,'/w/p/wp04-white_main_1.jpg','image',0),(3087,90,'/w/p/wp04-blue_main_1.jpg','image',0),(3088,90,'/w/p/wp04-blue_alt1_1.jpg','image',0),(3089,90,'/w/p/wp04-blue_alternate_1.jpg','image',0),(3090,90,'/w/p/wp04-blue_back_1.jpg','image',0),(3091,90,'/w/p/wp05-blue_main_1.jpg','image',0),(3092,90,'/w/p/wp05-gray_main_1.jpg','image',0),(3093,90,'/w/p/wp05-gray_alt1_1.jpg','image',0),(3094,90,'/w/p/wp05-gray_back_1.jpg','image',0),(3095,90,'/w/p/wp05-red_main_1.jpg','image',0),(3096,90,'/w/p/wp05-blue_main_1.jpg','image',0),(3097,90,'/w/p/wp05-gray_main_1.jpg','image',0),(3098,90,'/w/p/wp05-gray_alt1_1.jpg','image',0),(3099,90,'/w/p/wp05-gray_back_1.jpg','image',0),(3100,90,'/w/p/wp05-red_main_1.jpg','image',0),(3101,90,'/w/p/wp05-gray_main_2.jpg','image',0),(3102,90,'/w/p/wp05-gray_alt1_2.jpg','image',0),(3103,90,'/w/p/wp05-gray_back_2.jpg','image',0),(3104,90,'/w/p/wp06-black_main_1.jpg','image',0),(3105,90,'/w/p/wp06-black_alt1_1.jpg','image',0),(3106,90,'/w/p/wp06-black_back_1.jpg','image',0),(3107,90,'/w/p/wp06-black_outfit_1.jpg','image',0),(3108,90,'/w/p/wp06-blue_main_1.jpg','image',0),(3109,90,'/w/p/wp06-orange_main_1.jpg','image',0),(3110,90,'/w/p/wp06-black_main_1.jpg','image',0),(3111,90,'/w/p/wp06-black_alt1_1.jpg','image',0),(3112,90,'/w/p/wp06-black_back_1.jpg','image',0),(3113,90,'/w/p/wp06-black_outfit_1.jpg','image',0),(3114,90,'/w/p/wp06-blue_main_1.jpg','image',0),(3115,90,'/w/p/wp06-orange_main_1.jpg','image',0),(3116,90,'/w/p/wp06-black_main_1.jpg','image',0),(3117,90,'/w/p/wp06-black_alt1_1.jpg','image',0),(3118,90,'/w/p/wp06-black_back_1.jpg','image',0),(3119,90,'/w/p/wp06-black_outfit_1.jpg','image',0),(3120,90,'/w/p/wp07-black_main_1.jpg','image',0),(3121,90,'/w/p/wp07-black_alt1_1.jpg','image',0),(3122,90,'/w/p/wp07-black_back_1.jpg','image',0),(3123,90,'/w/p/wp07-blue_main_1.jpg','image',0),(3124,90,'/w/p/wp07-orange_main_1.jpg','image',0),(3125,90,'/w/p/wp07-black_main_1.jpg','image',0),(3126,90,'/w/p/wp07-black_alt1_1.jpg','image',0),(3127,90,'/w/p/wp07-black_back_1.jpg','image',0),(3128,90,'/w/p/wp07-blue_main_1.jpg','image',0),(3129,90,'/w/p/wp07-orange_main_1.jpg','image',0),(3130,90,'/w/p/wp07-black_main_1.jpg','image',0),(3131,90,'/w/p/wp07-black_alt1_1.jpg','image',0),(3132,90,'/w/p/wp07-black_back_1.jpg','image',0),(3133,90,'/w/p/wp08-black_main_1.jpg','image',0),(3134,90,'/w/p/wp08-black_back_1.jpg','image',0),(3135,90,'/w/p/wp08-green_main_1.jpg','image',0),(3136,90,'/w/p/wp08-red_main_1.jpg','image',0),(3137,90,'/w/p/wp08-black_main_1.jpg','image',0),(3138,90,'/w/p/wp08-black_back_1.jpg','image',0),(3139,90,'/w/p/wp08-green_main_1.jpg','image',0),(3140,90,'/w/p/wp08-red_main_1.jpg','image',0),(3141,90,'/w/p/wp08-black_main_1.jpg','image',0),(3142,90,'/w/p/wp08-black_back_1.jpg','image',0),(3143,90,'/w/p/wp09-black_main_1.jpg','image',0),(3144,90,'/w/p/wp09-black_alt1_1.jpg','image',0),(3145,90,'/w/p/wp09-black_back_1.jpg','image',0),(3146,90,'/w/p/wp09-black_outfit_1.jpg','image',0),(3147,90,'/w/p/wp09-blue_main_1.jpg','image',0),(3148,90,'/w/p/wp09-purple_main_1.jpg','image',0),(3149,90,'/w/p/wp09-black_main_1.jpg','image',0),(3150,90,'/w/p/wp09-black_alt1_1.jpg','image',0),(3151,90,'/w/p/wp09-black_back_1.jpg','image',0),(3152,90,'/w/p/wp09-black_outfit_1.jpg','image',0),(3153,90,'/w/p/wp09-blue_main_1.jpg','image',0),(3154,90,'/w/p/wp09-purple_main_1.jpg','image',0),(3155,90,'/w/p/wp09-black_main_1.jpg','image',0),(3156,90,'/w/p/wp09-black_alt1_1.jpg','image',0),(3157,90,'/w/p/wp09-black_back_1.jpg','image',0),(3158,90,'/w/p/wp09-black_outfit_1.jpg','image',0),(3159,90,'/w/p/wp10-black_main_1.jpg','image',0),(3160,90,'/w/p/wp10-gray_main_1.jpg','image',0),(3161,90,'/w/p/wp10-gray_alt1_1.jpg','image',0),(3162,90,'/w/p/wp10-gray_back_1.jpg','image',0),(3163,90,'/w/p/wp10-white_main_1.jpg','image',0),(3164,90,'/w/p/wp10-black_main_1.jpg','image',0),(3165,90,'/w/p/wp10-gray_main_1.jpg','image',0),(3166,90,'/w/p/wp10-gray_alt1_1.jpg','image',0),(3167,90,'/w/p/wp10-gray_back_1.jpg','image',0),(3168,90,'/w/p/wp10-white_main_1.jpg','image',0),(3169,90,'/w/p/wp10-gray_main_1.jpg','image',0),(3170,90,'/w/p/wp10-gray_alt1_1.jpg','image',0),(3171,90,'/w/p/wp10-gray_back_1.jpg','image',0),(3172,90,'/w/p/wp11-blue_main_1.jpg','image',0),(3173,90,'/w/p/wp11-green_main_1.jpg','image',0),(3174,90,'/w/p/wp11-green_back_1.jpg','image',0),(3175,90,'/w/p/wp11-red_main_1.jpg','image',0),(3176,90,'/w/p/wp11-blue_main_1.jpg','image',0),(3177,90,'/w/p/wp11-green_main_1.jpg','image',0),(3178,90,'/w/p/wp11-green_back_1.jpg','image',0),(3179,90,'/w/p/wp11-red_main_1.jpg','image',0),(3180,90,'/w/p/wp11-green_main_1.jpg','image',0),(3181,90,'/w/p/wp11-green_back_1.jpg','image',0),(3182,90,'/w/p/wp12-blue_main_1.jpg','image',0),(3183,90,'/w/p/wp12-gray_main_1.jpg','image',0),(3184,90,'/w/p/wp12-gray_back_1.jpg','image',0),(3185,90,'/w/p/wp12-green_main_1.jpg','image',0),(3186,90,'/w/p/wp12-blue_main_1.jpg','image',0),(3187,90,'/w/p/wp12-gray_main_1.jpg','image',0),(3188,90,'/w/p/wp12-gray_back_1.jpg','image',0),(3189,90,'/w/p/wp12-green_main_1.jpg','image',0),(3190,90,'/w/p/wp12-gray_main_1.jpg','image',0),(3191,90,'/w/p/wp12-gray_back_1.jpg','image',0),(3192,90,'/w/p/wp13-blue_main_1.jpg','image',0),(3193,90,'/w/p/wp13-green_main_1.jpg','image',0),(3194,90,'/w/p/wp13-orange_main_1.jpg','image',0),(3195,90,'/w/p/wp13-orange_back_1.jpg','image',0),(3196,90,'/w/p/wp13-blue_main_1.jpg','image',0),(3197,90,'/w/p/wp13-green_main_1.jpg','image',0),(3198,90,'/w/p/wp13-orange_main_1.jpg','image',0),(3199,90,'/w/p/wp13-orange_back_1.jpg','image',0),(3200,90,'/w/p/wp13-orange_main_1.jpg','image',0),(3201,90,'/w/p/wp13-orange_back_1.jpg','image',0),(3202,90,'/w/s/wsh01-black_main_1.jpg','image',0),(3203,90,'/w/s/wsh01-black_back_1.jpg','image',0),(3204,90,'/w/s/wsh01-green_main_1.jpg','image',0),(3205,90,'/w/s/wsh01-red_main_1.jpg','image',0),(3206,90,'/w/s/wsh01-black_main_1.jpg','image',0),(3207,90,'/w/s/wsh01-black_back_1.jpg','image',0),(3208,90,'/w/s/wsh01-green_main_1.jpg','image',0),(3209,90,'/w/s/wsh01-red_main_1.jpg','image',0),(3210,90,'/w/s/wsh01-black_main_1.jpg','image',0),(3211,90,'/w/s/wsh01-black_back_1.jpg','image',0),(3212,90,'/w/s/wsh01-green_main_1.jpg','image',0),(3213,90,'/w/s/wsh01-red_main_1.jpg','image',0),(3214,90,'/w/s/wsh01-black_main_1.jpg','image',0),(3215,90,'/w/s/wsh01-black_back_1.jpg','image',0),(3216,90,'/w/s/wsh01-green_main_1.jpg','image',0),(3217,90,'/w/s/wsh01-red_main_1.jpg','image',0),(3218,90,'/w/s/wsh01-black_main_1.jpg','image',0),(3219,90,'/w/s/wsh01-black_back_1.jpg','image',0),(3220,90,'/w/s/wsh01-green_main_1.jpg','image',0),(3221,90,'/w/s/wsh01-red_main_1.jpg','image',0),(3222,90,'/w/s/wsh01-black_main_1.jpg','image',0),(3223,90,'/w/s/wsh01-black_back_1.jpg','image',0),(3224,90,'/w/s/wsh02-gray_main_1.jpg','image',0),(3225,90,'/w/s/wsh02-gray_back_1.jpg','image',0),(3226,90,'/w/s/wsh02-orange_main_1.jpg','image',0),(3227,90,'/w/s/wsh02-yellow_main_1.jpg','image',0),(3228,90,'/w/s/wsh02-gray_main_1.jpg','image',0),(3229,90,'/w/s/wsh02-gray_back_1.jpg','image',0),(3230,90,'/w/s/wsh02-orange_main_1.jpg','image',0),(3231,90,'/w/s/wsh02-yellow_main_1.jpg','image',0),(3232,90,'/w/s/wsh02-gray_main_1.jpg','image',0),(3233,90,'/w/s/wsh02-gray_back_1.jpg','image',0),(3234,90,'/w/s/wsh02-orange_main_1.jpg','image',0),(3235,90,'/w/s/wsh02-yellow_main_1.jpg','image',0),(3236,90,'/w/s/wsh02-gray_main_1.jpg','image',0),(3237,90,'/w/s/wsh02-gray_back_1.jpg','image',0),(3238,90,'/w/s/wsh02-orange_main_1.jpg','image',0),(3239,90,'/w/s/wsh02-yellow_main_1.jpg','image',0),(3240,90,'/w/s/wsh02-gray_main_1.jpg','image',0),(3241,90,'/w/s/wsh02-gray_back_1.jpg','image',0),(3242,90,'/w/s/wsh02-orange_main_1.jpg','image',0),(3243,90,'/w/s/wsh02-yellow_main_1.jpg','image',0),(3244,90,'/w/s/wsh02-gray_main_1.jpg','image',0),(3245,90,'/w/s/wsh02-gray_back_1.jpg','image',0),(3246,90,'/w/s/wsh03-blue_main_1.jpg','image',0),(3247,90,'/w/s/wsh03-gray_main_1.jpg','image',0),(3248,90,'/w/s/wsh03-gray_alt1_1.jpg','image',0),(3249,90,'/w/s/wsh03-gray_back_1.jpg','image',0),(3250,90,'/w/s/wsh03-orange_main_1.jpg','image',0),(3251,90,'/w/s/wsh03-blue_main_1.jpg','image',0),(3252,90,'/w/s/wsh03-gray_main_1.jpg','image',0),(3253,90,'/w/s/wsh03-gray_alt1_1.jpg','image',0),(3254,90,'/w/s/wsh03-gray_back_1.jpg','image',0),(3255,90,'/w/s/wsh03-orange_main_1.jpg','image',0),(3256,90,'/w/s/wsh03-blue_main_1.jpg','image',0),(3257,90,'/w/s/wsh03-gray_main_1.jpg','image',0),(3258,90,'/w/s/wsh03-gray_alt1_1.jpg','image',0),(3259,90,'/w/s/wsh03-gray_back_1.jpg','image',0),(3260,90,'/w/s/wsh03-orange_main_1.jpg','image',0),(3261,90,'/w/s/wsh03-blue_main_1.jpg','image',0),(3262,90,'/w/s/wsh03-gray_main_1.jpg','image',0),(3263,90,'/w/s/wsh03-gray_alt1_1.jpg','image',0),(3264,90,'/w/s/wsh03-gray_back_1.jpg','image',0),(3265,90,'/w/s/wsh03-orange_main_2.jpg','image',0),(3266,90,'/w/s/wsh03-blue_main_2.jpg','image',0),(3267,90,'/w/s/wsh03-gray_main_2.jpg','image',0),(3268,90,'/w/s/wsh03-gray_alt1_2.jpg','image',0),(3269,90,'/w/s/wsh03-gray_back_2.jpg','image',0),(3270,90,'/w/s/wsh03-orange_main_2.jpg','image',0),(3271,90,'/w/s/wsh03-gray_main_2.jpg','image',0),(3272,90,'/w/s/wsh03-gray_alt1_2.jpg','image',0),(3273,90,'/w/s/wsh03-gray_back_2.jpg','image',0),(3274,90,'/w/s/wsh04-black_main_1.jpg','image',0),(3275,90,'/w/s/wsh04-black_alt1_1.jpg','image',0),(3276,90,'/w/s/wsh04-black_back_1.jpg','image',0),(3277,90,'/w/s/wsh04-green_main_1.jpg','image',0),(3278,90,'/w/s/wsh04-orange_main_1.jpg','image',0),(3279,90,'/w/s/wsh04-black_main_1.jpg','image',0),(3280,90,'/w/s/wsh04-black_alt1_1.jpg','image',0),(3281,90,'/w/s/wsh04-black_back_1.jpg','image',0),(3282,90,'/w/s/wsh04-green_main_1.jpg','image',0),(3283,90,'/w/s/wsh04-orange_main_1.jpg','image',0),(3284,90,'/w/s/wsh04-black_main_1.jpg','image',0),(3285,90,'/w/s/wsh04-black_alt1_1.jpg','image',0),(3286,90,'/w/s/wsh04-black_back_1.jpg','image',0),(3287,90,'/w/s/wsh04-green_main_1.jpg','image',0),(3288,90,'/w/s/wsh04-orange_main_1.jpg','image',0),(3289,90,'/w/s/wsh04-black_main_1.jpg','image',0),(3290,90,'/w/s/wsh04-black_alt1_1.jpg','image',0),(3291,90,'/w/s/wsh04-black_back_1.jpg','image',0),(3292,90,'/w/s/wsh04-green_main_1.jpg','image',0),(3293,90,'/w/s/wsh04-orange_main_1.jpg','image',0),(3294,90,'/w/s/wsh04-black_main_1.jpg','image',0),(3295,90,'/w/s/wsh04-black_alt1_1.jpg','image',0),(3296,90,'/w/s/wsh04-black_back_1.jpg','image',0),(3297,90,'/w/s/wsh04-green_main_1.jpg','image',0),(3298,90,'/w/s/wsh04-orange_main_1.jpg','image',0),(3299,90,'/w/s/wsh04-black_main_1.jpg','image',0),(3300,90,'/w/s/wsh04-black_alt1_1.jpg','image',0),(3301,90,'/w/s/wsh04-black_back_1.jpg','image',0),(3302,90,'/w/s/wsh05-blue_main_1.jpg','image',0),(3303,90,'/w/s/wsh05-blue_back_1.jpg','image',0),(3304,90,'/w/s/wsh05-purple_main_1.jpg','image',0),(3305,90,'/w/s/wsh05-yellow_main_1.jpg','image',0),(3306,90,'/w/s/wsh05-blue_main_1.jpg','image',0),(3307,90,'/w/s/wsh05-blue_back_1.jpg','image',0),(3308,90,'/w/s/wsh05-purple_main_1.jpg','image',0),(3309,90,'/w/s/wsh05-yellow_main_1.jpg','image',0),(3310,90,'/w/s/wsh05-blue_main_1.jpg','image',0),(3311,90,'/w/s/wsh05-blue_back_1.jpg','image',0),(3312,90,'/w/s/wsh05-purple_main_1.jpg','image',0),(3313,90,'/w/s/wsh05-yellow_main_1.jpg','image',0),(3314,90,'/w/s/wsh05-blue_main_1.jpg','image',0),(3315,90,'/w/s/wsh05-blue_back_1.jpg','image',0),(3316,90,'/w/s/wsh05-purple_main_1.jpg','image',0),(3317,90,'/w/s/wsh05-yellow_main_1.jpg','image',0),(3318,90,'/w/s/wsh05-blue_main_1.jpg','image',0),(3319,90,'/w/s/wsh05-blue_back_1.jpg','image',0),(3320,90,'/w/s/wsh05-purple_main_1.jpg','image',0),(3321,90,'/w/s/wsh05-yellow_main_1.jpg','image',0),(3322,90,'/w/s/wsh05-blue_main_1.jpg','image',0),(3323,90,'/w/s/wsh05-blue_back_1.jpg','image',0),(3324,90,'/w/s/wsh06-gray_main_1.jpg','image',0),(3325,90,'/w/s/wsh06-gray_alt1_1.jpg','image',0),(3326,90,'/w/s/wsh06-gray_back_1.jpg','image',0),(3327,90,'/w/s/wsh06-orange_main_1.jpg','image',0),(3328,90,'/w/s/wsh06-purple_main_1.jpg','image',0),(3329,90,'/w/s/wsh06-gray_main_1.jpg','image',0),(3330,90,'/w/s/wsh06-gray_alt1_1.jpg','image',0),(3331,90,'/w/s/wsh06-gray_back_1.jpg','image',0),(3332,90,'/w/s/wsh06-orange_main_1.jpg','image',0),(3333,90,'/w/s/wsh06-purple_main_1.jpg','image',0),(3334,90,'/w/s/wsh06-gray_main_1.jpg','image',0),(3335,90,'/w/s/wsh06-gray_alt1_1.jpg','image',0),(3336,90,'/w/s/wsh06-gray_back_1.jpg','image',0),(3337,90,'/w/s/wsh07-black_main_1.jpg','image',0),(3338,90,'/w/s/wsh07-black_back_1.jpg','image',0),(3339,90,'/w/s/wsh07-blue_main_1.jpg','image',0),(3340,90,'/w/s/wsh07-purple_main_1.jpg','image',0),(3341,90,'/w/s/wsh07-black_main_1.jpg','image',0),(3342,90,'/w/s/wsh07-black_back_1.jpg','image',0),(3343,90,'/w/s/wsh07-blue_main_1.jpg','image',0),(3344,90,'/w/s/wsh07-purple_main_1.jpg','image',0),(3345,90,'/w/s/wsh07-black_main_1.jpg','image',0),(3346,90,'/w/s/wsh07-black_back_1.jpg','image',0),(3347,90,'/w/s/wsh08-purple_main_1.jpg','image',0),(3348,90,'/w/s/wsh08-purple_back_1.jpg','image',0),(3349,90,'/w/s/wsh08-purple_main_1.jpg','image',0),(3350,90,'/w/s/wsh08-purple_back_1.jpg','image',0),(3351,90,'/w/s/wsh08-purple_main_1.jpg','image',0),(3352,90,'/w/s/wsh08-purple_back_1.jpg','image',0),(3353,90,'/w/s/wsh08-purple_main_1.jpg','image',0),(3354,90,'/w/s/wsh08-purple_back_1.jpg','image',0),(3355,90,'/w/s/wsh08-purple_main_1.jpg','image',0),(3356,90,'/w/s/wsh08-purple_back_1.jpg','image',0),(3357,90,'/w/s/wsh08-purple_main_1.jpg','image',0),(3358,90,'/w/s/wsh08-purple_back_1.jpg','image',0),(3359,90,'/w/s/wsh09-gray_main_1.jpg','image',0),(3360,90,'/w/s/wsh09-gray_alt1_1.jpg','image',0),(3361,90,'/w/s/wsh09-gray_back_1.jpg','image',0),(3362,90,'/w/s/wsh09-green_main_1.jpg','image',0),(3363,90,'/w/s/wsh09-white_main_1.jpg','image',0),(3364,90,'/w/s/wsh09-gray_main_1.jpg','image',0),(3365,90,'/w/s/wsh09-gray_alt1_1.jpg','image',0),(3366,90,'/w/s/wsh09-gray_back_1.jpg','image',0),(3367,90,'/w/s/wsh09-green_main_1.jpg','image',0),(3368,90,'/w/s/wsh09-white_main_1.jpg','image',0),(3369,90,'/w/s/wsh09-gray_main_1.jpg','image',0),(3370,90,'/w/s/wsh09-gray_alt1_1.jpg','image',0),(3371,90,'/w/s/wsh09-gray_back_1.jpg','image',0),(3372,90,'/w/s/wsh10-black_main_1.jpg','image',0),(3373,90,'/w/s/wsh10-black_alt1_1.jpg','image',0),(3374,90,'/w/s/wsh10-black_back_1.jpg','image',0),(3375,90,'/w/s/wsh10-orange_main_1.jpg','image',0),(3376,90,'/w/s/wsh10-white_main_1.jpg','image',0),(3377,90,'/w/s/wsh10-black_main_1.jpg','image',0),(3378,90,'/w/s/wsh10-black_alt1_1.jpg','image',0),(3379,90,'/w/s/wsh10-black_back_1.jpg','image',0),(3380,90,'/w/s/wsh10-orange_main_1.jpg','image',0),(3381,90,'/w/s/wsh10-white_main_1.jpg','image',0),(3382,90,'/w/s/wsh10-black_main_1.jpg','image',0),(3383,90,'/w/s/wsh10-black_alt1_1.jpg','image',0),(3384,90,'/w/s/wsh10-black_back_1.jpg','image',0),(3385,90,'/w/s/wsh11-blue_main_1.jpg','image',0),(3386,90,'/w/s/wsh11-blue_back_1.jpg','image',0),(3387,90,'/w/s/wsh11-orange_main_1.jpg','image',0),(3388,90,'/w/s/wsh11-red_main_1.jpg','image',0),(3389,90,'/w/s/wsh11-blue_main_1.jpg','image',0),(3390,90,'/w/s/wsh11-blue_back_1.jpg','image',0),(3391,90,'/w/s/wsh11-orange_main_1.jpg','image',0),(3392,90,'/w/s/wsh11-red_main_1.jpg','image',0),(3393,90,'/w/s/wsh11-blue_main_1.jpg','image',0),(3394,90,'/w/s/wsh11-blue_back_1.jpg','image',0),(3395,90,'/w/s/wsh12-green_main_1.jpg','image',0),(3396,90,'/w/s/wsh12-green_alt1_1.jpg','image',0),(3397,90,'/w/s/wsh12-green_back_1.jpg','image',0),(3398,90,'/w/s/wsh12-purple_main_1.jpg','image',0),(3399,90,'/w/s/wsh12-red_main_1.jpg','image',0),(3400,90,'/w/s/wsh12-green_main_1.jpg','image',0),(3401,90,'/w/s/wsh12-green_alt1_1.jpg','image',0),(3402,90,'/w/s/wsh12-green_back_1.jpg','image',0),(3403,90,'/w/s/wsh12-purple_main_1.jpg','image',0),(3404,90,'/w/s/wsh12-red_main_1.jpg','image',0),(3405,90,'/w/s/wsh12-green_main_1.jpg','image',0),(3406,90,'/w/s/wsh12-green_alt1_1.jpg','image',0),(3407,90,'/w/s/wsh12-green_back_1.jpg','image',0),(3408,90,'/w/s/wsh12-purple_main_1.jpg','image',0),(3409,90,'/w/s/wsh12-red_main_1.jpg','image',0),(3410,90,'/w/s/wsh12-green_main_1.jpg','image',0),(3411,90,'/w/s/wsh12-green_alt1_1.jpg','image',0),(3412,90,'/w/s/wsh12-green_back_1.jpg','image',0),(3413,90,'/w/s/wsh12-purple_main_1.jpg','image',0),(3414,90,'/w/s/wsh12-red_main_1.jpg','image',0),(3415,90,'/w/s/wsh12-green_main_1.jpg','image',0),(3416,90,'/w/s/wsh12-green_alt1_1.jpg','image',0),(3417,90,'/w/s/wsh12-green_back_1.jpg','image',0),(3418,90,'/w/s/wsh12-purple_main_1.jpg','image',0),(3419,90,'/w/s/wsh12-red_main_1.jpg','image',0),(3420,90,'/w/s/wsh12-green_main_1.jpg','image',0),(3421,90,'/w/s/wsh12-green_alt1_1.jpg','image',0),(3422,90,'/w/s/wsh12-green_back_1.jpg','image',0);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_media_gallery_value`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_media_gallery_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value` (
  `value_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Value ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `label` varchar(255) DEFAULT NULL COMMENT 'Label',
  `position` int(10) unsigned DEFAULT NULL COMMENT 'Position',
  `disabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Disabled',
  `record_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Record ID',
  PRIMARY KEY (`record_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_STORE_ID` (`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_ENTITY_ID` (`entity_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_VALUE_ID` (`value_id`),
  KEY `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_VAL_ENTT_ID_VAL_ID_STORE_ID` (`entity_id`,`value_id`,`store_id`),
  CONSTRAINT `FK_CCAEA26D5065C2D6A7A1517EBBA6ED81` FOREIGN KEY (`value_id`) REFERENCES `[[dbprefix]]catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_VAL_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_VAL_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3423 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Media Gallery Attribute Value Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_media_gallery_value`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_media_gallery_value` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_media_gallery_value` VALUES (1,0,1,'Image',1,0,1),(2,0,2,'Image',1,0,2),(3,0,2,'Image',2,0,3),(4,0,3,'Image',1,0,4),(5,0,3,'Image',2,0,5),(6,0,4,'Image',1,0,6),(7,0,5,'Image',1,0,7),(8,0,6,'Image',1,0,8),(9,0,6,'Image',2,0,9),(10,0,7,'Image',1,0,10),(11,0,8,'Image',1,0,11),(12,0,9,'Image',1,0,12),(13,0,10,'Image',1,0,13),(14,0,11,'Image',1,0,14),(15,0,11,'Image',2,0,15),(16,0,12,'Image',1,0,16),(17,0,13,'Image',1,0,17),(18,0,14,'Image',1,0,18),(19,0,15,'Image',1,0,19),(20,0,16,'Image',1,0,20),(21,0,16,'Image',2,0,21),(22,0,17,'Image',1,0,22),(23,0,18,'Image',1,0,23),(24,0,19,'Image',1,0,24),(25,0,20,'Image',1,0,25),(26,0,21,'Image',1,0,26),(27,0,22,'Image',1,0,27),(28,0,23,'Image',1,0,28),(29,0,24,'Image',1,0,29),(30,0,25,'Image',1,0,30),(31,0,26,'Image',1,0,31),(32,0,27,'Image',1,0,32),(33,0,28,'Image',1,0,33),(34,0,29,'Image',1,0,34),(35,0,30,'Image',1,0,35),(36,0,31,'Image',1,0,36),(37,0,32,'Image',1,0,37),(38,0,33,'Image',1,0,38),(39,0,34,'Image',1,0,39),(40,0,35,'Image',1,0,40),(41,0,36,'Image',1,0,41),(42,0,37,'Image',1,0,42),(43,0,38,'Image',1,0,43),(44,0,39,'Image',1,0,44),(45,0,40,'Image',1,0,45),(46,0,41,'Image',1,0,46),(47,0,42,'Image',1,0,47),(48,0,43,'Image',1,0,48),(49,0,43,'Image',2,0,49),(50,0,44,'Image',1,0,50),(51,0,45,'Image',1,0,51),(52,0,46,'Image',1,0,52),(53,0,47,'Image',1,0,53),(54,0,48,'Image',1,0,54),(55,0,49,'Image',1,0,55),(56,0,50,'Image',1,0,56),(57,0,51,'Image',1,0,57),(58,0,52,'Image',1,0,58),(59,0,53,'',1,0,59),(60,0,54,'',1,0,60),(61,0,54,'',2,0,61),(62,0,54,'',3,0,62),(63,0,55,'',1,0,63),(64,0,56,'',1,0,64),(65,0,57,'',1,0,65),(66,0,57,'',2,0,66),(67,0,57,'',3,0,67),(68,0,58,'',1,0,68),(69,0,59,'',1,0,69),(70,0,60,'',1,0,70),(71,0,60,'',2,0,71),(72,0,60,'',3,0,72),(73,0,61,'',1,0,73),(74,0,62,'',1,0,74),(75,0,63,'',1,0,75),(76,0,63,'',2,0,76),(77,0,63,'',3,0,77),(78,0,64,'',1,0,78),(79,0,65,'',1,0,79),(80,0,66,'',1,0,80),(81,0,66,'',2,0,81),(82,0,66,'',3,0,82),(83,0,67,'',1,0,83),(84,0,68,'',1,0,84),(85,0,68,'',2,0,85),(86,0,68,'',3,0,86),(87,0,69,'',1,0,87),(88,0,69,'',2,0,88),(89,0,69,'',3,0,89),(90,0,70,'',1,0,90),(91,0,71,'',1,0,91),(92,0,72,'',1,0,92),(93,0,72,'',2,0,93),(94,0,72,'',3,0,94),(95,0,73,'',1,0,95),(96,0,74,'',1,0,96),(97,0,75,'',1,0,97),(98,0,75,'',2,0,98),(99,0,75,'',3,0,99),(100,0,76,'',1,0,100),(101,0,77,'',1,0,101),(102,0,78,'',1,0,102),(103,0,78,'',2,0,103),(104,0,78,'',3,0,104),(105,0,79,'',1,0,105),(106,0,80,'',1,0,106),(107,0,81,'',1,0,107),(108,0,81,'',2,0,108),(109,0,81,'',3,0,109),(110,0,82,'',1,0,110),(111,0,83,'',1,0,111),(112,0,84,'',1,0,112),(113,0,84,'',2,0,113),(114,0,84,'',3,0,114),(115,0,85,'',1,0,115),(116,0,85,'',2,0,116),(117,0,85,'',3,0,117),(118,0,86,'',1,0,118),(119,0,87,'',1,0,119),(120,0,88,'',1,0,120),(121,0,88,'',2,0,121),(122,0,88,'',3,0,122),(123,0,89,'',1,0,123),(124,0,90,'',1,0,124),(125,0,91,'',1,0,125),(126,0,91,'',2,0,126),(127,0,91,'',3,0,127),(128,0,92,'',1,0,128),(129,0,93,'',1,0,129),(130,0,94,'',1,0,130),(131,0,94,'',2,0,131),(132,0,94,'',3,0,132),(133,0,95,'',1,0,133),(134,0,96,'',1,0,134),(135,0,97,'',1,0,135),(136,0,97,'',2,0,136),(137,0,97,'',3,0,137),(138,0,98,'',1,0,138),(139,0,99,'',1,0,139),(140,0,100,'',1,0,140),(141,0,100,'',2,0,141),(142,0,100,'',3,0,142),(143,0,101,'',1,0,143),(144,0,101,'',2,0,144),(145,0,101,'',3,0,145),(146,0,102,'',1,0,146),(147,0,103,'',1,0,147),(148,0,104,'',1,0,148),(149,0,104,'',2,0,149),(150,0,104,'',3,0,150),(151,0,105,'',1,0,151),(152,0,106,'',1,0,152),(153,0,107,'',1,0,153),(154,0,107,'',2,0,154),(155,0,107,'',3,0,155),(156,0,108,'',1,0,156),(157,0,109,'',1,0,157),(158,0,110,'',1,0,158),(159,0,110,'',2,0,159),(160,0,110,'',3,0,160),(161,0,111,'',1,0,161),(162,0,112,'',1,0,162),(163,0,113,'',1,0,163),(164,0,113,'',2,0,164),(165,0,113,'',3,0,165),(166,0,114,'',1,0,166),(167,0,115,'',1,0,167),(168,0,116,'',1,0,168),(169,0,116,'',2,0,169),(170,0,116,'',3,0,170),(171,0,117,'',1,0,171),(172,0,118,'',1,0,172),(173,0,119,'',1,0,173),(174,0,119,'',2,0,174),(175,0,119,'',3,0,175),(176,0,120,'',1,0,176),(177,0,121,'',1,0,177),(178,0,122,'',1,0,178),(179,0,122,'',2,0,179),(180,0,122,'',3,0,180),(181,0,123,'',1,0,181),(182,0,124,'',1,0,182),(183,0,125,'',1,0,183),(184,0,125,'',2,0,184),(185,0,125,'',3,0,185),(186,0,126,'',1,0,186),(187,0,127,'',1,0,187),(188,0,128,'',1,0,188),(189,0,128,'',2,0,189),(190,0,128,'',3,0,190),(191,0,129,'',1,0,191),(192,0,130,'',1,0,192),(193,0,131,'',1,0,193),(194,0,131,'',2,0,194),(195,0,131,'',3,0,195),(196,0,132,'',1,0,196),(197,0,132,'',2,0,197),(198,0,132,'',3,0,198),(199,0,133,'',1,0,199),(200,0,134,'',1,0,200),(201,0,134,'',2,0,201),(202,0,134,'',3,0,202),(203,0,135,'',1,0,203),(204,0,136,'',1,0,204),(205,0,137,'',1,0,205),(206,0,137,'',2,0,206),(207,0,137,'',3,0,207),(208,0,138,'',1,0,208),(209,0,139,'',1,0,209),(210,0,140,'',1,0,210),(211,0,140,'',2,0,211),(212,0,140,'',3,0,212),(213,0,141,'',1,0,213),(214,0,142,'',1,0,214),(215,0,143,'',1,0,215),(216,0,143,'',2,0,216),(217,0,143,'',3,0,217),(218,0,144,'',1,0,218),(219,0,145,'',1,0,219),(220,0,146,'',1,0,220),(221,0,146,'',2,0,221),(222,0,146,'',3,0,222),(223,0,147,'',1,0,223),(224,0,148,'',1,0,224),(225,0,148,'',2,0,225),(226,0,148,'',3,0,226),(227,0,149,'',1,0,227),(228,0,150,'',1,0,228),(229,0,150,'',2,0,229),(230,0,150,'',3,0,230),(231,0,151,'',1,0,231),(232,0,152,'',1,0,232),(233,0,153,'',1,0,233),(234,0,153,'',2,0,234),(235,0,153,'',3,0,235),(236,0,154,'',1,0,236),(237,0,155,'',1,0,237),(238,0,156,'',1,0,238),(239,0,156,'',2,0,239),(240,0,156,'',3,0,240),(241,0,157,'',1,0,241),(242,0,158,'',1,0,242),(243,0,159,'',1,0,243),(244,0,159,'',2,0,244),(245,0,159,'',3,0,245),(246,0,160,'',1,0,246),(247,0,161,'',1,0,247),(248,0,162,'',1,0,248),(249,0,162,'',2,0,249),(250,0,162,'',3,0,250),(251,0,163,'',1,0,251),(252,0,164,'',1,0,252),(253,0,164,'',2,0,253),(254,0,164,'',3,0,254),(255,0,165,'',1,0,255),(256,0,165,'',2,0,256),(257,0,165,'',3,0,257),(258,0,166,'',1,0,258),(259,0,167,'',1,0,259),(260,0,168,'',1,0,260),(261,0,168,'',2,0,261),(262,0,168,'',3,0,262),(263,0,169,'',1,0,263),(264,0,170,'',1,0,264),(265,0,171,'',1,0,265),(266,0,171,'',2,0,266),(267,0,171,'',3,0,267),(268,0,172,'',1,0,268),(269,0,173,'',1,0,269),(270,0,174,'',1,0,270),(271,0,174,'',2,0,271),(272,0,174,'',3,0,272),(273,0,175,'',1,0,273),(274,0,176,'',1,0,274),(275,0,177,'',1,0,275),(276,0,177,'',2,0,276),(277,0,177,'',3,0,277),(278,0,178,'',1,0,278),(279,0,179,'',1,0,279),(280,0,180,'',1,0,280),(281,0,180,'',2,0,281),(282,0,180,'',3,0,282),(283,0,181,'',1,0,283),(284,0,181,'',2,0,284),(285,0,181,'',3,0,285),(286,0,182,'',1,0,286),(287,0,183,'',1,0,287),(288,0,184,'',1,0,288),(289,0,184,'',2,0,289),(290,0,184,'',3,0,290),(291,0,185,'',1,0,291),(292,0,186,'',1,0,292),(293,0,187,'',1,0,293),(294,0,187,'',2,0,294),(295,0,187,'',3,0,295),(296,0,188,'',1,0,296),(297,0,189,'',1,0,297),(298,0,190,'',1,0,298),(299,0,190,'',2,0,299),(300,0,190,'',3,0,300),(301,0,191,'',1,0,301),(302,0,192,'',1,0,302),(303,0,193,'',1,0,303),(304,0,193,'',2,0,304),(305,0,193,'',3,0,305),(306,0,194,'',1,0,306),(307,0,195,'',1,0,307),(308,0,196,'',1,0,308),(309,0,196,'',2,0,309),(310,0,196,'',3,0,310),(311,0,197,'',1,0,311),(312,0,198,'',1,0,312),(313,0,198,'',2,0,313),(314,0,198,'',3,0,314),(315,0,199,'',1,0,315),(316,0,200,'',1,0,316),(317,0,201,'',1,0,317),(318,0,201,'',2,0,318),(319,0,201,'',3,0,319),(320,0,202,'',1,0,320),(321,0,203,'',1,0,321),(322,0,204,'',1,0,322),(323,0,204,'',2,0,323),(324,0,204,'',3,0,324),(325,0,205,'',1,0,325),(326,0,206,'',1,0,326),(327,0,207,'',1,0,327),(328,0,207,'',2,0,328),(329,0,207,'',3,0,329),(330,0,208,'',1,0,330),(331,0,209,'',1,0,331),(332,0,210,'',1,0,332),(333,0,210,'',2,0,333),(334,0,210,'',3,0,334),(335,0,211,'',1,0,335),(336,0,212,'',1,0,336),(337,0,212,'',2,0,337),(338,0,212,'',3,0,338),(339,0,213,'',1,0,339),(340,0,214,'',1,0,340),(341,0,215,'',1,0,341),(342,0,215,'',2,0,342),(343,0,215,'',3,0,343),(344,0,216,'',1,0,344),(345,0,217,'',1,0,345),(346,0,218,'',1,0,346),(347,0,218,'',2,0,347),(348,0,218,'',3,0,348),(349,0,219,'',1,0,349),(350,0,220,'',1,0,350),(351,0,221,'',1,0,351),(352,0,221,'',2,0,352),(353,0,221,'',3,0,353),(354,0,222,'',1,0,354),(355,0,223,'',1,0,355),(356,0,224,'',1,0,356),(357,0,224,'',2,0,357),(358,0,224,'',3,0,358),(359,0,225,'',1,0,359),(360,0,226,'',1,0,360),(361,0,227,'',1,0,361),(362,0,227,'',2,0,362),(363,0,227,'',3,0,363),(364,0,228,'',1,0,364),(365,0,228,'',2,0,365),(366,0,228,'',3,0,366),(367,0,229,'',1,0,367),(368,0,230,'',1,0,368),(369,0,230,'',2,0,369),(370,0,230,'',3,0,370),(371,0,231,'',1,0,371),(372,0,232,'',1,0,372),(373,0,233,'',1,0,373),(374,0,233,'',2,0,374),(375,0,233,'',3,0,375),(376,0,234,'',1,0,376),(377,0,235,'',1,0,377),(378,0,236,'',1,0,378),(379,0,236,'',2,0,379),(380,0,236,'',3,0,380),(381,0,237,'',1,0,381),(382,0,238,'',1,0,382),(383,0,239,'',1,0,383),(384,0,239,'',2,0,384),(385,0,239,'',3,0,385),(386,0,240,'',1,0,386),(387,0,241,'',1,0,387),(388,0,242,'',1,0,388),(389,0,242,'',2,0,389),(390,0,242,'',3,0,390),(391,0,243,'',1,0,391),(392,0,244,'',1,0,392),(393,0,244,'',2,0,393),(394,0,244,'',3,0,394),(395,0,245,'',1,0,395),(396,0,245,'',2,0,396),(397,0,245,'',3,0,397),(398,0,246,'',1,0,398),(399,0,247,'',1,0,399),(400,0,248,'',1,0,400),(401,0,248,'',2,0,401),(402,0,248,'',3,0,402),(403,0,249,'',1,0,403),(404,0,250,'',1,0,404),(405,0,251,'',1,0,405),(406,0,251,'',2,0,406),(407,0,251,'',3,0,407),(408,0,252,'',1,0,408),(409,0,253,'',1,0,409),(410,0,254,'',1,0,410),(411,0,254,'',2,0,411),(412,0,254,'',3,0,412),(413,0,255,'',1,0,413),(414,0,256,'',1,0,414),(415,0,257,'',1,0,415),(416,0,257,'',2,0,416),(417,0,257,'',3,0,417),(418,0,258,'',1,0,418),(419,0,259,'',1,0,419),(420,0,260,'',1,0,420),(421,0,260,'',2,0,421),(422,0,260,'',3,0,422),(423,0,261,'',1,0,423),(424,0,262,'',1,0,424),(425,0,263,'',1,0,425),(426,0,263,'',2,0,426),(427,0,263,'',3,0,427),(428,0,264,'',1,0,428),(429,0,265,'',1,0,429),(430,0,266,'',1,0,430),(431,0,266,'',2,0,431),(432,0,266,'',3,0,432),(433,0,267,'',1,0,433),(434,0,268,'',1,0,434),(435,0,269,'',1,0,435),(436,0,269,'',2,0,436),(437,0,269,'',3,0,437),(438,0,270,'',1,0,438),(439,0,271,'',1,0,439),(440,0,272,'',1,0,440),(441,0,272,'',2,0,441),(442,0,272,'',3,0,442),(443,0,273,'',1,0,443),(444,0,274,'',1,0,444),(445,0,275,'',1,0,445),(446,0,275,'',2,0,446),(447,0,275,'',3,0,447),(448,0,276,'',1,0,448),(449,0,276,'',2,0,449),(450,0,276,'',3,0,450),(451,0,277,'',1,0,451),(452,0,277,'',2,0,452),(453,0,277,'',3,0,453),(454,0,278,'',1,0,454),(455,0,279,'',1,0,455),(456,0,280,'',1,0,456),(457,0,280,'',2,0,457),(458,0,280,'',3,0,458),(459,0,281,'',1,0,459),(460,0,282,'',1,0,460),(461,0,283,'',1,0,461),(462,0,283,'',2,0,462),(463,0,283,'',3,0,463),(464,0,284,'',1,0,464),(465,0,285,'',1,0,465),(466,0,286,'',1,0,466),(467,0,286,'',2,0,467),(468,0,286,'',3,0,468),(469,0,287,'',1,0,469),(470,0,288,'',1,0,470),(471,0,289,'',1,0,471),(472,0,289,'',2,0,472),(473,0,289,'',3,0,473),(474,0,290,'',1,0,474),(475,0,291,'',1,0,475),(476,0,292,'',1,0,476),(477,0,292,'',2,0,477),(478,0,292,'',3,0,478),(479,0,293,'',1,0,479),(480,0,293,'',2,0,480),(481,0,293,'',3,0,481),(482,0,294,'',1,0,482),(483,0,295,'',1,0,483),(484,0,296,'',1,0,484),(485,0,296,'',2,0,485),(486,0,296,'',3,0,486),(487,0,297,'',1,0,487),(488,0,298,'',1,0,488),(489,0,299,'',1,0,489),(490,0,299,'',2,0,490),(491,0,299,'',3,0,491),(492,0,300,'',1,0,492),(493,0,301,'',1,0,493),(494,0,302,'',1,0,494),(495,0,302,'',2,0,495),(496,0,302,'',3,0,496),(497,0,303,'',1,0,497),(498,0,304,'',1,0,498),(499,0,305,'',1,0,499),(500,0,305,'',2,0,500),(501,0,305,'',3,0,501),(502,0,306,'',1,0,502),(503,0,307,'',1,0,503),(504,0,308,'',1,0,504),(505,0,308,'',2,0,505),(506,0,308,'',3,0,506),(507,0,309,'',1,0,507),(508,0,310,'',1,0,508),(509,0,310,'',2,0,509),(510,0,310,'',3,0,510),(511,0,311,'',1,0,511),(512,0,312,'',1,0,512),(513,0,313,'',1,0,513),(514,0,313,'',2,0,514),(515,0,313,'',3,0,515),(516,0,314,'',1,0,516),(517,0,315,'',1,0,517),(518,0,316,'',1,0,518),(519,0,316,'',2,0,519),(520,0,316,'',3,0,520),(521,0,317,'',1,0,521),(522,0,318,'',1,0,522),(523,0,319,'',1,0,523),(524,0,319,'',2,0,524),(525,0,319,'',3,0,525),(526,0,320,'',1,0,526),(527,0,321,'',1,0,527),(528,0,322,'',1,0,528),(529,0,322,'',2,0,529),(530,0,322,'',3,0,530),(531,0,323,'',1,0,531),(532,0,324,'',1,0,532),(533,0,324,'',2,0,533),(534,0,324,'',3,0,534),(535,0,325,'',1,0,535),(536,0,326,'',1,0,536),(537,0,326,'',2,0,537),(538,0,326,'',3,0,538),(539,0,327,'',1,0,539),(540,0,328,'',1,0,540),(541,0,329,'',1,0,541),(542,0,329,'',2,0,542),(543,0,329,'',3,0,543),(544,0,330,'',1,0,544),(545,0,331,'',1,0,545),(546,0,332,'',1,0,546),(547,0,332,'',2,0,547),(548,0,332,'',3,0,548),(549,0,333,'',1,0,549),(550,0,334,'',1,0,550),(551,0,335,'',1,0,551),(552,0,335,'',2,0,552),(553,0,335,'',3,0,553),(554,0,336,'',1,0,554),(555,0,337,'',1,0,555),(556,0,338,'',1,0,556),(557,0,338,'',2,0,557),(558,0,338,'',3,0,558),(559,0,339,'',1,0,559),(560,0,340,'',1,0,560),(561,0,340,'',2,0,561),(562,0,340,'',3,0,562),(563,0,341,'',1,0,563),(564,0,342,'',1,0,564),(565,0,343,'',1,0,565),(566,0,343,'',2,0,566),(567,0,343,'',3,0,567),(568,0,344,'',1,0,568),(569,0,345,'',1,0,569),(570,0,346,'',1,0,570),(571,0,346,'',2,0,571),(572,0,346,'',3,0,572),(573,0,347,'',1,0,573),(574,0,348,'',1,0,574),(575,0,349,'',1,0,575),(576,0,349,'',2,0,576),(577,0,349,'',3,0,577),(578,0,350,'',1,0,578),(579,0,351,'',1,0,579),(580,0,352,'',1,0,580),(581,0,352,'',2,0,581),(582,0,352,'',3,0,582),(583,0,353,'',1,0,583),(584,0,354,'',1,0,584),(585,0,355,'',1,0,585),(586,0,355,'',2,0,586),(587,0,355,'',3,0,587),(588,0,356,'',1,0,588),(589,0,356,'',2,0,589),(590,0,356,'',3,0,590),(591,0,357,'',1,0,591),(592,0,358,'',1,0,592),(593,0,359,'',1,0,593),(594,0,359,'',2,0,594),(595,0,359,'',3,0,595),(596,0,360,'',1,0,596),(597,0,361,'',1,0,597),(598,0,362,'',1,0,598),(599,0,362,'',2,0,599),(600,0,362,'',3,0,600),(601,0,363,'',1,0,601),(602,0,364,'',1,0,602),(603,0,365,'',1,0,603),(604,0,365,'',2,0,604),(605,0,365,'',3,0,605),(606,0,366,'',1,0,606),(607,0,367,'',1,0,607),(608,0,368,'',1,0,608),(609,0,368,'',2,0,609),(610,0,368,'',3,0,610),(611,0,369,'',1,0,611),(612,0,370,'',1,0,612),(613,0,371,'',1,0,613),(614,0,371,'',2,0,614),(615,0,371,'',3,0,615),(616,0,372,'',1,0,616),(617,0,372,'',2,0,617),(618,0,372,'',3,0,618),(619,0,373,'',1,0,619),(620,0,373,'',2,0,620),(621,0,373,'',3,0,621),(622,0,374,'',1,0,622),(623,0,375,'',1,0,623),(624,0,376,'',1,0,624),(625,0,376,'',2,0,625),(626,0,376,'',3,0,626),(627,0,377,'',1,0,627),(628,0,378,'',1,0,628),(629,0,379,'',1,0,629),(630,0,379,'',2,0,630),(631,0,379,'',3,0,631),(632,0,380,'',1,0,632),(633,0,381,'',1,0,633),(634,0,382,'',1,0,634),(635,0,382,'',2,0,635),(636,0,382,'',3,0,636),(637,0,383,'',1,0,637),(638,0,384,'',1,0,638),(639,0,385,'',1,0,639),(640,0,385,'',2,0,640),(641,0,385,'',3,0,641),(642,0,386,'',1,0,642),(643,0,387,'',1,0,643),(644,0,388,'',1,0,644),(645,0,388,'',2,0,645),(646,0,388,'',3,0,646),(647,0,389,'',1,0,647),(648,0,389,'',2,0,648),(649,0,389,'',3,0,649),(650,0,390,'',1,0,650),(651,0,391,'',1,0,651),(652,0,392,'',1,0,652),(653,0,392,'',2,0,653),(654,0,392,'',3,0,654),(655,0,393,'',1,0,655),(656,0,394,'',1,0,656),(657,0,395,'',1,0,657),(658,0,395,'',2,0,658),(659,0,395,'',3,0,659),(660,0,396,'',1,0,660),(661,0,397,'',1,0,661),(662,0,398,'',1,0,662),(663,0,398,'',2,0,663),(664,0,398,'',3,0,664),(665,0,399,'',1,0,665),(666,0,400,'',1,0,666),(667,0,401,'',1,0,667),(668,0,401,'',2,0,668),(669,0,401,'',3,0,669),(670,0,402,'',1,0,670),(671,0,403,'',1,0,671),(672,0,404,'',1,0,672),(673,0,404,'',2,0,673),(674,0,404,'',3,0,674),(675,0,405,'',1,0,675),(676,0,405,'',2,0,676),(677,0,405,'',3,0,677),(678,0,406,'',1,0,678),(679,0,407,'',1,0,679),(680,0,408,'',1,0,680),(681,0,408,'',2,0,681),(682,0,408,'',3,0,682),(683,0,409,'',1,0,683),(684,0,410,'',1,0,684),(685,0,411,'',1,0,685),(686,0,411,'',2,0,686),(687,0,411,'',3,0,687),(688,0,412,'',1,0,688),(689,0,413,'',1,0,689),(690,0,414,'',1,0,690),(691,0,414,'',2,0,691),(692,0,414,'',3,0,692),(693,0,415,'',1,0,693),(694,0,416,'',1,0,694),(695,0,417,'',1,0,695),(696,0,417,'',2,0,696),(697,0,417,'',3,0,697),(698,0,418,'',1,0,698),(699,0,419,'',1,0,699),(700,0,420,'',1,0,700),(701,0,420,'',2,0,701),(702,0,420,'',3,0,702),(703,0,421,'',1,0,703),(704,0,422,'',1,0,704),(705,0,423,'',1,0,705),(706,0,423,'',2,0,706),(707,0,423,'',3,0,707),(708,0,424,'',1,0,708),(709,0,425,'',1,0,709),(710,0,426,'',1,0,710),(711,0,426,'',2,0,711),(712,0,426,'',3,0,712),(713,0,427,'',1,0,713),(714,0,428,'',1,0,714),(715,0,429,'',1,0,715),(716,0,429,'',2,0,716),(717,0,429,'',3,0,717),(718,0,430,'',1,0,718),(719,0,431,'',1,0,719),(720,0,432,'',1,0,720),(721,0,432,'',2,0,721),(722,0,432,'',3,0,722),(723,0,433,'',1,0,723),(724,0,434,'',1,0,724),(725,0,435,'',1,0,725),(726,0,435,'',2,0,726),(727,0,435,'',3,0,727),(728,0,436,'',1,0,728),(729,0,436,'',2,0,729),(730,0,436,'',3,0,730),(731,0,437,'',1,0,731),(732,0,438,'',1,0,732),(733,0,438,'',2,0,733),(734,0,439,'',1,0,734),(735,0,440,'',1,0,735),(736,0,441,'',1,0,736),(737,0,441,'',2,0,737),(738,0,442,'',1,0,738),(739,0,443,'',1,0,739),(740,0,444,'',1,0,740),(741,0,444,'',2,0,741),(742,0,445,'',1,0,742),(743,0,446,'',1,0,743),(744,0,447,'',1,0,744),(745,0,447,'',2,0,745),(746,0,448,'',1,0,746),(747,0,449,'',1,0,747),(748,0,450,'',1,0,748),(749,0,450,'',2,0,749),(750,0,451,'',1,0,750),(751,0,452,'',1,0,751),(752,0,452,'',2,0,752),(753,0,453,'',1,0,753),(754,0,454,'',1,0,754),(755,0,454,'',2,0,755),(756,0,455,'',1,0,756),(757,0,456,'',1,0,757),(758,0,457,'',1,0,758),(759,0,457,'',2,0,759),(760,0,458,'',1,0,760),(761,0,459,'',1,0,761),(762,0,460,'',1,0,762),(763,0,460,'',2,0,763),(764,0,461,'',1,0,764),(765,0,462,'',1,0,765),(766,0,463,'',1,0,766),(767,0,463,'',2,0,767),(768,0,464,'',1,0,768),(769,0,465,'',1,0,769),(770,0,466,'',1,0,770),(771,0,466,'',2,0,771),(772,0,467,'',1,0,772),(773,0,468,'',1,0,773),(774,0,468,'',2,0,774),(775,0,469,'',1,0,775),(776,0,470,'',1,0,776),(777,0,470,'',2,0,777),(778,0,470,'',3,0,778),(779,0,471,'',1,0,779),(780,0,472,'',1,0,780),(781,0,473,'',1,0,781),(782,0,473,'',2,0,782),(783,0,473,'',3,0,783),(784,0,474,'',1,0,784),(785,0,475,'',1,0,785),(786,0,476,'',1,0,786),(787,0,476,'',2,0,787),(788,0,476,'',3,0,788),(789,0,477,'',1,0,789),(790,0,478,'',1,0,790),(791,0,479,'',1,0,791),(792,0,479,'',2,0,792),(793,0,479,'',3,0,793),(794,0,480,'',1,0,794),(795,0,481,'',1,0,795),(796,0,482,'',1,0,796),(797,0,482,'',2,0,797),(798,0,482,'',3,0,798),(799,0,483,'',1,0,799),(800,0,484,'',1,0,800),(801,0,484,'',2,0,801),(802,0,484,'',3,0,802),(803,0,485,'',1,0,803),(804,0,486,'',1,0,804),(805,0,486,'',2,0,805),(806,0,487,'',1,0,806),(807,0,488,'',1,0,807),(808,0,489,'',1,0,808),(809,0,489,'',2,0,809),(810,0,490,'',1,0,810),(811,0,491,'',1,0,811),(812,0,492,'',1,0,812),(813,0,492,'',2,0,813),(814,0,493,'',1,0,814),(815,0,494,'',1,0,815),(816,0,495,'',1,0,816),(817,0,495,'',2,0,817),(818,0,496,'',1,0,818),(819,0,497,'',1,0,819),(820,0,498,'',1,0,820),(821,0,498,'',2,0,821),(822,0,499,'',1,0,822),(823,0,500,'',1,0,823),(824,0,500,'',2,0,824),(825,0,501,'',1,0,825),(826,0,502,'',1,0,826),(827,0,503,'',1,0,827),(828,0,503,'',2,0,828),(829,0,503,'',3,0,829),(830,0,504,'',1,0,830),(831,0,505,'',1,0,831),(832,0,506,'',1,0,832),(833,0,506,'',2,0,833),(834,0,506,'',3,0,834),(835,0,507,'',1,0,835),(836,0,508,'',1,0,836),(837,0,509,'',1,0,837),(838,0,509,'',2,0,838),(839,0,509,'',3,0,839),(840,0,510,'',1,0,840),(841,0,511,'',1,0,841),(842,0,512,'',1,0,842),(843,0,512,'',2,0,843),(844,0,512,'',3,0,844),(845,0,513,'',1,0,845),(846,0,514,'',1,0,846),(847,0,515,'',1,0,847),(848,0,515,'',2,0,848),(849,0,515,'',3,0,849),(850,0,516,'',1,0,850),(851,0,516,'',2,0,851),(852,0,516,'',3,0,852),(853,0,517,'',1,0,853),(854,0,517,'',2,0,854),(855,0,517,'',3,0,855),(856,0,518,'',1,0,856),(857,0,519,'',1,0,857),(858,0,520,'',1,0,858),(859,0,520,'',2,0,859),(860,0,520,'',3,0,860),(861,0,521,'',1,0,861),(862,0,522,'',1,0,862),(863,0,523,'',1,0,863),(864,0,523,'',2,0,864),(865,0,523,'',3,0,865),(866,0,524,'',1,0,866),(867,0,525,'',1,0,867),(868,0,526,'',1,0,868),(869,0,526,'',2,0,869),(870,0,526,'',3,0,870),(871,0,527,'',1,0,871),(872,0,528,'',1,0,872),(873,0,529,'',1,0,873),(874,0,529,'',2,0,874),(875,0,529,'',3,0,875),(876,0,530,'',1,0,876),(877,0,531,'',1,0,877),(878,0,532,'',1,0,878),(879,0,532,'',2,0,879),(880,0,533,'',1,0,880),(881,0,533,'',2,0,881),(882,0,533,'',3,0,882),(883,0,534,'',1,0,883),(884,0,535,'',1,0,884),(885,0,536,'',1,0,885),(886,0,536,'',2,0,886),(887,0,536,'',3,0,887),(888,0,537,'',1,0,888),(889,0,538,'',1,0,889),(890,0,539,'',1,0,890),(891,0,539,'',2,0,891),(892,0,539,'',3,0,892),(893,0,540,'',1,0,893),(894,0,541,'',1,0,894),(895,0,542,'',1,0,895),(896,0,542,'',2,0,896),(897,0,542,'',3,0,897),(898,0,543,'',1,0,898),(899,0,544,'',1,0,899),(900,0,545,'',1,0,900),(901,0,545,'',2,0,901),(902,0,545,'',3,0,902),(903,0,546,'',1,0,903),(904,0,547,'',1,0,904),(905,0,548,'',1,0,905),(906,0,548,'',2,0,906),(907,0,548,'',3,0,907),(908,0,549,'',1,0,908),(909,0,550,'',1,0,909),(910,0,550,'',2,0,910),(911,0,551,'',1,0,911),(912,0,552,'',1,0,912),(913,0,553,'',1,0,913),(914,0,553,'',2,0,914),(915,0,554,'',1,0,915),(916,0,555,'',1,0,916),(917,0,556,'',1,0,917),(918,0,556,'',2,0,918),(919,0,557,'',1,0,919),(920,0,558,'',1,0,920),(921,0,559,'',1,0,921),(922,0,559,'',2,0,922),(923,0,560,'',1,0,923),(924,0,561,'',1,0,924),(925,0,562,'',1,0,925),(926,0,562,'',2,0,926),(927,0,563,'',1,0,927),(928,0,564,'',1,0,928),(929,0,564,'',2,0,929),(930,0,565,'',1,0,930),(931,0,566,'',1,0,931),(932,0,567,'',1,0,932),(933,0,567,'',2,0,933),(934,0,567,'',3,0,934),(935,0,568,'',1,0,935),(936,0,569,'',1,0,936),(937,0,570,'',1,0,937),(938,0,570,'',2,0,938),(939,0,570,'',3,0,939),(940,0,571,'',1,0,940),(941,0,572,'',1,0,941),(942,0,573,'',1,0,942),(943,0,573,'',2,0,943),(944,0,573,'',3,0,944),(945,0,574,'',1,0,945),(946,0,575,'',1,0,946),(947,0,576,'',1,0,947),(948,0,576,'',2,0,948),(949,0,576,'',3,0,949),(950,0,577,'',1,0,950),(951,0,578,'',1,0,951),(952,0,579,'',1,0,952),(953,0,579,'',2,0,953),(954,0,579,'',3,0,954),(955,0,580,'',1,0,955),(956,0,580,'',2,0,956),(957,0,580,'',3,0,957),(958,0,581,'',1,0,958),(959,0,582,'',1,0,959),(960,0,582,'',2,0,960),(961,0,582,'',3,0,961),(962,0,583,'',1,0,962),(963,0,584,'',1,0,963),(964,0,585,'',1,0,964),(965,0,585,'',2,0,965),(966,0,585,'',3,0,966),(967,0,586,'',1,0,967),(968,0,587,'',1,0,968),(969,0,588,'',1,0,969),(970,0,588,'',2,0,970),(971,0,588,'',3,0,971),(972,0,589,'',1,0,972),(973,0,590,'',1,0,973),(974,0,591,'',1,0,974),(975,0,591,'',2,0,975),(976,0,591,'',3,0,976),(977,0,592,'',1,0,977),(978,0,593,'',1,0,978),(979,0,594,'',1,0,979),(980,0,594,'',2,0,980),(981,0,594,'',3,0,981),(982,0,595,'',1,0,982),(983,0,596,'',1,0,983),(984,0,596,'',2,0,984),(985,0,596,'',3,0,985),(986,0,597,'',1,0,986),(987,0,598,'',1,0,987),(988,0,598,'',2,0,988),(989,0,598,'',3,0,989),(990,0,599,'',1,0,990),(991,0,600,'',1,0,991),(992,0,601,'',1,0,992),(993,0,601,'',2,0,993),(994,0,601,'',3,0,994),(995,0,602,'',1,0,995),(996,0,603,'',1,0,996),(997,0,604,'',1,0,997),(998,0,604,'',2,0,998),(999,0,604,'',3,0,999),(1000,0,605,'',1,0,1000),(1001,0,606,'',1,0,1001),(1002,0,607,'',1,0,1002),(1003,0,607,'',2,0,1003),(1004,0,607,'',3,0,1004),(1005,0,608,'',1,0,1005),(1006,0,609,'',1,0,1006),(1007,0,610,'',1,0,1007),(1008,0,610,'',2,0,1008),(1009,0,610,'',3,0,1009),(1010,0,611,'',1,0,1010),(1011,0,612,'',1,0,1011),(1012,0,612,'',2,0,1012),(1013,0,612,'',3,0,1013),(1014,0,613,'',1,0,1014),(1015,0,613,'',2,0,1015),(1016,0,614,'',1,0,1016),(1017,0,615,'',1,0,1017),(1018,0,616,'',1,0,1018),(1019,0,616,'',2,0,1019),(1020,0,617,'',1,0,1020),(1021,0,618,'',1,0,1021),(1022,0,619,'',1,0,1022),(1023,0,619,'',2,0,1023),(1024,0,620,'',1,0,1024),(1025,0,621,'',1,0,1025),(1026,0,622,'',1,0,1026),(1027,0,622,'',2,0,1027),(1028,0,623,'',1,0,1028),(1029,0,624,'',1,0,1029),(1030,0,625,'',1,0,1030),(1031,0,625,'',2,0,1031),(1032,0,626,'',1,0,1032),(1033,0,627,'',1,0,1033),(1034,0,628,'',1,0,1034),(1035,0,628,'',2,0,1035),(1036,0,629,'',1,0,1036),(1037,0,630,'',1,0,1037),(1038,0,631,'',1,0,1038),(1039,0,631,'',2,0,1039),(1040,0,631,'',3,0,1040),(1041,0,632,'',1,0,1041),(1042,0,633,'',1,0,1042),(1043,0,634,'',1,0,1043),(1044,0,634,'',2,0,1044),(1045,0,634,'',3,0,1045),(1046,0,635,'',1,0,1046),(1047,0,636,'',1,0,1047),(1048,0,637,'',1,0,1048),(1049,0,637,'',2,0,1049),(1050,0,637,'',3,0,1050),(1051,0,638,'',1,0,1051),(1052,0,639,'',1,0,1052),(1053,0,640,'',1,0,1053),(1054,0,640,'',2,0,1054),(1055,0,640,'',3,0,1055),(1056,0,641,'',1,0,1056),(1057,0,642,'',1,0,1057),(1058,0,643,'',1,0,1058),(1059,0,643,'',2,0,1059),(1060,0,643,'',3,0,1060),(1061,0,644,'',1,0,1061),(1062,0,644,'',2,0,1062),(1063,0,644,'',3,0,1063),(1064,0,645,'',1,0,1064),(1065,0,646,'',1,0,1065),(1066,0,647,'',1,0,1066),(1067,0,647,'',2,0,1067),(1068,0,647,'',3,0,1068),(1069,0,647,'',4,0,1069),(1070,0,648,'',1,0,1070),(1071,0,649,'',1,0,1071),(1072,0,650,'',1,0,1072),(1073,0,650,'',2,0,1073),(1074,0,650,'',3,0,1074),(1075,0,650,'',4,0,1075),(1076,0,651,'',1,0,1076),(1077,0,652,'',1,0,1077),(1078,0,653,'',1,0,1078),(1079,0,653,'',2,0,1079),(1080,0,653,'',3,0,1080),(1081,0,653,'',4,0,1081),(1082,0,654,'',1,0,1082),(1083,0,655,'',1,0,1083),(1084,0,656,'',1,0,1084),(1085,0,656,'',2,0,1085),(1086,0,656,'',3,0,1086),(1087,0,656,'',4,0,1087),(1088,0,657,'',1,0,1088),(1089,0,658,'',1,0,1089),(1090,0,659,'',1,0,1090),(1091,0,659,'',2,0,1091),(1092,0,659,'',3,0,1092),(1093,0,659,'',4,0,1093),(1094,0,660,'',1,0,1094),(1095,0,660,'',2,0,1095),(1096,0,660,'',3,0,1096),(1097,0,660,'',4,0,1097),(1098,0,661,'',1,0,1098),(1099,0,662,'',1,0,1099),(1100,0,663,'',1,0,1100),(1101,0,664,'',1,0,1101),(1102,0,665,'',1,0,1102),(1103,0,666,'',1,0,1103),(1104,0,667,'',1,0,1104),(1105,0,668,'',1,0,1105),(1106,0,669,'',1,0,1106),(1107,0,670,'',1,0,1107),(1108,0,671,'',1,0,1108),(1109,0,672,'',1,0,1109),(1110,0,673,'',1,0,1110),(1111,0,674,'',1,0,1111),(1112,0,675,'',1,0,1112),(1113,0,676,'',1,0,1113),(1114,0,677,'',1,0,1114),(1115,0,677,'',2,0,1115),(1116,0,677,'',3,0,1116),(1117,0,678,'',1,0,1117),(1118,0,678,'',2,0,1118),(1119,0,678,'',3,0,1119),(1120,0,679,'',1,0,1120),(1121,0,679,'',2,0,1121),(1122,0,679,'',3,0,1122),(1123,0,680,'',1,0,1123),(1124,0,680,'',2,0,1124),(1125,0,680,'',3,0,1125),(1126,0,681,'',1,0,1126),(1127,0,681,'',2,0,1127),(1128,0,681,'',3,0,1128),(1129,0,682,'',1,0,1129),(1130,0,682,'',2,0,1130),(1131,0,682,'',3,0,1131),(1132,0,683,'',1,0,1132),(1133,0,683,'',2,0,1133),(1134,0,684,'',1,0,1134),(1135,0,684,'',2,0,1135),(1136,0,685,'',1,0,1136),(1137,0,685,'',2,0,1137),(1138,0,686,'',1,0,1138),(1139,0,686,'',2,0,1139),(1140,0,687,'',1,0,1140),(1141,0,687,'',2,0,1141),(1142,0,688,'',1,0,1142),(1143,0,688,'',2,0,1143),(1144,0,689,'',1,0,1144),(1145,0,689,'',2,0,1145),(1146,0,690,'',1,0,1146),(1147,0,690,'',2,0,1147),(1148,0,691,'',1,0,1148),(1149,0,691,'',2,0,1149),(1150,0,692,'',1,0,1150),(1151,0,692,'',2,0,1151),(1152,0,693,'',1,0,1152),(1153,0,693,'',2,0,1153),(1154,0,694,'',1,0,1154),(1155,0,694,'',2,0,1155),(1156,0,695,'',1,0,1156),(1157,0,695,'',2,0,1157),(1158,0,696,'',1,0,1158),(1159,0,696,'',2,0,1159),(1160,0,697,'',1,0,1160),(1161,0,697,'',2,0,1161),(1162,0,698,'',1,0,1162),(1163,0,698,'',2,0,1163),(1164,0,699,'',1,0,1164),(1165,0,699,'',2,0,1165),(1166,0,700,'',1,0,1166),(1167,0,700,'',2,0,1167),(1168,0,701,'',1,0,1168),(1169,0,701,'',2,0,1169),(1170,0,701,'',3,0,1170),(1171,0,702,'',1,0,1171),(1172,0,702,'',2,0,1172),(1173,0,702,'',3,0,1173),(1174,0,703,'',1,0,1174),(1175,0,703,'',2,0,1175),(1176,0,703,'',3,0,1176),(1177,0,704,'',1,0,1177),(1178,0,704,'',2,0,1178),(1179,0,704,'',3,0,1179),(1180,0,705,'',1,0,1180),(1181,0,705,'',2,0,1181),(1182,0,705,'',3,0,1182),(1183,0,706,'',1,0,1183),(1184,0,706,'',2,0,1184),(1185,0,706,'',3,0,1185),(1186,0,707,'',1,0,1186),(1187,0,707,'',2,0,1187),(1188,0,707,'',3,0,1188),(1189,0,708,'',1,0,1189),(1190,0,708,'',2,0,1190),(1191,0,708,'',3,0,1191),(1192,0,709,'',1,0,1192),(1193,0,709,'',2,0,1193),(1194,0,709,'',3,0,1194),(1195,0,710,'',1,0,1195),(1196,0,710,'',2,0,1196),(1197,0,710,'',3,0,1197),(1198,0,711,'',1,0,1198),(1199,0,711,'',2,0,1199),(1200,0,711,'',3,0,1200),(1201,0,712,'',1,0,1201),(1202,0,712,'',2,0,1202),(1203,0,712,'',3,0,1203),(1204,0,713,'',1,0,1204),(1205,0,713,'',2,0,1205),(1206,0,714,'',1,0,1206),(1207,0,714,'',2,0,1207),(1208,0,715,'',1,0,1208),(1209,0,715,'',2,0,1209),(1210,0,716,'',1,0,1210),(1211,0,716,'',2,0,1211),(1212,0,717,'',1,0,1212),(1213,0,717,'',2,0,1213),(1214,0,718,'',1,0,1214),(1215,0,718,'',2,0,1215),(1216,0,719,'',1,0,1216),(1217,0,719,'',2,0,1217),(1218,0,720,'',1,0,1218),(1219,0,720,'',2,0,1219),(1220,0,721,'',1,0,1220),(1221,0,721,'',2,0,1221),(1222,0,722,'',1,0,1222),(1223,0,722,'',2,0,1223),(1224,0,723,'',1,0,1224),(1225,0,723,'',2,0,1225),(1226,0,724,'',1,0,1226),(1227,0,724,'',2,0,1227),(1228,0,725,'',1,0,1228),(1229,0,725,'',2,0,1229),(1230,0,726,'',1,0,1230),(1231,0,726,'',2,0,1231),(1232,0,727,'',1,0,1232),(1233,0,727,'',2,0,1233),(1234,0,728,'',1,0,1234),(1235,0,728,'',2,0,1235),(1236,0,729,'',1,0,1236),(1237,0,729,'',2,0,1237),(1238,0,730,'',1,0,1238),(1239,0,730,'',2,0,1239),(1240,0,731,'',1,0,1240),(1241,0,732,'',1,0,1241),(1242,0,732,'',2,0,1242),(1243,0,733,'',1,0,1243),(1244,0,734,'',1,0,1244),(1245,0,735,'',1,0,1245),(1246,0,735,'',2,0,1246),(1247,0,736,'',1,0,1247),(1248,0,737,'',1,0,1248),(1249,0,738,'',1,0,1249),(1250,0,738,'',2,0,1250),(1251,0,739,'',1,0,1251),(1252,0,740,'',1,0,1252),(1253,0,741,'',1,0,1253),(1254,0,741,'',2,0,1254),(1255,0,742,'',1,0,1255),(1256,0,743,'',1,0,1256),(1257,0,743,'',2,0,1257),(1258,0,744,'',1,0,1258),(1259,0,745,'',1,0,1259),(1260,0,745,'',2,0,1260),(1261,0,746,'',1,0,1261),(1262,0,747,'',1,0,1262),(1263,0,748,'',1,0,1263),(1264,0,748,'',2,0,1264),(1265,0,749,'',1,0,1265),(1266,0,750,'',1,0,1266),(1267,0,751,'',1,0,1267),(1268,0,751,'',2,0,1268),(1269,0,752,'',1,0,1269),(1270,0,753,'',1,0,1270),(1271,0,754,'',1,0,1271),(1272,0,754,'',2,0,1272),(1273,0,755,'',1,0,1273),(1274,0,756,'',1,0,1274),(1275,0,756,'',2,0,1275),(1276,0,757,'',1,0,1276),(1277,0,758,'',1,0,1277),(1278,0,759,'',1,0,1278),(1279,0,760,'',1,0,1279),(1280,0,761,'',1,0,1280),(1281,0,762,'',1,0,1281),(1282,0,763,'',1,0,1282),(1283,0,764,'',1,0,1283),(1284,0,765,'',1,0,1284),(1285,0,766,'',1,0,1285),(1286,0,767,'',1,0,1286),(1287,0,768,'',1,0,1287),(1288,0,769,'',1,0,1288),(1289,0,769,'',2,0,1289),(1290,0,769,'',3,0,1290),(1291,0,770,'',1,0,1291),(1292,0,771,'',1,0,1292),(1293,0,771,'',2,0,1293),(1294,0,772,'',1,0,1294),(1295,0,773,'',1,0,1295),(1296,0,774,'',1,0,1296),(1297,0,774,'',2,0,1297),(1298,0,775,'',1,0,1298),(1299,0,776,'',1,0,1299),(1300,0,777,'',1,0,1300),(1301,0,777,'',2,0,1301),(1302,0,778,'',1,0,1302),(1303,0,779,'',1,0,1303),(1304,0,780,'',1,0,1304),(1305,0,780,'',2,0,1305),(1306,0,781,'',1,0,1306),(1307,0,782,'',1,0,1307),(1308,0,782,'',2,0,1308),(1309,0,783,'',1,0,1309),(1310,0,784,'',1,0,1310),(1311,0,784,'',2,0,1311),(1312,0,784,'',3,0,1312),(1313,0,785,'',1,0,1313),(1314,0,786,'',1,0,1314),(1315,0,787,'',1,0,1315),(1316,0,787,'',2,0,1316),(1317,0,787,'',3,0,1317),(1318,0,788,'',1,0,1318),(1319,0,789,'',1,0,1319),(1320,0,790,'',1,0,1320),(1321,0,790,'',2,0,1321),(1322,0,790,'',3,0,1322),(1323,0,791,'',1,0,1323),(1324,0,792,'',1,0,1324),(1325,0,793,'',1,0,1325),(1326,0,793,'',2,0,1326),(1327,0,793,'',3,0,1327),(1328,0,794,'',1,0,1328),(1329,0,795,'',1,0,1329),(1330,0,795,'',2,0,1330),(1331,0,795,'',3,0,1331),(1332,0,796,'',1,0,1332),(1333,0,796,'',2,0,1333),(1334,0,796,'',3,0,1334),(1335,0,797,'',1,0,1335),(1336,0,798,'',1,0,1336),(1337,0,799,'',1,0,1337),(1338,0,799,'',2,0,1338),(1339,0,799,'',3,0,1339),(1340,0,800,'',1,0,1340),(1341,0,801,'',1,0,1341),(1342,0,802,'',1,0,1342),(1343,0,802,'',2,0,1343),(1344,0,802,'',3,0,1344),(1345,0,803,'',1,0,1345),(1346,0,804,'',1,0,1346),(1347,0,805,'',1,0,1347),(1348,0,805,'',2,0,1348),(1349,0,805,'',3,0,1349),(1350,0,806,'',1,0,1350),(1351,0,807,'',1,0,1351),(1352,0,808,'',1,0,1352),(1353,0,808,'',2,0,1353),(1354,0,808,'',3,0,1354),(1355,0,809,'',1,0,1355),(1356,0,810,'',1,0,1356),(1357,0,810,'',2,0,1357),(1358,0,810,'',3,0,1358),(1359,0,810,'',4,0,1359),(1360,0,810,'',5,0,1360),(1361,0,811,'',1,0,1361),(1362,0,812,'',1,0,1362),(1363,0,813,'',1,0,1363),(1364,0,813,'',2,0,1364),(1365,0,813,'',3,0,1365),(1366,0,813,'',4,0,1366),(1367,0,813,'',5,0,1367),(1368,0,814,'',1,0,1368),(1369,0,815,'',1,0,1369),(1370,0,816,'',1,0,1370),(1371,0,816,'',2,0,1371),(1372,0,816,'',3,0,1372),(1373,0,816,'',4,0,1373),(1374,0,816,'',5,0,1374),(1375,0,817,'',1,0,1375),(1376,0,818,'',1,0,1376),(1377,0,819,'',1,0,1377),(1378,0,819,'',2,0,1378),(1379,0,819,'',3,0,1379),(1380,0,819,'',4,0,1380),(1381,0,819,'',5,0,1381),(1382,0,820,'',1,0,1382),(1383,0,821,'',1,0,1383),(1384,0,821,'',2,0,1384),(1385,0,821,'',3,0,1385),(1386,0,821,'',4,0,1386),(1387,0,821,'',5,0,1387),(1388,0,822,'',1,0,1388),(1389,0,823,'',1,0,1389),(1390,0,823,'',2,0,1390),(1391,0,823,'',3,0,1391),(1392,0,824,'',1,0,1392),(1393,0,825,'',1,0,1393),(1394,0,826,'',1,0,1394),(1395,0,826,'',2,0,1395),(1396,0,826,'',3,0,1396),(1397,0,827,'',1,0,1397),(1398,0,828,'',1,0,1398),(1399,0,829,'',1,0,1399),(1400,0,829,'',2,0,1400),(1401,0,829,'',3,0,1401),(1402,0,830,'',1,0,1402),(1403,0,831,'',1,0,1403),(1404,0,832,'',1,0,1404),(1405,0,832,'',2,0,1405),(1406,0,832,'',3,0,1406),(1407,0,833,'',1,0,1407),(1408,0,834,'',1,0,1408),(1409,0,834,'',2,0,1409),(1410,0,834,'',3,0,1410),(1411,0,835,'',1,0,1411),(1412,0,836,'',1,0,1412),(1413,0,836,'',2,0,1413),(1414,0,836,'',3,0,1414),(1415,0,837,'',1,0,1415),(1416,0,838,'',1,0,1416),(1417,0,839,'',1,0,1417),(1418,0,839,'',2,0,1418),(1419,0,839,'',3,0,1419),(1420,0,840,'',1,0,1420),(1421,0,841,'',1,0,1421),(1422,0,842,'',1,0,1422),(1423,0,842,'',2,0,1423),(1424,0,842,'',3,0,1424),(1425,0,843,'',1,0,1425),(1426,0,844,'',1,0,1426),(1427,0,845,'',1,0,1427),(1428,0,845,'',2,0,1428),(1429,0,845,'',3,0,1429),(1430,0,846,'',1,0,1430),(1431,0,847,'',1,0,1431),(1432,0,847,'',2,0,1432),(1433,0,847,'',3,0,1433),(1434,0,848,'',1,0,1434),(1435,0,848,'',2,0,1435),(1436,0,848,'',3,0,1436),(1437,0,849,'',1,0,1437),(1438,0,850,'',1,0,1438),(1439,0,851,'',1,0,1439),(1440,0,851,'',2,0,1440),(1441,0,851,'',3,0,1441),(1442,0,852,'',1,0,1442),(1443,0,853,'',1,0,1443),(1444,0,854,'',1,0,1444),(1445,0,854,'',2,0,1445),(1446,0,854,'',3,0,1446),(1447,0,855,'',1,0,1447),(1448,0,856,'',1,0,1448),(1449,0,857,'',1,0,1449),(1450,0,857,'',2,0,1450),(1451,0,857,'',3,0,1451),(1452,0,858,'',1,0,1452),(1453,0,859,'',1,0,1453),(1454,0,860,'',1,0,1454),(1455,0,860,'',2,0,1455),(1456,0,860,'',3,0,1456),(1457,0,861,'',1,0,1457),(1458,0,862,'',1,0,1458),(1459,0,862,'',2,0,1459),(1460,0,862,'',3,0,1460),(1461,0,863,'',1,0,1461),(1462,0,864,'',1,0,1462),(1463,0,865,'',1,0,1463),(1464,0,865,'',2,0,1464),(1465,0,865,'',3,0,1465),(1466,0,866,'',1,0,1466),(1467,0,867,'',1,0,1467),(1468,0,868,'',1,0,1468),(1469,0,868,'',2,0,1469),(1470,0,868,'',3,0,1470),(1471,0,869,'',1,0,1471),(1472,0,870,'',1,0,1472),(1473,0,871,'',1,0,1473),(1474,0,871,'',2,0,1474),(1475,0,871,'',3,0,1475),(1476,0,872,'',1,0,1476),(1477,0,873,'',1,0,1477),(1478,0,873,'',2,0,1478),(1479,0,873,'',3,0,1479),(1480,0,874,'',1,0,1480),(1481,0,874,'',2,0,1481),(1482,0,875,'',1,0,1482),(1483,0,876,'',1,0,1483),(1484,0,877,'',1,0,1484),(1485,0,877,'',2,0,1485),(1486,0,878,'',1,0,1486),(1487,0,879,'',1,0,1487),(1488,0,880,'',1,0,1488),(1489,0,880,'',2,0,1489),(1490,0,881,'',1,0,1490),(1491,0,882,'',1,0,1491),(1492,0,883,'',1,0,1492),(1493,0,883,'',2,0,1493),(1494,0,884,'',1,0,1494),(1495,0,885,'',1,0,1495),(1496,0,886,'',1,0,1496),(1497,0,886,'',2,0,1497),(1498,0,887,'',1,0,1498),(1499,0,888,'',1,0,1499),(1500,0,888,'',2,0,1500),(1501,0,889,'',1,0,1501),(1502,0,890,'',1,0,1502),(1503,0,891,'',1,0,1503),(1504,0,891,'',2,0,1504),(1505,0,892,'',1,0,1505),(1506,0,893,'',1,0,1506),(1507,0,894,'',1,0,1507),(1508,0,894,'',2,0,1508),(1509,0,895,'',1,0,1509),(1510,0,896,'',1,0,1510),(1511,0,897,'',1,0,1511),(1512,0,897,'',2,0,1512),(1513,0,898,'',1,0,1513),(1514,0,899,'',1,0,1514),(1515,0,899,'',2,0,1515),(1516,0,900,'',1,0,1516),(1517,0,900,'',2,0,1517),(1518,0,900,'',3,0,1518),(1519,0,901,'',1,0,1519),(1520,0,901,'',2,0,1520),(1521,0,901,'',3,0,1521),(1522,0,902,'',1,0,1522),(1523,0,902,'',2,0,1523),(1524,0,902,'',3,0,1524),(1525,0,903,'',1,0,1525),(1526,0,903,'',2,0,1526),(1527,0,903,'',3,0,1527),(1528,0,904,'',1,0,1528),(1529,0,904,'',2,0,1529),(1530,0,904,'',3,0,1530),(1531,0,905,'',1,0,1531),(1532,0,906,'',1,0,1532),(1533,0,906,'',2,0,1533),(1534,0,906,'',3,0,1534),(1535,0,907,'',1,0,1535),(1536,0,908,'',1,0,1536),(1537,0,909,'',1,0,1537),(1538,0,909,'',2,0,1538),(1539,0,909,'',3,0,1539),(1540,0,910,'',1,0,1540),(1541,0,911,'',1,0,1541),(1542,0,912,'',1,0,1542),(1543,0,912,'',2,0,1543),(1544,0,912,'',3,0,1544),(1545,0,913,'',1,0,1545),(1546,0,914,'',1,0,1546),(1547,0,915,'',1,0,1547),(1548,0,915,'',2,0,1548),(1549,0,915,'',3,0,1549),(1550,0,916,'',1,0,1550),(1551,0,917,'',1,0,1551),(1552,0,917,'',2,0,1552),(1553,0,917,'',3,0,1553),(1554,0,918,'',1,0,1554),(1555,0,918,'',2,0,1555),(1556,0,919,'',1,0,1556),(1557,0,920,'',1,0,1557),(1558,0,921,'',1,0,1558),(1559,0,921,'',2,0,1559),(1560,0,922,'',1,0,1560),(1561,0,923,'',1,0,1561),(1562,0,924,'',1,0,1562),(1563,0,924,'',2,0,1563),(1564,0,925,'',1,0,1564),(1565,0,926,'',1,0,1565),(1566,0,927,'',1,0,1566),(1567,0,927,'',2,0,1567),(1568,0,928,'',1,0,1568),(1569,0,929,'',1,0,1569),(1570,0,930,'',1,0,1570),(1571,0,930,'',2,0,1571),(1572,0,931,'',1,0,1572),(1573,0,932,'',1,0,1573),(1574,0,933,'',1,0,1574),(1575,0,933,'',2,0,1575),(1576,0,933,'',3,0,1576),(1577,0,934,'',1,0,1577),(1578,0,935,'',1,0,1578),(1579,0,936,'',1,0,1579),(1580,0,936,'',2,0,1580),(1581,0,936,'',3,0,1581),(1582,0,937,'',1,0,1582),(1583,0,938,'',1,0,1583),(1584,0,939,'',1,0,1584),(1585,0,939,'',2,0,1585),(1586,0,939,'',3,0,1586),(1587,0,940,'',1,0,1587),(1588,0,941,'',1,0,1588),(1589,0,942,'',1,0,1589),(1590,0,942,'',2,0,1590),(1591,0,942,'',3,0,1591),(1592,0,943,'',1,0,1592),(1593,0,943,'',2,0,1593),(1594,0,943,'',3,0,1594),(1595,0,944,'',1,0,1595),(1596,0,945,'',1,0,1596),(1597,0,945,'',2,0,1597),(1598,0,945,'',3,0,1598),(1599,0,946,'',1,0,1599),(1600,0,947,'',1,0,1600),(1601,0,948,'',1,0,1601),(1602,0,948,'',2,0,1602),(1603,0,948,'',3,0,1603),(1604,0,949,'',1,0,1604),(1605,0,950,'',1,0,1605),(1606,0,951,'',1,0,1606),(1607,0,951,'',2,0,1607),(1608,0,951,'',3,0,1608),(1609,0,952,'',1,0,1609),(1610,0,953,'',1,0,1610),(1611,0,954,'',1,0,1611),(1612,0,954,'',2,0,1612),(1613,0,954,'',3,0,1613),(1614,0,955,'',1,0,1614),(1615,0,956,'',1,0,1615),(1616,0,956,'',2,0,1616),(1617,0,956,'',3,0,1617),(1618,0,957,'',1,0,1618),(1619,0,957,'',2,0,1619),(1620,0,957,'',3,0,1620),(1621,0,958,'',1,0,1621),(1622,0,959,'',1,0,1622),(1623,0,960,'',1,0,1623),(1624,0,960,'',2,0,1624),(1625,0,960,'',3,0,1625),(1626,0,961,'',1,0,1626),(1627,0,962,'',1,0,1627),(1628,0,963,'',1,0,1628),(1629,0,963,'',2,0,1629),(1630,0,963,'',3,0,1630),(1631,0,964,'',1,0,1631),(1632,0,965,'',1,0,1632),(1633,0,966,'',1,0,1633),(1634,0,966,'',2,0,1634),(1635,0,966,'',3,0,1635),(1636,0,967,'',1,0,1636),(1637,0,968,'',1,0,1637),(1638,0,969,'',1,0,1638),(1639,0,969,'',2,0,1639),(1640,0,969,'',3,0,1640),(1641,0,970,'',1,0,1641),(1642,0,970,'',2,0,1642),(1643,0,971,'',1,0,1643),(1644,0,972,'',1,0,1644),(1645,0,973,'',1,0,1645),(1646,0,973,'',2,0,1646),(1647,0,974,'',1,0,1647),(1648,0,975,'',1,0,1648),(1649,0,976,'',1,0,1649),(1650,0,976,'',2,0,1650),(1651,0,977,'',1,0,1651),(1652,0,978,'',1,0,1652),(1653,0,979,'',1,0,1653),(1654,0,979,'',2,0,1654),(1655,0,980,'',1,0,1655),(1656,0,981,'',1,0,1656),(1657,0,982,'',1,0,1657),(1658,0,982,'',2,0,1658),(1659,0,983,'',1,0,1659),(1660,0,984,'',1,0,1660),(1661,0,984,'',2,0,1661),(1662,0,984,'',3,0,1662),(1663,0,985,'',1,0,1663),(1664,0,986,'',1,0,1664),(1665,0,987,'',1,0,1665),(1666,0,987,'',2,0,1666),(1667,0,987,'',3,0,1667),(1668,0,988,'',1,0,1668),(1669,0,989,'',1,0,1669),(1670,0,990,'',1,0,1670),(1671,0,990,'',2,0,1671),(1672,0,990,'',3,0,1672),(1673,0,991,'',1,0,1673),(1674,0,992,'',1,0,1674),(1675,0,993,'',1,0,1675),(1676,0,993,'',2,0,1676),(1677,0,993,'',3,0,1677),(1678,0,994,'',1,0,1678),(1679,0,995,'',1,0,1679),(1680,0,995,'',2,0,1680),(1681,0,995,'',3,0,1681),(1682,0,996,'',1,0,1682),(1683,0,996,'',2,0,1683),(1684,0,996,'',3,0,1684),(1685,0,997,'',1,0,1685),(1686,0,998,'',1,0,1686),(1687,0,999,'',1,0,1687),(1688,0,999,'',2,0,1688),(1689,0,999,'',3,0,1689),(1690,0,1000,'',1,0,1690),(1691,0,1001,'',1,0,1691),(1692,0,1002,'',1,0,1692),(1693,0,1002,'',2,0,1693),(1694,0,1002,'',3,0,1694),(1695,0,1003,'',1,0,1695),(1696,0,1004,'',1,0,1696),(1697,0,1005,'',1,0,1697),(1698,0,1005,'',2,0,1698),(1699,0,1005,'',3,0,1699),(1700,0,1006,'',1,0,1700),(1701,0,1007,'',1,0,1701),(1702,0,1008,'',1,0,1702),(1703,0,1008,'',2,0,1703),(1704,0,1008,'',3,0,1704),(1705,0,1009,'',1,0,1705),(1706,0,1010,'',1,0,1706),(1707,0,1010,'',2,0,1707),(1708,0,1011,'',1,0,1708),(1709,0,1012,'',1,0,1709),(1710,0,1013,'',1,0,1710),(1711,0,1013,'',2,0,1711),(1712,0,1014,'',1,0,1712),(1713,0,1015,'',1,0,1713),(1714,0,1016,'',1,0,1714),(1715,0,1016,'',2,0,1715),(1716,0,1017,'',1,0,1716),(1717,0,1018,'',1,0,1717),(1718,0,1019,'',1,0,1718),(1719,0,1019,'',2,0,1719),(1720,0,1020,'',1,0,1720),(1721,0,1021,'',1,0,1721),(1722,0,1021,'',2,0,1722),(1723,0,1022,'',1,0,1723),(1724,0,1023,'',1,0,1724),(1725,0,1024,'',1,0,1725),(1726,0,1024,'',2,0,1726),(1727,0,1025,'',1,0,1727),(1728,0,1026,'',1,0,1728),(1729,0,1027,'',1,0,1729),(1730,0,1027,'',2,0,1730),(1731,0,1028,'',1,0,1731),(1732,0,1029,'',1,0,1732),(1733,0,1030,'',1,0,1733),(1734,0,1030,'',2,0,1734),(1735,0,1031,'',1,0,1735),(1736,0,1032,'',1,0,1736),(1737,0,1033,'',1,0,1737),(1738,0,1033,'',2,0,1738),(1739,0,1034,'',1,0,1739),(1740,0,1034,'',2,0,1740),(1741,0,1035,'',1,0,1741),(1742,0,1035,'',2,0,1742),(1743,0,1035,'',3,0,1743),(1744,0,1036,'',1,0,1744),(1745,0,1037,'',1,0,1745),(1746,0,1038,'',1,0,1746),(1747,0,1038,'',2,0,1747),(1748,0,1038,'',3,0,1748),(1749,0,1039,'',1,0,1749),(1750,0,1040,'',1,0,1750),(1751,0,1041,'',1,0,1751),(1752,0,1041,'',2,0,1752),(1753,0,1041,'',3,0,1753),(1754,0,1042,'',1,0,1754),(1755,0,1043,'',1,0,1755),(1756,0,1044,'',1,0,1756),(1757,0,1044,'',2,0,1757),(1758,0,1044,'',3,0,1758),(1759,0,1045,'',1,0,1759),(1760,0,1046,'',1,0,1760),(1761,0,1047,'',1,0,1761),(1762,0,1047,'',2,0,1762),(1763,0,1047,'',3,0,1763),(1764,0,1048,'',1,0,1764),(1765,0,1049,'',1,0,1765),(1766,0,1050,'',1,0,1766),(1767,0,1050,'',2,0,1767),(1768,0,1050,'',3,0,1768),(1769,0,1051,'',1,0,1769),(1770,0,1051,'',2,0,1770),(1771,0,1051,'',3,0,1771),(1772,0,1052,'',1,0,1772),(1773,0,1053,'',1,0,1773),(1774,0,1054,'',1,0,1774),(1775,0,1054,'',2,0,1775),(1776,0,1054,'',3,0,1776),(1777,0,1055,'',1,0,1777),(1778,0,1056,'',1,0,1778),(1779,0,1057,'',1,0,1779),(1780,0,1057,'',2,0,1780),(1781,0,1057,'',3,0,1781),(1782,0,1058,'',1,0,1782),(1783,0,1059,'',1,0,1783),(1784,0,1060,'',1,0,1784),(1785,0,1060,'',2,0,1785),(1786,0,1060,'',3,0,1786),(1787,0,1061,'',1,0,1787),(1788,0,1062,'',1,0,1788),(1789,0,1063,'',1,0,1789),(1790,0,1063,'',2,0,1790),(1791,0,1063,'',3,0,1791),(1792,0,1064,'',1,0,1792),(1793,0,1065,'',1,0,1793),(1794,0,1066,'',1,0,1794),(1795,0,1066,'',2,0,1795),(1796,0,1066,'',3,0,1796),(1797,0,1067,'',1,0,1797),(1798,0,1068,'',1,0,1798),(1799,0,1069,'',1,0,1799),(1800,0,1069,'',2,0,1800),(1801,0,1069,'',3,0,1801),(1802,0,1070,'',1,0,1802),(1803,0,1071,'',1,0,1803),(1804,0,1072,'',1,0,1804),(1805,0,1072,'',2,0,1805),(1806,0,1072,'',3,0,1806),(1807,0,1073,'',1,0,1807),(1808,0,1074,'',1,0,1808),(1809,0,1075,'',1,0,1809),(1810,0,1075,'',2,0,1810),(1811,0,1075,'',3,0,1811),(1812,0,1076,'',1,0,1812),(1813,0,1077,'',1,0,1813),(1814,0,1078,'',1,0,1814),(1815,0,1078,'',2,0,1815),(1816,0,1078,'',3,0,1816),(1817,0,1079,'',1,0,1817),(1818,0,1080,'',1,0,1818),(1819,0,1081,'',1,0,1819),(1820,0,1081,'',2,0,1820),(1821,0,1081,'',3,0,1821),(1822,0,1082,'',1,0,1822),(1823,0,1082,'',2,0,1823),(1824,0,1082,'',3,0,1824),(1825,0,1083,'',1,0,1825),(1826,0,1083,'',2,0,1826),(1827,0,1083,'',3,0,1827),(1828,0,1084,'',1,0,1828),(1829,0,1085,'',1,0,1829),(1830,0,1086,'',1,0,1830),(1831,0,1086,'',2,0,1831),(1832,0,1086,'',3,0,1832),(1833,0,1087,'',1,0,1833),(1834,0,1088,'',1,0,1834),(1835,0,1089,'',1,0,1835),(1836,0,1089,'',2,0,1836),(1837,0,1089,'',3,0,1837),(1838,0,1090,'',1,0,1838),(1839,0,1091,'',1,0,1839),(1840,0,1092,'',1,0,1840),(1841,0,1092,'',2,0,1841),(1842,0,1092,'',3,0,1842),(1843,0,1093,'',1,0,1843),(1844,0,1094,'',1,0,1844),(1845,0,1095,'',1,0,1845),(1846,0,1095,'',2,0,1846),(1847,0,1095,'',3,0,1847),(1848,0,1096,'',1,0,1848),(1849,0,1097,'',1,0,1849),(1850,0,1098,'',1,0,1850),(1851,0,1098,'',2,0,1851),(1852,0,1098,'',3,0,1852),(1853,0,1099,'',1,0,1853),(1854,0,1100,'',1,0,1854),(1855,0,1101,'',1,0,1855),(1856,0,1101,'',2,0,1856),(1857,0,1102,'',1,0,1857),(1858,0,1103,'',1,0,1858),(1859,0,1104,'',1,0,1859),(1860,0,1104,'',2,0,1860),(1861,0,1105,'',1,0,1861),(1862,0,1106,'',1,0,1862),(1863,0,1107,'',1,0,1863),(1864,0,1107,'',2,0,1864),(1865,0,1108,'',1,0,1865),(1866,0,1109,'',1,0,1866),(1867,0,1110,'',1,0,1867),(1868,0,1110,'',2,0,1868),(1869,0,1111,'',1,0,1869),(1870,0,1112,'',1,0,1870),(1871,0,1113,'',1,0,1871),(1872,0,1113,'',2,0,1872),(1873,0,1114,'',1,0,1873),(1874,0,1114,'',2,0,1874),(1875,0,1115,'',1,0,1875),(1876,0,1115,'',2,0,1876),(1877,0,1115,'',3,0,1877),(1878,0,1116,'',1,0,1878),(1879,0,1116,'',2,0,1879),(1880,0,1116,'',3,0,1880),(1881,0,1117,'',1,0,1881),(1882,0,1117,'',2,0,1882),(1883,0,1117,'',3,0,1883),(1884,0,1118,'',1,0,1884),(1885,0,1118,'',2,0,1885),(1886,0,1118,'',3,0,1886),(1887,0,1119,'',1,0,1887),(1888,0,1119,'',2,0,1888),(1889,0,1119,'',3,0,1889),(1890,0,1120,'',1,0,1890),(1891,0,1120,'',2,0,1891),(1892,0,1120,'',3,0,1892),(1893,0,1121,'',1,0,1893),(1894,0,1121,'',2,0,1894),(1895,0,1121,'',3,0,1895),(1896,0,1122,'',1,0,1896),(1897,0,1123,'',1,0,1897),(1898,0,1124,'',1,0,1898),(1899,0,1124,'',2,0,1899),(1900,0,1124,'',3,0,1900),(1901,0,1125,'',1,0,1901),(1902,0,1126,'',1,0,1902),(1903,0,1127,'',1,0,1903),(1904,0,1127,'',2,0,1904),(1905,0,1127,'',3,0,1905),(1906,0,1128,'',1,0,1906),(1907,0,1129,'',1,0,1907),(1908,0,1130,'',1,0,1908),(1909,0,1130,'',2,0,1909),(1910,0,1130,'',3,0,1910),(1911,0,1131,'',1,0,1911),(1912,0,1132,'',1,0,1912),(1913,0,1133,'',1,0,1913),(1914,0,1133,'',2,0,1914),(1915,0,1133,'',3,0,1915),(1916,0,1134,'',1,0,1916),(1917,0,1135,'',1,0,1917),(1918,0,1136,'',1,0,1918),(1919,0,1136,'',2,0,1919),(1920,0,1136,'',3,0,1920),(1921,0,1137,'',1,0,1921),(1922,0,1138,'',1,0,1922),(1923,0,1139,'',1,0,1923),(1924,0,1139,'',2,0,1924),(1925,0,1139,'',3,0,1925),(1926,0,1139,'',4,0,1926),(1927,0,1140,'',1,0,1927),(1928,0,1141,'',1,0,1928),(1929,0,1142,'',1,0,1929),(1930,0,1142,'',2,0,1930),(1931,0,1142,'',3,0,1931),(1932,0,1142,'',4,0,1932),(1933,0,1143,'',1,0,1933),(1934,0,1144,'',1,0,1934),(1935,0,1145,'',1,0,1935),(1936,0,1145,'',2,0,1936),(1937,0,1145,'',3,0,1937),(1938,0,1145,'',4,0,1938),(1939,0,1146,'',1,0,1939),(1940,0,1147,'',1,0,1940),(1941,0,1148,'',1,0,1941),(1942,0,1148,'',2,0,1942),(1943,0,1148,'',3,0,1943),(1944,0,1148,'',4,0,1944),(1945,0,1149,'',1,0,1945),(1946,0,1150,'',1,0,1946),(1947,0,1151,'',1,0,1947),(1948,0,1151,'',2,0,1948),(1949,0,1151,'',3,0,1949),(1950,0,1151,'',4,0,1950),(1951,0,1152,'',1,0,1951),(1952,0,1152,'',2,0,1952),(1953,0,1152,'',3,0,1953),(1954,0,1152,'',4,0,1954),(1955,0,1153,'',1,0,1955),(1956,0,1154,'',1,0,1956),(1957,0,1154,'',2,0,1957),(1958,0,1154,'',3,0,1958),(1959,0,1155,'',1,0,1959),(1960,0,1156,'',1,0,1960),(1961,0,1157,'',1,0,1961),(1962,0,1157,'',2,0,1962),(1963,0,1157,'',3,0,1963),(1964,0,1158,'',1,0,1964),(1965,0,1159,'',1,0,1965),(1966,0,1160,'',1,0,1966),(1967,0,1160,'',2,0,1967),(1968,0,1160,'',3,0,1968),(1969,0,1161,'',1,0,1969),(1970,0,1162,'',1,0,1970),(1971,0,1163,'',1,0,1971),(1972,0,1163,'',2,0,1972),(1973,0,1163,'',3,0,1973),(1974,0,1164,'',1,0,1974),(1975,0,1165,'',1,0,1975),(1976,0,1166,'',1,0,1976),(1977,0,1166,'',2,0,1977),(1978,0,1166,'',3,0,1978),(1979,0,1167,'',1,0,1979),(1980,0,1168,'',1,0,1980),(1981,0,1168,'',2,0,1981),(1982,0,1168,'',3,0,1982),(1983,0,1169,'',1,0,1983),(1984,0,1170,'',1,0,1984),(1985,0,1170,'',2,0,1985),(1986,0,1170,'',3,0,1986),(1987,0,1171,'',1,0,1987),(1988,0,1172,'',1,0,1988),(1989,0,1173,'',1,0,1989),(1990,0,1173,'',2,0,1990),(1991,0,1173,'',3,0,1991),(1992,0,1174,'',1,0,1992),(1993,0,1175,'',1,0,1993),(1994,0,1176,'',1,0,1994),(1995,0,1176,'',2,0,1995),(1996,0,1176,'',3,0,1996),(1997,0,1177,'',1,0,1997),(1998,0,1178,'',1,0,1998),(1999,0,1179,'',1,0,1999),(2000,0,1179,'',2,0,2000),(2001,0,1179,'',3,0,2001),(2002,0,1180,'',1,0,2002),(2003,0,1181,'',1,0,2003),(2004,0,1182,'',1,0,2004),(2005,0,1182,'',2,0,2005),(2006,0,1182,'',3,0,2006),(2007,0,1183,'',1,0,2007),(2008,0,1184,'',1,0,2008),(2009,0,1184,'',2,0,2009),(2010,0,1184,'',3,0,2010),(2011,0,1185,'',1,0,2011),(2012,0,1185,'',2,0,2012),(2013,0,1186,'',1,0,2013),(2014,0,1187,'',1,0,2014),(2015,0,1188,'',1,0,2015),(2016,0,1188,'',2,0,2016),(2017,0,1189,'',1,0,2017),(2018,0,1190,'',1,0,2018),(2019,0,1191,'',1,0,2019),(2020,0,1191,'',2,0,2020),(2021,0,1192,'',1,0,2021),(2022,0,1193,'',1,0,2022),(2023,0,1194,'',1,0,2023),(2024,0,1194,'',2,0,2024),(2025,0,1195,'',1,0,2025),(2026,0,1196,'',1,0,2026),(2027,0,1197,'',1,0,2027),(2028,0,1197,'',2,0,2028),(2029,0,1198,'',1,0,2029),(2030,0,1199,'',1,0,2030),(2031,0,1200,'',1,0,2031),(2032,0,1200,'',2,0,2032),(2033,0,1201,'',1,0,2033),(2034,0,1201,'',2,0,2034),(2035,0,1202,'',1,0,2035),(2036,0,1203,'',1,0,2036),(2037,0,1204,'',1,0,2037),(2038,0,1204,'',2,0,2038),(2039,0,1205,'',1,0,2039),(2040,0,1206,'',1,0,2040),(2041,0,1207,'',1,0,2041),(2042,0,1207,'',2,0,2042),(2043,0,1208,'',1,0,2043),(2044,0,1209,'',1,0,2044),(2045,0,1210,'',1,0,2045),(2046,0,1210,'',2,0,2046),(2047,0,1211,'',1,0,2047),(2048,0,1212,'',1,0,2048),(2049,0,1213,'',1,0,2049),(2050,0,1213,'',2,0,2050),(2051,0,1214,'',1,0,2051),(2052,0,1215,'',1,0,2052),(2053,0,1216,'',1,0,2053),(2054,0,1216,'',2,0,2054),(2055,0,1217,'',1,0,2055),(2056,0,1218,'',1,0,2056),(2057,0,1218,'',2,0,2057),(2058,0,1218,'',3,0,2058),(2059,0,1219,'',1,0,2059),(2060,0,1220,'',1,0,2060),(2061,0,1221,'',1,0,2061),(2062,0,1221,'',2,0,2062),(2063,0,1221,'',3,0,2063),(2064,0,1222,'',1,0,2064),(2065,0,1223,'',1,0,2065),(2066,0,1224,'',1,0,2066),(2067,0,1224,'',2,0,2067),(2068,0,1224,'',3,0,2068),(2069,0,1225,'',1,0,2069),(2070,0,1226,'',1,0,2070),(2071,0,1226,'',2,0,2071),(2072,0,1226,'',3,0,2072),(2073,0,1227,'',1,0,2073),(2074,0,1228,'',1,0,2074),(2075,0,1229,'',1,0,2075),(2076,0,1229,'',2,0,2076),(2077,0,1229,'',3,0,2077),(2078,0,1230,'',1,0,2078),(2079,0,1231,'',1,0,2079),(2080,0,1232,'',1,0,2080),(2081,0,1232,'',2,0,2081),(2082,0,1232,'',3,0,2082),(2083,0,1233,'',1,0,2083),(2084,0,1234,'',1,0,2084),(2085,0,1235,'',1,0,2085),(2086,0,1235,'',2,0,2086),(2087,0,1235,'',3,0,2087),(2088,0,1236,'',1,0,2088),(2089,0,1237,'',1,0,2089),(2090,0,1238,'',1,0,2090),(2091,0,1238,'',2,0,2091),(2092,0,1238,'',3,0,2092),(2093,0,1239,'',1,0,2093),(2094,0,1240,'',1,0,2094),(2095,0,1241,'',1,0,2095),(2096,0,1241,'',2,0,2096),(2097,0,1241,'',3,0,2097),(2098,0,1242,'',1,0,2098),(2099,0,1242,'',2,0,2099),(2100,0,1242,'',3,0,2100),(2101,0,1243,'',1,0,2101),(2102,0,1244,'',1,0,2102),(2103,0,1245,'',1,0,2103),(2104,0,1245,'',2,0,2104),(2105,0,1245,'',3,0,2105),(2106,0,1246,'',1,0,2106),(2107,0,1247,'',1,0,2107),(2108,0,1248,'',1,0,2108),(2109,0,1248,'',2,0,2109),(2110,0,1248,'',3,0,2110),(2111,0,1249,'',1,0,2111),(2112,0,1250,'',1,0,2112),(2113,0,1251,'',1,0,2113),(2114,0,1251,'',2,0,2114),(2115,0,1251,'',3,0,2115),(2116,0,1252,'',1,0,2116),(2117,0,1253,'',1,0,2117),(2118,0,1254,'',1,0,2118),(2119,0,1254,'',2,0,2119),(2120,0,1254,'',3,0,2120),(2121,0,1255,'',1,0,2121),(2122,0,1256,'',1,0,2122),(2123,0,1257,'',1,0,2123),(2124,0,1257,'',2,0,2124),(2125,0,1257,'',3,0,2125),(2126,0,1258,'',1,0,2126),(2127,0,1258,'',2,0,2127),(2128,0,1258,'',3,0,2128),(2129,0,1259,'',1,0,2129),(2130,0,1260,'',1,0,2130),(2131,0,1261,'',1,0,2131),(2132,0,1261,'',2,0,2132),(2133,0,1261,'',3,0,2133),(2134,0,1261,'',4,0,2134),(2135,0,1262,'',1,0,2135),(2136,0,1263,'',1,0,2136),(2137,0,1264,'',1,0,2137),(2138,0,1264,'',2,0,2138),(2139,0,1264,'',3,0,2139),(2140,0,1264,'',4,0,2140),(2141,0,1265,'',1,0,2141),(2142,0,1266,'',1,0,2142),(2143,0,1267,'',1,0,2143),(2144,0,1267,'',2,0,2144),(2145,0,1267,'',3,0,2145),(2146,0,1267,'',4,0,2146),(2147,0,1268,'',1,0,2147),(2148,0,1269,'',1,0,2148),(2149,0,1270,'',1,0,2149),(2150,0,1270,'',2,0,2150),(2151,0,1270,'',3,0,2151),(2152,0,1270,'',4,0,2152),(2153,0,1271,'',1,0,2153),(2154,0,1272,'',1,0,2154),(2155,0,1273,'',1,0,2155),(2156,0,1273,'',2,0,2156),(2157,0,1273,'',3,0,2157),(2158,0,1273,'',4,0,2158),(2159,0,1274,'',1,0,2159),(2160,0,1274,'',2,0,2160),(2161,0,1274,'',3,0,2161),(2162,0,1274,'',4,0,2162),(2163,0,1275,'',1,0,2163),(2164,0,1275,'',2,0,2164),(2165,0,1275,'',3,0,2165),(2166,0,1276,'',1,0,2166),(2167,0,1277,'',1,0,2167),(2168,0,1278,'',1,0,2168),(2169,0,1278,'',2,0,2169),(2170,0,1278,'',3,0,2170),(2171,0,1279,'',1,0,2171),(2172,0,1280,'',1,0,2172),(2173,0,1281,'',1,0,2173),(2174,0,1281,'',2,0,2174),(2175,0,1281,'',3,0,2175),(2176,0,1282,'',1,0,2176),(2177,0,1283,'',1,0,2177),(2178,0,1284,'',1,0,2178),(2179,0,1284,'',2,0,2179),(2180,0,1284,'',3,0,2180),(2181,0,1285,'',1,0,2181),(2182,0,1286,'',1,0,2182),(2183,0,1287,'',1,0,2183),(2184,0,1287,'',2,0,2184),(2185,0,1287,'',3,0,2185),(2186,0,1288,'',1,0,2186),(2187,0,1289,'',1,0,2187),(2188,0,1290,'',1,0,2188),(2189,0,1290,'',2,0,2189),(2190,0,1290,'',3,0,2190),(2191,0,1291,'',1,0,2191),(2192,0,1292,'',1,0,2192),(2193,0,1292,'',2,0,2193),(2194,0,1292,'',3,0,2194),(2195,0,1293,'',1,0,2195),(2196,0,1294,'',1,0,2196),(2197,0,1295,'',1,0,2197),(2198,0,1295,'',2,0,2198),(2199,0,1295,'',3,0,2199),(2200,0,1296,'',1,0,2200),(2201,0,1297,'',1,0,2201),(2202,0,1298,'',1,0,2202),(2203,0,1298,'',2,0,2203),(2204,0,1298,'',3,0,2204),(2205,0,1299,'',1,0,2205),(2206,0,1300,'',1,0,2206),(2207,0,1301,'',1,0,2207),(2208,0,1301,'',2,0,2208),(2209,0,1301,'',3,0,2209),(2210,0,1302,'',1,0,2210),(2211,0,1303,'',1,0,2211),(2212,0,1304,'',1,0,2212),(2213,0,1304,'',2,0,2213),(2214,0,1304,'',3,0,2214),(2215,0,1305,'',1,0,2215),(2216,0,1306,'',1,0,2216),(2217,0,1306,'',2,0,2217),(2218,0,1306,'',3,0,2218),(2219,0,1307,'',1,0,2219),(2220,0,1307,'',2,0,2220),(2221,0,1307,'',3,0,2221),(2222,0,1307,'',4,0,2222),(2223,0,1308,'',1,0,2223),(2224,0,1309,'',1,0,2224),(2225,0,1310,'',1,0,2225),(2226,0,1310,'',2,0,2226),(2227,0,1310,'',3,0,2227),(2228,0,1310,'',4,0,2228),(2229,0,1311,'',1,0,2229),(2230,0,1312,'',1,0,2230),(2231,0,1313,'',1,0,2231),(2232,0,1313,'',2,0,2232),(2233,0,1313,'',3,0,2233),(2234,0,1313,'',4,0,2234),(2235,0,1314,'',1,0,2235),(2236,0,1315,'',1,0,2236),(2237,0,1316,'',1,0,2237),(2238,0,1316,'',2,0,2238),(2239,0,1316,'',3,0,2239),(2240,0,1316,'',4,0,2240),(2241,0,1317,'',1,0,2241),(2242,0,1318,'',1,0,2242),(2243,0,1319,'',1,0,2243),(2244,0,1319,'',2,0,2244),(2245,0,1319,'',3,0,2245),(2246,0,1319,'',4,0,2246),(2247,0,1320,'',1,0,2247),(2248,0,1321,'',1,0,2248),(2249,0,1322,'',1,0,2249),(2250,0,1322,'',2,0,2250),(2251,0,1322,'',3,0,2251),(2252,0,1322,'',4,0,2252),(2253,0,1323,'',1,0,2253),(2254,0,1324,'',1,0,2254),(2255,0,1325,'',1,0,2255),(2256,0,1325,'',2,0,2256),(2257,0,1325,'',3,0,2257),(2258,0,1326,'',1,0,2258),(2259,0,1327,'',1,0,2259),(2260,0,1328,'',1,0,2260),(2261,0,1328,'',2,0,2261),(2262,0,1328,'',3,0,2262),(2263,0,1329,'',1,0,2263),(2264,0,1330,'',1,0,2264),(2265,0,1331,'',1,0,2265),(2266,0,1331,'',2,0,2266),(2267,0,1331,'',3,0,2267),(2268,0,1332,'',1,0,2268),(2269,0,1333,'',1,0,2269),(2270,0,1334,'',1,0,2270),(2271,0,1334,'',2,0,2271),(2272,0,1334,'',3,0,2272),(2273,0,1335,'',1,0,2273),(2274,0,1336,'',1,0,2274),(2275,0,1337,'',1,0,2275),(2276,0,1337,'',2,0,2276),(2277,0,1337,'',3,0,2277),(2278,0,1338,'',1,0,2278),(2279,0,1338,'',2,0,2279),(2280,0,1338,'',3,0,2280),(2281,0,1339,'',1,0,2281),(2282,0,1340,'',1,0,2282),(2283,0,1341,'',1,0,2283),(2284,0,1341,'',2,0,2284),(2285,0,1341,'',3,0,2285),(2286,0,1342,'',1,0,2286),(2287,0,1343,'',1,0,2287),(2288,0,1344,'',1,0,2288),(2289,0,1344,'',2,0,2289),(2290,0,1344,'',3,0,2290),(2291,0,1345,'',1,0,2291),(2292,0,1346,'',1,0,2292),(2293,0,1347,'',1,0,2293),(2294,0,1347,'',2,0,2294),(2295,0,1347,'',3,0,2295),(2296,0,1348,'',1,0,2296),(2297,0,1349,'',1,0,2297),(2298,0,1350,'',1,0,2298),(2299,0,1350,'',2,0,2299),(2300,0,1350,'',3,0,2300),(2301,0,1351,'',1,0,2301),(2302,0,1352,'',1,0,2302),(2303,0,1353,'',1,0,2303),(2304,0,1353,'',2,0,2304),(2305,0,1353,'',3,0,2305),(2306,0,1354,'',1,0,2306),(2307,0,1354,'',2,0,2307),(2308,0,1354,'',3,0,2308),(2309,0,1355,'',1,0,2309),(2310,0,1356,'',1,0,2310),(2311,0,1356,'',2,0,2311),(2312,0,1356,'',3,0,2312),(2313,0,1357,'',1,0,2313),(2314,0,1358,'',1,0,2314),(2315,0,1359,'',1,0,2315),(2316,0,1359,'',2,0,2316),(2317,0,1359,'',3,0,2317),(2318,0,1360,'',1,0,2318),(2319,0,1361,'',1,0,2319),(2320,0,1362,'',1,0,2320),(2321,0,1362,'',2,0,2321),(2322,0,1362,'',3,0,2322),(2323,0,1363,'',1,0,2323),(2324,0,1364,'',1,0,2324),(2325,0,1365,'',1,0,2325),(2326,0,1365,'',2,0,2326),(2327,0,1365,'',3,0,2327),(2328,0,1366,'',1,0,2328),(2329,0,1367,'',1,0,2329),(2330,0,1368,'',1,0,2330),(2331,0,1368,'',2,0,2331),(2332,0,1368,'',3,0,2332),(2333,0,1369,'',1,0,2333),(2334,0,1370,'',1,0,2334),(2335,0,1370,'',2,0,2335),(2336,0,1370,'',3,0,2336),(2337,0,1371,'',1,0,2337),(2338,0,1372,'',1,0,2338),(2339,0,1373,'',1,0,2339),(2340,0,1373,'',2,0,2340),(2341,0,1373,'',3,0,2341),(2342,0,1374,'',1,0,2342),(2343,0,1375,'',1,0,2343),(2344,0,1376,'',1,0,2344),(2345,0,1376,'',2,0,2345),(2346,0,1376,'',3,0,2346),(2347,0,1377,'',1,0,2347),(2348,0,1378,'',1,0,2348),(2349,0,1379,'',1,0,2349),(2350,0,1379,'',2,0,2350),(2351,0,1379,'',3,0,2351),(2352,0,1380,'',1,0,2352),(2353,0,1381,'',1,0,2353),(2354,0,1382,'',1,0,2354),(2355,0,1382,'',2,0,2355),(2356,0,1382,'',3,0,2356),(2357,0,1383,'',1,0,2357),(2358,0,1384,'',1,0,2358),(2359,0,1385,'',1,0,2359),(2360,0,1385,'',2,0,2360),(2361,0,1385,'',3,0,2361),(2362,0,1386,'',1,0,2362),(2363,0,1386,'',2,0,2363),(2364,0,1386,'',3,0,2364),(2365,0,1387,'',1,0,2365),(2366,0,1388,'',1,0,2366),(2367,0,1388,'',2,0,2367),(2368,0,1388,'',3,0,2368),(2369,0,1389,'',1,0,2369),(2370,0,1390,'',1,0,2370),(2371,0,1391,'',1,0,2371),(2372,0,1391,'',2,0,2372),(2373,0,1391,'',3,0,2373),(2374,0,1392,'',1,0,2374),(2375,0,1393,'',1,0,2375),(2376,0,1394,'',1,0,2376),(2377,0,1394,'',2,0,2377),(2378,0,1394,'',3,0,2378),(2379,0,1395,'',1,0,2379),(2380,0,1396,'',1,0,2380),(2381,0,1397,'',1,0,2381),(2382,0,1397,'',2,0,2382),(2383,0,1397,'',3,0,2383),(2384,0,1398,'',1,0,2384),(2385,0,1399,'',1,0,2385),(2386,0,1400,'',1,0,2386),(2387,0,1400,'',2,0,2387),(2388,0,1400,'',3,0,2388),(2389,0,1401,'',1,0,2389),(2390,0,1402,'',1,0,2390),(2391,0,1402,'',2,0,2391),(2392,0,1402,'',3,0,2392),(2393,0,1403,'',1,0,2393),(2394,0,1404,'',1,0,2394),(2395,0,1404,'',2,0,2395),(2396,0,1405,'',1,0,2396),(2397,0,1406,'',1,0,2397),(2398,0,1407,'',1,0,2398),(2399,0,1407,'',2,0,2399),(2400,0,1408,'',1,0,2400),(2401,0,1409,'',1,0,2401),(2402,0,1410,'',1,0,2402),(2403,0,1410,'',2,0,2403),(2404,0,1411,'',1,0,2404),(2405,0,1412,'',1,0,2405),(2406,0,1413,'',1,0,2406),(2407,0,1413,'',2,0,2407),(2408,0,1414,'',1,0,2408),(2409,0,1415,'',1,0,2409),(2410,0,1416,'',1,0,2410),(2411,0,1416,'',2,0,2411),(2412,0,1417,'',1,0,2412),(2413,0,1418,'',1,0,2413),(2414,0,1418,'',2,0,2414),(2415,0,1419,'',1,0,2415),(2416,0,1420,'',1,0,2416),(2417,0,1421,'',1,0,2417),(2418,0,1421,'',2,0,2418),(2419,0,1421,'',3,0,2419),(2420,0,1422,'',1,0,2420),(2421,0,1423,'',1,0,2421),(2422,0,1424,'',1,0,2422),(2423,0,1424,'',2,0,2423),(2424,0,1424,'',3,0,2424),(2425,0,1425,'',1,0,2425),(2426,0,1426,'',1,0,2426),(2427,0,1427,'',1,0,2427),(2428,0,1427,'',2,0,2428),(2429,0,1427,'',3,0,2429),(2430,0,1428,'',1,0,2430),(2431,0,1429,'',1,0,2431),(2432,0,1430,'',1,0,2432),(2433,0,1430,'',2,0,2433),(2434,0,1430,'',3,0,2434),(2435,0,1431,'',1,0,2435),(2436,0,1432,'',1,0,2436),(2437,0,1433,'',1,0,2437),(2438,0,1433,'',2,0,2438),(2439,0,1433,'',3,0,2439),(2440,0,1434,'',1,0,2440),(2441,0,1434,'',2,0,2441),(2442,0,1434,'',3,0,2442),(2443,0,1435,'',1,0,2443),(2444,0,1436,'',1,0,2444),(2445,0,1436,'',2,0,2445),(2446,0,1437,'',1,0,2446),(2447,0,1438,'',1,0,2447),(2448,0,1439,'',1,0,2448),(2449,0,1439,'',2,0,2449),(2450,0,1440,'',1,0,2450),(2451,0,1441,'',1,0,2451),(2452,0,1442,'',1,0,2452),(2453,0,1442,'',2,0,2453),(2454,0,1443,'',1,0,2454),(2455,0,1444,'',1,0,2455),(2456,0,1445,'',1,0,2456),(2457,0,1445,'',2,0,2457),(2458,0,1446,'',1,0,2458),(2459,0,1447,'',1,0,2459),(2460,0,1448,'',1,0,2460),(2461,0,1448,'',2,0,2461),(2462,0,1449,'',1,0,2462),(2463,0,1450,'',1,0,2463),(2464,0,1450,'',2,0,2464),(2465,0,1451,'',1,0,2465),(2466,0,1452,'',1,0,2466),(2467,0,1452,'',2,0,2467),(2468,0,1453,'',1,0,2468),(2469,0,1454,'',1,0,2469),(2470,0,1455,'',1,0,2470),(2471,0,1455,'',2,0,2471),(2472,0,1456,'',1,0,2472),(2473,0,1457,'',1,0,2473),(2474,0,1458,'',1,0,2474),(2475,0,1458,'',2,0,2475),(2476,0,1459,'',1,0,2476),(2477,0,1460,'',1,0,2477),(2478,0,1461,'',1,0,2478),(2479,0,1461,'',2,0,2479),(2480,0,1462,'',1,0,2480),(2481,0,1463,'',1,0,2481),(2482,0,1464,'',1,0,2482),(2483,0,1464,'',2,0,2483),(2484,0,1465,'',1,0,2484),(2485,0,1466,'',1,0,2485),(2486,0,1466,'',2,0,2486),(2487,0,1467,'',1,0,2487),(2488,0,1467,'',2,0,2488),(2489,0,1467,'',3,0,2489),(2490,0,1468,'',1,0,2490),(2491,0,1469,'',1,0,2491),(2492,0,1470,'',1,0,2492),(2493,0,1470,'',2,0,2493),(2494,0,1470,'',3,0,2494),(2495,0,1471,'',1,0,2495),(2496,0,1472,'',1,0,2496),(2497,0,1473,'',1,0,2497),(2498,0,1473,'',2,0,2498),(2499,0,1473,'',3,0,2499),(2500,0,1474,'',1,0,2500),(2501,0,1475,'',1,0,2501),(2502,0,1476,'',1,0,2502),(2503,0,1476,'',2,0,2503),(2504,0,1476,'',3,0,2504),(2505,0,1477,'',1,0,2505),(2506,0,1478,'',1,0,2506),(2507,0,1479,'',1,0,2507),(2508,0,1479,'',2,0,2508),(2509,0,1479,'',3,0,2509),(2510,0,1480,'',1,0,2510),(2511,0,1481,'',1,0,2511),(2512,0,1482,'',1,0,2512),(2513,0,1482,'',2,0,2513),(2514,0,1482,'',3,0,2514),(2515,0,1483,'',1,0,2515),(2516,0,1484,'',1,0,2516),(2517,0,1484,'',2,0,2517),(2518,0,1485,'',1,0,2518),(2519,0,1486,'',1,0,2519),(2520,0,1487,'',1,0,2520),(2521,0,1487,'',2,0,2521),(2522,0,1488,'',1,0,2522),(2523,0,1489,'',1,0,2523),(2524,0,1490,'',1,0,2524),(2525,0,1490,'',2,0,2525),(2526,0,1491,'',1,0,2526),(2527,0,1492,'',1,0,2527),(2528,0,1493,'',1,0,2528),(2529,0,1493,'',2,0,2529),(2530,0,1494,'',1,0,2530),(2531,0,1495,'',1,0,2531),(2532,0,1496,'',1,0,2532),(2533,0,1496,'',2,0,2533),(2534,0,1497,'',1,0,2534),(2535,0,1498,'',1,0,2535),(2536,0,1498,'',2,0,2536),(2537,0,1499,'',1,0,2537),(2538,0,1499,'',2,0,2538),(2539,0,1500,'',1,0,2539),(2540,0,1501,'',1,0,2540),(2541,0,1502,'',1,0,2541),(2542,0,1502,'',2,0,2542),(2543,0,1503,'',1,0,2543),(2544,0,1504,'',1,0,2544),(2545,0,1505,'',1,0,2545),(2546,0,1505,'',2,0,2546),(2547,0,1506,'',1,0,2547),(2548,0,1507,'',1,0,2548),(2549,0,1508,'',1,0,2549),(2550,0,1508,'',2,0,2550),(2551,0,1509,'',1,0,2551),(2552,0,1510,'',1,0,2552),(2553,0,1511,'',1,0,2553),(2554,0,1511,'',2,0,2554),(2555,0,1512,'',1,0,2555),(2556,0,1513,'',1,0,2556),(2557,0,1514,'',1,0,2557),(2558,0,1514,'',2,0,2558),(2559,0,1515,'',1,0,2559),(2560,0,1516,'',1,0,2560),(2561,0,1516,'',2,0,2561),(2562,0,1517,'',1,0,2562),(2563,0,1518,'',1,0,2563),(2564,0,1519,'',1,0,2564),(2565,0,1519,'',2,0,2565),(2566,0,1520,'',1,0,2566),(2567,0,1521,'',1,0,2567),(2568,0,1522,'',1,0,2568),(2569,0,1522,'',2,0,2569),(2570,0,1523,'',1,0,2570),(2571,0,1524,'',1,0,2571),(2572,0,1525,'',1,0,2572),(2573,0,1525,'',2,0,2573),(2574,0,1526,'',1,0,2574),(2575,0,1527,'',1,0,2575),(2576,0,1528,'',1,0,2576),(2577,0,1528,'',2,0,2577),(2578,0,1529,'',1,0,2578),(2579,0,1530,'',1,0,2579),(2580,0,1530,'',2,0,2580),(2581,0,1531,'',1,0,2581),(2582,0,1532,'',1,0,2582),(2583,0,1533,'',1,0,2583),(2584,0,1533,'',2,0,2584),(2585,0,1534,'',1,0,2585),(2586,0,1535,'',1,0,2586),(2587,0,1536,'',1,0,2587),(2588,0,1536,'',2,0,2588),(2589,0,1537,'',1,0,2589),(2590,0,1538,'',1,0,2590),(2591,0,1539,'',1,0,2591),(2592,0,1539,'',2,0,2592),(2593,0,1540,'',1,0,2593),(2594,0,1541,'',1,0,2594),(2595,0,1542,'',1,0,2595),(2596,0,1542,'',2,0,2596),(2597,0,1543,'',1,0,2597),(2598,0,1544,'',1,0,2598),(2599,0,1545,'',1,0,2599),(2600,0,1545,'',2,0,2600),(2601,0,1546,'',1,0,2601),(2602,0,1546,'',2,0,2602),(2603,0,1547,'',1,0,2603),(2604,0,1548,'',1,0,2604),(2605,0,1548,'',2,0,2605),(2606,0,1549,'',1,0,2606),(2607,0,1550,'',1,0,2607),(2608,0,1551,'',1,0,2608),(2609,0,1551,'',2,0,2609),(2610,0,1552,'',1,0,2610),(2611,0,1553,'',1,0,2611),(2612,0,1554,'',1,0,2612),(2613,0,1554,'',2,0,2613),(2614,0,1555,'',1,0,2614),(2615,0,1556,'',1,0,2615),(2616,0,1557,'',1,0,2616),(2617,0,1557,'',2,0,2617),(2618,0,1558,'',1,0,2618),(2619,0,1559,'',1,0,2619),(2620,0,1560,'',1,0,2620),(2621,0,1560,'',2,0,2621),(2622,0,1561,'',1,0,2622),(2623,0,1562,'',1,0,2623),(2624,0,1562,'',2,0,2624),(2625,0,1563,'',1,0,2625),(2626,0,1563,'',2,0,2626),(2627,0,1564,'',1,0,2627),(2628,0,1565,'',1,0,2628),(2629,0,1566,'',1,0,2629),(2630,0,1566,'',2,0,2630),(2631,0,1567,'',1,0,2631),(2632,0,1568,'',1,0,2632),(2633,0,1569,'',1,0,2633),(2634,0,1569,'',2,0,2634),(2635,0,1570,'',1,0,2635),(2636,0,1571,'',1,0,2636),(2637,0,1572,'',1,0,2637),(2638,0,1572,'',2,0,2638),(2639,0,1573,'',1,0,2639),(2640,0,1574,'',1,0,2640),(2641,0,1575,'',1,0,2641),(2642,0,1575,'',2,0,2642),(2643,0,1576,'',1,0,2643),(2644,0,1577,'',1,0,2644),(2645,0,1578,'',1,0,2645),(2646,0,1578,'',2,0,2646),(2647,0,1579,'',1,0,2647),(2648,0,1579,'',2,0,2648),(2649,0,1579,'',3,0,2649),(2650,0,1580,'',1,0,2650),(2651,0,1581,'',1,0,2651),(2652,0,1582,'',1,0,2652),(2653,0,1582,'',2,0,2653),(2654,0,1582,'',3,0,2654),(2655,0,1583,'',1,0,2655),(2656,0,1584,'',1,0,2656),(2657,0,1585,'',1,0,2657),(2658,0,1585,'',2,0,2658),(2659,0,1585,'',3,0,2659),(2660,0,1586,'',1,0,2660),(2661,0,1587,'',1,0,2661),(2662,0,1588,'',1,0,2662),(2663,0,1588,'',2,0,2663),(2664,0,1588,'',3,0,2664),(2665,0,1589,'',1,0,2665),(2666,0,1590,'',1,0,2666),(2667,0,1591,'',1,0,2667),(2668,0,1591,'',2,0,2668),(2669,0,1591,'',3,0,2669),(2670,0,1592,'',1,0,2670),(2671,0,1593,'',1,0,2671),(2672,0,1594,'',1,0,2672),(2673,0,1594,'',2,0,2673),(2674,0,1594,'',3,0,2674),(2675,0,1595,'',1,0,2675),(2676,0,1595,'',2,0,2676),(2677,0,1596,'',1,0,2677),(2678,0,1596,'',2,0,2678),(2679,0,1596,'',3,0,2679),(2680,0,1597,'',1,0,2680),(2681,0,1598,'',1,0,2681),(2682,0,1598,'',2,0,2682),(2683,0,1599,'',1,0,2683),(2684,0,1599,'',2,0,2684),(2685,0,1599,'',3,0,2685),(2686,0,1600,'',1,0,2686),(2687,0,1601,'',1,0,2687),(2688,0,1601,'',2,0,2688),(2689,0,1602,'',1,0,2689),(2690,0,1602,'',2,0,2690),(2691,0,1602,'',3,0,2691),(2692,0,1603,'',1,0,2692),(2693,0,1604,'',1,0,2693),(2694,0,1604,'',2,0,2694),(2695,0,1605,'',1,0,2695),(2696,0,1605,'',2,0,2696),(2697,0,1605,'',3,0,2697),(2698,0,1606,'',1,0,2698),(2699,0,1607,'',1,0,2699),(2700,0,1607,'',2,0,2700),(2701,0,1608,'',1,0,2701),(2702,0,1608,'',2,0,2702),(2703,0,1608,'',3,0,2703),(2704,0,1609,'',1,0,2704),(2705,0,1610,'',1,0,2705),(2706,0,1610,'',2,0,2706),(2707,0,1610,'',3,0,2707),(2708,0,1611,'',1,0,2708),(2709,0,1611,'',2,0,2709),(2710,0,1611,'',3,0,2710),(2711,0,1612,'',1,0,2711),(2712,0,1613,'',1,0,2712),(2713,0,1614,'',1,0,2713),(2714,0,1614,'',2,0,2714),(2715,0,1614,'',3,0,2715),(2716,0,1615,'',1,0,2716),(2717,0,1616,'',1,0,2717),(2718,0,1617,'',1,0,2718),(2719,0,1617,'',2,0,2719),(2720,0,1617,'',3,0,2720),(2721,0,1618,'',1,0,2721),(2722,0,1619,'',1,0,2722),(2723,0,1620,'',1,0,2723),(2724,0,1620,'',2,0,2724),(2725,0,1620,'',3,0,2725),(2726,0,1621,'',1,0,2726),(2727,0,1622,'',1,0,2727),(2728,0,1623,'',1,0,2728),(2729,0,1623,'',2,0,2729),(2730,0,1623,'',3,0,2730),(2731,0,1624,'',1,0,2731),(2732,0,1625,'',1,0,2732),(2733,0,1626,'',1,0,2733),(2734,0,1626,'',2,0,2734),(2735,0,1626,'',3,0,2735),(2736,0,1627,'',1,0,2736),(2737,0,1627,'',2,0,2737),(2738,0,1627,'',3,0,2738),(2739,0,1628,'',1,0,2739),(2740,0,1629,'',1,0,2740),(2741,0,1630,'',1,0,2741),(2742,0,1630,'',2,0,2742),(2743,0,1630,'',3,0,2743),(2744,0,1631,'',1,0,2744),(2745,0,1632,'',1,0,2745),(2746,0,1633,'',1,0,2746),(2747,0,1633,'',2,0,2747),(2748,0,1633,'',3,0,2748),(2749,0,1634,'',1,0,2749),(2750,0,1635,'',1,0,2750),(2751,0,1636,'',1,0,2751),(2752,0,1636,'',2,0,2752),(2753,0,1636,'',3,0,2753),(2754,0,1637,'',1,0,2754),(2755,0,1638,'',1,0,2755),(2756,0,1639,'',1,0,2756),(2757,0,1639,'',2,0,2757),(2758,0,1639,'',3,0,2758),(2759,0,1640,'',1,0,2759),(2760,0,1641,'',1,0,2760),(2761,0,1642,'',1,0,2761),(2762,0,1642,'',2,0,2762),(2763,0,1642,'',3,0,2763),(2764,0,1643,'',1,0,2764),(2765,0,1643,'',2,0,2765),(2766,0,1643,'',3,0,2766),(2767,0,1643,'',4,0,2767),(2768,0,1644,'',1,0,2768),(2769,0,1645,'',1,0,2769),(2770,0,1646,'',1,0,2770),(2771,0,1646,'',2,0,2771),(2772,0,1646,'',3,0,2772),(2773,0,1646,'',4,0,2773),(2774,0,1647,'',1,0,2774),(2775,0,1648,'',1,0,2775),(2776,0,1649,'',1,0,2776),(2777,0,1649,'',2,0,2777),(2778,0,1649,'',3,0,2778),(2779,0,1649,'',4,0,2779),(2780,0,1650,'',1,0,2780),(2781,0,1651,'',1,0,2781),(2782,0,1652,'',1,0,2782),(2783,0,1652,'',2,0,2783),(2784,0,1652,'',3,0,2784),(2785,0,1652,'',4,0,2785),(2786,0,1653,'',1,0,2786),(2787,0,1654,'',1,0,2787),(2788,0,1655,'',1,0,2788),(2789,0,1655,'',2,0,2789),(2790,0,1655,'',3,0,2790),(2791,0,1655,'',4,0,2791),(2792,0,1656,'',1,0,2792),(2793,0,1657,'',1,0,2793),(2794,0,1658,'',1,0,2794),(2795,0,1658,'',2,0,2795),(2796,0,1658,'',3,0,2796),(2797,0,1658,'',4,0,2797),(2798,0,1659,'',1,0,2798),(2799,0,1659,'',2,0,2799),(2800,0,1660,'',1,0,2800),(2801,0,1661,'',1,0,2801),(2802,0,1662,'',1,0,2802),(2803,0,1662,'',2,0,2803),(2804,0,1663,'',1,0,2804),(2805,0,1664,'',1,0,2805),(2806,0,1665,'',1,0,2806),(2807,0,1665,'',2,0,2807),(2808,0,1666,'',1,0,2808),(2809,0,1667,'',1,0,2809),(2810,0,1668,'',1,0,2810),(2811,0,1668,'',2,0,2811),(2812,0,1669,'',1,0,2812),(2813,0,1670,'',1,0,2813),(2814,0,1671,'',1,0,2814),(2815,0,1671,'',2,0,2815),(2816,0,1672,'',1,0,2816),(2817,0,1673,'',1,0,2817),(2818,0,1674,'',1,0,2818),(2819,0,1674,'',2,0,2819),(2820,0,1675,'',1,0,2820),(2821,0,1676,'',1,0,2821),(2822,0,1676,'',2,0,2822),(2823,0,1677,'',1,0,2823),(2824,0,1678,'',1,0,2824),(2825,0,1679,'',1,0,2825),(2826,0,1679,'',2,0,2826),(2827,0,1680,'',1,0,2827),(2828,0,1681,'',1,0,2828),(2829,0,1682,'',1,0,2829),(2830,0,1682,'',2,0,2830),(2831,0,1683,'',1,0,2831),(2832,0,1684,'',1,0,2832),(2833,0,1685,'',1,0,2833),(2834,0,1685,'',2,0,2834),(2835,0,1686,'',1,0,2835),(2836,0,1687,'',1,0,2836),(2837,0,1688,'',1,0,2837),(2838,0,1688,'',2,0,2838),(2839,0,1689,'',1,0,2839),(2840,0,1690,'',1,0,2840),(2841,0,1690,'',2,0,2841),(2842,0,1691,'',1,0,2842),(2843,0,1692,'',1,0,2843),(2844,0,1692,'',2,0,2844),(2845,0,1693,'',1,0,2845),(2846,0,1694,'',1,0,2846),(2847,0,1695,'',1,0,2847),(2848,0,1695,'',2,0,2848),(2849,0,1696,'',1,0,2849),(2850,0,1697,'',1,0,2850),(2851,0,1698,'',1,0,2851),(2852,0,1698,'',2,0,2852),(2853,0,1699,'',1,0,2853),(2854,0,1700,'',1,0,2854),(2855,0,1701,'',1,0,2855),(2856,0,1701,'',2,0,2856),(2857,0,1702,'',1,0,2857),(2858,0,1703,'',1,0,2858),(2859,0,1704,'',1,0,2859),(2860,0,1704,'',2,0,2860),(2861,0,1705,'',1,0,2861),(2862,0,1706,'',1,0,2862),(2863,0,1706,'',2,0,2863),(2864,0,1707,'',1,0,2864),(2865,0,1708,'',1,0,2865),(2866,0,1709,'',1,0,2866),(2867,0,1709,'',2,0,2867),(2868,0,1709,'',3,0,2868),(2869,0,1710,'',1,0,2869),(2870,0,1711,'',1,0,2870),(2871,0,1712,'',1,0,2871),(2872,0,1712,'',2,0,2872),(2873,0,1712,'',3,0,2873),(2874,0,1713,'',1,0,2874),(2875,0,1714,'',1,0,2875),(2876,0,1715,'',1,0,2876),(2877,0,1715,'',2,0,2877),(2878,0,1715,'',3,0,2878),(2879,0,1716,'',1,0,2879),(2880,0,1717,'',1,0,2880),(2881,0,1718,'',1,0,2881),(2882,0,1718,'',2,0,2882),(2883,0,1718,'',3,0,2883),(2884,0,1719,'',1,0,2884),(2885,0,1720,'',1,0,2885),(2886,0,1721,'',1,0,2886),(2887,0,1721,'',2,0,2887),(2888,0,1721,'',3,0,2888),(2889,0,1722,'',1,0,2889),(2890,0,1722,'',2,0,2890),(2891,0,1722,'',3,0,2891),(2892,0,1723,'',1,0,2892),(2893,0,1723,'',2,0,2893),(2894,0,1724,'',1,0,2894),(2895,0,1725,'',1,0,2895),(2896,0,1726,'',1,0,2896),(2897,0,1726,'',2,0,2897),(2898,0,1727,'',1,0,2898),(2899,0,1728,'',1,0,2899),(2900,0,1729,'',1,0,2900),(2901,0,1729,'',2,0,2901),(2902,0,1730,'',1,0,2902),(2903,0,1731,'',1,0,2903),(2904,0,1732,'',1,0,2904),(2905,0,1732,'',2,0,2905),(2906,0,1733,'',1,0,2906),(2907,0,1734,'',1,0,2907),(2908,0,1735,'',1,0,2908),(2909,0,1735,'',2,0,2909),(2910,0,1736,'',1,0,2910),(2911,0,1737,'',1,0,2911),(2912,0,1738,'',1,0,2912),(2913,0,1738,'',2,0,2913),(2914,0,1739,'',1,0,2914),(2915,0,1740,'',1,0,2915),(2916,0,1740,'',2,0,2916),(2917,0,1740,'',3,0,2917),(2918,0,1741,'',1,0,2918),(2919,0,1742,'',1,0,2919),(2920,0,1743,'',1,0,2920),(2921,0,1743,'',2,0,2921),(2922,0,1743,'',3,0,2922),(2923,0,1744,'',1,0,2923),(2924,0,1745,'',1,0,2924),(2925,0,1746,'',1,0,2925),(2926,0,1746,'',2,0,2926),(2927,0,1746,'',3,0,2927),(2928,0,1747,'',1,0,2928),(2929,0,1748,'',1,0,2929),(2930,0,1749,'',1,0,2930),(2931,0,1749,'',2,0,2931),(2932,0,1749,'',3,0,2932),(2933,0,1750,'',1,0,2933),(2934,0,1751,'',1,0,2934),(2935,0,1752,'',1,0,2935),(2936,0,1752,'',2,0,2936),(2937,0,1752,'',3,0,2937),(2938,0,1753,'',1,0,2938),(2939,0,1754,'',1,0,2939),(2940,0,1754,'',2,0,2940),(2941,0,1754,'',3,0,2941),(2942,0,1755,'',1,0,2942),(2943,0,1755,'',2,0,2943),(2944,0,1756,'',1,0,2944),(2945,0,1757,'',1,0,2945),(2946,0,1758,'',1,0,2946),(2947,0,1758,'',2,0,2947),(2948,0,1759,'',1,0,2948),(2949,0,1760,'',1,0,2949),(2950,0,1761,'',1,0,2950),(2951,0,1761,'',2,0,2951),(2952,0,1762,'',1,0,2952),(2953,0,1763,'',1,0,2953),(2954,0,1764,'',1,0,2954),(2955,0,1764,'',2,0,2955),(2956,0,1765,'',1,0,2956),(2957,0,1766,'',1,0,2957),(2958,0,1767,'',1,0,2958),(2959,0,1767,'',2,0,2959),(2960,0,1768,'',1,0,2960),(2961,0,1769,'',1,0,2961),(2962,0,1770,'',1,0,2962),(2963,0,1770,'',2,0,2963),(2964,0,1771,'',1,0,2964),(2965,0,1771,'',2,0,2965),(2966,0,1771,'',3,0,2966),(2967,0,1772,'',1,0,2967),(2968,0,1773,'',1,0,2968),(2969,0,1774,'',1,0,2969),(2970,0,1774,'',2,0,2970),(2971,0,1774,'',3,0,2971),(2972,0,1775,'',1,0,2972),(2973,0,1776,'',1,0,2973),(2974,0,1777,'',1,0,2974),(2975,0,1777,'',2,0,2975),(2976,0,1777,'',3,0,2976),(2977,0,1778,'',1,0,2977),(2978,0,1779,'',1,0,2978),(2979,0,1780,'',1,0,2979),(2980,0,1780,'',2,0,2980),(2981,0,1780,'',3,0,2981),(2982,0,1781,'',1,0,2982),(2983,0,1782,'',1,0,2983),(2984,0,1783,'',1,0,2984),(2985,0,1783,'',2,0,2985),(2986,0,1783,'',3,0,2986),(2987,0,1784,'',1,0,2987),(2988,0,1785,'',1,0,2988),(2989,0,1786,'',1,0,2989),(2990,0,1786,'',2,0,2990),(2991,0,1786,'',3,0,2991),(2992,0,1787,'',1,0,2992),(2993,0,1787,'',2,0,2993),(2994,0,1787,'',3,0,2994),(2995,0,1788,'',1,0,2995),(2996,0,1789,'',1,0,2996),(2997,0,1790,'',1,0,2997),(2998,0,1790,'',2,0,2998),(2999,0,1790,'',3,0,2999),(3000,0,1791,'',1,0,3000),(3001,0,1792,'',1,0,3001),(3002,0,1793,'',1,0,3002),(3003,0,1793,'',2,0,3003),(3004,0,1793,'',3,0,3004),(3005,0,1794,'',1,0,3005),(3006,0,1795,'',1,0,3006),(3007,0,1796,'',1,0,3007),(3008,0,1796,'',2,0,3008),(3009,0,1796,'',3,0,3009),(3010,0,1797,'',1,0,3010),(3011,0,1798,'',1,0,3011),(3012,0,1799,'',1,0,3012),(3013,0,1799,'',2,0,3013),(3014,0,1799,'',3,0,3014),(3015,0,1800,'',1,0,3015),(3016,0,1801,'',1,0,3016),(3017,0,1802,'',1,0,3017),(3018,0,1802,'',2,0,3018),(3019,0,1802,'',3,0,3019),(3020,0,1803,'',1,0,3020),(3021,0,1804,'',1,0,3021),(3022,0,1804,'',2,0,3022),(3023,0,1805,'',1,0,3023),(3024,0,1806,'',1,0,3024),(3025,0,1807,'',1,0,3025),(3026,0,1807,'',2,0,3026),(3027,0,1808,'',1,0,3027),(3028,0,1809,'',1,0,3028),(3029,0,1810,'',1,0,3029),(3030,0,1810,'',2,0,3030),(3031,0,1811,'',1,0,3031),(3032,0,1812,'',1,0,3032),(3033,0,1813,'',1,0,3033),(3034,0,1813,'',2,0,3034),(3035,0,1814,'',1,0,3035),(3036,0,1815,'',1,0,3036),(3037,0,1816,'',1,0,3037),(3038,0,1816,'',2,0,3038),(3039,0,1817,'',1,0,3039),(3040,0,1818,'',1,0,3040),(3041,0,1818,'',2,0,3041),(3042,0,1819,'',1,0,3042),(3043,0,1820,'',1,0,3043),(3044,0,1820,'',2,0,3044),(3045,0,1821,'',1,0,3045),(3046,0,1822,'',1,0,3046),(3047,0,1823,'',1,0,3047),(3048,0,1823,'',2,0,3048),(3049,0,1824,'',1,0,3049),(3050,0,1825,'',1,0,3050),(3051,0,1825,'',2,0,3051),(3052,0,1826,'',1,0,3052),(3053,0,1826,'',2,0,3053),(3054,0,1827,'',1,0,3054),(3055,0,1828,'',1,0,3055),(3056,0,1829,'',1,0,3056),(3057,0,1829,'',2,0,3057),(3058,0,1830,'',1,0,3058),(3059,0,1831,'',1,0,3059),(3060,0,1832,'',1,0,3060),(3061,0,1832,'',2,0,3061),(3062,0,1833,'',1,0,3062),(3063,0,1834,'',1,0,3063),(3064,0,1834,'',2,0,3064),(3065,0,1834,'',3,0,3065),(3066,0,1835,'',1,0,3066),(3067,0,1836,'',1,0,3067),(3068,0,1837,'',1,0,3068),(3069,0,1837,'',2,0,3069),(3070,0,1837,'',3,0,3070),(3071,0,1838,'',1,0,3071),(3072,0,1839,'',1,0,3072),(3073,0,1839,'',2,0,3073),(3074,0,1839,'',3,0,3074),(3075,0,1840,'',1,0,3075),(3076,0,1841,'',1,0,3076),(3077,0,1841,'',2,0,3077),(3078,0,1841,'',3,0,3078),(3079,0,1841,'',4,0,3079),(3080,0,1842,'',1,0,3080),(3081,0,1843,'',1,0,3081),(3082,0,1844,'',1,0,3082),(3083,0,1844,'',2,0,3083),(3084,0,1844,'',3,0,3084),(3085,0,1844,'',4,0,3085),(3086,0,1845,'',1,0,3086),(3087,0,1846,'',1,0,3087),(3088,0,1846,'',2,0,3088),(3089,0,1846,'',3,0,3089),(3090,0,1846,'',4,0,3090),(3091,0,1847,'',1,0,3091),(3092,0,1848,'',1,0,3092),(3093,0,1848,'',2,0,3093),(3094,0,1848,'',3,0,3094),(3095,0,1849,'',1,0,3095),(3096,0,1850,'',1,0,3096),(3097,0,1851,'',1,0,3097),(3098,0,1851,'',2,0,3098),(3099,0,1851,'',3,0,3099),(3100,0,1852,'',1,0,3100),(3101,0,1853,'',1,0,3101),(3102,0,1853,'',2,0,3102),(3103,0,1853,'',3,0,3103),(3104,0,1854,'',1,0,3104),(3105,0,1854,'',2,0,3105),(3106,0,1854,'',3,0,3106),(3107,0,1854,'',4,0,3107),(3108,0,1855,'',1,0,3108),(3109,0,1856,'',1,0,3109),(3110,0,1857,'',1,0,3110),(3111,0,1857,'',2,0,3111),(3112,0,1857,'',3,0,3112),(3113,0,1857,'',4,0,3113),(3114,0,1858,'',1,0,3114),(3115,0,1859,'',1,0,3115),(3116,0,1860,'',1,0,3116),(3117,0,1860,'',2,0,3117),(3118,0,1860,'',3,0,3118),(3119,0,1860,'',4,0,3119),(3120,0,1861,'',1,0,3120),(3121,0,1861,'',2,0,3121),(3122,0,1861,'',3,0,3122),(3123,0,1862,'',1,0,3123),(3124,0,1863,'',1,0,3124),(3125,0,1864,'',1,0,3125),(3126,0,1864,'',2,0,3126),(3127,0,1864,'',3,0,3127),(3128,0,1865,'',1,0,3128),(3129,0,1866,'',1,0,3129),(3130,0,1867,'',1,0,3130),(3131,0,1867,'',2,0,3131),(3132,0,1867,'',3,0,3132),(3133,0,1868,'',1,0,3133),(3134,0,1868,'',2,0,3134),(3135,0,1869,'',1,0,3135),(3136,0,1870,'',1,0,3136),(3137,0,1871,'',1,0,3137),(3138,0,1871,'',2,0,3138),(3139,0,1872,'',1,0,3139),(3140,0,1873,'',1,0,3140),(3141,0,1874,'',1,0,3141),(3142,0,1874,'',2,0,3142),(3143,0,1875,'',1,0,3143),(3144,0,1875,'',2,0,3144),(3145,0,1875,'',3,0,3145),(3146,0,1875,'',4,0,3146),(3147,0,1876,'',1,0,3147),(3148,0,1877,'',1,0,3148),(3149,0,1878,'',1,0,3149),(3150,0,1878,'',2,0,3150),(3151,0,1878,'',3,0,3151),(3152,0,1878,'',4,0,3152),(3153,0,1879,'',1,0,3153),(3154,0,1880,'',1,0,3154),(3155,0,1881,'',1,0,3155),(3156,0,1881,'',2,0,3156),(3157,0,1881,'',3,0,3157),(3158,0,1881,'',4,0,3158),(3159,0,1882,'',1,0,3159),(3160,0,1883,'',1,0,3160),(3161,0,1883,'',2,0,3161),(3162,0,1883,'',3,0,3162),(3163,0,1884,'',1,0,3163),(3164,0,1885,'',1,0,3164),(3165,0,1886,'',1,0,3165),(3166,0,1886,'',2,0,3166),(3167,0,1886,'',3,0,3167),(3168,0,1887,'',1,0,3168),(3169,0,1888,'',1,0,3169),(3170,0,1888,'',2,0,3170),(3171,0,1888,'',3,0,3171),(3172,0,1889,'',1,0,3172),(3173,0,1890,'',1,0,3173),(3174,0,1890,'',2,0,3174),(3175,0,1891,'',1,0,3175),(3176,0,1892,'',1,0,3176),(3177,0,1893,'',1,0,3177),(3178,0,1893,'',2,0,3178),(3179,0,1894,'',1,0,3179),(3180,0,1895,'',1,0,3180),(3181,0,1895,'',2,0,3181),(3182,0,1896,'',1,0,3182),(3183,0,1897,'',1,0,3183),(3184,0,1897,'',2,0,3184),(3185,0,1898,'',1,0,3185),(3186,0,1899,'',1,0,3186),(3187,0,1900,'',1,0,3187),(3188,0,1900,'',2,0,3188),(3189,0,1901,'',1,0,3189),(3190,0,1902,'',1,0,3190),(3191,0,1902,'',2,0,3191),(3192,0,1903,'',1,0,3192),(3193,0,1904,'',1,0,3193),(3194,0,1905,'',1,0,3194),(3195,0,1905,'',2,0,3195),(3196,0,1906,'',1,0,3196),(3197,0,1907,'',1,0,3197),(3198,0,1908,'',1,0,3198),(3199,0,1908,'',2,0,3199),(3200,0,1909,'',1,0,3200),(3201,0,1909,'',2,0,3201),(3202,0,1910,'',1,0,3202),(3203,0,1910,'',2,0,3203),(3204,0,1911,'',1,0,3204),(3205,0,1912,'',1,0,3205),(3206,0,1913,'',1,0,3206),(3207,0,1913,'',2,0,3207),(3208,0,1914,'',1,0,3208),(3209,0,1915,'',1,0,3209),(3210,0,1916,'',1,0,3210),(3211,0,1916,'',2,0,3211),(3212,0,1917,'',1,0,3212),(3213,0,1918,'',1,0,3213),(3214,0,1919,'',1,0,3214),(3215,0,1919,'',2,0,3215),(3216,0,1920,'',1,0,3216),(3217,0,1921,'',1,0,3217),(3218,0,1922,'',1,0,3218),(3219,0,1922,'',2,0,3219),(3220,0,1923,'',1,0,3220),(3221,0,1924,'',1,0,3221),(3222,0,1925,'',1,0,3222),(3223,0,1925,'',2,0,3223),(3224,0,1926,'',1,0,3224),(3225,0,1926,'',2,0,3225),(3226,0,1927,'',1,0,3226),(3227,0,1928,'',1,0,3227),(3228,0,1929,'',1,0,3228),(3229,0,1929,'',2,0,3229),(3230,0,1930,'',1,0,3230),(3231,0,1931,'',1,0,3231),(3232,0,1932,'',1,0,3232),(3233,0,1932,'',2,0,3233),(3234,0,1933,'',1,0,3234),(3235,0,1934,'',1,0,3235),(3236,0,1935,'',1,0,3236),(3237,0,1935,'',2,0,3237),(3238,0,1936,'',1,0,3238),(3239,0,1937,'',1,0,3239),(3240,0,1938,'',1,0,3240),(3241,0,1938,'',2,0,3241),(3242,0,1939,'',1,0,3242),(3243,0,1940,'',1,0,3243),(3244,0,1941,'',1,0,3244),(3245,0,1941,'',2,0,3245),(3246,0,1942,'',1,0,3246),(3247,0,1943,'',1,0,3247),(3248,0,1943,'',2,0,3248),(3249,0,1943,'',3,0,3249),(3250,0,1944,'',1,0,3250),(3251,0,1945,'',1,0,3251),(3252,0,1946,'',1,0,3252),(3253,0,1946,'',2,0,3253),(3254,0,1946,'',3,0,3254),(3255,0,1947,'',1,0,3255),(3256,0,1948,'',1,0,3256),(3257,0,1949,'',1,0,3257),(3258,0,1949,'',2,0,3258),(3259,0,1949,'',3,0,3259),(3260,0,1950,'',1,0,3260),(3261,0,1951,'',1,0,3261),(3262,0,1952,'',1,0,3262),(3263,0,1952,'',2,0,3263),(3264,0,1952,'',3,0,3264),(3265,0,1953,'',1,0,3265),(3266,0,1954,'',1,0,3266),(3267,0,1955,'',1,0,3267),(3268,0,1955,'',2,0,3268),(3269,0,1955,'',3,0,3269),(3270,0,1956,'',1,0,3270),(3271,0,1957,'',1,0,3271),(3272,0,1957,'',2,0,3272),(3273,0,1957,'',3,0,3273),(3274,0,1958,'',1,0,3274),(3275,0,1958,'',2,0,3275),(3276,0,1958,'',3,0,3276),(3277,0,1959,'',1,0,3277),(3278,0,1960,'',1,0,3278),(3279,0,1961,'',1,0,3279),(3280,0,1961,'',2,0,3280),(3281,0,1961,'',3,0,3281),(3282,0,1962,'',1,0,3282),(3283,0,1963,'',1,0,3283),(3284,0,1964,'',1,0,3284),(3285,0,1964,'',2,0,3285),(3286,0,1964,'',3,0,3286),(3287,0,1965,'',1,0,3287),(3288,0,1966,'',1,0,3288),(3289,0,1967,'',1,0,3289),(3290,0,1967,'',2,0,3290),(3291,0,1967,'',3,0,3291),(3292,0,1968,'',1,0,3292),(3293,0,1969,'',1,0,3293),(3294,0,1970,'',1,0,3294),(3295,0,1970,'',2,0,3295),(3296,0,1970,'',3,0,3296),(3297,0,1971,'',1,0,3297),(3298,0,1972,'',1,0,3298),(3299,0,1973,'',1,0,3299),(3300,0,1973,'',2,0,3300),(3301,0,1973,'',3,0,3301),(3302,0,1974,'',1,0,3302),(3303,0,1974,'',2,0,3303),(3304,0,1975,'',1,0,3304),(3305,0,1976,'',1,0,3305),(3306,0,1977,'',1,0,3306),(3307,0,1977,'',2,0,3307),(3308,0,1978,'',1,0,3308),(3309,0,1979,'',1,0,3309),(3310,0,1980,'',1,0,3310),(3311,0,1980,'',2,0,3311),(3312,0,1981,'',1,0,3312),(3313,0,1982,'',1,0,3313),(3314,0,1983,'',1,0,3314),(3315,0,1983,'',2,0,3315),(3316,0,1984,'',1,0,3316),(3317,0,1985,'',1,0,3317),(3318,0,1986,'',1,0,3318),(3319,0,1986,'',2,0,3319),(3320,0,1987,'',1,0,3320),(3321,0,1988,'',1,0,3321),(3322,0,1989,'',1,0,3322),(3323,0,1989,'',2,0,3323),(3324,0,1990,'',1,0,3324),(3325,0,1990,'',2,0,3325),(3326,0,1990,'',3,0,3326),(3327,0,1991,'',1,0,3327),(3328,0,1992,'',1,0,3328),(3329,0,1993,'',1,0,3329),(3330,0,1993,'',2,0,3330),(3331,0,1993,'',3,0,3331),(3332,0,1994,'',1,0,3332),(3333,0,1995,'',1,0,3333),(3334,0,1996,'',1,0,3334),(3335,0,1996,'',2,0,3335),(3336,0,1996,'',3,0,3336),(3337,0,1997,'',1,0,3337),(3338,0,1997,'',2,0,3338),(3339,0,1998,'',1,0,3339),(3340,0,1999,'',1,0,3340),(3341,0,2000,'',1,0,3341),(3342,0,2000,'',2,0,3342),(3343,0,2001,'',1,0,3343),(3344,0,2002,'',1,0,3344),(3345,0,2003,'',1,0,3345),(3346,0,2003,'',2,0,3346),(3347,0,2004,'',1,0,3347),(3348,0,2004,'',2,0,3348),(3349,0,2005,'',1,0,3349),(3350,0,2005,'',2,0,3350),(3351,0,2006,'',1,0,3351),(3352,0,2006,'',2,0,3352),(3353,0,2007,'',1,0,3353),(3354,0,2007,'',2,0,3354),(3355,0,2008,'',1,0,3355),(3356,0,2008,'',2,0,3356),(3357,0,2009,'',1,0,3357),(3358,0,2009,'',2,0,3358),(3359,0,2010,'',1,0,3359),(3360,0,2010,'',2,0,3360),(3361,0,2010,'',3,0,3361),(3362,0,2011,'',1,0,3362),(3363,0,2012,'',1,0,3363),(3364,0,2013,'',1,0,3364),(3365,0,2013,'',2,0,3365),(3366,0,2013,'',3,0,3366),(3367,0,2014,'',1,0,3367),(3368,0,2015,'',1,0,3368),(3369,0,2016,'',1,0,3369),(3370,0,2016,'',2,0,3370),(3371,0,2016,'',3,0,3371),(3372,0,2017,'',1,0,3372),(3373,0,2017,'',2,0,3373),(3374,0,2017,'',3,0,3374),(3375,0,2018,'',1,0,3375),(3376,0,2019,'',1,0,3376),(3377,0,2020,'',1,0,3377),(3378,0,2020,'',2,0,3378),(3379,0,2020,'',3,0,3379),(3380,0,2021,'',1,0,3380),(3381,0,2022,'',1,0,3381),(3382,0,2023,'',1,0,3382),(3383,0,2023,'',2,0,3383),(3384,0,2023,'',3,0,3384),(3385,0,2024,'',1,0,3385),(3386,0,2024,'',2,0,3386),(3387,0,2025,'',1,0,3387),(3388,0,2026,'',1,0,3388),(3389,0,2027,'',1,0,3389),(3390,0,2027,'',2,0,3390),(3391,0,2028,'',1,0,3391),(3392,0,2029,'',1,0,3392),(3393,0,2030,'',1,0,3393),(3394,0,2030,'',2,0,3394),(3395,0,2031,'',1,0,3395),(3396,0,2031,'',2,0,3396),(3397,0,2031,'',3,0,3397),(3398,0,2032,'',1,0,3398),(3399,0,2033,'',1,0,3399),(3400,0,2034,'',1,0,3400),(3401,0,2034,'',2,0,3401),(3402,0,2034,'',3,0,3402),(3403,0,2035,'',1,0,3403),(3404,0,2036,'',1,0,3404),(3405,0,2037,'',1,0,3405),(3406,0,2037,'',2,0,3406),(3407,0,2037,'',3,0,3407),(3408,0,2038,'',1,0,3408),(3409,0,2039,'',1,0,3409),(3410,0,2040,'',1,0,3410),(3411,0,2040,'',2,0,3411),(3412,0,2040,'',3,0,3412),(3413,0,2041,'',1,0,3413),(3414,0,2042,'',1,0,3414),(3415,0,2043,'',1,0,3415),(3416,0,2043,'',2,0,3416),(3417,0,2043,'',3,0,3417),(3418,0,2044,'',1,0,3418),(3419,0,2045,'',1,0,3419),(3420,0,2046,'',1,0,3420),(3421,0,2046,'',2,0,3421),(3422,0,2046,'',3,0,3422);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity` (
  `value_id` int(10) unsigned NOT NULL COMMENT 'Value media Entry ID',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Product Entity ID',
  UNIQUE KEY `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_VAL_TO_ENTT_VAL_ID_ENTT_ID` (`value_id`,`entity_id`),
  KEY `FK_11B443E566D0F1A4C7684AD8FAC9CFAE` (`entity_id`),
  CONSTRAINT `FK_11B443E566D0F1A4C7684AD8FAC9CFAE` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE,
  CONSTRAINT `FK_80EC8D98740F21EDD3873AF489663BE3` FOREIGN KEY (`value_id`) REFERENCES `[[dbprefix]]catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Link Media value to Product entity table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity` VALUES (1,1),(2,2),(3,2),(4,3),(5,3),(6,4),(7,5),(8,6),(9,6),(10,7),(11,8),(12,9),(13,10),(14,11),(15,11),(16,12),(17,13),(18,14),(19,15),(20,16),(21,16),(22,17),(23,18),(24,19),(25,20),(26,21),(27,22),(28,23),(29,24),(30,25),(31,26),(32,27),(33,28),(34,29),(35,30),(36,31),(37,32),(38,33),(39,34),(40,35),(41,36),(42,37),(43,38),(44,39),(45,40),(46,41),(47,42),(48,43),(49,43),(50,44),(51,45),(52,46),(53,47),(54,48),(55,49),(56,50),(57,51),(58,52),(59,53),(60,54),(61,54),(62,54),(63,55),(64,56),(65,57),(66,57),(67,57),(68,58),(69,59),(70,60),(71,60),(72,60),(73,61),(74,62),(75,63),(76,63),(77,63),(78,64),(79,65),(80,66),(81,66),(82,66),(83,67),(84,68),(85,68),(86,68),(87,69),(88,69),(89,69),(90,70),(91,71),(92,72),(93,72),(94,72),(95,73),(96,74),(97,75),(98,75),(99,75),(100,76),(101,77),(102,78),(103,78),(104,78),(105,79),(106,80),(107,81),(108,81),(109,81),(110,82),(111,83),(112,84),(113,84),(114,84),(115,85),(116,85),(117,85),(118,86),(119,87),(120,88),(121,88),(122,88),(123,89),(124,90),(125,91),(126,91),(127,91),(128,92),(129,93),(130,94),(131,94),(132,94),(133,95),(134,96),(135,97),(136,97),(137,97),(138,98),(139,99),(140,100),(141,100),(142,100),(143,101),(144,101),(145,101),(146,102),(147,103),(148,104),(149,104),(150,104),(151,105),(152,106),(153,107),(154,107),(155,107),(156,108),(157,109),(158,110),(159,110),(160,110),(161,111),(162,112),(163,113),(164,113),(165,113),(166,114),(167,115),(168,116),(169,116),(170,116),(171,117),(172,118),(173,119),(174,119),(175,119),(176,120),(177,121),(178,122),(179,122),(180,122),(181,123),(182,124),(183,125),(184,125),(185,125),(186,126),(187,127),(188,128),(189,128),(190,128),(191,129),(192,130),(193,131),(194,131),(195,131),(196,132),(197,132),(198,132),(199,133),(200,134),(201,134),(202,134),(203,135),(204,136),(205,137),(206,137),(207,137),(208,138),(209,139),(210,140),(211,140),(212,140),(213,141),(214,142),(215,143),(216,143),(217,143),(218,144),(219,145),(220,146),(221,146),(222,146),(223,147),(224,148),(225,148),(226,148),(227,149),(228,150),(229,150),(230,150),(231,151),(232,152),(233,153),(234,153),(235,153),(236,154),(237,155),(238,156),(239,156),(240,156),(241,157),(242,158),(243,159),(244,159),(245,159),(246,160),(247,161),(248,162),(249,162),(250,162),(251,163),(252,164),(253,164),(254,164),(255,165),(256,165),(257,165),(258,166),(259,167),(260,168),(261,168),(262,168),(263,169),(264,170),(265,171),(266,171),(267,171),(268,172),(269,173),(270,174),(271,174),(272,174),(273,175),(274,176),(275,177),(276,177),(277,177),(278,178),(279,179),(280,180),(281,180),(282,180),(283,181),(284,181),(285,181),(286,182),(287,183),(288,184),(289,184),(290,184),(291,185),(292,186),(293,187),(294,187),(295,187),(296,188),(297,189),(298,190),(299,190),(300,190),(301,191),(302,192),(303,193),(304,193),(305,193),(306,194),(307,195),(308,196),(309,196),(310,196),(311,197),(312,198),(313,198),(314,198),(315,199),(316,200),(317,201),(318,201),(319,201),(320,202),(321,203),(322,204),(323,204),(324,204),(325,205),(326,206),(327,207),(328,207),(329,207),(330,208),(331,209),(332,210),(333,210),(334,210),(335,211),(336,212),(337,212),(338,212),(339,213),(340,214),(341,215),(342,215),(343,215),(344,216),(345,217),(346,218),(347,218),(348,218),(349,219),(350,220),(351,221),(352,221),(353,221),(354,222),(355,223),(356,224),(357,224),(358,224),(359,225),(360,226),(361,227),(362,227),(363,227),(364,228),(365,228),(366,228),(367,229),(368,230),(369,230),(370,230),(371,231),(372,232),(373,233),(374,233),(375,233),(376,234),(377,235),(378,236),(379,236),(380,236),(381,237),(382,238),(383,239),(384,239),(385,239),(386,240),(387,241),(388,242),(389,242),(390,242),(391,243),(392,244),(393,244),(394,244),(395,245),(396,245),(397,245),(398,246),(399,247),(400,248),(401,248),(402,248),(403,249),(404,250),(405,251),(406,251),(407,251),(408,252),(409,253),(410,254),(411,254),(412,254),(413,255),(414,256),(415,257),(416,257),(417,257),(418,258),(419,259),(420,260),(421,260),(422,260),(423,261),(424,262),(425,263),(426,263),(427,263),(428,264),(429,265),(430,266),(431,266),(432,266),(433,267),(434,268),(435,269),(436,269),(437,269),(438,270),(439,271),(440,272),(441,272),(442,272),(443,273),(444,274),(445,275),(446,275),(447,275),(448,276),(449,276),(450,276),(451,277),(452,277),(453,277),(454,278),(455,279),(456,280),(457,280),(458,280),(459,281),(460,282),(461,283),(462,283),(463,283),(464,284),(465,285),(466,286),(467,286),(468,286),(469,287),(470,288),(471,289),(472,289),(473,289),(474,290),(475,291),(476,292),(477,292),(478,292),(479,293),(480,293),(481,293),(482,294),(483,295),(484,296),(485,296),(486,296),(487,297),(488,298),(489,299),(490,299),(491,299),(492,300),(493,301),(494,302),(495,302),(496,302),(497,303),(498,304),(499,305),(500,305),(501,305),(502,306),(503,307),(504,308),(505,308),(506,308),(507,309),(508,310),(509,310),(510,310),(511,311),(512,312),(513,313),(514,313),(515,313),(516,314),(517,315),(518,316),(519,316),(520,316),(521,317),(522,318),(523,319),(524,319),(525,319),(526,320),(527,321),(528,322),(529,322),(530,322),(531,323),(532,324),(533,324),(534,324),(535,325),(536,326),(537,326),(538,326),(539,327),(540,328),(541,329),(542,329),(543,329),(544,330),(545,331),(546,332),(547,332),(548,332),(549,333),(550,334),(551,335),(552,335),(553,335),(554,336),(555,337),(556,338),(557,338),(558,338),(559,339),(560,340),(561,340),(562,340),(563,341),(564,342),(565,343),(566,343),(567,343),(568,344),(569,345),(570,346),(571,346),(572,346),(573,347),(574,348),(575,349),(576,349),(577,349),(578,350),(579,351),(580,352),(581,352),(582,352),(583,353),(584,354),(585,355),(586,355),(587,355),(588,356),(589,356),(590,356),(591,357),(592,358),(593,359),(594,359),(595,359),(596,360),(597,361),(598,362),(599,362),(600,362),(601,363),(602,364),(603,365),(604,365),(605,365),(606,366),(607,367),(608,368),(609,368),(610,368),(611,369),(612,370),(613,371),(614,371),(615,371),(616,372),(617,372),(618,372),(619,373),(620,373),(621,373),(622,374),(623,375),(624,376),(625,376),(626,376),(627,377),(628,378),(629,379),(630,379),(631,379),(632,380),(633,381),(634,382),(635,382),(636,382),(637,383),(638,384),(639,385),(640,385),(641,385),(642,386),(643,387),(644,388),(645,388),(646,388),(647,389),(648,389),(649,389),(650,390),(651,391),(652,392),(653,392),(654,392),(655,393),(656,394),(657,395),(658,395),(659,395),(660,396),(661,397),(662,398),(663,398),(664,398),(665,399),(666,400),(667,401),(668,401),(669,401),(670,402),(671,403),(672,404),(673,404),(674,404),(675,405),(676,405),(677,405),(678,406),(679,407),(680,408),(681,408),(682,408),(683,409),(684,410),(685,411),(686,411),(687,411),(688,412),(689,413),(690,414),(691,414),(692,414),(693,415),(694,416),(695,417),(696,417),(697,417),(698,418),(699,419),(700,420),(701,420),(702,420),(703,421),(704,422),(705,423),(706,423),(707,423),(708,424),(709,425),(710,426),(711,426),(712,426),(713,427),(714,428),(715,429),(716,429),(717,429),(718,430),(719,431),(720,432),(721,432),(722,432),(723,433),(724,434),(725,435),(726,435),(727,435),(728,436),(729,436),(730,436),(731,437),(732,438),(733,438),(734,439),(735,440),(736,441),(737,441),(738,442),(739,443),(740,444),(741,444),(742,445),(743,446),(744,447),(745,447),(746,448),(747,449),(748,450),(749,450),(750,451),(751,452),(752,452),(753,453),(754,454),(755,454),(756,455),(757,456),(758,457),(759,457),(760,458),(761,459),(762,460),(763,460),(764,461),(765,462),(766,463),(767,463),(768,464),(769,465),(770,466),(771,466),(772,467),(773,468),(774,468),(775,469),(776,470),(777,470),(778,470),(779,471),(780,472),(781,473),(782,473),(783,473),(784,474),(785,475),(786,476),(787,476),(788,476),(789,477),(790,478),(791,479),(792,479),(793,479),(794,480),(795,481),(796,482),(797,482),(798,482),(799,483),(800,484),(801,484),(802,484),(803,485),(804,486),(805,486),(806,487),(807,488),(808,489),(809,489),(810,490),(811,491),(812,492),(813,492),(814,493),(815,494),(816,495),(817,495),(818,496),(819,497),(820,498),(821,498),(822,499),(823,500),(824,500),(825,501),(826,502),(827,503),(828,503),(829,503),(830,504),(831,505),(832,506),(833,506),(834,506),(835,507),(836,508),(837,509),(838,509),(839,509),(840,510),(841,511),(842,512),(843,512),(844,512),(845,513),(846,514),(847,515),(848,515),(849,515),(850,516),(851,516),(852,516),(853,517),(854,517),(855,517),(856,518),(857,519),(858,520),(859,520),(860,520),(861,521),(862,522),(863,523),(864,523),(865,523),(866,524),(867,525),(868,526),(869,526),(870,526),(871,527),(872,528),(873,529),(874,529),(875,529),(876,530),(877,531),(878,532),(879,532),(880,533),(881,533),(882,533),(883,534),(884,535),(885,536),(886,536),(887,536),(888,537),(889,538),(890,539),(891,539),(892,539),(893,540),(894,541),(895,542),(896,542),(897,542),(898,543),(899,544),(900,545),(901,545),(902,545),(903,546),(904,547),(905,548),(906,548),(907,548),(908,549),(909,550),(910,550),(911,551),(912,552),(913,553),(914,553),(915,554),(916,555),(917,556),(918,556),(919,557),(920,558),(921,559),(922,559),(923,560),(924,561),(925,562),(926,562),(927,563),(928,564),(929,564),(930,565),(931,566),(932,567),(933,567),(934,567),(935,568),(936,569),(937,570),(938,570),(939,570),(940,571),(941,572),(942,573),(943,573),(944,573),(945,574),(946,575),(947,576),(948,576),(949,576),(950,577),(951,578),(952,579),(953,579),(954,579),(955,580),(956,580),(957,580),(958,581),(959,582),(960,582),(961,582),(962,583),(963,584),(964,585),(965,585),(966,585),(967,586),(968,587),(969,588),(970,588),(971,588),(972,589),(973,590),(974,591),(975,591),(976,591),(977,592),(978,593),(979,594),(980,594),(981,594),(982,595),(983,596),(984,596),(985,596),(986,597),(987,598),(988,598),(989,598),(990,599),(991,600),(992,601),(993,601),(994,601),(995,602),(996,603),(997,604),(998,604),(999,604),(1000,605),(1001,606),(1002,607),(1003,607),(1004,607),(1005,608),(1006,609),(1007,610),(1008,610),(1009,610),(1010,611),(1011,612),(1012,612),(1013,612),(1014,613),(1015,613),(1016,614),(1017,615),(1018,616),(1019,616),(1020,617),(1021,618),(1022,619),(1023,619),(1024,620),(1025,621),(1026,622),(1027,622),(1028,623),(1029,624),(1030,625),(1031,625),(1032,626),(1033,627),(1034,628),(1035,628),(1036,629),(1037,630),(1038,631),(1039,631),(1040,631),(1041,632),(1042,633),(1043,634),(1044,634),(1045,634),(1046,635),(1047,636),(1048,637),(1049,637),(1050,637),(1051,638),(1052,639),(1053,640),(1054,640),(1055,640),(1056,641),(1057,642),(1058,643),(1059,643),(1060,643),(1061,644),(1062,644),(1063,644),(1064,645),(1065,646),(1066,647),(1067,647),(1068,647),(1069,647),(1070,648),(1071,649),(1072,650),(1073,650),(1074,650),(1075,650),(1076,651),(1077,652),(1078,653),(1079,653),(1080,653),(1081,653),(1082,654),(1083,655),(1084,656),(1085,656),(1086,656),(1087,656),(1088,657),(1089,658),(1090,659),(1091,659),(1092,659),(1093,659),(1094,660),(1095,660),(1096,660),(1097,660),(1098,661),(1099,662),(1100,663),(1101,664),(1102,665),(1103,666),(1104,667),(1105,668),(1106,669),(1107,670),(1108,671),(1109,672),(1110,673),(1111,674),(1112,675),(1113,676),(1114,677),(1115,677),(1116,677),(1117,678),(1118,678),(1119,678),(1120,679),(1121,679),(1122,679),(1123,680),(1124,680),(1125,680),(1126,681),(1127,681),(1128,681),(1129,682),(1130,682),(1131,682),(1132,683),(1133,683),(1134,684),(1135,684),(1136,685),(1137,685),(1138,686),(1139,686),(1140,687),(1141,687),(1142,688),(1143,688),(1144,689),(1145,689),(1146,690),(1147,690),(1148,691),(1149,691),(1150,692),(1151,692),(1152,693),(1153,693),(1154,694),(1155,694),(1156,695),(1157,695),(1158,696),(1159,696),(1160,697),(1161,697),(1162,698),(1163,698),(1164,699),(1165,699),(1166,700),(1167,700),(1168,701),(1169,701),(1170,701),(1171,702),(1172,702),(1173,702),(1174,703),(1175,703),(1176,703),(1177,704),(1178,704),(1179,704),(1180,705),(1181,705),(1182,705),(1183,706),(1184,706),(1185,706),(1186,707),(1187,707),(1188,707),(1189,708),(1190,708),(1191,708),(1192,709),(1193,709),(1194,709),(1195,710),(1196,710),(1197,710),(1198,711),(1199,711),(1200,711),(1201,712),(1202,712),(1203,712),(1204,713),(1205,713),(1206,714),(1207,714),(1208,715),(1209,715),(1210,716),(1211,716),(1212,717),(1213,717),(1214,718),(1215,718),(1216,719),(1217,719),(1218,720),(1219,720),(1220,721),(1221,721),(1222,722),(1223,722),(1224,723),(1225,723),(1226,724),(1227,724),(1228,725),(1229,725),(1230,726),(1231,726),(1232,727),(1233,727),(1234,728),(1235,728),(1236,729),(1237,729),(1238,730),(1239,730),(1240,731),(1241,732),(1242,732),(1243,733),(1244,734),(1245,735),(1246,735),(1247,736),(1248,737),(1249,738),(1250,738),(1251,739),(1252,740),(1253,741),(1254,741),(1255,742),(1256,743),(1257,743),(1258,744),(1259,745),(1260,745),(1261,746),(1262,747),(1263,748),(1264,748),(1265,749),(1266,750),(1267,751),(1268,751),(1269,752),(1270,753),(1271,754),(1272,754),(1273,755),(1274,756),(1275,756),(1276,757),(1277,758),(1278,759),(1279,760),(1280,761),(1281,762),(1282,763),(1283,764),(1284,765),(1285,766),(1286,767),(1287,768),(1288,769),(1289,769),(1290,769),(1291,770),(1292,771),(1293,771),(1294,772),(1295,773),(1296,774),(1297,774),(1298,775),(1299,776),(1300,777),(1301,777),(1302,778),(1303,779),(1304,780),(1305,780),(1306,781),(1307,782),(1308,782),(1309,783),(1310,784),(1311,784),(1312,784),(1313,785),(1314,786),(1315,787),(1316,787),(1317,787),(1318,788),(1319,789),(1320,790),(1321,790),(1322,790),(1323,791),(1324,792),(1325,793),(1326,793),(1327,793),(1328,794),(1329,795),(1330,795),(1331,795),(1332,796),(1333,796),(1334,796),(1335,797),(1336,798),(1337,799),(1338,799),(1339,799),(1340,800),(1341,801),(1342,802),(1343,802),(1344,802),(1345,803),(1346,804),(1347,805),(1348,805),(1349,805),(1350,806),(1351,807),(1352,808),(1353,808),(1354,808),(1355,809),(1356,810),(1357,810),(1358,810),(1359,810),(1360,810),(1361,811),(1362,812),(1363,813),(1364,813),(1365,813),(1366,813),(1367,813),(1368,814),(1369,815),(1370,816),(1371,816),(1372,816),(1373,816),(1374,816),(1375,817),(1376,818),(1377,819),(1378,819),(1379,819),(1380,819),(1381,819),(1382,820),(1383,821),(1384,821),(1385,821),(1386,821),(1387,821),(1388,822),(1389,823),(1390,823),(1391,823),(1392,824),(1393,825),(1394,826),(1395,826),(1396,826),(1397,827),(1398,828),(1399,829),(1400,829),(1401,829),(1402,830),(1403,831),(1404,832),(1405,832),(1406,832),(1407,833),(1408,834),(1409,834),(1410,834),(1411,835),(1412,836),(1413,836),(1414,836),(1415,837),(1416,838),(1417,839),(1418,839),(1419,839),(1420,840),(1421,841),(1422,842),(1423,842),(1424,842),(1425,843),(1426,844),(1427,845),(1428,845),(1429,845),(1430,846),(1431,847),(1432,847),(1433,847),(1434,848),(1435,848),(1436,848),(1437,849),(1438,850),(1439,851),(1440,851),(1441,851),(1442,852),(1443,853),(1444,854),(1445,854),(1446,854),(1447,855),(1448,856),(1449,857),(1450,857),(1451,857),(1452,858),(1453,859),(1454,860),(1455,860),(1456,860),(1457,861),(1458,862),(1459,862),(1460,862),(1461,863),(1462,864),(1463,865),(1464,865),(1465,865),(1466,866),(1467,867),(1468,868),(1469,868),(1470,868),(1471,869),(1472,870),(1473,871),(1474,871),(1475,871),(1476,872),(1477,873),(1478,873),(1479,873),(1480,874),(1481,874),(1482,875),(1483,876),(1484,877),(1485,877),(1486,878),(1487,879),(1488,880),(1489,880),(1490,881),(1491,882),(1492,883),(1493,883),(1494,884),(1495,885),(1496,886),(1497,886),(1498,887),(1499,888),(1500,888),(1501,889),(1502,890),(1503,891),(1504,891),(1505,892),(1506,893),(1507,894),(1508,894),(1509,895),(1510,896),(1511,897),(1512,897),(1513,898),(1514,899),(1515,899),(1516,900),(1517,900),(1518,900),(1519,901),(1520,901),(1521,901),(1522,902),(1523,902),(1524,902),(1525,903),(1526,903),(1527,903),(1528,904),(1529,904),(1530,904),(1531,905),(1532,906),(1533,906),(1534,906),(1535,907),(1536,908),(1537,909),(1538,909),(1539,909),(1540,910),(1541,911),(1542,912),(1543,912),(1544,912),(1545,913),(1546,914),(1547,915),(1548,915),(1549,915),(1550,916),(1551,917),(1552,917),(1553,917),(1554,918),(1555,918),(1556,919),(1557,920),(1558,921),(1559,921),(1560,922),(1561,923),(1562,924),(1563,924),(1564,925),(1565,926),(1566,927),(1567,927),(1568,928),(1569,929),(1570,930),(1571,930),(1572,931),(1573,932),(1574,933),(1575,933),(1576,933),(1577,934),(1578,935),(1579,936),(1580,936),(1581,936),(1582,937),(1583,938),(1584,939),(1585,939),(1586,939),(1587,940),(1588,941),(1589,942),(1590,942),(1591,942),(1592,943),(1593,943),(1594,943),(1595,944),(1596,945),(1597,945),(1598,945),(1599,946),(1600,947),(1601,948),(1602,948),(1603,948),(1604,949),(1605,950),(1606,951),(1607,951),(1608,951),(1609,952),(1610,953),(1611,954),(1612,954),(1613,954),(1614,955),(1615,956),(1616,956),(1617,956),(1618,957),(1619,957),(1620,957),(1621,958),(1622,959),(1623,960),(1624,960),(1625,960),(1626,961),(1627,962),(1628,963),(1629,963),(1630,963),(1631,964),(1632,965),(1633,966),(1634,966),(1635,966),(1636,967),(1637,968),(1638,969),(1639,969),(1640,969),(1641,970),(1642,970),(1643,971),(1644,972),(1645,973),(1646,973),(1647,974),(1648,975),(1649,976),(1650,976),(1651,977),(1652,978),(1653,979),(1654,979),(1655,980),(1656,981),(1657,982),(1658,982),(1659,983),(1660,984),(1661,984),(1662,984),(1663,985),(1664,986),(1665,987),(1666,987),(1667,987),(1668,988),(1669,989),(1670,990),(1671,990),(1672,990),(1673,991),(1674,992),(1675,993),(1676,993),(1677,993),(1678,994),(1679,995),(1680,995),(1681,995),(1682,996),(1683,996),(1684,996),(1685,997),(1686,998),(1687,999),(1688,999),(1689,999),(1690,1000),(1691,1001),(1692,1002),(1693,1002),(1694,1002),(1695,1003),(1696,1004),(1697,1005),(1698,1005),(1699,1005),(1700,1006),(1701,1007),(1702,1008),(1703,1008),(1704,1008),(1705,1009),(1706,1010),(1707,1010),(1708,1011),(1709,1012),(1710,1013),(1711,1013),(1712,1014),(1713,1015),(1714,1016),(1715,1016),(1716,1017),(1717,1018),(1718,1019),(1719,1019),(1720,1020),(1721,1021),(1722,1021),(1723,1022),(1724,1023),(1725,1024),(1726,1024),(1727,1025),(1728,1026),(1729,1027),(1730,1027),(1731,1028),(1732,1029),(1733,1030),(1734,1030),(1735,1031),(1736,1032),(1737,1033),(1738,1033),(1739,1034),(1740,1034),(1741,1035),(1742,1035),(1743,1035),(1744,1036),(1745,1037),(1746,1038),(1747,1038),(1748,1038),(1749,1039),(1750,1040),(1751,1041),(1752,1041),(1753,1041),(1754,1042),(1755,1043),(1756,1044),(1757,1044),(1758,1044),(1759,1045),(1760,1046),(1761,1047),(1762,1047),(1763,1047),(1764,1048),(1765,1049),(1766,1050),(1767,1050),(1768,1050),(1769,1051),(1770,1051),(1771,1051),(1772,1052),(1773,1053),(1774,1054),(1775,1054),(1776,1054),(1777,1055),(1778,1056),(1779,1057),(1780,1057),(1781,1057),(1782,1058),(1783,1059),(1784,1060),(1785,1060),(1786,1060),(1787,1061),(1788,1062),(1789,1063),(1790,1063),(1791,1063),(1792,1064),(1793,1065),(1794,1066),(1795,1066),(1796,1066),(1797,1067),(1798,1068),(1799,1069),(1800,1069),(1801,1069),(1802,1070),(1803,1071),(1804,1072),(1805,1072),(1806,1072),(1807,1073),(1808,1074),(1809,1075),(1810,1075),(1811,1075),(1812,1076),(1813,1077),(1814,1078),(1815,1078),(1816,1078),(1817,1079),(1818,1080),(1819,1081),(1820,1081),(1821,1081),(1822,1082),(1823,1082),(1824,1082),(1825,1083),(1826,1083),(1827,1083),(1828,1084),(1829,1085),(1830,1086),(1831,1086),(1832,1086),(1833,1087),(1834,1088),(1835,1089),(1836,1089),(1837,1089),(1838,1090),(1839,1091),(1840,1092),(1841,1092),(1842,1092),(1843,1093),(1844,1094),(1845,1095),(1846,1095),(1847,1095),(1848,1096),(1849,1097),(1850,1098),(1851,1098),(1852,1098),(1853,1099),(1854,1100),(1855,1101),(1856,1101),(1857,1102),(1858,1103),(1859,1104),(1860,1104),(1861,1105),(1862,1106),(1863,1107),(1864,1107),(1865,1108),(1866,1109),(1867,1110),(1868,1110),(1869,1111),(1870,1112),(1871,1113),(1872,1113),(1873,1114),(1874,1114),(1875,1115),(1876,1115),(1877,1115),(1878,1116),(1879,1116),(1880,1116),(1881,1117),(1882,1117),(1883,1117),(1884,1118),(1885,1118),(1886,1118),(1887,1119),(1888,1119),(1889,1119),(1890,1120),(1891,1120),(1892,1120),(1893,1121),(1894,1121),(1895,1121),(1896,1122),(1897,1123),(1898,1124),(1899,1124),(1900,1124),(1901,1125),(1902,1126),(1903,1127),(1904,1127),(1905,1127),(1906,1128),(1907,1129),(1908,1130),(1909,1130),(1910,1130),(1911,1131),(1912,1132),(1913,1133),(1914,1133),(1915,1133),(1916,1134),(1917,1135),(1918,1136),(1919,1136),(1920,1136),(1921,1137),(1922,1138),(1923,1139),(1924,1139),(1925,1139),(1926,1139),(1927,1140),(1928,1141),(1929,1142),(1930,1142),(1931,1142),(1932,1142),(1933,1143),(1934,1144),(1935,1145),(1936,1145),(1937,1145),(1938,1145),(1939,1146),(1940,1147),(1941,1148),(1942,1148),(1943,1148),(1944,1148),(1945,1149),(1946,1150),(1947,1151),(1948,1151),(1949,1151),(1950,1151),(1951,1152),(1952,1152),(1953,1152),(1954,1152),(1955,1153),(1956,1154),(1957,1154),(1958,1154),(1959,1155),(1960,1156),(1961,1157),(1962,1157),(1963,1157),(1964,1158),(1965,1159),(1966,1160),(1967,1160),(1968,1160),(1969,1161),(1970,1162),(1971,1163),(1972,1163),(1973,1163),(1974,1164),(1975,1165),(1976,1166),(1977,1166),(1978,1166),(1979,1167),(1980,1168),(1981,1168),(1982,1168),(1983,1169),(1984,1170),(1985,1170),(1986,1170),(1987,1171),(1988,1172),(1989,1173),(1990,1173),(1991,1173),(1992,1174),(1993,1175),(1994,1176),(1995,1176),(1996,1176),(1997,1177),(1998,1178),(1999,1179),(2000,1179),(2001,1179),(2002,1180),(2003,1181),(2004,1182),(2005,1182),(2006,1182),(2007,1183),(2008,1184),(2009,1184),(2010,1184),(2011,1185),(2012,1185),(2013,1186),(2014,1187),(2015,1188),(2016,1188),(2017,1189),(2018,1190),(2019,1191),(2020,1191),(2021,1192),(2022,1193),(2023,1194),(2024,1194),(2025,1195),(2026,1196),(2027,1197),(2028,1197),(2029,1198),(2030,1199),(2031,1200),(2032,1200),(2033,1201),(2034,1201),(2035,1202),(2036,1203),(2037,1204),(2038,1204),(2039,1205),(2040,1206),(2041,1207),(2042,1207),(2043,1208),(2044,1209),(2045,1210),(2046,1210),(2047,1211),(2048,1212),(2049,1213),(2050,1213),(2051,1214),(2052,1215),(2053,1216),(2054,1216),(2055,1217),(2056,1218),(2057,1218),(2058,1218),(2059,1219),(2060,1220),(2061,1221),(2062,1221),(2063,1221),(2064,1222),(2065,1223),(2066,1224),(2067,1224),(2068,1224),(2069,1225),(2070,1226),(2071,1226),(2072,1226),(2073,1227),(2074,1228),(2075,1229),(2076,1229),(2077,1229),(2078,1230),(2079,1231),(2080,1232),(2081,1232),(2082,1232),(2083,1233),(2084,1234),(2085,1235),(2086,1235),(2087,1235),(2088,1236),(2089,1237),(2090,1238),(2091,1238),(2092,1238),(2093,1239),(2094,1240),(2095,1241),(2096,1241),(2097,1241),(2098,1242),(2099,1242),(2100,1242),(2101,1243),(2102,1244),(2103,1245),(2104,1245),(2105,1245),(2106,1246),(2107,1247),(2108,1248),(2109,1248),(2110,1248),(2111,1249),(2112,1250),(2113,1251),(2114,1251),(2115,1251),(2116,1252),(2117,1253),(2118,1254),(2119,1254),(2120,1254),(2121,1255),(2122,1256),(2123,1257),(2124,1257),(2125,1257),(2126,1258),(2127,1258),(2128,1258),(2129,1259),(2130,1260),(2131,1261),(2132,1261),(2133,1261),(2134,1261),(2135,1262),(2136,1263),(2137,1264),(2138,1264),(2139,1264),(2140,1264),(2141,1265),(2142,1266),(2143,1267),(2144,1267),(2145,1267),(2146,1267),(2147,1268),(2148,1269),(2149,1270),(2150,1270),(2151,1270),(2152,1270),(2153,1271),(2154,1272),(2155,1273),(2156,1273),(2157,1273),(2158,1273),(2159,1274),(2160,1274),(2161,1274),(2162,1274),(2163,1275),(2164,1275),(2165,1275),(2166,1276),(2167,1277),(2168,1278),(2169,1278),(2170,1278),(2171,1279),(2172,1280),(2173,1281),(2174,1281),(2175,1281),(2176,1282),(2177,1283),(2178,1284),(2179,1284),(2180,1284),(2181,1285),(2182,1286),(2183,1287),(2184,1287),(2185,1287),(2186,1288),(2187,1289),(2188,1290),(2189,1290),(2190,1290),(2191,1291),(2192,1292),(2193,1292),(2194,1292),(2195,1293),(2196,1294),(2197,1295),(2198,1295),(2199,1295),(2200,1296),(2201,1297),(2202,1298),(2203,1298),(2204,1298),(2205,1299),(2206,1300),(2207,1301),(2208,1301),(2209,1301),(2210,1302),(2211,1303),(2212,1304),(2213,1304),(2214,1304),(2215,1305),(2216,1306),(2217,1306),(2218,1306),(2219,1307),(2220,1307),(2221,1307),(2222,1307),(2223,1308),(2224,1309),(2225,1310),(2226,1310),(2227,1310),(2228,1310),(2229,1311),(2230,1312),(2231,1313),(2232,1313),(2233,1313),(2234,1313),(2235,1314),(2236,1315),(2237,1316),(2238,1316),(2239,1316),(2240,1316),(2241,1317),(2242,1318),(2243,1319),(2244,1319),(2245,1319),(2246,1319),(2247,1320),(2248,1321),(2249,1322),(2250,1322),(2251,1322),(2252,1322),(2253,1323),(2254,1324),(2255,1325),(2256,1325),(2257,1325),(2258,1326),(2259,1327),(2260,1328),(2261,1328),(2262,1328),(2263,1329),(2264,1330),(2265,1331),(2266,1331),(2267,1331),(2268,1332),(2269,1333),(2270,1334),(2271,1334),(2272,1334),(2273,1335),(2274,1336),(2275,1337),(2276,1337),(2277,1337),(2278,1338),(2279,1338),(2280,1338),(2281,1339),(2282,1340),(2283,1341),(2284,1341),(2285,1341),(2286,1342),(2287,1343),(2288,1344),(2289,1344),(2290,1344),(2291,1345),(2292,1346),(2293,1347),(2294,1347),(2295,1347),(2296,1348),(2297,1349),(2298,1350),(2299,1350),(2300,1350),(2301,1351),(2302,1352),(2303,1353),(2304,1353),(2305,1353),(2306,1354),(2307,1354),(2308,1354),(2309,1355),(2310,1356),(2311,1356),(2312,1356),(2313,1357),(2314,1358),(2315,1359),(2316,1359),(2317,1359),(2318,1360),(2319,1361),(2320,1362),(2321,1362),(2322,1362),(2323,1363),(2324,1364),(2325,1365),(2326,1365),(2327,1365),(2328,1366),(2329,1367),(2330,1368),(2331,1368),(2332,1368),(2333,1369),(2334,1370),(2335,1370),(2336,1370),(2337,1371),(2338,1372),(2339,1373),(2340,1373),(2341,1373),(2342,1374),(2343,1375),(2344,1376),(2345,1376),(2346,1376),(2347,1377),(2348,1378),(2349,1379),(2350,1379),(2351,1379),(2352,1380),(2353,1381),(2354,1382),(2355,1382),(2356,1382),(2357,1383),(2358,1384),(2359,1385),(2360,1385),(2361,1385),(2362,1386),(2363,1386),(2364,1386),(2365,1387),(2366,1388),(2367,1388),(2368,1388),(2369,1389),(2370,1390),(2371,1391),(2372,1391),(2373,1391),(2374,1392),(2375,1393),(2376,1394),(2377,1394),(2378,1394),(2379,1395),(2380,1396),(2381,1397),(2382,1397),(2383,1397),(2384,1398),(2385,1399),(2386,1400),(2387,1400),(2388,1400),(2389,1401),(2390,1402),(2391,1402),(2392,1402),(2393,1403),(2394,1404),(2395,1404),(2396,1405),(2397,1406),(2398,1407),(2399,1407),(2400,1408),(2401,1409),(2402,1410),(2403,1410),(2404,1411),(2405,1412),(2406,1413),(2407,1413),(2408,1414),(2409,1415),(2410,1416),(2411,1416),(2412,1417),(2413,1418),(2414,1418),(2415,1419),(2416,1420),(2417,1421),(2418,1421),(2419,1421),(2420,1422),(2421,1423),(2422,1424),(2423,1424),(2424,1424),(2425,1425),(2426,1426),(2427,1427),(2428,1427),(2429,1427),(2430,1428),(2431,1429),(2432,1430),(2433,1430),(2434,1430),(2435,1431),(2436,1432),(2437,1433),(2438,1433),(2439,1433),(2440,1434),(2441,1434),(2442,1434),(2443,1435),(2444,1436),(2445,1436),(2446,1437),(2447,1438),(2448,1439),(2449,1439),(2450,1440),(2451,1441),(2452,1442),(2453,1442),(2454,1443),(2455,1444),(2456,1445),(2457,1445),(2458,1446),(2459,1447),(2460,1448),(2461,1448),(2462,1449),(2463,1450),(2464,1450),(2465,1451),(2466,1452),(2467,1452),(2468,1453),(2469,1454),(2470,1455),(2471,1455),(2472,1456),(2473,1457),(2474,1458),(2475,1458),(2476,1459),(2477,1460),(2478,1461),(2479,1461),(2480,1462),(2481,1463),(2482,1464),(2483,1464),(2484,1465),(2485,1466),(2486,1466),(2487,1467),(2488,1467),(2489,1467),(2490,1468),(2491,1469),(2492,1470),(2493,1470),(2494,1470),(2495,1471),(2496,1472),(2497,1473),(2498,1473),(2499,1473),(2500,1474),(2501,1475),(2502,1476),(2503,1476),(2504,1476),(2505,1477),(2506,1478),(2507,1479),(2508,1479),(2509,1479),(2510,1480),(2511,1481),(2512,1482),(2513,1482),(2514,1482),(2515,1483),(2516,1484),(2517,1484),(2518,1485),(2519,1486),(2520,1487),(2521,1487),(2522,1488),(2523,1489),(2524,1490),(2525,1490),(2526,1491),(2527,1492),(2528,1493),(2529,1493),(2530,1494),(2531,1495),(2532,1496),(2533,1496),(2534,1497),(2535,1498),(2536,1498),(2537,1499),(2538,1499),(2539,1500),(2540,1501),(2541,1502),(2542,1502),(2543,1503),(2544,1504),(2545,1505),(2546,1505),(2547,1506),(2548,1507),(2549,1508),(2550,1508),(2551,1509),(2552,1510),(2553,1511),(2554,1511),(2555,1512),(2556,1513),(2557,1514),(2558,1514),(2559,1515),(2560,1516),(2561,1516),(2562,1517),(2563,1518),(2564,1519),(2565,1519),(2566,1520),(2567,1521),(2568,1522),(2569,1522),(2570,1523),(2571,1524),(2572,1525),(2573,1525),(2574,1526),(2575,1527),(2576,1528),(2577,1528),(2578,1529),(2579,1530),(2580,1530),(2581,1531),(2582,1532),(2583,1533),(2584,1533),(2585,1534),(2586,1535),(2587,1536),(2588,1536),(2589,1537),(2590,1538),(2591,1539),(2592,1539),(2593,1540),(2594,1541),(2595,1542),(2596,1542),(2597,1543),(2598,1544),(2599,1545),(2600,1545),(2601,1546),(2602,1546),(2603,1547),(2604,1548),(2605,1548),(2606,1549),(2607,1550),(2608,1551),(2609,1551),(2610,1552),(2611,1553),(2612,1554),(2613,1554),(2614,1555),(2615,1556),(2616,1557),(2617,1557),(2618,1558),(2619,1559),(2620,1560),(2621,1560),(2622,1561),(2623,1562),(2624,1562),(2625,1563),(2626,1563),(2627,1564),(2628,1565),(2629,1566),(2630,1566),(2631,1567),(2632,1568),(2633,1569),(2634,1569),(2635,1570),(2636,1571),(2637,1572),(2638,1572),(2639,1573),(2640,1574),(2641,1575),(2642,1575),(2643,1576),(2644,1577),(2645,1578),(2646,1578),(2647,1579),(2648,1579),(2649,1579),(2650,1580),(2651,1581),(2652,1582),(2653,1582),(2654,1582),(2655,1583),(2656,1584),(2657,1585),(2658,1585),(2659,1585),(2660,1586),(2661,1587),(2662,1588),(2663,1588),(2664,1588),(2665,1589),(2666,1590),(2667,1591),(2668,1591),(2669,1591),(2670,1592),(2671,1593),(2672,1594),(2673,1594),(2674,1594),(2675,1595),(2676,1595),(2677,1596),(2678,1596),(2679,1596),(2680,1597),(2681,1598),(2682,1598),(2683,1599),(2684,1599),(2685,1599),(2686,1600),(2687,1601),(2688,1601),(2689,1602),(2690,1602),(2691,1602),(2692,1603),(2693,1604),(2694,1604),(2695,1605),(2696,1605),(2697,1605),(2698,1606),(2699,1607),(2700,1607),(2701,1608),(2702,1608),(2703,1608),(2704,1609),(2705,1610),(2706,1610),(2707,1610),(2708,1611),(2709,1611),(2710,1611),(2711,1612),(2712,1613),(2713,1614),(2714,1614),(2715,1614),(2716,1615),(2717,1616),(2718,1617),(2719,1617),(2720,1617),(2721,1618),(2722,1619),(2723,1620),(2724,1620),(2725,1620),(2726,1621),(2727,1622),(2728,1623),(2729,1623),(2730,1623),(2731,1624),(2732,1625),(2733,1626),(2734,1626),(2735,1626),(2736,1627),(2737,1627),(2738,1627),(2739,1628),(2740,1629),(2741,1630),(2742,1630),(2743,1630),(2744,1631),(2745,1632),(2746,1633),(2747,1633),(2748,1633),(2749,1634),(2750,1635),(2751,1636),(2752,1636),(2753,1636),(2754,1637),(2755,1638),(2756,1639),(2757,1639),(2758,1639),(2759,1640),(2760,1641),(2761,1642),(2762,1642),(2763,1642),(2764,1643),(2765,1643),(2766,1643),(2767,1643),(2768,1644),(2769,1645),(2770,1646),(2771,1646),(2772,1646),(2773,1646),(2774,1647),(2775,1648),(2776,1649),(2777,1649),(2778,1649),(2779,1649),(2780,1650),(2781,1651),(2782,1652),(2783,1652),(2784,1652),(2785,1652),(2786,1653),(2787,1654),(2788,1655),(2789,1655),(2790,1655),(2791,1655),(2792,1656),(2793,1657),(2794,1658),(2795,1658),(2796,1658),(2797,1658),(2798,1659),(2799,1659),(2800,1660),(2801,1661),(2802,1662),(2803,1662),(2804,1663),(2805,1664),(2806,1665),(2807,1665),(2808,1666),(2809,1667),(2810,1668),(2811,1668),(2812,1669),(2813,1670),(2814,1671),(2815,1671),(2816,1672),(2817,1673),(2818,1674),(2819,1674),(2820,1675),(2821,1676),(2822,1676),(2823,1677),(2824,1678),(2825,1679),(2826,1679),(2827,1680),(2828,1681),(2829,1682),(2830,1682),(2831,1683),(2832,1684),(2833,1685),(2834,1685),(2835,1686),(2836,1687),(2837,1688),(2838,1688),(2839,1689),(2840,1690),(2841,1690),(2842,1691),(2843,1692),(2844,1692),(2845,1693),(2846,1694),(2847,1695),(2848,1695),(2849,1696),(2850,1697),(2851,1698),(2852,1698),(2853,1699),(2854,1700),(2855,1701),(2856,1701),(2857,1702),(2858,1703),(2859,1704),(2860,1704),(2861,1705),(2862,1706),(2863,1706),(2864,1707),(2865,1708),(2866,1709),(2867,1709),(2868,1709),(2869,1710),(2870,1711),(2871,1712),(2872,1712),(2873,1712),(2874,1713),(2875,1714),(2876,1715),(2877,1715),(2878,1715),(2879,1716),(2880,1717),(2881,1718),(2882,1718),(2883,1718),(2884,1719),(2885,1720),(2886,1721),(2887,1721),(2888,1721),(2889,1722),(2890,1722),(2891,1722),(2892,1723),(2893,1723),(2894,1724),(2895,1725),(2896,1726),(2897,1726),(2898,1727),(2899,1728),(2900,1729),(2901,1729),(2902,1730),(2903,1731),(2904,1732),(2905,1732),(2906,1733),(2907,1734),(2908,1735),(2909,1735),(2910,1736),(2911,1737),(2912,1738),(2913,1738),(2914,1739),(2915,1740),(2916,1740),(2917,1740),(2918,1741),(2919,1742),(2920,1743),(2921,1743),(2922,1743),(2923,1744),(2924,1745),(2925,1746),(2926,1746),(2927,1746),(2928,1747),(2929,1748),(2930,1749),(2931,1749),(2932,1749),(2933,1750),(2934,1751),(2935,1752),(2936,1752),(2937,1752),(2938,1753),(2939,1754),(2940,1754),(2941,1754),(2942,1755),(2943,1755),(2944,1756),(2945,1757),(2946,1758),(2947,1758),(2948,1759),(2949,1760),(2950,1761),(2951,1761),(2952,1762),(2953,1763),(2954,1764),(2955,1764),(2956,1765),(2957,1766),(2958,1767),(2959,1767),(2960,1768),(2961,1769),(2962,1770),(2963,1770),(2964,1771),(2965,1771),(2966,1771),(2967,1772),(2968,1773),(2969,1774),(2970,1774),(2971,1774),(2972,1775),(2973,1776),(2974,1777),(2975,1777),(2976,1777),(2977,1778),(2978,1779),(2979,1780),(2980,1780),(2981,1780),(2982,1781),(2983,1782),(2984,1783),(2985,1783),(2986,1783),(2987,1784),(2988,1785),(2989,1786),(2990,1786),(2991,1786),(2992,1787),(2993,1787),(2994,1787),(2995,1788),(2996,1789),(2997,1790),(2998,1790),(2999,1790),(3000,1791),(3001,1792),(3002,1793),(3003,1793),(3004,1793),(3005,1794),(3006,1795),(3007,1796),(3008,1796),(3009,1796),(3010,1797),(3011,1798),(3012,1799),(3013,1799),(3014,1799),(3015,1800),(3016,1801),(3017,1802),(3018,1802),(3019,1802),(3020,1803),(3021,1804),(3022,1804),(3023,1805),(3024,1806),(3025,1807),(3026,1807),(3027,1808),(3028,1809),(3029,1810),(3030,1810),(3031,1811),(3032,1812),(3033,1813),(3034,1813),(3035,1814),(3036,1815),(3037,1816),(3038,1816),(3039,1817),(3040,1818),(3041,1818),(3042,1819),(3043,1820),(3044,1820),(3045,1821),(3046,1822),(3047,1823),(3048,1823),(3049,1824),(3050,1825),(3051,1825),(3052,1826),(3053,1826),(3054,1827),(3055,1828),(3056,1829),(3057,1829),(3058,1830),(3059,1831),(3060,1832),(3061,1832),(3062,1833),(3063,1834),(3064,1834),(3065,1834),(3066,1835),(3067,1836),(3068,1837),(3069,1837),(3070,1837),(3071,1838),(3072,1839),(3073,1839),(3074,1839),(3075,1840),(3076,1841),(3077,1841),(3078,1841),(3079,1841),(3080,1842),(3081,1843),(3082,1844),(3083,1844),(3084,1844),(3085,1844),(3086,1845),(3087,1846),(3088,1846),(3089,1846),(3090,1846),(3091,1847),(3092,1848),(3093,1848),(3094,1848),(3095,1849),(3096,1850),(3097,1851),(3098,1851),(3099,1851),(3100,1852),(3101,1853),(3102,1853),(3103,1853),(3104,1854),(3105,1854),(3106,1854),(3107,1854),(3108,1855),(3109,1856),(3110,1857),(3111,1857),(3112,1857),(3113,1857),(3114,1858),(3115,1859),(3116,1860),(3117,1860),(3118,1860),(3119,1860),(3120,1861),(3121,1861),(3122,1861),(3123,1862),(3124,1863),(3125,1864),(3126,1864),(3127,1864),(3128,1865),(3129,1866),(3130,1867),(3131,1867),(3132,1867),(3133,1868),(3134,1868),(3135,1869),(3136,1870),(3137,1871),(3138,1871),(3139,1872),(3140,1873),(3141,1874),(3142,1874),(3143,1875),(3144,1875),(3145,1875),(3146,1875),(3147,1876),(3148,1877),(3149,1878),(3150,1878),(3151,1878),(3152,1878),(3153,1879),(3154,1880),(3155,1881),(3156,1881),(3157,1881),(3158,1881),(3159,1882),(3160,1883),(3161,1883),(3162,1883),(3163,1884),(3164,1885),(3165,1886),(3166,1886),(3167,1886),(3168,1887),(3169,1888),(3170,1888),(3171,1888),(3172,1889),(3173,1890),(3174,1890),(3175,1891),(3176,1892),(3177,1893),(3178,1893),(3179,1894),(3180,1895),(3181,1895),(3182,1896),(3183,1897),(3184,1897),(3185,1898),(3186,1899),(3187,1900),(3188,1900),(3189,1901),(3190,1902),(3191,1902),(3192,1903),(3193,1904),(3194,1905),(3195,1905),(3196,1906),(3197,1907),(3198,1908),(3199,1908),(3200,1909),(3201,1909),(3202,1910),(3203,1910),(3204,1911),(3205,1912),(3206,1913),(3207,1913),(3208,1914),(3209,1915),(3210,1916),(3211,1916),(3212,1917),(3213,1918),(3214,1919),(3215,1919),(3216,1920),(3217,1921),(3218,1922),(3219,1922),(3220,1923),(3221,1924),(3222,1925),(3223,1925),(3224,1926),(3225,1926),(3226,1927),(3227,1928),(3228,1929),(3229,1929),(3230,1930),(3231,1931),(3232,1932),(3233,1932),(3234,1933),(3235,1934),(3236,1935),(3237,1935),(3238,1936),(3239,1937),(3240,1938),(3241,1938),(3242,1939),(3243,1940),(3244,1941),(3245,1941),(3246,1942),(3247,1943),(3248,1943),(3249,1943),(3250,1944),(3251,1945),(3252,1946),(3253,1946),(3254,1946),(3255,1947),(3256,1948),(3257,1949),(3258,1949),(3259,1949),(3260,1950),(3261,1951),(3262,1952),(3263,1952),(3264,1952),(3265,1953),(3266,1954),(3267,1955),(3268,1955),(3269,1955),(3270,1956),(3271,1957),(3272,1957),(3273,1957),(3274,1958),(3275,1958),(3276,1958),(3277,1959),(3278,1960),(3279,1961),(3280,1961),(3281,1961),(3282,1962),(3283,1963),(3284,1964),(3285,1964),(3286,1964),(3287,1965),(3288,1966),(3289,1967),(3290,1967),(3291,1967),(3292,1968),(3293,1969),(3294,1970),(3295,1970),(3296,1970),(3297,1971),(3298,1972),(3299,1973),(3300,1973),(3301,1973),(3302,1974),(3303,1974),(3304,1975),(3305,1976),(3306,1977),(3307,1977),(3308,1978),(3309,1979),(3310,1980),(3311,1980),(3312,1981),(3313,1982),(3314,1983),(3315,1983),(3316,1984),(3317,1985),(3318,1986),(3319,1986),(3320,1987),(3321,1988),(3322,1989),(3323,1989),(3324,1990),(3325,1990),(3326,1990),(3327,1991),(3328,1992),(3329,1993),(3330,1993),(3331,1993),(3332,1994),(3333,1995),(3334,1996),(3335,1996),(3336,1996),(3337,1997),(3338,1997),(3339,1998),(3340,1999),(3341,2000),(3342,2000),(3343,2001),(3344,2002),(3345,2003),(3346,2003),(3347,2004),(3348,2004),(3349,2005),(3350,2005),(3351,2006),(3352,2006),(3353,2007),(3354,2007),(3355,2008),(3356,2008),(3357,2009),(3358,2009),(3359,2010),(3360,2010),(3361,2010),(3362,2011),(3363,2012),(3364,2013),(3365,2013),(3366,2013),(3367,2014),(3368,2015),(3369,2016),(3370,2016),(3371,2016),(3372,2017),(3373,2017),(3374,2017),(3375,2018),(3376,2019),(3377,2020),(3378,2020),(3379,2020),(3380,2021),(3381,2022),(3382,2023),(3383,2023),(3384,2023),(3385,2024),(3386,2024),(3387,2025),(3388,2026),(3389,2027),(3390,2027),(3391,2028),(3392,2029),(3393,2030),(3394,2030),(3395,2031),(3396,2031),(3397,2031),(3398,2032),(3399,2033),(3400,2034),(3401,2034),(3402,2034),(3403,2035),(3404,2036),(3405,2037),(3406,2037),(3407,2037),(3408,2038),(3409,2039),(3410,2040),(3411,2040),(3412,2040),(3413,2041),(3414,2042),(3415,2043),(3416,2043),(3417,2043),(3418,2044),(3419,2045),(3420,2046),(3421,2046),(3422,2046);
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value_to_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_media_gallery_value_video`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_media_gallery_value_video`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value_video` (
  `value_id` int(10) unsigned NOT NULL COMMENT 'Media Entity ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `provider` varchar(32) DEFAULT NULL COMMENT 'Video provider ID',
  `url` text COMMENT 'Video URL',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `description` text COMMENT 'Page Meta Description',
  `metadata` text COMMENT 'Video meta data',
  UNIQUE KEY `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_VAL_ID_STORE_ID` (`value_id`,`store_id`),
  KEY `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` (`store_id`),
  CONSTRAINT `FK_A0FC129B4BF5F257FAA2BEFCD8CD532C` FOREIGN KEY (`value_id`) REFERENCES `[[dbprefix]]catalog_product_entity_media_gallery` (`value_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Video Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_media_gallery_value_video`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_media_gallery_value_video` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value_video` DISABLE KEYS */;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_media_gallery_value_video` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `[[dbprefix]]catalog_product_entity_text`
--

DROP TABLE IF EXISTS `[[dbprefix]]catalog_product_entity_text`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `[[dbprefix]]catalog_product_entity_text` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` text COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID` (`store_id`),
  CONSTRAINT `[[DBPREFIX]]CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID_[[DBPREFIX]]STORE_STORE_ID` FOREIGN KEY (`store_id`) REFERENCES `[[dbprefix]]store` (`store_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_TEXT_ATTR_ID_[[DBPREFIX]]EAV_ATTR_ATTR_ID` FOREIGN KEY (`attribute_id`) REFERENCES `[[dbprefix]]eav_attribute` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `[[DBPREFIX]]CAT_PRD_ENTT_TEXT_ENTT_ID_[[DBPREFIX]]CAT_PRD_ENTT_ENTT_ID` FOREIGN KEY (`entity_id`) REFERENCES `[[dbprefix]]catalog_product_entity` (`entity_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2053 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Text Attribute Backend Table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `[[dbprefix]]catalog_product_entity_text`
--

LOCK TABLES `[[dbprefix]]catalog_product_entity_text` WRITE;
/*!40000 ALTER TABLE `[[dbprefix]]catalog_product_entity_text` DISABLE KEYS */;
INSERT INTO `[[dbprefix]]catalog_product_entity_text` VALUES (1,75,0,1,'<p>The sporty Joust Duffle Bag can\'t be beat - not in the gym, not on the luggage carousel, not anywhere. Big enough to haul a basketball or soccer ball and some sneakers with plenty of room to spare, it\'s ideal for athletes with places to go.<p>\n<ul>\n<li>Dual top handles.</li>\n<li>Adjustable shoulder strap.</li>\n<li>Full-length zipper.</li>\n<li>L 29\" x W 13\" x H 11\".</li>\n</ul>'),(2,75,0,2,'<p>Convenience is next to nothing when your day is crammed with action. So whether you\'re heading to class, gym, or the unbeaten path, make sure you\'ve got your Strive Shoulder Pack stuffed with all your essentials, and extras as well.</p>\n<ul>\n<li>Zippered main compartment.</li>\n<li>Front zippered pocket.</li>\n<li>Side mesh pocket.</li>\n<li>Cell phone pocket on strap.</li>\n<li>Adjustable shoulder strap and top carry handle.</li>\n</ul>'),(3,75,0,3,'<p>The Crown Summit Backpack is equally at home in a gym locker, study cube or a pup tent, so be sure yours is packed with books, a bag lunch, water bottles, yoga block, laptop, or whatever else you want in hand. Rugged enough for day hikes and camping trips, it has two large zippered compartments and padded, adjustable shoulder straps.</p>\n<ul>\n<li>Top handle.</li>\n<li>Grommet holes.</li>\n<li>Two-way zippers.</li>\n<li>H 20\" x W 14\" x D 12\".</li>\n<li>Weight: 2 lbs, 8 oz. Volume: 29 L.</li>\n<ul>'),(4,75,0,4,'<p>Perfect for class, work or the gym, the Wayfarer Messenger Bag is packed with pockets. The dual-buckle flap closure reveals an organizational panel, and the roomy main compartment has spaces for your laptop and a change of clothes. An adjustable shoulder strap and easy-grip handle promise easy carrying.</p>\n<ul>\n<li>Multiple internal zip pockets.</li>\n<li>Made of durable nylon.</li>\n</ul>'),(5,75,0,5,'<p>The Rival Field Messenger packs all your campus, studio or trail essentials inside a unique design of soft, textured leather - with loads of character to spare. Two exterior pockets keep all your smaller items handy, and the roomy interior offers even more space.</p>\n<ul>\n<li>Leather construction.</li>\n<li>Adjustable fabric carry strap.</li>\n<li>Dimensions: 18\" x 10\" x 4\".</li>\n</ul>'),(6,75,0,6,'<p>With the Fusion Backpack strapped on, every trek is an adventure - even a bus ride to work. That\'s partly because two large zippered compartments store everything you need, while a front zippered pocket and side mesh pouches are perfect for stashing those little extras, in case you change your mind and take the day off.</p>\n<ul>\n<li>Durable nylon construction.</li>\n<li>2 main zippered compartments.</li>\n<li>1 exterior zippered pocket.</li>\n<li>Mesh side pouches.</li>\n<li>Padded, adjustable straps.</li>\n<li>Top carry handle.</li>\n<li>Dimensions: 18\" x 10\" x 6\".</li>\n</ul>'),(7,75,0,7,'<p>Good for beach trips, track meets, yoga retreats and more, the Impulse Duffle is the companion you\'ll want at your side. A large U-shaped opening makes packing a hassle-free affair, while a zippered interior pocket keeps jewelry and other small valuables safely tucked out of sight.</p>\n<ul>\n<li>Wheeled.</li>\n<li>Dual carry handles.</li>\n<li>Retractable top handle.</li>\n<li>W 14\" x H 26\" x D 11\".</li>\n</ul>'),(8,75,0,8,'<p>Everything you need for a trip to the gym will fit inside this surprisingly spacious Voyage Yoga Bag. Stock it with a water bottle, change of clothes, pair of shoes, and even a few beauty products. Fits inside a locker and zips shut for security.</p>\n<ul>\n<li>Slip pocket on front.</li>\n<li>Contrast piping.</li>\n<li>Durable nylon construction.</li>\n</ul>'),(9,75,0,9,'<p>The Compete Track Tote holds a host of exercise supplies with ease. Stash your towel, jacket and street shoes inside. Tuck water bottles in easy-access external spaces. Perfect for trips to gym or yoga studio, with dual top handles for convenience to and from.<p>\n<ul>\n<li>Two-way zippers.</li>\n<li>Contrast detailing.</li>\n<li>W 22.0\" x H 17\" x D 10\".</li>\n</ul>'),(10,75,0,10,'<p>Powerwalking to the gym or strolling to the local coffeehouse, the Savvy Shoulder Tote lets you stash your essentials in sporty style! A top-loading compartment provides quick and easy access to larger items, while zippered pockets on the front and side hold cash, credit cards and phone.</p>\n<ul>\n<li>Water-resistant shell.</li>\n<li>Water bottle pocket.</li>\n<li>Padded, articulating shoulder strap.</li>\n<li>Dimensions: W 21\" x H 15\" x D 10\".</li>\n</ul>'),(11,75,0,11,'<p>With more room than it appears, the Endeavor Daytrip Backpack will hold a whole day\'s worth of books, binders and gym clothes. The spacious main compartment includes a dedicated laptop sleeve. Two other compartments offer extra storage space.</p>\n<ul>\n<li>Foam-padded adjustable shoulder straps.</li>\n<li>900D polyester.</li>\n<li>Oversized zippers.</li>\n<li>Locker loop.</li>\n</ul>'),(12,75,0,12,'<p>School books, camp gear and yoga clothes get along just fine in the all-purpose Driven Backpack. Crafted with tough polyester ripstop fabric, it\'s outfitted with rubberized end panels and padded, adjustable shoulder straps. The roomy main compartment features molded foam pockets that host everything you need.</p>\n<ul>\n<li>Large main and small zip compartments.</li>\n<li>Adjustable, padded straps.</li>\n<li>Interior foam pockets.</li>\n<li>Exterior zip compartment.</li>\n<li>Left sport bottle pocket.</li>\n<li>Survival gear sold separately.</li>\n</ul>'),(13,75,0,13,'<p>For long weekends away, camping outings and business trips, the Overnight Duffle can\'t be beat. The dual handles make it a cinch to carry, while the durable waterproof exterior helps you worry less about the weather. With multiple organizational pockets inside and out, it\'s the perfect travel companion.</p>\n<ul>\n<li>Dual top handles.</li>\n<li>W 15\" x H 15\" x D 9\".</li>\n</ul>'),(14,75,0,14,'<p>The name says so, but the Push It Messenger Bag is much more than a busy commuter\'s tote. It\'s a closet away from home when you\'re pedaling from class or work to gym and back or home again. It\'s the perfect size and shape for laptop, folded clothes, even extra shoes.</p>\n<ul>\n<li>Adjustable crossbody strap.</li>\n<li>Top handle.</li>\n<li>Zippered interior pocket.</li>\n<li>Secure clip closures.</li>\n<li>Durable fabric construction.</li>\n</ul>'),(15,75,0,15,'<p>You\'ll stay hydrated with ease with the Affirm Water Bottle by your side or in hand. Measurements on the outside help you keep track of how much you\'re drinking, while the screw-top lid prevents spills. A metal carabiner clip allows you to attach it to the outside of a backpack or bag for easy access.</p>\n<ul>\n<li>Made of plastic.</li>\n<li>Grooved sides for an easy grip.</li>\n</ul>'),(16,75,0,16,'<p>Make the most of your limited workout window with our Dual-Handle Cardio Ball. The 15-lb ball maximizes the effort-impact to your abdominal, upper arm and lower-body muscles. It features a handle on each side for a firm, secure grip.</p>\n<ul>\n<li>Durable plastic shell with sand fill.\n<li>Two handles.\n<li>15 lbs.\n</ul>'),(17,75,0,17,'<p>One of the world\'s simplest and most portable exercise devices, a jump rope enables endless variations and fitness output. The Zing Jump Rope goes anywhere and can be used any time. It is adjustable in length and has contoured foam handles for a great grip.</p>\n<ul>\n<li> Contoured foam handles.\n<li> Adjustable length.\n</ul>'),(18,75,0,18,'<p>Save your knees and joints while strengthening arms, legs and core with the Pursuit Lumaflex&trade; Tone Band. This ultra-durable training tool lets you complete a full-body workout free of bulky machines or free weights.</p>\n<ul>\n<li>Home and/or gym use.</li>\n<li>Ergonomic handles.</li>\n</ul>'),(19,75,0,19,'<p>The Go-Get\'r Pushup Grips safely provide the extra range of motion you need for a deep-dip routine targeting core, shoulder, chest and arm strength. Do fewer pushups using more energy, getting better results faster than the standard floor-level technique yield.</p>\n<ul>\n<li>Durable foam grips.</li>\n<li>Supportive base.</li>\n</ul>'),(20,75,0,20,'<p>From leg extensions and standing squats to a full range of floor routines, the Quest Strength Band brings your own personal gym with you everywhere you go. Designed to add extra resistance to any training session, this strength band helps you tone and define your muscles. You\'ll love the extra comfort of its grippy handles and adjustable design.</p>\n<ul>\n<li>Adjusts from 30\" to 55\".\n<li>Grippy comfort handles.\n<li>Stretchy rubber construction.\n</ul>'),(21,75,0,21,'<p>Our top-selling yoga prop, the 4-inch, high-quality Sprite Foam Yoga Brick is popular among yoga novices and studio professionals alike. An essential yoga accessory, the yoga brick is a critical tool for finding balance and alignment in many common yoga poses. Choose from 5 color options.</p>\n<ul>\n<li>Standard Large Size: 4\" x 6\" x 9\".\n<li>Beveled edges for ideal contour grip.\n<li>Durable and soft, scratch-proof foam.\n<li>Individually wrapped.\n<li>Ten color choices.\n</ul> '),(22,75,0,22,'<p>It hurts so good to use the Sprite Foam Roller on achy, tired muscles for myofascial massage therapy. Or you can add this fundamental piece to your Pilates and yoga accouterment, or apply towards core stability, strengthening and balance exercise. </p>\n<ul>\n<li>6\'\' wide by 12\'\' long.</li>\n<li>Safe for myofascial release.</li>\n<li>EPP or PE foam options.</li>\n<li>Solid, dense, closed-cell foam.</li>\n</ul>'),(23,75,0,23,'<p>Forget fancy machines and costly memberships - the Harmony Lumaflex&trade; Stength Band Kit is all you need for an amazing workout. The kit has everything you need for a range of strengthening and toning exercises.</p>\n<ul>\n<li>Three flex bands.</li>\n<li>Textured, ergonomic grips.</li>\n<li>Adjustable lengths.</li>\n<li>Mesh carry bag included.</li>\n</ul>'),(24,75,0,24,'<p>The Sprite Stasis Ball gives you the toned abs, sides, and back you want by amping up your core workout. With bright colors and a burst-resistant design, it\'s a must-have for every hard-core exercise addict. Use for abdominal conditioning, balance training, yoga, or even physical therapy.</p>\n<ul>\n<li>Durable, burst-resistant design.</li>\n<li>Hand pump included.</li>\n</ul>'),(25,75,0,25,'<p>The Sprite Stasis Ball gives you the toned abs, sides, and back you want by amping up your core workout. With bright colors and a burst-resistant design, it\'s a must-have for every hard-core exercise addict. Use for abdominal conditioning, balance training, yoga, or even physical therapy.</p>\n<ul>\n<li>Durable, burst-resistant design.</li>\n<li>Hand pump included.</li>\n</ul>'),(26,75,0,26,'<p>The Sprite Stasis Ball gives you the toned abs, sides, and back you want by amping up your core workout. With bright colors and a burst-resistant design, it\'s a must-have for every hard-core exercise addict. Use for abdominal conditioning, balance training, yoga, or even physical therapy.</p>\n<ul>\n<li>Durable, burst-resistant design.</li>\n<li>Hand pump included.</li>\n</ul>'),(27,75,0,27,'<p>The Sprite Stasis Ball gives you the toned abs, sides, and back you want by amping up your core workout. With bright colors and a burst-resistant design, it\'s a must-have for every hard-core exercise addict. Use for abdominal conditioning, balance training, yoga, or even physical therapy.</p>\n<ul>\n<li>65 cm plastic shell.</li>\n<li>Durable, burst-resistant design.</li>\n<li>Hand pump included.</li>\n</ul>'),(28,75,0,28,'<p>The Sprite Stasis Ball gives you the toned abs, sides, and back you want by amping up your core workout. With bright colors and a burst-resistant design, it\'s a must-have for every hard-core exercise addict. Use for abdominal conditioning, balance training, yoga, or even physical therapy.</p>\n<ul>\n<li>65 cm plastic shell.</li>\n<li>Durable, burst-resistant design.</li>\n<li>Hand pump included.</li>\n</ul>'),(29,75,0,29,'<p>The Sprite Stasis Ball gives you the toned abs, sides, and back you want by amping up your core workout. With bright colors and a burst-resistant design, it\'s a must-have for every hard-core exercise addict. Use for abdominal conditioning, balance training, yoga, or even physical therapy.</p>\n<ul>\n<li>65 cm plastic shell.</li>\n<li>Durable, burst-resistant design.</li>\n<li>Hand pump included.</li>\n</ul>'),(30,75,0,30,'<p>The Sprite Stasis Ball gives you the toned abs, sides, and back you want by amping up your core workout. With bright colors and a burst-resistant design, it\'s a must-have for every hard-core exercise addict. Use for abdominal conditioning, balance training, yoga, or even physical therapy.</p>\n<ul>\n<li>75 cm plastic shell.</li>\n<li>Durable, burst-resistant design.</li>\n<li>Hand pump included.</li>\n</ul>'),(31,75,0,31,'<p>The Sprite Stasis Ball gives you the toned abs, sides, and back you want by amping up your core workout. With bright colors and a burst-resistant design, it\'s a must-have for every hard-core exercise addict. Use for abdominal conditioning, balance training, yoga, or even physical therapy.</p>\n<ul>\n<li>75 cm plastic shell.</li>\n<li>Durable, burst-resistant design.</li>\n<li>Hand pump included.</li>\n</ul>'),(32,75,0,32,'<p>The Sprite Stasis Ball gives you the toned abs, sides, and back you want by amping up your core workout. With bright colors and a burst-resistant design, it\'s a must-have for every hard-core exercise addict. Use for abdominal conditioning, balance training, yoga, or even physical therapy.</p>\n<ul>\n<li>75 cm plastic shell.</li>\n<li>Durable, burst-resistant design.</li>\n<li>Hand pump included.</li>\n</ul>'),(33,75,0,33,'<p>The Sprite Yoga Strap is your untiring partner in demanding stretches, holds and alignment routines. The strap\'s 100% organic cotton fabric is woven tightly to form a soft, textured yet non-slip surface. The plastic clasp buckle is easily adjustable, lightweight and durable under strain.</p>\n<ul>\n<li>100% soft and durable cotton.\n<li>Plastic cinch buckle is easy to use.\n<li>Three natural colors made from phthalate and heavy metal free dyes.\n</ul>'),(34,75,0,34,'<p>The Sprite Yoga Strap is your untiring partner in demanding stretches, holds and alignment routines. The strap\'s 100% organic cotton fabric is woven tightly to form a soft, textured yet non-slip surface. The plastic clasp buckle is easily adjustable, lightweight and durable under strain.</p>\n<ul>\n<li>8\' long x 1.0\" wide.\n<li>100% soft and durable cotton.\n<li>Plastic cinch buckle is easy to use.\n<li>Three natural colors made from phthalate and heavy metal free dyes.\n</ul>'),(35,75,0,35,'<p>The Sprite Yoga Strap is your untiring partner in demanding stretches, holds and alignment routines. The strap\'s 100% organic cotton fabric is woven tightly to form a soft, textured yet non-slip surface. The plastic clasp buckle is easily adjustable, lightweight and durable under strain.</p>\n<ul>\n<li>10\' long x 1.0\" wide.\n<li>100% soft and durable cotton.\n<li>Plastic cinch buckle is easy to use.\n<li>Three natural colors made from phthalate and heavy metal free dyes.\n</ul>'),(36,75,0,36,'<p>Stay light-years ahead of the competition with our Aim Analog Watch. The flexible, rubberized strap is contoured to conform to the shape of your wrist for a comfortable all-day fit. The face features three illuminated hands, a digital read-out of the current time, and stopwatch functions.</p>\n<ul>\n<li>Japanese quartz movement.</li>\n<li>Strap fits 7\" to 8.0\".</li>\n</ul>'),(37,75,0,37,'<p>It\'s easy to track and monitor your training progress with the Endurance Watch. You\'ll see standard info like time, date and day of the week, but it also functions for the serious high-mileage athete: lap counter, stopwatch, distance, heart rate, speed/pace, cadence and altitude.</p>\n<ul>\n<li>Digital display.</li>\n<li>LED backlight.</li>\n<li>Strap fits 7\" to 10\".</li>\n<li>1-year limited warranty.</li>\n<li>Comes with polished metal case.</li>\n</ul>'),(38,75,0,38,'<p>Trek high and low in the attractive Summit Watch, which features a digital LED display with time and date, stopwatch, lap counter, and 3-second backlight. It can also calculate the number of steps taken and calories burned.</p>\n<ul>\n<li>Brushed metal case.</li>\n<li>Water resistant (100 meters).</li>\n<li>Buckle clasp.</li>\n<li>Strap fits 7\" - 10\".</li>\n<li>1-year limited warranty.</li>\n</ul>'),(39,75,0,39,'<p>Whether you\'re traveling or wish you were, you\'ll never let time zones perplex you again with the Cruise Dual Analog Watch. The thick, adjustable band promises a comfortable, personalized fit to this classy, modern time piece.</p>\n<ul>\n<li>Two dials.</li>\n<li>Stainless steel case.</li>\n<li>Adjustable leather band.</li>\n</ul>'),(40,75,0,40,'<p>The Dash Digital Watch will challenge you to push harder and longer. Log workouts by date, average, and segment times, and recharge by setting hydration and nutrition alarms. This watch is styled with a sleek, square face and durable rubber strap for a long life.</p>\n<ul>\n<li>Digital display.</li>\n<li>LED backlight.</li>\n<li>Rubber strap with buckle clasp.</li>\n<li>1-year limited warranty.</li>'),(41,75,0,41,'<p>Designed to stand up to your active lifestyle, this women\'s Luma Analog Watch features a tasteful brushed chrome finish and a stainless steel, water-resistant construction for lasting durability.</p>\n<ul>\n<li>Precision Miyota&reg; three-hand movement.</li>\n</ul>'),(42,75,0,42,'<p>The Bolo Sport Watch is sleek, sporty and sized just right to fit your smaller wrist. Easy to read and set up, it features a large digital face and button-activated alarm and stopwatch. The soft-touch resin band promises no-pinch comfort, while the water-resistant design lets you take your workout to the lap pool.</p>\n<ul>\n<li>Displays time, day and date.</li>\n<li>Two-tone design.</li>\n<li>12/24 hour formats.</li>\n<li>Nickel-free buckle on band.</li>\n<li>Battery included.</li>\n</ul>'),(43,75,0,43,'<p>Keep track of time on the treadmill or trail with our Clamber Watch. The flexible, rubberized strap is contoured to conform to your wrist for a comfortable fit all day. The face features an illuminated digital read-out of the current time and stopwatch functions.</p>\n<ul>\n<li>Japanese quartz movement.</li>\n<li>Strap fits 5\" to 6.0\".</li>\n</ul>'),(44,75,0,44,'<p>The Didi Sport Watch helps you keep your workout plan down to the second. The vertical, digital face looks sleek and futuristic. This watch is programmed with tons of helpful features such as a timer, an alarm clock, a pedometer, and more to help make your excercise more productive.</p>\n<ul>\n<li>Digital display.</li>\n<li>LED backlight.</li>\n<li>Rubber strap with buckle clasp.</li>\n<li>1-year limited warranty.</li>\n</ul>'),(45,75,0,45,'<p>Great set of Sprite Yoga Straps for every stretch and hold you need. There are three st