<?php
/**
 * Interface of REST response renderers.
 *
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Magento\Framework\Webapi\Rest\Response;

/**
 * Renderer interface allows REST response data rendering in a specific format (e.g. Json or Xml)
 *
 * @api
 * @since 100.0.2
 */
interface RendererInterface
{
    /**
     * Render content in a certain format.
     *
     * @param object|array|int|string|bool|float|null $data
     * @return string
     */
    public function render($data);

    /**
     * Get MIME type generated by renderer.
     *
     * @return string
     */
    public function getMimeType();
}
