# How to contribute to MFTF docs

We welcome contributions to the MFTF documentation, which is kept within the `docs/` folder in this repository.
This page describes the submitting process and serves as a template for a properly written content.
The contribution workflow is the same as submitting code.

1. Create a branch from the `develop` branch in the [MFTF repository][].
1. Make edits/additions/deletions as needed. Read the [Basic Template][] for tips on how to write with Markdown.
1. Submit your pull request to the `develop` branch.

Once submitted, a member of the documentation team will review and merge it.
We will inform you if it needs any additional processing.

The documentation in this repository is used as the source for the [MFTF documentation][].
Any changes to the table of contents will need to be made through a separate pull request in the regular [Magento Developer documentation repository][].

Read more about how to [Contribute to Magento Devdocs][].

<!-- For readability, we abstract the link URLS to the bottom of the page. The extra set of square brackets denotes it is a link, rather than plain brackets. >

<!-- Link Definitions -->
[Magento Developer documentation repository]: https://github.com/magento/devdocs/blob/master/_data/toc/mftf.yml
[MFTF repository]: https://github.com/magento/magento2-functional-testing-framework
[Contribute to Magento Devdocs]: https://github.com/magento/devdocs/blob/master/.github/CONTRIBUTING.md
[MFTF documentation]: https://devdocs.magento.com/mftf/docs/introduction.html
[Basic Template]: https://devdocs.magento.com/guides/v2.3/contributor-guide/templates/basic_template.html
